# Copyright 2016 The Meson development team

# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at

#     http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import argparse
import subprocess
import os
import typing as T

parser = argparse.ArgumentParser()
parser.add_argument('input')
parser.add_argument('output')
parser.add_argument('type')
parser.add_argument('podir')
parser.add_argument('--datadirs', default='')
parser.add_argument('args', default=[], metavar='extra msgfmt argument', nargs='*')


def run(args: T.List[str]) -> int:
    options = parser.parse_args(args)
    env = None
    if options.datadirs:
        env = os.environ.copy()
        env.update({'GETTEXTDATADIRS': options.datadirs})
    return subprocess.call(['msgfmt', '--' + options.type, '-d', options.podir,
                            '--template', options.input,  '-o', options.output] + options.args,
                           env=env)
