# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class XMLDataElement(Object):
    r"""
    XMLDataElement - Represents an XML element and those nested inside.
    
    Superclass: Object
    
    XMLDataElement is used by XMLDataParser to represent an XML
    element.  It provides methods to access the element's attributes and
    nested elements in a convenient manner.  This allows easy traversal
    of an input XML file by XMLReader and its subclasses.
    
    @sa
    XMLDataParser
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkXMLDataElement, obj, update, **traits)
    
    def get_attribute(self, *args):
        """
        get_attribute(self, name:str) -> str
        C++: const char *get_attribute(const char *name)
        Get the attribute with the given name.  If it doesn't exist,
        returns 0.
        """
        ret = self._wrap_call(self._vtk_obj.GetAttribute, *args)
        return ret

    def set_attribute(self, *args):
        """
        set_attribute(self, name:str, value:str) -> None
        C++: void set_attribute(const char *name, const char *value)
        Set the attribute with the given name and value. If it doesn't
        exist, adds it.
        """
        ret = self._wrap_call(self._vtk_obj.SetAttribute, *args)
        return ret

    attribute_encoding = traits.Trait(3, traits.Range(0, 20, enter_set=True, auto_set=False), desc=\
        r"""
        Get/Set the internal character encoding of the attributes.
        Default type is VTK_ENCODING_UTF_8. Note that a XMLDataParser
        has its own attributes_encoding ivar. If this ivar is set to
        something other than VTK_ENCODING_NONE, it will be used to set
        the attribute encoding of each XMLDataElement created by this
        XMLDataParser.
        """
    )

    def _attribute_encoding_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAttributeEncoding,
                        self.attribute_encoding)

    character_data = traits.String('', enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the character data between XML start/end tags.
        """
    )

    def _character_data_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCharacterData,
                        self.character_data)

    character_data_width = traits.Int(-1, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _character_data_width_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCharacterDataWidth,
                        self.character_data_width)

    id = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        
        """
    )

    def _id_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetId,
                        self.id)

    name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        
        """
    )

    def _name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetName,
                        self.name)

    def _get_parent(self):
        return wrap_vtk(self._vtk_obj.GetParent())
    def _set_parent(self, arg):
        old_val = self._get_parent()
        self._wrap_call(self._vtk_obj.SetParent,
                        deref_vtk(arg))
        self.trait_property_changed('parent', old_val, arg)
    parent = traits.Property(_get_parent, _set_parent, desc=\
        r"""
        Set/Get the parent of this element.
        """
    )

    def get_vector_attribute(self, *args):
        """
        get_vector_attribute(self, name:str, length:int, value:[int, ...])
            -> int
        C++: int get_vector_attribute(const char *name, int length,
            int *value)
        get_vector_attribute(self, name:str, length:int, value:[float, ...])
             -> int
        C++: int get_vector_attribute(const char *name, int length,
            double *value)
        get_vector_attribute(self, name:str, length:int, value:[int, ...])
            -> int
        C++: int get_vector_attribute(const char *name, int length,
            long *value)
        get_vector_attribute(self, name:str, length:int, value:[int, ...])
            -> int
        C++: int get_vector_attribute(const char *name, int length,
            long long *value)
        Get the attribute with the given name and converted to a scalar
        value.  Returns length of vector read.
        """
        ret = self._wrap_call(self._vtk_obj.GetVectorAttribute, *args)
        return ret

    def set_vector_attribute(self, *args):
        """
        set_vector_attribute(self, name:str, length:int, value:(int, ...))
            -> None
        C++: void set_vector_attribute(const char *name, int length,
            const int *value)
        set_vector_attribute(self, name:str, length:int, value:(float, ...))
             -> None
        C++: void set_vector_attribute(const char *name, int length,
            const double *value)
        set_vector_attribute(self, name:str, length:int, value:(int, ...))
            -> None
        C++: void set_vector_attribute(const char *name, int length,
            const unsigned long *value)
        set_vector_attribute(self, name:str, length:int, value:(int, ...))
            -> None
        C++: void set_vector_attribute(const char *name, int length,
            long long const *value)
        Set the attribute with the given name.
        """
        ret = self._wrap_call(self._vtk_obj.SetVectorAttribute, *args)
        return ret

    xml_byte_index = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _xml_byte_index_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetXMLByteIndex,
                        self.xml_byte_index)

    def get_attribute_name(self, *args):
        """
        get_attribute_name(self, idx:int) -> str
        C++: const char *get_attribute_name(int idx)
        Get the n-th attribute name. Returns 0 if there is no such
        attribute.
        """
        ret = self._wrap_call(self._vtk_obj.GetAttributeName, *args)
        return ret

    def get_attribute_value(self, *args):
        """
        get_attribute_value(self, idx:int) -> str
        C++: const char *get_attribute_value(int idx)
        Get the n-th attribute value. Returns 0 if there is no such
        attribute.
        """
        ret = self._wrap_call(self._vtk_obj.GetAttributeValue, *args)
        return ret

    def get_nested_element(self, *args):
        """
        get_nested_element(self, index:int) -> XMLDataElement
        C++: XMLDataElement *get_nested_element(int index)
        Get the element nested in this one at the given index.
        """
        ret = self._wrap_call(self._vtk_obj.GetNestedElement, *args)
        return wrap_vtk(ret)

    def _get_number_of_attributes(self):
        return self._vtk_obj.GetNumberOfAttributes()
    number_of_attributes = traits.Property(_get_number_of_attributes, desc=\
        r"""
        Get the number of attributes.
        """
    )

    def _get_number_of_nested_elements(self):
        return self._vtk_obj.GetNumberOfNestedElements()
    number_of_nested_elements = traits.Property(_get_number_of_nested_elements, desc=\
        r"""
        Get the number of elements nested in this one.
        """
    )

    def _get_root(self):
        return wrap_vtk(self._vtk_obj.GetRoot())
    root = traits.Property(_get_root, desc=\
        r"""
        Get root of the XML tree this element is part of.
        """
    )

    def get_scalar_attribute(self, *args):
        """
        get_scalar_attribute(self, name:str, value:int) -> int
        C++: int get_scalar_attribute(const char *name, int &value)
        get_scalar_attribute(self, name:str, value:float) -> int
        C++: int get_scalar_attribute(const char *name, double &value)
        get_scalar_attribute(self, name:str, value:int) -> int
        C++: int get_scalar_attribute(const char *name, long &value)
        get_scalar_attribute(self, name:str, value:int) -> int
        C++: int get_scalar_attribute(const char *name, long long &value)
        Get the attribute with the given name and converted to a scalar
        value.  Returns whether value was extracted.
        """
        ret = self._wrap_call(self._vtk_obj.GetScalarAttribute, *args)
        return ret

    def get_word_type_attribute(self, *args):
        """
        get_word_type_attribute(self, name:str, value:int) -> int
        C++: int get_word_type_attribute(const char *name, int &value)
        Get the attribute with the given name and converted to a word
        type. Word types can be `VTK_TYPE_FLOAT32`, `VTK_TYPE_FLOAT64`,
        `VTK_INT8`, `VTK_UINT8`, `VTK_INT16`, `VTK_UINT16`, `VTK_INT32`,
        `VTK_UINT32`, `VTK_INT64`, `VTK_UINT64`, `VTK_STRING`, or
        `VTK_BIT`.
        """
        ret = self._wrap_call(self._vtk_obj.GetWordTypeAttribute, *args)
        return ret

    def add_character_data(self, *args):
        """
        add_character_data(self, c:str, length:int) -> None
        C++: void add_character_data(const char *c, size_t length)"""
        ret = self._wrap_call(self._vtk_obj.AddCharacterData, *args)
        return ret

    def add_nested_element(self, *args):
        """
        add_nested_element(self, element:XMLDataElement) -> None
        C++: void add_nested_element(XMLDataElement *element)
        Add nested element
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddNestedElement, *my_args)
        return ret

    def deep_copy(self, *args):
        """
        deep_copy(self, elem:XMLDataElement) -> None
        C++: virtual void deep_copy(XMLDataElement *elem)
        Copy this element from another of the same type (elem),
        recursively. Old attributes and nested elements are removed, new
        ones are created given the contents of 'elem'. Warning: Parent is
        ignored.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.DeepCopy, *my_args)
        return ret

    def find_nested_element(self, *args):
        """
        find_nested_element(self, id:str) -> XMLDataElement
        C++: XMLDataElement *find_nested_element(const char *id)
        Find the first nested element with the given id, given name, or
        given name and id. WARNING: the search is only performed on the
        children, not the grand-children.
        """
        ret = self._wrap_call(self._vtk_obj.FindNestedElement, *args)
        return wrap_vtk(ret)

    def find_nested_element_with_name(self, *args):
        """
        find_nested_element_with_name(self, name:str) -> XMLDataElement
        C++: XMLDataElement *find_nested_element_with_name(
            const char *name)"""
        ret = self._wrap_call(self._vtk_obj.FindNestedElementWithName, *args)
        return wrap_vtk(ret)

    def find_nested_element_with_name_and_attribute(self, *args):
        """
        find_nested_element_with_name_and_attribute(self, name:str,
            att_name:str, att_value:str) -> XMLDataElement
        C++: XMLDataElement *find_nested_element_with_name_and_attribute(
            const char *name, const char *att_name, const char *att_value)"""
        ret = self._wrap_call(self._vtk_obj.FindNestedElementWithNameAndAttribute, *args)
        return wrap_vtk(ret)

    def find_nested_element_with_name_and_id(self, *args):
        """
        find_nested_element_with_name_and_id(self, name:str, id:str)
            -> XMLDataElement
        C++: XMLDataElement *find_nested_element_with_name_and_id(
            const char *name, const char *id)"""
        ret = self._wrap_call(self._vtk_obj.FindNestedElementWithNameAndId, *args)
        return wrap_vtk(ret)

    def is_equal_to(self, *args):
        """
        is_equal_to(self, elem:XMLDataElement) -> int
        C++: virtual int is_equal_to(XMLDataElement *elem)
        Check if the instance has the same name, attributes, character
        data and nested elements contents than the given element (this
        method is applied recursively on the nested elements, and they
        must be stored in the same order). Warning: Id, Parent,
        XMLbyte_index are ignored.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.IsEqualTo, *my_args)
        return ret

    def lookup_element(self, *args):
        """
        lookup_element(self, id:str) -> XMLDataElement
        C++: XMLDataElement *lookup_element(const char *id)
        Lookup the element with the given id, starting at this scope.
        """
        ret = self._wrap_call(self._vtk_obj.LookupElement, *args)
        return wrap_vtk(ret)

    def lookup_element_with_name(self, *args):
        """
        lookup_element_with_name(self, name:str) -> XMLDataElement
        C++: XMLDataElement *lookup_element_with_name(const char *name)
        Find the first nested element with given name. WARNING: the
        search is performed on the whole XML tree.
        """
        ret = self._wrap_call(self._vtk_obj.LookupElementWithName, *args)
        return wrap_vtk(ret)

    def print_xml(self, *args):
        """
        print_xml(self, fname:str) -> None
        C++: void print_xml(const char *fname)"""
        ret = self._wrap_call(self._vtk_obj.PrintXML, *args)
        return ret

    def remove_all_attributes(self):
        """
        remove_all_attributes(self) -> None
        C++: virtual void remove_all_attributes()"""
        ret = self._vtk_obj.RemoveAllAttributes()
        return ret
        

    def remove_all_nested_elements(self):
        """
        remove_all_nested_elements(self) -> None
        C++: virtual void remove_all_nested_elements()
        Remove all nested elements.
        """
        ret = self._vtk_obj.RemoveAllNestedElements()
        return ret
        

    def remove_attribute(self, *args):
        """
        remove_attribute(self, name:str) -> None
        C++: virtual void remove_attribute(const char *name)
        Remove one or all attributes.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveAttribute, *args)
        return ret

    def remove_nested_element(self, *args):
        """
        remove_nested_element(self, __a:XMLDataElement) -> None
        C++: virtual void remove_nested_element(XMLDataElement *)
        Remove nested element.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.RemoveNestedElement, *my_args)
        return ret

    def set_double_attribute(self, *args):
        """
        set_double_attribute(self, name:str, value:float) -> None
        C++: void set_double_attribute(const char *name, double value)"""
        ret = self._wrap_call(self._vtk_obj.SetDoubleAttribute, *args)
        return ret

    def set_float_attribute(self, *args):
        """
        set_float_attribute(self, name:str, value:float) -> None
        C++: void set_float_attribute(const char *name, float value)"""
        ret = self._wrap_call(self._vtk_obj.SetFloatAttribute, *args)
        return ret

    def set_int_attribute(self, *args):
        """
        set_int_attribute(self, name:str, value:int) -> None
        C++: void set_int_attribute(const char *name, int value)
        Set the attribute with the given name. We can not use the same
        get_scalar_attribute() construct since the compiler will not be
        able to resolve between set_attribute(..., int) and
        set_attribute(..., unsigned long).
        """
        ret = self._wrap_call(self._vtk_obj.SetIntAttribute, *args)
        return ret

    def set_unsigned_long_attribute(self, *args):
        """
        set_unsigned_long_attribute(self, name:str, value:int) -> None
        C++: void set_unsigned_long_attribute(const char *name,
            unsigned long value)"""
        ret = self._wrap_call(self._vtk_obj.SetUnsignedLongAttribute, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('attribute_encoding',
    'GetAttributeEncoding'), ('character_data', 'GetCharacterData'),
    ('character_data_width', 'GetCharacterDataWidth'), ('id', 'GetId'),
    ('name', 'GetName'), ('xml_byte_index', 'GetXMLByteIndex'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'attribute_encoding',
    'character_data', 'character_data_width', 'id', 'name', 'object_name',
    'xml_byte_index'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(XMLDataElement, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit XMLDataElement properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['attribute_encoding', 'character_data',
            'character_data_width', 'id', 'name', 'object_name',
            'xml_byte_index']),
            title='Edit XMLDataElement properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit XMLDataElement properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

