# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class VRRay(Object):
    r"""
    VRRay - VR device model
    
    Superclass: Object
    
    * Represents a ray shooting from a VR controller, used for pointing
      or picking.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkVRRay, obj, update, **traits)
    
    show = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _show_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetShow,
                        self.show)

    def build(self, *args):
        """
        build(self, win:OpenGLRenderWindow) -> bool
        C++: bool build(OpenGLRenderWindow *win)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Build, *my_args)
        return ret

    def release_graphics_resources(self, *args):
        """
        release_graphics_resources(self, win:RenderWindow) -> None
        C++: void release_graphics_resources(RenderWindow *win)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ReleaseGraphicsResources, *my_args)
        return ret

    def render(self, *args):
        """
        render(self, win:OpenGLRenderWindow, poseMatrix:Matrix4x4)
            -> None
        C++: void render(OpenGLRenderWindow *win,
            Matrix4x4 *poseMatrix)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Render, *my_args)
        return ret

    def set_color(self, *args):
        """
        set_color(self, _arg1:float, _arg2:float, _arg3:float) -> None
        C++: virtual void set_color(float _arg1, float _arg2, float _arg3)
        set_color(self, _arg:(float, float, float)) -> None
        C++: virtual void set_color(const float _arg[3])"""
        ret = self._wrap_call(self._vtk_obj.SetColor, *args)
        return ret

    def set_length(self, *args):
        """
        set_length(self, _arg:float) -> None
        C++: virtual void set_length(float _arg)"""
        ret = self._wrap_call(self._vtk_obj.SetLength, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('show', 'GetShow'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'object_name', 'show'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(VRRay, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit VRRay properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name', 'show']),
            title='Edit VRRay properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit VRRay properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

