# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.abstract_widget import AbstractWidget


class VRMenuWidget(AbstractWidget):
    r"""
    VRMenuWidget - 3D widget to display a menu in VR
    
    Superclass: AbstractWidget
    
    @sa
    VRMenuRepresentation
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkVRMenuWidget, obj, update, **traits)
    
    def _get_representation(self):
        return wrap_vtk(self._vtk_obj.GetRepresentation())
    def _set_representation(self, arg):
        old_val = self._get_representation()
        self._wrap_call(self._vtk_obj.SetRepresentation,
                        deref_vtk(arg))
        self.trait_property_changed('representation', old_val, arg)
    representation = traits.Property(_get_representation, _set_representation, desc=\
        r"""
        Return an instance of WidgetRepresentation used to represent
        this widget in the scene. Note that the representation is a
        subclass of Prop (typically a subclass of
        WidgetRepresentation) so it can be added to the renderer
        independent of the widget.
        """
    )

    def _get_widget_state(self):
        return self._vtk_obj.GetWidgetState()
    widget_state = traits.Property(_get_widget_state, desc=\
        r"""
        Get the widget state.
        """
    )

    def push_front_menu_item(self, *args):
        """
        push_front_menu_item(self, name:str, text:str, cmd:Command)
            -> None
        C++: void push_front_menu_item(const char *name, const char *text,
            Command *cmd)
        Methods to add/remove items to the menu, called by the menu
        widget
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.PushFrontMenuItem, *my_args)
        return ret

    def remove_all_menu_items(self):
        """
        remove_all_menu_items(self) -> None
        C++: void remove_all_menu_items()"""
        ret = self._vtk_obj.RemoveAllMenuItems()
        return ret
        

    def remove_menu_item(self, *args):
        """
        remove_menu_item(self, name:str) -> None
        C++: void remove_menu_item(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.RemoveMenuItem, *args)
        return ret

    def rename_menu_item(self, *args):
        """
        rename_menu_item(self, name:str, text:str) -> None
        C++: void rename_menu_item(const char *name, const char *text)"""
        ret = self._wrap_call(self._vtk_obj.RenameMenuItem, *args)
        return ret

    def show(self, *args):
        """
        show(self, ed:EventData) -> None
        C++: void show(EventData *ed)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Show, *my_args)
        return ret

    def show_sub_menu(self, *args):
        """
        show_sub_menu(self, __a:VRMenuWidget) -> None
        C++: void show_sub_menu(VRMenuWidget *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ShowSubMenu, *my_args)
        return ret

    _updateable_traits_ = \
    (('manages_cursor', 'GetManagesCursor'), ('process_events',
    'GetProcessEvents'), ('enabled', 'GetEnabled'),
    ('key_press_activation', 'GetKeyPressActivation'), ('picking_managed',
    'GetPickingManaged'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('priority',
    'GetPriority'), ('key_press_activation_value',
    'GetKeyPressActivationValue'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'enabled', 'global_warning_display',
    'key_press_activation', 'manages_cursor', 'picking_managed',
    'process_events', 'key_press_activation_value', 'object_name',
    'priority'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(VRMenuWidget, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit VRMenuWidget properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['enabled', 'key_press_activation', 'manages_cursor',
            'picking_managed', 'process_events'], [],
            ['key_press_activation_value', 'object_name', 'priority']),
            title='Edit VRMenuWidget properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit VRMenuWidget properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

