# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.function_set import FunctionSet


class TemporalInterpolatedVelocityField(FunctionSet):
    r"""
    TemporalInterpolatedVelocityField - A helper class for
    interpolating between times during particle tracing
    
    Superclass: FunctionSet
    
    TemporalInterpolatedVelocityField is a general purpose helper for
    the temporal particle tracing code (vtkparticle_tracer_base)
    
    It maintains two copies of CompositeInterpolatedVelocityField
    internally and uses them to obtain velocity values at time T0 and T1.
    
    In fact the class does quite a bit more than this because when the
    geometry of the datasets is the same at T0 and T1, we can re-use
    cached cell Ids and weights used in the cell interpolation routines.
    Additionally, the same weights can be used when interpolating (point)
    scalar values and computing vorticity etc.
    
    @warning
    TemporalInterpolatedVelocityField is not thread safe. A new
    instance should be created by each thread.
    
    @warning
    Datasets are added in lists. The list for T1 must be identical to
    that for T0 in structure/topology and dataset order, and any datasets
    marked as static, must remain so for all T - changing a dataset from
    static to dynamic between time steps will result in undefined
    behaviour (=crash probably)
    
    @sa
    CompositeInterpolatedVelocityField ParticleTracerBase
    ParticleTracer ParticlePathFilter StreaklineFilter
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkTemporalInterpolatedVelocityField, obj, update, **traits)
    
    mesh_over_time = tvtk_base.RevPrefixMap({'different': 0, 'linear_transformation': 2, 'same_topology': 3, 'static': 1}, default_value='different', desc=\
        r"""
        
        """
    )

    def _mesh_over_time_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMeshOverTime,
                        self.mesh_over_time_)

    def get_cached_cell_ids(self, *args):
        """
        get_cached_cell_ids(self, id:[int, int], ds:[int, int]) -> bool
        C++: bool get_cached_cell_ids(IdType id[2], int ds[2])
        Between iterations of the Particle Tracer, Id's of the Cell are
        stored and then at the start of the next particle the Ids are set
        to 'pre-fill' the cache.
        """
        ret = self._wrap_call(self._vtk_obj.GetCachedCellIds, *args)
        return ret

    def set_cached_cell_ids(self, *args):
        """
        set_cached_cell_ids(self, id:[int, int], ds:[int, int]) -> None
        C++: void set_cached_cell_ids(IdType id[2], int ds[2])"""
        ret = self._wrap_call(self._vtk_obj.SetCachedCellIds, *args)
        return ret

    def _get_find_cell_strategy(self):
        return wrap_vtk(self._vtk_obj.GetFindCellStrategy())
    def _set_find_cell_strategy(self, arg):
        old_val = self._get_find_cell_strategy()
        self._wrap_call(self._vtk_obj.SetFindCellStrategy,
                        deref_vtk(arg))
        self.trait_property_changed('find_cell_strategy', old_val, arg)
    find_cell_strategy = traits.Property(_get_find_cell_strategy, _set_find_cell_strategy, desc=\
        r"""
        
        """
    )

    def _get_current_weight(self):
        return self._vtk_obj.GetCurrentWeight()
    current_weight = traits.Property(_get_current_weight, desc=\
        r"""
        Get the most recent weight between 0->1 from T1->T2. Initial
        value is 0.
        """
    )

    def _get_last_good_velocity(self):
        return self._vtk_obj.GetLastGoodVelocity()
    last_good_velocity = traits.Property(_get_last_good_velocity, desc=\
        r"""
        If an interpolation was successful, we can retrieve the last
        computed value from here. Initial value is (0.0,0.0,0.0)
        """
    )

    def add_data_set_at_time(self, *args):
        """
        add_data_set_at_time(self, N:int, T:float, dataset:DataSet) -> None
        C++: void add_data_set_at_time(int N, double T, DataSet *dataset)
        In order to use this class, two sets of data must be supplied,
        corresponding to times T1 and T2. Data is added via this
        function.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddDataSetAtTime, *my_args)
        return ret

    def advance_one_time_step(self):
        """
        advance_one_time_step(self) -> None
        C++: void advance_one_time_step()"""
        ret = self._vtk_obj.AdvanceOneTimeStep()
        return ret
        

    def clear_cache(self):
        """
        clear_cache(self) -> None
        C++: void clear_cache()
        Set the last cell id to -1 so that the next search does not start
        from the previous cell
        """
        ret = self._vtk_obj.ClearCache()
        return ret
        

    def copy_parameters(self, *args):
        """
        copy_parameters(self, from_:TemporalInterpolatedVelocityField)
            -> None
        C++: virtual void copy_parameters(
            TemporalInterpolatedVelocityField *from)
        Copy essential parameters between instances of this class. This
        generally is used to copy from instance prototype to another, or
        to copy interpolators between thread instances.  Sub-classes can
        contribute to the parameter copying process via chaining.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.CopyParameters, *my_args)
        return ret

    def function_values_at_t(self, *args):
        """
        function_values_at_t(self, T:int, x:[float, ...], u:[float, ...])
            -> int
        C++: int function_values_at_t(int T, double *x, double *u)"""
        ret = self._wrap_call(self._vtk_obj.FunctionValuesAtT, *args)
        return ret

    def initialize(self, *args):
        """
        initialize(self, t0:CompositeDataSet, t1:CompositeDataSet)
            -> None
        C++: void initialize(CompositeDataSet *t0,
            CompositeDataSet *t1)
        The Initialize() method is used to build and cache supporting
        structures (such as locators) which are used when operating on
        the interpolated velocity field. This method is needed mainly to
        deal with thread safety issues; i.e., these supporting structures
        must be built at the right time to avoid race conditions.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Initialize, *my_args)
        return ret

    def interpolate_point(self, *args):
        """
        interpolate_point(self, outPD1:PointData, outPD2:PointData,
            outIndex:int) -> bool
        C++: bool interpolate_point(PointData *outPD1,
            PointData *outPD2, IdType outIndex)
        interpolate_point(self, T:int, outPD1:PointData, outIndex:int)
            -> bool
        C++: bool interpolate_point(int T, PointData *outPD1,
            IdType outIndex)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.InterpolatePoint, *my_args)
        return ret

    def is_static(self, *args):
        """
        is_static(self, __a:int) -> bool
        C++: bool is_static(int)"""
        ret = self._wrap_call(self._vtk_obj.IsStatic, *args)
        return ret

    def quick_test_point(self, *args):
        """
        quick_test_point(self, x:[float, ...]) -> int
        C++: int quick_test_point(double *x)"""
        ret = self._wrap_call(self._vtk_obj.QuickTestPoint, *args)
        return ret

    def select_vectors(self, *args):
        """
        select_vectors(self, fieldName:str) -> None
        C++: void select_vectors(const char *fieldName)
        If you want to work with an arbitrary vector array, then set its
        name here. By default this is nullptr and the filter will use the
        active vector array.
        """
        ret = self._wrap_call(self._vtk_obj.SelectVectors, *args)
        return ret

    def set_data_set_at_time(self, *args):
        """
        set_data_set_at_time(self, __a:int, __b:int, __c:float,
            __d:DataSet, __e:bool) -> None
        C++: void set_data_set_at_time(int, int, double, DataSet *, bool)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetDataSetAtTime, *my_args)
        return ret

    def show_cache_results(self):
        """
        show_cache_results(self) -> None
        C++: void show_cache_results()"""
        ret = self._vtk_obj.ShowCacheResults()
        return ret
        

    def test_point(self, *args):
        """
        test_point(self, x:[float, ...]) -> int
        C++: int test_point(double *x)
        A utility function which evaluates the point at T1, T2 to see if
        it is inside the data at both times or only one.
        """
        ret = self._wrap_call(self._vtk_obj.TestPoint, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('mesh_over_time', 'GetMeshOverTime'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'mesh_over_time', 'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(TemporalInterpolatedVelocityField, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit TemporalInterpolatedVelocityField properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], ['mesh_over_time'], ['object_name']),
            title='Edit TemporalInterpolatedVelocityField properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit TemporalInterpolatedVelocityField properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

