# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.viewport import Viewport


class Renderer(Viewport):
    r"""
    Renderer - abstract specification for renderers
    
    Superclass: Viewport
    
    Renderer provides an abstract specification for renderers. A
    renderer is an object that controls the rendering process for
    objects. Rendering is the process of converting geometry, a
    specification for lights, and a camera view into an image.
    Renderer also performs coordinate transformation between world
    coordinates, view coordinates (the computer graphics rendering
    coordinate system), and display coordinates (the actual screen
    coordinates on the display device). Certain advanced rendering
    features such as two-sided lighting can also be controlled.
    
    @sa
    RenderWindow Actor Camera Light Volume
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkRenderer, obj, update, **traits)
    
    automatic_light_creation = tvtk_base.true_bool_trait(desc=\
        r"""
        
        """
    )

    def _automatic_light_creation_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAutomaticLightCreation,
                        self.automatic_light_creation_)

    backing_store = tvtk_base.false_bool_trait(desc=\
        r"""
        Turn on/off using backing store. This may cause the re-rendering
        time to be slightly slower when the view changes. But it is much
        faster when the image has not changed, such as during an expose
        event.
        """
    )

    def _backing_store_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBackingStore,
                        self.backing_store_)

    draw = tvtk_base.true_bool_trait(desc=\
        r"""
        When this flag is off, render commands are ignored.  It is used
        to either multiplex a RenderWindow or render only part of a
        RenderWindow. By default, Draw is on.
        """
    )

    def _draw_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDraw,
                        self.draw_)

    erase = tvtk_base.true_bool_trait(desc=\
        r"""
        When this flag is off, the renderer will not erase the background
        or the Zbuffer.  It is used to have overlapping renderers. Both
        the render_window Erase and Render Erase must be on for the camera
        to clear the renderer.  By default, Erase is on.
        """
    )

    def _erase_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetErase,
                        self.erase_)

    interactive = tvtk_base.true_bool_trait(desc=\
        r"""
        Turn on/off interactive status.  An interactive renderer is one
        that can receive events from an interactor.  Should only be set
        if there are multiple renderers in the same section of the
        viewport.
        """
    )

    def _interactive_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInteractive,
                        self.interactive_)

    light_follow_camera = tvtk_base.true_bool_trait(desc=\
        r"""
        Turn on/off the automatic repositioning of lights as the camera
        moves. If light_follow_camera is on, lights that are designated as
        Headlights or camera_lights will be adjusted to move with this
        renderer's camera. If light_follow_camera is off, the lights will
        not be adjusted.
        
        * (Note: In previous versions of vtk, this light-tracking
        * functionality was part of the interactors, not the renderer.
          For
        * backwards compatibility, the older, more limited interactor
        * behavior is enabled by default. To disable this mode, turn the
        * interactor's light_follow_camera flag OFF, and leave the
          renderer's
        * light_follow_camera flag ON.)
        """
    )

    def _light_follow_camera_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLightFollowCamera,
                        self.light_follow_camera_)

    preserve_color_buffer = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _preserve_color_buffer_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPreserveColorBuffer,
                        self.preserve_color_buffer_)

    preserve_depth_buffer = tvtk_base.false_bool_trait(desc=\
        r"""
        By default, the depth buffer is reset for each renderer. If this
        flag is true, this renderer will use the existing depth buffer
        for its rendering.
        """
    )

    def _preserve_depth_buffer_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPreserveDepthBuffer,
                        self.preserve_depth_buffer_)

    ssao_blur = tvtk_base.false_bool_trait(desc=\
        r"""
        When using SSAO, define blurring of the ambient occlusion.
        Blurring can help to improve the result if samples number is low.
        Default is false
        """
    )

    def _ssao_blur_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSSAOBlur,
                        self.ssao_blur_)

    textured_background = tvtk_base.false_bool_trait(desc=\
        r"""
        Set/Get whether this viewport should have a textured background.
        Default is off.
        """
    )

    def _textured_background_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTexturedBackground,
                        self.textured_background_)

    two_sided_lighting = tvtk_base.true_bool_trait(desc=\
        r"""
        
        """
    )

    def _two_sided_lighting_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTwoSidedLighting,
                        self.two_sided_lighting_)

    use_depth_peeling_for_volumes = tvtk_base.false_bool_trait(desc=\
        r"""
        This flag is on and the GPU supports it, depth-peel volumes along
        with the translucent geometry. Only supported on open_gl2 with
        dual-depth peeling. Default is false.
        """
    )

    def _use_depth_peeling_for_volumes_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseDepthPeelingForVolumes,
                        self.use_depth_peeling_for_volumes_)

    use_depth_peeling = tvtk_base.false_bool_trait(desc=\
        r"""
        Turn on/off rendering of translucent material with depth peeling
        technique. The render window must have alpha bits (ie call
        set_alpha_bit_planes(1)) and no multisample buffer (ie call
        set_multi_samples(0) ) to support depth peeling. If use_depth_peeling
        is on and the GPU supports it, depth peeling is used for
        rendering translucent materials. If use_depth_peeling is off, alpha
        blending is used. Initial value is off.
        """
    )

    def _use_depth_peeling_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseDepthPeeling,
                        self.use_depth_peeling_)

    use_fxaa = tvtk_base.false_bool_trait(desc=\
        r"""
        Turn on/off FXAA anti-aliasing, if supported. Initial value is
        off.
        """
    )

    def _use_fxaa_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseFXAA,
                        self.use_fxaa_)

    use_hidden_line_removal = tvtk_base.false_bool_trait(desc=\
        r"""
        If this flag is true and the rendering engine supports it,
        wireframe geometry will be drawn using hidden line removal.
        """
    )

    def _use_hidden_line_removal_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseHiddenLineRemoval,
                        self.use_hidden_line_removal_)

    use_image_based_lighting = tvtk_base.false_bool_trait(desc=\
        r"""
        If this flag is true and the rendering engine supports it, image
        based lighting is enabled and surface rendering displays
        environment reflections. The input cube map have to be set with
        set_environment_cube_map. If not cubemap is specified, this feature
        is disable.
        """
    )

    def _use_image_based_lighting_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseImageBasedLighting,
                        self.use_image_based_lighting_)

    use_ssao = tvtk_base.false_bool_trait(desc=\
        r"""
        Enable or disable Screen Space Ambient Occlusion. SSAO darkens
        some pixels to improve depth perception.
        """
    )

    def _use_ssao_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseSSAO,
                        self.use_ssao_)

    use_shadows = tvtk_base.false_bool_trait(desc=\
        r"""
        Turn on/off rendering of shadows if supported Initial value is
        off.
        """
    )

    def _use_shadows_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseShadows,
                        self.use_shadows_)

    def _get_active_camera(self):
        return wrap_vtk(self._vtk_obj.GetActiveCamera())
    def _set_active_camera(self, arg):
        old_val = self._get_active_camera()
        self._wrap_call(self._vtk_obj.SetActiveCamera,
                        deref_vtk(arg))
        self.trait_property_changed('active_camera', old_val, arg)
    active_camera = traits.Property(_get_active_camera, _set_active_camera, desc=\
        r"""
        Get the current camera. If there is not camera assigned to the
        renderer already, a new one is created automatically. This does
        *not* reset the camera.
        """
    )

    allocated_render_time = traits.Float(100.0, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the amount of time this renderer is allowed to spend
        rendering its scene. This is used by LODActor's.
        """
    )

    def _allocated_render_time_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAllocatedRenderTime,
                        self.allocated_render_time)

    ambient = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(1.0, 1.0, 1.0), cols=3, desc=\
        r"""
        Set the intensity of ambient lighting.
        """
    )

    def _ambient_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAmbient,
                        self.ambient)

    def _get_background_texture(self):
        return wrap_vtk(self._vtk_obj.GetBackgroundTexture())
    def _set_background_texture(self, arg):
        old_val = self._get_background_texture()
        self._wrap_call(self._vtk_obj.SetBackgroundTexture,
                        deref_vtk(arg))
        self.trait_property_changed('background_texture', old_val, arg)
    background_texture = traits.Property(_get_background_texture, _set_background_texture, desc=\
        r"""
        
        """
    )

    clipping_range_expansion = traits.Trait(0.5, traits.Range(0.0, 0.99, enter_set=True, auto_set=False), desc=\
        r"""
        Specify enlargement of bounds when resetting the camera clipping
        range.  By default the range is not expanded by any percent of
        the (far - near) on the near and far sides
        """
    )

    def _clipping_range_expansion_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetClippingRangeExpansion,
                        self.clipping_range_expansion)

    def _get_delegate(self):
        return wrap_vtk(self._vtk_obj.GetDelegate())
    def _set_delegate(self, arg):
        old_val = self._get_delegate()
        self._wrap_call(self._vtk_obj.SetDelegate,
                        deref_vtk(arg))
        self.trait_property_changed('delegate', old_val, arg)
    delegate = traits.Property(_get_delegate, _set_delegate, desc=\
        r"""
        
        """
    )

    environment_right = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(1.0, 0.0, 0.0), cols=3, desc=\
        r"""
        
        """
    )

    def _environment_right_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEnvironmentRight,
                        self.environment_right)

    def _get_environment_texture(self):
        return wrap_vtk(self._vtk_obj.GetEnvironmentTexture())
    def _set_environment_texture(self, arg):
        old_val = self._get_environment_texture()
        self._wrap_call(self._vtk_obj.SetEnvironmentTexture,
                        arg)
        self.trait_property_changed('environment_texture', old_val, arg)
    environment_texture = traits.Property(_get_environment_texture, _set_environment_texture, desc=\
        r"""
        Set/Get the environment texture used for image based lighting.
        This texture is supposed to represent the scene background. If it
        is not a cubemap, the texture is supposed to represent an
        equirectangular projection. If used with raytracing backends, the
        texture must be an equirectangular projection and must be
        constructed with a valid ImageData. Warning, this texture must
        be expressed in linear color space. If the texture is in sRGB
        color space, set the color flag on the texture or set the
        argument isSRGB to true.
        @sa Texture::UseSRGBColorSpaceOn
        """
    )

    environment_up = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 1.0, 0.0), cols=3, desc=\
        r"""
        
        """
    )

    def _environment_up_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEnvironmentUp,
                        self.environment_up)

    def _get_fxaa_options(self):
        return wrap_vtk(self._vtk_obj.GetFXAAOptions())
    def _set_fxaa_options(self, arg):
        old_val = self._get_fxaa_options()
        self._wrap_call(self._vtk_obj.SetFXAAOptions,
                        deref_vtk(arg))
        self.trait_property_changed('fxaa_options', old_val, arg)
    fxaa_options = traits.Property(_get_fxaa_options, _set_fxaa_options, desc=\
        r"""
        The configuration object for FXAA antialiasing.
        """
    )

    def _get_information(self):
        return wrap_vtk(self._vtk_obj.GetInformation())
    def _set_information(self, arg):
        old_val = self._get_information()
        self._wrap_call(self._vtk_obj.SetInformation,
                        deref_vtk(arg))
        self.trait_property_changed('information', old_val, arg)
    information = traits.Property(_get_information, _set_information, desc=\
        r"""
        Set/Get the information object associated with this algorithm.
        """
    )

    layer = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the layer that this renderer belongs to.  This is only
        used if there are layered renderers.
        
        * Note: Changing the layer will update the preserve_color_buffer
          setting. If
        * the layer is 0, preserve_color_buffer will be set to false,
          making the
        * bottom renderer opaque. If the layer is non-zero,
          preserve_color_buffer will
        * be set to true, giving the renderer a transparent background.
          If other
        * preserve_color_buffer configurations are desired, they must be
          adjusted after
        * the layer is set.
        """
    )

    def _layer_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLayer,
                        self.layer)

    def _get_left_background_texture(self):
        return wrap_vtk(self._vtk_obj.GetLeftBackgroundTexture())
    def _set_left_background_texture(self, arg):
        old_val = self._get_left_background_texture()
        self._wrap_call(self._vtk_obj.SetLeftBackgroundTexture,
                        deref_vtk(arg))
        self.trait_property_changed('left_background_texture', old_val, arg)
    left_background_texture = traits.Property(_get_left_background_texture, _set_left_background_texture, desc=\
        r"""
        
        """
    )

    maximum_number_of_peels = traits.Int(4, enter_set=True, auto_set=False, desc=\
        r"""
        In case of depth peeling, define the maximum number of peeling
        layers. Initial value is 4. A special value of 0 means no maximum
        limit. It has to be a positive value.
        """
    )

    def _maximum_number_of_peels_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaximumNumberOfPeels,
                        self.maximum_number_of_peels)

    near_clipping_plane_tolerance = traits.Trait(0.0, traits.Range(0.0, 0.99, enter_set=True, auto_set=False), desc=\
        r"""
        Specify tolerance for near clipping plane distance to the camera
        as a percentage of the far clipping plane distance. By default
        this will be set to 0.01 for 16 bit zbuffers and 0.001 for higher
        depth z buffers
        """
    )

    def _near_clipping_plane_tolerance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNearClippingPlaneTolerance,
                        self.near_clipping_plane_tolerance)

    occlusion_ratio = traits.Trait(0.0, traits.Range(0.0, 0.5, enter_set=True, auto_set=False), desc=\
        r"""
        In case of use of depth peeling technique for rendering
        translucent material, define the threshold under which the
        algorithm stops to iterate over peel layers. This is the ratio of
        the number of pixels that have been touched by the last layer
        over the total number of pixels of the viewport area. Initial
        value is 0.0, meaning rendering have to be exact. Greater values
        may speed-up the rendering with small impact on the quality.
        """
    )

    def _occlusion_ratio_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOcclusionRatio,
                        self.occlusion_ratio)

    def _get_pass_(self):
        return wrap_vtk(self._vtk_obj.GetPass())
    def _set_pass_(self, arg):
        old_val = self._get_pass_()
        self._wrap_call(self._vtk_obj.SetPass,
                        deref_vtk(arg))
        self.trait_property_changed('pass_', old_val, arg)
    pass_ = traits.Property(_get_pass_, _set_pass_, desc=\
        r"""
        
        """
    )

    def _get_render_window(self):
        return wrap_vtk(self._vtk_obj.GetRenderWindow())
    def _set_render_window(self, arg):
        old_val = self._get_render_window()
        self._wrap_call(self._vtk_obj.SetRenderWindow,
                        deref_vtk(arg))
        self.trait_property_changed('render_window', old_val, arg)
    render_window = traits.Property(_get_render_window, _set_render_window, desc=\
        r"""
        
        """
    )

    def _get_right_background_texture(self):
        return wrap_vtk(self._vtk_obj.GetRightBackgroundTexture())
    def _set_right_background_texture(self, arg):
        old_val = self._get_right_background_texture()
        self._wrap_call(self._vtk_obj.SetRightBackgroundTexture,
                        deref_vtk(arg))
        self.trait_property_changed('right_background_texture', old_val, arg)
    right_background_texture = traits.Property(_get_right_background_texture, _set_right_background_texture, desc=\
        r"""
        
        """
    )

    ssao_bias = traits.Float(0.01, enter_set=True, auto_set=False, desc=\
        r"""
        When using SSAO, define the bias when comparing samples. Default
        is 0.01
        """
    )

    def _ssao_bias_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSSAOBias,
                        self.ssao_bias)

    ssao_kernel_size = traits.Int(32, enter_set=True, auto_set=False, desc=\
        r"""
        When using SSAO, define the number of samples. Default is 32
        """
    )

    def _ssao_kernel_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSSAOKernelSize,
                        self.ssao_kernel_size)

    ssao_radius = traits.Float(0.5, enter_set=True, auto_set=False, desc=\
        r"""
        When using SSAO, define the SSAO hemisphere radius. Default is
        0.5
        """
    )

    def _ssao_radius_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSSAORadius,
                        self.ssao_radius)

    def _get_actors(self):
        return wrap_vtk(self._vtk_obj.GetActors())
    actors = traits.Property(_get_actors, desc=\
        r"""
        Return any actors in this renderer.
        """
    )

    def _get_cullers(self):
        return wrap_vtk(self._vtk_obj.GetCullers())
    cullers = traits.Property(_get_cullers, desc=\
        r"""
        Return the collection of cullers.
        """
    )

    def _get_last_render_time_in_seconds(self):
        return self._vtk_obj.GetLastRenderTimeInSeconds()
    last_render_time_in_seconds = traits.Property(_get_last_render_time_in_seconds, desc=\
        r"""
        Get the time required, in seconds, for the last Render call.
        """
    )

    def _get_last_rendering_used_depth_peeling(self):
        return self._vtk_obj.GetLastRenderingUsedDepthPeeling()
    last_rendering_used_depth_peeling = traits.Property(_get_last_rendering_used_depth_peeling, desc=\
        r"""
        Tells if the last call to
        device_render_translucent_polygonal_geometry() actually used depth
        peeling. Initial value is false.
        """
    )

    def _get_lights(self):
        return wrap_vtk(self._vtk_obj.GetLights())
    lights = traits.Property(_get_lights, desc=\
        r"""
        Return the collection of lights.
        """
    )

    def _get_number_of_props_rendered(self):
        return self._vtk_obj.GetNumberOfPropsRendered()
    number_of_props_rendered = traits.Property(_get_number_of_props_rendered, desc=\
        r"""
        Should be used internally only during a render Get the number of
        props that were rendered using a render_opaque_geometry or
        render_translucent_polygonal_geometry call. This is used to know if
        something is in the frame buffer.
        """
    )

    def _get_selector(self):
        return wrap_vtk(self._vtk_obj.GetSelector())
    selector = traits.Property(_get_selector, desc=\
        r"""
        Get the current hardware selector. If the Selector is set, it
        implies the current render pass is for selection.
        Mappers/Properties may choose to behave differently when
        rendering for hardware selection.
        """
    )

    def _get_tiled_aspect_ratio(self):
        return self._vtk_obj.GetTiledAspectRatio()
    tiled_aspect_ratio = traits.Property(_get_tiled_aspect_ratio, desc=\
        r"""
        Compute the aspect ratio of this renderer for the current tile.
        When tiled displays are used the aspect ratio of the renderer for
        a given tile may be different that the aspect ratio of the
        renderer when rendered in it entirety
        """
    )

    def _get_time_factor(self):
        return self._vtk_obj.GetTimeFactor()
    time_factor = traits.Property(_get_time_factor, desc=\
        r"""
        Get the ratio between allocated time and actual render time.
        time_factor has been taken out of the render process. It is still
        computed in case someone finds it useful. It may be taken away in
        the future.
        """
    )

    def _get_volumes(self):
        return wrap_vtk(self._vtk_obj.GetVolumes())
    volumes = traits.Property(_get_volumes, desc=\
        r"""
        Return the collection of volumes.
        """
    )

    def get_z(self, *args):
        """
        get_z(self, x:int, y:int) -> float
        C++: double get_z(int x, int y)
        Given a pixel location, return the Z value. The z value is
        normalized (0,1) between the front and back clipping planes.
        """
        ret = self._wrap_call(self._vtk_obj.GetZ, *args)
        return ret

    def add_actor(self, *args):
        """
        add_actor(self, p:Prop) -> None
        C++: void add_actor(Prop *p)
        Add/Remove different types of props to the renderer. These
        methods are all synonyms to add_view_prop and remove_view_prop. They
        are here for convenience and backwards compatibility.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddActor, *my_args)
        return ret

    def add_culler(self, *args):
        """
        add_culler(self, __a:Culler) -> None
        C++: void add_culler(Culler *)
        Add an culler to the list of cullers.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddCuller, *my_args)
        return ret

    def add_light(self, *args):
        """
        add_light(self, __a:Light) -> None
        C++: void add_light(Light *)
        Add a light to the list of lights.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddLight, *my_args)
        return ret

    def add_volume(self, *args):
        """
        add_volume(self, p:Prop) -> None
        C++: void add_volume(Prop *p)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddVolume, *my_args)
        return ret

    def capture_gl2ps_special_prop(self, *args):
        """
        capture_gl2ps_special_prop(self, __a:Prop) -> int
        C++: int capture_gl2ps_special_prop(Prop *)
        This function is called to capture an instance of Prop that
        requires special handling during
        RenderWindow::CaptureGL2PSSpecialProps().
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.CaptureGL2PSSpecialProp, *my_args)
        return ret

    def clear(self):
        """
        clear(self) -> None
        C++: virtual void clear()
        Clear the image to the background color.
        """
        ret = self._vtk_obj.Clear()
        return ret
        

    def clear_lights(self):
        """
        clear_lights(self) -> None
        C++: virtual void clear_lights(void)
        Internal method temporarily removes lights before reloading them
        into graphics pipeline.
        """
        ret = self._vtk_obj.ClearLights()
        return ret
        

    def compute_visible_prop_bounds(self, *args):
        """
        compute_visible_prop_bounds(self, bounds:[float, float, float, float,
             float, float]) -> None
        C++: void compute_visible_prop_bounds(double bounds[6])
        compute_visible_prop_bounds(self) -> (float, float, float, float,
            float, float)
        C++: double *compute_visible_prop_bounds()
        Compute the bounding box of all the visible props Used in
        reset_camera() and reset_camera_clipping_range()
        """
        ret = self._wrap_call(self._vtk_obj.ComputeVisiblePropBounds, *args)
        return ret

    def create_light(self):
        """
        create_light(self) -> None
        C++: void create_light(void)
        Create and add a light to renderer.
        """
        ret = self._vtk_obj.CreateLight()
        return ret
        

    def device_render(self):
        """
        device_render(self) -> None
        C++: virtual void device_render()
        Create an image. Subclasses of Renderer must implement this
        method.
        """
        ret = self._vtk_obj.DeviceRender()
        return ret
        

    def device_render_opaque_geometry(self, *args):
        """
        device_render_opaque_geometry(self, fbo:FrameBufferObjectBase=...)
             -> None
        C++: virtual void device_render_opaque_geometry(
            FrameBufferObjectBase *fbo=nullptr)
        Render opaque polygonal geometry. Default implementation just
        calls update_opaque_polygonal_geometry(). Subclasses of Renderer
        that can deal with, e.g. hidden line removal must override this
        method.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.DeviceRenderOpaqueGeometry, *my_args)
        return ret

    def device_render_translucent_polygonal_geometry(self, *args):
        """
        device_render_translucent_polygonal_geometry(self,
            fbo:FrameBufferObjectBase=...) -> None
        C++: virtual void device_render_translucent_polygonal_geometry(
            FrameBufferObjectBase *fbo=nullptr)
        Render translucent polygonal geometry. Default implementation
        just call update_translucent_polygonal_geometry(). Subclasses of
        Renderer that can deal with depth peeling must override this
        method. If use_depth_peeling and use_depth_peeling_for_volumes are
        true, volumetric data will be rendered here as well. It updates
        boolean ivar last_rendering_used_depth_peeling.
        """
        ret = self._wrap_call(self._vtk_obj.DeviceRenderTranslucentPolygonalGeometry, *args)
        return ret

    def is_active_camera_created(self):
        """
        is_active_camera_created(self) -> int
        C++: TypeBool is_active_camera_created()
        This method returns 1 if the active_camera has already been set or
        automatically created by the renderer. It returns 0 if the
        active_camera does not yet exist.
        """
        ret = self._vtk_obj.IsActiveCameraCreated()
        return ret
        

    def make_camera(self):
        """
        make_camera(self) -> Camera
        C++: virtual Camera *make_camera()
        Create a new Camera sutible for use with this type of Renderer.
        For example, a MesaRenderer should create a MesaCamera in
        this function.   The default is to just call Camera::New.
        """
        ret = wrap_vtk(self._vtk_obj.MakeCamera())
        return ret
        

    def make_light(self):
        """
        make_light(self) -> Light
        C++: virtual Light *make_light()
        Create a new Light sutible for use with this type of Renderer.
        For example, a MesaRenderer should create a MesaLight in
        this function.   The default is to just call Light::New.
        """
        ret = wrap_vtk(self._vtk_obj.MakeLight())
        return ret
        

    def release_graphics_resources(self, *args):
        """
        release_graphics_resources(self, __a:Window) -> None
        C++: virtual void release_graphics_resources(Window *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ReleaseGraphicsResources, *my_args)
        return ret

    def remove_actor(self, *args):
        """
        remove_actor(self, p:Prop) -> None
        C++: void remove_actor(Prop *p)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.RemoveActor, *my_args)
        return ret

    def remove_all_lights(self):
        """
        remove_all_lights(self) -> None
        C++: void remove_all_lights()
        Remove all lights from the list of lights.
        """
        ret = self._vtk_obj.RemoveAllLights()
        return ret
        

    def remove_culler(self, *args):
        """
        remove_culler(self, __a:Culler) -> None
        C++: void remove_culler(Culler *)
        Remove an actor from the list of cullers.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.RemoveCuller, *my_args)
        return ret

    def remove_light(self, *args):
        """
        remove_light(self, __a:Light) -> None
        C++: void remove_light(Light *)
        Remove a light from the list of lights.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.RemoveLight, *my_args)
        return ret

    def remove_volume(self, *args):
        """
        remove_volume(self, p:Prop) -> None
        C++: void remove_volume(Prop *p)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.RemoveVolume, *my_args)
        return ret

    def render(self):
        """
        render(self) -> None
        C++: virtual void render()
        CALLED BY RenderWindow ONLY. End-user pass your way and call
        RenderWindow::Render(). Create an image. This is a superclass
        method which will in turn call the device_render method of
        Subclasses of Renderer.
        """
        ret = self._vtk_obj.Render()
        return ret
        

    def reset_camera(self, *args):
        """
        reset_camera(self) -> None
        C++: virtual void reset_camera()
        reset_camera(self, bounds:(float, float, float, float, float,
            float)) -> None
        C++: virtual void reset_camera(const double bounds[6])
        reset_camera(self, xmin:float, xmax:float, ymin:float, ymax:float,
            zmin:float, zmax:float) -> None
        C++: virtual void reset_camera(double xmin, double xmax,
            double ymin, double ymax, double zmin, double zmax)
        Automatically set up the camera based on the visible actors. The
        camera will reposition itself to view the center point of the
        actors, and move along its initial view plane normal (i.e.,
        vector defined from camera position to focal point) so that all
        of the actors can be seen.
        """
        ret = self._wrap_call(self._vtk_obj.ResetCamera, *args)
        return ret

    def reset_camera_clipping_range(self, *args):
        """
        reset_camera_clipping_range(self) -> None
        C++: virtual void reset_camera_clipping_range()
        reset_camera_clipping_range(self, bounds:(float, float, float, float,
             float, float)) -> None
        C++: virtual void reset_camera_clipping_range(const double bounds[6])
        reset_camera_clipping_range(self, xmin:float, xmax:float, ymin:float,
             ymax:float, zmin:float, zmax:float) -> None
        C++: virtual void reset_camera_clipping_range(double xmin,
            double xmax, double ymin, double ymax, double zmin,
            double zmax)
        Reset the camera clipping range based on the bounds of the
        visible actors. This ensures that no props are cut off
        """
        ret = self._wrap_call(self._vtk_obj.ResetCameraClippingRange, *args)
        return ret

    def reset_camera_screen_space(self, *args):
        """
        reset_camera_screen_space(self) -> None
        C++: virtual void reset_camera_screen_space()
        reset_camera_screen_space(self, bounds:(float, float, float, float,
            float, float)) -> None
        C++: virtual void reset_camera_screen_space(const double bounds[6])
        reset_camera_screen_space(self, xmin:float, xmax:float, ymin:float,
            ymax:float, zmin:float, zmax:float) -> None
        C++: virtual void reset_camera_screen_space(double xmin, double xmax,
             double ymin, double ymax, double zmin, double zmax)
        Automatically set up the camera based on the visible actors. Use
        a screen space bounding box to zoom closer to the data.
        """
        ret = self._wrap_call(self._vtk_obj.ResetCameraScreenSpace, *args)
        return ret

    def set_gl2ps_special_prop_collection(self, *args):
        """
        set_gl2ps_special_prop_collection(self, __a:PropCollection) -> None
        C++: void set_gl2ps_special_prop_collection(PropCollection *)
        Set the prop collection object used during
        RenderWindow::CaptureGL2PSSpecialProps(). Do not call
        manually, this is handled automatically by the render window.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetGL2PSSpecialPropCollection, *my_args)
        return ret

    def set_light_collection(self, *args):
        """
        set_light_collection(self, lights:LightCollection) -> None
        C++: void set_light_collection(LightCollection *lights)
        Set the collection of lights. We cannot name it set_lights because
        of test_set_get
        \\pre lights_exist: lights!=0
        \\post lights_set: lights==this->get_lights()
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetLightCollection, *my_args)
        return ret

    def stereo_midpoint(self):
        """
        stereo_midpoint(self) -> None
        C++: virtual void stereo_midpoint()
        Do anything necessary between rendering the left and right
        viewpoints in a stereo render. Doesn't do anything except in the
        derived IceTRenderer in para_view.
        """
        ret = self._vtk_obj.StereoMidpoint()
        return ret
        

    def transparent(self):
        """
        transparent(self) -> int
        C++: int transparent()
        Returns a boolean indicating if this renderer is transparent.  It
        is transparent if it is not in the deepest layer of its render
        window.
        """
        ret = self._vtk_obj.Transparent()
        return ret
        

    def update_lights_geometry_to_follow_camera(self):
        """
        update_lights_geometry_to_follow_camera(self) -> int
        C++: virtual TypeBool update_lights_geometry_to_follow_camera(void)
        Ask the lights in the scene that are not in world space (for
        instance, Headlights or camera_lights that are attached to the
        camera) to update their geometry to match the active camera.
        """
        ret = self._vtk_obj.UpdateLightsGeometryToFollowCamera()
        return ret
        

    def visible_actor_count(self):
        """
        visible_actor_count(self) -> int
        C++: int visible_actor_count()
        Returns the number of visible actors.
        """
        ret = self._vtk_obj.VisibleActorCount()
        return ret
        

    def visible_volume_count(self):
        """
        visible_volume_count(self) -> int
        C++: int visible_volume_count()
        Returns the number of visible volumes.
        """
        ret = self._vtk_obj.VisibleVolumeCount()
        return ret
        

    def zoom_to_box_using_view_angle(self, *args):
        """
        zoom_to_box_using_view_angle(self, box:Recti, offsetRatio:float=1.0)
             -> None
        C++: void zoom_to_box_using_view_angle(const Recti &box,
            const double offsetRatio=1.0)
        Automatically set up the camera focal point and zoom factor to
        observe the box in display coordinates.offset_ratio can be used to
        add a zoom offset.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ZoomToBoxUsingViewAngle, *my_args)
        return ret

    _updateable_traits_ = \
    (('automatic_light_creation', 'GetAutomaticLightCreation'),
    ('backing_store', 'GetBackingStore'), ('draw', 'GetDraw'), ('erase',
    'GetErase'), ('interactive', 'GetInteractive'),
    ('light_follow_camera', 'GetLightFollowCamera'),
    ('preserve_color_buffer', 'GetPreserveColorBuffer'),
    ('preserve_depth_buffer', 'GetPreserveDepthBuffer'), ('ssao_blur',
    'GetSSAOBlur'), ('textured_background', 'GetTexturedBackground'),
    ('two_sided_lighting', 'GetTwoSidedLighting'),
    ('use_depth_peeling_for_volumes', 'GetUseDepthPeelingForVolumes'),
    ('use_depth_peeling', 'GetUseDepthPeeling'), ('use_fxaa',
    'GetUseFXAA'), ('use_hidden_line_removal', 'GetUseHiddenLineRemoval'),
    ('use_image_based_lighting', 'GetUseImageBasedLighting'), ('use_ssao',
    'GetUseSSAO'), ('use_shadows', 'GetUseShadows'),
    ('gradient_background', 'GetGradientBackground'),
    ('gradient_environmental_bg', 'GetGradientEnvironmentalBG'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('allocated_render_time', 'GetAllocatedRenderTime'), ('ambient',
    'GetAmbient'), ('clipping_range_expansion',
    'GetClippingRangeExpansion'), ('environment_right',
    'GetEnvironmentRight'), ('environment_up', 'GetEnvironmentUp'),
    ('layer', 'GetLayer'), ('maximum_number_of_peels',
    'GetMaximumNumberOfPeels'), ('near_clipping_plane_tolerance',
    'GetNearClippingPlaneTolerance'), ('occlusion_ratio',
    'GetOcclusionRatio'), ('ssao_bias', 'GetSSAOBias'),
    ('ssao_kernel_size', 'GetSSAOKernelSize'), ('ssao_radius',
    'GetSSAORadius'), ('aspect', 'GetAspect'), ('background',
    'GetBackground'), ('background2', 'GetBackground2'),
    ('background_alpha', 'GetBackgroundAlpha'), ('display_point',
    'GetDisplayPoint'), ('environmental_bg', 'GetEnvironmentalBG'),
    ('environmental_bg2', 'GetEnvironmentalBG2'), ('pixel_aspect',
    'GetPixelAspect'), ('view_point', 'GetViewPoint'), ('viewport',
    'GetViewport'), ('world_point', 'GetWorldPoint'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['automatic_light_creation', 'backing_store', 'debug', 'draw',
    'erase', 'global_warning_display', 'gradient_background',
    'gradient_environmental_bg', 'interactive', 'light_follow_camera',
    'preserve_color_buffer', 'preserve_depth_buffer', 'ssao_blur',
    'textured_background', 'two_sided_lighting', 'use_depth_peeling',
    'use_depth_peeling_for_volumes', 'use_fxaa',
    'use_hidden_line_removal', 'use_image_based_lighting', 'use_shadows',
    'use_ssao', 'allocated_render_time', 'ambient', 'aspect',
    'background', 'background2', 'background_alpha',
    'clipping_range_expansion', 'display_point', 'environment_right',
    'environment_up', 'environmental_bg', 'environmental_bg2', 'layer',
    'maximum_number_of_peels', 'near_clipping_plane_tolerance',
    'object_name', 'occlusion_ratio', 'pixel_aspect', 'ssao_bias',
    'ssao_kernel_size', 'ssao_radius', 'view_point', 'viewport',
    'world_point'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Renderer, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Renderer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['automatic_light_creation', 'backing_store', 'draw', 'erase',
            'gradient_background', 'gradient_environmental_bg', 'interactive',
            'light_follow_camera', 'preserve_color_buffer',
            'preserve_depth_buffer', 'ssao_blur', 'textured_background',
            'two_sided_lighting', 'use_depth_peeling',
            'use_depth_peeling_for_volumes', 'use_fxaa',
            'use_hidden_line_removal', 'use_image_based_lighting', 'use_shadows',
            'use_ssao'], [], ['allocated_render_time', 'ambient', 'aspect',
            'background', 'background2', 'background_alpha',
            'clipping_range_expansion', 'display_point', 'environment_right',
            'environment_up', 'environmental_bg', 'environmental_bg2', 'layer',
            'maximum_number_of_peels', 'near_clipping_plane_tolerance',
            'object_name', 'occlusion_ratio', 'pixel_aspect', 'ssao_bias',
            'ssao_kernel_size', 'ssao_radius', 'view_point', 'viewport',
            'world_point']),
            title='Edit Renderer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Renderer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

