# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_set_algorithm import DataSetAlgorithm


class ExtractCellsByType(DataSetAlgorithm):
    r"""
    ExtractCellsByType - extract cells of a specified type
    
    Superclass: DataSetAlgorithm
    
    Given an input DataSet and a list of cell types, produce an output
    dataset containing only cells of the specified type(s). Note that if
    the input dataset is homogeneous (e.g., all cells are of the same
    type) and the cell type is one of the cells specified, then the input
    dataset is shallow copied to the output.
    
    The type of output dataset is always the same as the input type.
    Since structured types of data (i.e., ImageData,
    StructuredGrid, RectilnearGrid, UniformGrid) are all
    composed of a cell of the same type, the output is either empty, or a
    shallow copy of the input. Unstructured data (vtkunstructured_grid,
    PolyData) input may produce a subset of the input data (depending
    on the selected cell types).
    
    Note this filter can be used in a pipeline with composite datasets to
    extract blocks of (a) particular cell type(s).
    
    @warning
    Unlike the filter ExtractCells which always produces
    UnstructuredGrid output, this filter produces the same output type
    as input type (i.e., it is a DataSetAlgorithm). Also,
    ExtractCells extracts cells based on their ids.
    
    * @sa
    * ExtractBlock ExtractCells
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkExtractCellsByType, obj, update, **traits)
    
    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        r"""
        Get the input data object. This method is not recommended for
        use, but lots of old style filters use it.
        """
    )

    def add_all_cell_types(self):
        """
        add_all_cell_types(self) -> None
        C++: void add_all_cell_types()"""
        ret = self._vtk_obj.AddAllCellTypes()
        return ret
        

    def add_cell_type(self, *args):
        """
        add_cell_type(self, type:int) -> None
        C++: void add_cell_type(unsigned int type)
        Specify the cell types to extract. Any cells of the type
        specified are extracted. Methods for clearing the set of cells,
        adding all cells, and determining if a cell is in the set are
        also provided.
        """
        ret = self._wrap_call(self._vtk_obj.AddCellType, *args)
        return ret

    def extract_cell_type(self, *args):
        """
        extract_cell_type(self, type:int) -> bool
        C++: bool extract_cell_type(unsigned int type)"""
        ret = self._wrap_call(self._vtk_obj.ExtractCellType, *args)
        return ret

    def remove_all_cell_types(self):
        """
        remove_all_cell_types(self) -> None
        C++: void remove_all_cell_types()"""
        ret = self._vtk_obj.RemoveAllCellTypes()
        return ret
        

    def remove_cell_type(self, *args):
        """
        remove_cell_type(self, type:int) -> None
        C++: void remove_cell_type(unsigned int type)"""
        ret = self._wrap_call(self._vtk_obj.RemoveCellType, *args)
        return ret

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('progress_text', 'GetProgressText'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'object_name', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ExtractCellsByType, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ExtractCellsByType properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name']),
            title='Edit ExtractCellsByType properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ExtractCellsByType properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

