# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.statistics_algorithm import StatisticsAlgorithm


class DescriptiveStatistics(StatisticsAlgorithm):
    r"""
    DescriptiveStatistics - A class for univariate descriptive
    statistics
    
    Superclass: StatisticsAlgorithm
    
    Given a selection of columns of interest in an input data table, this
    class provides the following functionalities, depending on the chosen
    execution options:
    * Learn: calculate extremal values, sample mean, and M2, M3, and M4
      aggregates (cf. P. Pebay, Formulas for robust, one-pass parallel
      computation of covariances and Arbitrary-Order Statistical Moments,
    Sandia Report SAND2008-6212, Sep 2008,
      http://infoserve.sandia.gov/sand_doc/2008/086212.pdf for details)
    * Derive: calculate unbiased variance estimator, standard deviation
      estimator, two skewness estimators, and two kurtosis excess
      estimators.
    * Assess: given an input data set, a reference value and a
      non-negative deviation, mark each datum with corresponding relative
    deviation (1-dimensional Mahlanobis distance). If the deviation is
      zero, then mark each datum which are equal to the reference value
      with 0, and all others with 1. By default, the reference value and
      the deviation are, respectively, the mean and the standard
      deviation of the input model.
    * Test: calculate Jarque-Bera statistic and, if VTK to R interface is
    available, retrieve corresponding p-value for normality testing.
    
    Among the derived statistics, the variance, the standard deviation,
    the skewness and the kurtosis can be estimated in two ways: using the
    sample version of those statistics, or the population version.
    Specify whether a sample estimate or population estimate is done by
    setting `sample_estimate`. By default, `sample_estimate == true`, hence
    the sample version of the statistics is estimated, which produces
    unbiased estimators (except for the sample standard deviation). The
    sample estimate should be used for input that represent a subset of
    the whole population of study. On the other hand, when
    `sample_estimate == false`, the population version of the statistics
    is estimated. If the input doesn't contain all the samples from the
    population of study, then a bias is induced (the variance is slightly
    bigger than it should be). One can read about Bessel's correction to
    understand better where this comes from. That being said, on very
    large data, the difference between the 2 estimation formulas becomes
    very low, so in those instances, either state of `sample_estimate`
    should yield very similar results (see explicit formulas below).
    
    
    
     The formulas used are as follows, writing \f( \bar{X} \f) the mean of \f( X \f) and \f( N \f)
     the number of samples:
     - Sample estimate:
       \f[
        Var{X} = s^2 = \frac{\sum_{k=1}^N \left(x_k - \bar{x}\right)^2 }{N - 1}
       \f]
       \f[
        Skew{X} = \frac{n}{(n - 1)(n - 2)}
        \frac{\sum_{k=1}^N \left(x_k - \bar{x}\right)^3 }{s^3}
       \f]
       \f[
        Kurt{X} = \frac{n(n + 1)}{(n - 1)(n - 2)(n - 3)}
        \frac{\sum_{k=1}^N \left(x_k - \bar{x}\right)^3 }{s^4}
        - 3 \frac{(n - 1)^2}{(n - 2)(n - 3)}
       \f]
     - Population estimate:
       \f[
        Var{X} = \sigma^2 = \frac{\sum_{k=1}^N \left(x_k - \bar{x}\right)^2 }{N}
       \f]
       \f[
        Skew{X} = \frac{1}{N}\frac{\sum_{k=1}^N \left(x_k - \bar{x}\right)^3 }{\sigma^3}
       \f]
       \f[
        Kurt{X} = \frac{1}{N}\frac{\sum_{k=1}^N \left(x_k - \bar{x}\right)^3 }{\sigma^4} - 3
       \f]
    
     \f(\sigma\f) is the population standard deviation, and \f(s\f) is the sample standard deviation.
     Note that the kurtosis is corrected so the kurtosis of a gaussian distribution should yield 0.
    
     In the instance where \f(\sigma = 0\f) or \f(s = 0\f), the skewness and kurtosis are undefined.
     Thus they output a `NaN`. Similarly, if there are no samples, then all derived statistics
     yield a `NaN`.
    
     
    
    @par Thanks: Thanks to Philippe Pebay and David Thompson from Sandia
    National Laboratories for implementing this class. Updated by
    Philippe Pebay, Kitware SAS 2012
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkDescriptiveStatistics, obj, update, **traits)
    
    g1_skewness = tvtk_base.true_bool_trait(desc=\
        r"""
        @warning THIS METHOD DOES NOTHING AND IS DEPRECATED.
        
        Skewness estimator is picked depending on the state of
        `sample_estimate`.
        """
    )

    def _g1_skewness_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetG1Skewness,
                        self.g1_skewness_)

    g2_kurtosis = tvtk_base.true_bool_trait(desc=\
        r"""
        @warning THIS METHOD DOES NOTHING AND IS DEPRECATED.
        
        Kurtosis estimator is picked depending on the state of
        `sample_estimate`.
        """
    )

    def _g2_kurtosis_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetG2Kurtosis,
                        self.g2_kurtosis_)

    sample_estimate = tvtk_base.true_bool_trait(desc=\
        r"""
        Getter / Setter on `sample_estimate`. When turned on, descriptive
        statistics computed by this filter assume that the input data
        only holds a sample of the whole population of study. In effect,
        the sample variance, the sample standard deviation, the sample
        skewness and the sample kurtosis are estimated. When turned off,
        the population variance, the population standard deviation, the
        population skewness and the population kurtosis are estimated
        instead.
        
        In short, if the input data is a full description of the
        population being studied, `sample_estimate` should be turned off.
        If the input data is a sample of the population being studied,
        then `sample_estimate` should be turned on. By default,
        `sample_estimate` is turned on, as it is the most likely case.
        
        Please see class description for a full description of the
        formulas.
        
        ote For large data, the difference between the population
        estimate and the sample estimate becomes thin, so this parameter
        becomes of less worry.
        """
    )

    def _sample_estimate_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSampleEstimate,
                        self.sample_estimate_)

    signed_deviations = tvtk_base.false_bool_trait(desc=\
        r"""
        Set/get whether the deviations returned should be signed, or
        should only have their magnitude reported. The default is that
        signed deviations will be computed.
        """
    )

    def _signed_deviations_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSignedDeviations,
                        self.signed_deviations_)

    unbiased_variance = tvtk_base.true_bool_trait(desc=\
        r"""
        @warning THIS METHOD DOES NOTHING AND IS DEPRECATED.
        
        To compute an unbiased variance, please set `sample_estimate`
        instead. When set to true, the sample variance is computed, which
        is unbiased.
        """
    )

    def _unbiased_variance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUnbiasedVariance,
                        self.unbiased_variance_)

    ghosts_to_skip = traits.Int(255, enter_set=True, auto_set=False, desc=\
        r"""
        If there is a ghost array in the input, then ghosts matching
        `ghosts_to_skip` mask will be skipped. It is set to 0xff by default
        (every ghosts types are skipped).
        
        @sa
        DataSetAttributes FieldData PointData CellData
        """
    )

    def _ghosts_to_skip_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGhostsToSkip,
                        self.ghosts_to_skip)

    _updateable_traits_ = \
    (('g1_skewness', 'GetG1Skewness'), ('g2_kurtosis', 'GetG2Kurtosis'),
    ('sample_estimate', 'GetSampleEstimate'), ('signed_deviations',
    'GetSignedDeviations'), ('unbiased_variance', 'GetUnbiasedVariance'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('ghosts_to_skip', 'GetGhostsToSkip'), ('assess_option',
    'GetAssessOption'), ('derive_option', 'GetDeriveOption'),
    ('learn_option', 'GetLearnOption'), ('number_of_primary_tables',
    'GetNumberOfPrimaryTables'), ('test_option', 'GetTestOption'),
    ('progress_text', 'GetProgressText'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'g1_skewness', 'g2_kurtosis',
    'global_warning_display', 'release_data_flag', 'sample_estimate',
    'signed_deviations', 'unbiased_variance', 'assess_option',
    'derive_option', 'ghosts_to_skip', 'learn_option',
    'number_of_primary_tables', 'object_name', 'progress_text',
    'test_option'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(DescriptiveStatistics, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit DescriptiveStatistics properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['g1_skewness', 'g2_kurtosis', 'sample_estimate',
            'signed_deviations', 'unbiased_variance'], [], ['assess_option',
            'derive_option', 'ghosts_to_skip', 'learn_option',
            'number_of_primary_tables', 'object_name', 'test_option']),
            title='Edit DescriptiveStatistics properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit DescriptiveStatistics properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

