# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.context_item import ContextItem


class BlockItem(ContextItem):
    r"""
    BlockItem - a ContextItem that draws a block (optional label).
    
    Superclass: ContextItem
    
    This is a ContextItem that can be placed into a ContextScene.
    It draws a block of the given dimensions, and reacts to mouse events.
    
    BlockItem can also be used to render label in the scene. The label
    properties can be set using `vtktext_property` accessed via
    `get_label_properties`.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkBlockItem, obj, update, **traits)
    
    auto_compute_dimensions = tvtk_base.false_bool_trait(desc=\
        r"""
        When set to true, the dimensions for the block are computed
        automatically using the anchor point, alignment at the size of
        the label. Otherwise the `Dimensions` are used.
        
        Default is false i.e `Dimensions` will be used.
        """
    )

    def _auto_compute_dimensions_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAutoComputeDimensions,
                        self.auto_compute_dimensions_)

    dimensions = traits.Array(enter_set=True, auto_set=False, shape=(4,), dtype="float", value=(0.0, 0.0, 0.0, 0.0), cols=3, desc=\
        r"""
        Set the dimensions of the block, elements 0 and 1 are the x and y
        coordinate of the bottom corner. Elements 2 and 3 are the width
        and height. Initial value is (0,0,0,0).
        """
    )

    def _dimensions_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDimensions,
                        self.dimensions)

    horizontal_alignment = traits.Int(5, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the horizontal alignment of the legend to the point
        specified. Valid values are LEFT, CENTER and RIGHT.
        """
    )

    def _horizontal_alignment_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHorizontalAlignment,
                        self.horizontal_alignment)

    label = traits.String('', enter_set=True, auto_set=False, desc=\
        r"""
        Set the block label.
        """
    )

    def _label_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLabel,
                        self.label)

    def _get_label_properties(self):
        return wrap_vtk(self._vtk_obj.GetLabelProperties())
    def _set_label_properties(self, arg):
        old_val = self._get_label_properties()
        self._wrap_call(self._vtk_obj.SetLabelProperties,
                        deref_vtk(arg))
        self.trait_property_changed('label_properties', old_val, arg)
    label_properties = traits.Property(_get_label_properties, _set_label_properties, desc=\
        r"""
        
        """
    )

    margins = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="int", value=(10, 10), cols=2, desc=\
        r"""
        When auto_compute_dimensions is true, these are the margins from
        the edge of the viewport to use when placing the block based on
        horizontal_alignment and vertical_alignment preferences.
        """
    )

    def _margins_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMargins,
                        self.margins)

    padding = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="int", value=(5, 5), cols=2, desc=\
        r"""
        When auto_compute_dimensions is true, these are the padding for the
        label within the block.
        
        Default is (5, 5).
        """
    )

    def _padding_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPadding,
                        self.padding)

    vertical_alignment = traits.Int(5, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the vertical alignment of the legend to the point
        specified. Valid values are TOP, CENTER and BOTTOM.
        """
    )

    def _vertical_alignment_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetVerticalAlignment,
                        self.vertical_alignment)

    def _get_brush(self):
        return wrap_vtk(self._vtk_obj.GetBrush())
    brush = traits.Property(_get_brush, desc=\
        r"""
        Get the brush used to draw the block item background.
        """
    )

    def _get_mouse_over_brush(self):
        return wrap_vtk(self._vtk_obj.GetMouseOverBrush())
    mouse_over_brush = traits.Property(_get_mouse_over_brush, desc=\
        r"""
        Get the brush used to draw the block item background when the
        item is "hit" i.e. interaction is enabled and the mouse is over
        the block.
        """
    )

    def _get_pen(self):
        return wrap_vtk(self._vtk_obj.GetPen())
    pen = traits.Property(_get_pen, desc=\
        r"""
        Get pen used to draw the block item outline.
        """
    )

    _updateable_traits_ = \
    (('auto_compute_dimensions', 'GetAutoComputeDimensions'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('dimensions', 'GetDimensions'), ('horizontal_alignment',
    'GetHorizontalAlignment'), ('label', 'GetLabel'), ('margins',
    'GetMargins'), ('padding', 'GetPadding'), ('vertical_alignment',
    'GetVerticalAlignment'), ('opacity', 'GetOpacity'), ('interactive',
    'GetInteractive'), ('visible', 'GetVisible'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['auto_compute_dimensions', 'debug', 'global_warning_display',
    'dimensions', 'horizontal_alignment', 'interactive', 'label',
    'margins', 'object_name', 'opacity', 'padding', 'vertical_alignment',
    'visible'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(BlockItem, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit BlockItem properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['auto_compute_dimensions'], [], ['dimensions',
            'horizontal_alignment', 'interactive', 'label', 'margins',
            'object_name', 'opacity', 'padding', 'vertical_alignment',
            'visible']),
            title='Edit BlockItem properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit BlockItem properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

