
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileBinningObjectAttributes.h
    \brief Definition of BinningObject Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef BinningObjectAttributes_H
#define BinningObjectAttributes_H

#include "magics.h"
namespace magics {

class XmlNode;
class BinningObjectAttributes 
{
public:
//  --  constructor
    BinningObjectAttributes();
    
//  --  destructor
    virtual ~BinningObjectAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const BinningObjectAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	string x_;
	double x_min_;
	double x_max_;
	int x_count_;
	doublearray x_list_;
	double x_interval_;
	double x_reference_;
	string y_;
	double y_min_;
	double y_max_;
	int y_count_;
	doublearray y_list_;
	double y_interval_;
	double y_reference_;
	 

private:
	friend ostream& operator<<(ostream& s,const BinningObjectAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

