-- -*- coding: utf-8 -*-
--- status: DRAFT
--- author(s): MES
--- notes:

-- in Classic: (monomialIdeal, String)
document {
     Key => MonomialIdeal,
     Headline => "the class of all monomial ideals handled by the engine",
     "Monomial ideals are kinds of ideals, but many algorithms are much faster.
     Generally, any routines available for ideals are also available for monomial
     ideals.",
     EXAMPLE lines ///
         R = QQ[a..d];
	 I = monomialIdeal(a*b*c,b*c*d,a^2*d,b^3*c)
	 I^2
	 I + monomialIdeal(b*c)
	 I : monomialIdeal(b*c)
	 radical I
	 associatedPrimes I
	 primaryDecomposition I
     ///,
     HEADER3 "Specialized functions only available for monomial ideals",
     UL {
	  TO (borel,MonomialIdeal),
	  TO (isBorel,MonomialIdeal),
	  TO (symbol-, MonomialIdeal, MonomialIdeal),
	  TO (dual, MonomialIdeal),
	  TO independentSets,
	  TO "PrimaryDecomposition::irreducibleDecomposition",
	  TO standardPairs,
	  },
     EXAMPLE lines ///
         borel I
	 isBorel I
	 I - monomialIdeal(b^3*c,b^4)
	 standardPairs I
	 independentSets I
	 dual I
     ///,
     "The ring of a monomial ideal must be a commutative polynomial ring.  This ring must
     not be a skew commuting ring, and/or a quotient ring.",
    Subnodes => {
	TO monomialIdeal,
	TO monomialSubideal,
	TO (independentSets, MonomialIdeal),
	TO (standardPairs, MonomialIdeal),
	TO (polarize, MonomialIdeal),
	TO (codim, MonomialIdeal),
        TO (symbol -, MonomialIdeal, MonomialIdeal),
        TO (dual, MonomialIdeal, List),
        TO (dual, MonomialIdeal, RingElement),
        TO (dual, MonomialIdeal),
        TO (lcm, MonomialIdeal),
        },
     }

document {
     Key => monomialIdeal,
     Headline => "make a monomial ideal",
    SeeAlso => {
	"Classic::monomialIdeal(String)",
        },
    Subnodes => {
	TO (monomialIdeal, Matrix),
	TO (monomialIdeal, Ideal),
        },
     }
document {
     Key => {
	  (monomialIdeal,Matrix),
	  (monomialIdeal,RingElement),
	  (monomialIdeal,List),
	  (monomialIdeal,Sequence)},
     Headline => "monomial ideal of lead monomials",
     Usage => "monomialIdeal L",
     Inputs => {
	  "L" => Nothing => {ofClass Matrix, ", ",
	       ofClass RingElement, ", ",
	       ofClass List, ", or ",
	       ofClass Sequence}
	  },
     Outputs => {
	  MonomialIdeal => "the monomial ideal of lead monomials of the elements of L",
	  },
     "If L is a matrix, then it must have only one row.  For all of these types,
     the result is generated by only the lead monomials given: no Gröbner bases are computed.
     See ", TO (monomialIdeal,Ideal), " if the lead monomials of a Gröbner basis is desired.",
     EXAMPLE lines ///
	  R = ZZ/101[a,b,c];
	  I = monomialIdeal(a^3,b^3,c^3, a^2-b^2)
      	  M = monomialIdeal vars R
	  J = monomialIdeal 0_R
	  ///,
     "If the coefficient ring is ZZ, lead coefficients of the monomials are ignored.",
     EXAMPLE lines ///
       R = ZZ[x,y]
       monomialIdeal(2*x,3*y)
     ///,
     SeeAlso => {MonomialIdeal}
     }
document {
     Key => {
	 (monomialIdeal, Ideal),
	 (monomialIdeal, Module),
	 (monomialIdeal, MonomialIdeal)},
     Headline => "monomial ideal of lead monomials of a Gröbner basis",
     Usage => "monomialIdeal J",
     Inputs => {
	  "J"
	  },
     Outputs => {
	  MonomialIdeal => {"the monomial ideal generated by the lead monomials of a Gröbner basis of ",
	       TT "J" } },
     "J may also be a submodule of R^1, for R the ring of J.",
     EXAMPLE lines ///
	  R = ZZ/101[a,b,c];
	  I = ideal(a^3,b^3,c^3, a^2-b^2)
     	  monomialIdeal I
	  monomialSubideal I
	  ///,
     "If the coefficient ring is ZZ, lead coefficients of the monomials are ignored.",
     EXAMPLE lines ///
       R = ZZ[x,y]
       monomialIdeal ideal(2*x,3*y)
     ///,
     SeeAlso => {MonomialIdeal,monomialSubideal}
     }

document {
     Key => (symbol -, MonomialIdeal, MonomialIdeal),
     Headline => "monomial ideal difference",
     Usage => "I - J",
     Inputs => {
	  "I", "J"
	  },
     Outputs => {
	  MonomialIdeal => {"generated by those minimal generators of I which are not in J"}
	  },
     EXAMPLE lines ///
     	  R = QQ[a..d];
	  I = monomialIdeal(a^3,b^2,a*b*c)
	  J = monomialIdeal(a^2,b^3,a*b*c)
	  I - J
	  J - I
	  I - (I-J)
          ///,
     SeeAlso => {MonomialIdeal}
     }

--document { (complement, MonomialIdeal),
--					  -- compute { m^c : m minimal generator of I }, where
--					  -- m^c is the product of the variables
--					  -- not in the support of m.",
--     TT "complement I", " -- computes the complement of a monomial ideal.",
--     PARA{},
--     "The complement of ", TT "I", " is defined to be the ideal generated by those monomials
--     which have no factor in common with some monomial of ", TT "I", ".",
--     SeeAlso => MonomialIdeal
--     }
--
--document { (complement, MonomialIdeal, Monomial),
--					  -- (I,p) -- compute { p/m : m in I }, where p is a given monomial",
--     TT "complement(I,p)", " -- ",
--     SeeAlso => MonomialIdeal
--     }
--

document {
     Key => {[(dual,MonomialIdeal),Strategy], [(dual,MonomialIdeal,List),Strategy], [(dual,MonomialIdeal,RingElement),Strategy]},
     PARA {
	  "Specify ", TT "Strategy => 1", " to test an older strategy for performing the computation."
	  }
     }

document {
     Key => (dual,MonomialIdeal,List),
     Headline => "the Alexander dual",
     Usage => "dual(I,e)",
     Inputs => {
	  "I" => {"a monomial ideal"},
	  "e" => {"a list of exponents"}
	  },
     Outputs => { {"the Alexander dual of ", TT "I", " formed with respect to the monomial whose exponents are listed in ", TT "e" } },
     PARA { "The monomial corresponding to ", TT "e", " should be divisible by all of the minimal generators of ", TT "I", "." },
     PARA {
	  "The computation is done by calling the ", TO "frobby", " library, written by B. H. Roune;
	  setting ", TO "gbTrace", " to a positive value will cause a message to be printed when it is called."
	  },
     SeeAlso => {(dual,MonomialIdeal)}
     }

document {
     Key => (dual,MonomialIdeal,RingElement),
     Headline => "the Alexander dual",
     Usage => "dual(I,m)",
     Inputs => {
	  "I" => {"a monomial ideal"},
	  "m" => {"a monomial"}
	  },
     Outputs => { {"the Alexander dual of ", TT "I", " formed with respect to ", TT "m", "." } },
     "The monomial ", TT "m", " should be divisible by all
     of the minimal generators of ", TT "I", ".",
     SeeAlso => {(dual,MonomialIdeal)}
     }

document {
     Key => (dual,MonomialIdeal),
     Headline => "the Alexander dual of a monomial ideal",
     Usage => "dual I",
     Inputs => {
	  "I" => {"a monomial ideal"}
	  },
     Outputs => {
	  {"the Alexander dual of ", TT "I"}
	  },
     "If ", TT "I", "is a square free monomial ideal then ",
     TT "I", " is the Stanley-Reisner ideal of a simplicial
     complex.  In this case, ", TT "dual I", " is the
     Stanley-Reisner ideal associated to the dual complex.
     In particular, ", TT "dual I", " is obtained by
     switching the roles of minimal generators and prime
     components.",
     EXAMPLE {
	  "QQ[a,b,c,d];",
	  "I = monomialIdeal(a*b, b*c, c*d)",
	  "dual I",
	  "intersect(monomialIdeal(a,b),
	       monomialIdeal(b,c),
	       monomialIdeal(c,d))",
	  "dual dual I"
	  },
     PARA{},
     "For a general monomial ideal, the Alexander dual
     defined as follows:  Given two list of nonnegative
     integers ", TT "a", " and ", TT "b", "for which ",
     TT "a_i >= b_i", " for all ", TT "i", " let ",
     TT "a\\b", " denote the list whose ", TT "i", "-th
     entry is ", TT "a_i+1-b_i", "if ", TT "b_i >= 1",
     "and ", TT "0", "otherwise.  The Alexander dual with
     respect to ", TT "a", " is the ideal generated by
     a monomial ", TT "x^a\\b", " for each irreducible
     component ", TT "(x_i^b_i)", " of ", TT "I", ".
     If ", TT "a", " is not provided, it is assumed to be
     the least common multiple of the minimal generators
     of ", TT "I", ".",
     EXAMPLE {
     	  "QQ[x,y,z];",
	  "I = monomialIdeal(x^3, x*y, y*z^2)",
	  "dual(I, {4,4,4})",
	  "intersect( monomialIdeal(x^2),
	       monomialIdeal(x^4, y^4),
	       monomialIdeal(y^4, z^3))",
	  },
     PARA{},
     "One always has ", TT "dual( dual(I, a), a) == I",
     " however ", TT "dual dual I", "may not equal ",
     TT "I", ".",
     EXAMPLE lines ///
	  QQ[x,y,z];
	  J = monomialIdeal( x^3*y^2, x*y^4, x*z, y^2*z)
	  dual dual J
	  dual( dual(J, {3,4,1}), {3,4,1})
	  ///,
     PARA{},
     "See Ezra Miller's Ph.D. thesis 'Resolutions and
     Duality for Monomial Ideals'.",
     PARA { "Implemented by Greg Smith." },
     PARA {
	  "The computation is done by calling the ", TO "frobby", " library, written by B. H. Roune;
	  setting ", TO "gbTrace", " to a positive value will cause a message to be printed when it is called."
	  },
     Subnodes => { TO [(dual, MonomialIdeal), Strategy] },
     }

document {
     Key => {
	  monomialSubideal,
	  (monomialSubideal, Ideal)},
     Headline => "find the largest monomial ideal in an ideal",
     Usage => "monomialSubideal I",
     Inputs => {
	  "I" => Ideal
	  },
     Outputs => {
	  MonomialIdeal => {"the largest monomial ideal contained in ", TT "I"}
	  },
     EXAMPLE lines ///
	  QQ[a,b,c,d];
	  I = ideal(b*c, c^2 - b*d, -a*c+b^2)
	  monomialSubideal I
	  ///,
     PARA{},
     "Implemented by Greg Smith."
     }

document {
     Key => {isBorel,(isBorel, MonomialIdeal)},
     Headline => "whether an ideal is fixed by upper triangular changes of coordinates"
     }

doc ///
  Key
    (lcm,MonomialIdeal)
  Headline
    least common multiple of all minimal generators
  Usage
    m = lcm I
  Inputs
    I:MonomialIdeal
  Outputs
    m:RingElement
  Description
   Text
     This function is implemented in the engine, as it is used in many algorithms involving monomial ideals.
   Example
     R = QQ[a..d];
     I = monomialIdeal "a4,a3b6,a2b8c2,c4d5"
     lcm I
     first exponents lcm I
  SeeAlso
    (dual,MonomialIdeal)
    "PrimaryDecomposition::irreducibleDecomposition(MonomialIdeal)"
    "PrimaryDecomposition::primaryDecomposition(Ideal)"
///
