////////////////////////////////////////////////////////////////////////////////
//
//	Pico Technology USB Device Driver
//
///	\file     LinuxUsbFS.h
///	\brief    IOCTLs and structures for interfacing with the Linux USB FS
//
//	Copyright (c) 2007, Pico Technology.
//	All rights reserved.
//   
//	Redistribution and use in source and binary forms, with or without
//	modification, are permitted provided that the following conditions are met:
//		* Redistributions of source code must retain the above copyright
//		  notice, this list of conditions and the following disclaimer.
//		* Redistributions in binary form must reproduce the above copyright
//		  notice, this list of conditions and the following disclaimer in the
//		  documentation and/or other materials provided with the distribution.
//		* The name of Pico Technology may not be used to endorse or promote
//		  products derived from this software without specific prior written
//		  permission.
//
//	THIS SOFTWARE IS PROVIDED BY PICO TECHNOLOGY ``AS IS'' AND ANY
//	EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
//	DISCLAIMED. IN NO EVENT SHALL PICO TECHNOLOGY BE LIABLE FOR ANY
//	DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
//	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
//	LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
//	ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
//	(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
//	THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//	Version $Id: LinuxUsbFS.h,v 1.2 2008/03/10 20:26:01 douglas Exp $
//
////////////////////////////////////////////////////////////////////////////////

#include "PicoPortability.h"

/* Avoid including this header if we are not compiling for Linux */
#ifdef PICO_OS_LINUX

/* Avoid including this header more than once */
#ifndef LINUXUSBFS_H
#define LINUXUSBFS_H

/// Control transfer information
struct linux_usbfs_ctrltransfer {
	uint8_t bRequestType;
	uint8_t bRequest;
	uint16_t wValue;
	uint16_t wIndex;
	uint16_t wLength;
	uint32_t timeout;
	uint8_t *data;
};

// We don't use this but must define it for the purpose of the urb struct below
struct  linux_usbfs_iso_packet_desc {
	uint32_t length;
	uint32_t actual_length;
	uint32_t status;
};

/// USB URB, used for bulk transfers
struct  linux_usbfs_urb {
	uint8_t type;
	uint8_t endpoint;
	int32_t status;
	uint32_t flags;
	void  *buffer;
	int32_t buffer_length;
	int32_t actual_length;
	int32_t start_frame;
	int32_t number_of_packets;
	int32_t error_count;
	uint32_t signr;
	void *usercontext;
	struct linux_usbfs_iso_packet_desc iso_frame_desc[0];
};


struct linux_usbfs_setinterface {
	uint32_t  interface;
	uint32_t  altsetting;
}; 


#define IOCTL_USBFS_CONTROL           _IOWR('U', 0, struct linux_usbfs_ctrltransfer)
#define IOCTL_USBFS_BULK              _IOWR('U', 2, struct linux_usbfs_bulktransfer)
#define IOCTL_USBFS_RESETEP           _IOR('U', 3, unsigned int)
#define IOCTL_USBFS_SETINTERFACE      _IOR('U', 4, struct linux_usbfs_setinterface)
#define IOCTL_USBFS_SETCONFIGURATION  _IOR('U', 5, unsigned int)
#define IOCTL_USBFS_GETDRIVER         _IOW('U', 8, struct linux_usbfs_getdriver)
#define IOCTL_USBFS_SUBMITURB         _IOR('U', 10, struct linux_usbfs_urb)
#define IOCTL_USBFS_SUBMITURB32       _IOR('U', 10, struct linux_usbfs_urb32)
#define IOCTL_USBFS_DISCARDURB        _IO('U', 11)
#define IOCTL_USBFS_REAPURB           _IOW('U', 12, void *)
#define IOCTL_USBFS_REAPURB32         _IOW('U', 12, __u32)
#define IOCTL_USBFS_REAPURBNDELAY     _IOW('U', 13, void *)
#define IOCTL_USBFS_REAPURBNDELAY32   _IOW('U', 13, __u32)
#define IOCTL_USBFS_DISCSIGNAL        _IOR('U', 14, struct linux_usbfs_disconnectsignal)
#define IOCTL_USBFS_CLAIMINTERFACE    _IOR('U', 15, unsigned int)
#define IOCTL_USBFS_RELEASEINTERFACE  _IOR('U', 16, unsigned int)
#define IOCTL_USBFS_CONNECTINFO       _IOW('U', 17, struct linux_usbfs_connectinfo)
#define IOCTL_USBFS_IOCTL             _IOWR('U', 18, struct linux_usbfs_ioctl)
#define IOCTL_USBFS_IOCTL32           _IOWR('U', 18, struct linux_usbfs_ioctl32)
#define IOCTL_USBFS_HUB_PORTINFO      _IOR('U', 19, struct linux_usbfs_hub_portinfo)
#define IOCTL_USBFS_RESET             _IO('U', 20)
#define IOCTL_USBFS_CLEAR_HALT        _IOR('U', 21, unsigned int)
#define IOCTL_USBFS_DISCONNECT        _IO('U', 22)
#define IOCTL_USBFS_CONNECT           _IO('U', 23)

#endif // not defined LINUXUSBFS_H

#endif // defined PICO_OS_LINUX
