/* A Bison parser, made by GNU Bison 3.0.4.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.0.4"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* "%code top" blocks.  */
#line 61 "L3Parser.ypp" /* yacc.c:316  */


 /** @cond doxygenLibsbmlInternal */

#line 68 "L3Parser.cpp" /* yacc.c:316  */
/* Substitute the type names.  */
#define YYSTYPE         SBML_YYSTYPE
/* Substitute the variable and function names.  */
#define yyparse         sbml_yyparse
#define yylex           sbml_yylex
#define yyerror         sbml_yyerror
#define yydebug         sbml_yydebug
#define yynerrs         sbml_yynerrs

#define yylval          sbml_yylval
#define yychar          sbml_yychar

/* Copy the first part of user declarations.  */
#line 66 "L3Parser.ypp" /* yacc.c:339  */

/**
 *
 * This file is AUTOMATICALLY GENERATED by the 'bison' program and
 * should not be modified directly.  It is created with the command
 *
 * bison -v L3Parser.ypp -o L3Parser.cpp
 *
 * from the L3Parser.ypp file.  Any modifications should be performed on
 * that file directly.
 *
 * This file defines an entire class, 'L3Parser', that does not appear
 * in any header file, as it is only useful in the context of the C functions
 * generated by the bison program.  Future versions of this parser may
 * use a version of bison that generates a parser object instead of C
 * functions, but for now, the only interface with the library is defined
 * in the L3Parser.h file.
 */

#include <sbml/common/libsbml-namespace.h>
#include <sbml/Model.h>
#include <sbml/math/L3Parser.h>
#include <sbml/math/L3ParserSettings.h>
#include <sbml/extension/ASTBasePlugin.h>
#include <sbml/util/util.h>

#include <sstream>
#include <set>

LIBSBML_CPP_NAMESPACE_USE
LIBSBML_CPP_NAMESPACE_BEGIN
class SBMLVisitor;
class FormulaUnitsData;

#ifndef SWIG //Hide the entire class from SWIG
/**
 * @class L3Parser
 * @ingroup core
 * @brief Class providing functionality for the bison-generated parser.
 *
 * The L3Parser class is an internal class designed to hold the guts of the bison parser, plus
 * the lexer.  It is designed to be a global singleton object, because that's the cleanest way
 * I could find to incorporate functions into the bison framework.
 *
 * The functions declared in this file are defined in the file L3Parser.ypp, which
 * must be compiled by bison to create L3Parser.cpp, the file included in
 * libsbml.  For more details, see the L3Parser.ypp file.
 *
 * Within the various 'sbml_yylex*' functions that bison creates, functions
 * from the global 'l3p' object (of the L3Parser class) are used to calculate
 * necessary information for the parsing of the string, and to determine appropriate
 * error messages when things go wrong.
 * @internal
 */
class LIBSBML_EXTERN L3Parser
{
public:

  std::stringstream input;
  ASTNode* outputNode;
  std::string error;
  std::map<std::string, std::string*> words;
  long exponent;
  long denominator;

  //settings:
  L3ParserSettings defaultL3ParserSettings;
  const Model* model;
  ParseLogType_t parselog;
  bool collapseminus;
  bool parseunits;
  bool avocsymbol;
  const L3ParserSettings* currentSettings;
  bool strCmpIsCaseSensitive;
  bool modulol3v2;

  L3Parser();
  virtual ~L3Parser();

  //Functions needed for the parser and the lexer:
  /**
   * Compares 'name' against a list of known constants, and returns the particular
   * constant type (AST_CONSTANT_TRUE, AST_CONSTANT_PI, AST_NAME_TIME) associated
   * with that string (with case ignored).  For the mathematical constants
   * infinity and notanumber, AST_REAL is returned, and the parser must then
   * examine the string again to discover what to do with the ASTNode.
   */
  ASTNodeType_t getSymbolFor(std::string name) const;
  /**
   * Compares 'name' against a list of known functions allowed in the MathML
   * of SBML Level 2 and 3.  Multiple mappings of string->type are present,
   * so that (for example) both the strings 'acos' and 'arccos' return the
   * type AST_FUNCTION_ARCCOS.  "log" returns AST_FUNCTION_LOG, so when 
   * user preference is taken into consideration, 'name' must once again
   * be checked.
   */
  ASTNodeType_t getFunctionFor(std::string name) const;
  /**
   * This function creates an ASTNode that is a 'piecewise' function that
   * mimics the 'modulo' function 'x % y'.  It was modified from the
   * function of the same name in Copasi in its  CEvaluationNodeOperator 
   * class, which itself had modifications submitted by Frank Bergmann.  
   */
  ASTNode*      createModuloTree(ASTNode* x, ASTNode* y) const;
  /**
   * Sets the member variable 'collapseminus' to the provided boolean value.  Used in parsing
   * unary minuses.
   */
  void setCollapseMinus(bool collapse);
  /**
   * Sets the member variable 'parselog' to the provided enum.  Used in parsing
   * strings with the function "log" with a single argument.
   */
  void setParseLog(ParseLogType_t parseas);
  /**
   * Sets the member variable 'parseunits' to the provided boolean.  Used in
   * deciding whether strings that assign units to numbers (like "10 mL") 
   * are parsed correctly, or as errors.
   */
  void setParseUnits(bool units);
  /**
   * Sets the member variable 'avocsymbol' to the provided boolean. Used in
   * deciding whether to parse the string 'avogadro' as an ASTNode of type
   * AST_NAME_AVOGADRO or AST_NAME with the name 'avogadro'.
   */
  void setAvoCsymbol(bool avo);
  /**
   * Sets the member variable 'strCmpIsCaseSensitive' to the provided boolean. Used in
   * deciding whether to parse the built-in functions and variables caseless
   * or not.
   */
  void setComparisonCaseSensitivity(bool strcmp);
  /**
   * Compares the two strings, and returns 'true' if they are equivalent,
   * ignoring case.  Used in the parser and in the 'getSymbolFor' and 
   * 'getFunctionFor' functions.
   */
  bool l3StrCmp(const std::string& lhs, const std::string& rhs) const;
  /**
   * Sets the member variable 'modulol3v2' to the provided boolean value.  Used in parsing
   * the '%' symbol.
   */
  void setModuloL3v2(bool ml3v2);
  /**
   * Sets the member variable 'l3v2functions' to the provided boolean value.  Used in parsing
   * the functions added to the SBML spec in l3v2.
   */
  void setInput(const char* c);
  /**
   * Sets the error string so that it can be retrieved by the function 
   * 'SBML_getLastParseL3Error'.
   */
  void setError(const char* c);
  /**
   * Sets the error string so that it can be retrieved by the function 
   * 'SBML_getLastParseL3Error'.
   */
  void setError(const std::string& c);
  /**
   * Resets the L3Parser object, removing any error or input strings,
   * setting the output ASTNode to NULL, and resetting all parser settings
   * to that stored in the 'defaultL3ParserSettings' member variable.
   */
  void clear();
  /**
   * Returns the 'error' member variable, which is either empty or contains
   * the error message set from a 'setError' function.
   */
  std::string getError();
  
  /**
   * The bison parser needs string pointers to pass around from function to
   * function.  In order to not create too many of these objects, and to
   * ensure that they are properly deleted, the lexer calls this function
   * when it encounters a valid ID string to get a stable pointer that can 
   * be passed to the parser functions.
   * 
   * In this function, 'word' is looked up in a hash map of strings to 
   * string pointers; if it is not found, a new string pointer containing
   * the string is created, added to the hash, and returned.  If it is
   * found, the previously-created pointer is returned.
   */
  std::string* addWord(const std::string& word);
  
  /**
   * This function checks the provided ASTNode function to see if it is a 
   * known function with the wrong number of arguments.  If so, an error is set
   * (using the 'setError' function) and 'true' is returned.  If the
   * correct number of arguments is provided, 'false' is returned.
   */
  bool checkNumArguments(const ASTNode* function);

  /**
   * This function takes a 'lambda' function and changes any arguments
   * that might match predefined constants, and changes them back to normal
   * AST_NAME children, and changes any corresponding constants in the final
   * math function to also be AST_NAME. 
   */
  void fixLambdaArguments(const ASTNode* function);

  /**
   * This function checks the provided ASTNode function to see if it is a 
   * known function with the wrong number of arguments.  If so, an error is set
   * (using the 'setError' function) and 'true' is returned.  If the
   * correct number of arguments is provided, 'false' is returned.  It is used
   * for ASTNodes created from packages.
   */
  bool checkNumArgumentsForPackage(const ASTNode* function);

  /**
   * This function takes the given left and right ASTNodes, and combines them
   * with the given relational type, returning the combined node.
   */
  ASTNode* combineRelationalElements(ASTNode* left, ASTNode* right, ASTNodeType_t type);

  /**
   * Provides a copy of the default parser settings member variable.
   */
  L3ParserSettings getDefaultL3ParserSettings();

  /**
   * Change the default settings for this parser to the settings provided.  All subsequent
   * calls to parseL3Formula with no 'settings' argument will use these settings
   * instead of the defaults.
   */
  void setDefaultSettings(L3ParserSettings settings);

  /**
   * The generic parsing function for grammar lines that packages recognize, but not core.
   * When a package recognizes the 'type', it will parse and return the correct ASTNode.
   * If it does not recognize the 'type', or if the arguments are incorrect, NULL is returend.
   */
  virtual ASTNode* parsePackageInfix(L3ParserGrammarLineType_t type, 
    std::vector<ASTNode*> *nodeList = NULL, std::vector<std::string*> *stringList = NULL,
    std::vector<double> *doubleList = NULL) const;


  /**
   * If the either versions of the function @see SBML_parseL3Formula() returns NULL, an error 
   * is set internally which is accessible via this function.  The returned error will 
   * report the string it was trying to parse, which character it had parsed when it 
   * encountered the error, and what the error was.
   * 
   */
  static char* getLastParseL3Error();
};
#endif //The entire class should be invisible to SWIG, too.

LIBSBML_CPP_NAMESPACE_END

  using namespace std;

  int sbml_yylex(void);
  L3Parser* l3p = NULL;


LIBSBML_CPP_NAMESPACE_BEGIN
L3Parser* L3Parser_getInstance()
{
  if (l3p == NULL)
  {
    l3p = new L3Parser();
    std::atexit(SBML_deleteL3Parser);
  }
  return l3p;
}
LIBSBML_CPP_NAMESPACE_END

  void sbml_yyerror(char const *);
  int sbml_yylloc_first_position = 1;
  int sbml_yylloc_last_position = 1;

#ifdef __BORLANDC__
#undef DOUBLE
#endif


#line 360 "L3Parser.cpp" /* yacc.c:339  */

# ifndef YY_NULLPTR
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULLPTR nullptr
#  else
#   define YY_NULLPTR 0
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 1
#endif


/* Debug traces.  */
#ifndef SBML_YYDEBUG
# if defined YYDEBUG
#if YYDEBUG
#   define SBML_YYDEBUG 1
#  else
#   define SBML_YYDEBUG 0
#  endif
# else /* ! defined YYDEBUG */
#  define SBML_YYDEBUG 1
# endif /* ! defined YYDEBUG */
#endif  /* ! defined SBML_YYDEBUG */
#if SBML_YYDEBUG
extern int sbml_yydebug;
#endif

/* Token type.  */
#ifndef SBML_YYTOKENTYPE
# define SBML_YYTOKENTYPE
  enum sbml_yytokentype
  {
    YYEOF = 0,
    NOT = 258,
    NEG = 259,
    UPLUS = 260,
    DOUBLE = 261,
    INTEGER = 262,
    E_NOTATION = 263,
    RATIONAL = 264,
    SYMBOL = 265
  };
#endif

/* Value type.  */
#if ! defined SBML_YYSTYPE && ! defined SBML_YYSTYPE_IS_DECLARED

union SBML_YYSTYPE
{
#line 345 "L3Parser.ypp" /* yacc.c:355  */

  ASTNode* astnode;
  char character;
  const string* word;
  double numdouble;
  long   numlong;
  double mantissa;
  long   rational;

#line 427 "L3Parser.cpp" /* yacc.c:355  */
};

typedef union SBML_YYSTYPE SBML_YYSTYPE;
# define SBML_YYSTYPE_IS_TRIVIAL 1
# define SBML_YYSTYPE_IS_DECLARED 1
#endif


extern SBML_YYSTYPE sbml_yylval;

int sbml_yyparse (void);



/* Copy the second part of user declarations.  */

#line 444 "L3Parser.cpp" /* yacc.c:358  */

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE
# if (defined __GNUC__                                               \
      && (2 < __GNUC__ || (__GNUC__ == 2 && 96 <= __GNUC_MINOR__)))  \
     || defined __SUNPRO_C && 0x5110 <= __SUNPRO_C
#  define YY_ATTRIBUTE(Spec) __attribute__(Spec)
# else
#  define YY_ATTRIBUTE(Spec) /* empty */
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# define YY_ATTRIBUTE_PURE   YY_ATTRIBUTE ((__pure__))
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# define YY_ATTRIBUTE_UNUSED YY_ATTRIBUTE ((__unused__))
#endif

#if !defined _Noreturn \
     && (!defined __STDC_VERSION__ || __STDC_VERSION__ < 201112)
# if defined _MSC_VER && 1200 <= _MSC_VER
#  define _Noreturn __declspec (noreturn)
# else
#  define _Noreturn YY_ATTRIBUTE ((__noreturn__))
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif


#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined SBML_YYSTYPE_IS_TRIVIAL && SBML_YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYSIZE_T yynewbytes;                                            \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / sizeof (*yyptr);                          \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  24
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   254

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  31
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  6
/* YYNRULES -- Number of rules.  */
#define YYNRULES  43
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  79

/* YYTRANSLATE[YYX] -- Symbol number corresponding to YYX as returned
   by yylex, with out-of-bounds checking.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   265

#define YYTRANSLATE(YYX)                                                \
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, without out-of-bounds checking.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     8,     2,     2,     2,    13,     3,     2,
      24,    25,    11,    10,    29,     9,     2,    12,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,    30,
       5,     7,     6,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    18,     2,    26,    17,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    27,     4,    28,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,    14,    15,
      16,    19,    20,    21,    22,    23
};

#if SBML_YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,   378,   378,   379,   380,   381,   384,   385,   411,   412,
     413,   424,   435,   436,   437,   447,   448,   481,   482,   483,
     484,   485,   486,   487,   488,   489,   500,   511,   512,   524,
     581,   594,   605,   616,   627,   637,   644,   651,   658,   665,
     681,   682,   685,   686
};
#endif

#if SBML_YYDEBUG || YYERROR_VERBOSE || 1
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of string\"", "error", "$undefined", "'&'", "'|'", "'<'", "'>'",
  "'='", "'!'", "'-'", "'+'", "'*'", "'/'", "'%'", "NOT", "NEG", "UPLUS",
  "'^'", "'['", "\"number\"", "\"integer\"",
  "\"number in e-notation form\"", "\"number in rational notation\"",
  "\"element name\"", "'('", "')'", "']'", "'{'", "'}'", "','", "';'",
  "$accept", "input", "node", "number", "nodelist", "nodesemicolonlist", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,    38,   124,    60,    62,    61,    33,    45,
      43,    42,    47,    37,   258,   259,   260,    94,    91,   261,
     262,   263,   264,   265,    40,    41,    93,   123,   125,    44,
      59
};
# endif

#define YYPACT_NINF -24

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-24)))

#define YYTABLE_NINF -4

#define yytable_value_is_error(Yytable_value) \
  0

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
      58,   -24,   178,   178,   178,   -24,   -24,   -24,   -24,   -23,
     178,   117,    27,   203,    16,     7,     7,     7,   138,    83,
     -24,   219,    13,   -15,   -24,   -24,    42,    26,    -1,    97,
      39,    40,   178,   178,   178,   178,   178,   178,   158,   -24,
     -24,   -13,   -24,   -24,   178,   178,   -24,   178,   178,   178,
     178,   178,    52,   178,   178,    52,   178,   178,   236,   236,
       7,     7,     7,     7,   -24,   -12,   -24,   219,    23,    23,
     233,   233,    52,    52,    52,    52,    52,    52,   -24
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
       0,     4,     0,     0,     0,    35,    37,    36,    38,     7,
       0,     0,     0,     0,     6,    27,    16,    15,     0,     0,
      34,    40,     0,     0,     1,     5,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    39,
      28,     0,     8,    32,     0,     0,    33,     0,     0,     0,
       0,     0,    18,     0,     0,    17,     0,     0,    13,    11,
      10,    12,    14,     9,    31,     0,    29,    41,    42,    43,
      25,    26,    23,    20,    24,    19,    21,    22,    30
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int8 yypgoto[] =
{
     -24,   -24,     0,   -24,    -7,   -24
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int8 yydefgoto[] =
{
      -1,    12,    21,    14,    22,    23
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int8 yytable[] =
{
      13,    18,    15,    16,    17,    50,    51,     2,     3,     4,
      19,    41,    66,    46,    78,    47,    44,    44,     5,     6,
       7,     8,     9,    10,    37,    38,    11,    24,    52,    55,
      49,    65,    58,    59,    60,    61,    62,    63,    68,    39,
      69,    43,    44,    45,    67,    48,    56,    57,    70,    71,
      72,    73,    44,    74,    75,     0,    76,    77,    -2,     1,
       0,    32,    33,    34,    35,    36,     2,     3,     4,    37,
      38,     0,     0,     0,     0,     0,     0,     5,     6,     7,
       8,     9,    10,     0,     0,    11,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,    36,     0,     0,     0,
      37,    38,    53,     0,    54,     2,     3,     4,    42,     0,
       0,     0,     0,     0,     0,     0,     5,     6,     7,     8,
       9,    10,     0,     0,    11,     2,     3,     4,     0,     0,
       0,     0,     0,     0,     0,     0,     5,     6,     7,     8,
       9,    10,     0,     0,    11,    20,     2,     3,     4,     0,
       0,     0,     0,     0,     0,     0,     0,     5,     6,     7,
       8,     9,    10,    40,     0,    11,     2,     3,     4,     0,
       0,     0,     0,     0,     0,     0,     0,     5,     6,     7,
       8,     9,    10,     0,    64,    11,     2,     3,     4,     0,
       0,     0,     0,     0,     0,     0,     0,     5,     6,     7,
       8,     9,    10,    -3,    25,    11,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,    36,     0,     0,     0,
      37,    38,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    36,     0,     0,     0,    37,    38,    28,    29,
      30,    31,    32,    33,    34,    35,    36,    34,    35,    36,
      37,    38,     0,    37,    38
};

static const yytype_int8 yycheck[] =
{
       0,    24,     2,     3,     4,     6,     7,     8,     9,    10,
      10,    18,    25,    28,    26,    30,    29,    29,    19,    20,
      21,    22,    23,    24,    17,    18,    27,     0,    28,    29,
       4,    38,    32,    33,    34,    35,    36,    37,    45,    23,
      47,    28,    29,    30,    44,     3,     7,     7,    48,    49,
      50,    51,    29,    53,    54,    -1,    56,    57,     0,     1,
      -1,     9,    10,    11,    12,    13,     8,     9,    10,    17,
      18,    -1,    -1,    -1,    -1,    -1,    -1,    19,    20,    21,
      22,    23,    24,    -1,    -1,    27,     3,     4,     5,     6,
       7,     8,     9,    10,    11,    12,    13,    -1,    -1,    -1,
      17,    18,     5,    -1,     7,     8,     9,    10,    25,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    19,    20,    21,    22,
      23,    24,    -1,    -1,    27,     8,     9,    10,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    19,    20,    21,    22,
      23,    24,    -1,    -1,    27,    28,     8,     9,    10,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    19,    20,    21,
      22,    23,    24,    25,    -1,    27,     8,     9,    10,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    19,    20,    21,
      22,    23,    24,    -1,    26,    27,     8,     9,    10,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    19,    20,    21,
      22,    23,    24,     0,     1,    27,     3,     4,     5,     6,
       7,     8,     9,    10,    11,    12,    13,    -1,    -1,    -1,
      17,    18,     3,     4,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    -1,    -1,    -1,    17,    18,     5,     6,
       7,     8,     9,    10,    11,    12,    13,    11,    12,    13,
      17,    18,    -1,    17,    18
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     1,     8,     9,    10,    19,    20,    21,    22,    23,
      24,    27,    32,    33,    34,    33,    33,    33,    24,    33,
      28,    33,    35,    36,     0,     1,     3,     4,     5,     6,
       7,     8,     9,    10,    11,    12,    13,    17,    18,    23,
      25,    35,    25,    28,    29,    30,    28,    30,     3,     4,
       6,     7,    33,     5,     7,    33,     7,     7,    33,    33,
      33,    33,    33,    33,    26,    35,    25,    33,    35,    35,
      33,    33,    33,    33,    33,    33,    33,    33,    26
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,    31,    32,    32,    32,    32,    33,    33,    33,    33,
      33,    33,    33,    33,    33,    33,    33,    33,    33,    33,
      33,    33,    33,    33,    33,    33,    33,    33,    33,    33,
      33,    33,    33,    33,    33,    34,    34,    34,    34,    34,
      35,    35,    36,    36
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     0,     1,     1,     2,     1,     1,     3,     3,
       3,     3,     3,     3,     3,     2,     2,     3,     3,     4,
       4,     4,     4,     4,     4,     4,     4,     2,     3,     4,
       4,     3,     3,     3,     2,     1,     1,     1,     1,     2,
       1,     3,     3,     3
};


#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)
#define YYEMPTY         (-2)
#define YYEOF           0

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                  \
do                                                              \
  if (yychar == YYEMPTY)                                        \
    {                                                           \
      yychar = (Token);                                         \
      yylval = (Value);                                         \
      YYPOPSTACK (yylen);                                       \
      yystate = *yyssp;                                         \
      goto yybackup;                                            \
    }                                                           \
  else                                                          \
    {                                                           \
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;                                                  \
    }                                                           \
while (0)

/* Error token number */
#define YYTERROR        1
#define YYERRCODE       256



/* Enable debugging if requested.  */
#if SBML_YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)

/* This macro is provided for backward compatibility. */
#ifndef YY_LOCATION_PRINT
# define YY_LOCATION_PRINT(File, Loc) ((void) 0)
#endif


# define YY_SYMBOL_PRINT(Title, Type, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Type, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*----------------------------------------.
| Print this symbol's value on YYOUTPUT.  |
`----------------------------------------*/

static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
{
  FILE *yyo = yyoutput;
  YYUSE (yyo);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  YYUSE (yytype);
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyoutput, "%s %s (",
             yytype < YYNTOKENS ? "token" : "nterm", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yytype_int16 *yyssp, YYSTYPE *yyvsp, int yyrule)
{
  unsigned long int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       yystos[yyssp[yyi + 1 - yynrhs]],
                       &(yyvsp[(yyi + 1) - (yynrhs)])
                                              );
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !SBML_YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !SBML_YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
yystrlen (const char *yystr)
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            /* Fall through.  */
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYSIZE_T *yymsg_alloc, char **yymsg,
                yytype_int16 *yyssp, int yytoken)
{
  YYSIZE_T yysize0 = yytnamerr (YY_NULLPTR, yytname[yytoken]);
  YYSIZE_T yysize = yysize0;
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat. */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Number of reported tokens (one for the "unexpected", one per
     "expected"). */
  int yycount = 0;

  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[*yyssp];
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                {
                  YYSIZE_T yysize1 = yysize + yytnamerr (YY_NULLPTR, yytname[yyx]);
                  if (! (yysize <= yysize1
                         && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
                    return 2;
                  yysize = yysize1;
                }
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  {
    YYSIZE_T yysize1 = yysize + yystrlen (yyformat);
    if (! (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
      return 2;
    yysize = yysize1;
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          yyp++;
          yyformat++;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
{
  YYUSE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yytype);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}




/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;


/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       'yyss': related to states.
       'yyvs': related to semantic values.

       Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yyssp = yyss = yyssa;
  yyvsp = yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */
  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        YYSTYPE *yyvs1 = yyvs;
        yytype_int16 *yyss1 = yyss;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * sizeof (*yyssp),
                    &yyvs1, yysize * sizeof (*yyvsp),
                    &yystacksize);

        yyss = yyss1;
        yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yytype_int16 *yyss1 = yyss;
        union yyalloc *yyptr =
          (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
                  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 3:
#line 379 "L3Parser.ypp" /* yacc.c:1646  */
    {l3p->outputNode = (yyvsp[0].astnode);}
#line 1600 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 4:
#line 380 "L3Parser.ypp" /* yacc.c:1646  */
    {}
#line 1606 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 5:
#line 381 "L3Parser.ypp" /* yacc.c:1646  */
    {delete (yyvsp[-1].astnode);}
#line 1612 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 6:
#line 384 "L3Parser.ypp" /* yacc.c:1646  */
    {(yyval.astnode) = (yyvsp[0].astnode);}
#line 1618 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 7:
#line 385 "L3Parser.ypp" /* yacc.c:1646  */
    {
                   (yyval.astnode) = new ASTNode();
                   string name(*(yyvsp[0].word));
                   (yyval.astnode)->setName(name.c_str());
                   if (l3p->model == NULL ||
                       (l3p->model->getSpecies(name) == NULL
                        && l3p->model->getCompartment(name) == NULL
                        && l3p->model->getReaction(name) == NULL
                        && l3p->model->getParameter(name) == NULL
                        && l3p->model->getSpeciesReference(name) == NULL)) {
                     //The symbol is not used in any other mathematical context in the SBML model, so we can see if it matches a list of pre-defined names
                     ASTNodeType_t type = l3p->getSymbolFor(name);
                     if (type != AST_UNKNOWN) (yyval.astnode)->setType(type);
                     if (type==AST_REAL) {
                       if (l3p->l3StrCmp(name, "inf"))          (yyval.astnode)->setValue(numeric_limits<double>::infinity());
                       if (l3p->l3StrCmp(name, "infinity"))     (yyval.astnode)->setValue(numeric_limits<double>::infinity());
                       if (l3p->l3StrCmp(name, "nan"))          (yyval.astnode)->setValue(numeric_limits<double>::quiet_NaN());
                       if (l3p->l3StrCmp(name, "notanumber"))   (yyval.astnode)->setValue(numeric_limits<double>::quiet_NaN());
                     }
                     if (!l3p->avocsymbol && type==AST_NAME_AVOGADRO) {
                       //Don't parse 'avogadro' as a csymbol.
                       (yyval.astnode)->setName(name.c_str());
                       (yyval.astnode)->setType(AST_NAME);
                     }
                   }
        }
#line 1649 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 8:
#line 411 "L3Parser.ypp" /* yacc.c:1646  */
    {(yyval.astnode) = (yyvsp[-1].astnode);}
#line 1655 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 9:
#line 412 "L3Parser.ypp" /* yacc.c:1646  */
    {(yyval.astnode) = new ASTNode(AST_POWER); (yyval.astnode)->addChild((yyvsp[-2].astnode)); (yyval.astnode)->addChild((yyvsp[0].astnode));}
#line 1661 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 10:
#line 413 "L3Parser.ypp" /* yacc.c:1646  */
    {
                  if ((yyvsp[-2].astnode)->getType()==AST_TIMES) {
                    (yyval.astnode) = (yyvsp[-2].astnode);
                    (yyval.astnode)->addChild((yyvsp[0].astnode));
                  }
                  else {
                    (yyval.astnode) = new ASTNode(AST_TIMES);
                    (yyval.astnode)->addChild((yyvsp[-2].astnode));
                    (yyval.astnode)->addChild((yyvsp[0].astnode));
                  }
                }
#line 1677 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 11:
#line 424 "L3Parser.ypp" /* yacc.c:1646  */
    {
                  if ((yyvsp[-2].astnode)->getType()==AST_PLUS) {
                    (yyval.astnode) = (yyvsp[-2].astnode);
                    (yyval.astnode)->addChild((yyvsp[0].astnode));
                  }
                  else {
                    (yyval.astnode) = new ASTNode(AST_PLUS);
                    (yyval.astnode)->addChild((yyvsp[-2].astnode));
                    (yyval.astnode)->addChild((yyvsp[0].astnode));
                  }
                }
#line 1693 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 12:
#line 435 "L3Parser.ypp" /* yacc.c:1646  */
    {(yyval.astnode) = new ASTNode(AST_DIVIDE); (yyval.astnode)->addChild((yyvsp[-2].astnode)); (yyval.astnode)->addChild((yyvsp[0].astnode));}
#line 1699 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 13:
#line 436 "L3Parser.ypp" /* yacc.c:1646  */
    {(yyval.astnode) = new ASTNode(AST_MINUS); (yyval.astnode)->addChild((yyvsp[-2].astnode)); (yyval.astnode)->addChild((yyvsp[0].astnode));}
#line 1705 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 14:
#line 437 "L3Parser.ypp" /* yacc.c:1646  */
    {
                  if (l3p->modulol3v2) {
                    (yyval.astnode) = new ASTNode(AST_FUNCTION_REM);
                    (yyval.astnode)->addChild((yyvsp[-2].astnode));
                    (yyval.astnode)->addChild((yyvsp[0].astnode));
                  }
                  else {
                    (yyval.astnode) = l3p->createModuloTree((yyvsp[-2].astnode), (yyvsp[0].astnode));
                  }
                }
#line 1720 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 15:
#line 447 "L3Parser.ypp" /* yacc.c:1646  */
    {(yyval.astnode) = (yyvsp[0].astnode);}
#line 1726 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 16:
#line 448 "L3Parser.ypp" /* yacc.c:1646  */
    {
                  if (l3p->collapseminus) {
                    if ((yyvsp[0].astnode)->getType()==AST_REAL) {
                      (yyval.astnode) = (yyvsp[0].astnode);
                      (yyval.astnode)->setValue(-(yyval.astnode)->getReal());
                    }
                    else if ((yyvsp[0].astnode)->getType()==AST_INTEGER) {
                      (yyval.astnode) = (yyvsp[0].astnode);
                      (yyval.astnode)->setValue(-(yyval.astnode)->getInteger());
                    }
                    else if ((yyvsp[0].astnode)->getType()==AST_REAL_E) {
                      (yyval.astnode) = (yyvsp[0].astnode);
                      (yyval.astnode)->setValue(-(yyval.astnode)->getMantissa(), (yyval.astnode)->getExponent());
                    }
                    else if ((yyvsp[0].astnode)->getType()==AST_RATIONAL) {
                      (yyval.astnode) = (yyvsp[0].astnode);
                      (yyval.astnode)->setValue(-(yyval.astnode)->getNumerator(), (yyval.astnode)->getDenominator());
                    }
                    else if ((yyvsp[0].astnode)->getType()==AST_MINUS && (yyvsp[0].astnode)->getNumChildren()==1) {
                      (yyval.astnode) = (yyvsp[0].astnode)->getChild(0);
                      (yyvsp[0].astnode)->removeChild(0);
                      delete (yyvsp[0].astnode);
                    }
                    else {
                      (yyval.astnode) = new ASTNode(AST_MINUS);    
                      (yyval.astnode)->addChild((yyvsp[0].astnode));
                    }
                  }
                  else {
                    (yyval.astnode) = new ASTNode(AST_MINUS);
                    (yyval.astnode)->addChild((yyvsp[0].astnode));
                  }
                }
#line 1764 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 17:
#line 481 "L3Parser.ypp" /* yacc.c:1646  */
    {(yyval.astnode) = l3p->combineRelationalElements((yyvsp[-2].astnode), (yyvsp[0].astnode), AST_RELATIONAL_GT);}
#line 1770 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 18:
#line 482 "L3Parser.ypp" /* yacc.c:1646  */
    {(yyval.astnode) = l3p->combineRelationalElements((yyvsp[-2].astnode), (yyvsp[0].astnode), AST_RELATIONAL_LT);}
#line 1776 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 19:
#line 483 "L3Parser.ypp" /* yacc.c:1646  */
    {(yyval.astnode) = l3p->combineRelationalElements((yyvsp[-3].astnode), (yyvsp[0].astnode), AST_RELATIONAL_GEQ);}
#line 1782 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 20:
#line 484 "L3Parser.ypp" /* yacc.c:1646  */
    {(yyval.astnode) = l3p->combineRelationalElements((yyvsp[-3].astnode), (yyvsp[0].astnode), AST_RELATIONAL_LEQ);}
#line 1788 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 21:
#line 485 "L3Parser.ypp" /* yacc.c:1646  */
    {(yyval.astnode) = l3p->combineRelationalElements((yyvsp[-3].astnode), (yyvsp[0].astnode), AST_RELATIONAL_EQ);}
#line 1794 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 22:
#line 486 "L3Parser.ypp" /* yacc.c:1646  */
    {(yyval.astnode) = l3p->combineRelationalElements((yyvsp[-3].astnode), (yyvsp[0].astnode), AST_RELATIONAL_NEQ);}
#line 1800 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 23:
#line 487 "L3Parser.ypp" /* yacc.c:1646  */
    {(yyval.astnode) = l3p->combineRelationalElements((yyvsp[-3].astnode), (yyvsp[0].astnode), AST_RELATIONAL_NEQ);}
#line 1806 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 24:
#line 488 "L3Parser.ypp" /* yacc.c:1646  */
    {(yyval.astnode) = l3p->combineRelationalElements((yyvsp[-3].astnode), (yyvsp[0].astnode), AST_RELATIONAL_NEQ);}
#line 1812 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 25:
#line 489 "L3Parser.ypp" /* yacc.c:1646  */
    {
                  if ((yyvsp[-3].astnode)->getType()==AST_LOGICAL_AND) {
                    (yyval.astnode) = (yyvsp[-3].astnode);
                    (yyval.astnode)->addChild((yyvsp[0].astnode));
                  }
                  else {
                    (yyval.astnode) = new ASTNode(AST_LOGICAL_AND);
                    (yyval.astnode)->addChild((yyvsp[-3].astnode));
                    (yyval.astnode)->addChild((yyvsp[0].astnode));
                  }
                }
#line 1828 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 26:
#line 500 "L3Parser.ypp" /* yacc.c:1646  */
    {
                  if ((yyvsp[-3].astnode)->getType()==AST_LOGICAL_OR) {
                    (yyval.astnode) = (yyvsp[-3].astnode);
                    (yyval.astnode)->addChild((yyvsp[0].astnode));
                  }
                  else {
                    (yyval.astnode) = new ASTNode(AST_LOGICAL_OR);
                    (yyval.astnode)->addChild((yyvsp[-3].astnode));
                    (yyval.astnode)->addChild((yyvsp[0].astnode));
                  }
                }
#line 1844 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 27:
#line 511 "L3Parser.ypp" /* yacc.c:1646  */
    {(yyval.astnode) = new ASTNode(AST_LOGICAL_NOT); (yyval.astnode)->addChild((yyvsp[0].astnode));}
#line 1850 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 28:
#line 512 "L3Parser.ypp" /* yacc.c:1646  */
    {
                   (yyval.astnode) = new ASTNode(AST_FUNCTION);
                   string name(*(yyvsp[-2].word));
                   (yyval.astnode)->setName((yyvsp[-2].word)->c_str());
                   if (l3p->model == NULL || l3p->model->getFunctionDefinition(name) == NULL) {
                     //The symbol is not used in any other mathematical context in the SBML model, so we can see if it matches a list of pre-defined names
                     ASTNodeType_t type = l3p->getFunctionFor(name);
                     if (type != AST_UNKNOWN) (yyval.astnode)->setType(type);
                     if (type == AST_LAMBDA) l3p->fixLambdaArguments((yyval.astnode));
                     if (l3p->checkNumArguments((yyval.astnode))) YYABORT;
                   }
        }
#line 1867 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 29:
#line 524 "L3Parser.ypp" /* yacc.c:1646  */
    {
                   (yyval.astnode) = (yyvsp[-1].astnode);
                   string name(*(yyvsp[-3].word));
                   (yyval.astnode)->setName((yyvsp[-3].word)->c_str());
                   (yyval.astnode)->setType(AST_FUNCTION);
                   ASTNodeType_t type = l3p->getFunctionFor(name);
                   if (l3p->model == NULL || l3p->model->getFunctionDefinition(name) == NULL) {
                     //The symbol is not used in any other mathematical context in the SBML model, so we can see if it matches a list of pre-defined names
                     if (type != AST_UNKNOWN) (yyval.astnode)->setType(type);
                     if (type==AST_FUNCTION_ROOT && l3p->l3StrCmp(name, "sqrt")) {
                       //If the number of arguments is wrong, set an error now instead of waiting for later.
                       if ((yyval.astnode)->getNumChildren() != 1) {
                         l3p->setError("The function 'sqrt' takes exactly one argument.");
                         delete (yyval.astnode);
                         YYABORT;
                       }
                       //Add a '2' node before the existing child.
                       ASTNode* int2 = new ASTNode(AST_INTEGER);
                       int2->setValue(2);
                       (yyval.astnode)->prependChild(int2);
                     }
                     if (type==AST_FUNCTION_POWER && l3p->l3StrCmp(name, "sqr")) {
                       //Add a '2' node after the existing child.
                       ASTNode* int2 = new ASTNode(AST_INTEGER);
                       int2->setValue(2);
                       (yyval.astnode)->addChild(int2);
                     }
                     if (type==AST_FUNCTION_LOG && l3p->l3StrCmp(name, "log10")) {
                       //Add a '10' node before the existing child.
                       ASTNode* int10 = new ASTNode(AST_INTEGER);
                       int10->setValue(10);
                       (yyval.astnode)->prependChild(int10);
                     }
                     if (type==AST_FUNCTION_LOG && l3p->l3StrCmp(name, "log")) {
                       //If there is exactly one argument, change it to log10, ln, or give a special error message, depending on a user setting (by default, parse to log10).
                       if ((yyval.astnode)->getNumChildren() == 1) {
                         ASTNode* int10;
                         switch(l3p->parselog) {
                         case L3P_PARSE_LOG_AS_LOG10:
                           int10 = new ASTNode(AST_INTEGER);
                           int10->setValue(10);
                           (yyval.astnode)->prependChild(int10);
                           break;
                         case L3P_PARSE_LOG_AS_LN:
                           (yyval.astnode)->setType(AST_FUNCTION_LN);
                           break;
                         case L3P_PARSE_LOG_AS_ERROR:
                           l3p->setError("Writing a function as 'log(x)' was legal in the L1 parser, but translated as the natural log, not the base-10 log.  This construct is disallowed entirely as being ambiguous, and you are encouraged instead to use 'ln(x)', 'log10(x)', or 'log(base, x)'.");
                           delete (yyval.astnode);
                           YYABORT;
                         }
                       }
                     }
                   }
                   if (type == AST_LAMBDA) l3p->fixLambdaArguments((yyval.astnode));
                   if (l3p->checkNumArguments((yyval.astnode))) YYABORT;
        }
#line 1929 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 30:
#line 581 "L3Parser.ypp" /* yacc.c:1646  */
    {
                  vector<ASTNode*> allnodes;
                  allnodes.push_back((yyvsp[-3].astnode));
                  allnodes.push_back((yyvsp[-1].astnode));
                  (yyval.astnode) = l3p->parsePackageInfix(INFIX_SYNTAX_NAMED_SQUARE_BRACKETS, &allnodes);
                  if ((yyval.astnode) == NULL) {
                    l3p->setError("No package is enabled that can interpret vectors, so formulas of the form 'x[y]' are disallowed.");
                    delete((yyvsp[-3].astnode));
                    delete((yyvsp[-1].astnode));
                    YYERROR;
                  }
                  if (l3p->checkNumArgumentsForPackage((yyval.astnode))) YYABORT;
                }
#line 1947 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 31:
#line 594 "L3Parser.ypp" /* yacc.c:1646  */
    {
                  vector<ASTNode*> allnodes;
                  allnodes.push_back((yyvsp[-2].astnode));
                  (yyval.astnode) = l3p->parsePackageInfix(INFIX_SYNTAX_NAMED_SQUARE_BRACKETS, &allnodes);
                  if ((yyval.astnode) == NULL) {
                    l3p->setError("No package is enabled that can interpret vectors, so formulas of the form 'x[]' are disallowed.");
                    delete ((yyvsp[-2].astnode));
                    YYERROR;
                  }
                  if (l3p->checkNumArgumentsForPackage((yyval.astnode))) YYABORT;
                }
#line 1963 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 32:
#line 605 "L3Parser.ypp" /* yacc.c:1646  */
    {
                  vector<ASTNode*> allnodes;
                  allnodes.push_back((yyvsp[-1].astnode));
                  (yyval.astnode) = l3p->parsePackageInfix(INFIX_SYNTAX_CURLY_BRACES, &allnodes);
                  if ((yyval.astnode) == NULL) {
                    l3p->setError("No package is enabled that can interpret curly braces, so formulas of the form '{x, y}' are disallowed.");
                    delete((yyvsp[-1].astnode));
                    YYERROR;
                  }
                  if (l3p->checkNumArgumentsForPackage((yyval.astnode))) YYABORT;
                }
#line 1979 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 33:
#line 616 "L3Parser.ypp" /* yacc.c:1646  */
    {
                  vector<ASTNode*> allnodes;
                  allnodes.push_back((yyvsp[-1].astnode));
                  (yyval.astnode) = l3p->parsePackageInfix(INFIX_SYNTAX_CURLY_BRACES_SEMICOLON, &allnodes);
                  if ((yyval.astnode) == NULL) {
                    l3p->setError("No package is enabled that can interpret curly braces with semicolon-delimited lists, so formulas of the form '{x, y; p, q}' are disallowed.");
                    delete((yyvsp[-1].astnode));
                    YYERROR;
                  }
                  if (l3p->checkNumArgumentsForPackage((yyval.astnode))) YYABORT;
                }
#line 1995 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 34:
#line 627 "L3Parser.ypp" /* yacc.c:1646  */
    {
                  (yyval.astnode) = l3p->parsePackageInfix(INFIX_SYNTAX_CURLY_BRACES);
                  if ((yyval.astnode) == NULL) {
                    l3p->setError("No package is enabled that can interpret empty curly braces, so formulas of the form '{}' are disallowed.");
                    YYERROR;
                  }
                  if (l3p->checkNumArgumentsForPackage((yyval.astnode))) YYABORT;
                }
#line 2008 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 35:
#line 637 "L3Parser.ypp" /* yacc.c:1646  */
    {
                  (yyval.astnode) = new ASTNode(); 
                  (yyval.astnode)->setValue((yyvsp[0].numdouble)); 
//                  if(l3p->useDimensionless) {
//                    $$->setUnits("dimensionless");
//                  }
                }
#line 2020 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 36:
#line 644 "L3Parser.ypp" /* yacc.c:1646  */
    {
                  (yyval.astnode) = new ASTNode();
                  (yyval.astnode)->setValue((yyvsp[0].mantissa), l3p->exponent); 
//                  if(l3p->useDimensionless) {
//                    $$->setUnits("dimensionless");
//                  }
                }
#line 2032 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 37:
#line 651 "L3Parser.ypp" /* yacc.c:1646  */
    {
                  (yyval.astnode) = new ASTNode(); 
                  (yyval.astnode)->setValue((yyvsp[0].numlong)); 
//                  if(l3p->useDimensionless) {
//                    $$->setUnits("dimensionless");
//                  }
                }
#line 2044 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 38:
#line 658 "L3Parser.ypp" /* yacc.c:1646  */
    {
                  (yyval.astnode) = new ASTNode(); 
                  (yyval.astnode)->setValue((yyvsp[0].rational), l3p->denominator);
//                  if(l3p->useDimensionless) {
//                    $$->setUnits("dimensionless");
//                  }
                }
#line 2056 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 39:
#line 665 "L3Parser.ypp" /* yacc.c:1646  */
    {
                  (yyval.astnode) = (yyvsp[-1].astnode);
                  if ((yyval.astnode)->getUnits() != "") {
                    l3p->setError("Can't use " + *(yyvsp[0].word) + " as a unit, because the unit is already set for this number.");
                    delete (yyval.astnode);
                    YYERROR;
                  }
                  if (!l3p->parseunits) {
                    l3p->setError("The ability to associate units with numbers has been disabled.");
                    delete (yyval.astnode);
                    YYERROR;
                  }
                  (yyval.astnode)->setUnits(*(yyvsp[0].word));
               }
#line 2075 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 40:
#line 681 "L3Parser.ypp" /* yacc.c:1646  */
    {(yyval.astnode) = new ASTNode(AST_FUNCTION); (yyval.astnode)->addChild((yyvsp[0].astnode));}
#line 2081 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 41:
#line 682 "L3Parser.ypp" /* yacc.c:1646  */
    {(yyval.astnode) = (yyvsp[-2].astnode);  (yyval.astnode)->addChild((yyvsp[0].astnode));}
#line 2087 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 42:
#line 685 "L3Parser.ypp" /* yacc.c:1646  */
    {(yyval.astnode) = new ASTNode(AST_FUNCTION); (yyval.astnode)->addChild((yyvsp[-2].astnode)); (yyval.astnode)->addChild((yyvsp[0].astnode));}
#line 2093 "L3Parser.cpp" /* yacc.c:1646  */
    break;

  case 43:
#line 686 "L3Parser.ypp" /* yacc.c:1646  */
    {(yyval.astnode) = (yyvsp[-2].astnode);  (yyval.astnode)->addChild((yyvsp[0].astnode));}
#line 2099 "L3Parser.cpp" /* yacc.c:1646  */
    break;


#line 2103 "L3Parser.cpp" /* yacc.c:1646  */
      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYEMPTY : YYTRANSLATE (yychar);

  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
# define YYSYNTAX_ERROR yysyntax_error (&yymsg_alloc, &yymsg, \
                                        yyssp, yytoken)
      {
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = YYSYNTAX_ERROR;
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == 1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = (char *) YYSTACK_ALLOC (yymsg_alloc);
            if (!yymsg)
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = 2;
              }
            else
              {
                yysyntax_error_status = YYSYNTAX_ERROR;
                yymsgp = yymsg;
              }
          }
        yyerror (yymsgp);
        if (yysyntax_error_status == 2)
          goto yyexhaustedlab;
      }
# undef YYSYNTAX_ERROR
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYTERROR;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  yystos[yystate], yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined yyoverflow || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  yystos[*yyssp], yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  return yyresult;
}
#line 689 "L3Parser.ypp" /* yacc.c:1906  */



void sbml_yyerror(char const *s)
{
  l3p->setError(s);
}

int sbml_yylex(void)
{
  char cc = 0;
  l3p->input.get(cc);

  //If we're done with the input:
  if (l3p->input.eof()) {
    return 0;
  }
  //If something else went wrong:
  if (!l3p->input.good()) {
    l3p->setError("The input is no longer good, for an unknown reason.");
    return -1;
  }

  // Skip white space.
  while ((cc == ' ' || cc == '\t' || cc == '\n' || cc == '\r')
         && !l3p->input.eof()) {
    l3p->input.get(cc);
  }
  if (l3p->input.eof()) return 0;

  // Parse words
  if (isalpha(cc) || cc == '_') {
    string word;
    while ((isalpha(cc) || isdigit(cc) || cc == '_') && !l3p->input.eof()) {
      word += cc;
      l3p->input.get(cc);
    }
    if (!l3p->input.eof()) {
      l3p->input.unget();
    }
    sbml_yylval.word = l3p->addWord(word);
    //cout << "\tRead word '" << word << "'." << endl;
    return SYMBOL;
  }

  // Parse numbers
  if (isdigit(cc) || (cc=='.' && isdigit(l3p->input.peek()))) {
    double number;
    long numlong;
    l3p->input.unget();
    streampos numbegin = l3p->input.tellg();
    l3p->input >> numlong;
    l3p->input.clear();
    l3p->input.seekg(numbegin);
    l3p->input >> number;
    if (l3p->input.fail()) {
      //The only reason I know of for this to happen is that there was a number followed by an 'e'.
      l3p->input.clear(); //clear the error.
      l3p->input.seekg(numbegin);
      string failnum = "";
      cc = l3p->input.get();
      while (l3p->input.good() && (isdigit(cc) || cc=='.')) {
        failnum += cc;
        cc = l3p->input.get();
      }
      if (cc=='e' || cc=='E') {
        l3p->input.unget();
        //We're going to call yylex recursively here, so we need to swap out l3p->input
        streampos numend = l3p->input.tellg();
        string tempinput = l3p->input.str();
        l3p->input.str(failnum);
        int ret = sbml_yylex();
        l3p->input.str(tempinput);
        l3p->input.clear();
        l3p->input.seekg(numend);
        return ret;
      }
      //Something weird went wrong; give up.
      return -1;
    }
    streampos numend = l3p->input.tellg();
    l3p->input.clear();
    l3p->input.seekg(numbegin);
    bool decimal = false;
    bool e = false;
    bool last_e = false;
    while (l3p->input.tellg() != numend) {
      cc = l3p->input.get();
      if (cc=='.') {
        decimal = true;
      }
      if (cc=='e' || cc=='E') {
        e = true;
        last_e = true;
      }
      else {
        last_e = false;
      }
    }
    if (last_e) {
       e = false;
       l3p->input.unget();
    }
    if (!decimal && !e && number == static_cast<double>(numlong) && numlong <= SBML_INT_MAX) {
      sbml_yylval.numlong = numlong;
      return INTEGER;
    }
    if (!e) {
      sbml_yylval.numdouble = number;
      return DOUBLE;
    }
    l3p->input.clear();
    l3p->input.seekg(numbegin);
    cc = l3p->input.get();
    string mantissa = "";
    while (l3p->input.tellg() != numend && (isdigit(cc) || cc=='.')) {
      mantissa += cc;
      cc = l3p->input.get();
    }
    if (cc=='e' || cc=='E') {
      if (l3p->input.peek()=='+') {
        cc = l3p->input.get();
      }
      bool isneg = false;
      if (l3p->input.peek()=='-') {
        cc = l3p->input.get();
        isneg = true;
      }
      l3p->input >> numlong;
      if (isneg) {
        numlong = -numlong;
      }
      stringstream mantissastr;
      mantissastr.str(mantissa);
      mantissastr >> number;
      l3p->exponent = numlong;
      sbml_yylval.mantissa = number;
      return E_NOTATION;
    }
    else {
      assert(false); //How did this happen?
      //This is an error condition, but parsing the value as a double should be sufficient.
      sbml_yylval.numdouble = number;
      return DOUBLE;
    }
  }
  else if (cc=='(') {
    streampos rationalbegin = l3p->input.tellg();
    cc = l3p->input.get();
    if ((cc== '-' && isdigit(l3p->input.peek())) || isdigit(cc)) {
      l3p->input.unget();
      long numerator;
      l3p->input >> numerator;
      cc = l3p->input.get();
      if (cc=='/') {
        cc = l3p->input.get();
        if ((cc== '-' && isdigit(l3p->input.peek())) || isdigit(cc)) {
          l3p->input.unget();
          long denominator;
          l3p->input >> denominator; 
          cc = l3p->input.get();
          if (cc==')') {
            //Actually a rational number!
            sbml_yylval.rational = numerator;
            l3p->denominator = denominator;
            return RATIONAL;
          }
        }
      }
    }
    l3p->input.clear();
    l3p->input.seekg(rationalbegin, ios::beg); // Not actually a rational number.
    return '(';
  }

  //Otherwise, return the character we are looking at (like '*', '+', etc.
  return cc;
}

L3Parser::L3Parser()
  : input()
  , outputNode(NULL)
  , error()
  , words()
  , exponent(0)
  , denominator(0)
  , defaultL3ParserSettings()
  , model(NULL)
  , parselog(L3P_PARSE_LOG_AS_LOG10)
  , collapseminus(L3P_EXPAND_UNARY_MINUS)
  , parseunits(L3P_PARSE_UNITS)
  , avocsymbol(L3P_AVOGADRO_IS_CSYMBOL)
  , strCmpIsCaseSensitive(L3P_COMPARE_BUILTINS_CASE_SENSITIVE)
  , modulol3v2(L3P_MODULO_IS_PIECEWISE)
{
}

L3Parser::~L3Parser ()
{
  for (map<string, string*>::iterator word = words.begin(); word != words.end(); word++) {
    delete (*word).second;
  }
}

ASTNodeType_t L3Parser::getSymbolFor(string name) const
{
  if (l3StrCmp(name, "true"))         return AST_CONSTANT_TRUE;
  if (l3StrCmp(name, "false"))        return AST_CONSTANT_FALSE;
  if (l3StrCmp(name, "pi"))           return AST_CONSTANT_PI;
  if (l3StrCmp(name, "exponentiale")) return AST_CONSTANT_E;
  if (l3StrCmp(name, "avogadro"))     return AST_NAME_AVOGADRO;
  if (l3StrCmp(name, "time"))         return AST_NAME_TIME;
  if (l3StrCmp(name, "inf"))          return AST_REAL;
  if (l3StrCmp(name, "infinity"))     return AST_REAL;
  if (l3StrCmp(name, "nan"))          return AST_REAL;
  if (l3StrCmp(name, "notanumber"))   return AST_REAL;
 
  return currentSettings->getPackageFunctionFor(name);
}

ASTNodeType_t L3Parser::getFunctionFor(string name) const
{
  if (l3StrCmp(name, "abs"))      return AST_FUNCTION_ABS;
  if (l3StrCmp(name, "acos"))     return AST_FUNCTION_ARCCOS;
  if (l3StrCmp(name, "arccos"))   return AST_FUNCTION_ARCCOS;
  if (l3StrCmp(name, "acosh"))    return AST_FUNCTION_ARCCOSH;
  if (l3StrCmp(name, "arccosh"))  return AST_FUNCTION_ARCCOSH;
  if (l3StrCmp(name, "acot"))     return AST_FUNCTION_ARCCOT;
  if (l3StrCmp(name, "arccot"))   return AST_FUNCTION_ARCCOT;
  if (l3StrCmp(name, "acoth"))    return AST_FUNCTION_ARCCOTH;
  if (l3StrCmp(name, "arccoth"))  return AST_FUNCTION_ARCCOTH;
  if (l3StrCmp(name, "acsc"))     return AST_FUNCTION_ARCCSC;
  if (l3StrCmp(name, "arccsc"))   return AST_FUNCTION_ARCCSC;
  if (l3StrCmp(name, "acsch"))    return AST_FUNCTION_ARCCSCH;
  if (l3StrCmp(name, "arccsch"))  return AST_FUNCTION_ARCCSCH;
  if (l3StrCmp(name, "asec"))     return AST_FUNCTION_ARCSEC;
  if (l3StrCmp(name, "arcsec"))   return AST_FUNCTION_ARCSEC;
  if (l3StrCmp(name, "asech"))    return AST_FUNCTION_ARCSECH;
  if (l3StrCmp(name, "arcsech"))  return AST_FUNCTION_ARCSECH;
  if (l3StrCmp(name, "asin"))     return AST_FUNCTION_ARCSIN;
  if (l3StrCmp(name, "arcsin"))   return AST_FUNCTION_ARCSIN;
  if (l3StrCmp(name, "asinh"))    return AST_FUNCTION_ARCSINH;
  if (l3StrCmp(name, "arcsinh"))  return AST_FUNCTION_ARCSINH;
  if (l3StrCmp(name, "atan"))     return AST_FUNCTION_ARCTAN;
  if (l3StrCmp(name, "arctan"))   return AST_FUNCTION_ARCTAN;
  if (l3StrCmp(name, "atanh"))    return AST_FUNCTION_ARCTANH;
  if (l3StrCmp(name, "arctanh"))  return AST_FUNCTION_ARCTANH;
  if (l3StrCmp(name, "ceil"))     return AST_FUNCTION_CEILING;
  if (l3StrCmp(name, "ceiling"))  return AST_FUNCTION_CEILING;
  if (l3StrCmp(name, "cos"))      return AST_FUNCTION_COS;
  if (l3StrCmp(name, "cosh"))     return AST_FUNCTION_COSH;
  if (l3StrCmp(name, "cot"))      return AST_FUNCTION_COT;
  if (l3StrCmp(name, "coth"))     return AST_FUNCTION_COTH;
  if (l3StrCmp(name, "csc"))      return AST_FUNCTION_CSC;
  if (l3StrCmp(name, "csch"))     return AST_FUNCTION_CSCH;
  if (l3StrCmp(name, "delay"))    return AST_FUNCTION_DELAY;
  if (l3StrCmp(name, "exp"))      return AST_FUNCTION_EXP;
  if (l3StrCmp(name, "factorial")) return AST_FUNCTION_FACTORIAL;
  if (l3StrCmp(name, "floor"))    return AST_FUNCTION_FLOOR;
  if (l3StrCmp(name, "lambda"))   return AST_LAMBDA;
  if (l3StrCmp(name, "log"))      return AST_FUNCTION_LOG;
  if (l3StrCmp(name, "ln"))       return AST_FUNCTION_LN;
  if (l3StrCmp(name, "log10"))    return AST_FUNCTION_LOG;
  if (l3StrCmp(name, "piecewise")) return AST_FUNCTION_PIECEWISE;
  if (l3StrCmp(name, "power"))    return AST_POWER;
  if (l3StrCmp(name, "pow"))      return AST_POWER;
  if (l3StrCmp(name, "sqr"))      return AST_FUNCTION_POWER;
  if (l3StrCmp(name, "sqrt"))     return AST_FUNCTION_ROOT;
  if (l3StrCmp(name, "root"))     return AST_FUNCTION_ROOT;
  if (l3StrCmp(name, "sec"))      return AST_FUNCTION_SEC;
  if (l3StrCmp(name, "sech"))     return AST_FUNCTION_SECH;
  if (l3StrCmp(name, "sin"))      return AST_FUNCTION_SIN;
  if (l3StrCmp(name, "sinh"))     return AST_FUNCTION_SINH;
  if (l3StrCmp(name, "tan"))      return AST_FUNCTION_TAN;
  if (l3StrCmp(name, "tanh"))     return AST_FUNCTION_TANH;
  if (l3StrCmp(name, "and"))      return AST_LOGICAL_AND;
  if (l3StrCmp(name, "not"))      return AST_LOGICAL_NOT;
  if (l3StrCmp(name, "or"))       return AST_LOGICAL_OR;
  if (l3StrCmp(name, "xor"))      return AST_LOGICAL_XOR;
  if (l3StrCmp(name, "eq"))       return AST_RELATIONAL_EQ;
  if (l3StrCmp(name, "equals"))   return AST_RELATIONAL_EQ;
  if (l3StrCmp(name, "geq"))      return AST_RELATIONAL_GEQ;
  if (l3StrCmp(name, "gt"))       return AST_RELATIONAL_GT;
  if (l3StrCmp(name, "leq"))      return AST_RELATIONAL_LEQ;
  if (l3StrCmp(name, "lt"))       return AST_RELATIONAL_LT;
  if (l3StrCmp(name, "neq"))      return AST_RELATIONAL_NEQ;
  if (l3StrCmp(name, "divide"))   return AST_DIVIDE;
  if (l3StrCmp(name, "minus"))    return AST_MINUS;
  if (l3StrCmp(name, "plus"))     return AST_PLUS;
  if (l3StrCmp(name, "times"))    return AST_TIMES;

  return currentSettings->getPackageFunctionFor(name);
}

ASTNode* L3Parser::createModuloTree(ASTNode* x, ASTNode* y) const
{
  if (x==NULL || y==NULL) return NULL;
  ASTNode* pASTNode = new ASTNode(); 
  //The following code was lifted wholesale from Copasi's  CEvaluationNodeOperator::createModuloTree.  Thanks, Copasi!

  // Frank noticed that this should actually be implemented as a
  // piecewise function because if one of the arguments is
  // negative, the definition is different
  pASTNode->setType(AST_FUNCTION_PIECEWISE);
  // the first child is the true branch
  // x%y -> x-ceil(x/y)*y
  ASTNode* pASTNodeTrue = new ASTNode();
  pASTNodeTrue->setType(AST_MINUS);
  ASTNode* tmpASTNode = new ASTNode(AST_DIVIDE);
  tmpASTNode->addChild(x);
  tmpASTNode->addChild(y);
  ASTNode* tmpASTNode2 = new ASTNode(AST_FUNCTION_CEILING);
  tmpASTNode2->addChild(tmpASTNode);
  tmpASTNode = new ASTNode(AST_TIMES);
  tmpASTNode->addChild(new ASTNode(*y));
  tmpASTNode->addChild(tmpASTNode2);
  pASTNodeTrue->addChild(new ASTNode(*x));
  pASTNodeTrue->addChild(tmpASTNode);
  pASTNode->addChild(pASTNodeTrue);
  // now comes the condition
  // if exactly one of the arguments to modulo is a negative number
  // we use the ceil branch, else we use the floor branch
  // x < 0 xor y < 0
  // xor
  ASTNode* pASTNodeCondition = new ASTNode();
  pASTNodeCondition->setType(AST_LOGICAL_XOR);
  // x < 0
  // <
  tmpASTNode = new ASTNode(AST_RELATIONAL_LT);
  // x
  tmpASTNode->addChild(new ASTNode(*x));
  // 0
  tmpASTNode2 = new ASTNode(AST_INTEGER);
  tmpASTNode2->setValue(0);
  tmpASTNode->addChild(tmpASTNode2);
  pASTNodeCondition->addChild(tmpASTNode);
  // y < 0
  // <
  tmpASTNode = new ASTNode(AST_RELATIONAL_LT);
  // y
  tmpASTNode->addChild(new ASTNode(*y));
  // 0
  tmpASTNode2 = new ASTNode(AST_INTEGER);
  tmpASTNode2->setValue(0);
  tmpASTNode->addChild(tmpASTNode2);
  pASTNodeCondition->addChild(tmpASTNode);
  pASTNode->addChild(pASTNodeCondition);
  // last is the false branch
  // x%y -> x-floor(x/y)*y
  ASTNode* pASTNodeFalse = new ASTNode();
  pASTNodeFalse->setType(AST_MINUS);
  tmpASTNode = new ASTNode(AST_DIVIDE);
  tmpASTNode->addChild(new ASTNode(*x));
  tmpASTNode->addChild(new ASTNode(*y));
  tmpASTNode2 = new ASTNode(AST_FUNCTION_FLOOR);
  tmpASTNode2->addChild(tmpASTNode);
  tmpASTNode = new ASTNode(AST_TIMES);
  tmpASTNode->addChild(new ASTNode(*y));
  tmpASTNode->addChild(tmpASTNode2);
  pASTNodeFalse->addChild(new ASTNode(*x));
  pASTNodeFalse->addChild(tmpASTNode);
  pASTNode->addChild(pASTNodeFalse);
  return pASTNode;
}

void L3Parser::setParseLog(ParseLogType_t parseas)
{
  parselog = parseas;
}

void L3Parser::setCollapseMinus(bool collapse)
{
  collapseminus = collapse;
}

void L3Parser::setParseUnits(bool units)
{
  parseunits = units;
}

void L3Parser::setAvoCsymbol(bool avo)
{
  avocsymbol = avo;
}

void L3Parser::setComparisonCaseSensitivity(bool strcmp)
{
  strCmpIsCaseSensitive = strcmp;
}

void L3Parser::setModuloL3v2(bool ml3v2)
{
  modulol3v2 = ml3v2;
}

bool L3Parser::l3StrCmp(const string& lhs, const string& rhs) const
{
  if (strCmpIsCaseSensitive) {
    return lhs==rhs;
  }
  if (lhs.size() != rhs.size()) return false;

  for (size_t i = 0; i < lhs.size(); ++i) {
    if (toupper(lhs[i]) != toupper(rhs[i])) return false;
  }
  return true;

}

void L3Parser::setInput(const char* c)
{
  input.clear();
  if (c == NULL) 
  {
    setError("NULL input.");
    return;
  }
  input.str(c);
}

void L3Parser::setError(const char* c)
{
  if (c == NULL) return;
  string err = c;
  setError(err);
}

void L3Parser::setError(const string& c)
{
  stringstream err;
  streampos position = input.tellg();
  if (position== (streampos)-1) {
    position = input.str().size();
  }
  err << "Error when parsing input '" << input.str() << "' at position " << position << ":  " << c;
  error = err.str();
}

void L3Parser::clear()
{
  input.clear();
  input.str("");
  outputNode = NULL;
  error = "";
  model = defaultL3ParserSettings.getModel();
  parselog = defaultL3ParserSettings.getParseLog();
  collapseminus = defaultL3ParserSettings.getParseCollapseMinus();
  parseunits = defaultL3ParserSettings.getParseUnits();
  avocsymbol = defaultL3ParserSettings.getParseAvogadroCsymbol();
  strCmpIsCaseSensitive = defaultL3ParserSettings.getComparisonCaseSensitivity();
  modulol3v2 = defaultL3ParserSettings.getParseModuloL3v2();
}

string L3Parser::getError()
{
  return error;
}
    
string* L3Parser::addWord(const std::string& word)
{
  //cout << "The word is: " << word << endl;
  map<string, string*>::iterator found = words.find(word);
  if (found != words.end()) {
    return (*found).second;
  }
  else {
    string* savedword = new string(word);
    words.insert(make_pair(word, savedword));
    return savedword;
  }
}

bool L3Parser::checkNumArguments(const ASTNode* function)
{
  unsigned int children = function->getNumChildren();
  stringstream error;
  string name = "";
  if (function->isOperator()) {
    name = function->getOperatorName();
  }
  else {
    name = function->getName();
  }
  error << "The function '" << name << "' takes ";
  string errmsg = "";
  ASTNodeType_t type = function->getType(); 
  switch(type) 
  {
  case AST_FUNCTION_ABS:
  case AST_FUNCTION_ARCCOS:
  case AST_FUNCTION_ARCCOSH:
  case AST_FUNCTION_ARCCOT:
  case AST_FUNCTION_ARCCOTH:
  case AST_FUNCTION_ARCCSC:
  case AST_FUNCTION_ARCCSCH:
  case AST_FUNCTION_ARCSEC:
  case AST_FUNCTION_ARCSECH:
  case AST_FUNCTION_ARCSIN:
  case AST_FUNCTION_ARCSINH:
  case AST_FUNCTION_ARCTAN:
  case AST_FUNCTION_ARCTANH:
  case AST_FUNCTION_CEILING:
  case AST_FUNCTION_COS:
  case AST_FUNCTION_COSH:
  case AST_FUNCTION_COT:
  case AST_FUNCTION_COTH:
  case AST_FUNCTION_CSC:
  case AST_FUNCTION_CSCH:
  case AST_FUNCTION_EXP:
  case AST_FUNCTION_FACTORIAL:
  case AST_FUNCTION_FLOOR:
  case AST_FUNCTION_LN:
  case AST_FUNCTION_SEC:
  case AST_FUNCTION_SECH:
  case AST_FUNCTION_SIN:
  case AST_FUNCTION_SINH:
  case AST_FUNCTION_TAN:
  case AST_FUNCTION_TANH:
  case AST_LOGICAL_NOT:

    if (children != 1) {
      error << "exactly one argument, but " << children << " were found.";
      l3p->setError(error.str());
      delete function;
      return true;
    }
    return false;
  case AST_DIVIDE:
  case AST_FUNCTION_DELAY:
  case AST_FUNCTION_LOG:       // a log ASTNode has a child for base
  case AST_FUNCTION_POWER:
  case AST_POWER:
  case AST_RELATIONAL_NEQ:

    if (children != 2) {
      error << "exactly two arguments, but " << children << " were found.";
      l3p->setError(error.str());
      delete function;
      return true;
    }
    return false;

  case AST_RELATIONAL_EQ:
  case AST_RELATIONAL_GEQ:
  case AST_RELATIONAL_GT:
  case AST_RELATIONAL_LEQ:
  case AST_RELATIONAL_LT:
    if (children <= 1) {
      error << "at least two arguments, but " << children << " were found.";
      l3p->setError(error.str());
      delete function;
      return true;
    }
    return false;

  case AST_FUNCTION_PIECEWISE:
  case AST_LAMBDA:
    if (children == 0) {
      error << "at least one argument, but none were found.";
      l3p->setError(error.str());
      delete function;
      return true;
    }
    return false;

  case AST_FUNCTION_ROOT:
  case AST_MINUS:
    if (children < 1 || children > 2) {
      error << "exactly one or two arguments, but " << children << " were found.";
      l3p->setError(error.str());
      delete function;
      return true;
    }
    return false;
      
  case AST_TIMES:
  case AST_PLUS:
  case AST_LOGICAL_AND:
  case AST_LOGICAL_OR:
  case AST_LOGICAL_XOR:
    return false;
  default:
    {
      error.str("");
      bool ret = currentSettings->checkNumArgumentsForPackage(function, error);
      if (ret)
      {
        l3p->setError(error.str());
        delete function;
      }
      return ret;
    }
    //Otherwise, we'll assume that the function is n-ary and takes 0 or more arguments
    return false;
  }
}

void makeConstantIntoName(ASTNodeType_t type, ASTNode* function)
{
  if (function->getType() == type) {
    function->setType(AST_NAME);
    function->setDefinitionURL("");
    switch(type) {
    case AST_CONSTANT_TRUE:
      function->setName("true");
      break;
    case AST_CONSTANT_FALSE:
      function->setName("false");
      break;
    case AST_CONSTANT_PI:
      function->setName("pi");
      break;
    case AST_CONSTANT_E:
      function->setName("exponentiale");
      break;
    default:
      break;
    }
  }
  for (unsigned int c=0; c<function->getNumChildren(); c++) {
    makeConstantIntoName(type, function->getChild(c));
  }
}

void L3Parser::fixLambdaArguments(const ASTNode* function)
{
  if (function->getType() != AST_LAMBDA) {
    return;
  }
  unsigned int nchildren = function->getNumChildren();
  if (nchildren==0) {
    return;
  }
  std::set<ASTNodeType_t> fixList;
  for (unsigned int c=0; c<nchildren-1; c++) {
    ASTNode* child = function->getChild(c);
    ASTNodeType_t ctype = child->getType(); 
    switch(ctype) {
    case AST_CONSTANT_TRUE:
    case AST_CONSTANT_FALSE:
    case AST_CONSTANT_PI:
    case AST_CONSTANT_E:
    case AST_NAME_AVOGADRO:
    case AST_NAME_TIME:
      child->setType(AST_NAME);
      child->setDefinitionURL("");
      switch(ctype) {
      case AST_CONSTANT_TRUE:
        child->setName("true");
        break;
      case AST_CONSTANT_FALSE:
        child->setName("false");
        break;
      case AST_CONSTANT_PI:
        child->setName("pi");
        break;
      case AST_CONSTANT_E:
        child->setName("exponentiale");
        break;
      default:
        break;
      }
      fixList.insert(ctype);
      break;
    default:
      break;
    }
  }
  for (set<ASTNodeType_t>::iterator ftype = fixList.begin(); ftype != fixList.end(); ftype++) {
    makeConstantIntoName(*ftype, function->getChild(nchildren-1));
  }
}

bool L3Parser::checkNumArgumentsForPackage(const ASTNode* function)
{
  stringstream error;
  bool ret = currentSettings->checkNumArgumentsForPackage(function, error);
  if (ret) {
    l3p->setError(error.str());
    delete function;
  }
  return ret;
}

ASTNode* L3Parser::combineRelationalElements(ASTNode* left, ASTNode* right, ASTNodeType_t type)
{
  //If 'left' is the same as 'type', add 'right' as a new argument.  (cf x < y < z -> lt(x, y, z))
  ASTNodeType_t leftType = left->getType();
  if (leftType == type && type != AST_RELATIONAL_NEQ)
  {
    left->addChild(right);
    return left;
  }
  //If 'left' is relational itself, make a new 'and' node and combine them:
  // x < y <= z  ->  and(x<y, y<=z)
  if (ASTNode_isRelational(left))
  {
    ASTNode* ret = new ASTNode(AST_LOGICAL_AND);
    ret->addChild(left);
    ASTNode* newrel = new ASTNode(type);
    newrel->addChild(left->getChild(left->getNumChildren()-1)->deepCopy());
    newrel->addChild(right);
    ret->addChild(newrel);
    return ret;
  }

  //Another option is that we've already done the above, and need to extend it:
  if (leftType == AST_LOGICAL_AND && left->getNumChildren() >= 2)
  {
    bool combine = true;
    ASTNode* leftchild = NULL;
    for (unsigned int lc=0; lc<left->getNumChildren(); lc++)
    {
      leftchild = left->getChild(lc);
      if (!ASTNode_isRelational(leftchild) ||
          leftchild->getNumChildren() < 2)
      {
        combine = false;
      }
    }
    if (combine)
    {
      if (leftchild->getType() == type && type != AST_RELATIONAL_NEQ) {
        //We can combine them by adding to the last entry (x < y <= z <= q)
        leftchild->addChild(right);
        return left;
      }
      ASTNode* newrel = new ASTNode(type);
      newrel->addChild(leftchild->getChild(leftchild->getNumChildren()-1)->deepCopy());
      newrel->addChild(right);
      left->addChild(newrel);
      return left;
    }
  }

  //Otherwise, we can't combine them:
  ASTNode* ret = new ASTNode(type);
  ret->addChild(left);
  ret->addChild(right);
  return ret;
}


ASTNode* L3Parser::parsePackageInfix(L3ParserGrammarLineType_t type, 
    vector<ASTNode*> *nodeList, vector<std::string*> *stringList,
    vector<double> *doubleList) const
{
  if (currentSettings == NULL) return NULL;
  return currentSettings->parsePackageInfix(type, nodeList, stringList, doubleList);
}

L3ParserSettings L3Parser::getDefaultL3ParserSettings()
{
  return defaultL3ParserSettings;
}

/** Everything above this point is internal. */
/** @endcond */

LIBSBML_CPP_NAMESPACE_BEGIN
#ifdef __cplusplus
BEGIN_C_DECLS

#endif /* __cplusplus */

/**
 * @if conly
 * @memberof ASTNode_t
 * @endif
 */
LIBSBML_EXTERN
ASTNode_t *
SBML_parseL3Formula (const char *formula)
{
  L3ParserSettings l3ps = L3Parser_getInstance()->getDefaultL3ParserSettings();
  return SBML_parseL3FormulaWithSettings(formula, &l3ps);
}


/**
 * @if conly
 * @memberof ASTNode_t
 * @endif
 */
LIBSBML_EXTERN
ASTNode_t *
SBML_parseL3FormulaWithModel (const char *formula, const Model_t * model)
{
  L3ParserSettings l3ps = L3Parser_getInstance()->getDefaultL3ParserSettings();
  l3ps.setModel(model);
  return SBML_parseL3FormulaWithSettings(formula, &l3ps);
}


/**
 * @if conly
 * @memberof ASTNode_t
 * @endif
 */
LIBSBML_EXTERN
ASTNode_t *
SBML_parseL3FormulaWithSettings (const char *formula, const L3ParserSettings_t * settings)
{
  l3p = L3Parser_getInstance();
  if (settings == NULL) {
    L3ParserSettings l3ps = l3p->getDefaultL3ParserSettings();
    return SBML_parseL3FormulaWithSettings(formula, &l3ps);
  }
  l3p->clear();
  l3p->setInput(formula);
  l3p->model = settings->getModel();
  l3p->parselog = settings->getParseLog();
  l3p->collapseminus = settings->getParseCollapseMinus();
  l3p->parseunits = settings->getParseUnits();
  l3p->avocsymbol = settings->getParseAvogadroCsymbol();
  l3p->currentSettings = settings;
  l3p->strCmpIsCaseSensitive = settings->getComparisonCaseSensitivity();
  l3p->modulol3v2 = settings->getParseModuloL3v2();
  sbml_yyparse();
  return l3p->outputNode;
}


/**
 * @if conly
 * @memberof ASTNode_t
 * @endif
 */
LIBSBML_EXTERN
L3ParserSettings_t* 
SBML_getDefaultL3ParserSettings ()
{
  return new L3ParserSettings(L3Parser_getInstance()->getDefaultL3ParserSettings());
}

/**
 * @if conly
 * @memberof ASTNode_t
 * @endif
 */
LIBSBML_EXTERN
char*
SBML_getLastParseL3Error()
{
  return safe_strdup(L3Parser_getInstance()->getError().c_str());
}

/** @cond doxygenLibsbmlInternal */

LIBSBML_EXTERN
void
SBML_deleteL3Parser()
{
  if (l3p!=NULL) 
  {
    delete l3p;
    l3p = NULL;
  }
}

/** @endcond */

END_C_DECLS
LIBSBML_CPP_NAMESPACE_END
