package org.jboss.cache.commands;

import org.jboss.cache.transaction.GlobalTransaction;

/**
 * A reversible command is one that can be rolled back.  Also typically has a reference to a {@link org.jboss.cache.transaction.GlobalTransaction}.
 *
 * @author Mircea.Markus@jboss.com
 * @author Manik Surtani (<a href="mailto:manik@jboss.org">manik@jboss.org</a>)
 * @since 2.2.0
 */
public interface ReversibleCommand extends DataCommand
{
   /**
    * Reverses a command that has already been invoked.
    *
    * <b>Important</b>: this method will be invoked at the end of interceptors chain. It should never be called directly from
    * a custom interceptor.
    */
   void rollback();

   /**
    * @return a GlobalTransaction associated with this command.
    */
   GlobalTransaction getGlobalTransaction();

   /**
    * Sets a GlobalTransaction on this command.
    *
    * @param gtx global transaction to set
    */
   void setGlobalTransaction(GlobalTransaction gtx);
}
