with GNATCOLL.Traces;   use GNATCOLL.Traces;

package body Support is

   overriding procedure Start_Of_Line
     (Self            : in out Custom_Decorator;
      Msg             : in out Msg_Strings.XString;
      Is_Continuation : Boolean)
   is
      pragma Unreferenced (Self, Is_Continuation);
   begin
      if Is_Continuation then
         Msg.Append ("       =>  ");
      else
         Msg.Append ("[timestamp]");
      end if;
   end Start_Of_Line;

   overriding procedure Before_Message
     (Self    : in out Custom_Decorator;
      Handle  : not null Logger;
      Msg     : in out Msg_Strings.XString)
   is
      pragma Unreferenced (Self);
   begin
      Msg.Append ("[predecorator]");
   end Before_Message;

   overriding procedure After_Message
     (Self    : in out Custom_Decorator;
      Handle  : not null Logger;
      Msg     : in out Msg_Strings.XString)
   is
      pragma Unreferenced (Self);
   begin
      Msg.Append ("[postdecorator]");
   end After_Message;

end Support;
