#!/bin/sh

. ../GNATCOLL_CONFIG

print_header "Ravenscar"

echo > log.txt

gprbuild -q -P ravenscar_tests.gpr

../obj/test_simple_cyclic_task
../obj/test_simple_sporadic_task
../obj/test_sporadic_server
../obj/test_sporadic_server_with_callback
../obj/test_multiple_queue_sporadic_server
../obj/test_multiple_queue_cyclic_server

tr -d '\r' < log.txt > log.txt.nocr
diff log_reference.txt log.txt.nocr >/dev/null
if [ $? -ne 0 ]; then
  print_status 1
  diff log_reference.txt log.txt.nocr
fi

rm -f log.txt log.txt.nocr
print_status 0
