/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__HARDDRIVE_HPP)
#include <HardDrive.hpp>
#endif

using namespace corelinux;

const Watt  DriveWattage(10);

//
// Default constructor throws
// exception
//

HardDrive::HardDrive( void ) throw( CompositeException )
   :
   Equipment()
{
   ; // do nothing
}

//
// Valid default constructor
//

HardDrive::HardDrive( NameCref aName )
   :
   Equipment( aName )
{
   ;  // do nothing
}

//
// Copy constructor
//

HardDrive::HardDrive( HardDriveCref aRef )
   :
   Equipment( aRef )
{
   ;  // do nothing
}

//
// Destructor
//

HardDrive::~HardDrive( void )
{
   ;  // do nothing
}

//
// Assignment operator throws exception
//

HardDriveRef   HardDrive::operator=( HardDriveCref aRef )
   throw(CORELINUX(CompositeException))
{
   Equipment::operator=(aRef);
   return (*this);
}

//
// Equality operator overload
//

bool  HardDrive::operator==( HardDriveCref aRef ) const
{
   return Equipment::operator==(aRef);
}

//
// Return the hard drive power requirement
//

Watt  HardDrive::getPower( void ) 
{
   return DriveWattage;
}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/01/21 03:44:01 $
   $Locker:  $
*/


