/*
  CoreLinux++ 
  Copyright (C) 1999 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

namespace corelinux
{
   //
   // Default constructor that gathers
   // the information about the exception
   //

   Exception::Exception
       ( 
           CharCptr   aWhy, 
           CharCptr   aFile, 
           LineNum    aLine,
           Exception::Severity	aSeverity,
           bool       aOutOfMemoryFlag
   	 )
      :
      theReason(aWhy),
      theFile(aFile),
      theSeverity(aSeverity),
      theUnwindInfo(),
      theLine(aLine),
      theOutOfMemoryFlag(aOutOfMemoryFlag)
   {
      ;  // do nothing
   }   

   //
   // Used by subclasses of Exception
   //

   Exception::Exception
      ( 
         CharCptr             aFile,
         LineNum              aLine,
         Exception::Severity	aSeverity,
         bool                 aOutOfMemoryFlag
      )
      :
      theReason(),
      theFile(aFile),
      theSeverity(aSeverity),
      theUnwindInfo(),
      theLine(aLine),
      theOutOfMemoryFlag(aOutOfMemoryFlag)
   {
      ;  //do nothing
   }

   //
   // Copy constructor
   //

   Exception::Exception( ExceptionCref crOther ) 
       :
      theReason(crOther.getWhy()),
      theFile(crOther.getFile()),
      theSeverity(crOther.getSeverity()),
      theUnwindInfo(crOther.getUnwind()),
      theLine(crOther.getLine()),
      theOutOfMemoryFlag(crOther.isOutOfMemory())
   {
      ;  // do nothing   
   }  

   //
   // Protected default constructor
   //

   Exception::Exception( void )
   {
      ;  // do nothing
   }

   //
   // Destructor
   //

   Exception::~Exception( void )
   {
      ;  // do nothing
   }   

   //
   // Assignment operator overload
   //

   ExceptionRef Exception::operator=( ExceptionCref crOther )
   {
      if( this != &crOther )
      {
         theReason = crOther.getWhy();
         theFile = crOther.getFile();
         theSeverity = crOther.getSeverity();
         theUnwindInfo = crOther.getUnwind();
         theLine = crOther.getLine();
         theOutOfMemoryFlag = crOther.isOutOfMemory();
      }
      else
      {
         ;  // do nothing
      }
   
      return *this;
   }   

   //
   // Equality operator overload
   //

   bool  Exception::operator ==( ExceptionCref aException )
   {
      return (this == &aException);
   }

   const std::string & Exception::getFile( void ) const
   {
       return theFile;
   }

   LineNumCref Exception::getLine( void ) const
   {
      return theLine;
   }

   const std::string & Exception::getWhy( void ) const
   {
      return theReason;
   }
   
   const Exception::Severity & Exception::getSeverity( void ) const
   {
      return theSeverity;
   }
   
   
   const std::string & Exception::getUnwind( void ) const
   {
      return theUnwindInfo;
   }
   
   void Exception::addUnwindInfo( CharCptr aUnwindInfo )
   {
       if( theOutOfMemoryFlag == false )
       {
          theUnwindInfo += aUnwindInfo;
       }
       else
       {
           ;   //  do nothing
       }
   }
   
   
   void Exception::setThreadFatalSeverity( void )
   {
   	if( theSeverity < THREADFATAL )
   	{
         theSeverity = THREADFATAL ;
   	}
      else
      {
         ;  // do nothing, severe enough
      }
   }
   
   
   void Exception::setProcessFatalSeverity( void )
   {
   	if( theSeverity < PROCESSFATAL )
   	{
         theSeverity = PROCESSFATAL ;
   	}
      else
      {
         ;  // do nothing, severe enough
      }
   }
   
   void Exception::setThreadTerminateSeverity( void )
   {
      if( theSeverity < THREADTERMINATE )
      {
         theSeverity = THREADTERMINATE ;
      }
      else
      {
         ;  // do nothing, severe enough
      }
   }
   
   void Exception::setProcessTerminateSeverity( void )
   {
      if( theSeverity < PROCESSTERMINATE )
   	{
   	   theSeverity = PROCESSTERMINATE ;
   	}
      else
      {
         ;  // do nothing, severe enough
      }
   }
   
   void  Exception::setWhy( const std::string & aWhy )
   {
      theReason = aWhy;
   }
   
   void  Exception::setWhy( CharCptr aWhy )
   {
      theReason = aWhy;
   }


}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.6 $
   $Date: 2000/10/07 12:06:16 $
   $Locker:  $
*/


