/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.sql.tests.java.sql;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestHelper_ClassLoader
extends ClassLoader {
    public TestHelper_ClassLoader() {
        super(null);
    }

    public Class<?> findClass(String className) throws ClassNotFoundException {
        Class theClass = null;
        if (!className.equals("org.apache.harmony.sql.tests.java.sql.TestHelper_DriverManager")) {
            return null;
        }
        String classNameAsFile = new StringBuffer(String.valueOf(className.replace('.', '/'))).append(".class").toString();
        String classPath = System.getProperty("java.class.path");
        String theSeparator = String.valueOf(File.pathSeparatorChar);
        String[] theClassPaths = classPath.split(theSeparator);
        int i = 0;
        while (i < theClassPaths.length && theClass == null) {
            theClass = theClassPaths[i].endsWith(".jar") ? this.loadClassFromJar(theClassPaths[i], className, classNameAsFile) : this.loadClassFromFile(theClassPaths[i], className, classNameAsFile);
            ++i;
        }
        return theClass;
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        String[] disallowedClasses = new String[]{"org.apache.harmony.sql.tests.java.sql.TestHelper_Driver1", "org.apache.harmony.sql.tests.java.sql.TestHelper_Driver2", "org.apache.harmony.sql.tests.java.sql.TestHelper_Driver4", "org.apache.harmony.sql.tests.java.sql.TestHelper_Driver5"};
        Class theClass = this.findLoadedClass(className);
        if (theClass != null) {
            return theClass;
        }
        theClass = this.findClass(className);
        if (theClass == null) {
            String[] stringArray = disallowedClasses;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String element = stringArray[n];
                if (element.equals(className)) {
                    return null;
                }
                ++n;
            }
            theClass = Class.forName(className);
        }
        return theClass;
    }

    private Class<?> loadClassFromFile(String pathName, String className, String classNameAsFile) {
        Class theClass = null;
        FileInputStream theInput = null;
        File theFile = null;
        try {
            try {
                theFile = new File(pathName, classNameAsFile);
                if (theFile.exists()) {
                    ClassLoader testClassLoader;
                    int length = (int)theFile.length();
                    theInput = new FileInputStream(theFile);
                    byte[] theBytes = new byte[length + 100];
                    int dataRead = 0;
                    while (dataRead < length) {
                        int count = theInput.read(theBytes, dataRead, theBytes.length - dataRead);
                        if (count == -1) break;
                        dataRead += count;
                    }
                    if (dataRead > 0 && (testClassLoader = (theClass = this.defineClass(className, theBytes, 0, dataRead)).getClassLoader()) != this) {
                        System.out.println("findClass - wrong classloader!!");
                    }
                }
            }
            catch (Exception e) {
                System.out.println("findClass - exception reading class file.");
                e.printStackTrace();
            }
        }
        finally {
            try {
                if (theInput != null) {
                    theInput.close();
                }
            }
            catch (Exception exception) {}
        }
        return theClass;
    }

    private Class<?> loadClassFromJar(String jarfileName, String className, String classNameAsFile) {
        Class theClass;
        block22: {
            JarEntry theEntry;
            JarFile theJar;
            block21: {
                theClass = null;
                theJar = null;
                theJar = new JarFile(jarfileName);
                theEntry = theJar.getJarEntry(classNameAsFile);
                if (theEntry != null) break block21;
                Class clazz = theClass;
                try {
                    if (theJar != null) {
                        theJar.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return clazz;
            }
            try {
                try {
                    theEntry.getMethod();
                    InputStream theStream = theJar.getInputStream(theEntry);
                    long size = theEntry.getSize();
                    if (size < 0L) {
                        size = 100000L;
                    }
                    byte[] theBytes = new byte[(int)size + 100];
                    int dataRead = 0;
                    while ((long)dataRead < size) {
                        int count = theStream.read(theBytes, dataRead, theBytes.length - dataRead);
                        if (count == -1) break;
                        dataRead += count;
                    }
                    if (dataRead <= 0) break block22;
                    theClass = this.defineClass(className, theBytes, 0, dataRead);
                    ClassLoader testClassLoader = theClass.getClassLoader();
                    if (testClassLoader != this) {
                        System.out.println("findClass - wrong classloader!!");
                        break block22;
                    }
                    System.out.println(new StringBuffer("Testclassloader loaded class from jar: ").append(className).toString());
                }
                catch (IOException ie) {
                    System.out.println(new StringBuffer("TestHelper_ClassLoader: IOException opening Jar ").append(jarfileName).toString());
                }
                catch (Exception e) {
                    System.out.println("TestHelper_ClassLoader: Exception loading class from Jar ");
                }
                catch (ClassFormatError ce) {
                    System.out.println("TestHelper_ClassLoader: ClassFormatException loading class from Jar ");
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    if (theJar != null) {
                        theJar.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return theClass;
    }
}

