#!/usr/bin/python
# -*- coding: utf-8 -*-

import gettext, sys, gtk, socket, os
from gettext import gettext as _

gettext.textdomain("weblive-dialog")

if len(sys.argv) < 2 or sys.argv[1] not in ('login','logout'):
    print _("Usage: %s <login|logout> [options]" % sys.argv[0])
    sys.exit(1)

if sys.argv[1] == "login":
    from weblive import WebLive
    locales=WebLive("https://weblive.stgraber.org/weblive/json").list_locales(socket.gethostname())

    if os.path.exists(os.path.expanduser("~/.weblive_locale")):
        default=open(os.path.expanduser("~/.weblive_locale"),"r").read().strip()
    else:
        default="en_US.utf8"

    dialog = gtk.Dialog(parent=None, flags=gtk.DIALOG_MODAL, buttons=(gtk.STOCK_CANCEL, gtk.RESPONSE_REJECT,
                      gtk.STOCK_OK, gtk.RESPONSE_ACCEPT))
    dialog.set_title("Welcome to WebLive!")

    # Main label
    label=gtk.Label()
    label.set_markup("""<b>Welcome to WebLive!</b>

This server (%s) is provided free of charge by: <b>Stéphane Graber</b>
and is located in: <b>Nürnberg, Germany</b>

<b>All internet trafic from WebLive is logged</b> and may be restricted
or even blocked completely at any time and for any reason.

WebLive is meant to let users easily try Ubuntu, its derivatives
and the software they include. Any other use isn't allowed.

As servers need maintenance, users may get disconnected at any time.
If that happens, just reconnect and you'll be connected to another server.

Please report any bug you encounter at:
<b>https://launchpad.net/weblive/+filebug</b>

If you disagree with any of the above, click <b>Cancel</b> now.

Enjoy!""" % socket.gethostname())
    label.set_padding(12,12)

    # Drop down
    model = gtk.ListStore(str,str)
    cell = gtk.CellRendererText()

    index=False
    for locale in locales:
        if locale[0] == default:
            index = model.append(locale)
        else:
            model.append(locale)

    combobox = gtk.ComboBox()
    combobox.pack_start(cell)
    combobox.add_attribute(cell, 'text', 1)
    combobox.set_model(model)
    if index:
        combobox.set_active_iter(index)

    # Language selector
    language_label = gtk.Label()
    language_label.set_markup("<b>Session language:</b>")
    language_label.set_padding(5,0)
    language_label.set_alignment(0,0.5)

    language = gtk.HBox()
    language.pack_start(language_label)
    language.pack_start(combobox)

    dialog.vbox.pack_start(label)
    dialog.vbox.pack_start(language)
    dialog.set_resizable(False)
    dialog.set_position(gtk.WIN_POS_CENTER_ALWAYS)
    dialog.set_modal(True)
    dialog.show_all()
    retval=dialog.run()

    if retval == gtk.RESPONSE_ACCEPT:
        open(os.path.expanduser("~/.weblive_locale"),"w+").write("%s\n" % model[combobox.get_active()][0])
        sys.exit(0)
    else:
        sys.exit(1)

elif sys.argv[1] == "logout":
    pass
