; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefix=ALL --check-prefix=AVX --check-prefix=AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefix=ALL --check-prefix=AVX --check-prefix=AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512cd,+avx512vl | FileCheck %s --check-prefix=ALL --check-prefix=AVX --check-prefix=AVX512CDVL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512cd,-avx512vl | FileCheck %s --check-prefix=ALL --check-prefix=AVX --check-prefix=AVX512CD
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vpopcntdq | FileCheck %s --check-prefix=ALL --check-prefix=AVX --check-prefix=AVX512VPOPCNTDQ
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vpopcntdq,+avx512vl | FileCheck %s --check-prefix=ALL --check-prefix=AVX --check-prefix=AVX512VPOPCNTDQVL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bitalg | FileCheck %s --check-prefix=ALL --check-prefix=BITALG_NOVLX
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bitalg,+avx512vl | FileCheck %s --check-prefix=ALL --check-prefix=BITALG
;
; Just one 32-bit run to make sure we do reasonable things for i64 tzcnt.
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefix=ALL --check-prefix=X32-AVX --check-prefix=X32-AVX2

define <4 x i64> @testv4i64(<4 x i64> %in) nounwind {
; AVX1-LABEL: testv4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpsubq %xmm1, %xmm2, %xmm3
; AVX1-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpaddq %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm4, %xmm1, %xmm5
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm6 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm5, %xmm6, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm6, %xmm1
; AVX1-NEXT:    vpaddb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpsadbw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpsubq %xmm0, %xmm2, %xmm5
; AVX1-NEXT:    vpand %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpaddq %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm4, %xmm0, %xmm3
; AVX1-NEXT:    vpshufb %xmm3, %xmm6, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm6, %xmm0
; AVX1-NEXT:    vpaddb %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: testv4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsubq %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX2-NEXT:    vpaddq %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm3
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    vpshufb %ymm3, %ymm4, %ymm3
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm4, %ymm0
; AVX2-NEXT:    vpaddb %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512CDVL-LABEL: testv4i64:
; AVX512CDVL:       # %bb.0:
; AVX512CDVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512CDVL-NEXT:    vpsubq %ymm0, %ymm1, %ymm2
; AVX512CDVL-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX512CDVL-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512CDVL-NEXT:    vpaddq %ymm2, %ymm0, %ymm0
; AVX512CDVL-NEXT:    vmovdqa {{.*#+}} ymm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512CDVL-NEXT:    vpand %ymm2, %ymm0, %ymm3
; AVX512CDVL-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512CDVL-NEXT:    vpshufb %ymm3, %ymm4, %ymm3
; AVX512CDVL-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512CDVL-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX512CDVL-NEXT:    vpshufb %ymm0, %ymm4, %ymm0
; AVX512CDVL-NEXT:    vpaddb %ymm3, %ymm0, %ymm0
; AVX512CDVL-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX512CDVL-NEXT:    retq
;
; AVX512CD-LABEL: testv4i64:
; AVX512CD:       # %bb.0:
; AVX512CD-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512CD-NEXT:    vpsubq %ymm0, %ymm1, %ymm2
; AVX512CD-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX512CD-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512CD-NEXT:    vpaddq %ymm2, %ymm0, %ymm0
; AVX512CD-NEXT:    vmovdqa {{.*#+}} ymm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512CD-NEXT:    vpand %ymm2, %ymm0, %ymm3
; AVX512CD-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512CD-NEXT:    vpshufb %ymm3, %ymm4, %ymm3
; AVX512CD-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512CD-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX512CD-NEXT:    vpshufb %ymm0, %ymm4, %ymm0
; AVX512CD-NEXT:    vpaddb %ymm3, %ymm0, %ymm0
; AVX512CD-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX512CD-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: testv4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VPOPCNTDQ-NEXT:    vpsubq %ymm0, %ymm1, %ymm1
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512VPOPCNTDQ-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    # kill: def %ymm0 killed %ymm0 killed %zmm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: testv4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VPOPCNTDQVL-NEXT:    vpsubq %ymm0, %ymm1, %ymm1
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512VPOPCNTDQVL-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: testv4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsubq %ymm0, %ymm1, %ymm2
; BITALG_NOVLX-NEXT:    vpand %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpaddq %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vmovdqa {{.*#+}} ymm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; BITALG_NOVLX-NEXT:    vpand %ymm2, %ymm0, %ymm3
; BITALG_NOVLX-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; BITALG_NOVLX-NEXT:    vpshufb %ymm3, %ymm4, %ymm3
; BITALG_NOVLX-NEXT:    vpsrlw $4, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpand %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpshufb %ymm0, %ymm4, %ymm0
; BITALG_NOVLX-NEXT:    vpaddb %ymm3, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: testv4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsubq %ymm0, %ymm1, %ymm2
; BITALG-NEXT:    vpand %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; BITALG-NEXT:    vpaddq %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vmovdqa {{.*#+}} ymm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; BITALG-NEXT:    vpand %ymm2, %ymm0, %ymm3
; BITALG-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; BITALG-NEXT:    vpshufb %ymm3, %ymm4, %ymm3
; BITALG-NEXT:    vpsrlw $4, %ymm0, %ymm0
; BITALG-NEXT:    vpand %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpshufb %ymm0, %ymm4, %ymm0
; BITALG-NEXT:    vpaddb %ymm3, %ymm0, %ymm0
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
;
; X32-AVX-LABEL: testv4i64:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X32-AVX-NEXT:    vpsubq %ymm0, %ymm1, %ymm2
; X32-AVX-NEXT:    vpand %ymm2, %ymm0, %ymm0
; X32-AVX-NEXT:    vpsubq {{\.LCPI.*}}, %ymm0, %ymm0
; X32-AVX-NEXT:    vmovdqa {{.*#+}} ymm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; X32-AVX-NEXT:    vpand %ymm2, %ymm0, %ymm3
; X32-AVX-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; X32-AVX-NEXT:    vpshufb %ymm3, %ymm4, %ymm3
; X32-AVX-NEXT:    vpsrlw $4, %ymm0, %ymm0
; X32-AVX-NEXT:    vpand %ymm2, %ymm0, %ymm0
; X32-AVX-NEXT:    vpshufb %ymm0, %ymm4, %ymm0
; X32-AVX-NEXT:    vpaddb %ymm3, %ymm0, %ymm0
; X32-AVX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; X32-AVX-NEXT:    retl
  %out = call <4 x i64> @llvm.cttz.v4i64(<4 x i64> %in, i1 0)
  ret <4 x i64> %out
}

define <4 x i64> @testv4i64u(<4 x i64> %in) nounwind {
; AVX1-LABEL: testv4i64u:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpsubq %xmm1, %xmm2, %xmm3
; AVX1-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpaddq %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm4, %xmm1, %xmm5
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm6 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm5, %xmm6, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm6, %xmm1
; AVX1-NEXT:    vpaddb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpsadbw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpsubq %xmm0, %xmm2, %xmm5
; AVX1-NEXT:    vpand %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpaddq %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm4, %xmm0, %xmm3
; AVX1-NEXT:    vpshufb %xmm3, %xmm6, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm6, %xmm0
; AVX1-NEXT:    vpaddb %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: testv4i64u:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsubq %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX2-NEXT:    vpaddq %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm3
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    vpshufb %ymm3, %ymm4, %ymm3
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm4, %ymm0
; AVX2-NEXT:    vpaddb %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512CDVL-LABEL: testv4i64u:
; AVX512CDVL:       # %bb.0:
; AVX512CDVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512CDVL-NEXT:    vpsubq %ymm0, %ymm1, %ymm1
; AVX512CDVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512CDVL-NEXT:    vplzcntq %ymm0, %ymm0
; AVX512CDVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [63,63,63,63]
; AVX512CDVL-NEXT:    vpsubq %ymm0, %ymm1, %ymm0
; AVX512CDVL-NEXT:    retq
;
; AVX512CD-LABEL: testv4i64u:
; AVX512CD:       # %bb.0:
; AVX512CD-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512CD-NEXT:    vpsubq %ymm0, %ymm1, %ymm1
; AVX512CD-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512CD-NEXT:    vplzcntq %zmm0, %zmm0
; AVX512CD-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [63,63,63,63]
; AVX512CD-NEXT:    vpsubq %ymm0, %ymm1, %ymm0
; AVX512CD-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: testv4i64u:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VPOPCNTDQ-NEXT:    vpsubq %ymm0, %ymm1, %ymm1
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512VPOPCNTDQ-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    # kill: def %ymm0 killed %ymm0 killed %zmm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: testv4i64u:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VPOPCNTDQVL-NEXT:    vpsubq %ymm0, %ymm1, %ymm1
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512VPOPCNTDQVL-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: testv4i64u:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsubq %ymm0, %ymm1, %ymm2
; BITALG_NOVLX-NEXT:    vpand %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpaddq %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vmovdqa {{.*#+}} ymm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; BITALG_NOVLX-NEXT:    vpand %ymm2, %ymm0, %ymm3
; BITALG_NOVLX-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; BITALG_NOVLX-NEXT:    vpshufb %ymm3, %ymm4, %ymm3
; BITALG_NOVLX-NEXT:    vpsrlw $4, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpand %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpshufb %ymm0, %ymm4, %ymm0
; BITALG_NOVLX-NEXT:    vpaddb %ymm3, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: testv4i64u:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsubq %ymm0, %ymm1, %ymm2
; BITALG-NEXT:    vpand %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; BITALG-NEXT:    vpaddq %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vmovdqa {{.*#+}} ymm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; BITALG-NEXT:    vpand %ymm2, %ymm0, %ymm3
; BITALG-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; BITALG-NEXT:    vpshufb %ymm3, %ymm4, %ymm3
; BITALG-NEXT:    vpsrlw $4, %ymm0, %ymm0
; BITALG-NEXT:    vpand %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpshufb %ymm0, %ymm4, %ymm0
; BITALG-NEXT:    vpaddb %ymm3, %ymm0, %ymm0
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
;
; X32-AVX-LABEL: testv4i64u:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X32-AVX-NEXT:    vpsubq %ymm0, %ymm1, %ymm2
; X32-AVX-NEXT:    vpand %ymm2, %ymm0, %ymm0
; X32-AVX-NEXT:    vpsubq {{\.LCPI.*}}, %ymm0, %ymm0
; X32-AVX-NEXT:    vmovdqa {{.*#+}} ymm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; X32-AVX-NEXT:    vpand %ymm2, %ymm0, %ymm3
; X32-AVX-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; X32-AVX-NEXT:    vpshufb %ymm3, %ymm4, %ymm3
; X32-AVX-NEXT:    vpsrlw $4, %ymm0, %ymm0
; X32-AVX-NEXT:    vpand %ymm2, %ymm0, %ymm0
; X32-AVX-NEXT:    vpshufb %ymm0, %ymm4, %ymm0
; X32-AVX-NEXT:    vpaddb %ymm3, %ymm0, %ymm0
; X32-AVX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; X32-AVX-NEXT:    retl
  %out = call <4 x i64> @llvm.cttz.v4i64(<4 x i64> %in, i1 -1)
  ret <4 x i64> %out
}

define <8 x i32> @testv8i32(<8 x i32> %in) nounwind {
; AVX1-LABEL: testv8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpsubd %xmm1, %xmm2, %xmm3
; AVX1-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpaddd %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm4, %xmm1, %xmm5
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm6 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm5, %xmm6, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm6, %xmm1
; AVX1-NEXT:    vpaddb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; AVX1-NEXT:    vpsadbw %xmm2, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpsubd %xmm0, %xmm2, %xmm5
; AVX1-NEXT:    vpand %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpaddd %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm4, %xmm0, %xmm3
; AVX1-NEXT:    vpshufb %xmm3, %xmm6, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm6, %xmm0
; AVX1-NEXT:    vpaddb %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm3 = xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; AVX1-NEXT:    vpsadbw %xmm2, %xmm3, %xmm3
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: testv8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsubd %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX2-NEXT:    vpaddd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm3
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    vpshufb %ymm3, %ymm4, %ymm3
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm4, %ymm0
; AVX2-NEXT:    vpaddb %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512CDVL-LABEL: testv8i32:
; AVX512CDVL:       # %bb.0:
; AVX512CDVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512CDVL-NEXT:    vpsubd %ymm0, %ymm1, %ymm2
; AVX512CDVL-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX512CDVL-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512CDVL-NEXT:    vpaddd %ymm2, %ymm0, %ymm0
; AVX512CDVL-NEXT:    vmovdqa {{.*#+}} ymm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512CDVL-NEXT:    vpand %ymm2, %ymm0, %ymm3
; AVX512CDVL-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512CDVL-NEXT:    vpshufb %ymm3, %ymm4, %ymm3
; AVX512CDVL-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512CDVL-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX512CDVL-NEXT:    vpshufb %ymm0, %ymm4, %ymm0
; AVX512CDVL-NEXT:    vpaddb %ymm3, %ymm0, %ymm0
; AVX512CDVL-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX512CDVL-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX512CDVL-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX512CDVL-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX512CDVL-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX512CDVL-NEXT:    retq
;
; AVX512CD-LABEL: testv8i32:
; AVX512CD:       # %bb.0:
; AVX512CD-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512CD-NEXT:    vpsubd %ymm0, %ymm1, %ymm2
; AVX512CD-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX512CD-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512CD-NEXT:    vpaddd %ymm2, %ymm0, %ymm0
; AVX512CD-NEXT:    vmovdqa {{.*#+}} ymm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512CD-NEXT:    vpand %ymm2, %ymm0, %ymm3
; AVX512CD-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512CD-NEXT:    vpshufb %ymm3, %ymm4, %ymm3
; AVX512CD-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512CD-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX512CD-NEXT:    vpshufb %ymm0, %ymm4, %ymm0
; AVX512CD-NEXT:    vpaddb %ymm3, %ymm0, %ymm0
; AVX512CD-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX512CD-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX512CD-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX512CD-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX512CD-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX512CD-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: testv8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VPOPCNTDQ-NEXT:    vpsubd %ymm0, %ymm1, %ymm1
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512VPOPCNTDQ-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    # kill: def %ymm0 killed %ymm0 killed %zmm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: testv8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VPOPCNTDQVL-NEXT:    vpsubd %ymm0, %ymm1, %ymm1
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512VPOPCNTDQVL-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: testv8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsubd %ymm0, %ymm1, %ymm2
; BITALG_NOVLX-NEXT:    vpand %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpaddd %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vmovdqa {{.*#+}} ymm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; BITALG_NOVLX-NEXT:    vpand %ymm2, %ymm0, %ymm3
; BITALG_NOVLX-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; BITALG_NOVLX-NEXT:    vpshufb %ymm3, %ymm4, %ymm3
; BITALG_NOVLX-NEXT:    vpsrlw $4, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpand %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpshufb %ymm0, %ymm4, %ymm0
; BITALG_NOVLX-NEXT:    vpaddb %ymm3, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: testv8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsubd %ymm0, %ymm1, %ymm2
; BITALG-NEXT:    vpand %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; BITALG-NEXT:    vpaddd %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vmovdqa {{.*#+}} ymm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; BITALG-NEXT:    vpand %ymm2, %ymm0, %ymm3
; BITALG-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; BITALG-NEXT:    vpshufb %ymm3, %ymm4, %ymm3
; BITALG-NEXT:    vpsrlw $4, %ymm0, %ymm0
; BITALG-NEXT:    vpand %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpshufb %ymm0, %ymm4, %ymm0
; BITALG-NEXT:    vpaddb %ymm3, %ymm0, %ymm0
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    retq
;
; X32-AVX-LABEL: testv8i32:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X32-AVX-NEXT:    vpsubd %ymm0, %ymm1, %ymm2
; X32-AVX-NEXT:    vpand %ymm2, %ymm0, %ymm0
; X32-AVX-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; X32-AVX-NEXT:    vpaddd %ymm2, %ymm0, %ymm0
; X32-AVX-NEXT:    vmovdqa {{.*#+}} ymm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; X32-AVX-NEXT:    vpand %ymm2, %ymm0, %ymm3
; X32-AVX-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; X32-AVX-NEXT:    vpshufb %ymm3, %ymm4, %ymm3
; X32-AVX-NEXT:    vpsrlw $4, %ymm0, %ymm0
; X32-AVX-NEXT:    vpand %ymm2, %ymm0, %ymm0
; X32-AVX-NEXT:    vpshufb %ymm0, %ymm4, %ymm0
; X32-AVX-NEXT:    vpaddb %ymm3, %ymm0, %ymm0
; X32-AVX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; X32-AVX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; X32-AVX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; X32-AVX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; X32-AVX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; X32-AVX-NEXT:    retl
  %out = call <8 x i32> @llvm.cttz.v8i32(<8 x i32> %in, i1 0)
  ret <8 x i32> %out
}

define <8 x i32> @testv8i32u(<8 x i32> %in) nounwind {
; AVX1-LABEL: testv8i32u:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpsubd %xmm1, %xmm2, %xmm3
; AVX1-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpaddd %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm4, %xmm1, %xmm5
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm6 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm5, %xmm6, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm6, %xmm1
; AVX1-NEXT:    vpaddb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; AVX1-NEXT:    vpsadbw %xmm2, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpsubd %xmm0, %xmm2, %xmm5
; AVX1-NEXT:    vpand %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpaddd %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm4, %xmm0, %xmm3
; AVX1-NEXT:    vpshufb %xmm3, %xmm6, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm6, %xmm0
; AVX1-NEXT:    vpaddb %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm3 = xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; AVX1-NEXT:    vpsadbw %xmm2, %xmm3, %xmm3
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: testv8i32u:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsubd %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX2-NEXT:    vpaddd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm3
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    vpshufb %ymm3, %ymm4, %ymm3
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm4, %ymm0
; AVX2-NEXT:    vpaddb %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512CDVL-LABEL: testv8i32u:
; AVX512CDVL:       # %bb.0:
; AVX512CDVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512CDVL-NEXT:    vpsubd %ymm0, %ymm1, %ymm1
; AVX512CDVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512CDVL-NEXT:    vplzcntd %ymm0, %ymm0
; AVX512CDVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [31,31,31,31,31,31,31,31]
; AVX512CDVL-NEXT:    vpsubd %ymm0, %ymm1, %ymm0
; AVX512CDVL-NEXT:    retq
;
; AVX512CD-LABEL: testv8i32u:
; AVX512CD:       # %bb.0:
; AVX512CD-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512CD-NEXT:    vpsubd %ymm0, %ymm1, %ymm1
; AVX512CD-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512CD-NEXT:    vplzcntd %zmm0, %zmm0
; AVX512CD-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [31,31,31,31,31,31,31,31]
; AVX512CD-NEXT:    vpsubd %ymm0, %ymm1, %ymm0
; AVX512CD-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: testv8i32u:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VPOPCNTDQ-NEXT:    vpsubd %ymm0, %ymm1, %ymm1
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512VPOPCNTDQ-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    # kill: def %ymm0 killed %ymm0 killed %zmm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: testv8i32u:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VPOPCNTDQVL-NEXT:    vpsubd %ymm0, %ymm1, %ymm1
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512VPOPCNTDQVL-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: testv8i32u:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsubd %ymm0, %ymm1, %ymm2
; BITALG_NOVLX-NEXT:    vpand %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpaddd %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vmovdqa {{.*#+}} ymm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; BITALG_NOVLX-NEXT:    vpand %ymm2, %ymm0, %ymm3
; BITALG_NOVLX-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; BITALG_NOVLX-NEXT:    vpshufb %ymm3, %ymm4, %ymm3
; BITALG_NOVLX-NEXT:    vpsrlw $4, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpand %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpshufb %ymm0, %ymm4, %ymm0
; BITALG_NOVLX-NEXT:    vpaddb %ymm3, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: testv8i32u:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsubd %ymm0, %ymm1, %ymm2
; BITALG-NEXT:    vpand %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; BITALG-NEXT:    vpaddd %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vmovdqa {{.*#+}} ymm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; BITALG-NEXT:    vpand %ymm2, %ymm0, %ymm3
; BITALG-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; BITALG-NEXT:    vpshufb %ymm3, %ymm4, %ymm3
; BITALG-NEXT:    vpsrlw $4, %ymm0, %ymm0
; BITALG-NEXT:    vpand %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpshufb %ymm0, %ymm4, %ymm0
; BITALG-NEXT:    vpaddb %ymm3, %ymm0, %ymm0
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    retq
;
; X32-AVX-LABEL: testv8i32u:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X32-AVX-NEXT:    vpsubd %ymm0, %ymm1, %ymm2
; X32-AVX-NEXT:    vpand %ymm2, %ymm0, %ymm0
; X32-AVX-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; X32-AVX-NEXT:    vpaddd %ymm2, %ymm0, %ymm0
; X32-AVX-NEXT:    vmovdqa {{.*#+}} ymm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; X32-AVX-NEXT:    vpand %ymm2, %ymm0, %ymm3
; X32-AVX-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; X32-AVX-NEXT:    vpshufb %ymm3, %ymm4, %ymm3
; X32-AVX-NEXT:    vpsrlw $4, %ymm0, %ymm0
; X32-AVX-NEXT:    vpand %ymm2, %ymm0, %ymm0
; X32-AVX-NEXT:    vpshufb %ymm0, %ymm4, %ymm0
; X32-AVX-NEXT:    vpaddb %ymm3, %ymm0, %ymm0
; X32-AVX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; X32-AVX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; X32-AVX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; X32-AVX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; X32-AVX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; X32-AVX-NEXT:    retl
  %out = call <8 x i32> @llvm.cttz.v8i32(<8 x i32> %in, i1 -1)
  ret <8 x i32> %out
}

define <16 x i16> @testv16i16(<16 x i16> %in) nounwind {
; AVX1-LABEL: testv16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpsubw %xmm0, %xmm1, %xmm2
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpaddw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm4, %xmm2, %xmm5
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm6 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm5, %xmm6, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm2, %xmm2
; AVX1-NEXT:    vpand %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpshufb %xmm2, %xmm6, %xmm2
; AVX1-NEXT:    vpaddb %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpsllw $8, %xmm2, %xmm5
; AVX1-NEXT:    vpaddb %xmm2, %xmm5, %xmm2
; AVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpsubw %xmm0, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpaddw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm4, %xmm0, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm6, %xmm1
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm6, %xmm0
; AVX1-NEXT:    vpaddb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $8, %xmm0, %xmm1
; AVX1-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: testv16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsubw %ymm0, %ymm1, %ymm1
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsllw $8, %ymm0, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512CDVL-LABEL: testv16i16:
; AVX512CDVL:       # %bb.0:
; AVX512CDVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512CDVL-NEXT:    vpsubw %ymm0, %ymm1, %ymm1
; AVX512CDVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512CDVL-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512CDVL-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; AVX512CDVL-NEXT:    vmovdqa {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512CDVL-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512CDVL-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512CDVL-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX512CDVL-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512CDVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512CDVL-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512CDVL-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512CDVL-NEXT:    vpsllw $8, %ymm0, %ymm1
; AVX512CDVL-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512CDVL-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX512CDVL-NEXT:    retq
;
; AVX512CD-LABEL: testv16i16:
; AVX512CD:       # %bb.0:
; AVX512CD-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512CD-NEXT:    vpsubw %ymm0, %ymm1, %ymm1
; AVX512CD-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512CD-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512CD-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; AVX512CD-NEXT:    vmovdqa {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512CD-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512CD-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512CD-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX512CD-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512CD-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512CD-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512CD-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512CD-NEXT:    vpsllw $8, %ymm0, %ymm1
; AVX512CD-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512CD-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX512CD-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: testv16i16:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VPOPCNTDQ-NEXT:    vpsubw %ymm0, %ymm1, %ymm1
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512VPOPCNTDQ-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: testv16i16:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VPOPCNTDQVL-NEXT:    vpsubw %ymm0, %ymm1, %ymm1
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512VPOPCNTDQVL-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQVL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: testv16i16:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsubw %ymm0, %ymm1, %ymm1
; BITALG_NOVLX-NEXT:    vpand %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; BITALG_NOVLX-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpopcntw %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    # kill: def %ymm0 killed %ymm0 killed %zmm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: testv16i16:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsubw %ymm0, %ymm1, %ymm1
; BITALG-NEXT:    vpand %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; BITALG-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpopcntw %ymm0, %ymm0
; BITALG-NEXT:    retq
;
; X32-AVX-LABEL: testv16i16:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X32-AVX-NEXT:    vpsubw %ymm0, %ymm1, %ymm1
; X32-AVX-NEXT:    vpand %ymm1, %ymm0, %ymm0
; X32-AVX-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; X32-AVX-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; X32-AVX-NEXT:    vmovdqa {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; X32-AVX-NEXT:    vpand %ymm1, %ymm0, %ymm2
; X32-AVX-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; X32-AVX-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; X32-AVX-NEXT:    vpsrlw $4, %ymm0, %ymm0
; X32-AVX-NEXT:    vpand %ymm1, %ymm0, %ymm0
; X32-AVX-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; X32-AVX-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; X32-AVX-NEXT:    vpsllw $8, %ymm0, %ymm1
; X32-AVX-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; X32-AVX-NEXT:    vpsrlw $8, %ymm0, %ymm0
; X32-AVX-NEXT:    retl
  %out = call <16 x i16> @llvm.cttz.v16i16(<16 x i16> %in, i1 0)
  ret <16 x i16> %out
}

define <16 x i16> @testv16i16u(<16 x i16> %in) nounwind {
; AVX1-LABEL: testv16i16u:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpsubw %xmm0, %xmm1, %xmm2
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpaddw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm4, %xmm2, %xmm5
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm6 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm5, %xmm6, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm2, %xmm2
; AVX1-NEXT:    vpand %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpshufb %xmm2, %xmm6, %xmm2
; AVX1-NEXT:    vpaddb %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpsllw $8, %xmm2, %xmm5
; AVX1-NEXT:    vpaddb %xmm2, %xmm5, %xmm2
; AVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpsubw %xmm0, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpaddw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm4, %xmm0, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm6, %xmm1
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm6, %xmm0
; AVX1-NEXT:    vpaddb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $8, %xmm0, %xmm1
; AVX1-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: testv16i16u:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsubw %ymm0, %ymm1, %ymm1
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsllw $8, %ymm0, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512CDVL-LABEL: testv16i16u:
; AVX512CDVL:       # %bb.0:
; AVX512CDVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512CDVL-NEXT:    vpsubw %ymm0, %ymm1, %ymm1
; AVX512CDVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512CDVL-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512CDVL-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; AVX512CDVL-NEXT:    vmovdqa {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512CDVL-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512CDVL-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512CDVL-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX512CDVL-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512CDVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512CDVL-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512CDVL-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512CDVL-NEXT:    vpsllw $8, %ymm0, %ymm1
; AVX512CDVL-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512CDVL-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX512CDVL-NEXT:    retq
;
; AVX512CD-LABEL: testv16i16u:
; AVX512CD:       # %bb.0:
; AVX512CD-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512CD-NEXT:    vpsubw %ymm0, %ymm1, %ymm1
; AVX512CD-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512CD-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512CD-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; AVX512CD-NEXT:    vmovdqa {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512CD-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512CD-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512CD-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX512CD-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512CD-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512CD-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512CD-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512CD-NEXT:    vpsllw $8, %ymm0, %ymm1
; AVX512CD-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512CD-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX512CD-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: testv16i16u:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VPOPCNTDQ-NEXT:    vpsubw %ymm0, %ymm1, %ymm1
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512VPOPCNTDQ-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: testv16i16u:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VPOPCNTDQVL-NEXT:    vpsubw %ymm0, %ymm1, %ymm1
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512VPOPCNTDQVL-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQVL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: testv16i16u:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsubw %ymm0, %ymm1, %ymm1
; BITALG_NOVLX-NEXT:    vpand %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; BITALG_NOVLX-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpopcntw %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    # kill: def %ymm0 killed %ymm0 killed %zmm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: testv16i16u:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsubw %ymm0, %ymm1, %ymm1
; BITALG-NEXT:    vpand %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; BITALG-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpopcntw %ymm0, %ymm0
; BITALG-NEXT:    retq
;
; X32-AVX-LABEL: testv16i16u:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X32-AVX-NEXT:    vpsubw %ymm0, %ymm1, %ymm1
; X32-AVX-NEXT:    vpand %ymm1, %ymm0, %ymm0
; X32-AVX-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; X32-AVX-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; X32-AVX-NEXT:    vmovdqa {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; X32-AVX-NEXT:    vpand %ymm1, %ymm0, %ymm2
; X32-AVX-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; X32-AVX-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; X32-AVX-NEXT:    vpsrlw $4, %ymm0, %ymm0
; X32-AVX-NEXT:    vpand %ymm1, %ymm0, %ymm0
; X32-AVX-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; X32-AVX-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; X32-AVX-NEXT:    vpsllw $8, %ymm0, %ymm1
; X32-AVX-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; X32-AVX-NEXT:    vpsrlw $8, %ymm0, %ymm0
; X32-AVX-NEXT:    retl
  %out = call <16 x i16> @llvm.cttz.v16i16(<16 x i16> %in, i1 -1)
  ret <16 x i16> %out
}

define <32 x i8> @testv32i8(<32 x i8> %in) nounwind {
; AVX1-LABEL: testv32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpsubb %xmm1, %xmm2, %xmm3
; AVX1-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm4, %xmm1, %xmm5
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm6 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm5, %xmm6, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm6, %xmm1
; AVX1-NEXT:    vpaddb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpsubb %xmm0, %xmm2, %xmm2
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpaddb %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm4, %xmm0, %xmm2
; AVX1-NEXT:    vpshufb %xmm2, %xmm6, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm6, %xmm0
; AVX1-NEXT:    vpaddb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: testv32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsubb %ymm0, %ymm1, %ymm1
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512CDVL-LABEL: testv32i8:
; AVX512CDVL:       # %bb.0:
; AVX512CDVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512CDVL-NEXT:    vpsubb %ymm0, %ymm1, %ymm1
; AVX512CDVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512CDVL-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512CDVL-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX512CDVL-NEXT:    vmovdqa {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512CDVL-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512CDVL-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512CDVL-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX512CDVL-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512CDVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512CDVL-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512CDVL-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512CDVL-NEXT:    retq
;
; AVX512CD-LABEL: testv32i8:
; AVX512CD:       # %bb.0:
; AVX512CD-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512CD-NEXT:    vpsubb %ymm0, %ymm1, %ymm1
; AVX512CD-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512CD-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512CD-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX512CD-NEXT:    vmovdqa {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512CD-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512CD-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512CD-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX512CD-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512CD-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512CD-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512CD-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512CD-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: testv32i8:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VPOPCNTDQ-NEXT:    vpsubb %ymm0, %ymm1, %ymm1
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512VPOPCNTDQ-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vmovdqa {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512VPOPCNTDQ-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512VPOPCNTDQ-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX512VPOPCNTDQ-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: testv32i8:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VPOPCNTDQVL-NEXT:    vpsubb %ymm0, %ymm1, %ymm1
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512VPOPCNTDQVL-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vmovdqa {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512VPOPCNTDQVL-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512VPOPCNTDQVL-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX512VPOPCNTDQVL-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: testv32i8:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsubb %ymm0, %ymm1, %ymm1
; BITALG_NOVLX-NEXT:    vpand %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; BITALG_NOVLX-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    # kill: def %ymm0 killed %ymm0 killed %zmm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: testv32i8:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsubb %ymm0, %ymm1, %ymm1
; BITALG-NEXT:    vpand %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; BITALG-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    retq
;
; X32-AVX-LABEL: testv32i8:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X32-AVX-NEXT:    vpsubb %ymm0, %ymm1, %ymm1
; X32-AVX-NEXT:    vpand %ymm1, %ymm0, %ymm0
; X32-AVX-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; X32-AVX-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; X32-AVX-NEXT:    vmovdqa {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; X32-AVX-NEXT:    vpand %ymm1, %ymm0, %ymm2
; X32-AVX-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; X32-AVX-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; X32-AVX-NEXT:    vpsrlw $4, %ymm0, %ymm0
; X32-AVX-NEXT:    vpand %ymm1, %ymm0, %ymm0
; X32-AVX-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; X32-AVX-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; X32-AVX-NEXT:    retl
  %out = call <32 x i8> @llvm.cttz.v32i8(<32 x i8> %in, i1 0)
  ret <32 x i8> %out
}

define <32 x i8> @testv32i8u(<32 x i8> %in) nounwind {
; AVX1-LABEL: testv32i8u:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpsubb %xmm1, %xmm2, %xmm3
; AVX1-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm4, %xmm1, %xmm5
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm6 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm5, %xmm6, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm6, %xmm1
; AVX1-NEXT:    vpaddb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpsubb %xmm0, %xmm2, %xmm2
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpaddb %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm4, %xmm0, %xmm2
; AVX1-NEXT:    vpshufb %xmm2, %xmm6, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm6, %xmm0
; AVX1-NEXT:    vpaddb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: testv32i8u:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsubb %ymm0, %ymm1, %ymm1
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512CDVL-LABEL: testv32i8u:
; AVX512CDVL:       # %bb.0:
; AVX512CDVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512CDVL-NEXT:    vpsubb %ymm0, %ymm1, %ymm1
; AVX512CDVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512CDVL-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512CDVL-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX512CDVL-NEXT:    vmovdqa {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512CDVL-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512CDVL-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512CDVL-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX512CDVL-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512CDVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512CDVL-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512CDVL-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512CDVL-NEXT:    retq
;
; AVX512CD-LABEL: testv32i8u:
; AVX512CD:       # %bb.0:
; AVX512CD-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512CD-NEXT:    vpsubb %ymm0, %ymm1, %ymm1
; AVX512CD-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512CD-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512CD-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX512CD-NEXT:    vmovdqa {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512CD-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512CD-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512CD-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX512CD-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512CD-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512CD-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512CD-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512CD-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: testv32i8u:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VPOPCNTDQ-NEXT:    vpsubb %ymm0, %ymm1, %ymm1
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512VPOPCNTDQ-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vmovdqa {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512VPOPCNTDQ-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512VPOPCNTDQ-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX512VPOPCNTDQ-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: testv32i8u:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VPOPCNTDQVL-NEXT:    vpsubb %ymm0, %ymm1, %ymm1
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512VPOPCNTDQVL-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vmovdqa {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512VPOPCNTDQVL-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512VPOPCNTDQVL-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX512VPOPCNTDQVL-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: testv32i8u:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsubb %ymm0, %ymm1, %ymm1
; BITALG_NOVLX-NEXT:    vpand %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; BITALG_NOVLX-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    # kill: def %ymm0 killed %ymm0 killed %zmm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: testv32i8u:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsubb %ymm0, %ymm1, %ymm1
; BITALG-NEXT:    vpand %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; BITALG-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    retq
;
; X32-AVX-LABEL: testv32i8u:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X32-AVX-NEXT:    vpsubb %ymm0, %ymm1, %ymm1
; X32-AVX-NEXT:    vpand %ymm1, %ymm0, %ymm0
; X32-AVX-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; X32-AVX-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; X32-AVX-NEXT:    vmovdqa {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; X32-AVX-NEXT:    vpand %ymm1, %ymm0, %ymm2
; X32-AVX-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; X32-AVX-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; X32-AVX-NEXT:    vpsrlw $4, %ymm0, %ymm0
; X32-AVX-NEXT:    vpand %ymm1, %ymm0, %ymm0
; X32-AVX-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; X32-AVX-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; X32-AVX-NEXT:    retl
  %out = call <32 x i8> @llvm.cttz.v32i8(<32 x i8> %in, i1 -1)
  ret <32 x i8> %out
}

define <4 x i64> @foldv4i64() nounwind {
; AVX-LABEL: foldv4i64:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,64,0]
; AVX-NEXT:    retq
;
; BITALG_NOVLX-LABEL: foldv4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,64,0]
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: foldv4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,64,0]
; BITALG-NEXT:    retq
;
; X32-AVX-LABEL: foldv4i64:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,0,0,64,0,0,0]
; X32-AVX-NEXT:    retl
  %out = call <4 x i64> @llvm.cttz.v4i64(<4 x i64> <i64 256, i64 -1, i64 0, i64 255>, i1 0)
  ret <4 x i64> %out
}

define <4 x i64> @foldv4i64u() nounwind {
; AVX-LABEL: foldv4i64u:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,64,0]
; AVX-NEXT:    retq
;
; BITALG_NOVLX-LABEL: foldv4i64u:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,64,0]
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: foldv4i64u:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,64,0]
; BITALG-NEXT:    retq
;
; X32-AVX-LABEL: foldv4i64u:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,0,0,64,0,0,0]
; X32-AVX-NEXT:    retl
  %out = call <4 x i64> @llvm.cttz.v4i64(<4 x i64> <i64 256, i64 -1, i64 0, i64 255>, i1 -1)
  ret <4 x i64> %out
}

define <8 x i32> @foldv8i32() nounwind {
; AVX-LABEL: foldv8i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,32,0,16,0,3,3]
; AVX-NEXT:    retq
;
; BITALG_NOVLX-LABEL: foldv8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,32,0,16,0,3,3]
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: foldv8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,32,0,16,0,3,3]
; BITALG-NEXT:    retq
;
; X32-AVX-LABEL: foldv8i32:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,32,0,16,0,3,3]
; X32-AVX-NEXT:    retl
  %out = call <8 x i32> @llvm.cttz.v8i32(<8 x i32> <i32 256, i32 -1, i32 0, i32 255, i32 -65536, i32 7, i32 24, i32 88>, i1 0)
  ret <8 x i32> %out
}

define <8 x i32> @foldv8i32u() nounwind {
; AVX-LABEL: foldv8i32u:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,32,0,16,0,3,3]
; AVX-NEXT:    retq
;
; BITALG_NOVLX-LABEL: foldv8i32u:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,32,0,16,0,3,3]
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: foldv8i32u:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,32,0,16,0,3,3]
; BITALG-NEXT:    retq
;
; X32-AVX-LABEL: foldv8i32u:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,32,0,16,0,3,3]
; X32-AVX-NEXT:    retl
  %out = call <8 x i32> @llvm.cttz.v8i32(<8 x i32> <i32 256, i32 -1, i32 0, i32 255, i32 -65536, i32 7, i32 24, i32 88>, i1 -1)
  ret <8 x i32> %out
}

define <16 x i16> @foldv16i16() nounwind {
; AVX-LABEL: foldv16i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,16,0,16,0,3,3,1,1,0,1,2,3,4,5]
; AVX-NEXT:    retq
;
; BITALG_NOVLX-LABEL: foldv16i16:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,16,0,16,0,3,3,1,1,0,1,2,3,4,5]
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: foldv16i16:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,16,0,16,0,3,3,1,1,0,1,2,3,4,5]
; BITALG-NEXT:    retq
;
; X32-AVX-LABEL: foldv16i16:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,16,0,16,0,3,3,1,1,0,1,2,3,4,5]
; X32-AVX-NEXT:    retl
  %out = call <16 x i16> @llvm.cttz.v16i16(<16 x i16> <i16 256, i16 -1, i16 0, i16 255, i16 -65536, i16 7, i16 24, i16 88, i16 -2, i16 254, i16 1, i16 2, i16 4, i16 8, i16 16, i16 32>, i1 0)
  ret <16 x i16> %out
}

define <16 x i16> @foldv16i16u() nounwind {
; AVX-LABEL: foldv16i16u:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,16,0,16,0,3,3,1,1,0,1,2,3,4,5]
; AVX-NEXT:    retq
;
; BITALG_NOVLX-LABEL: foldv16i16u:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,16,0,16,0,3,3,1,1,0,1,2,3,4,5]
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: foldv16i16u:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,16,0,16,0,3,3,1,1,0,1,2,3,4,5]
; BITALG-NEXT:    retq
;
; X32-AVX-LABEL: foldv16i16u:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,16,0,16,0,3,3,1,1,0,1,2,3,4,5]
; X32-AVX-NEXT:    retl
  %out = call <16 x i16> @llvm.cttz.v16i16(<16 x i16> <i16 256, i16 -1, i16 0, i16 255, i16 -65536, i16 7, i16 24, i16 88, i16 -2, i16 254, i16 1, i16 2, i16 4, i16 8, i16 16, i16 32>, i1 -1)
  ret <16 x i16> %out
}

define <32 x i8> @foldv32i8() nounwind {
; AVX-LABEL: foldv32i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,8,0,8,0,3,3,1,1,0,1,2,3,4,5,6,7,8,8,7,6,5,4,3,2,1,0,0,0,0,0]
; AVX-NEXT:    retq
;
; BITALG_NOVLX-LABEL: foldv32i8:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,8,0,8,0,3,3,1,1,0,1,2,3,4,5,6,7,8,8,7,6,5,4,3,2,1,0,0,0,0,0]
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: foldv32i8:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,8,0,8,0,3,3,1,1,0,1,2,3,4,5,6,7,8,8,7,6,5,4,3,2,1,0,0,0,0,0]
; BITALG-NEXT:    retq
;
; X32-AVX-LABEL: foldv32i8:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,8,0,8,0,3,3,1,1,0,1,2,3,4,5,6,7,8,8,7,6,5,4,3,2,1,0,0,0,0,0]
; X32-AVX-NEXT:    retl
  %out = call <32 x i8> @llvm.cttz.v32i8(<32 x i8> <i8 256, i8 -1, i8 0, i8 255, i8 -65536, i8 7, i8 24, i8 88, i8 -2, i8 254, i8 1, i8 2, i8 4, i8 8, i8 16, i8 32, i8 64, i8 128, i8 256, i8 -256, i8 -128, i8 -64, i8 -32, i8 -16, i8 -8, i8 -4, i8 -2, i8 -1, i8 3, i8 5, i8 7, i8 127>, i1 0)
  ret <32 x i8> %out
}

define <32 x i8> @foldv32i8u() nounwind {
; AVX-LABEL: foldv32i8u:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,8,0,8,0,3,3,1,1,0,1,2,3,4,5,6,7,8,8,7,6,5,4,3,2,1,0,0,0,0,0]
; AVX-NEXT:    retq
;
; BITALG_NOVLX-LABEL: foldv32i8u:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,8,0,8,0,3,3,1,1,0,1,2,3,4,5,6,7,8,8,7,6,5,4,3,2,1,0,0,0,0,0]
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: foldv32i8u:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,8,0,8,0,3,3,1,1,0,1,2,3,4,5,6,7,8,8,7,6,5,4,3,2,1,0,0,0,0,0]
; BITALG-NEXT:    retq
;
; X32-AVX-LABEL: foldv32i8u:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,8,0,8,0,3,3,1,1,0,1,2,3,4,5,6,7,8,8,7,6,5,4,3,2,1,0,0,0,0,0]
; X32-AVX-NEXT:    retl
  %out = call <32 x i8> @llvm.cttz.v32i8(<32 x i8> <i8 256, i8 -1, i8 0, i8 255, i8 -65536, i8 7, i8 24, i8 88, i8 -2, i8 254, i8 1, i8 2, i8 4, i8 8, i8 16, i8 32, i8 64, i8 128, i8 256, i8 -256, i8 -128, i8 -64, i8 -32, i8 -16, i8 -8, i8 -4, i8 -2, i8 -1, i8 3, i8 5, i8 7, i8 127>, i1 -1)
  ret <32 x i8> %out
}

declare <4 x i64> @llvm.cttz.v4i64(<4 x i64>, i1)
declare <8 x i32> @llvm.cttz.v8i32(<8 x i32>, i1)
declare <16 x i16> @llvm.cttz.v16i16(<16 x i16>, i1)
declare <32 x i8> @llvm.cttz.v32i8(<32 x i8>, i1)
