#ifndef _KEYMAP_H
#define _KEYMAP_H

#include <string>
#include <vector>

class Keymap {
  public:
    Keymap();
    void ReadMap(const std::string& filename);

    struct Key {
	Key(int a, int b, int c, int d):px(a),py(b),w(c),h(d){}
	int px, py, w, h;
	std::string look;
	std::string action;
    };


    const std::vector<Key>& GetCurrentKeys() const;
    bool GetKey(int x, int y, Key* k) const;
    std::string GetAction(int x, int y);
    void SetFunction(std::string f);

    int Height() const;
    int Width() const;

    int CurrentFunction() const;


  private:
    int GetFunId(std::string f);
    int width, height;
    std::vector<std::vector<Key> > keys;
    std::vector<std::string> functions;
    int function;
    bool is_alt;
    bool is_ctrl;
    bool keep_fun;
};


#endif
