/*
 * OMAP44xx DMM_CORE registers and bitfields
 *
 * Copyright (C) 2009-2010 Texas Instruments, Inc.
 *
 * Benoit Cousson (b-cousson@ti.com)
 * Santosh Shilimkar (santosh.shilimkar@ti.com)
 *
 * This file is automatically generated from the OMAP hardware databases.
 * We respectfully ask that any modifications to this file be coordinated
 * with the public linux-omap@vger.kernel.org mailing list and the
 * authors above to ensure that the autogeneration scripts are kept
 * up-to-date with the file contents.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef __ARCH_ARM_MACH_OMAP2_DMM_CORE_44XX_H
#define __ARCH_ARM_MACH_OMAP2_DMM_CORE_44XX_H


/* Base address */
#define OMAP44XX_DMM__DMM		0x4e000000

/* Registers offset */
#define OMAP44XX_DMM_REVISION		0x0000
#define OMAP44XX_DMM_HWINFO		0x0004
#define OMAP44XX_DMM_LISA_HWINFO	0x0008
#define OMAP44XX_DMM_SYSCONFIG		0x0010
#define OMAP44XX_DMM_LISA_LOCK		0x001c
#define OMAP44XX_DMM_LISA_MAP		0x0040
#define OMAP44XX_DMM_TILER_HWINFO	0x0208
#define OMAP44XX_DMM_TILER_OR		0x0220
#define OMAP44XX_DMM_PAT_HWINFO		0x0408
#define OMAP44XX_DMM_PAT_GEOMETRY	0x040c
#define OMAP44XX_DMM_PAT_CONFIG		0x0410
#define OMAP44XX_DMM_PAT_VIEW		0x0420
#define OMAP44XX_DMM_PAT_VIEW_MAP	0x0440
#define OMAP44XX_DMM_PAT_VIEW_MAP_BASE	0x0460
#define OMAP44XX_DMM_PAT_IRQ_EOI	0x0478
#define OMAP44XX_DMM_PAT_IRQSTATUS_RAW	0x0480
#define OMAP44XX_DMM_PAT_IRQSTATUS	0x0490
#define OMAP44XX_DMM_PAT_IRQENABLE_SET	0x04a0
#define OMAP44XX_DMM_PAT_IRQENABLE_CLR	0x04b0
#define OMAP44XX_DMM_PAT_STATUS		0x04c0
#define OMAP44XX_DMM_PAT_DESCR		0x0500
#define OMAP44XX_DMM_PAT_AREA		0x0504
#define OMAP44XX_DMM_PAT_CTRL		0x0508
#define OMAP44XX_DMM_PAT_DATA		0x050c
#define OMAP44XX_DMM_PEG_HWINFO		0x0608
#define OMAP44XX_DMM_PEG_PRIO		0x0620
#define OMAP44XX_DMM_PEG_PRIO_PAT	0x0640

/* Registers shifts and masks */

/* DMM_REVISION */
#define OMAP44XX_SCHEME_SHIFT		30
#define OMAP44XX_SCHEME_MASK		(0x3 << 30)
#define OMAP44XX_FUNC_SHIFT		16
#define OMAP44XX_FUNC_MASK		(0xfff << 16)
#define OMAP44XX_R_RTL_SHIFT		11
#define OMAP44XX_R_RTL_MASK		(0x1f << 11)
#define OMAP44XX_X_MAJOR_SHIFT		8
#define OMAP44XX_X_MAJOR_MASK		(0x7 << 8)
#define OMAP44XX_CUSTOM_SHIFT		6
#define OMAP44XX_CUSTOM_MASK		(0x3 << 6)
#define OMAP44XX_Y_MINOR_SHIFT		0
#define OMAP44XX_Y_MINOR_MASK		(0x3f << 0)

/* DMM_HWINFO */
#define OMAP44XX_ROBIN_CNT_SHIFT	16
#define OMAP44XX_ROBIN_CNT_MASK		(0xf << 16)
#define OMAP44XX_ELLA_CNT_SHIFT		8
#define OMAP44XX_ELLA_CNT_MASK		(0xf << 8)
#define OMAP44XX_TILER_CNT_SHIFT	0
#define OMAP44XX_TILER_CNT_MASK		(0xf << 0)

/* DMM_LISA_HWINFO */
#define OMAP44XX_SDRC_CNT_SHIFT		8
#define OMAP44XX_SDRC_CNT_MASK		(0xf << 8)
#define OMAP44XX_SECTION_CNT_SHIFT	0
#define OMAP44XX_SECTION_CNT_MASK	(0x1f << 0)

/* DMM_SYSCONFIG */
#define OMAP44XX_IDLE_MODE_SHIFT	2
#define OMAP44XX_IDLE_MODE_MASK		(0x3 << 2)

/* DMM_LISA_LOCK */
#define OMAP44XX_LOCK_SHIFT		0
#define OMAP44XX_LOCK_MASK		(1 << 0)

/* DMM_LISA_MAP */
#define OMAP44XX_SYS_ADDR_SHIFT		24
#define OMAP44XX_SYS_ADDR_MASK		(0xff << 24)
#define OMAP44XX_SYS_SIZE_SHIFT		20
#define OMAP44XX_SYS_SIZE_MASK		(0x7 << 20)
#define OMAP44XX_SDRC_INTL_SHIFT	18
#define OMAP44XX_SDRC_INTL_MASK		(0x3 << 18)
#define OMAP44XX_SDRC_ADDRSPC_SHIFT	16
#define OMAP44XX_SDRC_ADDRSPC_MASK	(0x3 << 16)
#define OMAP44XX_SDRC_MAP_SHIFT		8
#define OMAP44XX_SDRC_MAP_MASK		(0x3 << 8)
#define OMAP44XX_SDRC_ADDR_SHIFT	0
#define OMAP44XX_SDRC_ADDR_MASK		(0xff << 0)

/* DMM_TILER_HWINFO */
#define OMAP44XX_OR_CNT_SHIFT		0
#define OMAP44XX_OR_CNT_MASK		(0x7f << 0)

/* DMM_TILER_OR */
#define OMAP44XX_W7_SHIFT		31
#define OMAP44XX_W7_MASK		(1 << 31)
#define OMAP44XX_OR7_SHIFT		28
#define OMAP44XX_OR7_MASK		(0x7 << 28)
#define OMAP44XX_W6_SHIFT		27
#define OMAP44XX_W6_MASK		(1 << 27)
#define OMAP44XX_OR6_SHIFT		24
#define OMAP44XX_OR6_MASK		(0x7 << 24)
#define OMAP44XX_W5_SHIFT		23
#define OMAP44XX_W5_MASK		(1 << 23)
#define OMAP44XX_OR5_SHIFT		20
#define OMAP44XX_OR5_MASK		(0x7 << 20)
#define OMAP44XX_W4_SHIFT		19
#define OMAP44XX_W4_MASK		(1 << 19)
#define OMAP44XX_OR4_SHIFT		16
#define OMAP44XX_OR4_MASK		(0x7 << 16)
#define OMAP44XX_W3_SHIFT		15
#define OMAP44XX_W3_MASK		(1 << 15)
#define OMAP44XX_OR3_SHIFT		12
#define OMAP44XX_OR3_MASK		(0x7 << 12)
#define OMAP44XX_W2_SHIFT		11
#define OMAP44XX_W2_MASK		(1 << 11)
#define OMAP44XX_OR2_SHIFT		8
#define OMAP44XX_OR2_MASK		(0x7 << 8)
#define OMAP44XX_W1_SHIFT		7
#define OMAP44XX_W1_MASK		(1 << 7)
#define OMAP44XX_OR1_SHIFT		4
#define OMAP44XX_OR1_MASK		(0x7 << 4)
#define OMAP44XX_W0_SHIFT		3
#define OMAP44XX_W0_MASK		(1 << 3)
#define OMAP44XX_OR0_SHIFT		0
#define OMAP44XX_OR0_MASK		(0x7 << 0)

/* DMM_PAT_HWINFO */
#define OMAP44XX_ENGINE_CNT_SHIFT	24
#define OMAP44XX_ENGINE_CNT_MASK	(0x1f << 24)
#define OMAP44XX_LUT_CNT_SHIFT		16
#define OMAP44XX_LUT_CNT_MASK		(0x1f << 16)
#define OMAP44XX_VIEW_MAP_CNT_SHIFT	8
#define OMAP44XX_VIEW_MAP_CNT_MASK	(0xf << 8)
#define OMAP44XX_VIEW_CNT_SHIFT		0
#define OMAP44XX_VIEW_CNT_MASK		(0x7f << 0)

/* DMM_PAT_GEOMETRY */
#define OMAP44XX_CONT_HGHT_SHIFT	24
#define OMAP44XX_CONT_HGHT_MASK		(0x7 << 24)
#define OMAP44XX_CONT_WDTH_SHIFT	16
#define OMAP44XX_CONT_WDTH_MASK		(0xf << 16)
#define OMAP44XX_ADDR_RANGE_SHIFT	8
#define OMAP44XX_ADDR_RANGE_MASK	(0x3f << 8)
#define OMAP44XX_PAGE_SZ_SHIFT		0
#define OMAP44XX_PAGE_SZ_MASK		(0x1f << 0)

/* DMM_PAT_CONFIG */
#define OMAP44XX_MODE3_SHIFT		3
#define OMAP44XX_MODE3_MASK		(1 << 3)
#define OMAP44XX_MODE2_SHIFT		2
#define OMAP44XX_MODE2_MASK		(1 << 2)
#define OMAP44XX_MODE1_SHIFT		1
#define OMAP44XX_MODE1_MASK		(1 << 1)
#define OMAP44XX_MODE0_SHIFT		0
#define OMAP44XX_MODE0_MASK		(1 << 0)

/* DMM_PAT_VIEW */
#define OMAP44XX_V7_SHIFT		28
#define OMAP44XX_V7_MASK		(0x3 << 28)
#define OMAP44XX_V6_SHIFT		24
#define OMAP44XX_V6_MASK		(0x3 << 24)
#define OMAP44XX_V5_SHIFT		20
#define OMAP44XX_V5_MASK		(0x3 << 20)
#define OMAP44XX_V4_SHIFT		16
#define OMAP44XX_V4_MASK		(0x3 << 16)
#define OMAP44XX_V3_SHIFT		12
#define OMAP44XX_V3_MASK		(0x3 << 12)
#define OMAP44XX_V2_SHIFT		8
#define OMAP44XX_V2_MASK		(0x3 << 8)
#define OMAP44XX_V1_SHIFT		4
#define OMAP44XX_V1_MASK		(0x3 << 4)
#define OMAP44XX_V0_SHIFT		0
#define OMAP44XX_V0_MASK		(0x3 << 0)

/* DMM_PAT_VIEW_MAP */
#define OMAP44XX_ACCESS_PAGE_SHIFT	31
#define OMAP44XX_ACCESS_PAGE_MASK	(1 << 31)
#define OMAP44XX_CONT_PAGE_SHIFT	24
#define OMAP44XX_CONT_PAGE_MASK		(0xf << 24)
#define OMAP44XX_ACCESS_32_SHIFT	23
#define OMAP44XX_ACCESS_32_MASK		(1 << 23)
#define OMAP44XX_CONT_32_SHIFT		16
#define OMAP44XX_CONT_32_MASK		(0xf << 16)
#define OMAP44XX_ACCESS_16_SHIFT	15
#define OMAP44XX_ACCESS_16_MASK		(1 << 15)
#define OMAP44XX_CONT_16_SHIFT		8
#define OMAP44XX_CONT_16_MASK		(0xf << 8)
#define OMAP44XX_ACCESS_8_SHIFT		7
#define OMAP44XX_ACCESS_8_MASK		(1 << 7)
#define OMAP44XX_CONT_8_SHIFT		0
#define OMAP44XX_CONT_8_MASK		(0xf << 0)

/* DMM_PAT_VIEW_MAP_BASE */
#define OMAP44XX_BASE_ADDR_SHIFT	31
#define OMAP44XX_BASE_ADDR_MASK		(1 << 31)

/* DMM_PAT_IRQ_EOI */
#define OMAP44XX_EOI_SHIFT		0
#define OMAP44XX_EOI_MASK		(1 << 0)

/* DMM_PAT_IRQSTATUS_RAW */
#define OMAP44XX_ERR_LUT_MISS3_SHIFT	31
#define OMAP44XX_ERR_LUT_MISS3_MASK	(1 << 31)
#define OMAP44XX_ERR_UPD_DATA3_SHIFT	30
#define OMAP44XX_ERR_UPD_DATA3_MASK	(1 << 30)
#define OMAP44XX_ERR_UPD_CTRL3_SHIFT	29
#define OMAP44XX_ERR_UPD_CTRL3_MASK	(1 << 29)
#define OMAP44XX_ERR_UPD_AREA3_SHIFT	28
#define OMAP44XX_ERR_UPD_AREA3_MASK	(1 << 28)
#define OMAP44XX_ERR_INV_DATA3_SHIFT	27
#define OMAP44XX_ERR_INV_DATA3_MASK	(1 << 27)
#define OMAP44XX_ERR_INV_DSC3_SHIFT	26
#define OMAP44XX_ERR_INV_DSC3_MASK	(1 << 26)
#define OMAP44XX_FILL_LST3_SHIFT	25
#define OMAP44XX_FILL_LST3_MASK		(1 << 25)
#define OMAP44XX_FILL_DSC3_SHIFT	24
#define OMAP44XX_FILL_DSC3_MASK		(1 << 24)
#define OMAP44XX_ERR_LUT_MISS2_SHIFT	23
#define OMAP44XX_ERR_LUT_MISS2_MASK	(1 << 23)
#define OMAP44XX_ERR_UPD_DATA2_SHIFT	22
#define OMAP44XX_ERR_UPD_DATA2_MASK	(1 << 22)
#define OMAP44XX_ERR_UPD_CTRL2_SHIFT	21
#define OMAP44XX_ERR_UPD_CTRL2_MASK	(1 << 21)
#define OMAP44XX_ERR_UPD_AREA2_SHIFT	20
#define OMAP44XX_ERR_UPD_AREA2_MASK	(1 << 20)
#define OMAP44XX_ERR_INV_DATA2_SHIFT	19
#define OMAP44XX_ERR_INV_DATA2_MASK	(1 << 19)
#define OMAP44XX_ERR_INV_DSC2_SHIFT	18
#define OMAP44XX_ERR_INV_DSC2_MASK	(1 << 18)
#define OMAP44XX_FILL_LST2_SHIFT	17
#define OMAP44XX_FILL_LST2_MASK		(1 << 17)
#define OMAP44XX_FILL_DSC2_SHIFT	16
#define OMAP44XX_FILL_DSC2_MASK		(1 << 16)
#define OMAP44XX_ERR_LUT_MISS1_SHIFT	15
#define OMAP44XX_ERR_LUT_MISS1_MASK	(1 << 15)
#define OMAP44XX_ERR_UPD_DATA1_SHIFT	14
#define OMAP44XX_ERR_UPD_DATA1_MASK	(1 << 14)
#define OMAP44XX_ERR_UPD_CTRL1_SHIFT	13
#define OMAP44XX_ERR_UPD_CTRL1_MASK	(1 << 13)
#define OMAP44XX_ERR_UPD_AREA1_SHIFT	12
#define OMAP44XX_ERR_UPD_AREA1_MASK	(1 << 12)
#define OMAP44XX_ERR_INV_DATA1_SHIFT	11
#define OMAP44XX_ERR_INV_DATA1_MASK	(1 << 11)
#define OMAP44XX_ERR_INV_DSC1_SHIFT	10
#define OMAP44XX_ERR_INV_DSC1_MASK	(1 << 10)
#define OMAP44XX_FILL_LST1_SHIFT	9
#define OMAP44XX_FILL_LST1_MASK		(1 << 9)
#define OMAP44XX_FILL_DSC1_SHIFT	8
#define OMAP44XX_FILL_DSC1_MASK		(1 << 8)
#define OMAP44XX_ERR_LUT_MISS0_SHIFT	7
#define OMAP44XX_ERR_LUT_MISS0_MASK	(1 << 7)
#define OMAP44XX_ERR_UPD_DATA0_SHIFT	6
#define OMAP44XX_ERR_UPD_DATA0_MASK	(1 << 6)
#define OMAP44XX_ERR_UPD_CTRL0_SHIFT	5
#define OMAP44XX_ERR_UPD_CTRL0_MASK	(1 << 5)
#define OMAP44XX_ERR_UPD_AREA0_SHIFT	4
#define OMAP44XX_ERR_UPD_AREA0_MASK	(1 << 4)
#define OMAP44XX_ERR_INV_DATA0_SHIFT	3
#define OMAP44XX_ERR_INV_DATA0_MASK	(1 << 3)
#define OMAP44XX_ERR_INV_DSC0_SHIFT	2
#define OMAP44XX_ERR_INV_DSC0_MASK	(1 << 2)
#define OMAP44XX_FILL_LST0_SHIFT	1
#define OMAP44XX_FILL_LST0_MASK		(1 << 1)
#define OMAP44XX_FILL_DSC0_SHIFT	0
#define OMAP44XX_FILL_DSC0_MASK		(1 << 0)

/* DMM_PAT_IRQSTATUS */

/* DMM_PAT_IRQENABLE_SET */

/* DMM_PAT_IRQENABLE_CLR */

/* DMM_PAT_STATUS */
#define OMAP44XX_CNT_SHIFT		16
#define OMAP44XX_CNT_MASK		(0x1ff << 16)
#define OMAP44XX_ERROR_SHIFT		10
#define OMAP44XX_ERROR_MASK		(0x3f << 10)
#define OMAP44XX_BYPASSED_SHIFT		7
#define OMAP44XX_BYPASSED_MASK		(1 << 7)
#define OMAP44XX_LINKED_SHIFT		4
#define OMAP44XX_LINKED_MASK		(1 << 4)
#define OMAP44XX_DONE_SHIFT		3
#define OMAP44XX_DONE_MASK		(1 << 3)
#define OMAP44XX_RUN_SHIFT		2
#define OMAP44XX_RUN_MASK		(1 << 2)
#define OMAP44XX_VALID_SHIFT		1
#define OMAP44XX_VALID_MASK		(1 << 1)
#define OMAP44XX_READY_SHIFT		0
#define OMAP44XX_READY_MASK		(1 << 0)

/* DMM_PAT_DESCR */
#define OMAP44XX_ADDR_SHIFT		4
#define OMAP44XX_ADDR_MASK		(0xfffffff << 4)

/* DMM_PAT_AREA */
#define OMAP44XX_Y1_SHIFT		24
#define OMAP44XX_Y1_MASK		(0x7f << 24)
#define OMAP44XX_X1_SHIFT		16
#define OMAP44XX_X1_MASK		(0xff << 16)
#define OMAP44XX_Y0_SHIFT		8
#define OMAP44XX_Y0_MASK		(0x7f << 8)
#define OMAP44XX_X0_SHIFT		0
#define OMAP44XX_X0_MASK		(0xff << 0)

/* DMM_PAT_CTRL */
#define OMAP44XX_INITIATOR_SHIFT	28
#define OMAP44XX_INITIATOR_MASK		(0xf << 28)
#define OMAP44XX_SYNC_SHIFT		16
#define OMAP44XX_SYNC_MASK		(1 << 16)
#define OMAP44XX_DIRECTION_SHIFT	4
#define OMAP44XX_DIRECTION_MASK		(0x7 << 4)
#define OMAP44XX_START_SHIFT		0
#define OMAP44XX_START_MASK		(1 << 0)

/* DMM_PAT_DATA */

/* DMM_PEG_HWINFO */
#define OMAP44XX_PRIO_CNT_SHIFT		0
#define OMAP44XX_PRIO_CNT_MASK		(0x7f << 0)

/* DMM_PEG_PRIO */
#define OMAP44XX_P7_SHIFT		28
#define OMAP44XX_P7_MASK		(0x7 << 28)
#define OMAP44XX_P6_SHIFT		24
#define OMAP44XX_P6_MASK		(0x7 << 24)
#define OMAP44XX_P5_SHIFT		20
#define OMAP44XX_P5_MASK		(0x7 << 20)
#define OMAP44XX_P4_SHIFT		16
#define OMAP44XX_P4_MASK		(0x7 << 16)
#define OMAP44XX_P3_SHIFT		12
#define OMAP44XX_P3_MASK		(0x7 << 12)
#define OMAP44XX_P2_SHIFT		8
#define OMAP44XX_P2_MASK		(0x7 << 8)
#define OMAP44XX_P1_SHIFT		4
#define OMAP44XX_P1_MASK		(0x7 << 4)
#define OMAP44XX_P0_SHIFT		0
#define OMAP44XX_P0_MASK		(0x7 << 0)

/* DMM_PEG_PRIO_PAT */
#define OMAP44XX_W_PAT_SHIFT		3
#define OMAP44XX_W_PAT_MASK		(1 << 3)
#define OMAP44XX_P_PAT_SHIFT		0
#define OMAP44XX_P_PAT_MASK		(0x7 << 0)
#endif
