/*
 * Copyright (C) 2011 NVIDIA, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307, USA
 */

#include <linux/kernel.h>
#include <linux/init.h>

#include "board.h"
#include "board-cardhu.h"
#include "tegra3_emc.h"
#include "fuse.h"


static const struct tegra_emc_table cardhu_emc_tables_h5tc2g[] = {
	{
		0x30,		/* Rev 3.0 */
		27000,		/* SDRAM frquency */
		{
			0x00000001,   /* EMC_RC */
			0x00000004,   /* EMC_RFC */
			0x00000000,   /* EMC_RAS */
			0x00000000,   /* EMC_RP */
			0x00000002,   /* EMC_R2W */
			0x0000000a,   /* EMC_W2R */
			0x00000003,   /* EMC_R2P */
			0x0000000b,   /* EMC_W2P */
			0x00000000,   /* EMC_RD_RCD */
			0x00000000,   /* EMC_WR_RCD */
			0x00000003,   /* EMC_RRD */
			0x00000001,   /* EMC_REXT */
			0x00000000,   /* EMC_WEXT */
			0x00000005,   /* EMC_WDV */
			0x00000005,   /* EMC_QUSE */
			0x00000004,   /* EMC_QRST */
			0x00000007,   /* EMC_QSAFE */
			0x0000000d,   /* EMC_RDV */
			0x000000cb,   /* EMC_REFRESH */
			0x00000000,   /* EMC_BURST_REFRESH_NUM */
			0x00000032,   /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002,   /* EMC_PDEX2WR */
			0x00000002,   /* EMC_PDEX2RD */
			0x00000001,   /* EMC_PCHG2PDEN */
			0x00000000,   /* EMC_ACT2PDEN */
			0x00000007,   /* EMC_AR2PDEN */
			0x0000000f,   /* EMC_RW2PDEN */
			0x00000005,   /* EMC_TXSR */
			0x00000005,   /* EMC_TXSRDLL */
			0x00000004,   /* EMC_TCKE */
			0x00000001,   /* EMC_TFAW */
			0x00000000,   /* EMC_TRPAB */
			0x00000004,   /* EMC_TCLKSTABLE */
			0x00000005,   /* EMC_TCLKSTOP */
			0x000000d3,   /* EMC_TREFBW */
			0x00000000,   /* EMC_QUSE_EXTRA */
			0x00000004,   /* EMC_FBIO_CFG6 */
			0x00000000,   /* EMC_ODT_WRITE */
			0x00000000,   /* EMC_ODT_READ */
			0x00006288,   /* EMC_FBIO_CFG5 */
			0xd0780421,   /* EMC_CFG_DIG_DLL */
			0x00008000,   /* EMC_CFG_DIG_DLL_PERIOD */
			0x00080000,   /* EMC_DLL_XFORM_DQS0 */
			0x00080000,   /* EMC_DLL_XFORM_DQS1 */
			0x00080000,   /* EMC_DLL_XFORM_DQS2 */
			0x00080000,   /* EMC_DLL_XFORM_DQS3 */
			0x00080000,   /* EMC_DLL_XFORM_DQS4 */
			0x00080000,   /* EMC_DLL_XFORM_DQS5 */
			0x00080000,   /* EMC_DLL_XFORM_DQS6 */
			0x00080000,   /* EMC_DLL_XFORM_DQS7 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE0 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE1 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE2 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE3 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE4 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE5 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE6 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE7 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS7 */
			0x00080000,   /* EMC_DLL_XFORM_DQ0 */
			0x00080000,   /* EMC_DLL_XFORM_DQ1 */
			0x00080000,   /* EMC_DLL_XFORM_DQ2 */
			0x00080000,   /* EMC_DLL_XFORM_DQ3 */
			0x000003e0,   /* EMC_XM2CMDPADCTRL */
			0x0800211d,   /* EMC_XM2DQSPADCTRL2 */
			0x00000000,   /* EMC_XM2DQPADCTRL2 */
			0x77ffc084,   /* EMC_XM2CLKPADCTRL */
			0x01f1f108,   /* EMC_XM2COMPPADCTRL */
			0x07075504,   /* EMC_XM2VTTGENPADCTRL */
			0x00000007,   /* EMC_XM2VTTGENPADCTRL2 */
			0x0800012d,   /* EMC_XM2QUSEPADCTRL */
			0x08000000,   /* EMC_XM2DQSPADCTRL3 */
			0x00000802,   /* EMC_CTT_TERM_CTRL */
			0x00000000,   /* EMC_ZCAL_INTERVAL */
			0x00000040,   /* EMC_ZCAL_WAIT_CNT */
			0x000c000c,   /* EMC_MRS_WAIT_CNT */
			0xa0f10000,   /* EMC_AUTO_CAL_CONFIG */
			0x00000000,   /* EMC_CTT */
			0x00000000,   /* EMC_CTT_DURATION */
			0x8000029e,   /* EMC_DYN_SELF_REF_CONTROL */
			0x00000001,   /* MC_EMEM_ARB_CFG */
			0x8000000d,   /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001,   /* MC_EMEM_ARB_TIMING_RCD */
			0x00000004,   /* MC_EMEM_ARB_TIMING_RP */
			0x00000005,   /* MC_EMEM_ARB_TIMING_RC */
			0x00000001,   /* MC_EMEM_ARB_TIMING_RAS */
			0x00000001,   /* MC_EMEM_ARB_TIMING_FAW */
			0x00000003,   /* MC_EMEM_ARB_TIMING_RRD */
			0x00000004,   /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000f,   /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000006,   /* MC_EMEM_ARB_TIMING_R2R */
			0x00000005,   /* MC_EMEM_ARB_TIMING_W2W */
			0x00000007,   /* MC_EMEM_ARB_TIMING_R2W */
			0x0000000f,   /* MC_EMEM_ARB_TIMING_W2R */
			0x0f070506,   /* MC_EMEM_ARB_DA_TURNS */
			0x00140905,   /* MC_EMEM_ARB_DA_COVERS */
			0x78430306,   /* MC_EMEM_ARB_MISC0 */
			0x001f0001,   /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		0x00000040,	/* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff,	/* EMC_AUTO_CAL_INTERVAL */
		0x00000000,	/* EMC_CFG.PERIODIC_QRST */
		0x00001221,	/* Mode Register 0 */
		0x00100003,	/* Mode Register 1 */
		0x00200008,	/* Mode Register 2 */
	},
	{
		0x30,		/* Rev 3.0 */
		54000,		/* SDRAM frquency */
		{
			0x00000002,   /* EMC_RC */
			0x00000008,   /* EMC_RFC */
			0x00000001,   /* EMC_RAS */
			0x00000000,   /* EMC_RP */
			0x00000002,   /* EMC_R2W */
			0x0000000a,   /* EMC_W2R */
			0x00000003,   /* EMC_R2P */
			0x0000000b,   /* EMC_W2P */
			0x00000000,   /* EMC_RD_RCD */
			0x00000000,   /* EMC_WR_RCD */
			0x00000003,   /* EMC_RRD */
			0x00000001,   /* EMC_REXT */
			0x00000000,   /* EMC_WEXT */
			0x00000005,   /* EMC_WDV */
			0x00000005,   /* EMC_QUSE */
			0x00000004,   /* EMC_QRST */
			0x00000007,   /* EMC_QSAFE */
			0x0000000d,   /* EMC_RDV */
			0x00000198,   /* EMC_REFRESH */
			0x00000000,   /* EMC_BURST_REFRESH_NUM */
			0x00000066,   /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002,   /* EMC_PDEX2WR */
			0x00000002,   /* EMC_PDEX2RD */
			0x00000001,   /* EMC_PCHG2PDEN */
			0x00000000,   /* EMC_ACT2PDEN */
			0x00000007,   /* EMC_AR2PDEN */
			0x0000000f,   /* EMC_RW2PDEN */
			0x0000000a,   /* EMC_TXSR */
			0x0000000a,   /* EMC_TXSRDLL */
			0x00000004,   /* EMC_TCKE */
			0x00000002,   /* EMC_TFAW */
			0x00000000,   /* EMC_TRPAB */
			0x00000004,   /* EMC_TCLKSTABLE */
			0x00000005,   /* EMC_TCLKSTOP */
			0x000001a6,   /* EMC_TREFBW */
			0x00000000,   /* EMC_QUSE_EXTRA */
			0x00000004,   /* EMC_FBIO_CFG6 */
			0x00000000,   /* EMC_ODT_WRITE */
			0x00000000,   /* EMC_ODT_READ */
			0x00006288,   /* EMC_FBIO_CFG5 */
			0xd0780421,   /* EMC_CFG_DIG_DLL */
			0x00008000,   /* EMC_CFG_DIG_DLL_PERIOD */
			0x00080000,   /* EMC_DLL_XFORM_DQS0 */
			0x00080000,   /* EMC_DLL_XFORM_DQS1 */
			0x00080000,   /* EMC_DLL_XFORM_DQS2 */
			0x00080000,   /* EMC_DLL_XFORM_DQS3 */
			0x00080000,   /* EMC_DLL_XFORM_DQS4 */
			0x00080000,   /* EMC_DLL_XFORM_DQS5 */
			0x00080000,   /* EMC_DLL_XFORM_DQS6 */
			0x00080000,   /* EMC_DLL_XFORM_DQS7 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE0 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE1 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE2 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE3 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE4 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE5 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE6 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE7 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS7 */
			0x00080000,   /* EMC_DLL_XFORM_DQ0 */
			0x00080000,   /* EMC_DLL_XFORM_DQ1 */
			0x00080000,   /* EMC_DLL_XFORM_DQ2 */
			0x00080000,   /* EMC_DLL_XFORM_DQ3 */
			0x000003e0,   /* EMC_XM2CMDPADCTRL */
			0x0800211d,   /* EMC_XM2DQSPADCTRL2 */
			0x00000000,   /* EMC_XM2DQPADCTRL2 */
			0x77ffc084,   /* EMC_XM2CLKPADCTRL */
			0x01f1f108,   /* EMC_XM2COMPPADCTRL */
			0x07075504,   /* EMC_XM2VTTGENPADCTRL */
			0x00000007,   /* EMC_XM2VTTGENPADCTRL2 */
			0x0800012d,   /* EMC_XM2QUSEPADCTRL */
			0x08000000,   /* EMC_XM2DQSPADCTRL3 */
			0x00000802,   /* EMC_CTT_TERM_CTRL */
			0x00000000,   /* EMC_ZCAL_INTERVAL */
			0x00000040,   /* EMC_ZCAL_WAIT_CNT */
			0x000c000c,   /* EMC_MRS_WAIT_CNT */
			0xa0f10000,   /* EMC_AUTO_CAL_CONFIG */
			0x00000000,   /* EMC_CTT */
			0x00000000,   /* EMC_CTT_DURATION */
			0x80000439,   /* EMC_DYN_SELF_REF_CONTROL */
			0x00000001,   /* MC_EMEM_ARB_CFG */
			0x80000014,   /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001,   /* MC_EMEM_ARB_TIMING_RCD */
			0x00000004,   /* MC_EMEM_ARB_TIMING_RP */
			0x00000005,   /* MC_EMEM_ARB_TIMING_RC */
			0x00000001,   /* MC_EMEM_ARB_TIMING_RAS */
			0x00000001,   /* MC_EMEM_ARB_TIMING_FAW */
			0x00000003,   /* MC_EMEM_ARB_TIMING_RRD */
			0x00000004,   /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000f,   /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000006,   /* MC_EMEM_ARB_TIMING_R2R */
			0x00000005,   /* MC_EMEM_ARB_TIMING_W2W */
			0x00000007,   /* MC_EMEM_ARB_TIMING_R2W */
			0x0000000f,   /* MC_EMEM_ARB_TIMING_W2R */
			0x0f070506,   /* MC_EMEM_ARB_DA_TURNS */
			0x00140905,   /* MC_EMEM_ARB_DA_COVERS */
			0x78430506,   /* MC_EMEM_ARB_MISC0 */
			0x001f0001,   /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		0x00000040,	/* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff,	/* EMC_AUTO_CAL_INTERVAL */
		0x00000000,	/* EMC_CFG.PERIODIC_QRST */
		0x00001221,	/* Mode Register 0 */
		0x00100003,	/* Mode Register 1 */
		0x00200008,	/* Mode Register 2 */
	},
	{
		0x30,		/* Rev 3.0 */
		108000,		/* SDRAM frquency */
		{
			0x00000005,   /* EMC_RC */
			0x00000011,   /* EMC_RFC */
			0x00000003,   /* EMC_RAS */
			0x00000001,   /* EMC_RP */
			0x00000002,   /* EMC_R2W */
			0x0000000a,   /* EMC_W2R */
			0x00000003,   /* EMC_R2P */
			0x0000000b,   /* EMC_W2P */
			0x00000001,   /* EMC_RD_RCD */
			0x00000001,   /* EMC_WR_RCD */
			0x00000003,   /* EMC_RRD */
			0x00000001,   /* EMC_REXT */
			0x00000000,   /* EMC_WEXT */
			0x00000005,   /* EMC_WDV */
			0x00000005,   /* EMC_QUSE */
			0x00000004,   /* EMC_QRST */
			0x00000007,   /* EMC_QSAFE */
			0x0000000d,   /* EMC_RDV */
			0x00000330,   /* EMC_REFRESH */
			0x00000000,   /* EMC_BURST_REFRESH_NUM */
			0x000000cc,   /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002,   /* EMC_PDEX2WR */
			0x00000002,   /* EMC_PDEX2RD */
			0x00000001,   /* EMC_PCHG2PDEN */
			0x00000000,   /* EMC_ACT2PDEN */
			0x00000007,   /* EMC_AR2PDEN */
			0x0000000f,   /* EMC_RW2PDEN */
			0x00000013,   /* EMC_TXSR */
			0x00000013,   /* EMC_TXSRDLL */
			0x00000004,   /* EMC_TCKE */
			0x00000004,   /* EMC_TFAW */
			0x00000000,   /* EMC_TRPAB */
			0x00000004,   /* EMC_TCLKSTABLE */
			0x00000005,   /* EMC_TCLKSTOP */
			0x0000034b,   /* EMC_TREFBW */
			0x00000000,   /* EMC_QUSE_EXTRA */
			0x00000004,   /* EMC_FBIO_CFG6 */
			0x00000000,   /* EMC_ODT_WRITE */
			0x00000000,   /* EMC_ODT_READ */
			0x00006288,   /* EMC_FBIO_CFG5 */
			0xd0780421,   /* EMC_CFG_DIG_DLL */
			0x00008000,   /* EMC_CFG_DIG_DLL_PERIOD */
			0x00080000,   /* EMC_DLL_XFORM_DQS0 */
			0x00080000,   /* EMC_DLL_XFORM_DQS1 */
			0x00080000,   /* EMC_DLL_XFORM_DQS2 */
			0x00080000,   /* EMC_DLL_XFORM_DQS3 */
			0x00080000,   /* EMC_DLL_XFORM_DQS4 */
			0x00080000,   /* EMC_DLL_XFORM_DQS5 */
			0x00080000,   /* EMC_DLL_XFORM_DQS6 */
			0x00080000,   /* EMC_DLL_XFORM_DQS7 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE0 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE1 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE2 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE3 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE4 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE5 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE6 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE7 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS7 */
			0x00080000,   /* EMC_DLL_XFORM_DQ0 */
			0x00080000,   /* EMC_DLL_XFORM_DQ1 */
			0x00080000,   /* EMC_DLL_XFORM_DQ2 */
			0x00080000,   /* EMC_DLL_XFORM_DQ3 */
			0x000003e0,   /* EMC_XM2CMDPADCTRL */
			0x0800211d,   /* EMC_XM2DQSPADCTRL2 */
			0x00000000,   /* EMC_XM2DQPADCTRL2 */
			0x77ffc084,   /* EMC_XM2CLKPADCTRL */
			0x01f1f108,   /* EMC_XM2COMPPADCTRL */
			0x07075504,   /* EMC_XM2VTTGENPADCTRL */
			0x00000007,   /* EMC_XM2VTTGENPADCTRL2 */
			0x0800012d,   /* EMC_XM2QUSEPADCTRL */
			0x08000000,   /* EMC_XM2DQSPADCTRL3 */
			0x00000802,   /* EMC_CTT_TERM_CTRL */
			0x00000000,   /* EMC_ZCAL_INTERVAL */
			0x00000040,   /* EMC_ZCAL_WAIT_CNT */
			0x000c000c,   /* EMC_MRS_WAIT_CNT */
			0xa0f10000,   /* EMC_AUTO_CAL_CONFIG */
			0x00000000,   /* EMC_CTT */
			0x00000000,   /* EMC_CTT_DURATION */
			0x8000076e,   /* EMC_DYN_SELF_REF_CONTROL */
			0x00000003,   /* MC_EMEM_ARB_CFG */
			0x80000027,   /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001,   /* MC_EMEM_ARB_TIMING_RCD */
			0x00000004,   /* MC_EMEM_ARB_TIMING_RP */
			0x00000006,   /* MC_EMEM_ARB_TIMING_RC */
			0x00000002,   /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003,   /* MC_EMEM_ARB_TIMING_FAW */
			0x00000003,   /* MC_EMEM_ARB_TIMING_RRD */
			0x00000004,   /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000f,   /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000006,   /* MC_EMEM_ARB_TIMING_R2R */
			0x00000005,   /* MC_EMEM_ARB_TIMING_W2W */
			0x00000007,   /* MC_EMEM_ARB_TIMING_R2W */
			0x0000000f,   /* MC_EMEM_ARB_TIMING_W2R */
			0x0f070506,   /* MC_EMEM_ARB_DA_TURNS */
			0x00140906,   /* MC_EMEM_ARB_DA_COVERS */
			0x78440a07,   /* MC_EMEM_ARB_MISC0 */
			0x001f0001,   /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		0x00000040,	/* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff,	/* EMC_AUTO_CAL_INTERVAL */
		0x00000000,	/* EMC_CFG.PERIODIC_QRST */
		0x00001221,	/* Mode Register 0 */
		0x00100003,	/* Mode Register 1 */
		0x00200008,	/* Mode Register 2 */
	},
	{
		0x30,		/* Rev 3.0 */
		416000,		/* SDRAM frequency */
		{
			0x00000013,   /* EMC_RC */
			0x00000041,   /* EMC_RFC */
			0x0000000d,   /* EMC_RAS */
			0x00000004,   /* EMC_RP */
			0x00000002,   /* EMC_R2W */
			0x00000009,   /* EMC_W2R */
			0x00000002,   /* EMC_R2P */
			0x0000000c,   /* EMC_W2P */
			0x00000004,   /* EMC_RD_RCD */
			0x00000004,   /* EMC_WR_RCD */
			0x00000002,   /* EMC_RRD */
			0x00000001,   /* EMC_REXT */
			0x00000000,   /* EMC_WEXT */
			0x00000005,   /* EMC_WDV */
			0x00000008,   /* EMC_QUSE */
			0x00000006,   /* EMC_QRST */
			0x00000008,   /* EMC_QSAFE */
			0x00000010,   /* EMC_RDV */
			0x00000c6c,   /* EMC_REFRESH */
			0x00000000,   /* EMC_BURST_REFRESH_NUM */
			0x0000031b,   /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001,   /* EMC_PDEX2WR */
			0x00000001,   /* EMC_PDEX2RD */
			0x00000001,   /* EMC_PCHG2PDEN */
			0x00000000,   /* EMC_ACT2PDEN */
			0x00000008,   /* EMC_AR2PDEN */
			0x00000011,   /* EMC_RW2PDEN */
			0x00000047,   /* EMC_TXSR */
			0x00000200,   /* EMC_TXSRDLL */
			0x00000004,   /* EMC_TCKE */
			0x0000000d,   /* EMC_TFAW */
			0x00000000,   /* EMC_TRPAB */
			0x00000004,   /* EMC_TCLKSTABLE */
			0x00000005,   /* EMC_TCLKSTOP */
			0x00000cad,   /* EMC_TREFBW */
			0x00000000,   /* EMC_QUSE_EXTRA */
			0x00000006,   /* EMC_FBIO_CFG6 */
			0x00000000,   /* EMC_ODT_WRITE */
			0x00000000,   /* EMC_ODT_READ */
			0x00007088,   /* EMC_FBIO_CFG5 */
			0xf0120441,   /* EMC_CFG_DIG_DLL */
			0x00008000,   /* EMC_CFG_DIG_DLL_PERIOD */
			0x00010000,   /* EMC_DLL_XFORM_DQS0 */
			0x00010000,   /* EMC_DLL_XFORM_DQS1 */
			0x00010000,   /* EMC_DLL_XFORM_DQS2 */
			0x00010000,   /* EMC_DLL_XFORM_DQS3 */
			0x00010000,   /* EMC_DLL_XFORM_DQS4 */
			0x00010000,   /* EMC_DLL_XFORM_DQS5 */
			0x00010000,   /* EMC_DLL_XFORM_DQS6 */
			0x00010000,   /* EMC_DLL_XFORM_DQS7 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE0 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE1 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE2 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE3 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE4 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE5 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE6 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE7 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS7 */
			0x00020000,   /* EMC_DLL_XFORM_DQ0 */
			0x00020000,   /* EMC_DLL_XFORM_DQ1 */
			0x00020000,   /* EMC_DLL_XFORM_DQ2 */
			0x00020000,   /* EMC_DLL_XFORM_DQ3 */
			0x000006a0,   /* EMC_XM2CMDPADCTRL */
			0x0800013d,   /* EMC_XM2DQSPADCTRL2 */
			0x00000000,   /* EMC_XM2DQPADCTRL2 */
			0x77ffc084,   /* EMC_XM2CLKPADCTRL */
			0x01f1f50f,   /* EMC_XM2COMPPADCTRL */
			0x07077404,   /* EMC_XM2VTTGENPADCTRL */
			0x00000007,   /* EMC_XM2VTTGENPADCTRL2 */
			0x0800011d,   /* EMC_XM2QUSEPADCTRL */
			0x08000021,   /* EMC_XM2DQSPADCTRL3 */
			0x00000802,   /* EMC_CTT_TERM_CTRL */
			0x00000000,   /* EMC_ZCAL_INTERVAL */
			0x00000040,   /* EMC_ZCAL_WAIT_CNT */
			0x01be000c,   /* EMC_MRS_WAIT_CNT */
			0xa0f10404,   /* EMC_AUTO_CAL_CONFIG */
			0x00000000,   /* EMC_CTT */
			0x00000000,   /* EMC_CTT_DURATION */
			0x000020ae,   /* EMC_DYN_SELF_REF_CONTROL */
			0x00000006,   /* MC_EMEM_ARB_CFG */
			0x8000004b,   /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001,   /* MC_EMEM_ARB_TIMING_RCD */
			0x00000002,   /* MC_EMEM_ARB_TIMING_RP */
			0x0000000a,   /* MC_EMEM_ARB_TIMING_RC */
			0x00000006,   /* MC_EMEM_ARB_TIMING_RAS */
			0x00000006,   /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001,   /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002,   /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000009,   /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002,   /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002,   /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003,   /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006,   /* MC_EMEM_ARB_TIMING_W2R */
			0x06030202,   /* MC_EMEM_ARB_DA_TURNS */
			0x000e070a,   /* MC_EMEM_ARB_DA_COVERS */
			0x7027130b,   /* MC_EMEM_ARB_MISC0 */
			0x001f0000,   /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		0x00000040,	/* EMC_ZCAL_WAIT_CNT after clock change */
		0x00000010,	/* EMC_AUTO_CAL_INTERVAL */
		0x00000000,	/* EMC_CFG.PERIODIC_QRST */
		0x00001941,	/* Mode Register 0 */
		0x00100002,	/* Mode Register 1 */
		0x00200008,	/* Mode Register 2 */
	},
	{
		0x30,		/* Rev 3.0 */
		533000,		/* SDRAM frquency */
		{
			0x00000018,   /* EMC_RC */
			0x00000054,   /* EMC_RFC */
			0x00000011,   /* EMC_RAS */
			0x00000006,   /* EMC_RP */
			0x00000003,   /* EMC_R2W */
			0x00000009,   /* EMC_W2R */
			0x00000002,   /* EMC_R2P */
			0x0000000d,   /* EMC_W2P */
			0x00000006,   /* EMC_RD_RCD */
			0x00000006,   /* EMC_WR_RCD */
			0x00000002,   /* EMC_RRD */
			0x00000001,   /* EMC_REXT */
			0x00000000,   /* EMC_WEXT */
			0x00000005,   /* EMC_WDV */
			0x00000008,   /* EMC_QUSE */
			0x00000006,   /* EMC_QRST */
			0x00000008,   /* EMC_QSAFE */
			0x00000010,   /* EMC_RDV */
			0x00000ffd,   /* EMC_REFRESH */
			0x00000000,   /* EMC_BURST_REFRESH_NUM */
			0x000003ff,   /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002,   /* EMC_PDEX2WR */
			0x00000002,   /* EMC_PDEX2RD */
			0x00000001,   /* EMC_PCHG2PDEN */
			0x00000000,   /* EMC_ACT2PDEN */
			0x0000000a,   /* EMC_AR2PDEN */
			0x00000012,   /* EMC_RW2PDEN */
			0x0000005b,   /* EMC_TXSR */
			0x00000200,   /* EMC_TXSRDLL */
			0x00000004,   /* EMC_TCKE */
			0x00000010,   /* EMC_TFAW */
			0x00000000,   /* EMC_TRPAB */
			0x00000005,   /* EMC_TCLKSTABLE */
			0x00000006,   /* EMC_TCLKSTOP */
			0x0000103e,   /* EMC_TREFBW */
			0x00000000,   /* EMC_QUSE_EXTRA */
			0x00000006,   /* EMC_FBIO_CFG6 */
			0x00000000,   /* EMC_ODT_WRITE */
			0x00000000,   /* EMC_ODT_READ */
			0x00007088,   /* EMC_FBIO_CFG5 */
			0xf0120441,   /* EMC_CFG_DIG_DLL */
			0x00008000,   /* EMC_CFG_DIG_DLL_PERIOD */
			0x00010000,   /* EMC_DLL_XFORM_DQS0 */
			0x00010000,   /* EMC_DLL_XFORM_DQS1 */
			0x00010000,   /* EMC_DLL_XFORM_DQS2 */
			0x00010000,   /* EMC_DLL_XFORM_DQS3 */
			0x00010000,   /* EMC_DLL_XFORM_DQS4 */
			0x00010000,   /* EMC_DLL_XFORM_DQS5 */
			0x00010000,   /* EMC_DLL_XFORM_DQS6 */
			0x00010000,   /* EMC_DLL_XFORM_DQS7 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE0 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE1 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE2 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE3 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE4 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE5 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE6 */
			0x00000000,   /* EMC_DLL_XFORM_QUSE7 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000,   /* EMC_DLI_TRIM_TXDQS7 */
			0x00020000,   /* EMC_DLL_XFORM_DQ0 */
			0x00020000,   /* EMC_DLL_XFORM_DQ1 */
			0x00020000,   /* EMC_DLL_XFORM_DQ2 */
			0x00020000,   /* EMC_DLL_XFORM_DQ3 */
			0x000006a0,   /* EMC_XM2CMDPADCTRL */
			0x0800013d,   /* EMC_XM2DQSPADCTRL2 */
			0x00000000,   /* EMC_XM2DQPADCTRL2 */
			0x77ffc084,   /* EMC_XM2CLKPADCTRL */
			0x01f1f50f,   /* EMC_XM2COMPPADCTRL */
			0x07077404,   /* EMC_XM2VTTGENPADCTRL */
			0x00000007,   /* EMC_XM2VTTGENPADCTRL2 */
			0x0800011d,   /* EMC_XM2QUSEPADCTRL */
			0x08000021,   /* EMC_XM2DQSPADCTRL3 */
			0x00000802,   /* EMC_CTT_TERM_CTRL */
			0x00000000,   /* EMC_ZCAL_INTERVAL */
			0x00000040,   /* EMC_ZCAL_WAIT_CNT */
			0x01ab000c,   /* EMC_MRS_WAIT_CNT */
			0xa0f10404,   /* EMC_AUTO_CAL_CONFIG */
			0x00000000,   /* EMC_CTT */
			0x00000000,   /* EMC_CTT_DURATION */
			0x000020ae,   /* EMC_DYN_SELF_REF_CONTROL */
			0x00000008,   /* MC_EMEM_ARB_CFG */
			0x80000060,   /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000002,   /* MC_EMEM_ARB_TIMING_RCD */
			0x00000003,   /* MC_EMEM_ARB_TIMING_RP */
			0x0000000d,   /* MC_EMEM_ARB_TIMING_RC */
			0x00000008,   /* MC_EMEM_ARB_TIMING_RAS */
			0x00000007,   /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001,   /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002,   /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000009,   /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002,   /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002,   /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003,   /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006,   /* MC_EMEM_ARB_TIMING_W2R */
			0x06030202,   /* MC_EMEM_ARB_DA_TURNS */
			0x0010090d,   /* MC_EMEM_ARB_DA_COVERS */
			0x7028180e,   /* MC_EMEM_ARB_MISC0 */
			0x001f0000,   /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		0x00000040,	/* EMC_ZCAL_WAIT_CNT after clock change */
		0x00000010,	/* EMC_AUTO_CAL_INTERVAL */
		0x00000000,	/* EMC_CFG.PERIODIC_QRST */
		0x00001941,	/* Mode Register 0 */
		0x00100002,	/* Mode Register 1 */
		0x00200008,	/* Mode Register 2 */
	},
};

static const struct tegra_emc_table cardhu_emc_tables_h5tc2g_a2[] = {
	{
		0x32,       /* Rev 3.2 */
		25500,      /* SDRAM frequency */
		{
			0x00000001, /* EMC_RC */
			0x00000003, /* EMC_RFC */
			0x00000000, /* EMC_RAS */
			0x00000000, /* EMC_RP */
			0x00000002, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000000, /* EMC_RD_RCD */
			0x00000000, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_QUSE */
			0x00000004, /* EMC_QRST */
			0x00000007, /* EMC_QSAFE */
			0x0000000c, /* EMC_RDV */
			0x000000bd, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x0000002f, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000007, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000005, /* EMC_TXSR */
			0x00000005, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000001, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x000000c3, /* EMC_TREFBW */
			0x00000000, /* EMC_QUSE_EXTRA */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00006288, /* EMC_FBIO_CFG5 */
			0x007800a4, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00080000, /* EMC_DLL_XFORM_DQS0 */
			0x00080000, /* EMC_DLL_XFORM_DQS1 */
			0x00080000, /* EMC_DLL_XFORM_DQS2 */
			0x00080000, /* EMC_DLL_XFORM_DQS3 */
			0x00080000, /* EMC_DLL_XFORM_DQS4 */
			0x00080000, /* EMC_DLL_XFORM_DQS5 */
			0x00080000, /* EMC_DLL_XFORM_DQS6 */
			0x00080000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00080000, /* EMC_DLL_XFORM_DQ0 */
			0x00080000, /* EMC_DLL_XFORM_DQ1 */
			0x00080000, /* EMC_DLL_XFORM_DQ2 */
			0x00080000, /* EMC_DLL_XFORM_DQ3 */
			0x000002a0, /* EMC_XM2CMDPADCTRL */
			0x0800211c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc084, /* EMC_XM2CLKPADCTRL */
			0x01f1f108, /* EMC_XM2COMPPADCTRL */
			0x05057404, /* EMC_XM2VTTGENPADCTRL */
			0x54000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000168, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000040, /* EMC_ZCAL_WAIT_CNT */
			0x000c000c, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80000280, /* EMC_DYN_SELF_REF_CONTROL */
			0x00020001, /* MC_EMEM_ARB_CFG */
			0xc0000010, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000001, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06020102, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0402, /* MC_EMEM_ARB_DA_COVERS */
			0x74430303, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0xd8000000, /* EMC_FBIO_SPARE */
			0xff00ff00, /* EMC_CFG_RSV */
		},
		0x00000040, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000000, /* EMC_CFG.PERIODIC_QRST */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000001, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		51000,      /* SDRAM frequency */
		{
			0x00000002, /* EMC_RC */
			0x00000008, /* EMC_RFC */
			0x00000001, /* EMC_RAS */
			0x00000000, /* EMC_RP */
			0x00000002, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000000, /* EMC_RD_RCD */
			0x00000000, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_QUSE */
			0x00000004, /* EMC_QRST */
			0x00000007, /* EMC_QSAFE */
			0x0000000c, /* EMC_RDV */
			0x00000181, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000060, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000007, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000009, /* EMC_TXSR */
			0x00000009, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000002, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x0000018e, /* EMC_TREFBW */
			0x00000000, /* EMC_QUSE_EXTRA */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00006288, /* EMC_FBIO_CFG5 */
			0x007800a4, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00080000, /* EMC_DLL_XFORM_DQS0 */
			0x00080000, /* EMC_DLL_XFORM_DQS1 */
			0x00080000, /* EMC_DLL_XFORM_DQS2 */
			0x00080000, /* EMC_DLL_XFORM_DQS3 */
			0x00080000, /* EMC_DLL_XFORM_DQS4 */
			0x00080000, /* EMC_DLL_XFORM_DQS5 */
			0x00080000, /* EMC_DLL_XFORM_DQS6 */
			0x00080000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00080000, /* EMC_DLL_XFORM_DQ0 */
			0x00080000, /* EMC_DLL_XFORM_DQ1 */
			0x00080000, /* EMC_DLL_XFORM_DQ2 */
			0x00080000, /* EMC_DLL_XFORM_DQ3 */
			0x000002a0, /* EMC_XM2CMDPADCTRL */
			0x0800211c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc084, /* EMC_XM2CLKPADCTRL */
			0x01f1f108, /* EMC_XM2COMPPADCTRL */
			0x05057404, /* EMC_XM2VTTGENPADCTRL */
			0x54000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000168, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000040, /* EMC_ZCAL_WAIT_CNT */
			0x000c000c, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x8000040b, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000001, /* MC_EMEM_ARB_CFG */
			0xc0000010, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000001, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06020102, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0402, /* MC_EMEM_ARB_DA_COVERS */
			0x73430303, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0xd8000000, /* EMC_FBIO_SPARE */
			0xff00ff00, /* EMC_CFG_RSV */
		},
		0x00000040, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000000, /* EMC_CFG.PERIODIC_QRST */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000001, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		102000,     /* SDRAM frequency */
		{
			0x00000004, /* EMC_RC */
			0x00000010, /* EMC_RFC */
			0x00000003, /* EMC_RAS */
			0x00000001, /* EMC_RP */
			0x00000002, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000001, /* EMC_RD_RCD */
			0x00000001, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_QUSE */
			0x00000004, /* EMC_QRST */
			0x00000007, /* EMC_QSAFE */
			0x0000000c, /* EMC_RDV */
			0x00000303, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000000c0, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000007, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000012, /* EMC_TXSR */
			0x00000012, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000004, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x0000031c, /* EMC_TREFBW */
			0x00000000, /* EMC_QUSE_EXTRA */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00006288, /* EMC_FBIO_CFG5 */
			0x007800a4, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00080000, /* EMC_DLL_XFORM_DQS0 */
			0x00080000, /* EMC_DLL_XFORM_DQS1 */
			0x00080000, /* EMC_DLL_XFORM_DQS2 */
			0x00080000, /* EMC_DLL_XFORM_DQS3 */
			0x00080000, /* EMC_DLL_XFORM_DQS4 */
			0x00080000, /* EMC_DLL_XFORM_DQS5 */
			0x00080000, /* EMC_DLL_XFORM_DQS6 */
			0x00080000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00080000, /* EMC_DLL_XFORM_DQ0 */
			0x00080000, /* EMC_DLL_XFORM_DQ1 */
			0x00080000, /* EMC_DLL_XFORM_DQ2 */
			0x00080000, /* EMC_DLL_XFORM_DQ3 */
			0x000002a0, /* EMC_XM2CMDPADCTRL */
			0x0800211c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc084, /* EMC_XM2CLKPADCTRL */
			0x01f1f108, /* EMC_XM2COMPPADCTRL */
			0x05057404, /* EMC_XM2VTTGENPADCTRL */
			0x54000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000168, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000040, /* EMC_ZCAL_WAIT_CNT */
			0x000c000c, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80000713, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000001, /* MC_EMEM_ARB_CFG */
			0xc0000018, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000003, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000001, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06020102, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0403, /* MC_EMEM_ARB_DA_COVERS */
			0x72830504, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0xd8000000, /* EMC_FBIO_SPARE */
			0xff00ff00, /* EMC_CFG_RSV */
		},
		0x00000040, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000000, /* EMC_CFG.PERIODIC_QRST */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000001, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		204000,     /* SDRAM frequency */
		{
			0x00000009, /* EMC_RC */
			0x00000020, /* EMC_RFC */
			0x00000007, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000002, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000005, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_QUSE */
			0x00000004, /* EMC_QRST */
			0x00000009, /* EMC_QSAFE */
			0x0000000b, /* EMC_RDV */
			0x00000607, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000181, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000007, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000023, /* EMC_TXSR */
			0x00000023, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000007, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000638, /* EMC_TREFBW */
			0x00000006, /* EMC_QUSE_EXTRA */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00004288, /* EMC_FBIO_CFG5 */
			0x004400a4, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00080000, /* EMC_DLL_XFORM_DQS0 */
			0x00080000, /* EMC_DLL_XFORM_DQS1 */
			0x00080000, /* EMC_DLL_XFORM_DQS2 */
			0x00080000, /* EMC_DLL_XFORM_DQS3 */
			0x00080000, /* EMC_DLL_XFORM_DQS4 */
			0x00080000, /* EMC_DLL_XFORM_DQS5 */
			0x00080000, /* EMC_DLL_XFORM_DQS6 */
			0x00080000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00080000, /* EMC_DLL_XFORM_DQ0 */
			0x00080000, /* EMC_DLL_XFORM_DQ1 */
			0x00080000, /* EMC_DLL_XFORM_DQ2 */
			0x00080000, /* EMC_DLL_XFORM_DQ3 */
			0x000002a0, /* EMC_XM2CMDPADCTRL */
			0x0800211c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77fff884, /* EMC_XM2CLKPADCTRL */
			0x01f1f108, /* EMC_XM2COMPPADCTRL */
			0x05057404, /* EMC_XM2VTTGENPADCTRL */
			0x54000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000168, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x000c000c, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80000d22, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000003, /* MC_EMEM_ARB_CFG */
			0xc0000025, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000005, /* MC_EMEM_ARB_TIMING_RC */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06020102, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0505, /* MC_EMEM_ARB_DA_COVERS */
			0x72440a06, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0xe8000000, /* EMC_FBIO_SPARE */
			0xff00ff00, /* EMC_CFG_RSV */
		},
		0x00000040, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000001, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		375000,     /* SDRAM frequency */
		{
			0x00000011, /* EMC_RC */
			0x0000003a, /* EMC_RFC */
			0x0000000c, /* EMC_RAS */
			0x00000004, /* EMC_RP */
			0x00000003, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000002, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000004, /* EMC_RD_RCD */
			0x00000004, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000004, /* EMC_WDV */
			0x00000006, /* EMC_QUSE */
			0x00000004, /* EMC_QRST */
			0x00000008, /* EMC_QSAFE */
			0x0000000d, /* EMC_RDV */
			0x00000b2d, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000002cb, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000008, /* EMC_PDEX2WR */
			0x00000008, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000007, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000040, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000009, /* EMC_TCKE */
			0x0000000c, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000b6d, /* EMC_TREFBW */
			0x00000000, /* EMC_QUSE_EXTRA */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00007088, /* EMC_FBIO_CFG5 */
			0x00200084, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x0003c000, /* EMC_DLL_XFORM_DQS0 */
			0x0003c000, /* EMC_DLL_XFORM_DQS1 */
			0x0003c000, /* EMC_DLL_XFORM_DQS2 */
			0x0003c000, /* EMC_DLL_XFORM_DQS3 */
			0x0003c000, /* EMC_DLL_XFORM_DQS4 */
			0x0003c000, /* EMC_DLL_XFORM_DQS5 */
			0x0003c000, /* EMC_DLL_XFORM_DQS6 */
			0x0003c000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00040000, /* EMC_DLL_XFORM_DQ0 */
			0x00040000, /* EMC_DLL_XFORM_DQ1 */
			0x00040000, /* EMC_DLL_XFORM_DQ2 */
			0x00040000, /* EMC_DLL_XFORM_DQ3 */
			0x000002a0, /* EMC_XM2CMDPADCTRL */
			0x0800013d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77fff884, /* EMC_XM2CLKPADCTRL */
			0x01f1f508, /* EMC_XM2COMPPADCTRL */
			0x05057404, /* EMC_XM2VTTGENPADCTRL */
			0x54000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x080001e8, /* EMC_XM2QUSEPADCTRL */
			0x08000021, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x0184000c, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x8000174b, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000005, /* MC_EMEM_ARB_CFG */
			0x80000044, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RP */
			0x00000009, /* MC_EMEM_ARB_TIMING_RC */
			0x00000005, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000005, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030202, /* MC_EMEM_ARB_DA_TURNS */
			0x000d0709, /* MC_EMEM_ARB_DA_COVERS */
			0x75c6110a, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x58000000, /* EMC_FBIO_SPARE */
			0xff00ff88, /* EMC_CFG_RSV */
		},
		0x00000040, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000000, /* EMC_CFG.PERIODIC_QRST */
		0x80000521, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200000, /* Mode Register 2 */
		0x00000000, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		400000,     /* SDRAM frequency */
		{
			0x00000012, /* EMC_RC */
			0x00000040, /* EMC_RFC */
			0x0000000d, /* EMC_RAS */
			0x00000004, /* EMC_RP */
			0x00000002, /* EMC_R2W */
			0x00000009, /* EMC_W2R */
			0x00000002, /* EMC_R2P */
			0x0000000c, /* EMC_W2P */
			0x00000004, /* EMC_RD_RCD */
			0x00000004, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000007, /* EMC_QUSE */
			0x00000005, /* EMC_QRST */
			0x00000008, /* EMC_QSAFE */
			0x0000000e, /* EMC_RDV */
			0x00000c2e, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x0000030b, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000008, /* EMC_PDEX2WR */
			0x00000008, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000008, /* EMC_AR2PDEN */
			0x00000011, /* EMC_RW2PDEN */
			0x00000046, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x0000000a, /* EMC_TCKE */
			0x0000000d, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000c6f, /* EMC_TREFBW */
			0x00000000, /* EMC_QUSE_EXTRA */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00007088, /* EMC_FBIO_CFG5 */
			0x001c0084, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00034000, /* EMC_DLL_XFORM_DQS0 */
			0x00034000, /* EMC_DLL_XFORM_DQS1 */
			0x00034000, /* EMC_DLL_XFORM_DQS2 */
			0x00034000, /* EMC_DLL_XFORM_DQS3 */
			0x00034000, /* EMC_DLL_XFORM_DQS4 */
			0x00034000, /* EMC_DLL_XFORM_DQS5 */
			0x00034000, /* EMC_DLL_XFORM_DQS6 */
			0x00034000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00040000, /* EMC_DLL_XFORM_DQ0 */
			0x00040000, /* EMC_DLL_XFORM_DQ1 */
			0x00040000, /* EMC_DLL_XFORM_DQ2 */
			0x00040000, /* EMC_DLL_XFORM_DQ3 */
			0x000002a0, /* EMC_XM2CMDPADCTRL */
			0x0800013d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77fff884, /* EMC_XM2CLKPADCTRL */
			0x01f1f508, /* EMC_XM2COMPPADCTRL */
			0x05057404, /* EMC_XM2VTTGENPADCTRL */
			0x54000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x080001e8, /* EMC_XM2QUSEPADCTRL */
			0x08000021, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x017f000c, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80001941, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000006, /* MC_EMEM_ARB_CFG */
			0x8000004a, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RP */
			0x0000000a, /* MC_EMEM_ARB_TIMING_RC */
			0x00000006, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000006, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000009, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030202, /* MC_EMEM_ARB_DA_TURNS */
			0x000e070a, /* MC_EMEM_ARB_DA_COVERS */
			0x7547130b, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x58000000, /* EMC_FBIO_SPARE */
			0xff00ff88, /* EMC_CFG_RSV */
		},
		0x00000040, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000000, /* EMC_CFG.PERIODIC_QRST */
		0x80000731, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		450000,     /* SDRAM frequency */
		{
			0x00000014, /* EMC_RC */
			0x00000046, /* EMC_RFC */
			0x0000000e, /* EMC_RAS */
			0x00000005, /* EMC_RP */
			0x00000003, /* EMC_R2W */
			0x00000009, /* EMC_W2R */
			0x00000002, /* EMC_R2P */
			0x0000000c, /* EMC_W2P */
			0x00000005, /* EMC_RD_RCD */
			0x00000005, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000007, /* EMC_QUSE */
			0x00000005, /* EMC_QRST */
			0x0000000a, /* EMC_QSAFE */
			0x0000000e, /* EMC_RDV */
			0x00000d76, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x0000035d, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000009, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000009, /* EMC_AR2PDEN */
			0x00000011, /* EMC_RW2PDEN */
			0x0000004d, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x0000000e, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000db6, /* EMC_TREFBW */
			0x00000000, /* EMC_QUSE_EXTRA */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00007088, /* EMC_FBIO_CFG5 */
			0x00180084, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00022000, /* EMC_DLL_XFORM_DQS0 */
			0x00022000, /* EMC_DLL_XFORM_DQS1 */
			0x00022000, /* EMC_DLL_XFORM_DQS2 */
			0x00022000, /* EMC_DLL_XFORM_DQS3 */
			0x00022000, /* EMC_DLL_XFORM_DQS4 */
			0x00022000, /* EMC_DLL_XFORM_DQS5 */
			0x00022000, /* EMC_DLL_XFORM_DQS6 */
			0x00022000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00030000, /* EMC_DLL_XFORM_DQ0 */
			0x00030000, /* EMC_DLL_XFORM_DQ1 */
			0x00030000, /* EMC_DLL_XFORM_DQ2 */
			0x00030000, /* EMC_DLL_XFORM_DQ3 */
			0x000002a0, /* EMC_XM2CMDPADCTRL */
			0x0800013d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77fff884, /* EMC_XM2CLKPADCTRL */
			0x01f1f508, /* EMC_XM2COMPPADCTRL */
			0x05057404, /* EMC_XM2VTTGENPADCTRL */
			0x54000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x080001e8, /* EMC_XM2QUSEPADCTRL */
			0x08000021, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x0178000c, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80001bc0, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000006, /* MC_EMEM_ARB_CFG */
			0x80000051, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000002, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RP */
			0x0000000b, /* MC_EMEM_ARB_TIMING_RC */
			0x00000006, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000006, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000009, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030202, /* MC_EMEM_ARB_DA_TURNS */
			0x000f080b, /* MC_EMEM_ARB_DA_COVERS */
			0x70a7150c, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0xe8000000, /* EMC_FBIO_SPARE */
			0xff00ff8b, /* EMC_CFG_RSV */
		},
		0x00000040, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000000, /* EMC_CFG.PERIODIC_QRST */
		0x80000731, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		533000,     /* SDRAM frequency */
		{
			0x00000018, /* EMC_RC */
			0x00000054, /* EMC_RFC */
			0x00000011, /* EMC_RAS */
			0x00000006, /* EMC_RP */
			0x00000003, /* EMC_R2W */
			0x00000009, /* EMC_W2R */
			0x00000002, /* EMC_R2P */
			0x0000000d, /* EMC_W2P */
			0x00000006, /* EMC_RD_RCD */
			0x00000006, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000008, /* EMC_QUSE */
			0x00000006, /* EMC_QRST */
			0x00000008, /* EMC_QSAFE */
			0x00000010, /* EMC_RDV */
			0x00000ffd, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000003ff, /* EMC_PRE_REFRESH_REQ_CNT */
			0x0000000b, /* EMC_PDEX2WR */
			0x0000000b, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x0000000a, /* EMC_AR2PDEN */
			0x00000012, /* EMC_RW2PDEN */
			0x0000005b, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x0000000d, /* EMC_TCKE */
			0x00000010, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000006, /* EMC_TCLKSTOP */
			0x0000103e, /* EMC_TREFBW */
			0x00000000, /* EMC_QUSE_EXTRA */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00007088, /* EMC_FBIO_CFG5 */
			0x00120084, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00010000, /* EMC_DLL_XFORM_DQS0 */
			0x00010000, /* EMC_DLL_XFORM_DQS1 */
			0x00010000, /* EMC_DLL_XFORM_DQS2 */
			0x00010000, /* EMC_DLL_XFORM_DQS3 */
			0x00010000, /* EMC_DLL_XFORM_DQS4 */
			0x00010000, /* EMC_DLL_XFORM_DQS5 */
			0x00010000, /* EMC_DLL_XFORM_DQS6 */
			0x00010000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00020000, /* EMC_DLL_XFORM_DQ0 */
			0x00020000, /* EMC_DLL_XFORM_DQ1 */
			0x00020000, /* EMC_DLL_XFORM_DQ2 */
			0x00020000, /* EMC_DLL_XFORM_DQ3 */
			0x000006a0, /* EMC_XM2CMDPADCTRL */
			0x0800013d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc084, /* EMC_XM2CLKPADCTRL */
			0x01f1f508, /* EMC_XM2COMPPADCTRL */
			0x05057404, /* EMC_XM2VTTGENPADCTRL */
			0x54000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000168, /* EMC_XM2QUSEPADCTRL */
			0x08000021, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000040, /* EMC_ZCAL_WAIT_CNT */
			0x01ab000c, /* EMC_MRS_WAIT_CNT */
			0xa0f10404, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x800020ae, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000008, /* MC_EMEM_ARB_CFG */
			0x80000060, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000002, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RP */
			0x0000000d, /* MC_EMEM_ARB_TIMING_RC */
			0x00000008, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000007, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000009, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030202, /* MC_EMEM_ARB_DA_TURNS */
			0x0010090d, /* MC_EMEM_ARB_DA_COVERS */
			0x7028180e, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x00000000, /* EMC_FBIO_SPARE */
			0xff00ff00, /* EMC_CFG_RSV */
		},
		0x00000040, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000000, /* EMC_CFG.PERIODIC_QRST */
		0x80000941, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		667000,     /* SDRAM frequency */
		{
			0x0000001f, /* EMC_RC */
			0x00000069, /* EMC_RFC */
			0x00000016, /* EMC_RAS */
			0x00000008, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x0000000c, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x00000011, /* EMC_W2P */
			0x00000008, /* EMC_RD_RCD */
			0x00000008, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000007, /* EMC_WDV */
			0x0000000b, /* EMC_QUSE */
			0x00000009, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x00000011, /* EMC_RDV */
			0x00001412, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000504, /* EMC_PRE_REFRESH_REQ_CNT */
			0x0000000e, /* EMC_PDEX2WR */
			0x0000000e, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x0000000c, /* EMC_AR2PDEN */
			0x00000016, /* EMC_RW2PDEN */
			0x00000072, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000010, /* EMC_TCKE */
			0x00000015, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000006, /* EMC_TCLKSTABLE */
			0x00000007, /* EMC_TCLKSTOP */
			0x00001453, /* EMC_TREFBW */
			0x0000000c, /* EMC_QUSE_EXTRA */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00005088, /* EMC_FBIO_CFG5 */
			0x40070191, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00000008, /* EMC_DLL_XFORM_DQS0 */
			0x00000008, /* EMC_DLL_XFORM_DQS1 */
			0x00000008, /* EMC_DLL_XFORM_DQS2 */
			0x00000008, /* EMC_DLL_XFORM_DQS3 */
			0x00000008, /* EMC_DLL_XFORM_DQS4 */
			0x00000008, /* EMC_DLL_XFORM_DQS5 */
			0x00000008, /* EMC_DLL_XFORM_DQS6 */
			0x00000008, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000008, /* EMC_DLL_XFORM_DQ0 */
			0x00000008, /* EMC_DLL_XFORM_DQ1 */
			0x00000008, /* EMC_DLL_XFORM_DQ2 */
			0x00000008, /* EMC_DLL_XFORM_DQ3 */
			0x000002a0, /* EMC_XM2CMDPADCTRL */
			0x0600013d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77fff884, /* EMC_XM2CLKPADCTRL */
			0x01f1f508, /* EMC_XM2COMPPADCTRL */
			0x07077404, /* EMC_XM2VTTGENPADCTRL */
			0x54000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x080001e8, /* EMC_XM2QUSEPADCTRL */
			0x07000021, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x01d6000c, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x800028a5, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* MC_EMEM_ARB_CFG */
			0x80000079, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000003, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000004, /* MC_EMEM_ARB_TIMING_RP */
			0x00000010, /* MC_EMEM_ARB_TIMING_RC */
			0x0000000a, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000a, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000b, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000008, /* MC_EMEM_ARB_TIMING_W2R */
			0x08040202, /* MC_EMEM_ARB_DA_TURNS */
			0x00140c10, /* MC_EMEM_ARB_DA_COVERS */
			0x734a1f11, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0xf8000000, /* EMC_FBIO_SPARE */
			0xff00ff01, /* EMC_CFG_RSV */
		},
		0x00000040, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x80000b71, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200018, /* Mode Register 2 */
		0x00000000, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		750000,     /* SDRAM frequency */
		{
			0x00000025, /* EMC_RC */
			0x0000007e, /* EMC_RFC */
			0x0000001a, /* EMC_RAS */
			0x00000009, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x0000000d, /* EMC_W2R */
			0x00000004, /* EMC_R2P */
			0x00000013, /* EMC_W2P */
			0x00000009, /* EMC_RD_RCD */
			0x00000009, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000007, /* EMC_WDV */
			0x0000000b, /* EMC_QUSE */
			0x00000009, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x00000011, /* EMC_RDV */
			0x0000169a, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000608, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000012, /* EMC_PDEX2WR */
			0x00000012, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x0000000f, /* EMC_AR2PDEN */
			0x00000018, /* EMC_RW2PDEN */
			0x00000088, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000014, /* EMC_TCKE */
			0x00000018, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000007, /* EMC_TCLKSTABLE */
			0x00000008, /* EMC_TCLKSTOP */
			0x00001860, /* EMC_TREFBW */
			0x0000000c, /* EMC_QUSE_EXTRA */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00005088, /* EMC_FBIO_CFG5 */
			0xf0080191, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00000008, /* EMC_DLL_XFORM_DQS0 */
			0x00000008, /* EMC_DLL_XFORM_DQS1 */
			0x00000008, /* EMC_DLL_XFORM_DQS2 */
			0x00000008, /* EMC_DLL_XFORM_DQS3 */
			0x00000008, /* EMC_DLL_XFORM_DQS4 */
			0x00000008, /* EMC_DLL_XFORM_DQS5 */
			0x00000008, /* EMC_DLL_XFORM_DQS6 */
			0x00000008, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x0000000c, /* EMC_DLL_XFORM_DQ0 */
			0x0000000c, /* EMC_DLL_XFORM_DQ1 */
			0x0000000c, /* EMC_DLL_XFORM_DQ2 */
			0x0000000c, /* EMC_DLL_XFORM_DQ3 */
			0x000002a0, /* EMC_XM2CMDPADCTRL */
			0x0600013d, /* EMC_XM2DQSPADCTRL2 */
			0x22220000, /* EMC_XM2DQPADCTRL2 */
			0x77fff884, /* EMC_XM2CLKPADCTRL */
			0x01f1f501, /* EMC_XM2COMPPADCTRL */
			0x07077404, /* EMC_XM2VTTGENPADCTRL */
			0x54000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x080001e8, /* EMC_XM2QUSEPADCTRL */
			0x07000021, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x0180000c, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x8000308c, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000c, /* MC_EMEM_ARB_CFG */
			0x80000090, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000004, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000005, /* MC_EMEM_ARB_TIMING_RP */
			0x00000013, /* MC_EMEM_ARB_TIMING_RC */
			0x0000000c, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000b, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000002, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000c, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000008, /* MC_EMEM_ARB_TIMING_W2R */
			0x08040202, /* MC_EMEM_ARB_DA_TURNS */
			0x00160d13, /* MC_EMEM_ARB_DA_COVERS */
			0x72ac2414, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0xf8000000, /* EMC_FBIO_SPARE */
			0xff00ff49, /* EMC_CFG_RSV */
		},
		0x00000040, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x80000d71, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200018, /* Mode Register 2 */
		0x00000000, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		800000,     /* SDRAM frequency */
		{
			0x00000025, /* EMC_RC */
			0x0000007e, /* EMC_RFC */
			0x0000001a, /* EMC_RAS */
			0x00000009, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x0000000d, /* EMC_W2R */
			0x00000004, /* EMC_R2P */
			0x00000013, /* EMC_W2P */
			0x00000009, /* EMC_RD_RCD */
			0x00000009, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000007, /* EMC_WDV */
			0x0000000b, /* EMC_QUSE */
			0x00000009, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x00000011, /* EMC_RDV */
			0x00001820, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000608, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000012, /* EMC_PDEX2WR */
			0x00000012, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x0000000f, /* EMC_AR2PDEN */
			0x00000018, /* EMC_RW2PDEN */
			0x00000088, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000014, /* EMC_TCKE */
			0x00000018, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000007, /* EMC_TCLKSTABLE */
			0x00000008, /* EMC_TCLKSTOP */
			0x00001860, /* EMC_TREFBW */
			0x0000000c, /* EMC_QUSE_EXTRA */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00005088, /* EMC_FBIO_CFG5 */
			0xf0070191, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x0000800a, /* EMC_DLL_XFORM_DQS0 */
			0x0000000a, /* EMC_DLL_XFORM_DQS1 */
			0x0000000a, /* EMC_DLL_XFORM_DQS2 */
			0x0000000a, /* EMC_DLL_XFORM_DQS3 */
			0x0000000a, /* EMC_DLL_XFORM_DQS4 */
			0x0000000a, /* EMC_DLL_XFORM_DQS5 */
			0x0000000a, /* EMC_DLL_XFORM_DQS6 */
			0x0000000a, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x007fc00a, /* EMC_DLL_XFORM_DQ0 */
			0x0000000a, /* EMC_DLL_XFORM_DQ1 */
			0x0000000a, /* EMC_DLL_XFORM_DQ2 */
			0x0000000a, /* EMC_DLL_XFORM_DQ3 */
			0x000002a0, /* EMC_XM2CMDPADCTRL */
			0x0600013d, /* EMC_XM2DQSPADCTRL2 */
			0x22220000, /* EMC_XM2DQPADCTRL2 */
			0x77fff884, /* EMC_XM2CLKPADCTRL */
			0x01f1f501, /* EMC_XM2COMPPADCTRL */
			0x07077404, /* EMC_XM2VTTGENPADCTRL */
			0x54000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x080001e8, /* EMC_XM2QUSEPADCTRL */
			0x07000021, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x0180000c, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x8000308c, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000c, /* MC_EMEM_ARB_CFG */
			0x80000090, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000004, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000005, /* MC_EMEM_ARB_TIMING_RP */
			0x00000013, /* MC_EMEM_ARB_TIMING_RC */
			0x0000000c, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000b, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000002, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000c, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000008, /* MC_EMEM_ARB_TIMING_W2R */
			0x08040202, /* MC_EMEM_ARB_DA_TURNS */
			0x00160d13, /* MC_EMEM_ARB_DA_COVERS */
			0x72ac2414, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0xf8000000, /* EMC_FBIO_SPARE */
			0xff00ff49, /* EMC_CFG_RSV */
		},
		0x00000040, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x80000d71, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200018, /* Mode Register 2 */
		0x00000000, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		900000,     /* SDRAM frequency */
		{
			0x0000002a, /* EMC_RC */
			0x0000008e, /* EMC_RFC */
			0x0000001e, /* EMC_RAS */
			0x0000000b, /* EMC_RP */
			0x00000006, /* EMC_R2W */
			0x0000000f, /* EMC_W2R */
			0x00000005, /* EMC_R2P */
			0x00000016, /* EMC_W2P */
			0x0000000b, /* EMC_RD_RCD */
			0x0000000b, /* EMC_WR_RCD */
			0x00000004, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000008, /* EMC_WDV */
			0x0000000d, /* EMC_QUSE */
			0x0000000b, /* EMC_QRST */
			0x0000000b, /* EMC_QSAFE */
			0x00000014, /* EMC_RDV */
			0x00001b2c, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000006cb, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000004, /* EMC_PDEX2WR */
			0x00000014, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000011, /* EMC_AR2PDEN */
			0x0000001b, /* EMC_RW2PDEN */
			0x00000099, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000006, /* EMC_TCKE */
			0x0000001b, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000008, /* EMC_TCLKSTABLE */
			0x00000009, /* EMC_TCLKSTOP */
			0x00001b6c, /* EMC_TREFBW */
			0x0000000e, /* EMC_QUSE_EXTRA */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00005088, /* EMC_FBIO_CFG5 */
			0xf0040191, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x0000800a, /* EMC_DLL_XFORM_DQS0 */
			0x0000000a, /* EMC_DLL_XFORM_DQS1 */
			0x007fc00a, /* EMC_DLL_XFORM_DQS2 */
			0x0000000a, /* EMC_DLL_XFORM_DQS3 */
			0x0000000a, /* EMC_DLL_XFORM_DQS4 */
			0x0000000a, /* EMC_DLL_XFORM_DQS5 */
			0x0000000a, /* EMC_DLL_XFORM_DQS6 */
			0x0000000a, /* EMC_DLL_XFORM_DQS7 */
			0x0001c000, /* EMC_DLL_XFORM_QUSE0 */
			0x0001c000, /* EMC_DLL_XFORM_QUSE1 */
			0x0001c000, /* EMC_DLL_XFORM_QUSE2 */
			0x0001c000, /* EMC_DLL_XFORM_QUSE3 */
			0x0001c000, /* EMC_DLL_XFORM_QUSE4 */
			0x0001c000, /* EMC_DLL_XFORM_QUSE5 */
			0x0001c000, /* EMC_DLL_XFORM_QUSE6 */
			0x0001c000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x007fc00a, /* EMC_DLL_XFORM_DQ0 */
			0x0000000a, /* EMC_DLL_XFORM_DQ1 */
			0x0000000a, /* EMC_DLL_XFORM_DQ2 */
			0x0000000a, /* EMC_DLL_XFORM_DQ3 */
			0x000002a0, /* EMC_XM2CMDPADCTRL */
			0x0600013d, /* EMC_XM2DQSPADCTRL2 */
			0x22220000, /* EMC_XM2DQPADCTRL2 */
			0x77fff884, /* EMC_XM2CLKPADCTRL */
			0x01f1f501, /* EMC_XM2COMPPADCTRL */
			0x07077404, /* EMC_XM2VTTGENPADCTRL */
			0x54000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x080001e8, /* EMC_XM2QUSEPADCTRL */
			0x07000021, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000120, /* EMC_ZCAL_WAIT_CNT */
			0x0128000c, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x8000367d, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000d, /* MC_EMEM_ARB_CFG */
			0x800000a2, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000005, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000006, /* MC_EMEM_ARB_TIMING_RP */
			0x00000016, /* MC_EMEM_ARB_TIMING_RC */
			0x0000000e, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000d, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000002, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000004, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000e, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000009, /* MC_EMEM_ARB_TIMING_W2R */
			0x09050202, /* MC_EMEM_ARB_DA_TURNS */
			0x001a1016, /* MC_EMEM_ARB_DA_COVERS */
			0x714e2917, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0xe8000000, /* EMC_FBIO_SPARE */
			0xff00ff4b, /* EMC_CFG_RSV */
		},
		0x00000048, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x80000f15, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200020, /* Mode Register 2 */
		0x00000000, /* EMC_CFG.DYN_SELF_REF */
	},
};

static const struct tegra_emc_table cardhu_emc_tables_h5tc2g_a2_2GB1R[] = {
	{
		0x32,       /* Rev 3.2 */
		51000,      /* SDRAM frequency */
		{
			0x00000002, /* EMC_RC */
			0x0000000d, /* EMC_RFC */
			0x00000001, /* EMC_RAS */
			0x00000000, /* EMC_RP */
			0x00000002, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000000, /* EMC_RD_RCD */
			0x00000000, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_QUSE */
			0x00000004, /* EMC_QRST */
			0x00000009, /* EMC_QSAFE */
			0x0000000b, /* EMC_RDV */
			0x00000181, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000060, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000007, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x0000000e, /* EMC_TXSR */
			0x0000000e, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000002, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x0000018e, /* EMC_TREFBW */
			0x00000006, /* EMC_QUSE_EXTRA */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00004288, /* EMC_FBIO_CFG5 */
			0x007800a4, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x000fc000, /* EMC_DLL_XFORM_DQS0 */
			0x000fc000, /* EMC_DLL_XFORM_DQS1 */
			0x000fc000, /* EMC_DLL_XFORM_DQS2 */
			0x000fc000, /* EMC_DLL_XFORM_DQS3 */
			0x000fc000, /* EMC_DLL_XFORM_DQS4 */
			0x000fc000, /* EMC_DLL_XFORM_DQS5 */
			0x000fc000, /* EMC_DLL_XFORM_DQS6 */
			0x000fc000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x000fc000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x000002a0, /* EMC_XM2CMDPADCTRL */
			0x0800211c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77fff884, /* EMC_XM2CLKPADCTRL */
			0x01f1f108, /* EMC_XM2COMPPADCTRL */
			0x05057404, /* EMC_XM2VTTGENPADCTRL */
			0x54000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000168, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000040, /* EMC_ZCAL_WAIT_CNT */
			0x000c000c, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x8000040b, /* EMC_DYN_SELF_REF_CONTROL */
			0x00010001, /* MC_EMEM_ARB_CFG */
			0xc0000010, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000001, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06020102, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0402, /* MC_EMEM_ARB_DA_COVERS */
			0x74630303, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0xe8000000, /* EMC_FBIO_SPARE */
			0xff00ff00, /* EMC_CFG_RSV */
		},
		0x00000040, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000001, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		102000,     /* SDRAM frequency */
		{
			0x00000004, /* EMC_RC */
			0x0000001a, /* EMC_RFC */
			0x00000003, /* EMC_RAS */
			0x00000001, /* EMC_RP */
			0x00000002, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000001, /* EMC_RD_RCD */
			0x00000001, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_QUSE */
			0x00000004, /* EMC_QRST */
			0x00000009, /* EMC_QSAFE */
			0x0000000b, /* EMC_RDV */
			0x00000303, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000000c0, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000007, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x0000001c, /* EMC_TXSR */
			0x0000001c, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000004, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x0000031c, /* EMC_TREFBW */
			0x00000006, /* EMC_QUSE_EXTRA */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00004288, /* EMC_FBIO_CFG5 */
			0x007800a4, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x000fc000, /* EMC_DLL_XFORM_DQS0 */
			0x000fc000, /* EMC_DLL_XFORM_DQS1 */
			0x000fc000, /* EMC_DLL_XFORM_DQS2 */
			0x000fc000, /* EMC_DLL_XFORM_DQS3 */
			0x000fc000, /* EMC_DLL_XFORM_DQS4 */
			0x000fc000, /* EMC_DLL_XFORM_DQS5 */
			0x000fc000, /* EMC_DLL_XFORM_DQS6 */
			0x000fc000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x000fc000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x000002a0, /* EMC_XM2CMDPADCTRL */
			0x0800211c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77fff884, /* EMC_XM2CLKPADCTRL */
			0x01f1f108, /* EMC_XM2COMPPADCTRL */
			0x05057404, /* EMC_XM2VTTGENPADCTRL */
			0x54000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000168, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000040, /* EMC_ZCAL_WAIT_CNT */
			0x000c000c, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80000713, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000001, /* MC_EMEM_ARB_CFG */
			0xc0000018, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000003, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000001, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06020102, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0403, /* MC_EMEM_ARB_DA_COVERS */
			0x73c30504, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0xe8000000, /* EMC_FBIO_SPARE */
			0xff00ff00, /* EMC_CFG_RSV */
		},
		0x00000040, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000001, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		204000,     /* SDRAM frequency */
		{
			0x00000009, /* EMC_RC */
			0x00000035, /* EMC_RFC */
			0x00000007, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000002, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_QUSE */
			0x00000004, /* EMC_QRST */
			0x00000009, /* EMC_QSAFE */
			0x0000000b, /* EMC_RDV */
			0x00000607, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000181, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000007, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000038, /* EMC_TXSR */
			0x00000038, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000007, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000638, /* EMC_TREFBW */
			0x00000006, /* EMC_QUSE_EXTRA */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00004288, /* EMC_FBIO_CFG5 */
			0x004400a4, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00080000, /* EMC_DLL_XFORM_DQS0 */
			0x00080000, /* EMC_DLL_XFORM_DQS1 */
			0x00080000, /* EMC_DLL_XFORM_DQS2 */
			0x00080000, /* EMC_DLL_XFORM_DQS3 */
			0x00080000, /* EMC_DLL_XFORM_DQS4 */
			0x00080000, /* EMC_DLL_XFORM_DQS5 */
			0x00080000, /* EMC_DLL_XFORM_DQS6 */
			0x00080000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00080000, /* EMC_DLL_XFORM_DQ0 */
			0x00080000, /* EMC_DLL_XFORM_DQ1 */
			0x00080000, /* EMC_DLL_XFORM_DQ2 */
			0x00080000, /* EMC_DLL_XFORM_DQ3 */
			0x000002a0, /* EMC_XM2CMDPADCTRL */
			0x0800211c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77fff884, /* EMC_XM2CLKPADCTRL */
			0x01f1f108, /* EMC_XM2COMPPADCTRL */
			0x05057404, /* EMC_XM2VTTGENPADCTRL */
			0x54000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000168, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x000c000c, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80000d22, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000003, /* MC_EMEM_ARB_CFG */
			0xc0000025, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000005, /* MC_EMEM_ARB_TIMING_RC */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06020102, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0405, /* MC_EMEM_ARB_DA_COVERS */
			0x73840a06, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0xe8000000, /* EMC_FBIO_SPARE */
			0xff00ff00, /* EMC_CFG_RSV */
		},
		0x00000040, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000001, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		375000,     /* SDRAM frequency */
		{
			0x00000011, /* EMC_RC */
			0x0000006f, /* EMC_RFC */
			0x0000000c, /* EMC_RAS */
			0x00000004, /* EMC_RP */
			0x00000003, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000002, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000004, /* EMC_RD_RCD */
			0x00000004, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000004, /* EMC_WDV */
			0x00000006, /* EMC_QUSE */
			0x00000004, /* EMC_QRST */
			0x0000000a, /* EMC_QSAFE */
			0x0000000d, /* EMC_RDV */
			0x00000b2d, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000002cb, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000008, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000007, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000075, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x0000000c, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000b6d, /* EMC_TREFBW */
			0x00000000, /* EMC_QUSE_EXTRA */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00007088, /* EMC_FBIO_CFG5 */
			0x00200084, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x0003c000, /* EMC_DLL_XFORM_DQS0 */
			0x0003c000, /* EMC_DLL_XFORM_DQS1 */
			0x0003c000, /* EMC_DLL_XFORM_DQS2 */
			0x0003c000, /* EMC_DLL_XFORM_DQS3 */
			0x0003c000, /* EMC_DLL_XFORM_DQS4 */
			0x0003c000, /* EMC_DLL_XFORM_DQS5 */
			0x0003c000, /* EMC_DLL_XFORM_DQS6 */
			0x0003c000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00040000, /* EMC_DLL_XFORM_DQ0 */
			0x00040000, /* EMC_DLL_XFORM_DQ1 */
			0x00040000, /* EMC_DLL_XFORM_DQ2 */
			0x00040000, /* EMC_DLL_XFORM_DQ3 */
			0x000002a0, /* EMC_XM2CMDPADCTRL */
			0x0800013d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77fff884, /* EMC_XM2CLKPADCTRL */
			0x01f1f508, /* EMC_XM2COMPPADCTRL */
			0x05057404, /* EMC_XM2VTTGENPADCTRL */
			0x54000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x080001e8, /* EMC_XM2QUSEPADCTRL */
			0x08000021, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x0150000c, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x8000174b, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000005, /* MC_EMEM_ARB_CFG */
			0x80000044, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RP */
			0x00000009, /* MC_EMEM_ARB_TIMING_RC */
			0x00000005, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000005, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030202, /* MC_EMEM_ARB_DA_TURNS */
			0x000d0709, /* MC_EMEM_ARB_DA_COVERS */
			0x75c6110a, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x58000000, /* EMC_FBIO_SPARE */
			0xff00ff88, /* EMC_CFG_RSV */
		},
		0x00000040, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000000, /* EMC_CFG.PERIODIC_QRST */
		0x80000521, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200000, /* Mode Register 2 */
		0x00000000, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		750000,     /* SDRAM frequency */
		{
			0x00000023, /* EMC_RC */
			0x000000df, /* EMC_RFC */
			0x00000019, /* EMC_RAS */
			0x00000009, /* EMC_RP */
			0x00000005, /* EMC_R2W */
			0x0000000d, /* EMC_W2R */
			0x00000004, /* EMC_R2P */
			0x00000013, /* EMC_W2P */
			0x00000009, /* EMC_RD_RCD */
			0x00000009, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000007, /* EMC_WDV */
			0x0000000b, /* EMC_QUSE */
			0x00000009, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x00000011, /* EMC_RDV */
			0x0000169a, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000005a6, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000003, /* EMC_PDEX2WR */
			0x00000010, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x0000000e, /* EMC_AR2PDEN */
			0x00000018, /* EMC_RW2PDEN */
			0x000000e9, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000005, /* EMC_TCKE */
			0x00000017, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000007, /* EMC_TCLKSTABLE */
			0x00000008, /* EMC_TCLKSTOP */
			0x000016da, /* EMC_TREFBW */
			0x0000000c, /* EMC_QUSE_EXTRA */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00005088, /* EMC_FBIO_CFG5 */
			0xf0080191, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00000008, /* EMC_DLL_XFORM_DQS0 */
			0x00000008, /* EMC_DLL_XFORM_DQS1 */
			0x00000008, /* EMC_DLL_XFORM_DQS2 */
			0x00000008, /* EMC_DLL_XFORM_DQS3 */
			0x00000008, /* EMC_DLL_XFORM_DQS4 */
			0x00000008, /* EMC_DLL_XFORM_DQS5 */
			0x00000008, /* EMC_DLL_XFORM_DQS6 */
			0x00000008, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x0000000c, /* EMC_DLL_XFORM_DQ0 */
			0x0000000c, /* EMC_DLL_XFORM_DQ1 */
			0x0000000c, /* EMC_DLL_XFORM_DQ2 */
			0x0000000c, /* EMC_DLL_XFORM_DQ3 */
			0x000002a0, /* EMC_XM2CMDPADCTRL */
			0x0600013d, /* EMC_XM2DQSPADCTRL2 */
			0x22220000, /* EMC_XM2DQPADCTRL2 */
			0x77fff884, /* EMC_XM2CLKPADCTRL */
			0x01f1f501, /* EMC_XM2COMPPADCTRL */
			0x07077404, /* EMC_XM2VTTGENPADCTRL */
			0x54000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x080001e8, /* EMC_XM2QUSEPADCTRL */
			0x07000021, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x00df000c, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80002d93, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000b, /* MC_EMEM_ARB_CFG */
			0x80000087, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000004, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000005, /* MC_EMEM_ARB_TIMING_RP */
			0x00000012, /* MC_EMEM_ARB_TIMING_RC */
			0x0000000c, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000b, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000002, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000c, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000008, /* MC_EMEM_ARB_TIMING_W2R */
			0x08040202, /* MC_EMEM_ARB_DA_TURNS */
			0x00160d12, /* MC_EMEM_ARB_DA_COVERS */
			0x73cc2213, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0xf8000000, /* EMC_FBIO_SPARE */
			0xff00ff49, /* EMC_CFG_RSV */
		},
		0x00000040, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x80000d71, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200018, /* Mode Register 2 */
		0x00000000, /* EMC_CFG.DYN_SELF_REF */
	},
};

static const struct tegra_emc_table cardhu_emc_tables_k4b4g0846b_hyk0[] = {
	{
		0x32,       /* Rev 3.2 */
		25500,      /* SDRAM frequency */
		{
			0x00000001, /* EMC_RC */
			0x00000006, /* EMC_RFC */
			0x00000000, /* EMC_RAS */
			0x00000000, /* EMC_RP */
			0x00000002, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000005, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000000, /* EMC_RD_RCD */
			0x00000000, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_QUSE */
			0x00000004, /* EMC_QRST */
			0x00000009, /* EMC_QSAFE */
			0x0000000b, /* EMC_RDV */
			0x000000c0, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000030, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000007, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000007, /* EMC_TXSR */
			0x00000007, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000001, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x000000c7, /* EMC_TREFBW */
			0x00000006, /* EMC_QUSE_EXTRA */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00004288, /* EMC_FBIO_CFG5 */
			0x007800a4, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x000fc000, /* EMC_DLL_XFORM_DQS0 */
			0x000fc000, /* EMC_DLL_XFORM_DQS1 */
			0x000fc000, /* EMC_DLL_XFORM_DQS2 */
			0x000fc000, /* EMC_DLL_XFORM_DQS3 */
			0x000fc000, /* EMC_DLL_XFORM_DQS4 */
			0x000fc000, /* EMC_DLL_XFORM_DQS5 */
			0x000fc000, /* EMC_DLL_XFORM_DQS6 */
			0x000fc000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x000fc000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x000002a0, /* EMC_XM2CMDPADCTRL */
			0x0800211c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77fff884, /* EMC_XM2CLKPADCTRL */
			0x01f1f108, /* EMC_XM2COMPPADCTRL */
			0x05057404, /* EMC_XM2VTTGENPADCTRL */
			0x54000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000168, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000040, /* EMC_ZCAL_WAIT_CNT */
			0x000c000c, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80000287, /* EMC_DYN_SELF_REF_CONTROL */
			0x00020001, /* MC_EMEM_ARB_CFG */
			0xc0000010, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000001, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06020102, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0402, /* MC_EMEM_ARB_DA_COVERS */
			0x75830303, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0xe8000000, /* EMC_FBIO_SPARE */
			0xff00ff00, /* EMC_CFG_RSV */
		},
		0x00000040, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000001, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		51000,      /* SDRAM frequency */
		{
			0x00000002, /* EMC_RC */
			0x0000000d, /* EMC_RFC */
			0x00000001, /* EMC_RAS */
			0x00000000, /* EMC_RP */
			0x00000002, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000005, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000000, /* EMC_RD_RCD */
			0x00000000, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_QUSE */
			0x00000004, /* EMC_QRST */
			0x00000009, /* EMC_QSAFE */
			0x0000000b, /* EMC_RDV */
			0x00000181, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000060, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000007, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x0000000e, /* EMC_TXSR */
			0x0000000e, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000002, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x0000018e, /* EMC_TREFBW */
			0x00000006, /* EMC_QUSE_EXTRA */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00004288, /* EMC_FBIO_CFG5 */
			0x007800a4, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x000fc000, /* EMC_DLL_XFORM_DQS0 */
			0x000fc000, /* EMC_DLL_XFORM_DQS1 */
			0x000fc000, /* EMC_DLL_XFORM_DQS2 */
			0x000fc000, /* EMC_DLL_XFORM_DQS3 */
			0x000fc000, /* EMC_DLL_XFORM_DQS4 */
			0x000fc000, /* EMC_DLL_XFORM_DQS5 */
			0x000fc000, /* EMC_DLL_XFORM_DQS6 */
			0x000fc000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x000fc000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x000002a0, /* EMC_XM2CMDPADCTRL */
			0x0800211c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77fff884, /* EMC_XM2CLKPADCTRL */
			0x01f1f108, /* EMC_XM2COMPPADCTRL */
			0x05057404, /* EMC_XM2VTTGENPADCTRL */
			0x54000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000168, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000040, /* EMC_ZCAL_WAIT_CNT */
			0x000c000c, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x8000040b, /* EMC_DYN_SELF_REF_CONTROL */
			0x00010001, /* MC_EMEM_ARB_CFG */
			0xc0000010, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000001, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06020102, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0402, /* MC_EMEM_ARB_DA_COVERS */
			0x74630303, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0xe8000000, /* EMC_FBIO_SPARE */
			0xff00ff00, /* EMC_CFG_RSV */
		},
		0x00000040, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000001, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		102000,     /* SDRAM frequency */
		{
			0x00000004, /* EMC_RC */
			0x0000001a, /* EMC_RFC */
			0x00000003, /* EMC_RAS */
			0x00000001, /* EMC_RP */
			0x00000002, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000005, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000001, /* EMC_RD_RCD */
			0x00000001, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_QUSE */
			0x00000004, /* EMC_QRST */
			0x00000009, /* EMC_QSAFE */
			0x0000000b, /* EMC_RDV */
			0x00000303, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000000c0, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000007, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x0000001c, /* EMC_TXSR */
			0x0000001c, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000004, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x0000031c, /* EMC_TREFBW */
			0x00000006, /* EMC_QUSE_EXTRA */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00004288, /* EMC_FBIO_CFG5 */
			0x007800a4, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x000fc000, /* EMC_DLL_XFORM_DQS0 */
			0x000fc000, /* EMC_DLL_XFORM_DQS1 */
			0x000fc000, /* EMC_DLL_XFORM_DQS2 */
			0x000fc000, /* EMC_DLL_XFORM_DQS3 */
			0x000fc000, /* EMC_DLL_XFORM_DQS4 */
			0x000fc000, /* EMC_DLL_XFORM_DQS5 */
			0x000fc000, /* EMC_DLL_XFORM_DQS6 */
			0x000fc000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x000fc000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x000002a0, /* EMC_XM2CMDPADCTRL */
			0x0800211c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77fff884, /* EMC_XM2CLKPADCTRL */
			0x01f1f108, /* EMC_XM2COMPPADCTRL */
			0x05057404, /* EMC_XM2VTTGENPADCTRL */
			0x54000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000168, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000040, /* EMC_ZCAL_WAIT_CNT */
			0x000c000c, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80000713, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000001, /* MC_EMEM_ARB_CFG */
			0xc0000018, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000003, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000001, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06020102, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0403, /* MC_EMEM_ARB_DA_COVERS */
			0x73c30504, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0xe8000000, /* EMC_FBIO_SPARE */
			0xff00ff00, /* EMC_CFG_RSV */
		},
		0x00000040, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000001, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		204000,     /* SDRAM frequency */
		{
			0x00000009, /* EMC_RC */
			0x00000035, /* EMC_RFC */
			0x00000007, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000002, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000005, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_QUSE */
			0x00000004, /* EMC_QRST */
			0x00000009, /* EMC_QSAFE */
			0x0000000b, /* EMC_RDV */
			0x00000607, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000181, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000007, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000038, /* EMC_TXSR */
			0x00000038, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000007, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000638, /* EMC_TREFBW */
			0x00000006, /* EMC_QUSE_EXTRA */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00004288, /* EMC_FBIO_CFG5 */
			0x004400a4, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00080000, /* EMC_DLL_XFORM_DQS0 */
			0x00080000, /* EMC_DLL_XFORM_DQS1 */
			0x00080000, /* EMC_DLL_XFORM_DQS2 */
			0x00080000, /* EMC_DLL_XFORM_DQS3 */
			0x00080000, /* EMC_DLL_XFORM_DQS4 */
			0x00080000, /* EMC_DLL_XFORM_DQS5 */
			0x00080000, /* EMC_DLL_XFORM_DQS6 */
			0x00080000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00080000, /* EMC_DLL_XFORM_DQ0 */
			0x00080000, /* EMC_DLL_XFORM_DQ1 */
			0x00080000, /* EMC_DLL_XFORM_DQ2 */
			0x00080000, /* EMC_DLL_XFORM_DQ3 */
			0x000002a0, /* EMC_XM2CMDPADCTRL */
			0x0800211c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77fff884, /* EMC_XM2CLKPADCTRL */
			0x01f1f108, /* EMC_XM2COMPPADCTRL */
			0x05057404, /* EMC_XM2VTTGENPADCTRL */
			0x54000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000168, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x000c000c, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80000d22, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000003, /* MC_EMEM_ARB_CFG */
			0xc0000025, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000005, /* MC_EMEM_ARB_TIMING_RC */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06020102, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0405, /* MC_EMEM_ARB_DA_COVERS */
			0x73840a06, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0xe8000000, /* EMC_FBIO_SPARE */
			0xff00ff00, /* EMC_CFG_RSV */
		},
		0x00000040, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000001, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		375000,     /* SDRAM frequency */
		{
			0x00000011, /* EMC_RC */
			0x00000060, /* EMC_RFC */
			0x0000000c, /* EMC_RAS */
			0x00000004, /* EMC_RP */
			0x00000003, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000002, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000004, /* EMC_RD_RCD */
			0x00000004, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000004, /* EMC_WDV */
			0x00000006, /* EMC_QUSE */
			0x00000004, /* EMC_QRST */
			0x0000000a, /* EMC_QSAFE */
			0x0000000d, /* EMC_RDV */
			0x00000b2d, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000002cb, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000008, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000007, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000066, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x0000000c, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000b6d, /* EMC_TREFBW */
			0x00000000, /* EMC_QUSE_EXTRA */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00007088, /* EMC_FBIO_CFG5 */
			0x00200084, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00014000, /* EMC_DLL_XFORM_DQS0 */
			0x00014000, /* EMC_DLL_XFORM_DQS1 */
			0x00014000, /* EMC_DLL_XFORM_DQS2 */
			0x00014000, /* EMC_DLL_XFORM_DQS3 */
			0x00014000, /* EMC_DLL_XFORM_DQS4 */
			0x00014000, /* EMC_DLL_XFORM_DQS5 */
			0x00014000, /* EMC_DLL_XFORM_DQS6 */
			0x00014000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00020000, /* EMC_DLL_XFORM_DQ0 */
			0x00020000, /* EMC_DLL_XFORM_DQ1 */
			0x00020000, /* EMC_DLL_XFORM_DQ2 */
			0x00020000, /* EMC_DLL_XFORM_DQ3 */
			0x000002a0, /* EMC_XM2CMDPADCTRL */
			0x0800013d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77fff884, /* EMC_XM2CLKPADCTRL */
			0x01f1f508, /* EMC_XM2COMPPADCTRL */
			0x05057404, /* EMC_XM2VTTGENPADCTRL */
			0x54000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x080001e8, /* EMC_XM2QUSEPADCTRL */
			0x08000021, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x015f000c, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x8000174b, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000005, /* MC_EMEM_ARB_CFG */
			0x80000044, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RP */
			0x00000009, /* MC_EMEM_ARB_TIMING_RC */
			0x00000005, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000005, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030202, /* MC_EMEM_ARB_DA_TURNS */
			0x000d0709, /* MC_EMEM_ARB_DA_COVERS */
			0x7086110a, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x58000000, /* EMC_FBIO_SPARE */
			0xff00ff88, /* EMC_CFG_RSV */
		},
		0x00000040, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000000, /* EMC_CFG.PERIODIC_QRST */
		0x80000521, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200000, /* Mode Register 2 */
		0x00000000, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		400000,     /* SDRAM frequency */
		{
			0x00000012, /* EMC_RC */
			0x00000066, /* EMC_RFC */
			0x0000000c, /* EMC_RAS */
			0x00000004, /* EMC_RP */
			0x00000003, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000002, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000004, /* EMC_RD_RCD */
			0x00000004, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000004, /* EMC_WDV */
			0x00000006, /* EMC_QUSE */
			0x00000004, /* EMC_QRST */
			0x0000000a, /* EMC_QSAFE */
			0x0000000c, /* EMC_RDV */
			0x00000bf0, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000002fc, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000008, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000008, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x0000006c, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x0000000c, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000c30, /* EMC_TREFBW */
			0x00000000, /* EMC_QUSE_EXTRA */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00007088, /* EMC_FBIO_CFG5 */
			0x001d0084, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00034000, /* EMC_DLL_XFORM_DQS0 */
			0x00034000, /* EMC_DLL_XFORM_DQS1 */
			0x00034000, /* EMC_DLL_XFORM_DQS2 */
			0x00034000, /* EMC_DLL_XFORM_DQS3 */
			0x00034000, /* EMC_DLL_XFORM_DQS4 */
			0x00034000, /* EMC_DLL_XFORM_DQS5 */
			0x00034000, /* EMC_DLL_XFORM_DQS6 */
			0x00034000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00040000, /* EMC_DLL_XFORM_DQ0 */
			0x00040000, /* EMC_DLL_XFORM_DQ1 */
			0x00040000, /* EMC_DLL_XFORM_DQ2 */
			0x00040000, /* EMC_DLL_XFORM_DQ3 */
			0x000002a0, /* EMC_XM2CMDPADCTRL */
			0x0800013d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77fff884, /* EMC_XM2CLKPADCTRL */
			0x01f1f508, /* EMC_XM2COMPPADCTRL */
			0x05057404, /* EMC_XM2VTTGENPADCTRL */
			0x54000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x080001e8, /* EMC_XM2QUSEPADCTRL */
			0x08000021, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x0158000c, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x800018c8, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000006, /* MC_EMEM_ARB_CFG */
			0x80000048, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RP */
			0x00000009, /* MC_EMEM_ARB_TIMING_RC */
			0x00000005, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000005, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030202, /* MC_EMEM_ARB_DA_TURNS */
			0x000d0709, /* MC_EMEM_ARB_DA_COVERS */
			0x7566120a, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0xe8000000, /* EMC_FBIO_SPARE */
			0xff00ff89, /* EMC_CFG_RSV */
		},
		0x00000040, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000000, /* EMC_CFG.PERIODIC_QRST */
		0x80000521, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200000, /* Mode Register 2 */
		0x00000000, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		750000,     /* SDRAM frequency */
		{
			0x00000023, /* EMC_RC */
			0x000000c1, /* EMC_RFC */
			0x00000019, /* EMC_RAS */
			0x00000009, /* EMC_RP */
			0x00000005, /* EMC_R2W */
			0x0000000d, /* EMC_W2R */
			0x00000004, /* EMC_R2P */
			0x00000013, /* EMC_W2P */
			0x00000009, /* EMC_RD_RCD */
			0x00000009, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000007, /* EMC_WDV */
			0x0000000b, /* EMC_QUSE */
			0x00000009, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x00000011, /* EMC_RDV */
			0x0000169a, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000005a6, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000003, /* EMC_PDEX2WR */
			0x00000010, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x0000000e, /* EMC_AR2PDEN */
			0x00000018, /* EMC_RW2PDEN */
			0x000000cb, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000005, /* EMC_TCKE */
			0x00000017, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000007, /* EMC_TCLKSTABLE */
			0x00000008, /* EMC_TCLKSTOP */
			0x000016da, /* EMC_TREFBW */
			0x0000000c, /* EMC_QUSE_EXTRA */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00005088, /* EMC_FBIO_CFG5 */
			0xf0080191, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00000008, /* EMC_DLL_XFORM_DQS0 */
			0x00000008, /* EMC_DLL_XFORM_DQS1 */
			0x00000008, /* EMC_DLL_XFORM_DQS2 */
			0x00000008, /* EMC_DLL_XFORM_DQS3 */
			0x00000008, /* EMC_DLL_XFORM_DQS4 */
			0x00000008, /* EMC_DLL_XFORM_DQS5 */
			0x00000008, /* EMC_DLL_XFORM_DQS6 */
			0x00000008, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x0000000c, /* EMC_DLL_XFORM_DQ0 */
			0x0000000c, /* EMC_DLL_XFORM_DQ1 */
			0x0000000c, /* EMC_DLL_XFORM_DQ2 */
			0x0000000c, /* EMC_DLL_XFORM_DQ3 */
			0x000002a0, /* EMC_XM2CMDPADCTRL */
			0x0600013d, /* EMC_XM2DQSPADCTRL2 */
			0x22220000, /* EMC_XM2DQPADCTRL2 */
			0x77fff884, /* EMC_XM2CLKPADCTRL */
			0x01f1f501, /* EMC_XM2COMPPADCTRL */
			0x07077404, /* EMC_XM2VTTGENPADCTRL */
			0x54000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x080001e8, /* EMC_XM2QUSEPADCTRL */
			0x08000021, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x00fd000c, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80002d93, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000b, /* MC_EMEM_ARB_CFG */
			0x80000087, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000004, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000005, /* MC_EMEM_ARB_TIMING_RP */
			0x00000012, /* MC_EMEM_ARB_TIMING_RC */
			0x0000000c, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000b, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000002, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000c, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000008, /* MC_EMEM_ARB_TIMING_W2R */
			0x08040202, /* MC_EMEM_ARB_DA_TURNS */
			0x00160d12, /* MC_EMEM_ARB_DA_COVERS */
			0x710c2213, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0xf8000000, /* EMC_FBIO_SPARE */
			0xff00ff49, /* EMC_CFG_RSV */
		},
		0x00000040, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x80000d71, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200018, /* Mode Register 2 */
		0x00000000, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		800000,     /* SDRAM frequency */
		{
			0x00000025, /* EMC_RC */
			0x000000ce, /* EMC_RFC */
			0x0000001a, /* EMC_RAS */
			0x00000009, /* EMC_RP */
			0x00000005, /* EMC_R2W */
			0x0000000d, /* EMC_W2R */
			0x00000004, /* EMC_R2P */
			0x00000013, /* EMC_W2P */
			0x00000009, /* EMC_RD_RCD */
			0x00000009, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000007, /* EMC_WDV */
			0x0000000b, /* EMC_QUSE */
			0x00000009, /* EMC_QRST */
			0x0000000b, /* EMC_QSAFE */
			0x00000011, /* EMC_RDV */
			0x00001820, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000608, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000003, /* EMC_PDEX2WR */
			0x00000012, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x0000000f, /* EMC_AR2PDEN */
			0x00000018, /* EMC_RW2PDEN */
			0x000000d8, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000005, /* EMC_TCKE */
			0x00000018, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000007, /* EMC_TCLKSTABLE */
			0x00000008, /* EMC_TCLKSTOP */
			0x00001860, /* EMC_TREFBW */
			0x0000000c, /* EMC_QUSE_EXTRA */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00005088, /* EMC_FBIO_CFG5 */
			0xf0070191, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x0000800a, /* EMC_DLL_XFORM_DQS0 */
			0x0000800a, /* EMC_DLL_XFORM_DQS1 */
			0x0000800a, /* EMC_DLL_XFORM_DQS2 */
			0x0000800a, /* EMC_DLL_XFORM_DQS3 */
			0x0000800a, /* EMC_DLL_XFORM_DQS4 */
			0x0000800a, /* EMC_DLL_XFORM_DQS5 */
			0x0000800a, /* EMC_DLL_XFORM_DQS6 */
			0x0000800a, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x0000000a, /* EMC_DLL_XFORM_DQ0 */
			0x0000000a, /* EMC_DLL_XFORM_DQ1 */
			0x0000000a, /* EMC_DLL_XFORM_DQ2 */
			0x0000000a, /* EMC_DLL_XFORM_DQ3 */
			0x000002a0, /* EMC_XM2CMDPADCTRL */
			0x0600013d, /* EMC_XM2DQSPADCTRL2 */
			0x22220000, /* EMC_XM2DQPADCTRL2 */
			0x77fff884, /* EMC_XM2CLKPADCTRL */
			0x01f1f501, /* EMC_XM2COMPPADCTRL */
			0x07077404, /* EMC_XM2VTTGENPADCTRL */
			0x54000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x080001e8, /* EMC_XM2QUSEPADCTRL */
			0x09000021, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x00f0000c, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x8000308c, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000c, /* MC_EMEM_ARB_CFG */
			0x80000090, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000004, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000005, /* MC_EMEM_ARB_TIMING_RP */
			0x00000013, /* MC_EMEM_ARB_TIMING_RC */
			0x0000000c, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000b, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000002, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000c, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000008, /* MC_EMEM_ARB_TIMING_W2R */
			0x08040202, /* MC_EMEM_ARB_DA_TURNS */
			0x00160d13, /* MC_EMEM_ARB_DA_COVERS */
			0x734c2414, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0xf8000000, /* EMC_FBIO_SPARE */
			0xff00ff49, /* EMC_CFG_RSV */
		},
		0x00000040, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x80000d71, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200018, /* Mode Register 2 */
		0x00000000, /* EMC_CFG.DYN_SELF_REF */
	},
};

static const struct tegra_emc_table cardhu_emc_tables_k4p8g304eb[] = {
	{
		0x32,       /* Rev 3.2 */
		25500,      /* SDRAM frequency */
		{
			0x00000001, /* EMC_RC */
			0x00000003, /* EMC_RFC */
			0x00000002, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x00000004, /* EMC_W2R */
			0x00000001, /* EMC_R2P */
			0x00000005, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000001, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000001, /* EMC_WDV */
			0x00000003, /* EMC_QUSE */
			0x00000001, /* EMC_QRST */
			0x00000009, /* EMC_QSAFE */
			0x0000000a, /* EMC_RDV */
			0x0000005e, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000017, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000001, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x00000007, /* EMC_RW2PDEN */
			0x00000004, /* EMC_TXSR */
			0x00000004, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000008, /* EMC_TFAW */
			0x00000004, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000002, /* EMC_TCLKSTOP */
			0x00000068, /* EMC_TREFBW */
			0x00000004, /* EMC_QUSE_EXTRA */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00004282, /* EMC_FBIO_CFG5 */
			0x007800a4, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00098000, /* EMC_DLL_XFORM_DQS0 */
			0x00098000, /* EMC_DLL_XFORM_DQS1 */
			0x00098000, /* EMC_DLL_XFORM_DQS2 */
			0x00098000, /* EMC_DLL_XFORM_DQS3 */
			0x00000010, /* EMC_DLL_XFORM_DQS4 */
			0x00000010, /* EMC_DLL_XFORM_DQS5 */
			0x00000010, /* EMC_DLL_XFORM_DQS6 */
			0x00000010, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000008, /* EMC_DLL_XFORM_QUSE4 */
			0x00000008, /* EMC_DLL_XFORM_QUSE5 */
			0x00000008, /* EMC_DLL_XFORM_QUSE6 */
			0x00000008, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00080000, /* EMC_DLL_XFORM_DQ0 */
			0x00080000, /* EMC_DLL_XFORM_DQ1 */
			0x00080000, /* EMC_DLL_XFORM_DQ2 */
			0x00080000, /* EMC_DLL_XFORM_DQ3 */
			0x00100220, /* EMC_XM2CMDPADCTRL */
			0x0800201c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x01f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x00000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000068, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x0000000a, /* EMC_ZCAL_WAIT_CNT */
			0x00090009, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x800001c2, /* EMC_DYN_SELF_REF_CONTROL */
			0x00020001, /* MC_EMEM_ARB_CFG */
			0xc0000008, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000004, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000001, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000000, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2R */
			0x02020001, /* MC_EMEM_ARB_DA_TURNS */
			0x00060402, /* MC_EMEM_ARB_DA_COVERS */
			0x74030303, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x50000000, /* EMC_FBIO_SPARE */
			0xff00ff00, /* EMC_CFG_RSV */
		},
		0x00000009, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x00000000, /* Mode Register 0 */
		0x00010022, /* Mode Register 1 */
		0x00020001, /* Mode Register 2 */
		0x00000001, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		51000,      /* SDRAM frequency */
		{
			0x00000003, /* EMC_RC */
			0x00000006, /* EMC_RFC */
			0x00000002, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x00000004, /* EMC_W2R */
			0x00000001, /* EMC_R2P */
			0x00000005, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000001, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000001, /* EMC_WDV */
			0x00000003, /* EMC_QUSE */
			0x00000001, /* EMC_QRST */
			0x00000009, /* EMC_QSAFE */
			0x0000000a, /* EMC_RDV */
			0x000000c0, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000030, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000001, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x00000007, /* EMC_RW2PDEN */
			0x00000008, /* EMC_TXSR */
			0x00000008, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000008, /* EMC_TFAW */
			0x00000004, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000002, /* EMC_TCLKSTOP */
			0x000000d5, /* EMC_TREFBW */
			0x00000004, /* EMC_QUSE_EXTRA */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00004282, /* EMC_FBIO_CFG5 */
			0x007800a4, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x000a0000, /* EMC_DLL_XFORM_DQS0 */
			0x000a0000, /* EMC_DLL_XFORM_DQS1 */
			0x000a0000, /* EMC_DLL_XFORM_DQS2 */
			0x000a0000, /* EMC_DLL_XFORM_DQS3 */
			0x00000010, /* EMC_DLL_XFORM_DQS4 */
			0x00000010, /* EMC_DLL_XFORM_DQS5 */
			0x00000010, /* EMC_DLL_XFORM_DQS6 */
			0x00000010, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000018, /* EMC_DLL_XFORM_QUSE4 */
			0x00000018, /* EMC_DLL_XFORM_QUSE5 */
			0x00000018, /* EMC_DLL_XFORM_QUSE6 */
			0x00000018, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00080000, /* EMC_DLL_XFORM_DQ0 */
			0x00080000, /* EMC_DLL_XFORM_DQ1 */
			0x00080000, /* EMC_DLL_XFORM_DQ2 */
			0x00080000, /* EMC_DLL_XFORM_DQ3 */
			0x00100220, /* EMC_XM2CMDPADCTRL */
			0x0800201c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x01f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x00000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000068, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x00000013, /* EMC_ZCAL_WAIT_CNT */
			0x00090009, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80000287, /* EMC_DYN_SELF_REF_CONTROL */
			0x00010001, /* MC_EMEM_ARB_CFG */
			0xc000000a, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000004, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000001, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000000, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2R */
			0x02020001, /* MC_EMEM_ARB_DA_TURNS */
			0x00060402, /* MC_EMEM_ARB_DA_COVERS */
			0x72c30303, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x50000000, /* EMC_FBIO_SPARE */
			0xff00ff00, /* EMC_CFG_RSV */
		},
		0x00000009, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x00000000, /* Mode Register 0 */
		0x00010022, /* Mode Register 1 */
		0x00020001, /* Mode Register 2 */
		0x00000001, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		102000,     /* SDRAM frequency */
		{
			0x00000006, /* EMC_RC */
			0x0000000d, /* EMC_RFC */
			0x00000004, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x00000004, /* EMC_W2R */
			0x00000001, /* EMC_R2P */
			0x00000005, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000001, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000001, /* EMC_WDV */
			0x00000003, /* EMC_QUSE */
			0x00000001, /* EMC_QRST */
			0x00000009, /* EMC_QSAFE */
			0x00000009, /* EMC_RDV */
			0x00000181, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000060, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000001, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x00000007, /* EMC_RW2PDEN */
			0x0000000f, /* EMC_TXSR */
			0x0000000f, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000008, /* EMC_TFAW */
			0x00000004, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000002, /* EMC_TCLKSTOP */
			0x000001a9, /* EMC_TREFBW */
			0x00000004, /* EMC_QUSE_EXTRA */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00004282, /* EMC_FBIO_CFG5 */
			0x007800a4, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x000a0000, /* EMC_DLL_XFORM_DQS0 */
			0x000a0000, /* EMC_DLL_XFORM_DQS1 */
			0x000a0000, /* EMC_DLL_XFORM_DQS2 */
			0x000a0000, /* EMC_DLL_XFORM_DQS3 */
			0x00000010, /* EMC_DLL_XFORM_DQS4 */
			0x00000010, /* EMC_DLL_XFORM_DQS5 */
			0x00000010, /* EMC_DLL_XFORM_DQS6 */
			0x00000010, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000008, /* EMC_DLL_XFORM_QUSE4 */
			0x00000008, /* EMC_DLL_XFORM_QUSE5 */
			0x00000008, /* EMC_DLL_XFORM_QUSE6 */
			0x00000008, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00080000, /* EMC_DLL_XFORM_DQ0 */
			0x00080000, /* EMC_DLL_XFORM_DQ1 */
			0x00080000, /* EMC_DLL_XFORM_DQ2 */
			0x00080000, /* EMC_DLL_XFORM_DQ3 */
			0x00120220, /* EMC_XM2CMDPADCTRL */
			0x0800201c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x01f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x00000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000068, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x00000025, /* EMC_ZCAL_WAIT_CNT */
			0x00090009, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x8000040b, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000001, /* MC_EMEM_ARB_CFG */
			0xc0000013, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000003, /* MC_EMEM_ARB_TIMING_RC */
			0x00000001, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000004, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000001, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000000, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2R */
			0x02020001, /* MC_EMEM_ARB_DA_TURNS */
			0x00060403, /* MC_EMEM_ARB_DA_COVERS */
			0x72430504, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x10000000, /* EMC_FBIO_SPARE */
			0xff00ff00, /* EMC_CFG_RSV */
		},
		0x0000000a, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x00000000, /* Mode Register 0 */
		0x00010022, /* Mode Register 1 */
		0x00020001, /* Mode Register 2 */
		0x00000001, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		204000,     /* SDRAM frequency */
		{
			0x0000000c, /* EMC_RC */
			0x0000001a, /* EMC_RFC */
			0x00000008, /* EMC_RAS */
			0x00000003, /* EMC_RP */
			0x00000005, /* EMC_R2W */
			0x00000004, /* EMC_W2R */
			0x00000001, /* EMC_R2P */
			0x00000006, /* EMC_W2P */
			0x00000003, /* EMC_RD_RCD */
			0x00000003, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000001, /* EMC_WDV */
			0x00000003, /* EMC_QUSE */
			0x00000001, /* EMC_QRST */
			0x0000000a, /* EMC_QSAFE */
			0x0000000a, /* EMC_RDV */
			0x00000303, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000000c0, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000001, /* EMC_PDEX2RD */
			0x00000003, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x00000007, /* EMC_RW2PDEN */
			0x0000001d, /* EMC_TXSR */
			0x0000001d, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x0000000b, /* EMC_TFAW */
			0x00000005, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000002, /* EMC_TCLKSTOP */
			0x00000351, /* EMC_TREFBW */
			0x00000004, /* EMC_QUSE_EXTRA */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00004282, /* EMC_FBIO_CFG5 */
			0x004400a4, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00074000, /* EMC_DLL_XFORM_DQS0 */
			0x00074000, /* EMC_DLL_XFORM_DQS1 */
			0x00074000, /* EMC_DLL_XFORM_DQS2 */
			0x00074000, /* EMC_DLL_XFORM_DQS3 */
			0x00000010, /* EMC_DLL_XFORM_DQS4 */
			0x00000010, /* EMC_DLL_XFORM_DQS5 */
			0x00000010, /* EMC_DLL_XFORM_DQS6 */
			0x00000010, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000018, /* EMC_DLL_XFORM_QUSE4 */
			0x00000018, /* EMC_DLL_XFORM_QUSE5 */
			0x00000018, /* EMC_DLL_XFORM_QUSE6 */
			0x00000018, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00078000, /* EMC_DLL_XFORM_DQ0 */
			0x00078000, /* EMC_DLL_XFORM_DQ1 */
			0x00078000, /* EMC_DLL_XFORM_DQ2 */
			0x00078000, /* EMC_DLL_XFORM_DQ3 */
			0x00100220, /* EMC_XM2CMDPADCTRL */
			0x0800201c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x01f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x00000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000068, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x0000004a, /* EMC_ZCAL_WAIT_CNT */
			0x00090009, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80000713, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000003, /* MC_EMEM_ARB_CFG */
			0xc0000025, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000006, /* MC_EMEM_ARB_TIMING_RC */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000005, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000004, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000001, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000000, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2R */
			0x02030001, /* MC_EMEM_ARB_DA_TURNS */
			0x00070506, /* MC_EMEM_ARB_DA_COVERS */
			0x71e40a07, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x50000000, /* EMC_FBIO_SPARE */
			0xff00ff00, /* EMC_CFG_RSV */
		},
		0x00000013, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x00000000, /* Mode Register 0 */
		0x00010042, /* Mode Register 1 */
		0x00020001, /* Mode Register 2 */
		0x00000001, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		533000,     /* SDRAM frequency */
		{
			0x0000001f, /* EMC_RC */
			0x00000045, /* EMC_RFC */
			0x00000016, /* EMC_RAS */
			0x00000009, /* EMC_RP */
			0x00000008, /* EMC_R2W */
			0x00000009, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000d, /* EMC_W2P */
			0x00000009, /* EMC_RD_RCD */
			0x00000009, /* EMC_WR_RCD */
			0x00000005, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000004, /* EMC_WDV */
			0x00000009, /* EMC_QUSE */
			0x00000006, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x00000010, /* EMC_RDV */
			0x000007df, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000001f7, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000003, /* EMC_PDEX2WR */
			0x00000003, /* EMC_PDEX2RD */
			0x00000009, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x0000004b, /* EMC_TXSR */
			0x0000004b, /* EMC_TXSRDLL */
			0x00000008, /* EMC_TCKE */
			0x0000001b, /* EMC_TFAW */
			0x0000000c, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000002, /* EMC_TCLKSTOP */
			0x000008aa, /* EMC_TREFBW */
			0x00000000, /* EMC_QUSE_EXTRA */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00006282, /* EMC_FBIO_CFG5 */
			0xf0120091, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x0000000a, /* EMC_DLL_XFORM_DQS0 */
			0x0000000a, /* EMC_DLL_XFORM_DQS1 */
			0x0000000a, /* EMC_DLL_XFORM_DQS2 */
			0x0000000a, /* EMC_DLL_XFORM_DQS3 */
			0x00000010, /* EMC_DLL_XFORM_DQS4 */
			0x00000010, /* EMC_DLL_XFORM_DQS5 */
			0x00000010, /* EMC_DLL_XFORM_DQS6 */
			0x00000010, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000008, /* EMC_DLL_XFORM_QUSE4 */
			0x00000008, /* EMC_DLL_XFORM_QUSE5 */
			0x00000008, /* EMC_DLL_XFORM_QUSE6 */
			0x00000008, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x0000000c, /* EMC_DLL_XFORM_DQ0 */
			0x0000000c, /* EMC_DLL_XFORM_DQ1 */
			0x0000000c, /* EMC_DLL_XFORM_DQ2 */
			0x0000000c, /* EMC_DLL_XFORM_DQ3 */
			0x000b0220, /* EMC_XM2CMDPADCTRL */
			0x0800003d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x01f1f408, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x00000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000068, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x000000c0, /* EMC_ZCAL_WAIT_CNT */
			0x000e000e, /* EMC_MRS_WAIT_CNT */
			0xa0f10202, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x800010d9, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000008, /* MC_EMEM_ARB_CFG */
			0x80000060, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000003, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000004, /* MC_EMEM_ARB_TIMING_RP */
			0x00000010, /* MC_EMEM_ARB_TIMING_RC */
			0x0000000a, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000d, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000002, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000000, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_W2R */
			0x05040002, /* MC_EMEM_ARB_DA_TURNS */
			0x00110b10, /* MC_EMEM_ARB_DA_COVERS */
			0x71c81811, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0xe0000000, /* EMC_FBIO_SPARE */
			0xff00ff88, /* EMC_CFG_RSV */
		},
		0x00000030, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x00000000, /* Mode Register 0 */
		0x000100c2, /* Mode Register 1 */
		0x00020006, /* Mode Register 2 */
		0x00000000, /* EMC_CFG.DYN_SELF_REF */
	},
};

static const struct tegra_emc_table cardhu_emc_tables_edb8132b2ma[] = {
	{
		0x32,       /* Rev 3.2 */
		25500,      /* SDRAM frequency */
		{
			0x00000001, /* EMC_RC */
			0x00000003, /* EMC_RFC */
			0x00000002, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x00000004, /* EMC_W2R */
			0x00000001, /* EMC_R2P */
			0x00000005, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000001, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000001, /* EMC_WDV */
			0x00000003, /* EMC_QUSE */
			0x00000001, /* EMC_QRST */
			0x00000009, /* EMC_QSAFE */
			0x0000000a, /* EMC_RDV */
			0x00000060, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000018, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000001, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x00000007, /* EMC_RW2PDEN */
			0x00000004, /* EMC_TXSR */
			0x00000004, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000008, /* EMC_TFAW */
			0x00000004, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000002, /* EMC_TCLKSTOP */
			0x0000006b, /* EMC_TREFBW */
			0x00000004, /* EMC_QUSE_EXTRA */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00004282, /* EMC_FBIO_CFG5 */
			0x007800a4, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x000a0000, /* EMC_DLL_XFORM_DQS0 */
			0x000a0000, /* EMC_DLL_XFORM_DQS1 */
			0x000a0000, /* EMC_DLL_XFORM_DQS2 */
			0x000a0000, /* EMC_DLL_XFORM_DQS3 */
			0x00000010, /* EMC_DLL_XFORM_DQS4 */
			0x00000010, /* EMC_DLL_XFORM_DQS5 */
			0x00000010, /* EMC_DLL_XFORM_DQS6 */
			0x00000010, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000008, /* EMC_DLL_XFORM_QUSE4 */
			0x00000008, /* EMC_DLL_XFORM_QUSE5 */
			0x00000008, /* EMC_DLL_XFORM_QUSE6 */
			0x00000008, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00080000, /* EMC_DLL_XFORM_DQ0 */
			0x00080000, /* EMC_DLL_XFORM_DQ1 */
			0x00080000, /* EMC_DLL_XFORM_DQ2 */
			0x00080000, /* EMC_DLL_XFORM_DQ3 */
			0x00120220, /* EMC_XM2CMDPADCTRL */
			0x0800201c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x01f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x00000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000068, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x0000000a, /* EMC_ZCAL_WAIT_CNT */
			0x00090009, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x800001c5, /* EMC_DYN_SELF_REF_CONTROL */
			0x00020001, /* MC_EMEM_ARB_CFG */
			0xc0000008, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000004, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000001, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000000, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2R */
			0x02020001, /* MC_EMEM_ARB_DA_TURNS */
			0x00060402, /* MC_EMEM_ARB_DA_COVERS */
			0x73e30303, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x50000000, /* EMC_FBIO_SPARE */
			0xff00ff00, /* EMC_CFG_RSV */
		},
		0x00000009, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x00000000, /* Mode Register 0 */
		0x00010022, /* Mode Register 1 */
		0x00020001, /* Mode Register 2 */
		0x00000001, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		51000,      /* SDRAM frequency */
		{
			0x00000003, /* EMC_RC */
			0x00000006, /* EMC_RFC */
			0x00000002, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x00000004, /* EMC_W2R */
			0x00000001, /* EMC_R2P */
			0x00000005, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000001, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000001, /* EMC_WDV */
			0x00000003, /* EMC_QUSE */
			0x00000001, /* EMC_QRST */
			0x00000009, /* EMC_QSAFE */
			0x0000000a, /* EMC_RDV */
			0x000000c0, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000030, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000001, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x00000007, /* EMC_RW2PDEN */
			0x00000008, /* EMC_TXSR */
			0x00000008, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000008, /* EMC_TFAW */
			0x00000004, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000002, /* EMC_TCLKSTOP */
			0x000000d5, /* EMC_TREFBW */
			0x00000004, /* EMC_QUSE_EXTRA */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00004282, /* EMC_FBIO_CFG5 */
			0x007800a4, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x000a0000, /* EMC_DLL_XFORM_DQS0 */
			0x000a0000, /* EMC_DLL_XFORM_DQS1 */
			0x000a0000, /* EMC_DLL_XFORM_DQS2 */
			0x000a0000, /* EMC_DLL_XFORM_DQS3 */
			0x00000010, /* EMC_DLL_XFORM_DQS4 */
			0x00000010, /* EMC_DLL_XFORM_DQS5 */
			0x00000010, /* EMC_DLL_XFORM_DQS6 */
			0x00000010, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000018, /* EMC_DLL_XFORM_QUSE4 */
			0x00000018, /* EMC_DLL_XFORM_QUSE5 */
			0x00000018, /* EMC_DLL_XFORM_QUSE6 */
			0x00000018, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00080000, /* EMC_DLL_XFORM_DQ0 */
			0x00080000, /* EMC_DLL_XFORM_DQ1 */
			0x00080000, /* EMC_DLL_XFORM_DQ2 */
			0x00080000, /* EMC_DLL_XFORM_DQ3 */
			0x00120220, /* EMC_XM2CMDPADCTRL */
			0x0800201c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x01f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x00000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000068, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x00000013, /* EMC_ZCAL_WAIT_CNT */
			0x00090009, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80000287, /* EMC_DYN_SELF_REF_CONTROL */
			0x00010001, /* MC_EMEM_ARB_CFG */
			0xc000000a, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000004, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000001, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000000, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2R */
			0x02020001, /* MC_EMEM_ARB_DA_TURNS */
			0x00060402, /* MC_EMEM_ARB_DA_COVERS */
			0x72c30303, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x50000000, /* EMC_FBIO_SPARE */
			0xff00ff00, /* EMC_CFG_RSV */
		},
		0x00000009, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x00000000, /* Mode Register 0 */
		0x00010022, /* Mode Register 1 */
		0x00020001, /* Mode Register 2 */
		0x00000001, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		102000,     /* SDRAM frequency */
		{
			0x00000006, /* EMC_RC */
			0x0000000d, /* EMC_RFC */
			0x00000004, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x00000004, /* EMC_W2R */
			0x00000001, /* EMC_R2P */
			0x00000005, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000001, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000001, /* EMC_WDV */
			0x00000003, /* EMC_QUSE */
			0x00000001, /* EMC_QRST */
			0x00000009, /* EMC_QSAFE */
			0x0000000a, /* EMC_RDV */
			0x00000181, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000060, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000001, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x00000007, /* EMC_RW2PDEN */
			0x0000000f, /* EMC_TXSR */
			0x0000000f, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000008, /* EMC_TFAW */
			0x00000004, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000002, /* EMC_TCLKSTOP */
			0x000001a9, /* EMC_TREFBW */
			0x00000004, /* EMC_QUSE_EXTRA */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00004282, /* EMC_FBIO_CFG5 */
			0x007800a4, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x000a0000, /* EMC_DLL_XFORM_DQS0 */
			0x000a0000, /* EMC_DLL_XFORM_DQS1 */
			0x000a0000, /* EMC_DLL_XFORM_DQS2 */
			0x000a0000, /* EMC_DLL_XFORM_DQS3 */
			0x00000010, /* EMC_DLL_XFORM_DQS4 */
			0x00000010, /* EMC_DLL_XFORM_DQS5 */
			0x00000010, /* EMC_DLL_XFORM_DQS6 */
			0x00000010, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000008, /* EMC_DLL_XFORM_QUSE4 */
			0x00000008, /* EMC_DLL_XFORM_QUSE5 */
			0x00000008, /* EMC_DLL_XFORM_QUSE6 */
			0x00000008, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00080000, /* EMC_DLL_XFORM_DQ0 */
			0x00080000, /* EMC_DLL_XFORM_DQ1 */
			0x00080000, /* EMC_DLL_XFORM_DQ2 */
			0x00080000, /* EMC_DLL_XFORM_DQ3 */
			0x00120220, /* EMC_XM2CMDPADCTRL */
			0x0800201c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x01f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x00000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000068, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x00000025, /* EMC_ZCAL_WAIT_CNT */
			0x00090009, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x8000040b, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000001, /* MC_EMEM_ARB_CFG */
			0xc0000013, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000003, /* MC_EMEM_ARB_TIMING_RC */
			0x00000001, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000004, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000001, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000000, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2R */
			0x02020001, /* MC_EMEM_ARB_DA_TURNS */
			0x00060403, /* MC_EMEM_ARB_DA_COVERS */
			0x72430504, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x50000000, /* EMC_FBIO_SPARE */
			0xff00ff00, /* EMC_CFG_RSV */
		},
		0x0000000a, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x00000000, /* Mode Register 0 */
		0x00010022, /* Mode Register 1 */
		0x00020001, /* Mode Register 2 */
		0x00000001, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		204000,     /* SDRAM frequency */
		{
			0x0000000c, /* EMC_RC */
			0x0000001a, /* EMC_RFC */
			0x00000008, /* EMC_RAS */
			0x00000003, /* EMC_RP */
			0x00000005, /* EMC_R2W */
			0x00000004, /* EMC_W2R */
			0x00000001, /* EMC_R2P */
			0x00000006, /* EMC_W2P */
			0x00000003, /* EMC_RD_RCD */
			0x00000003, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000001, /* EMC_WDV */
			0x00000004, /* EMC_QUSE */
			0x00000001, /* EMC_QRST */
			0x0000000b, /* EMC_QSAFE */
			0x0000000a, /* EMC_RDV */
			0x00000303, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000000c0, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000001, /* EMC_PDEX2RD */
			0x00000003, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x00000007, /* EMC_RW2PDEN */
			0x0000001d, /* EMC_TXSR */
			0x0000001d, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x0000000b, /* EMC_TFAW */
			0x00000005, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000002, /* EMC_TCLKSTOP */
			0x00000351, /* EMC_TREFBW */
			0x00000005, /* EMC_QUSE_EXTRA */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00004282, /* EMC_FBIO_CFG5 */
			0x004400a4, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00070000, /* EMC_DLL_XFORM_DQS0 */
			0x00070000, /* EMC_DLL_XFORM_DQS1 */
			0x00070000, /* EMC_DLL_XFORM_DQS2 */
			0x00070000, /* EMC_DLL_XFORM_DQS3 */
			0x00000010, /* EMC_DLL_XFORM_DQS4 */
			0x00000010, /* EMC_DLL_XFORM_DQS5 */
			0x00000010, /* EMC_DLL_XFORM_DQS6 */
			0x00000010, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000018, /* EMC_DLL_XFORM_QUSE4 */
			0x00000018, /* EMC_DLL_XFORM_QUSE5 */
			0x00000018, /* EMC_DLL_XFORM_QUSE6 */
			0x00000018, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00078000, /* EMC_DLL_XFORM_DQ0 */
			0x00078000, /* EMC_DLL_XFORM_DQ1 */
			0x00078000, /* EMC_DLL_XFORM_DQ2 */
			0x00078000, /* EMC_DLL_XFORM_DQ3 */
			0x000d0220, /* EMC_XM2CMDPADCTRL */
			0x0800201c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x01f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x00000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000068, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x0000004a, /* EMC_ZCAL_WAIT_CNT */
			0x00090009, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80000713, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000003, /* MC_EMEM_ARB_CFG */
			0xc0000025, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000006, /* MC_EMEM_ARB_TIMING_RC */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000005, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000004, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000001, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000000, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2R */
			0x02030001, /* MC_EMEM_ARB_DA_TURNS */
			0x00070506, /* MC_EMEM_ARB_DA_COVERS */
			0x71e40a07, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0xd0000000, /* EMC_FBIO_SPARE */
			0xff00ff00, /* EMC_CFG_RSV */
		},
		0x00000013, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x00000000, /* Mode Register 0 */
		0x00010042, /* Mode Register 1 */
		0x00020001, /* Mode Register 2 */
		0x00000001, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		533000,     /* SDRAM frequency */
		{
			0x0000001f, /* EMC_RC */
			0x00000045, /* EMC_RFC */
			0x00000016, /* EMC_RAS */
			0x00000009, /* EMC_RP */
			0x00000008, /* EMC_R2W */
			0x00000009, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000d, /* EMC_W2P */
			0x00000009, /* EMC_RD_RCD */
			0x00000009, /* EMC_WR_RCD */
			0x00000005, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000004, /* EMC_WDV */
			0x00000009, /* EMC_QUSE */
			0x00000006, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x00000010, /* EMC_RDV */
			0x000007df, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000001f7, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000003, /* EMC_PDEX2WR */
			0x00000003, /* EMC_PDEX2RD */
			0x00000009, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x0000004b, /* EMC_TXSR */
			0x0000004b, /* EMC_TXSRDLL */
			0x00000008, /* EMC_TCKE */
			0x0000001b, /* EMC_TFAW */
			0x0000000c, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000002, /* EMC_TCLKSTOP */
			0x000008aa, /* EMC_TREFBW */
			0x00000000, /* EMC_QUSE_EXTRA */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00006282, /* EMC_FBIO_CFG5 */
			0xf0120091, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00000008, /* EMC_DLL_XFORM_DQS0 */
			0x00000008, /* EMC_DLL_XFORM_DQS1 */
			0x00000008, /* EMC_DLL_XFORM_DQS2 */
			0x00000008, /* EMC_DLL_XFORM_DQS3 */
			0x00000010, /* EMC_DLL_XFORM_DQS4 */
			0x00000010, /* EMC_DLL_XFORM_DQS5 */
			0x00000010, /* EMC_DLL_XFORM_DQS6 */
			0x00000010, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000008, /* EMC_DLL_XFORM_QUSE4 */
			0x00000008, /* EMC_DLL_XFORM_QUSE5 */
			0x00000008, /* EMC_DLL_XFORM_QUSE6 */
			0x00000008, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x0000000c, /* EMC_DLL_XFORM_DQ0 */
			0x0000000c, /* EMC_DLL_XFORM_DQ1 */
			0x0000000c, /* EMC_DLL_XFORM_DQ2 */
			0x0000000c, /* EMC_DLL_XFORM_DQ3 */
			0x00070220, /* EMC_XM2CMDPADCTRL */
			0x0400003d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x01f1f408, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x00000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000068, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x000000c0, /* EMC_ZCAL_WAIT_CNT */
			0x000e000e, /* EMC_MRS_WAIT_CNT */
			0xa0f10202, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x800010d9, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000008, /* MC_EMEM_ARB_CFG */
			0x80000060, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000003, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000004, /* MC_EMEM_ARB_TIMING_RP */
			0x00000010, /* MC_EMEM_ARB_TIMING_RC */
			0x0000000a, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000d, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000002, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000000, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_W2R */
			0x05040002, /* MC_EMEM_ARB_DA_TURNS */
			0x00110b10, /* MC_EMEM_ARB_DA_COVERS */
			0x71c81811, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x60000000, /* EMC_FBIO_SPARE */
			0xff00ff88, /* EMC_CFG_RSV */
		},
		0x00000030, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x00000000, /* Mode Register 0 */
		0x000100c2, /* Mode Register 1 */
		0x00020006, /* Mode Register 2 */
		0x00000000, /* EMC_CFG.DYN_SELF_REF */
	},
};

static const struct tegra_emc_table cardhu_emc_tables_h5tc2g_pm311[] = {
	{
		0x32,       /* Rev 3.2 */
		51000,      /* SDRAM frequency */
		{
			0x00000002, /* EMC_RC */
			0x00000008, /* EMC_RFC */
			0x00000001, /* EMC_RAS */
			0x00000000, /* EMC_RP */
			0x00000002, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000000, /* EMC_RD_RCD */
			0x00000000, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_QUSE */
			0x00000004, /* EMC_QRST */
			0x00000009, /* EMC_QSAFE */
			0x0000000b, /* EMC_RDV */
			0x00000181, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000060, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000007, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000009, /* EMC_TXSR */
			0x00000009, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000002, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x0000018e, /* EMC_TREFBW */
			0x00000006, /* EMC_QUSE_EXTRA */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00004288, /* EMC_FBIO_CFG5 */
			0x007800a4, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x000fc000, /* EMC_DLL_XFORM_DQS0 */
			0x000fc000, /* EMC_DLL_XFORM_DQS1 */
			0x000fc000, /* EMC_DLL_XFORM_DQS2 */
			0x000fc000, /* EMC_DLL_XFORM_DQS3 */
			0x000fc000, /* EMC_DLL_XFORM_DQS4 */
			0x000fc000, /* EMC_DLL_XFORM_DQS5 */
			0x000fc000, /* EMC_DLL_XFORM_DQS6 */
			0x000fc000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x000fc000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x000002a0, /* EMC_XM2CMDPADCTRL */
			0x0800211c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc084, /* EMC_XM2CLKPADCTRL */
			0x01f1f108, /* EMC_XM2COMPPADCTRL */
			0x05057404, /* EMC_XM2VTTGENPADCTRL */
			0x54000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000168, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000040, /* EMC_ZCAL_WAIT_CNT */
			0x000c000c, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x8000040b, /* EMC_DYN_SELF_REF_CONTROL */
			0x00010001, /* MC_EMEM_ARB_CFG */
			0xc000000a, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000001, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06020102, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0402, /* MC_EMEM_ARB_DA_COVERS */
			0x73430303, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0xe8000000, /* EMC_FBIO_SPARE */
			0xff00ff00, /* EMC_CFG_RSV */
		},
		0x00000040, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000001, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		102000,     /* SDRAM frequency */
		{
			0x00000005, /* EMC_RC */
			0x00000010, /* EMC_RFC */
			0x00000003, /* EMC_RAS */
			0x00000001, /* EMC_RP */
			0x00000002, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000001, /* EMC_RD_RCD */
			0x00000001, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_QUSE */
			0x00000004, /* EMC_QRST */
			0x00000009, /* EMC_QSAFE */
			0x0000000c, /* EMC_RDV */
			0x00000303, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000000c0, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000007, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000012, /* EMC_TXSR */
			0x00000012, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000004, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x0000031c, /* EMC_TREFBW */
			0x00000006, /* EMC_QUSE_EXTRA */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00004288, /* EMC_FBIO_CFG5 */
			0x007800a4, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x000fc000, /* EMC_DLL_XFORM_DQS0 */
			0x000fc000, /* EMC_DLL_XFORM_DQS1 */
			0x000fc000, /* EMC_DLL_XFORM_DQS2 */
			0x000fc000, /* EMC_DLL_XFORM_DQS3 */
			0x000fc000, /* EMC_DLL_XFORM_DQS4 */
			0x000fc000, /* EMC_DLL_XFORM_DQS5 */
			0x000fc000, /* EMC_DLL_XFORM_DQS6 */
			0x000fc000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x000fc000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x000002a0, /* EMC_XM2CMDPADCTRL */
			0x0800211c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc084, /* EMC_XM2CLKPADCTRL */
			0x01f1f108, /* EMC_XM2COMPPADCTRL */
			0x03037404, /* EMC_XM2VTTGENPADCTRL */
			0x54000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000168, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000040, /* EMC_ZCAL_WAIT_CNT */
			0x000c000c, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80000713, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000001, /* MC_EMEM_ARB_CFG */
			0xc0000013, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000003, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000001, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06020102, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0403, /* MC_EMEM_ARB_DA_COVERS */
			0x72830504, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0xe8000000, /* EMC_FBIO_SPARE */
			0xff00ff00, /* EMC_CFG_RSV */
		},
		0x00000040, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000001, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		204000,     /* SDRAM frequency */
		{
			0x0000000a, /* EMC_RC */
			0x00000020, /* EMC_RFC */
			0x00000007, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000002, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000006, /* EMC_QUSE */
			0x00000004, /* EMC_QRST */
			0x00000009, /* EMC_QSAFE */
			0x0000000b, /* EMC_RDV */
			0x00000607, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000181, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000007, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000023, /* EMC_TXSR */
			0x00000023, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000007, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000638, /* EMC_TREFBW */
			0x00000007, /* EMC_QUSE_EXTRA */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00004288, /* EMC_FBIO_CFG5 */
			0x004400a4, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00080000, /* EMC_DLL_XFORM_DQS0 */
			0x00080000, /* EMC_DLL_XFORM_DQS1 */
			0x00080000, /* EMC_DLL_XFORM_DQS2 */
			0x00080000, /* EMC_DLL_XFORM_DQS3 */
			0x00080000, /* EMC_DLL_XFORM_DQS4 */
			0x00080000, /* EMC_DLL_XFORM_DQS5 */
			0x00080000, /* EMC_DLL_XFORM_DQS6 */
			0x00080000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00080000, /* EMC_DLL_XFORM_DQ0 */
			0x00080000, /* EMC_DLL_XFORM_DQ1 */
			0x00080000, /* EMC_DLL_XFORM_DQ2 */
			0x00080000, /* EMC_DLL_XFORM_DQ3 */
			0x000002a0, /* EMC_XM2CMDPADCTRL */
			0x0800211c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77fff884, /* EMC_XM2CLKPADCTRL */
			0x01f1f108, /* EMC_XM2COMPPADCTRL */
			0x05057404, /* EMC_XM2VTTGENPADCTRL */
			0x54000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000168, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x000c000c, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80000d22, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000003, /* MC_EMEM_ARB_CFG */
			0xc0000025, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000005, /* MC_EMEM_ARB_TIMING_RC */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06020102, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0405, /* MC_EMEM_ARB_DA_COVERS */
			0x72440a06, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0xe8000000, /* EMC_FBIO_SPARE */
			0xff00ff00, /* EMC_CFG_RSV */
		},
		0x00000040, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000001, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		333500,     /* SDRAM frequency */
		{
			0x0000000f, /* EMC_RC */
			0x00000034, /* EMC_RFC */
			0x0000000a, /* EMC_RAS */
			0x00000003, /* EMC_RP */
			0x00000003, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000002, /* EMC_R2P */
			0x00000009, /* EMC_W2P */
			0x00000003, /* EMC_RD_RCD */
			0x00000003, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000004, /* EMC_WDV */
			0x00000006, /* EMC_QUSE */
			0x00000004, /* EMC_QRST */
			0x0000000a, /* EMC_QSAFE */
			0x0000000c, /* EMC_RDV */
			0x000009e9, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x0000027a, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000008, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000007, /* EMC_AR2PDEN */
			0x0000000e, /* EMC_RW2PDEN */
			0x00000039, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x0000000a, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000a2a, /* EMC_TREFBW */
			0x00000000, /* EMC_QUSE_EXTRA */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00007088, /* EMC_FBIO_CFG5 */
			0x002600a4, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00014000, /* EMC_DLL_XFORM_DQS0 */
			0x00014000, /* EMC_DLL_XFORM_DQS1 */
			0x00014000, /* EMC_DLL_XFORM_DQS2 */
			0x00014000, /* EMC_DLL_XFORM_DQS3 */
			0x00014000, /* EMC_DLL_XFORM_DQS4 */
			0x00014000, /* EMC_DLL_XFORM_DQS5 */
			0x00014000, /* EMC_DLL_XFORM_DQS6 */
			0x00014000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00050000, /* EMC_DLL_XFORM_DQ0 */
			0x00050000, /* EMC_DLL_XFORM_DQ1 */
			0x00050000, /* EMC_DLL_XFORM_DQ2 */
			0x00050000, /* EMC_DLL_XFORM_DQ3 */
			0x000002a0, /* EMC_XM2CMDPADCTRL */
			0x0800013d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77fff884, /* EMC_XM2CLKPADCTRL */
			0x01f1f508, /* EMC_XM2COMPPADCTRL */
			0x05057404, /* EMC_XM2VTTGENPADCTRL */
			0x54000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x080001e8, /* EMC_XM2QUSEPADCTRL */
			0x08000021, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x018b000c, /* EMC_MRS_WAIT_CNT */
			0xa0f11c1c, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x800014d4, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000005, /* MC_EMEM_ARB_CFG */
			0x8000003d, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RP */
			0x00000008, /* MC_EMEM_ARB_TIMING_RC */
			0x00000004, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000004, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030202, /* MC_EMEM_ARB_DA_TURNS */
			0x000b0608, /* MC_EMEM_ARB_DA_COVERS */
			0x76850f09, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0xe8000000, /* EMC_FBIO_SPARE */
			0xff00ff89, /* EMC_CFG_RSV */
		},
		0x00000040, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000000, /* EMC_CFG.PERIODIC_QRST */
		0x80000321, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200000, /* Mode Register 2 */
		0x00000000, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		667000,     /* SDRAM frequency */
		{
			0x00000020, /* EMC_RC */
			0x00000069, /* EMC_RFC */
			0x00000017, /* EMC_RAS */
			0x00000007, /* EMC_RP */
			0x00000005, /* EMC_R2W */
			0x0000000c, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x00000011, /* EMC_W2P */
			0x00000007, /* EMC_RD_RCD */
			0x00000007, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000007, /* EMC_WDV */
			0x0000000b, /* EMC_QUSE */
			0x00000009, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x00000011, /* EMC_RDV */
			0x00001412, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000504, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x0000000e, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x0000000c, /* EMC_AR2PDEN */
			0x00000016, /* EMC_RW2PDEN */
			0x00000072, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000005, /* EMC_TCKE */
			0x00000015, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000006, /* EMC_TCLKSTABLE */
			0x00000007, /* EMC_TCLKSTOP */
			0x00001453, /* EMC_TREFBW */
			0x0000000c, /* EMC_QUSE_EXTRA */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00005088, /* EMC_FBIO_CFG5 */
			0xf00b0191, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x0000000a, /* EMC_DLL_XFORM_DQS0 */
			0x0000000a, /* EMC_DLL_XFORM_DQS1 */
			0x0000000a, /* EMC_DLL_XFORM_DQS2 */
			0x0000000a, /* EMC_DLL_XFORM_DQS3 */
			0x0000000a, /* EMC_DLL_XFORM_DQS4 */
			0x0000000a, /* EMC_DLL_XFORM_DQS5 */
			0x0000000a, /* EMC_DLL_XFORM_DQS6 */
			0x0000000a, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x0000000a, /* EMC_DLL_XFORM_DQ0 */
			0x0000000a, /* EMC_DLL_XFORM_DQ1 */
			0x0000000a, /* EMC_DLL_XFORM_DQ2 */
			0x0000000a, /* EMC_DLL_XFORM_DQ3 */
			0x000002a0, /* EMC_XM2CMDPADCTRL */
			0x0700013d, /* EMC_XM2DQSPADCTRL2 */
			0x22220000, /* EMC_XM2DQPADCTRL2 */
			0x77fff884, /* EMC_XM2CLKPADCTRL */
			0x01f1f501, /* EMC_XM2COMPPADCTRL */
			0x07077404, /* EMC_XM2VTTGENPADCTRL */
			0x54000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x080001e8, /* EMC_XM2QUSEPADCTRL */
			0x07000021, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x0156000c, /* EMC_MRS_WAIT_CNT */
			0xa0f11d1d, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x800028a5, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* MC_EMEM_ARB_CFG */
			0x80000079, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000003, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000004, /* MC_EMEM_ARB_TIMING_RP */
			0x00000010, /* MC_EMEM_ARB_TIMING_RC */
			0x0000000b, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000a, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000b, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000008, /* MC_EMEM_ARB_TIMING_W2R */
			0x08040202, /* MC_EMEM_ARB_DA_TURNS */
			0x00130b10, /* MC_EMEM_ARB_DA_COVERS */
			0x734a1f11, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0xe8000000, /* EMC_FBIO_SPARE */
			0xff00ff49, /* EMC_CFG_RSV */
		},
		0x00000040, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x80000b71, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200018, /* Mode Register 2 */
		0x00000000, /* EMC_CFG.DYN_SELF_REF */
	},
};

static const u32 pm269_bit_swap_map[32] = {
      /* DDR bit #    SoC bit # */
	[0]  = 0x1 << 1,
	[1]  = 0x1 << 2,
	[2]  = 0x1 << 3,
	[3]  = 0x1 << 0,
	[4]  = 0x1 << 7,
	[5]  = 0x1 << 5,
	[6]  = 0x1 << 6,
	[7]  = 0x1 << 4,

	[8]  = 0x1 << 13,
	[9]  = 0x1 << 9,
	[10] = 0x1 << 8,
	[11] = 0x1 << 12,
	[12] = 0x1 << 11,
	[13] = 0x1 << 10,
	[14] = 0x1 << 14,
	[15] = 0x1 << 15,

	[16] = 0x1 << 20,
	[17] = 0x1 << 23,
	[18] = 0x1 << 16,
	[19] = 0x1 << 19,
	[20] = 0x1 << 18,
	[21] = 0x1 << 21,
	[22] = 0x1 << 22,
	[23] = 0x1 << 17,

	[24] = 0x1 << 27,
	[25] = 0x1 << 30,
	[26] = 0x1 << 31,
	[27] = 0x1 << 28,
	[28] = 0x1 << 26,
	[29] = 0x1 << 25,
	[30] = 0x1 << 24,
	[31] = 0x1 << 29,
};

int cardhu_emc_init(void)
{
	struct board_info board;

	tegra_get_board_info(&board);

	switch (board.board_id) {
	case BOARD_PM269:
		tegra_init_dram_bit_map(pm269_bit_swap_map,
				ARRAY_SIZE(pm269_bit_swap_map));
		/* fall through */
	case BOARD_E1257:
		if (MEMORY_TYPE(board.sku) == SKU_MEMORY_ELPIDA)
			tegra_init_emc(cardhu_emc_tables_edb8132b2ma,
				ARRAY_SIZE(cardhu_emc_tables_edb8132b2ma));
		else
			tegra_init_emc(cardhu_emc_tables_k4p8g304eb,
				ARRAY_SIZE(cardhu_emc_tables_k4p8g304eb));
		break;

	case BOARD_PM305:
		break;
	case BOARD_PM311:
		tegra_init_emc(cardhu_emc_tables_h5tc2g_pm311,
			ARRAY_SIZE(cardhu_emc_tables_h5tc2g_pm311));
		break;
	default:
		if (tegra_get_revision() == TEGRA_REVISION_A01)
			tegra_init_emc(cardhu_emc_tables_h5tc2g,
				ARRAY_SIZE(cardhu_emc_tables_h5tc2g));
		else if (MEMORY_TYPE(board.sku) == SKU_MEMORY_CARDHU_1GB_1R)
			tegra_init_emc(cardhu_emc_tables_h5tc2g_a2,
				ARRAY_SIZE(cardhu_emc_tables_h5tc2g_a2));
		else if (MEMORY_TYPE(board.sku) ==
				SKU_MEMORY_CARDHU_2GB_1R_HYK0)
			tegra_init_emc(cardhu_emc_tables_k4b4g0846b_hyk0,
				ARRAY_SIZE(cardhu_emc_tables_k4b4g0846b_hyk0));
		else if (MEMORY_TYPE(board.sku) ==
				SKU_MEMORY_CARDHU_2GB_1R_HYNIX)
			tegra_init_emc(cardhu_emc_tables_h5tc2g_a2_2GB1R,
				ARRAY_SIZE(cardhu_emc_tables_h5tc2g_a2_2GB1R));
		break;
	}
	return 0;
}
