#!/usr/bin/perl

use Test::More tests => 3;
use Test::Deep;
use Debian::LicenseReconcile::Utils qw(get_files);
use Debian::LicenseReconcile::Filter::Rules;
use Readonly;

Readonly my $DIR => 't/data/example';

my @files = get_files($DIR);

my $filter = Debian::LicenseReconcile::Filter::Rules->new(
    directory=>$DIR,
    name=>'Rules5',
    config=>{
        rules=>[
            {
                MMagic=>'application/octet-stream',
                License=>'BSD',
                Copyright=>'[Copyright: 2012, Periapt Technologies. All rights reserved]',
            },
            {
                Glob=>'b*s?',
                MMagic=>'text/plain',
                License=>'GPL-1',
                Copyright=>'[Copyright: 2012, Periapt Technologies. All rights reserved]',
            },
        ],
    },
    files_remaining=>\@files,
);
isa_ok($filter, 'Debian::LicenseReconcile::Filter');
isa_ok($filter, 'Debian::LicenseReconcile::Filter::Rules');

my @data = sort { $a->{file} cmp $b->{file} } $filter->get_info;
cmp_deeply(\@data, [
    {
        file=>'base',
        license=>'GPL-1',
        test=>'Rules5',
        copyright=>'[Copyright: 2012, Periapt Technologies. All rights reserved]',
    },
    {
        file=>'sample.png',
        license=>'BSD',
        test=>'Rules5',
        copyright=>'[Copyright: 2012, Periapt Technologies. All rights reserved]',
    },
]);
