/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2009-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     Mischa Sall\'e <msalle@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl> 
 *
 *  2007-2009
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 *  2003-2007
 *     Martijn Steenbakkers <martijn@nikhef.nl>
 *     Gerben Venekamp <venekamp@nikhef.nl>
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 */


/*!
    \file   lcmaps_cred_data.h
    \brief  Public header file to be used by plugins

    Routines to access the credential data that are gathered by the plugins.
    \author Martijn Steenbakkers and Oscar Koeroo for the EU DataGrid.
    \ingroup APIforLcmapsPlugins
*/

#ifndef LCMAPS_CRED_DATA_H
#define LCMAPS_CRED_DATA_H

/******************************************************************************
                             Define constants
******************************************************************************/
#define DN                        5
#define UID                      10
#define PRI_GID                  20
#define SEC_GID                  30
#define LCMAPS_VO_CRED           90
#define LCMAPS_VO_CRED_STRING   100
#define LCMAPS_VO_CRED_MAPPING  110
#define POOL_INDEX              200


/******************************************************************************
                             Include header files
******************************************************************************/

#include <pwd.h>
#include "lcmaps_vo_data.h"

/******************************************************************************
                               Type definitions
******************************************************************************/


/*!
    \struct cred_data_s
    \brief structure that contains the gathered (local) credentials en VOMS info
*/
/*!
    \typedef cred_data_t
    \brief Type of credential data
*/
typedef struct cred_data_s
{
    char                 *dn;                /*!< user globus DN */
    uid_t                *uid;               /*!< list of userIDs */
    gid_t                *priGid;            /*!< list of primary groupIDs */
    gid_t                *secGid;            /*!< list of secondary groupIDs */
    lcmaps_vo_data_t     *VoCred;            /*!< list of VO data structures */
    char                **VoCredString;      /*!< list of VO data strings */
    lcmaps_vo_mapping_t  *VoCredMapping;     /*!< list of VO mapping structures */
    int                   cntUid;            /*!< number of userIDs */
    int                   cntPriGid;         /*!< number of primary groupIDs (in principle only one) */
    int                   cntSecGid;         /*!< number of secondary groupIDs (could be any number) */
    int                   cntVoCred;         /*!< number of VO data structures */
    int                   cntVoCredString;   /*!< number of VO data strings */
    int                   cntVoCredMapping;  /*!< number of VO mapping structures */
    char                 *pool_index;        /*!< pool_index is the concat of a DN+GIDs for the DAS */
} cred_data_t;


/******************************************************************************
 *                 Module definition
 *****************************************************************************/

/******************************************************************************
Function:   addCredentialData
Description:
    Add a credential to the list of found credentials (uids, gids etc)

Parameters:
    datatype: type of credential
    data:     pointer to credential
Returns:
    0:  success
    -1: failure (unknown data type, realloc error)
******************************************************************************/
extern int   addCredentialData(int datatype, void *data);

/******************************************************************************
Function:   getCredentialData
Description:
    Get pointer to a list of credential data of a certain type

Parameters:
    datatype: type of credential
    count:    number of credentials found in list of datatype
Returns:
    pointer to list of credential data or NULL in case of failure
******************************************************************************/
extern void *getCredentialData(int datatype, int *count);

#endif /* LCMAPS_CRED_DATA_H */

/******************************************************************************
CVS Information:
    $Source: /srv/home/dennisvd/svn/mw-security/lcmaps/interface/lcmaps_cred_data.h,v $
    $Date: 2011-03-04 21:55:13 +0100 (Fri, 04 Mar 2011) $
    $Revision: 14868 $
    $Author: dennisvd $
******************************************************************************/
