/*
 * Kylin-video
 *
 * Copyright (C) 2021, Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Liu Cong <liucong1@kylinos.cn>
 *
 */

#ifndef FUNCTIONS_H
#define FUNCTIONS_H

#include <time.h>
#include <unistd.h>
#include <math.h>

#include <QStringList>
#include <QIcon>
#include <QDate>

struct AVDictionary;

class QHeaderView;
class QMPlay2OSD;
class VideoFrame;
class QMimeData;
class QPainter;
class QPixmap;
class QWindow;
class QIcon;
class QRect;

namespace Functions
{
    struct DemuxerInfo
    {
        QString name;
        QIcon icon;
        QStringList extensions;
    };
    using DemuxersInfos = QVector<DemuxerInfo>;
    using ChecksumList = QVector<quint64>;
    QString Url(QString, const QString &pth = QString());
    QString getUrlType(const QString &url);
    QString timeToStr(const double t, const bool decimals = false);

    QString filePath(const QString &);
    QString fileExt(const QString &);
    QString processComand(const QString &);
    bool isKirinCpu();
    bool isQingsongDevice();
}

#endif
