Ext.namespace('Zarafa.core');

/**
 * @class Zarafa.core.ErrorType
 * @extends Zarafa.core.Enum
 * 
 * @singleton
 */
Zarafa.core.ErrorType = Zarafa.core.Enum.create({
	/**
	 * Denotes type of error is MAPI which is generated from an errornous mapi call.
	 * @property
	 * @type Number
	 */
	'MAPI' : 1,

	/**
	 * Denotes type of error is ZARAFA which is generated by our PHP code.
	 * @property
	 * @type Number
	 */
	'ZARAFA' : 2,

	/**
	 * Denotes type of error is GENERAL which is generated by PHP's error handler.
	 * @property
	 * @type Number
	 */
	'GENERAL' : 3
});

