/***************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
***************************************************************************/

#ifndef LOGGER_H
#define LOGGER_H

#include <QObject>
#include <QFile>
#include <QString>

class Logger : public QObject
{
public:
    enum LogLevel{ DEBUG_LEVEL=1, INFO_LEVEL=5, WARNING_LEVEL=10, ERROR_LEVEL=15 };

private:
    static QFile* m_file;
    static int m_nbInstance;
    static QString m_logFileName;
    static LogLevel m_level;
    QString m_className;

public:
    Logger(QObject* parent = 0);
    Logger(QString className);
    ~Logger();

    QString className() const;
    void setClassName(const QString&);

    void debug(QString);
    void info(QString);
    void warning(QString);
    void error(QString);

    static void setFileName(const QString&);
    static void setLevel(Logger::LogLevel=DEBUG_LEVEL);
    static void setLevel(const QString&);

private:
    void init();
    void write(QString priority, QString text);
};

#endif
