
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQAbstractAudioDeviceInfo.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QAbstractAudioDeviceInfo>
#include <QAudioFormat>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QAbstractAudioDeviceInfo

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QAbstractAudioDeviceInfo::staticMetaObject);
}


// QString QAbstractAudioDeviceInfo::deviceName()


static void _init_f_deviceName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_deviceName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QAbstractAudioDeviceInfo *)cls)->deviceName ());
}


// bool QAbstractAudioDeviceInfo::isFormatSupported(const QAudioFormat &format)


static void _init_f_isFormatSupported_c2509 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QAudioFormat & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isFormatSupported_c2509 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QAudioFormat &arg1 = gsi::arg_reader<const QAudioFormat & >() (args, heap);
  ret.write<bool > ((bool)((QAbstractAudioDeviceInfo *)cls)->isFormatSupported (arg1));
}


// QAudioFormat QAbstractAudioDeviceInfo::preferredFormat()


static void _init_f_preferredFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAudioFormat > ();
}

static void _call_f_preferredFormat_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAudioFormat > ((QAudioFormat)((QAbstractAudioDeviceInfo *)cls)->preferredFormat ());
}


// QList<QAudioFormat::Endian> QAbstractAudioDeviceInfo::supportedByteOrders()


static void _init_f_supportedByteOrders_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QAudioFormat::Endian> > ();
}

static void _call_f_supportedByteOrders_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QAudioFormat::Endian> > ((QList<QAudioFormat::Endian>)((QAbstractAudioDeviceInfo *)cls)->supportedByteOrders ());
}


// QList<int> QAbstractAudioDeviceInfo::supportedChannelCounts()


static void _init_f_supportedChannelCounts_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<int> > ();
}

static void _call_f_supportedChannelCounts_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<int> > ((QList<int>)((QAbstractAudioDeviceInfo *)cls)->supportedChannelCounts ());
}


// QStringList QAbstractAudioDeviceInfo::supportedCodecs()


static void _init_f_supportedCodecs_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_supportedCodecs_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QAbstractAudioDeviceInfo *)cls)->supportedCodecs ());
}


// QList<int> QAbstractAudioDeviceInfo::supportedSampleRates()


static void _init_f_supportedSampleRates_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<int> > ();
}

static void _call_f_supportedSampleRates_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<int> > ((QList<int>)((QAbstractAudioDeviceInfo *)cls)->supportedSampleRates ());
}


// QList<int> QAbstractAudioDeviceInfo::supportedSampleSizes()


static void _init_f_supportedSampleSizes_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<int> > ();
}

static void _call_f_supportedSampleSizes_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<int> > ((QList<int>)((QAbstractAudioDeviceInfo *)cls)->supportedSampleSizes ());
}


// QList<QAudioFormat::SampleType> QAbstractAudioDeviceInfo::supportedSampleTypes()


static void _init_f_supportedSampleTypes_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QAudioFormat::SampleType> > ();
}

static void _call_f_supportedSampleTypes_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QAudioFormat::SampleType> > ((QList<QAudioFormat::SampleType>)((QAbstractAudioDeviceInfo *)cls)->supportedSampleTypes ());
}


// static QString QAbstractAudioDeviceInfo::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QAbstractAudioDeviceInfo::tr (arg1, arg2, arg3));
}


// static QString QAbstractAudioDeviceInfo::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QAbstractAudioDeviceInfo::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QAbstractAudioDeviceInfo () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("deviceName", "@brief Method QString QAbstractAudioDeviceInfo::deviceName()\n", true, &_init_f_deviceName_c0, &_call_f_deviceName_c0);
  methods += new qt_gsi::GenericMethod ("isFormatSupported?", "@brief Method bool QAbstractAudioDeviceInfo::isFormatSupported(const QAudioFormat &format)\n", true, &_init_f_isFormatSupported_c2509, &_call_f_isFormatSupported_c2509);
  methods += new qt_gsi::GenericMethod ("preferredFormat", "@brief Method QAudioFormat QAbstractAudioDeviceInfo::preferredFormat()\n", true, &_init_f_preferredFormat_c0, &_call_f_preferredFormat_c0);
  methods += new qt_gsi::GenericMethod ("supportedByteOrders", "@brief Method QList<QAudioFormat::Endian> QAbstractAudioDeviceInfo::supportedByteOrders()\n", false, &_init_f_supportedByteOrders_0, &_call_f_supportedByteOrders_0);
  methods += new qt_gsi::GenericMethod ("supportedChannelCounts", "@brief Method QList<int> QAbstractAudioDeviceInfo::supportedChannelCounts()\n", false, &_init_f_supportedChannelCounts_0, &_call_f_supportedChannelCounts_0);
  methods += new qt_gsi::GenericMethod ("supportedCodecs", "@brief Method QStringList QAbstractAudioDeviceInfo::supportedCodecs()\n", false, &_init_f_supportedCodecs_0, &_call_f_supportedCodecs_0);
  methods += new qt_gsi::GenericMethod ("supportedSampleRates", "@brief Method QList<int> QAbstractAudioDeviceInfo::supportedSampleRates()\n", false, &_init_f_supportedSampleRates_0, &_call_f_supportedSampleRates_0);
  methods += new qt_gsi::GenericMethod ("supportedSampleSizes", "@brief Method QList<int> QAbstractAudioDeviceInfo::supportedSampleSizes()\n", false, &_init_f_supportedSampleSizes_0, &_call_f_supportedSampleSizes_0);
  methods += new qt_gsi::GenericMethod ("supportedSampleTypes", "@brief Method QList<QAudioFormat::SampleType> QAbstractAudioDeviceInfo::supportedSampleTypes()\n", false, &_init_f_supportedSampleTypes_0, &_call_f_supportedSampleTypes_0);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QAbstractAudioDeviceInfo::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QAbstractAudioDeviceInfo::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QAbstractAudioDeviceInfo::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QAbstractAudioDeviceInfo::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QAbstractAudioDeviceInfo> decl_QAbstractAudioDeviceInfo (qtdecl_QObject (), "QtMultimedia", "QAbstractAudioDeviceInfo_Native",
  methods_QAbstractAudioDeviceInfo (),
  "@hide\n@alias QAbstractAudioDeviceInfo");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QAbstractAudioDeviceInfo> &qtdecl_QAbstractAudioDeviceInfo () { return decl_QAbstractAudioDeviceInfo; }

}


class QAbstractAudioDeviceInfo_Adaptor : public QAbstractAudioDeviceInfo, public qt_gsi::QtObjectBase
{
public:

  virtual ~QAbstractAudioDeviceInfo_Adaptor();

  //  [adaptor ctor] QAbstractAudioDeviceInfo::QAbstractAudioDeviceInfo()
  QAbstractAudioDeviceInfo_Adaptor() : QAbstractAudioDeviceInfo()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QAbstractAudioDeviceInfo::isSignalConnected(const QMetaMethod &signal)
  bool fp_QAbstractAudioDeviceInfo_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QAbstractAudioDeviceInfo::isSignalConnected(signal);
  }

  //  [expose] int QAbstractAudioDeviceInfo::receivers(const char *signal)
  int fp_QAbstractAudioDeviceInfo_receivers_c1731 (const char *signal) const {
    return QAbstractAudioDeviceInfo::receivers(signal);
  }

  //  [expose] QObject *QAbstractAudioDeviceInfo::sender()
  QObject * fp_QAbstractAudioDeviceInfo_sender_c0 () const {
    return QAbstractAudioDeviceInfo::sender();
  }

  //  [expose] int QAbstractAudioDeviceInfo::senderSignalIndex()
  int fp_QAbstractAudioDeviceInfo_senderSignalIndex_c0 () const {
    return QAbstractAudioDeviceInfo::senderSignalIndex();
  }

  //  [emitter impl] void QAbstractAudioDeviceInfo::destroyed(QObject *)
  void emitter_QAbstractAudioDeviceInfo_destroyed_1302(QObject *arg1)
  {
    emit QAbstractAudioDeviceInfo::destroyed(arg1);
  }

  //  [adaptor impl] QString QAbstractAudioDeviceInfo::deviceName()
  QString cbs_deviceName_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("deviceName");
  }

  virtual QString deviceName() const
  {
    if (cb_deviceName_c0_0.can_issue()) {
      return cb_deviceName_c0_0.issue<QAbstractAudioDeviceInfo_Adaptor, QString>(&QAbstractAudioDeviceInfo_Adaptor::cbs_deviceName_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("deviceName");
    }
  }

  //  [adaptor impl] bool QAbstractAudioDeviceInfo::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QAbstractAudioDeviceInfo::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QAbstractAudioDeviceInfo_Adaptor, bool, QEvent *>(&QAbstractAudioDeviceInfo_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QAbstractAudioDeviceInfo::event(_event);
    }
  }

  //  [adaptor impl] bool QAbstractAudioDeviceInfo::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QAbstractAudioDeviceInfo::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QAbstractAudioDeviceInfo_Adaptor, bool, QObject *, QEvent *>(&QAbstractAudioDeviceInfo_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QAbstractAudioDeviceInfo::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] bool QAbstractAudioDeviceInfo::isFormatSupported(const QAudioFormat &format)
  bool cbs_isFormatSupported_c2509_0(const QAudioFormat &format) const
  {
    __SUPPRESS_UNUSED_WARNING (format);
    throw qt_gsi::AbstractMethodCalledException("isFormatSupported");
  }

  virtual bool isFormatSupported(const QAudioFormat &format) const
  {
    if (cb_isFormatSupported_c2509_0.can_issue()) {
      return cb_isFormatSupported_c2509_0.issue<QAbstractAudioDeviceInfo_Adaptor, bool, const QAudioFormat &>(&QAbstractAudioDeviceInfo_Adaptor::cbs_isFormatSupported_c2509_0, format);
    } else {
      throw qt_gsi::AbstractMethodCalledException("isFormatSupported");
    }
  }

  //  [emitter impl] void QAbstractAudioDeviceInfo::objectNameChanged(const QString &objectName)
  void emitter_QAbstractAudioDeviceInfo_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QAbstractAudioDeviceInfo::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] QAudioFormat QAbstractAudioDeviceInfo::preferredFormat()
  QAudioFormat cbs_preferredFormat_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("preferredFormat");
  }

  virtual QAudioFormat preferredFormat() const
  {
    if (cb_preferredFormat_c0_0.can_issue()) {
      return cb_preferredFormat_c0_0.issue<QAbstractAudioDeviceInfo_Adaptor, QAudioFormat>(&QAbstractAudioDeviceInfo_Adaptor::cbs_preferredFormat_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("preferredFormat");
    }
  }

  //  [adaptor impl] QList<QAudioFormat::Endian> QAbstractAudioDeviceInfo::supportedByteOrders()
  QList<QAudioFormat::Endian> cbs_supportedByteOrders_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("supportedByteOrders");
  }

  virtual QList<QAudioFormat::Endian> supportedByteOrders()
  {
    if (cb_supportedByteOrders_0_0.can_issue()) {
      return cb_supportedByteOrders_0_0.issue<QAbstractAudioDeviceInfo_Adaptor, QList<QAudioFormat::Endian> >(&QAbstractAudioDeviceInfo_Adaptor::cbs_supportedByteOrders_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("supportedByteOrders");
    }
  }

  //  [adaptor impl] QList<int> QAbstractAudioDeviceInfo::supportedChannelCounts()
  QList<int> cbs_supportedChannelCounts_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("supportedChannelCounts");
  }

  virtual QList<int> supportedChannelCounts()
  {
    if (cb_supportedChannelCounts_0_0.can_issue()) {
      return cb_supportedChannelCounts_0_0.issue<QAbstractAudioDeviceInfo_Adaptor, QList<int> >(&QAbstractAudioDeviceInfo_Adaptor::cbs_supportedChannelCounts_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("supportedChannelCounts");
    }
  }

  //  [adaptor impl] QStringList QAbstractAudioDeviceInfo::supportedCodecs()
  QStringList cbs_supportedCodecs_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("supportedCodecs");
  }

  virtual QStringList supportedCodecs()
  {
    if (cb_supportedCodecs_0_0.can_issue()) {
      return cb_supportedCodecs_0_0.issue<QAbstractAudioDeviceInfo_Adaptor, QStringList>(&QAbstractAudioDeviceInfo_Adaptor::cbs_supportedCodecs_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("supportedCodecs");
    }
  }

  //  [adaptor impl] QList<int> QAbstractAudioDeviceInfo::supportedSampleRates()
  QList<int> cbs_supportedSampleRates_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("supportedSampleRates");
  }

  virtual QList<int> supportedSampleRates()
  {
    if (cb_supportedSampleRates_0_0.can_issue()) {
      return cb_supportedSampleRates_0_0.issue<QAbstractAudioDeviceInfo_Adaptor, QList<int> >(&QAbstractAudioDeviceInfo_Adaptor::cbs_supportedSampleRates_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("supportedSampleRates");
    }
  }

  //  [adaptor impl] QList<int> QAbstractAudioDeviceInfo::supportedSampleSizes()
  QList<int> cbs_supportedSampleSizes_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("supportedSampleSizes");
  }

  virtual QList<int> supportedSampleSizes()
  {
    if (cb_supportedSampleSizes_0_0.can_issue()) {
      return cb_supportedSampleSizes_0_0.issue<QAbstractAudioDeviceInfo_Adaptor, QList<int> >(&QAbstractAudioDeviceInfo_Adaptor::cbs_supportedSampleSizes_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("supportedSampleSizes");
    }
  }

  //  [adaptor impl] QList<QAudioFormat::SampleType> QAbstractAudioDeviceInfo::supportedSampleTypes()
  QList<QAudioFormat::SampleType> cbs_supportedSampleTypes_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("supportedSampleTypes");
  }

  virtual QList<QAudioFormat::SampleType> supportedSampleTypes()
  {
    if (cb_supportedSampleTypes_0_0.can_issue()) {
      return cb_supportedSampleTypes_0_0.issue<QAbstractAudioDeviceInfo_Adaptor, QList<QAudioFormat::SampleType> >(&QAbstractAudioDeviceInfo_Adaptor::cbs_supportedSampleTypes_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("supportedSampleTypes");
    }
  }

  //  [adaptor impl] void QAbstractAudioDeviceInfo::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QAbstractAudioDeviceInfo::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QAbstractAudioDeviceInfo_Adaptor, QChildEvent *>(&QAbstractAudioDeviceInfo_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QAbstractAudioDeviceInfo::childEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractAudioDeviceInfo::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QAbstractAudioDeviceInfo::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QAbstractAudioDeviceInfo_Adaptor, QEvent *>(&QAbstractAudioDeviceInfo_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QAbstractAudioDeviceInfo::customEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractAudioDeviceInfo::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QAbstractAudioDeviceInfo::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QAbstractAudioDeviceInfo_Adaptor, const QMetaMethod &>(&QAbstractAudioDeviceInfo_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QAbstractAudioDeviceInfo::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QAbstractAudioDeviceInfo::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QAbstractAudioDeviceInfo::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QAbstractAudioDeviceInfo_Adaptor, QTimerEvent *>(&QAbstractAudioDeviceInfo_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QAbstractAudioDeviceInfo::timerEvent(event);
    }
  }

  gsi::Callback cb_deviceName_c0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_isFormatSupported_c2509_0;
  gsi::Callback cb_preferredFormat_c0_0;
  gsi::Callback cb_supportedByteOrders_0_0;
  gsi::Callback cb_supportedChannelCounts_0_0;
  gsi::Callback cb_supportedCodecs_0_0;
  gsi::Callback cb_supportedSampleRates_0_0;
  gsi::Callback cb_supportedSampleSizes_0_0;
  gsi::Callback cb_supportedSampleTypes_0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QAbstractAudioDeviceInfo_Adaptor::~QAbstractAudioDeviceInfo_Adaptor() { }

//  Constructor QAbstractAudioDeviceInfo::QAbstractAudioDeviceInfo() (adaptor class)

static void _init_ctor_QAbstractAudioDeviceInfo_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QAbstractAudioDeviceInfo_Adaptor> ();
}

static void _call_ctor_QAbstractAudioDeviceInfo_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAbstractAudioDeviceInfo_Adaptor *> (new QAbstractAudioDeviceInfo_Adaptor ());
}


// void QAbstractAudioDeviceInfo::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioDeviceInfo_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioDeviceInfo_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QAbstractAudioDeviceInfo::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioDeviceInfo_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioDeviceInfo_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QAbstractAudioDeviceInfo::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QAbstractAudioDeviceInfo_Adaptor *)cls)->emitter_QAbstractAudioDeviceInfo_destroyed_1302 (arg1);
}


// QString QAbstractAudioDeviceInfo::deviceName()

static void _init_cbs_deviceName_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_cbs_deviceName_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QAbstractAudioDeviceInfo_Adaptor *)cls)->cbs_deviceName_c0_0 ());
}

static void _set_callback_cbs_deviceName_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioDeviceInfo_Adaptor *)cls)->cb_deviceName_c0_0 = cb;
}


// void QAbstractAudioDeviceInfo::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioDeviceInfo_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioDeviceInfo_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QAbstractAudioDeviceInfo::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAbstractAudioDeviceInfo_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioDeviceInfo_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QAbstractAudioDeviceInfo::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAbstractAudioDeviceInfo_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioDeviceInfo_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// bool QAbstractAudioDeviceInfo::isFormatSupported(const QAudioFormat &format)

static void _init_cbs_isFormatSupported_c2509_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QAudioFormat & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_isFormatSupported_c2509_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QAudioFormat &arg1 = args.read<const QAudioFormat & > (heap);
  ret.write<bool > ((bool)((QAbstractAudioDeviceInfo_Adaptor *)cls)->cbs_isFormatSupported_c2509_0 (arg1));
}

static void _set_callback_cbs_isFormatSupported_c2509_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioDeviceInfo_Adaptor *)cls)->cb_isFormatSupported_c2509_0 = cb;
}


// exposed bool QAbstractAudioDeviceInfo::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QAbstractAudioDeviceInfo_Adaptor *)cls)->fp_QAbstractAudioDeviceInfo_isSignalConnected_c2394 (arg1));
}


// emitter void QAbstractAudioDeviceInfo::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QAbstractAudioDeviceInfo_Adaptor *)cls)->emitter_QAbstractAudioDeviceInfo_objectNameChanged_4567 (arg1);
}


// QAudioFormat QAbstractAudioDeviceInfo::preferredFormat()

static void _init_cbs_preferredFormat_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAudioFormat > ();
}

static void _call_cbs_preferredFormat_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAudioFormat > ((QAudioFormat)((QAbstractAudioDeviceInfo_Adaptor *)cls)->cbs_preferredFormat_c0_0 ());
}

static void _set_callback_cbs_preferredFormat_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioDeviceInfo_Adaptor *)cls)->cb_preferredFormat_c0_0 = cb;
}


// exposed int QAbstractAudioDeviceInfo::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QAbstractAudioDeviceInfo_Adaptor *)cls)->fp_QAbstractAudioDeviceInfo_receivers_c1731 (arg1));
}


// exposed QObject *QAbstractAudioDeviceInfo::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QAbstractAudioDeviceInfo_Adaptor *)cls)->fp_QAbstractAudioDeviceInfo_sender_c0 ());
}


// exposed int QAbstractAudioDeviceInfo::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractAudioDeviceInfo_Adaptor *)cls)->fp_QAbstractAudioDeviceInfo_senderSignalIndex_c0 ());
}


// QList<QAudioFormat::Endian> QAbstractAudioDeviceInfo::supportedByteOrders()

static void _init_cbs_supportedByteOrders_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QAudioFormat::Endian> > ();
}

static void _call_cbs_supportedByteOrders_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QAudioFormat::Endian> > ((QList<QAudioFormat::Endian>)((QAbstractAudioDeviceInfo_Adaptor *)cls)->cbs_supportedByteOrders_0_0 ());
}

static void _set_callback_cbs_supportedByteOrders_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioDeviceInfo_Adaptor *)cls)->cb_supportedByteOrders_0_0 = cb;
}


// QList<int> QAbstractAudioDeviceInfo::supportedChannelCounts()

static void _init_cbs_supportedChannelCounts_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<int> > ();
}

static void _call_cbs_supportedChannelCounts_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<int> > ((QList<int>)((QAbstractAudioDeviceInfo_Adaptor *)cls)->cbs_supportedChannelCounts_0_0 ());
}

static void _set_callback_cbs_supportedChannelCounts_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioDeviceInfo_Adaptor *)cls)->cb_supportedChannelCounts_0_0 = cb;
}


// QStringList QAbstractAudioDeviceInfo::supportedCodecs()

static void _init_cbs_supportedCodecs_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_cbs_supportedCodecs_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QAbstractAudioDeviceInfo_Adaptor *)cls)->cbs_supportedCodecs_0_0 ());
}

static void _set_callback_cbs_supportedCodecs_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioDeviceInfo_Adaptor *)cls)->cb_supportedCodecs_0_0 = cb;
}


// QList<int> QAbstractAudioDeviceInfo::supportedSampleRates()

static void _init_cbs_supportedSampleRates_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<int> > ();
}

static void _call_cbs_supportedSampleRates_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<int> > ((QList<int>)((QAbstractAudioDeviceInfo_Adaptor *)cls)->cbs_supportedSampleRates_0_0 ());
}

static void _set_callback_cbs_supportedSampleRates_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioDeviceInfo_Adaptor *)cls)->cb_supportedSampleRates_0_0 = cb;
}


// QList<int> QAbstractAudioDeviceInfo::supportedSampleSizes()

static void _init_cbs_supportedSampleSizes_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<int> > ();
}

static void _call_cbs_supportedSampleSizes_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<int> > ((QList<int>)((QAbstractAudioDeviceInfo_Adaptor *)cls)->cbs_supportedSampleSizes_0_0 ());
}

static void _set_callback_cbs_supportedSampleSizes_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioDeviceInfo_Adaptor *)cls)->cb_supportedSampleSizes_0_0 = cb;
}


// QList<QAudioFormat::SampleType> QAbstractAudioDeviceInfo::supportedSampleTypes()

static void _init_cbs_supportedSampleTypes_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QAudioFormat::SampleType> > ();
}

static void _call_cbs_supportedSampleTypes_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QAudioFormat::SampleType> > ((QList<QAudioFormat::SampleType>)((QAbstractAudioDeviceInfo_Adaptor *)cls)->cbs_supportedSampleTypes_0_0 ());
}

static void _set_callback_cbs_supportedSampleTypes_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioDeviceInfo_Adaptor *)cls)->cb_supportedSampleTypes_0_0 = cb;
}


// void QAbstractAudioDeviceInfo::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioDeviceInfo_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioDeviceInfo_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QAbstractAudioDeviceInfo> &qtdecl_QAbstractAudioDeviceInfo ();

static gsi::Methods methods_QAbstractAudioDeviceInfo_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAbstractAudioDeviceInfo::QAbstractAudioDeviceInfo()\nThis method creates an object of class QAbstractAudioDeviceInfo.", &_init_ctor_QAbstractAudioDeviceInfo_Adaptor_0, &_call_ctor_QAbstractAudioDeviceInfo_Adaptor_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QAbstractAudioDeviceInfo::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QAbstractAudioDeviceInfo::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QAbstractAudioDeviceInfo::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("deviceName", "@brief Virtual method QString QAbstractAudioDeviceInfo::deviceName()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_deviceName_c0_0, &_call_cbs_deviceName_c0_0);
  methods += new qt_gsi::GenericMethod ("deviceName", "@hide", true, &_init_cbs_deviceName_c0_0, &_call_cbs_deviceName_c0_0, &_set_callback_cbs_deviceName_c0_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QAbstractAudioDeviceInfo::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QAbstractAudioDeviceInfo::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QAbstractAudioDeviceInfo::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("isFormatSupported", "@brief Virtual method bool QAbstractAudioDeviceInfo::isFormatSupported(const QAudioFormat &format)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isFormatSupported_c2509_0, &_call_cbs_isFormatSupported_c2509_0);
  methods += new qt_gsi::GenericMethod ("isFormatSupported", "@hide", true, &_init_cbs_isFormatSupported_c2509_0, &_call_cbs_isFormatSupported_c2509_0, &_set_callback_cbs_isFormatSupported_c2509_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QAbstractAudioDeviceInfo::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QAbstractAudioDeviceInfo::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("preferredFormat", "@brief Virtual method QAudioFormat QAbstractAudioDeviceInfo::preferredFormat()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_preferredFormat_c0_0, &_call_cbs_preferredFormat_c0_0);
  methods += new qt_gsi::GenericMethod ("preferredFormat", "@hide", true, &_init_cbs_preferredFormat_c0_0, &_call_cbs_preferredFormat_c0_0, &_set_callback_cbs_preferredFormat_c0_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QAbstractAudioDeviceInfo::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QAbstractAudioDeviceInfo::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QAbstractAudioDeviceInfo::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("supportedByteOrders", "@brief Virtual method QList<QAudioFormat::Endian> QAbstractAudioDeviceInfo::supportedByteOrders()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_supportedByteOrders_0_0, &_call_cbs_supportedByteOrders_0_0);
  methods += new qt_gsi::GenericMethod ("supportedByteOrders", "@hide", false, &_init_cbs_supportedByteOrders_0_0, &_call_cbs_supportedByteOrders_0_0, &_set_callback_cbs_supportedByteOrders_0_0);
  methods += new qt_gsi::GenericMethod ("supportedChannelCounts", "@brief Virtual method QList<int> QAbstractAudioDeviceInfo::supportedChannelCounts()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_supportedChannelCounts_0_0, &_call_cbs_supportedChannelCounts_0_0);
  methods += new qt_gsi::GenericMethod ("supportedChannelCounts", "@hide", false, &_init_cbs_supportedChannelCounts_0_0, &_call_cbs_supportedChannelCounts_0_0, &_set_callback_cbs_supportedChannelCounts_0_0);
  methods += new qt_gsi::GenericMethod ("supportedCodecs", "@brief Virtual method QStringList QAbstractAudioDeviceInfo::supportedCodecs()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_supportedCodecs_0_0, &_call_cbs_supportedCodecs_0_0);
  methods += new qt_gsi::GenericMethod ("supportedCodecs", "@hide", false, &_init_cbs_supportedCodecs_0_0, &_call_cbs_supportedCodecs_0_0, &_set_callback_cbs_supportedCodecs_0_0);
  methods += new qt_gsi::GenericMethod ("supportedSampleRates", "@brief Virtual method QList<int> QAbstractAudioDeviceInfo::supportedSampleRates()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_supportedSampleRates_0_0, &_call_cbs_supportedSampleRates_0_0);
  methods += new qt_gsi::GenericMethod ("supportedSampleRates", "@hide", false, &_init_cbs_supportedSampleRates_0_0, &_call_cbs_supportedSampleRates_0_0, &_set_callback_cbs_supportedSampleRates_0_0);
  methods += new qt_gsi::GenericMethod ("supportedSampleSizes", "@brief Virtual method QList<int> QAbstractAudioDeviceInfo::supportedSampleSizes()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_supportedSampleSizes_0_0, &_call_cbs_supportedSampleSizes_0_0);
  methods += new qt_gsi::GenericMethod ("supportedSampleSizes", "@hide", false, &_init_cbs_supportedSampleSizes_0_0, &_call_cbs_supportedSampleSizes_0_0, &_set_callback_cbs_supportedSampleSizes_0_0);
  methods += new qt_gsi::GenericMethod ("supportedSampleTypes", "@brief Virtual method QList<QAudioFormat::SampleType> QAbstractAudioDeviceInfo::supportedSampleTypes()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_supportedSampleTypes_0_0, &_call_cbs_supportedSampleTypes_0_0);
  methods += new qt_gsi::GenericMethod ("supportedSampleTypes", "@hide", false, &_init_cbs_supportedSampleTypes_0_0, &_call_cbs_supportedSampleTypes_0_0, &_set_callback_cbs_supportedSampleTypes_0_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QAbstractAudioDeviceInfo::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QAbstractAudioDeviceInfo_Adaptor> decl_QAbstractAudioDeviceInfo_Adaptor (qtdecl_QAbstractAudioDeviceInfo (), "QtMultimedia", "QAbstractAudioDeviceInfo",
  methods_QAbstractAudioDeviceInfo_Adaptor (),
  "@qt\n@brief Binding of QAbstractAudioDeviceInfo");

}

