# Model class API

In the functional API, given some input tensor(s) and output tensor(s), you can instantiate a `Model` via:

```python
from keras.models import Model
from keras.layers import Input, Dense

a = Input(shape=(32,))
b = Dense(32)(a)
model = Model(inputs=a, outputs=b)
```

This model will include all layers required in the computation of `b` given `a`.

In the case of multi-input or multi-output models, you can use lists as well:

```python
model = Model(inputs=[a1, a2], outputs=[b1, b2, b3])
```

For a detailed introduction of what `Model` can do, read [this guide to the Keras functional API](/getting-started/functional-api-guide).


## Methods

{{autogenerated}}
