/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.validation.expression;

import java.util.List;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.Expression;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.VariableResolver;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.controller.ParameterName;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.util.bean.BeanUtil;
import net.sourceforge.stripes.validation.ScopedLocalizableError;
import net.sourceforge.stripes.validation.ValidationErrors;
import net.sourceforge.stripes.validation.ValidationMetadata;
import net.sourceforge.stripes.validation.expression.ExpressionExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExpressionExecutorSupport
implements ExpressionExecutor {
    private static final Log log = Log.getInstance(ExpressionExecutorSupport.class);

    @Override
    public void evaluate(ActionBean bean, ParameterName name, List<Object> values, ValidationMetadata validationInfo, ValidationErrors errors) {
        Expression expr = null;
        BeanVariableResolver resolver = null;
        if (validationInfo.expression() != null) {
            try {
                ExpressionEvaluator evaluator = this.getEvaluator();
                if (evaluator == null) {
                    return;
                }
                String expression = validationInfo.expression();
                expr = evaluator.parseExpression(expression, Boolean.class, null);
                resolver = new BeanVariableResolver(bean);
            }
            catch (ELException ele) {
                throw new StripesRuntimeException("Could not parse the EL expression being used to validate field " + name.getName() + ". This is not a transient error. Please double " + "check the following expression for errors: " + validationInfo.expression(), ele);
            }
        }
        for (Object value : values) {
            if (expr == null) continue;
            try {
                resolver.setCurrentValue(value);
                Boolean result = (Boolean)expr.evaluate((VariableResolver)resolver);
                if (Boolean.TRUE.equals(result)) continue;
                ScopedLocalizableError error = new ScopedLocalizableError("validation.expression", "valueFailedExpression", new Object[0]);
                error.setFieldValue(String.valueOf(value));
                errors.add(name.getName(), error);
            }
            catch (ELException ele) {
                log.error("Error evaluating expression for property ", name.getName(), " of class ", bean.getClass().getSimpleName(), ". Expression: ", validationInfo.expression());
            }
        }
    }

    protected abstract ExpressionEvaluator getEvaluator();

    protected static class BeanVariableResolver
    implements VariableResolver {
        private ActionBean bean;
        private Object currentValue;

        BeanVariableResolver(ActionBean bean) {
            this.bean = bean;
        }

        void setCurrentValue(Object value) {
            this.currentValue = value;
        }

        public Object resolveVariable(String property) throws ELException {
            if ("this".equals(property)) {
                return this.currentValue;
            }
            if ("actionBean".equals(property)) {
                return this.bean;
            }
            try {
                return BeanUtil.getPropertyValue(property, this.bean);
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

