/*
 * Copyright 1999-2006 University of Chicago
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.globus.ftp.vanilla;


/**
   Basic subset of server side control channel functionality.
   Using this class, local server can send replies but not receive
   commands.
 **/
public interface BasicServerControlChannel{

    /**
       write reply to the control channel
     **/
    public void write(Reply reply);
    /**
       @return number of replies sent so far
     **/
    public int getReplyCount();
    /**
       set reply count to 0. If this function is used consequently
       at the beginning of each transfer,
       then reply count will always indicate number of messages
       of last transfer.
     **/
    public void resetReplyCount();
} //BasicServerControlChannel



