/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.console.manager.interfaces;

/**
 * Information about a specific node in the tree-browser
 *
 * @see org.jboss.console.manager.interfaces.TreeInfo
 *
 * @author  <a href="mailto:sacha.labourey@cogito-info.ch">Sacha Labourey</a>.
 * @version $Revision: 57191 $
 *
 * <p><b>Revisions:</b>
 *
 * <p><b>14 decembre 2002 Sacha Labourey:</b>
 * <ul>
 * <li> First implementation </li>
 * </ul>
 */

public interface TreeNode
   extends java.io.Serializable
{
   public String getName ();
   public String getDescription ();
   
   public String getIcon ();
   
   public TreeAction getAction ();
   
   public TreeNodeMenuEntry[] getMenuEntries ();
   
   public TreeNode[] getSubNodes ();

   public ResourceTreeNode[] getNodeManagableResources ();
   
   /**
    * indicates if, in the presence of several nodes fighting for
    * the same ResourceTreeNode in mode INVISIBLE_IF_SUBNODE_EXISTS,
    * this node is master and other nodes (if any) will go as sub-nodes
    * of this one
    */
   public boolean isMasterNode ();
      
}
