.\"                                      Hey, EMACS: -*- nroff -*-
.TH XYACC "1" "June 2021" "IRAF 2.17" "IRAF commands"
.\" Please adjust this date whenever revising the manpage.
.SH NAME
xyacc \- SPP modified yacc compiler compiler [IRAF]
.SH SYNOPSIS
.B xyacc
.RI [ options ] " file"

.SH OPTIONS
.TP
.B -b \fIfile_prefix\fR
Specify a file_prefix for output files
.TP
.B -d
Also produce a header file \fBy.tab.h\fR.
.TP
.B -l
Don't generate '#line' directives
.TP
.B -p \fIsym_prefix\fR
Prepend sym_prefix to the external symbols
.TP
.B -P \fIparser\fR
Specify parser file (default \fBboot$xyacc/yaccpar.x\fR)
.TP
.B -Q\fI(y/n)\fR
Flag for version stamping. The \fB-Qy\fR option puts the version
stamping information in \fBy.tab.c\fR. This allows you to know what
version of yacc built the file. The \fB-Qn\fR option (the default)
writes no version information.
.TP
.B -t
Compiles runtime debugging code by default.
.TP
.B -v
Prepares the file \fBy.output\fR, which contains a description of the
parsing tables and a report on conflicts generated by ambiguities in
the grammar.
.TP
.B -V
Output version information and exit
.TP
.B -Y \fIdir\fR
Specify location of \fByaccpar.x\fR (default \fBboot$xyacc\fR).
.SH DESCRIPTION
The yacc command converts a context-free grammar into a set of tables
for a simple automaton that executes an LALR(1) parsing algorithm. The
grammar can be ambiguous. Specified precedence rules are used to break
ambiguities.
.sp
This is a version of yacc that has been modified to produce SPP
language parsers.  For the most part, it should follow the operation
of standard yacc, with the differences noted below.
.sp
Input files should follow the yacc convention of ending in .y.
.SH DIFFERENCES
.TP
.B (1) 
The Yacc input syntax is unmodified, except that the comment
convention is now as in SPP, rather than C (i.e., use #, rather than
/*..*/).  All defines, actions, etc. are of course given in the SPP
language.
.TP
.B (2) 
The Yacc output file is "ytab.x", rather than "y.tab.c".  The token
defs file "y.tab.h" now contains SPP defines, rather than C #defines.
The states file "y.output" is completely unmodified.
.TP
.B (3) 
The global declarations section %{ .. %} had to be changed somewhat
because SPP does not have global variables.  The section is now
divided into two subsections.  The first is for global defines,
includes, etc. which go into the header area of the ytab.x file.  Then
follows a %L, telling Yacc that the local declarations for the parser
procedure follow.  This second section should contain variable and
function declarations required for the user supplied actions (code
fragments to be executed when a rule of the grammar is recognized) in
the yyparse procedure.
.TP
.B (4) 
The global declarations section MUST contain the following two
defines:
.sp
.B YYMAXDEPTH
Depth of the parser stacks; determines the maximum complexity of a
language construct which can be parsed.  A typical value is 150.
.sp
.B YYOPLEN
The length, in struct units, of a token operand value structure.  You
define the operand structure to be whatever you wish; all the parser
needs to know is how big an element is.  The lexical analyzer and the
actions, both of which are supplied by the user, use the operand
structure for communications.  Operand structures are always referred
to by a Mem pointer.

.SH SEE ALSO
.BR yacc (1),
.BR xpp (1),
.BR rpp (1).
.SH AUTHOR
This manual page was written by Zed Pobre <zed@debian.org>, for the
Debian GNU/Linux system (but may be used by others).  It includes text
from the README file for xyacc in the IRAF sources.
