/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2012 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IGGDIALOGSCRIPTDEBUGGER_H
#define IGGDIALOGSCRIPTDEBUGGER_H


#include "iggmenuwindow.h"
#include "iscript.h"


#include "istring.h"

class iAnimator;

class iggDialog;
class iggDialogScriptDebuggerEditor;
class iggFrame;
class iggFrameTopParent;
class iggWidgetListView;
class iggWidgetSimpleButton;
class iggWidgetTextEditor;

class vtkTimerLog;


class iggDialogScriptDebugger : public iggMenuWindow, public iScriptObserver
{

public:

	iggDialogScriptDebugger(iggMainWindow *parent);
	virtual ~iggDialogScriptDebugger();

	virtual void Show(bool s);
	virtual void OnMenuBody(int id, bool on);

	inline iAnimator* GetAnimator();
	void Debug(bool s);

	void SetRunState(int n);
	inline int GetRunState() const { return mRunState; }

	void SetDelayTime(float v){ mDelayTime = v; }
	void SetDebugFlag(int f);

protected:

	bool ImmediateConstruction() const; 
	void CompleteConstruction();
	virtual void CompleteConstructionBody();

	virtual void UpdateContents();

	virtual void OnScriptStartBody();
	virtual void OnScriptStopBody(const iString &error);
	virtual void OnScriptBeginLineBody(int line, const iString &text);
	virtual void OnScriptEndLineBody(int line, const iString &text);
	virtual bool OnScriptCheckAbortBody(int cur, int num, int level);

	bool CheckSyntax(bool silent);
	void BuildMenus();
	void LoadFromFile(const iString &fn);
	void SaveToFile(const iString &fn);
	void SetContents(const iString &text);
	void CheckModified();
	void UpdateButtons();
	void UpdateVariables();

	iggFrame *mDebugFrame;
	iggDialogScriptDebuggerEditor *mEditor;
	iggWidgetListView *mVarView;
	iggDialog *mFindDialog;

	bool mCompleteConstructionCalled;
	int mRunState, mCurIter, mNumIter, mDebugFlag;
	float mDelayTime;
	bool mDebugging, mAllowFrameStep, mInsideALine, mFirstShow;
	iString mCurrentFileName;
	iAnimator *mCurrentAnimator;
	vtkTimerLog *mTimer;
	iggWidgetSimpleButton *mControlButtons[4];
};

#endif  //  IGGDIALOGSCRIPTDEBUGGER_H
