/***************************************************************************
 *   Copyright (C) 2004-2006 by Jim Campbell                               *
 *   ifpgui@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef IOINTERFACE_H
#define IOINTERFACE_H

#include <QString>
#include "gui_user.h"

/** Successful return code. */
#define IO_INTF_OK           0
/**< A user callback requested the transfer be cancelled. */
#define IO_INTF_USER_CANCEL 11

/** File 'type'. */
#define IO_INTF_FILE         0x01 //1001
/** Dir 'type'. */
#define IO_INTF_DIR          0x02 //1002
/** Symbolic Link 'type'. */
#define IO_INTF_SYMLINK      0x03 //1003
/** Special 'type'. */
#define IO_INTF_SPECIAL      0x04 //1004
/** Locked Dir 'type'. */
#define IO_INTF_DIR_LOCKED   0x05 //1005


/**
 * Types of I/O Interfaces.  Define one for each type.
 * if you add new types you will also need to add to the
 * case statement in fileviewer.cpp
 */
#define IO_INTF_TYPE_LOCAL   0
#define IO_INTF_TYPE_IFP     1


class IOInterface
{
private:
protected:
    int internal_exec_TransferToiFP(QString& remoteDest, QList<FileInfos> *local_file_list);
    int internal_exec_TransferFromiFP(QString& localDest, QList<FileInfos> *remote_file_list);
    QString internal_get_ProtocolStr(QString& fileName);
    int internal_remove_ProtocolStr(QString& fileName);
    int internal_norm_ProtocolStr(QString& fileName, QString protoStr);
    QString lastErrString;
    int interfaceType;
    bool processingFiles;
public:
    IOInterface() {};
    virtual ~IOInterface() {};

    virtual int exec_TransferUpload(QString& destination, QList<FileInfos> *file_info_list) = 0;
    virtual int exec_TransferDownload(QString& destination, QList<FileInfos> *file_info_list) = 0;
    virtual int exec_Mkdir(QString& baseDir, QString& newDir) = 0;
    virtual int exec_Rename(const QString& oldName, const QString& newName) = 0;
    virtual int exec_Delete(QList<FileInfos> *file_info_list) = 0;
    virtual int exec_ShowProperties(const QString& fileName) = 0;
    virtual int exec_GetDirectoryListing(QString dirName, QList<FileInfos> *file_info_list) = 0;
    virtual bool get_isReadable(QString& dirName) = 0;
    virtual QString get_LastError() = 0;
    bool isProcessing() {return (processingFiles);};
    bool isAudioFileType(const QString& fileName)
    {
        QString ext;
        ext = fileName.right(4);
        if ((ext == ".aac") ||      // Advanced Audio Coding File
            (ext == ".aif") ||       // Audio Interchange File Format
            (ext == ".iff") ||       // Interchange File Format
            //(ext == ".m3u") ||       // Media Playlist File
            (ext == ".mid") ||       // MIDI File
            (ext == ".midi") ||      // MIDI File
            (ext == ".mp3") ||       // MP3 Audio File
            (ext == ".mpa") ||       // MPEG-2 Audio File
            (ext == ".ra") ||        // Real Audio File
            (ext == ".wav") ||       // WAVE Audio File
            (ext == ".wma"))         // Windows Media Audio File
        {
            return true;
        }
        return false;
    }
    QString ProtocolType; // examples (file:  ifp:  ftp:)

};



class FileInterface : public IOInterface
{
private:
public:
    FileInterface()
    {
        interfaceType = IO_INTF_TYPE_LOCAL;
        ProtocolType  = "file://";
    };
    ~FileInterface() {};

    int exec_TransferUpload(QString& destination, QList<FileInfos> *file_info_list);
    int exec_TransferDownload(QString& destination, QList<FileInfos> *file_info_list);
    int exec_Mkdir(QString& baseDir, QString& newDir);
    int exec_Rename(const QString& oldName, const QString& newName);
    int exec_Delete(QList<FileInfos> *file_info_list);
    int exec_ShowProperties(const QString& fileName);
    int exec_GetDirectoryListing(QString dirName, QList<FileInfos> *file_info_list);
    bool get_isReadable(QString& dirName);
    QString get_LastError();
};



class iFPInterface : public IOInterface
{
private:
    int ifp_connect(bool showError);
public:
    iFPInterface()
    {
        interfaceType = IO_INTF_TYPE_IFP;
        ProtocolType  = "ifp://";
    };
    virtual ~iFPInterface() {};

    int exec_TransferUpload(QString& destination, QList<FileInfos> *file_info_list);
    int exec_TransferDownload(QString& destination, QList<FileInfos> *file_info_list);
    int exec_Mkdir(QString& baseDir, QString& newDir);
    int exec_Rename(const QString& oldName, const QString& newName);
    int exec_Delete(QList<FileInfos> *file_info_list);
    int exec_ShowProperties(const QString& fileName);
    int exec_GetDirectoryListing(QString dirName, QList<FileInfos> *file_info_list);
    bool get_isReadable(QString& dirName);
    QString get_LastError();
};

#endif

