#!/usr/bin/env python
# vim:fileencoding=utf-8
# License: Apache 2.0 Copyright: 2017, Kovid Goyal <kovid at kovidgoyal.net>

from __future__ import absolute_import, division, print_function, unicode_literals

import json
import os

try:
    from urllib.request import urlopen
except ImportError:
    from urllib import urlopen

self_path = os.path.abspath(__file__)
HEADER = '''\
# Do not edit
# Generated by genencodings.py

encodings = {
'''


def get_data(url='https://encoding.spec.whatwg.org/encodings.json'):
    return json.loads(urlopen(url).read().decode('ascii'))


def get_mapping(data):
    for category in data:
        for encoding in category['encodings']:
            name = encoding['name'].lower()
            for label in encoding['labels']:
                yield label.lower(), name


def main():
    os.chdir(os.path.dirname(self_path))
    data = get_data()
    ans = dict(get_mapping(data))
    keys = sorted(ans)
    lines = ['  "%s": "%s",' % (k, ans[k]) for k in keys] + ['}']
    with open('src/html5_parser/encoding_names.py', 'wb') as f:
        f.write(HEADER.encode('ascii'))
        f.write('\n'.join(lines).encode('ascii'))


if __name__ == '__main__':
    main()
