{- This module was generated from data in the Kate syntax
   highlighting file xul.xml, version 1, by Wilbert Berendsen (wilbert@kde.nl), Anders Lund (anders@alweb.dk), Joseph Wenninger (jowenn@kde.org), Whitehawk Stormchaser (zerokode@gmx.net), Marc Dassonneville (marc.dassonneville@gmail.com) -}

module Text.Highlighting.Kate.Syntax.Xul
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "XUL"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.xul;*.xbl"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("XUL","Start")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStContinuation = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  st <- getState
  if length contexts >= 2
    then case context of
      _ | synStContinuation st -> updateState $ \st -> st{ synStContinuation = False }
      ("XUL","Start") -> return ()
      ("XUL","FindXML") -> return ()
      ("XUL","FindEntityRefs") -> return ()
      ("XUL","FindPEntityRefs") -> return ()
      ("XUL","Comment") -> return ()
      ("XUL","PI") -> return ()
      ("XUL","Doctype") -> return ()
      ("XUL","Doctype Internal Subset") -> return ()
      ("XUL","Doctype Markupdecl") -> return ()
      ("XUL","Doctype Markupdecl DQ") -> return ()
      ("XUL","Doctype Markupdecl SQ") -> return ()
      ("XUL","Element") -> return ()
      ("XUL","El Content") -> return ()
      ("XUL","El End") -> return ()
      ("XUL","Attribute") -> return ()
      ("XUL","Value") -> return ()
      ("XUL","Value DQ") -> return ()
      ("XUL","Value SQ") -> return ()
      ("XUL","CDATA") -> return ()
      ("XUL","String") -> (popContext) >> pEndLine
      ("XUL","String 1") -> (popContext) >> pEndLine
      ("XUL","JSComment") -> (popContext) >> pEndLine
      ("XUL","Multi/inline Comment") -> return ()
      ("XUL","Regular Expression") -> return ()
      ("XUL","(Internal regex catch)") -> return ()
      ("XUL","Regular Expression Character Class") -> return ()
      ("XUL","(regex caret first check)") -> (popContext) >> pEndLine
      ("XUL","(charclass caret first check)") -> (popContext) >> pEndLine
      ("XUL","region_marker") -> (popContext) >> pEndLine
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_keywords = Set.fromList $ words $ "if else for in while do continue break with try catch finally switch case new var function return delete true false void throw typeof const default"
list_functions = Set.fromList $ words $ "escape isFinite isNaN Number parseFloat parseInt reload taint unescape untaint write"
list_objects = Set.fromList $ words $ "Anchor Applet Area Array Boolean Button Checkbox Date document window Image FileUpload Form Frame Function Hidden Link MimeType Math Max Min Layer navigator Object Password Plugin Radio RegExp Reset Screen Select String Text Textarea this Window"
list_math = Set.fromList $ words $ "abs acos asin atan atan2 ceil cos ctg E exp floor LN2 LN10 log LOG2E LOG10E PI pow round sin sqrt SQRT1_2 SQRT2 tan"
list_events = Set.fromList $ words $ "onAbort onBlur onChange onClick onError onFocus onLoad onMouseOut onMouseOver onReset onSelect onSubmit onUnload"
list_methods = Set.fromList $ words $ "above action alinkColor alert anchor anchors appCodeName applets apply appName appVersion argument arguments arity availHeight availWidth back background below bgColor border big blink blur bold border call caller charAt charCodeAt checked clearInterval clearTimeout click clip close closed colorDepth complete compile constructor confirm cookie current cursor data defaultChecked defaultSelected defaultStatus defaultValue description disableExternalCapture domain elements embeds enabledPlugin enableExternalCapture encoding eval exec fgColor filename find fixed focus fontcolor fontsize form forms formName forward frames fromCharCode getDate getDay getHours getMiliseconds getMinutes getMonth getSeconds getSelection getTime getTimezoneOffset getUTCDate getUTCDay getUTCFullYear getUTCHours getUTCMilliseconds getUTCMinutes getUTCMonth getUTCSeconds getYear global go hash height history home host hostname href hspace ignoreCase images index indexOf innerHeight innerWidth input italics javaEnabled join language lastIndex lastIndexOf lastModified lastParen layers layerX layerY left leftContext length link linkColor links location locationbar load lowsrc match MAX_VALUE menubar method mimeTypes MIN_VALUE modifiers moveAbove moveBelow moveBy moveTo moveToAbsolute multiline name NaN NEGATIVE_INFINITY negative_infinity next open opener options outerHeight outerWidth pageX pageY pageXoffset pageYoffset parent parse pathname personalbar pixelDepth platform plugins pop port POSITIVE_INFINITY positive_infinity preference previous print prompt protocol prototype push referrer refresh releaseEvents reload replace reset resizeBy resizeTo reverse rightContext screenX screenY scroll scrollbar scrollBy scrollTo search select selected selectedIndex self setDate setHours setMinutes setMonth setSeconds setTime setTimeout setUTCDate setUTCDay setUTCFullYear setUTCHours setUTCMilliseconds setUTCMinutes setUTCMonth setUTCSeconds setYear shift siblingAbove siblingBelow small sort source splice split src status statusbar strike sub submit substr substring suffixes sup taintEnabled target test text title toGMTString toLocaleString toLowerCase toolbar toSource toString top toUpperCase toUTCString type URL unshift unwatch userAgent UTC value valueOf visibility vlinkColor vspace width watch which width write writeln x y zIndex"

regex_'3c'21DOCTYPE'5cs'2b = compileRegex True "<!DOCTYPE\\s+"
regex_'3c'5c'3f'5b'5cw'3a'5f'2d'5d'2a = compileRegex True "<\\?[\\w:_-]*"
regex_'3c'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a = compileRegex True "<[A-Za-z_:][\\w.:_-]*"
regex_'26'28'23'5b0'2d9'5d'2b'7c'23'5bxX'5d'5b0'2d9A'2dFa'2df'5d'2b'7c'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'29'3b = compileRegex True "&(#[0-9]+|#[xX][0-9A-Fa-f]+|[A-Za-z_:][\\w.:_-]*);"
regex_'25'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'3b = compileRegex True "%[A-Za-z_:][\\w.:_-]*;"
regex_'2d'28'2d'28'3f'21'2d'3e'29'29'2b = compileRegex True "-(-(?!->))+"
regex_'3c'21'28ELEMENT'7cENTITY'7cATTLIST'7cNOTATION'29'5cb = compileRegex True "<!(ELEMENT|ENTITY|ATTLIST|NOTATION)\\b"
regex_'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a = compileRegex True "[A-Za-z_:][\\w.:_-]*"
regex_'5cs'2b'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a = compileRegex True "\\s+[A-Za-z_:][\\w.:_-]*"
regex_'5cS = compileRegex True "\\S"
regex_'3c'2f'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a = compileRegex True "</[A-Za-z_:][\\w.:_-]*"
regex_'5b'3d'3f'3a'5d = compileRegex True "[=?:]"
regex_'5c'28 = compileRegex True "\\("
regex_'2f'5big'5d'7b0'2c2'7d = compileRegex True "/[ig]{0,2}"
regex_'5c'7b'5b'5cd'2c_'5d'2b'5c'7d = compileRegex True "\\{[\\d, ]+\\}"
regex_'5c'5c'5bbB'5d = compileRegex True "\\\\[bB]"
regex_'5c'5c'5bnrtvfDdSsWw'5d = compileRegex True "\\\\[nrtvfDdSsWw]"
regex_'5c'5c'2e = compileRegex True "\\\\."
regex_'5c'24'28'3f'3d'2f'29 = compileRegex True "\\$(?=/)"
regex_'5cs'2a = compileRegex True "\\s*"
regex_'2f'2f'28'3f'3d'3b'29 = compileRegex True "//(?=;)"
regex_'5c'5c'5b'5c'5b'5c'5d'5d = compileRegex True "\\\\[\\[\\]]"

parseRules ("XUL","Start") =
  (((parseRules ("XUL","FindXML")))
   <|>
   (currentContext >>= \x -> guard (x == ("XUL","Start")) >> pDefault >>= withAttribute NormalTok))

parseRules ("XUL","FindXML") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pString False "<!--" >>= withAttribute CommentTok) >>~ pushContext ("XUL","Comment"))
   <|>
   ((pString False "<![CDATA[" >>= withAttribute BaseNTok) >>~ pushContext ("XUL","CDATA"))
   <|>
   ((pRegExpr regex_'3c'21DOCTYPE'5cs'2b >>= withAttribute DataTypeTok) >>~ pushContext ("XUL","Doctype"))
   <|>
   ((pRegExpr regex_'3c'5c'3f'5b'5cw'3a'5f'2d'5d'2a >>= withAttribute KeywordTok) >>~ pushContext ("XUL","PI"))
   <|>
   ((pRegExpr regex_'3c'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a >>= withAttribute KeywordTok) >>~ pushContext ("XUL","Element"))
   <|>
   ((parseRules ("XUL","FindEntityRefs")))
   <|>
   ((pDetectIdentifier >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("XUL","FindXML")) >> pDefault >>= withAttribute NormalTok))

parseRules ("XUL","FindEntityRefs") =
  (((pRegExpr regex_'26'28'23'5b0'2d9'5d'2b'7c'23'5bxX'5d'5b0'2d9A'2dFa'2df'5d'2b'7c'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'29'3b >>= withAttribute DecValTok))
   <|>
   ((pAnyChar "&<" >>= withAttribute ErrorTok))
   <|>
   (currentContext >>= \x -> guard (x == ("XUL","FindEntityRefs")) >> pDefault >>= withAttribute NormalTok))

parseRules ("XUL","FindPEntityRefs") =
  (((pRegExpr regex_'26'28'23'5b0'2d9'5d'2b'7c'23'5bxX'5d'5b0'2d9A'2dFa'2df'5d'2b'7c'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'29'3b >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'25'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'3b >>= withAttribute DecValTok))
   <|>
   ((pAnyChar "&%" >>= withAttribute ErrorTok))
   <|>
   (currentContext >>= \x -> guard (x == ("XUL","FindPEntityRefs")) >> pDefault >>= withAttribute NormalTok))

parseRules ("XUL","Comment") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pString False "-->" >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'2d'28'2d'28'3f'21'2d'3e'29'29'2b >>= withAttribute ErrorTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   (currentContext >>= \x -> guard (x == ("XUL","Comment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("XUL","PI") =
  (((pDetect2Chars False '?' '>' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("XUL","PI")) >> pDefault >>= withAttribute NormalTok))

parseRules ("XUL","Doctype") =
  (((pDetectChar False '>' >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   ((pDetectChar False '[' >>= withAttribute DataTypeTok) >>~ pushContext ("XUL","Doctype Internal Subset"))
   <|>
   (currentContext >>= \x -> guard (x == ("XUL","Doctype")) >> pDefault >>= withAttribute NormalTok))

parseRules ("XUL","Doctype Internal Subset") =
  (((pDetectChar False ']' >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'3c'21'28ELEMENT'7cENTITY'7cATTLIST'7cNOTATION'29'5cb >>= withAttribute DataTypeTok) >>~ pushContext ("XUL","Doctype Markupdecl"))
   <|>
   ((pString False "<!--" >>= withAttribute CommentTok) >>~ pushContext ("XUL","Comment"))
   <|>
   ((pRegExpr regex_'3c'5c'3f'5b'5cw'3a'5f'2d'5d'2a >>= withAttribute KeywordTok) >>~ pushContext ("XUL","PI"))
   <|>
   ((parseRules ("XUL","FindPEntityRefs")))
   <|>
   (currentContext >>= \x -> guard (x == ("XUL","Doctype Internal Subset")) >> pDefault >>= withAttribute NormalTok))

parseRules ("XUL","Doctype Markupdecl") =
  (((pDetectChar False '>' >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("XUL","Doctype Markupdecl DQ"))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext ("XUL","Doctype Markupdecl SQ"))
   <|>
   (currentContext >>= \x -> guard (x == ("XUL","Doctype Markupdecl")) >> pDefault >>= withAttribute NormalTok))

parseRules ("XUL","Doctype Markupdecl DQ") =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((parseRules ("XUL","FindPEntityRefs")))
   <|>
   (currentContext >>= \x -> guard (x == ("XUL","Doctype Markupdecl DQ")) >> pDefault >>= withAttribute StringTok))

parseRules ("XUL","Doctype Markupdecl SQ") =
  (((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((parseRules ("XUL","FindPEntityRefs")))
   <|>
   (currentContext >>= \x -> guard (x == ("XUL","Doctype Markupdecl SQ")) >> pDefault >>= withAttribute StringTok))

parseRules ("XUL","Element") =
  (((pDetect2Chars False '/' '>' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pDetectChar False '>' >>= withAttribute KeywordTok) >>~ pushContext ("XUL","El Content"))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a >>= withAttribute OtherTok) >>~ pushContext ("XUL","Attribute"))
   <|>
   ((pRegExpr regex_'5cs'2b'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a >>= withAttribute OtherTok) >>~ pushContext ("XUL","Attribute"))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute ErrorTok))
   <|>
   (currentContext >>= \x -> guard (x == ("XUL","Element")) >> pDefault >>= withAttribute NormalTok))

parseRules ("XUL","El Content") =
  (((pRegExpr regex_'3c'2f'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a >>= withAttribute KeywordTok) >>~ pushContext ("XUL","El End"))
   <|>
   ((parseRules ("XUL","FindXML")))
   <|>
   (currentContext >>= \x -> guard (x == ("XUL","El Content")) >> pDefault >>= withAttribute NormalTok))

parseRules ("XUL","El End") =
  (((pDetectChar False '>' >>= withAttribute KeywordTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute ErrorTok))
   <|>
   (currentContext >>= \x -> guard (x == ("XUL","El End")) >> pDefault >>= withAttribute NormalTok))

parseRules ("XUL","Attribute") =
  (((pDetectChar False '=' >>= withAttribute OtherTok) >>~ pushContext ("XUL","Value"))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute ErrorTok))
   <|>
   (currentContext >>= \x -> guard (x == ("XUL","Attribute")) >> pDefault >>= withAttribute NormalTok))

parseRules ("XUL","Value") =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("XUL","Value DQ"))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext ("XUL","Value SQ"))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute ErrorTok))
   <|>
   (currentContext >>= \x -> guard (x == ("XUL","Value")) >> pDefault >>= withAttribute NormalTok))

parseRules ("XUL","Value DQ") =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((parseRules ("XUL","FindEntityRefs")))
   <|>
   (currentContext >>= \x -> guard (x == ("XUL","Value DQ")) >> pDefault >>= withAttribute StringTok))

parseRules ("XUL","Value SQ") =
  (((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((parseRules ("XUL","FindEntityRefs")))
   <|>
   (currentContext >>= \x -> guard (x == ("XUL","Value SQ")) >> pDefault >>= withAttribute StringTok))

parseRules ("XUL","CDATA") =
  (((pString False "]]>" >>= withAttribute BaseNTok) >>~ (popContext))
   <|>
   ((pString False "]]&gt;" >>= withAttribute DecValTok))
   <|>
   ((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pString False "//BEGIN" >>= withAttribute RegionMarkerTok) >>~ pushContext ("XUL","region_marker"))
   <|>
   ((pString False "//END" >>= withAttribute RegionMarkerTok) >>~ pushContext ("XUL","region_marker"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_functions >>= withAttribute FunctionTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_objects >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_math >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_events >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_methods >>= withAttribute DataTypeTok))
   <|>
   ((pDetectIdentifier >>= withAttribute NormalTok))
   <|>
   ((pFloat >>= withAttribute FloatTok))
   <|>
   ((pInt >>= withAttribute DecValTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("XUL","String"))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext ("XUL","String 1"))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("XUL","JSComment"))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("XUL","Multi/inline Comment"))
   <|>
   ((pRegExpr regex_'5b'3d'3f'3a'5d >>= withAttribute NormalTok) >>~ pushContext ("XUL","(Internal regex catch)"))
   <|>
   ((pRegExpr regex_'5c'28 >>= withAttribute NormalTok) >>~ pushContext ("XUL","(Internal regex catch)"))
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok))
   <|>
   ((pAnyChar ":!%&+,-/.*<=>?[]|~^;" >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("XUL","CDATA")) >> pDefault >>= withAttribute NormalTok))

parseRules ("XUL","String") =
  (((pDetectIdentifier >>= withAttribute StringTok))
   <|>
   ((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("XUL","String")) >> pDefault >>= withAttribute StringTok))

parseRules ("XUL","String 1") =
  (((pDetectIdentifier >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("XUL","String"))
   <|>
   ((pDetectChar False '\'' >>= withAttribute CharTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("XUL","String 1")) >> pDefault >>= withAttribute CharTok))

parseRules ("XUL","JSComment") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   (currentContext >>= \x -> guard (x == ("XUL","JSComment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("XUL","Multi/inline Comment") =
  (((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("XUL","Multi/inline Comment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("XUL","Regular Expression") =
  (((pRegExpr regex_'2f'5big'5d'7b0'2c2'7d >>= withAttribute OtherTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((pRegExpr regex_'5c'7b'5b'5cd'2c_'5d'2b'5c'7d >>= withAttribute FloatTok))
   <|>
   ((pRegExpr regex_'5c'5c'5bbB'5d >>= withAttribute FloatTok))
   <|>
   ((pRegExpr regex_'5c'5c'5bnrtvfDdSsWw'5d >>= withAttribute BaseNTok))
   <|>
   ((pDetectChar False '[' >>= withAttribute BaseNTok) >>~ pushContext ("XUL","(charclass caret first check)"))
   <|>
   ((pRegExpr regex_'5c'5c'2e >>= withAttribute FloatTok))
   <|>
   ((pRegExpr regex_'5c'24'28'3f'3d'2f'29 >>= withAttribute FloatTok))
   <|>
   ((pAnyChar "?+*()|" >>= withAttribute FloatTok))
   <|>
   (currentContext >>= \x -> guard (x == ("XUL","Regular Expression")) >> pDefault >>= withAttribute OtherTok))

parseRules ("XUL","(Internal regex catch)") =
  (((pRegExpr regex_'5cs'2a >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'2f'2f'28'3f'3d'3b'29 >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("XUL","JSComment"))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("XUL","Multi/inline Comment"))
   <|>
   ((pDetectChar False '/' >>= withAttribute OtherTok) >>~ pushContext ("XUL","(regex caret first check)"))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("XUL","Regular Expression Character Class") =
  (((pRegExpr regex_'5c'5c'5b'5c'5b'5c'5d'5d >>= withAttribute BaseNTok))
   <|>
   ((pDetectChar False ']' >>= withAttribute BaseNTok) >>~ (popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("XUL","Regular Expression Character Class")) >> pDefault >>= withAttribute BaseNTok))

parseRules ("XUL","(regex caret first check)") =
  (((pDetectChar False '^' >>= withAttribute FloatTok) >>~ pushContext ("XUL","Regular Expression"))
   <|>
   (pushContext ("XUL","Regular Expression") >> currentContext >>= parseRules))

parseRules ("XUL","(charclass caret first check)") =
  (((pDetectChar False '^' >>= withAttribute FloatTok) >>~ pushContext ("XUL","Regular Expression Character Class"))
   <|>
   (pushContext ("XUL","Regular Expression Character Class") >> currentContext >>= parseRules))

parseRules ("XUL","region_marker") =
  (((pDetectIdentifier >>= withAttribute RegionMarkerTok))
   <|>
   ((pDetectSpaces >>= withAttribute RegionMarkerTok))
   <|>
   (currentContext >>= \x -> guard (x == ("XUL","region_marker")) >> pDefault >>= withAttribute RegionMarkerTok))

parseRules ("Alerts", _) = Text.Highlighting.Kate.Syntax.Alert.parseExpression Nothing

parseRules x = parseRules ("XUL","Start") <|> fail ("Unknown context" ++ show x)
