{- This module was generated from data in the Kate syntax
   highlighting file abc.xml, version 2, by Andrea Primiani (primiani@dag.it) -}

module Text.Highlighting.Kate.Syntax.Abc
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)

-- | Full name of language.
syntaxName :: String
syntaxName = "ABC"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.abc;*.ABC"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("ABC","Normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStContinuation = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  st <- getState
  if length contexts >= 2
    then case context of
      _ | synStContinuation st -> updateState $ \st -> st{ synStContinuation = False }
      ("ABC","Normal") -> return ()
      ("ABC","Preprocessor") -> (popContext) >> pEndLine
      ("ABC","Lyrics") -> (popContext) >> pEndLine
      ("ABC","Part") -> (popContext) >> pEndLine
      ("ABC","Comment") -> (popContext) >> pEndLine
      ("ABC","Bar") -> (popContext) >> pEndLine
      ("ABC","Header") -> return ()
      ("ABC","Header2") -> (popContext) >> pEndLine
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)


regex_'5c'28'5b23456789'5d'3a'3f'5b23456789'5d'3f'3a'3f'5b23456789'5d'3f = compileRegex True "\\([23456789]:?[23456789]?:?[23456789]?"
regex_'5c'5b'5bABCGHILMNOQRSTUVZ'5d'3a = compileRegex True "\\[[ABCGHILMNOQRSTUVZ]:"
regex_'5bABCGHILMNOPQRSTUVZ'5d'3a = compileRegex True "[ABCGHILMNOPQRSTUVZ]:"
regex_'5b'5f'7c'5c'5e'5d'3f'5b'5f'7c'3d'7c'5c'5e'5d'5bA'2dGa'2dg'5d = compileRegex True "[_|\\^]?[_|=|\\^][A-Ga-g]"
regex_'5bA'2dGa'2dgZz'5d = compileRegex True "[A-Ga-gZz]"
regex_'3a'2a'5c'7c'2a'5b1'2d9'5d'7c'2f'2a'5c'7c = compileRegex True ":*\\|*[1-9]|/*\\|"
regex_K'3a'2e'2b = compileRegex True "K:.+"

parseRules ("ABC","Normal") =
  (((pRegExpr regex_'5c'28'5b23456789'5d'3a'3f'5b23456789'5d'3f'3a'3f'5b23456789'5d'3f >>= withAttribute DataTypeTok))
   <|>
   ((pRangeDetect '"' '"' >>= withAttribute StringTok))
   <|>
   ((pRangeDetect '!' '!' >>= withAttribute FloatTok))
   <|>
   ((pRegExpr regex_'5c'5b'5bABCGHILMNOQRSTUVZ'5d'3a >>= withAttribute FloatTok) >>~ pushContext ("ABC","Header"))
   <|>
   ((pRegExpr regex_'5bABCGHILMNOPQRSTUVZ'5d'3a >>= withAttribute FloatTok) >>~ pushContext ("ABC","Header2"))
   <|>
   ((pColumn 0 >> pDetect2Chars False 'X' ':' >>= withAttribute FloatTok) >>~ pushContext ("ABC","Header"))
   <|>
   ((pAnyChar "|:[" >>= withAttribute CharTok) >>~ pushContext ("ABC","Bar"))
   <|>
   ((pDetectChar False ']' >>= withAttribute CharTok))
   <|>
   ((pAnyChar "()" >>= withAttribute DataTypeTok))
   <|>
   ((pAnyChar "{}" >>= withAttribute DataTypeTok))
   <|>
   ((pDetect2Chars False 'W' ':' >>= withAttribute DataTypeTok) >>~ pushContext ("ABC","Lyrics"))
   <|>
   ((pDetect2Chars False 'w' ':' >>= withAttribute DataTypeTok) >>~ pushContext ("ABC","Lyrics"))
   <|>
   ((pDetect2Chars False '%' '%' >>= withAttribute StringTok) >>~ pushContext ("ABC","Preprocessor"))
   <|>
   ((pDetectChar False '%' >>= withAttribute CommentTok) >>~ pushContext ("ABC","Comment"))
   <|>
   ((pRegExpr regex_'5b'5f'7c'5c'5e'5d'3f'5b'5f'7c'3d'7c'5c'5e'5d'5bA'2dGa'2dg'5d >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("ABC","Normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("ABC","Preprocessor") =
  (currentContext >>= \x -> guard (x == ("ABC","Preprocessor")) >> pDefault >>= withAttribute StringTok)

parseRules ("ABC","Lyrics") =
  (currentContext >>= \x -> guard (x == ("ABC","Lyrics")) >> pDefault >>= withAttribute DataTypeTok)

parseRules ("ABC","Part") =
  (currentContext >>= \x -> guard (x == ("ABC","Part")) >> pDefault >>= withAttribute FloatTok)

parseRules ("ABC","Comment") =
  (currentContext >>= \x -> guard (x == ("ABC","Comment")) >> pDefault >>= withAttribute CommentTok)

parseRules ("ABC","Bar") =
  (((pDetectChar False '"' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5bA'2dGa'2dgZz'5d >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pDetectChar False ' ' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pRangeDetect '!' '!' >>= withAttribute FloatTok))
   <|>
   ((pAnyChar "()" >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'3a'2a'5c'7c'2a'5b1'2d9'5d'7c'2f'2a'5c'7c >>= withAttribute CharTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("ABC","Bar")) >> pDefault >>= withAttribute CharTok))

parseRules ("ABC","Header") =
  (((pColumn 0 >> pRegExpr regex_K'3a'2e'2b >>= withAttribute FloatTok) >>~ (popContext))
   <|>
   ((pDetectChar False ']' >>= withAttribute FloatTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("ABC","Header")) >> pDefault >>= withAttribute FloatTok))

parseRules ("ABC","Header2") =
  (currentContext >>= \x -> guard (x == ("ABC","Header2")) >> pDefault >>= withAttribute FloatTok)


parseRules x = parseRules ("ABC","Normal") <|> fail ("Unknown context" ++ show x)
