# Copyright (c) 2012 Oracle and/or its affiliates. All rights reserved.
# Use is subject to license terms.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301
# USA

# Certain parts (c) Percona Inc

# Version 3.0: Advanced Combinatorics + TokuDB final

# ==== Workarounds
# --mysqld=--utility-user-password=test in top block: to avoid assert BUG #

# ==== Notes
# Note that --short_column_names is required for this grammar (see .zz1 for use of 'c1' name)
# Is the above outdated? c1 is no longer used in .zz1. Also check mail thread on pk issue.
#
# --plugin-load=tokudb=ha_tokudb.so has to be part of all runs, because if a
# --tokudb-... option is used, the TokuDB engine needs to be available already 
#
# To avoid TokuDB checking for jemalloc (i.e. to use default malloc), use the
# following --mysqld option, and unset LD_PRELOAD so that jemalloc cannot be found
# (Normally this option should NOT be used, it is only handy for throubleshooting)
#   --mysqld=--loose-tokudb-check-jemalloc=0
# Furthermore, when doing this set --soname-synonyms=somalloc=NONE (instead of *jemalloc*)
# 
# --soname-synonyms=somalloc=*jemalloc* is set to avoid many jemalloc-related SIG11
# crashes during Valgrind runs with jemalloc. For additional information, see:
# http://valgrind.org/docs/manual/manual-core.html#opt.soname-synonyms 

$combinations=
[
 ['
  --seed=random --duration=300 --querytimeout=60 --short_column_names
  --reporter=Shutdown,Backtrace,QueryTimeout,ErrorLog,ErrorLogAlarm
  --mysqld=--log-output=none --mysqld=--sql_mode=ONLY_FULL_GROUP_BY
  --mysqld=\'--plugin-load=audit_log=audit_log.so;tokudb=ha_tokudb.so\'
  --mysqld=--init-file='.$ENV{RQG_HOME}.'/conf/percona_qa/5.6/TokuDB.sql

  --mysqld=--utility-user-password=test
 '],[
  '--grammar=/tmp/mtr_to_sql.yy --gendata=conf/percona_qa/5.6/5.6.zz1 --threads=15 --no-mask
     --basedir=/sda/Percona-Server-5.6.20-rel68.0-657.Linux.x86_64-debug',
  '--grammar=/tmp/mtr_to_sql.yy --gendata=conf/percona_qa/5.6/5.6.zz1 --threads=20 --no-mask
     --basedir=/sda/Percona-Server-5.6.20-rel68.0-657.Linux.x86_64-debug-valgrind --valgrind --reporter=ValgrindErrors --validator=MarkErrorLog
     --valgrind_options=--soname-synonyms=somalloc=*jemalloc* --valgrind_options=--track-origins=yes',
  '--grammar=/tmp/mtr_to_sql.yy --gendata=conf/percona_qa/5.6/5.6.zz1 --threads=1  --no-mask
     --basedir=/sda/Percona-Server-5.6.20-rel68.0-657.Linux.x86_64-debug',
  '--grammar=/tmp/mtr_to_sql.yy --gendata=conf/percona_qa/5.6/5.6.zz1 --threads=17 --mask-level=1
     --basedir=/sda/Percona-Server-5.6.20-rel68.0-657.Linux.x86_64-debug --mysqld=--enforce-storage-engine=InnoDB --validator=Transformer',
  '--grammar=/tmp/mtr_to_sql.yy --gendata=conf/percona_qa/5.6/5.6.zz1 --threads=1  --no-mask
     --basedir=/sda/Percona-Server-5.6.20-rel68.0-657.Linux.x86_64-debug-valgrind --valgrind --reporter=ValgrindErrors --validator=MarkErrorLog
     --valgrind_options=--soname-synonyms=somalloc=*jemalloc* --valgrind_options=--track-origins=yes',
  '--grammar=/tmp/mtr_to_sql.yy --gendata=conf/percona_qa/5.6/5.6.zz1 --threads=13 --mask-level=1 --validator=Transformer
     --basedir=/sda/Percona-Server-5.6.20-rel68.0-657.Linux.x86_64-debug-valgrind --valgrind --reporter=ValgrindErrors --validator=MarkErrorLog
     --valgrind_options=--soname-synonyms=somalloc=*jemalloc* --valgrind_options=--track-origins=yes',
  '--grammar=/tmp/mtr_to_sql.yy --gendata=conf/percona_qa/5.6/5.6.zz2 --threads=1  --no-mask
     --basedir=/sda/Percona-Server-5.6.20-rel68.0-657.Linux.x86_64-debug',
  '--grammar=/tmp/mtr_to_sql.yy --gendata=conf/percona_qa/5.6/5.6.zz2 --threads=11 --mask-level=1
     --basedir=/sda/Percona-Server-5.6.20-rel68.0-657.Linux.x86_64-debug --validator=Transformer',
  '--grammar=/tmp/mtr_to_sql.yy --gendata=conf/percona_qa/5.6/5.6.zz2 --threads=25 --no-mask
     --basedir=/sda/Percona-Server-5.6.20-rel68.0-657.Linux.x86_64-debug-valgrind --valgrind --reporter=ValgrindErrors --validator=MarkErrorLog
     --valgrind_options=--soname-synonyms=somalloc=*jemalloc* --valgrind_options=--track-origins=yes',
  '--grammar=/tmp/mtr_to_sql.yy --gendata=conf/percona_qa/5.6/5.6.zz2 --threads=8 --mask-level=1 --validator=Transformer
     --basedir=/sda/Percona-Server-5.6.20-rel68.0-657.Linux.x86_64-debug-valgrind --valgrind --reporter=ValgrindErrors --validator=MarkErrorLog
     --valgrind_options=--soname-synonyms=somalloc=*jemalloc* --valgrind_options=--track-origins=yes',
  '--grammar=/tmp/mtr_to_sql.yy --gendata=conf/percona_qa/5.6/5.6.zz3 --threads=10 --no-mask
     --basedir=/sda/Percona-Server-5.6.20-rel68.0-657.Linux.x86_64-debug',
  '--grammar=/tmp/mtr_to_sql.yy --gendata=conf/percona_qa/5.6/5.6.zz3 --threads=15 --no-mask
     --basedir=/sda/Percona-Server-5.6.20-rel68.0-657.Linux.x86_64-debug-valgrind --valgrind --reporter=ValgrindErrors --validator=MarkErrorLog
     --valgrind_options=--soname-synonyms=somalloc=*jemalloc* --valgrind_options=--track-origins=yes'
 ],['
  --mysqld=--innodb_change_buffering=none
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=2
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_type=1
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=SYNCHRONOUS
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--innodb_purge_threads=4
  --mysqld=--innodb_adaptive_hash_index_partitions=1
  --mysqld=--innodb_buffer_pool_instances=1
  --rpl_mode=default
  --mysqld=--binlog-row-event-max-size=4K
  --mysqld=--sync_binlog=1
  --mysqld=--max_binlog_cache_size=8K
  --mysqld=--max_binlog_size=8K
  --mysqld=--max_relay_log_size=4K
 ','
  --views
  --notnull
  --mysqld=--innodb_change_buffering=inserts
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_flush_log_at_trx_commit=0
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb_max_changed_pages=0
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=PERFORMANCE
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user-password=test
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=6
  --mysqld=--innodb_adaptive_hash_index_partitions=8
  --mysqld=--innodb_buffer_pool_instances=17
 ','
  --notnull
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_files_in_group=3
  --mysqld=--innodb_max_bitmap_file_size=9223372036854770000
  --mysqld=--innodb_max_changed_pages=2
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=1
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-COMMITTED
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=32
  --mysqld=--innodb_adaptive_hash_index_partitions=5
  --mysqld=--innodb_buffer_pool_instances=4
 ','
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_flush_log_at_trx_commit=1
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_buffer_size=1048576
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_changed_pages=100
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=1
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--userstat
  --mysqld=--innodb_adaptive_hash_index_partitions=12
  --mysqld=--innodb_buffer_pool_instances=8
 ','
  --mysqld=--innodb_change_buffering=none
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=3
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=9223372036854770000
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--transaction-isolation=READ-COMMITTED
  --mysqld=--userstat
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=1
  --mysqld=--innodb_buffer_pool_instances=5
 ','
  --notnull
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=1048576
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb_max_changed_pages=100
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=1
  --mysqld=--innodb_adaptive_hash_index_partitions=16
  --rpl_mode=default
  --mysqld=--binlog-row-event-max-size=8K
  --mysqld=--sync_binlog=1
  --mysqld=--max_binlog_cache_size=16K
  --mysqld=--max_binlog_size=16K
  --mysqld=--max_relay_log_size=8K
 ','
  --notnull
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_flush_log_at_trx_commit=2
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_max_changed_pages=2
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=PERFORMANCE
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--userstat
  --mysqld=--utility-user-password=test
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=32
  --mysqld=--innodb_adaptive_hash_index_partitions=8
 ','
  --mysqld=--innodb_change_buffering=inserts
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=0
  --mysqld=--innodb_flush_method=ALL_O_DIRECT
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=1
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_adaptive_hash_index_partitions=1
  --mysqld=--innodb_buffer_pool_instances=4
 ','
  --notnull
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_flush_log_at_trx_commit=0
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_buffer_size=1048576
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_changed_pages=0
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user-password=test
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=4
  --mysqld=--innodb_adaptive_hash_index_partitions=16
  --mysqld=--innodb_buffer_pool_instances=17
 ','
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=2
  --mysqld=--innodb_flush_method=ALL_O_DIRECT
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_max_bitmap_file_size=9223372036854770000
  --mysqld=--innodb_max_changed_pages=0
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_type=1
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--audit-log-strategy=SYNCHRONOUS
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--innodb_purge_threads=6
  --mysqld=--innodb_adaptive_hash_index_partitions=5
  --mysqld=--innodb_buffer_pool_instances=5
  --rpl_mode=default
  --mysqld=--binlog-row-event-max-size=16K
  --mysqld=--sync_binlog=1
  --mysqld=--max_binlog_cache_size=32K
  --mysqld=--max_binlog_size=32K
  --mysqld=--max_relay_log_size=16K
 ','
  --notnull
  --mysqld=--innodb_change_buffering=none
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=1
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_max_changed_pages=2
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--slow_query_log
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--innodb_purge_threads=32
  --mysqld=--innodb_buffer_pool_instances=8
 ','
  --mysqld=--innodb_change_buffering=inserts
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_flush_log_at_trx_commit=2
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb_max_changed_pages=100
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=1
  --mysqld=--innodb_adaptive_hash_index_partitions=12
  --mysqld=--innodb_buffer_pool_instances=1
 ','
  --views
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=1048576
  --mysqld=--innodb_log_files_in_group=3
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_track_changed_pages=0
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=32
  --mysqld=--innodb_adaptive_hash_index_partitions=1
  --mysqld=--innodb_buffer_pool_instances=17
 ','
  --notnull
  --mysqld=--innodb_change_buffering=inserts
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_files_in_group=3
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_max_changed_pages=0
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=1
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=SYNCHRONOUS
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-COMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--innodb_adaptive_hash_index_partitions=8
  --mysqld=--innodb_buffer_pool_instances=1
 ','
  --notnull
  --mysqld=--innodb_change_buffering=none
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=0
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=9223372036854770000
  --mysqld=--innodb_max_changed_pages=100
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--readonly-key-cache-block-size=1
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--slow_query_log
  --mysqld=--transaction-isolation=READ-COMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user-password=test
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=4
  --mysqld=--innodb_adaptive_hash_index_partitions=12
  --mysqld=--innodb_buffer_pool_instances=4
 ','
  --mysqld=--innodb_change_buffering=inserts
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_flush_log_at_trx_commit=1
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb_max_changed_pages=2
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=1
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=PERFORMANCE
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--userstat
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=6
  --mysqld=--innodb_adaptive_hash_index_partitions=16
  --mysqld=--innodb_buffer_pool_instances=5
  --rpl_mode=default
  --mysqld=--binlog-row-event-max-size=32K
  --mysqld=--sync_binlog=1
  --mysqld=--max_binlog_cache_size=64K
  --mysqld=--max_binlog_size=64K
  --mysqld=--max_relay_log_size=32K
 ','
  --notnull
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_flush_log_at_trx_commit=1
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-COMMITTED
  --mysqld=--utility-user-password=test
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=4
  --mysqld=--innodb_adaptive_hash_index_partitions=8
  --mysqld=--innodb_buffer_pool_instances=8
 ','
  --mysqld=--innodb_change_buffering=none
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_flush_log_at_trx_commit=0
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_max_changed_pages=0
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=SYNCHRONOUS
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--userstat
  --mysqld=--innodb_purge_threads=1
  --mysqld=--innodb_adaptive_hash_index_partitions=5
  --mysqld=--innodb_buffer_pool_instances=17
 ','
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_flush_log_at_trx_commit=2
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_buffer_size=1048576
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_max_changed_pages=100
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--userstat
  --mysqld=--utility-user-password=test
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=6
  --mysqld=--innodb_adaptive_hash_index_partitions=1
  --mysqld=--innodb_buffer_pool_instances=8
 ','
  --notnull
  --mysqld=--innodb_change_buffering=inserts
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=1
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb_max_changed_pages=0
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=1
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--utility-user=roel@%
 ','
  --views
  --notnull
  --mysqld=--innodb_change_buffering=none
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_flush_log_at_trx_commit=0
  --mysqld=--innodb_log_files_in_group=3
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_track_changed_pages=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=1
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--userstat
  --mysqld=--utility-user-password=test
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=32
  --mysqld=--innodb_adaptive_hash_index_partitions=16
  --mysqld=--innodb_buffer_pool_instances=1
  --rpl_mode=default
  --mysqld=--binlog-row-event-max-size=32K
  --mysqld=--sync_binlog=0
  --mysqld=--max_binlog_cache_size=64K
  --mysqld=--max_binlog_size=64K
  --mysqld=--max_relay_log_size=32K
 ','
  --notnull
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_flush_method=ALL_O_DIRECT
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=3
  --mysqld=--innodb_max_bitmap_file_size=9223372036854770000
  --mysqld=--innodb_max_changed_pages=100
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--innodb_purge_threads=4
  --mysqld=--innodb_adaptive_hash_index_partitions=8
  --mysqld=--innodb_buffer_pool_instances=5
  --rpl_mode=default
  --mysqld=--binlog-row-event-max-size=32K
  --mysqld=--sync_binlog=10
  --mysqld=--max_binlog_cache_size=64K
  --mysqld=--max_binlog_size=64K
  --mysqld=--max_relay_log_size=32K
 ','
  --notnull
  --mysqld=--innodb_change_buffering=inserts
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=9223372036854770000
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-COMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user-password=test
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_adaptive_hash_index_partitions=5
 ','
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=2
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_buffer_size=1048576
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_changed_pages=0
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=6
  --mysqld=--innodb_buffer_pool_instances=1
 ','
  --notnull
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=1
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_buffer_size=1048576
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_files_in_group=3
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb_max_changed_pages=2
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=SYNCHRONOUS
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-COMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--innodb_purge_threads=32
  --mysqld=--innodb_adaptive_hash_index_partitions=16
  --mysqld=--innodb_buffer_pool_instances=4
 ','
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_max_changed_pages=100
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=1
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-COMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--innodb_purge_threads=6
  --mysqld=--innodb_adaptive_hash_index_partitions=12
  --mysqld=--innodb_buffer_pool_instances=8
 ','
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=2
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=9223372036854770000
  --mysqld=--innodb_max_changed_pages=2
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=SYNCHRONOUS
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--userstat
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_adaptive_hash_index_partitions=12
  --mysqld=--innodb_buffer_pool_instances=17
 ','
  --views
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=0
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_log_files_in_group=3
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_changed_pages=2
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--readonly-key-cache-block-size=1
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=32
  --mysqld=--innodb_adaptive_hash_index_partitions=12
  --mysqld=--innodb_buffer_pool_instances=5
 ','
  --mysqld=--innodb_change_buffering=none
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_flush_log_at_trx_commit=2
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_buffer_size=1048576
  --mysqld=--innodb_log_files_in_group=3
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_changed_pages=2
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=SYNCHRONOUS
  --mysqld=--userstat
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=1
  --mysqld=--innodb_adaptive_hash_index_partitions=8
  --mysqld=--innodb_buffer_pool_instances=4
 ','
  --mysqld=--innodb_change_buffering=inserts
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_flush_log_at_trx_commit=0
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_buffer_size=1048576
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=9223372036854770000
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=4
  --mysqld=--innodb_adaptive_hash_index_partitions=5
  --mysqld=--innodb_buffer_pool_instances=1
 ','
  --mysqld=--innodb_change_buffering=none
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=0
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_log_files_in_group=3
  --mysqld=--innodb_max_changed_pages=2
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=1
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--audit-log-strategy=PERFORMANCE
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=1
  --mysqld=--innodb_adaptive_hash_index_partitions=1
 ','
  --notnull
  --mysqld=--innodb_change_buffering=none
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=0
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_changed_pages=100
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-COMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--innodb_purge_threads=4
  --mysqld=--innodb_buffer_pool_instances=17
 ','
  --notnull
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--innodb_purge_threads=6
  --mysqld=--innodb_adaptive_hash_index_partitions=5
  --mysqld=--innodb_buffer_pool_instances=1
  --rpl_mode=default
  --mysqld=--binlog-row-event-max-size=32K
  --mysqld=--sync_binlog=100
  --mysqld=--max_binlog_cache_size=64K
  --mysqld=--max_binlog_size=64K
  --mysqld=--max_relay_log_size=32K
 ','
  --notnull
  --mysqld=--innodb_change_buffering=none
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_max_changed_pages=0
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_adaptive_hash_index_partitions=1
  --mysqld=--innodb_buffer_pool_instances=8
 ','
  --notnull
  --mysqld=--innodb_change_buffering=inserts
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_flush_log_at_trx_commit=2
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_max_changed_pages=0
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=32
  --mysqld=--innodb_buffer_pool_instances=4
 ','
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=2
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_track_changed_pages=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--audit-log-strategy=PERFORMANCE
  --mysqld=--userstat
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--innodb_purge_threads=1
  --mysqld=--innodb_adaptive_hash_index_partitions=5
  --mysqld=--innodb_buffer_pool_instances=5
  --rpl_mode=default
  --mysqld=--binlog-row-event-max-size=16K
  --mysqld=--sync_binlog=1
  --mysqld=--max_binlog_cache_size=32K
  --mysqld=--max_binlog_size=32K
  --mysqld=--max_relay_log_size=16K
 ','
  --notnull
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_flush_log_at_trx_commit=0
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_max_changed_pages=0
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--userstat
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=4
  --mysqld=--innodb_buffer_pool_instances=17
 ','
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_max_bitmap_file_size=9223372036854770000
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=1
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_adaptive_hash_index_partitions=12
  --mysqld=--innodb_buffer_pool_instances=1
 ','
  --notnull
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_flush_log_at_trx_commit=1
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_files_in_group=3
  --mysqld=--innodb_max_bitmap_file_size=9223372036854770000
  --mysqld=--innodb_max_changed_pages=100
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=1
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=1
  --mysqld=--innodb_adaptive_hash_index_partitions=5
  --rpl_mode=default
  --mysqld=--binlog-row-event-max-size=16K
  --mysqld=--sync_binlog=1
  --mysqld=--max_binlog_cache_size=32K
  --mysqld=--max_binlog_size=32K
  --mysqld=--max_relay_log_size=16K
 ','
  --notnull
  --mysqld=--innodb_change_buffering=none
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb_max_changed_pages=100
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=1
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=PERFORMANCE
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--userstat
  --mysqld=--utility-user-password=test
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=32
  --mysqld=--innodb_adaptive_hash_index_partitions=16
  --mysqld=--innodb_buffer_pool_instances=4
 ','
  --views
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=2
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=3
  --mysqld=--innodb_max_bitmap_file_size=9223372036854770000
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--slow_query_log
  --mysqld=--transaction-isolation=READ-COMMITTED
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=6
  --mysqld=--innodb_adaptive_hash_index_partitions=16
  --mysqld=--innodb_buffer_pool_instances=4
 ','
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=1
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=1048576
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb_max_changed_pages=2
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--userstat
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--innodb_purge_threads=4
  --mysqld=--innodb_adaptive_hash_index_partitions=1
  --mysqld=--innodb_buffer_pool_instances=5
 ','
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=1048576
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_max_bitmap_file_size=9223372036854770000
  --mysqld=--innodb_max_changed_pages=0
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_adaptive_hash_index_partitions=5
  --mysqld=--innodb_buffer_pool_instances=8
 ','
  --notnull
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_flush_log_at_trx_commit=2
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=3
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb_max_changed_pages=0
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--audit-log-strategy=PERFORMANCE
  --mysqld=--utility-user-password=test
  --mysqld=--innodb_purge_threads=1
  --mysqld=--innodb_adaptive_hash_index_partitions=8
  --mysqld=--innodb_buffer_pool_instances=4
 ','
  --notnull
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_flush_log_at_trx_commit=0
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_max_bitmap_file_size=9223372036854770000
  --mysqld=--innodb_track_changed_pages=0
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_type=1
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-COMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user-password=test
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=6
  --mysqld=--innodb_adaptive_hash_index_partitions=12
  --mysqld=--innodb_buffer_pool_instances=8
 ','
  --notnull
  --mysqld=--innodb_change_buffering=inserts
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_flush_log_at_trx_commit=1
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_max_changed_pages=0
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=SYNCHRONOUS
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--innodb_purge_threads=6
  --mysqld=--innodb_adaptive_hash_index_partitions=12
 ','
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_flush_log_at_trx_commit=2
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb_max_changed_pages=2
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=32
 ','
  --mysqld=--innodb_change_buffering=none
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_flush_log_at_trx_commit=1
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_buffer_size=1048576
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=9223372036854770000
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=1
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=PERFORMANCE
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--innodb_adaptive_hash_index_partitions=16
  --mysqld=--innodb_buffer_pool_instances=17
 ','
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_flush_log_at_trx_commit=0
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=1048576
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb_max_changed_pages=2
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=1
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-COMMITTED
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--innodb_adaptive_hash_index_partitions=1
  --mysqld=--innodb_buffer_pool_instances=5
 ','
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_files_in_group=3
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=9223372036854770000
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=1
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--innodb_purge_threads=1
  --mysqld=--innodb_adaptive_hash_index_partitions=8
  --mysqld=--innodb_buffer_pool_instances=8
 ','
  --views
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_flush_log_at_trx_commit=1
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_max_changed_pages=100
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--innodb_purge_threads=4
  --mysqld=--innodb_adaptive_hash_index_partitions=5
 ','
  --notnull
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=2
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=1
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=PERFORMANCE
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--userstat
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--innodb_purge_threads=32
  --mysqld=--innodb_adaptive_hash_index_partitions=12
  --mysqld=--innodb_buffer_pool_instances=17
 ','
  --mysqld=--innodb_change_buffering=inserts
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=2
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=1048576
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_max_changed_pages=100
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=6
  --mysqld=--innodb_buffer_pool_instances=8
 ','
  --notnull
  --mysqld=--innodb_change_buffering=inserts
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_flush_log_at_trx_commit=0
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_buffer_size=1048576
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=SYNCHRONOUS
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=6
  --mysqld=--innodb_adaptive_hash_index_partitions=16
  --mysqld=--innodb_buffer_pool_instances=5
 ','
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=9223372036854770000
  --mysqld=--innodb_max_changed_pages=100
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_type=1
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--innodb_purge_threads=1
  --mysqld=--innodb_adaptive_hash_index_partitions=1
  --mysqld=--innodb_buffer_pool_instances=17
 ','
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=1
  --mysqld=--innodb_log_buffer_size=1048576
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=3
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb_max_changed_pages=0
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=1
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--userstat
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=1
  --mysqld=--innodb_adaptive_hash_index_partitions=16
  --mysqld=--innodb_buffer_pool_instances=1
  --rpl_mode=default
  --mysqld=--binlog-row-event-max-size=16K
  --mysqld=--sync_binlog=1
  --mysqld=--max_binlog_cache_size=32K
  --mysqld=--max_binlog_size=32K
  --mysqld=--max_relay_log_size=64K
 ','
  --mysqld=--innodb_change_buffering=inserts
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=2
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_max_bitmap_file_size=9223372036854770000
  --mysqld=--innodb_max_changed_pages=2
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=1
  --mysqld=--slow_query_log
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_adaptive_hash_index_partitions=8
  --mysqld=--innodb_buffer_pool_instances=4
 ','
  --mysqld=--innodb_change_buffering=inserts
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-COMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=32
  --mysqld=--innodb_adaptive_hash_index_partitions=1
  --mysqld=--innodb_buffer_pool_instances=1
 ','
  --notnull
  --mysqld=--innodb_change_buffering=inserts
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=1
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb_track_changed_pages=0
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=PERFORMANCE
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-COMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=4
  --mysqld=--innodb_adaptive_hash_index_partitions=8
 ','
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_flush_log_at_trx_commit=2
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_max_changed_pages=2
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--transaction-isolation=READ-COMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=4
  --mysqld=--innodb_adaptive_hash_index_partitions=5
  --mysqld=--innodb_buffer_pool_instances=5
 ','
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_max_bitmap_file_size=9223372036854770000
  --mysqld=--innodb_max_changed_pages=0
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=1
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-COMMITTED
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--innodb_purge_threads=4
  --mysqld=--innodb_adaptive_hash_index_partitions=12
  --mysqld=--innodb_buffer_pool_instances=5
 ','
  --mysqld=--innodb_change_buffering=none
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=9223372036854770000
  --mysqld=--innodb_max_changed_pages=0
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--userstat
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=6
  --mysqld=--innodb_adaptive_hash_index_partitions=16
  --mysqld=--innodb_buffer_pool_instances=8
 ','
  --mysqld=--innodb_change_buffering=none
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_buffer_size=1048576
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=3
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--innodb_purge_threads=1
  --mysqld=--innodb_adaptive_hash_index_partitions=8
  --mysqld=--innodb_buffer_pool_instances=1
 ','
  --mysqld=--innodb_change_buffering=inserts
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_method=ALL_O_DIRECT
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb_max_changed_pages=2
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=PERFORMANCE
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_adaptive_hash_index_partitions=5
  --mysqld=--innodb_buffer_pool_instances=1
 ','
  --views
  --notnull
  --mysqld=--innodb_change_buffering=inserts
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_method=ALL_O_DIRECT
  --mysqld=--innodb_flush_log_at_trx_commit=0
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_max_changed_pages=100
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-COMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_buffer_pool_instances=8
 ','
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_flush_log_at_trx_commit=1
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_max_changed_pages=0
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--userstat
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=4
  --mysqld=--innodb_adaptive_hash_index_partitions=1
  --mysqld=--innodb_buffer_pool_instances=5
  --rpl_mode=default
  --mysqld=--binlog-row-event-max-size=16K
  --mysqld=--sync_binlog=10
  --mysqld=--max_binlog_cache_size=32K
  --mysqld=--max_binlog_size=32K
  --mysqld=--max_relay_log_size=16K
 ','
  --mysqld=--innodb_change_buffering=none
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=0
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_max_bitmap_file_size=9223372036854770000
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=1
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--audit-log-strategy=SYNCHRONOUS
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=32
  --mysqld=--innodb_adaptive_hash_index_partitions=12
  --mysqld=--innodb_buffer_pool_instances=17
 ','
  --notnull
  --mysqld=--innodb_change_buffering=none
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=1
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_files_in_group=3
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-COMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--innodb_purge_threads=1
  --mysqld=--innodb_adaptive_hash_index_partitions=1
 ','
  --notnull
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=9223372036854770000
  --mysqld=--innodb_track_changed_pages=0
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=PERFORMANCE
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=1
  --mysqld=--innodb_buffer_pool_instances=17
 ','
  --notnull
  --mysqld=--innodb_change_buffering=inserts
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=1
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=1048576
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=9223372036854770000
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=SYNCHRONOUS
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--userstat
  --mysqld=--utility-user-password=test
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=32
  --mysqld=--innodb_adaptive_hash_index_partitions=12
  --mysqld=--innodb_buffer_pool_instances=4
 ','
  --notnull
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_track_changed_pages=0
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=1
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--slow_query_log
  --mysqld=--userstat
  --mysqld=--innodb_adaptive_hash_index_partitions=5
  --mysqld=--innodb_buffer_pool_instances=4
 ','
  --views
  --mysqld=--innodb_change_buffering=none
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=1
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-COMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=4
  --mysqld=--innodb_adaptive_hash_index_partitions=12
 ','
  --notnull
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=2
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_max_changed_pages=0
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--innodb_purge_threads=6
  --mysqld=--innodb_adaptive_hash_index_partitions=12
  --mysqld=--innodb_buffer_pool_instances=5
 ','
  --notnull
  --mysqld=--innodb_change_buffering=inserts
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_flush_log_at_trx_commit=2
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=32
  --mysqld=--innodb_adaptive_hash_index_partitions=16
  --mysqld=--innodb_buffer_pool_instances=4
 ','
  --mysqld=--innodb_change_buffering=none
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=1
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=SYNCHRONOUS
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--innodb_purge_threads=32
  --mysqld=--innodb_buffer_pool_instances=17
 ','
  --notnull
  --mysqld=--innodb_change_buffering=none
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=0
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_buffer_size=1048576
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=9223372036854770000
  --mysqld=--innodb_max_changed_pages=2
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=1
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=PERFORMANCE
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--userstat
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_buffer_pool_instances=5
 ','
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_max_bitmap_file_size=9223372036854770000
  --mysqld=--innodb_max_changed_pages=100
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--userstat
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=32
  --rpl_mode=default
  --mysqld=--binlog-row-event-max-size=16K
  --mysqld=--sync_binlog=1
  --mysqld=--max_binlog_cache_size=32K
  --mysqld=--max_binlog_size=32K
  --mysqld=--max_relay_log_size=16K
 ','
  --notnull
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_flush_log_at_trx_commit=0
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_changed_pages=0
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=SYNCHRONOUS
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--innodb_purge_threads=6
  --mysqld=--innodb_adaptive_hash_index_partitions=1
  --mysqld=--innodb_buffer_pool_instances=8
 ','
  --notnull
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_max_changed_pages=2
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=4
  --mysqld=--innodb_adaptive_hash_index_partitions=8
  --mysqld=--innodb_buffer_pool_instances=8
 ','
  --notnull
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_track_changed_pages=0
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_type=1
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=SYNCHRONOUS
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=32
  --mysqld=--innodb_buffer_pool_instances=8
 ','
  --mysqld=--innodb_change_buffering=inserts
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=0
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_track_changed_pages=0
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=PERFORMANCE
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=6
  --mysqld=--innodb_adaptive_hash_index_partitions=5
  --mysqld=--innodb_buffer_pool_instances=1
 ','
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_flush_log_at_trx_commit=0
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_track_changed_pages=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--innodb_purge_threads=1
  --mysqld=--innodb_buffer_pool_instances=1
 ','
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_flush_log_at_trx_commit=0
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=1048576
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb_max_changed_pages=2
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-COMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_adaptive_hash_index_partitions=8
 ','
  --notnull
  --mysqld=--innodb_change_buffering=inserts
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_flush_log_at_trx_commit=1
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=3
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb_max_changed_pages=100
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=1
  --mysqld=--innodb_adaptive_hash_index_partitions=12
  --mysqld=--innodb_buffer_pool_instances=5
 ','
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--query_cache_type=1
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=1
 ','
  --views
  --mysqld=--innodb_change_buffering=none
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=1
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb_max_changed_pages=2
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=SEMISYNCHRONOUS
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=1
  --mysqld=--innodb_adaptive_hash_index_partitions=1
  --mysqld=--innodb_buffer_pool_instances=1
 ','
  --notnull
  --mysqld=--innodb_change_buffering=inserts
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_buffer_size=1048576
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_max_changed_pages=0
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=1
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=4
  --mysqld=--innodb_buffer_pool_instances=17
 ','
  --notnull
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=1
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_type=1
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=PERFORMANCE
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=32
  --mysqld=--innodb_adaptive_hash_index_partitions=1
  --mysqld=--innodb_buffer_pool_instances=8
 ','
  --views
  --notnull
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_flush_log_at_trx_commit=1
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=1048576
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_files_in_group=3
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_changed_pages=100
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--userstat
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--innodb_purge_threads=32
  --mysqld=--innodb_buffer_pool_instances=17
 ','
  --mysqld=--innodb_change_buffering=inserts
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=1
  --mysqld=--innodb_flush_method=ALL_O_DIRECT
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=1
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--transaction-isolation=READ-COMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=32
  --mysqld=--innodb_adaptive_hash_index_partitions=8
  --mysqld=--innodb_buffer_pool_instances=4
 ','
  --notnull
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_flush_log_at_trx_commit=2
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_max_changed_pages=0
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=1
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=SEMISYNCHRONOUS
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=4
  --mysqld=--innodb_adaptive_hash_index_partitions=16
  --mysqld=--innodb_buffer_pool_instances=8
 ','
  --notnull
  --mysqld=--innodb_change_buffering=inserts
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_track_changed_pages=0
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--slow_query_log
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_adaptive_hash_index_partitions=8
  --mysqld=--innodb_buffer_pool_instances=1
 ','
  --mysqld=--innodb_change_buffering=inserts
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=1
  --mysqld=--innodb_log_buffer_size=1048576
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-COMMITTED
  --mysqld=--userstat
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=32
  --mysqld=--innodb_buffer_pool_instances=8
 ','
  --notnull
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_flush_log_at_trx_commit=1
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb_max_changed_pages=2
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--slow_query_log
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--audit-log-strategy=PERFORMANCE
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--innodb_purge_threads=1
  --mysqld=--innodb_adaptive_hash_index_partitions=12
 ','
  --mysqld=--innodb_change_buffering=none
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_flush_log_at_trx_commit=1
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_adaptive_hash_index_partitions=16
  --mysqld=--innodb_buffer_pool_instances=1
 ','
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_flush_log_at_trx_commit=2
  --mysqld=--innodb_flush_method=ALL_O_DIRECT
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_log_files_in_group=3
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=1
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=SEMISYNCHRONOUS
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--userstat
  --mysqld=--utility-user-password=test
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=6
  --mysqld=--innodb_adaptive_hash_index_partitions=1
  --mysqld=--innodb_buffer_pool_instances=8
 ','
  --notnull
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_flush_log_at_trx_commit=2
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_max_changed_pages=0
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=1
  --mysqld=--innodb_adaptive_hash_index_partitions=8
  --mysqld=--innodb_buffer_pool_instances=17
 ','
  --mysqld=--innodb_change_buffering=inserts
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_flush_log_at_trx_commit=2
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_buffer_size=1048576
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_changed_pages=0
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--innodb_purge_threads=32
  --mysqld=--innodb_adaptive_hash_index_partitions=8
  --mysqld=--innodb_buffer_pool_instances=17
 ','
  --notnull
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=6
  --mysqld=--innodb_adaptive_hash_index_partitions=12
  --mysqld=--innodb_buffer_pool_instances=17
 ','
  --mysqld=--innodb_change_buffering=none
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_flush_log_at_trx_commit=0
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_max_bitmap_file_size=9223372036854770000
  --mysqld=--innodb_max_changed_pages=100
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=PERFORMANCE
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=4
  --mysqld=--innodb_adaptive_hash_index_partitions=16
 ','
  --mysqld=--innodb_change_buffering=inserts
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=2
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb_track_changed_pages=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-COMMITTED
  --mysqld=--audit-log-strategy=SEMISYNCHRONOUS
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=4
  --mysqld=--innodb_adaptive_hash_index_partitions=8
  --mysqld=--innodb_buffer_pool_instances=17
 ','
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_flush_log_at_trx_commit=0
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=1048576
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=9223372036854770000
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=1
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--userstat
  --mysqld=--innodb_purge_threads=6
  --mysqld=--innodb_adaptive_hash_index_partitions=12
  --mysqld=--innodb_buffer_pool_instances=5
 ','
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=1
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=4
  --mysqld=--innodb_adaptive_hash_index_partitions=5
  --mysqld=--innodb_buffer_pool_instances=4
 ','
  --mysqld=--innodb_change_buffering=none
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=2
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_buffer_size=1048576
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb_max_changed_pages=0
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--innodb_purge_threads=6
  --mysqld=--innodb_adaptive_hash_index_partitions=8
 ','
  --notnull
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=3
  --mysqld=--innodb_max_changed_pages=100
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=PERFORMANCE
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=4
  --mysqld=--innodb_adaptive_hash_index_partitions=12
  --mysqld=--innodb_buffer_pool_instances=1
 ','
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=0
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=9223372036854770000
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=SEMISYNCHRONOUS
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--userstat
  --mysqld=--utility-user-password=test
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=6
  --mysqld=--innodb_adaptive_hash_index_partitions=5
  --mysqld=--innodb_buffer_pool_instances=8
 ','
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_flush_log_at_trx_commit=1
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_buffer_size=1048576
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=9223372036854770000
  --mysqld=--innodb_max_changed_pages=0
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=1
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=32
  --mysqld=--innodb_adaptive_hash_index_partitions=5
 ','
  --views
  --notnull
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_flush_log_at_trx_commit=1
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_max_changed_pages=100
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--query_cache_type=1
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=PERFORMANCE
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=4
  --mysqld=--innodb_adaptive_hash_index_partitions=12
 ','
  --notnull
  --mysqld=--innodb_change_buffering=none
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_flush_log_at_trx_commit=2
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=1048576
  --mysqld=--innodb_track_changed_pages=0
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_adaptive_hash_index_partitions=16
 ','
  --notnull
  --mysqld=--innodb_change_buffering=inserts
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_flush_log_at_trx_commit=2
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=SEMISYNCHRONOUS
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--innodb_purge_threads=32
  --mysqld=--innodb_adaptive_hash_index_partitions=5
  --mysqld=--innodb_buffer_pool_instances=4
 ','
  --notnull
  --mysqld=--innodb_change_buffering=inserts
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=1
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=9223372036854770000
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=PERFORMANCE
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=4
  --mysqld=--innodb_adaptive_hash_index_partitions=5
  --mysqld=--innodb_buffer_pool_instances=8
 ','
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_flush_log_at_trx_commit=0
  --mysqld=--innodb_flush_method=ALL_O_DIRECT
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_log_files_in_group=3
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_track_changed_pages=0
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user-password=test
  --mysqld=--innodb_purge_threads=1
  --mysqld=--innodb_adaptive_hash_index_partitions=5
  --mysqld=--innodb_buffer_pool_instances=1
 ','
  --mysqld=--innodb_change_buffering=none
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=1048576
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_max_changed_pages=2
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--readonly-key-cache-block-size=1
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_adaptive_hash_index_partitions=1
  --mysqld=--innodb_buffer_pool_instances=17
 ','
  --views
  --notnull
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_max_changed_pages=0
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--userstat
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--innodb_adaptive_hash_index_partitions=1
  --mysqld=--innodb_buffer_pool_instances=8
 ','
  --mysqld=--innodb_change_buffering=inserts
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-COMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user-password=test
  --mysqld=--innodb_adaptive_hash_index_partitions=5
  --mysqld=--innodb_buffer_pool_instances=8
 ','
  --views
  --mysqld=--innodb_change_buffering=none
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_buffer_size=1048576
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb_max_changed_pages=100
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-COMMITTED
  --mysqld=--audit-log-strategy=SEMISYNCHRONOUS
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=4
  --mysqld=--innodb_adaptive_hash_index_partitions=16
  --mysqld=--innodb_buffer_pool_instances=8
 ','
  --mysqld=--innodb_change_buffering=none
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--slow_query_log
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=6
  --mysqld=--innodb_adaptive_hash_index_partitions=5
  --mysqld=--innodb_buffer_pool_instances=1
 ','
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=1048576
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb_max_changed_pages=100
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_type=1
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=PERFORMANCE
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-COMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=1
  --mysqld=--innodb_adaptive_hash_index_partitions=12
  --mysqld=--innodb_buffer_pool_instances=4
 ','
  --notnull
  --mysqld=--innodb_change_buffering=none
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_method=ALL_O_DIRECT
  --mysqld=--innodb_flush_log_at_trx_commit=0
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_max_bitmap_file_size=9223372036854770000
  --mysqld=--innodb_max_changed_pages=100
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=SEMISYNCHRONOUS
  --mysqld=--transaction-isolation=READ-COMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_adaptive_hash_index_partitions=5
  --mysqld=--innodb_buffer_pool_instances=17
 ','
  --notnull
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_max_bitmap_file_size=9223372036854770000
  --mysqld=--innodb_max_changed_pages=2
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--innodb_purge_threads=4
  --mysqld=--innodb_adaptive_hash_index_partitions=16
  --mysqld=--innodb_buffer_pool_instances=4
 ','
  --notnull
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=2
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_max_bitmap_file_size=9223372036854770000
  --mysqld=--innodb_max_changed_pages=0
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=1
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_adaptive_hash_index_partitions=16
  --mysqld=--innodb_buffer_pool_instances=8
 ','
  --notnull
  --mysqld=--innodb_change_buffering=inserts
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=1
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--transaction-isolation=READ-COMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=4
 ','
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_flush_log_at_trx_commit=0
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--query_cache_type=1
  --mysqld=--slow_query_log
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--userstat
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--innodb_purge_threads=4
  --mysqld=--innodb_adaptive_hash_index_partitions=16
  --mysqld=--innodb_buffer_pool_instances=4
 ','
  --notnull
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb_max_changed_pages=0
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_type=1
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=REPEATABLE-READ
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=32
  --mysqld=--innodb_adaptive_hash_index_partitions=1
  --mysqld=--innodb_buffer_pool_instances=1
 ','
  --notnull
  --mysqld=--innodb_change_buffering=none
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=3
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--readonly-key-cache-block-size=1
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=SEMISYNCHRONOUS
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=32
  --mysqld=--innodb_buffer_pool_instances=17
 ','
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=2
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_max_bitmap_file_size=9223372036854770000
  --mysqld=--innodb_max_changed_pages=0
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=6
  --mysqld=--innodb_adaptive_hash_index_partitions=5
  --mysqld=--innodb_buffer_pool_instances=5
 ','
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_max_changed_pages=2
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--innodb_purge_threads=6
  --mysqld=--innodb_adaptive_hash_index_partitions=16
 ','
  --mysqld=--innodb_change_buffering=none
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=1048576
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--utility-user=roel@%
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_adaptive_hash_index_partitions=16
  --mysqld=--innodb_buffer_pool_instances=1
 ','
  --notnull
  --mysqld=--innodb_change_buffering=inserts
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_flush_log_at_trx_commit=0
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_log_file_size=104857601
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_max_changed_pages=2
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-loose-max-connect-errors=1
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=PERFORMANCE
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=1
  --mysqld=--innodb_adaptive_hash_index_partitions=12
  --mysqld=--innodb_buffer_pool_instances=8
 ','
  --mysqld=--innodb_changed_pages=FORCE
  --mysqld=--innodb_flush_log_at_trx_commit=2
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_buffer_size=1048576
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb_max_changed_pages=100
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb_use_global_flush_log_at_trx_commit=0
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-COMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=1
  --mysqld=--innodb_adaptive_hash_index_partitions=1
  --mysqld=--innodb_buffer_pool_instances=17
 ','
  --notnull
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=2
  --mysqld=--innodb_flush_method=O_DSYNC
  --mysqld=--innodb_log_arch_expire_sec=120
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=1048577
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=4097
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--slow_query_log
  --mysqld=--audit-log-strategy=SEMISYNCHRONOUS
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--userstat
  --mysqld=--utility-user=roel@%
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=1
  --mysqld=--innodb_adaptive_hash_index_partitions=12
  --mysqld=--innodb_buffer_pool_instances=4
 ','
  --notnull
  --mysqld=--innodb_fast_shutdown=0
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_log_at_trx_commit=0
  --mysqld=--innodb_flush_method=O_DIRECT
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=512
  --mysqld=--innodb_log_buffer_size=10485761
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_files_in_group=2
  --mysqld=--innodb_log_group_home_dir=_epoch
  --mysqld=--innodb_max_bitmap_file_size=20480
  --mysqld=--innodb_max_changed_pages=0
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=0
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=1
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--skip-innodb_doublewrite
  --mysqld=--slow_query_log
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--userstat
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=1
  --mysqld=--innodb_purge_threads=6
  --mysqld=--innodb_adaptive_hash_index_partitions=8
 ','
  --notnull
  --mysqld=--innodb_change_buffering=all
  --mysqld=--innodb_changed_pages=ON
  --mysqld=--innodb_fast_shutdown=2
  --mysqld=--innodb_file_format=barracuda
  --mysqld=--innodb_file_per_table=1
  --mysqld=--innodb_flush_method=ALL_O_DIRECT
  --mysqld=--innodb_flush_log_at_trx_commit=1
  --mysqld=--innodb_log_arch_dir=_epoch
  --mysqld=--innodb_log_archive=1
  --mysqld=--innodb_log_block_size=4096
  --mysqld=--innodb_log_buffer_size=1048576
  --mysqld=--innodb_log_file_size=10485760
  --mysqld=--innodb_log_files_in_group=10
  --mysqld=--innodb_max_bitmap_file_size=9223372036854770000
  --mysqld=--innodb_max_changed_pages=0
  --mysqld=--innodb_track_changed_pages=1
  --mysqld=--innodb-buffer-pool-populate
  --mysqld=--loose-readonly-key-cache-division-limit=1
  --mysqld=--minimum-join-buffer-size=128
  --mysqld=--query_cache_size=1048576
  --mysqld=--query_cache_type=1
  --mysqld=--readonly-key-cache-block-size=0
  --mysqld=--readonly-loose-max-connect-errors=0
  --mysqld=--thread_handling=pool-of-threads
  --mysqld=--transaction-isolation=READ-UNCOMMITTED
  --mysqld=--audit-log-strategy=SEMISYNCHRONOUS
  --mysqld=--userstat
  --mysqld=--utility-user-password=test
  --mysqld=--utility-user-schema-access=mysqlinformation_schema
  --mysqld=--hidden-key-buffer-size=0
  --mysqld=--innodb_purge_threads=32
  --mysqld=--innodb_adaptive_hash_index_partitions=12
  --mysqld=--innodb_buffer_pool_instances=1
  '
 ]
]

