/*
 * Copyright (C) 2013-2021 Canonical, Ltd.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Author: Colin Ian King <colin.king@canonical.com>
 */
#ifndef __HEALTH_CHECK_H__
#define __HEALTH_CHECK_H__

#define _GNU_SOURCE

#include <stdbool.h>
#include <math.h>
#include "json.h"

#define OPT_GET_CHILDREN                0x00000001
#define OPT_BRIEF                       0x00000002
#define OPT_ADDR_RESOLVE		0x00000004
#define OPT_WAKELOCKS_LIGHT             0x00000008
#define OPT_WAKELOCKS_HEAVY             0x00000010
#define OPT_VERBOSE                     0x00000020
#define OPT_FOLLOW_NEW_PROCS		0x00000040
#define OPT_DURATION			0x00000080

#define FLOAT_TINY			(0.0000001)
#define FLOAT_CMP(a, b)			(fabs((a) - (b)) < FLOAT_TINY)

#define _VER_(major, minor, patchlevel)	\
	((major * 10000) + (minor * 100) + patchlevel)

#if defined(__GNUC__) && defined(__GNUC_MINOR__)
#if defined(__GNUC_PATCHLEVEL__)
#define NEED_GNUC(major, minor, patchlevel)                     \
	_VER_(major, minor, patchlevel) <= _VER_(__GNUC__, __GNUC_MINOR__, __GNUC_PATCHLEVEL__)
#else
#define NEED_GNUC(major, minor, patchlevel)                     \
	_VER_(major, minor, patchlevel) <= _VER_(__GNUC__, __GNUC_MINOR__, 0)
#endif
#else
#define NEED_GNUC(major, minor, patchlevel)     (0)
#endif

extern void health_check_exit(const int status) __attribute__ ((noreturn));
extern void health_check_out_of_memory(const char *msg);
extern int pid_max_digits(void);
extern volatile bool keep_running;
extern long int opt_max_syscalls;
extern int opt_flags;

#endif
