-- | Bill Alves.
module Music.Theory.Tuning.Alves where

import Music.Theory.Tuning {- hmt -}

-- | Ratios for 'harrison_ditone'.
--
-- > let c = [0,114,204,294,408,498,612,702,816,906,996,1110]
-- > in map (round . ratio_to_cents) harrison_ditone_r == c
harrison_ditone_r :: [Rational]
harrison_ditone_r =
    [1,2187/2048 {- 256/243 -}
    ,9/8,32/27
    ,81/64
    ,4/3,729/512
    ,3/2,6561/4096 {- 128/81 -}
    ,27/16,16/9
    ,243/128]

-- | Ditone/pythagorean tuning,
-- see <http://www.billalves.com/porgitaro/ditonesettuning.html>
--
-- > cents_i harrison_ditone == [0,114,204,294,408,498,612,702,816,906,996,1110]
harrison_ditone :: Tuning
harrison_ditone = Tuning (Left harrison_ditone_r) 2
