{-# OPTIONS_GHC -w #-}
{-# OPTIONS -fglasgow-exts -cpp #-}
{-# LANGUAGE Trustworthy #-}
module Cryptol.Parser
  ( parseModule
  , parseProgram, parseProgramWith
  , parseExpr, parseExprWith
  , parseDecl, parseDeclWith
  , parseDecls, parseDeclsWith
  , parseLetDecl, parseLetDeclWith
  , parseRepl, parseReplWith
  , parseSchema, parseSchemaWith
  , parseModName
  , ParseError(..), ppError
  , Layout(..)
  , Config(..), defaultConfig
  , guessPreProc, PreProc(..)
  ) where

import Data.Maybe(fromMaybe)
import Control.Monad(liftM2,msum)

import Cryptol.Prims.Syntax
import Cryptol.Parser.AST
import Cryptol.Parser.Position
import Cryptol.Parser.LexerUtils
import Cryptol.Parser.ParserUtils
import Cryptol.Parser.Unlit(PreProc(..), guessPreProc)

import Paths_cryptol
import qualified Data.Array as Happy_Data_Array
import qualified GHC.Exts as Happy_GHC_Exts
import Control.Applicative(Applicative(..))
import Control.Monad (ap)

-- parser produced by Happy Version 1.19.5

newtype HappyAbsSyn t55 = HappyAbsSyn HappyAny
#if __GLASGOW_HASKELL__ >= 607
type HappyAny = Happy_GHC_Exts.Any
#else
type HappyAny = forall a . a
#endif
happyIn14 :: (Module) -> (HappyAbsSyn t55)
happyIn14 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn14 #-}
happyOut14 :: (HappyAbsSyn t55) -> (Module)
happyOut14 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut14 #-}
happyIn15 :: (([Located Import], [TopDecl])) -> (HappyAbsSyn t55)
happyIn15 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn15 #-}
happyOut15 :: (HappyAbsSyn t55) -> (([Located Import], [TopDecl]))
happyOut15 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut15 #-}
happyIn16 :: ([Located Import]) -> (HappyAbsSyn t55)
happyIn16 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn16 #-}
happyOut16 :: (HappyAbsSyn t55) -> ([Located Import])
happyOut16 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut16 #-}
happyIn17 :: (Located Import) -> (HappyAbsSyn t55)
happyIn17 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn17 #-}
happyOut17 :: (HappyAbsSyn t55) -> (Located Import)
happyOut17 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut17 #-}
happyIn18 :: (Maybe (Located ModName)) -> (HappyAbsSyn t55)
happyIn18 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn18 #-}
happyOut18 :: (HappyAbsSyn t55) -> (Maybe (Located ModName))
happyOut18 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut18 #-}
happyIn19 :: (Maybe (Located ImportSpec)) -> (HappyAbsSyn t55)
happyIn19 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn19 #-}
happyOut19 :: (HappyAbsSyn t55) -> (Maybe (Located ImportSpec))
happyOut19 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut19 #-}
happyIn20 :: ([LName]) -> (HappyAbsSyn t55)
happyIn20 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn20 #-}
happyOut20 :: (HappyAbsSyn t55) -> ([LName])
happyOut20 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut20 #-}
happyIn21 :: ([Name] -> ImportSpec) -> (HappyAbsSyn t55)
happyIn21 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn21 #-}
happyOut21 :: (HappyAbsSyn t55) -> ([Name] -> ImportSpec)
happyOut21 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut21 #-}
happyIn22 :: (Program) -> (HappyAbsSyn t55)
happyIn22 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn22 #-}
happyOut22 :: (HappyAbsSyn t55) -> (Program)
happyOut22 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut22 #-}
happyIn23 :: (Program) -> (HappyAbsSyn t55)
happyIn23 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn23 #-}
happyOut23 :: (HappyAbsSyn t55) -> (Program)
happyOut23 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut23 #-}
happyIn24 :: ([TopDecl]) -> (HappyAbsSyn t55)
happyIn24 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn24 #-}
happyOut24 :: (HappyAbsSyn t55) -> ([TopDecl])
happyOut24 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut24 #-}
happyIn25 :: ([TopDecl]) -> (HappyAbsSyn t55)
happyIn25 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn25 #-}
happyOut25 :: (HappyAbsSyn t55) -> ([TopDecl])
happyOut25 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut25 #-}
happyIn26 :: ([TopDecl]) -> (HappyAbsSyn t55)
happyIn26 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn26 #-}
happyOut26 :: (HappyAbsSyn t55) -> ([TopDecl])
happyOut26 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut26 #-}
happyIn27 :: (TopDecl) -> (HappyAbsSyn t55)
happyIn27 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn27 #-}
happyOut27 :: (HappyAbsSyn t55) -> (TopDecl)
happyOut27 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut27 #-}
happyIn28 :: (Decl) -> (HappyAbsSyn t55)
happyIn28 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn28 #-}
happyOut28 :: (HappyAbsSyn t55) -> (Decl)
happyOut28 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut28 #-}
happyIn29 :: (Decl) -> (HappyAbsSyn t55)
happyIn29 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn29 #-}
happyOut29 :: (HappyAbsSyn t55) -> (Decl)
happyOut29 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut29 #-}
happyIn30 :: (Newtype) -> (HappyAbsSyn t55)
happyIn30 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn30 #-}
happyOut30 :: (HappyAbsSyn t55) -> (Newtype)
happyOut30 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut30 #-}
happyIn31 :: ([Named Type]) -> (HappyAbsSyn t55)
happyIn31 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn31 #-}
happyOut31 :: (HappyAbsSyn t55) -> ([Named Type])
happyOut31 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut31 #-}
happyIn32 :: ([ LName ]) -> (HappyAbsSyn t55)
happyIn32 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn32 #-}
happyOut32 :: (HappyAbsSyn t55) -> ([ LName ])
happyOut32 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut32 #-}
happyIn33 :: ([Pattern]) -> (HappyAbsSyn t55)
happyIn33 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn33 #-}
happyOut33 :: (HappyAbsSyn t55) -> ([Pattern])
happyOut33 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut33 #-}
happyIn34 :: ([Decl]) -> (HappyAbsSyn t55)
happyIn34 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn34 #-}
happyOut34 :: (HappyAbsSyn t55) -> ([Decl])
happyOut34 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut34 #-}
happyIn35 :: ([Decl]) -> (HappyAbsSyn t55)
happyIn35 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn35 #-}
happyOut35 :: (HappyAbsSyn t55) -> ([Decl])
happyOut35 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut35 #-}
happyIn36 :: ([Decl]) -> (HappyAbsSyn t55)
happyIn36 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn36 #-}
happyOut36 :: (HappyAbsSyn t55) -> ([Decl])
happyOut36 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut36 #-}
happyIn37 :: (ReplInput) -> (HappyAbsSyn t55)
happyIn37 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn37 #-}
happyOut37 :: (HappyAbsSyn t55) -> (ReplInput)
happyOut37 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut37 #-}
happyIn38 :: (Expr) -> (HappyAbsSyn t55)
happyIn38 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn38 #-}
happyOut38 :: (HappyAbsSyn t55) -> (Expr)
happyOut38 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut38 #-}
happyIn39 :: ([(Expr, Expr)]) -> (HappyAbsSyn t55)
happyIn39 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn39 #-}
happyOut39 :: (HappyAbsSyn t55) -> ([(Expr, Expr)])
happyOut39 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut39 #-}
happyIn40 :: ((Expr, Expr)) -> (HappyAbsSyn t55)
happyIn40 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn40 #-}
happyOut40 :: (HappyAbsSyn t55) -> ((Expr, Expr))
happyOut40 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut40 #-}
happyIn41 :: (Expr) -> (HappyAbsSyn t55)
happyIn41 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn41 #-}
happyOut41 :: (HappyAbsSyn t55) -> (Expr)
happyOut41 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut41 #-}
happyIn42 :: ([Expr]) -> (HappyAbsSyn t55)
happyIn42 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn42 #-}
happyOut42 :: (HappyAbsSyn t55) -> ([Expr])
happyOut42 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut42 #-}
happyIn43 :: (Expr) -> (HappyAbsSyn t55)
happyIn43 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn43 #-}
happyOut43 :: (HappyAbsSyn t55) -> (Expr)
happyOut43 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut43 #-}
happyIn44 :: ([(Bool, Integer)]) -> (HappyAbsSyn t55)
happyIn44 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn44 #-}
happyOut44 :: (HappyAbsSyn t55) -> ([(Bool, Integer)])
happyOut44 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut44 #-}
happyIn45 :: ((Bool, Integer)) -> (HappyAbsSyn t55)
happyIn45 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn45 #-}
happyOut45 :: (HappyAbsSyn t55) -> ((Bool, Integer))
happyOut45 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut45 #-}
happyIn46 :: (Located Selector) -> (HappyAbsSyn t55)
happyIn46 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn46 #-}
happyOut46 :: (HappyAbsSyn t55) -> (Located Selector)
happyOut46 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut46 #-}
happyIn47 :: ([Expr]) -> (HappyAbsSyn t55)
happyIn47 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn47 #-}
happyOut47 :: (HappyAbsSyn t55) -> ([Expr])
happyOut47 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut47 #-}
happyIn48 :: (Named Expr) -> (HappyAbsSyn t55)
happyIn48 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn48 #-}
happyOut48 :: (HappyAbsSyn t55) -> (Named Expr)
happyOut48 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut48 #-}
happyIn49 :: ([Named Expr]) -> (HappyAbsSyn t55)
happyIn49 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn49 #-}
happyOut49 :: (HappyAbsSyn t55) -> ([Named Expr])
happyOut49 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut49 #-}
happyIn50 :: (Expr) -> (HappyAbsSyn t55)
happyIn50 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn50 #-}
happyOut50 :: (HappyAbsSyn t55) -> (Expr)
happyOut50 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut50 #-}
happyIn51 :: ([[Match]]) -> (HappyAbsSyn t55)
happyIn51 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn51 #-}
happyOut51 :: (HappyAbsSyn t55) -> ([[Match]])
happyOut51 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut51 #-}
happyIn52 :: ([Match]) -> (HappyAbsSyn t55)
happyIn52 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn52 #-}
happyOut52 :: (HappyAbsSyn t55) -> ([Match])
happyOut52 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut52 #-}
happyIn53 :: (Match) -> (HappyAbsSyn t55)
happyIn53 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn53 #-}
happyOut53 :: (HappyAbsSyn t55) -> (Match)
happyOut53 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut53 #-}
happyIn54 :: (Pattern) -> (HappyAbsSyn t55)
happyIn54 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn54 #-}
happyOut54 :: (HappyAbsSyn t55) -> (Pattern)
happyOut54 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut54 #-}
happyIn55 :: t55 -> (HappyAbsSyn t55)
happyIn55 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn55 #-}
happyOut55 :: (HappyAbsSyn t55) -> t55
happyOut55 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut55 #-}
happyIn56 :: (Pattern) -> (HappyAbsSyn t55)
happyIn56 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn56 #-}
happyOut56 :: (HappyAbsSyn t55) -> (Pattern)
happyOut56 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut56 #-}
happyIn57 :: ([Pattern]) -> (HappyAbsSyn t55)
happyIn57 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn57 #-}
happyOut57 :: (HappyAbsSyn t55) -> ([Pattern])
happyOut57 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut57 #-}
happyIn58 :: (Named Pattern) -> (HappyAbsSyn t55)
happyIn58 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn58 #-}
happyOut58 :: (HappyAbsSyn t55) -> (Named Pattern)
happyOut58 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut58 #-}
happyIn59 :: ([Named Pattern]) -> (HappyAbsSyn t55)
happyIn59 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn59 #-}
happyOut59 :: (HappyAbsSyn t55) -> ([Named Pattern])
happyOut59 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut59 #-}
happyIn60 :: (Schema) -> (HappyAbsSyn t55)
happyIn60 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn60 #-}
happyOut60 :: (HappyAbsSyn t55) -> (Schema)
happyOut60 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut60 #-}
happyIn61 :: (Located [TParam]) -> (HappyAbsSyn t55)
happyIn61 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn61 #-}
happyOut61 :: (HappyAbsSyn t55) -> (Located [TParam])
happyOut61 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut61 #-}
happyIn62 :: (Located [Prop]) -> (HappyAbsSyn t55)
happyIn62 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn62 #-}
happyOut62 :: (HappyAbsSyn t55) -> (Located [Prop])
happyOut62 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut62 #-}
happyIn63 :: (Located Kind) -> (HappyAbsSyn t55)
happyIn63 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn63 #-}
happyOut63 :: (HappyAbsSyn t55) -> (Located Kind)
happyOut63 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut63 #-}
happyIn64 :: (TParam) -> (HappyAbsSyn t55)
happyIn64 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn64 #-}
happyOut64 :: (HappyAbsSyn t55) -> (TParam)
happyOut64 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut64 #-}
happyIn65 :: ([TParam]) -> (HappyAbsSyn t55)
happyIn65 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn65 #-}
happyOut65 :: (HappyAbsSyn t55) -> ([TParam])
happyOut65 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut65 #-}
happyIn66 :: (TParam) -> (HappyAbsSyn t55)
happyIn66 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn66 #-}
happyOut66 :: (HappyAbsSyn t55) -> (TParam)
happyOut66 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut66 #-}
happyIn67 :: ([TParam]) -> (HappyAbsSyn t55)
happyIn67 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn67 #-}
happyOut67 :: (HappyAbsSyn t55) -> ([TParam])
happyOut67 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut67 #-}
happyIn68 :: (Prop) -> (HappyAbsSyn t55)
happyIn68 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn68 #-}
happyOut68 :: (HappyAbsSyn t55) -> (Prop)
happyOut68 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut68 #-}
happyIn69 :: ([Prop]) -> (HappyAbsSyn t55)
happyIn69 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn69 #-}
happyOut69 :: (HappyAbsSyn t55) -> ([Prop])
happyOut69 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut69 #-}
happyIn70 :: (Type) -> (HappyAbsSyn t55)
happyIn70 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn70 #-}
happyOut70 :: (HappyAbsSyn t55) -> (Type)
happyOut70 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut70 #-}
happyIn71 :: (Type) -> (HappyAbsSyn t55)
happyIn71 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn71 #-}
happyOut71 :: (HappyAbsSyn t55) -> (Type)
happyOut71 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut71 #-}
happyIn72 :: (Type) -> (HappyAbsSyn t55)
happyIn72 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn72 #-}
happyOut72 :: (HappyAbsSyn t55) -> (Type)
happyOut72 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut72 #-}
happyIn73 :: ([ Type ]) -> (HappyAbsSyn t55)
happyIn73 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn73 #-}
happyOut73 :: (HappyAbsSyn t55) -> ([ Type ])
happyOut73 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut73 #-}
happyIn74 :: (Located [Type]) -> (HappyAbsSyn t55)
happyIn74 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn74 #-}
happyOut74 :: (HappyAbsSyn t55) -> (Located [Type])
happyOut74 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut74 #-}
happyIn75 :: ([Type]) -> (HappyAbsSyn t55)
happyIn75 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn75 #-}
happyOut75 :: (HappyAbsSyn t55) -> ([Type])
happyOut75 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut75 #-}
happyIn76 :: (Named Type) -> (HappyAbsSyn t55)
happyIn76 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn76 #-}
happyOut76 :: (HappyAbsSyn t55) -> (Named Type)
happyOut76 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut76 #-}
happyIn77 :: ([Named Type]) -> (HappyAbsSyn t55)
happyIn77 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn77 #-}
happyOut77 :: (HappyAbsSyn t55) -> ([Named Type])
happyOut77 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut77 #-}
happyIn78 :: ([LName]) -> (HappyAbsSyn t55)
happyIn78 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn78 #-}
happyOut78 :: (HappyAbsSyn t55) -> ([LName])
happyOut78 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut78 #-}
happyIn79 :: (LName) -> (HappyAbsSyn t55)
happyIn79 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn79 #-}
happyOut79 :: (HappyAbsSyn t55) -> (LName)
happyOut79 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut79 #-}
happyIn80 :: (Located ModName) -> (HappyAbsSyn t55)
happyIn80 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn80 #-}
happyOut80 :: (HappyAbsSyn t55) -> (Located ModName)
happyOut80 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut80 #-}
happyIn81 :: (Located QName) -> (HappyAbsSyn t55)
happyIn81 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn81 #-}
happyOut81 :: (HappyAbsSyn t55) -> (Located QName)
happyOut81 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut81 #-}
happyIn82 :: (Type) -> (HappyAbsSyn t55)
happyIn82 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn82 #-}
happyOut82 :: (HappyAbsSyn t55) -> (Type)
happyOut82 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut82 #-}
happyIn83 :: (Named Type) -> (HappyAbsSyn t55)
happyIn83 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn83 #-}
happyOut83 :: (HappyAbsSyn t55) -> (Named Type)
happyOut83 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut83 #-}
happyIn84 :: ([Named Type]) -> (HappyAbsSyn t55)
happyIn84 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn84 #-}
happyOut84 :: (HappyAbsSyn t55) -> ([Named Type])
happyOut84 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut84 #-}
happyInTok :: (Located Token) -> (HappyAbsSyn t55)
happyInTok x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyInTok #-}
happyOutTok :: (HappyAbsSyn t55) -> (Located Token)
happyOutTok x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOutTok #-}


happyActOffsets :: HappyAddr
happyActOffsets = HappyA# "\xf6\xff\xed\x03\x48\x03\x68\x01\xcd\x04\xcd\x04\x46\x03\x6a\x03\x28\x01\xc9\x02\x08\x05\x68\x03\x08\x05\x2b\x03\x00\x00\x15\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x03\xa3\x02\x2f\x03\x30\x03\xef\x07\x00\x00\x00\x00\x65\x03\x24\x03\x50\x03\x00\x00\x00\x00\x50\x03\x00\x00\x50\x03\x50\x03\x00\x00\x50\x03\x50\x03\x50\x03\x50\x03\x50\x03\x2f\x03\x31\x02\x72\x05\x00\x00\x00\x00\x04\x03\x42\x03\x13\x07\x1f\x05\x1e\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf3\x04\x68\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe7\x00\x01\x00\x6a\x05\x0a\x00\x4a\x02\xf3\x04\x68\x01\x68\x01\xef\x02\xef\x02\xf3\x01\x08\x03\xe2\x00\x63\x00\x01\x03\xbc\x04\x08\x05\xb3\x04\x9c\x04\x5f\x05\x00\x00\xdf\x02\x16\x00\xdf\x02\xe7\x01\xdf\x02\xed\x03\x00\x03\x00\x00\x36\x03\xd2\x02\xa3\x03\xec\x02\x80\x00\x00\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x29\x03\x08\x05\xde\x02\x08\x05\x08\x05\x00\x00\x00\x00\xea\x02\x21\x01\x00\x00\x9e\x00\x00\x00\x50\x02\xe2\x02\x00\x00\x3c\x02\xd7\xff\x00\x00\x09\x02\x00\x00\x00\x00\x4e\x01\x33\x01\x00\x00\xff\x04\x87\x04\x00\x00\x68\x01\xe5\x02\x08\x05\x7d\x02\x00\x00\x00\x00\xf2\x00\x00\x00\x00\x00\x00\x00\x76\x04\x00\x00\x00\x00\x00\x00\x2f\x03\x0f\x03\xd6\xff\x00\x00\x00\x00\xa0\x02\x00\x00\x00\x00\x41\x02\x61\x04\x00\x00\xa8\x00\xd3\x01\x00\x00\xe3\x02\xa7\x00\xe0\x02\xdc\x02\xdb\x02\xd9\x02\xd4\x02\xd0\x02\xcf\x02\xc7\x02\xc1\x02\xbc\x02\xb4\x02\xb3\x02\xb1\x02\xaf\x02\xa1\x02\x9d\x02\x9a\x02\x96\x02\x91\x02\x8e\x02\x8d\x02\x77\x02\x74\x02\x6b\x02\x44\x04\x67\x02\x6d\x02\x00\x00\x07\x01\x65\x00\x00\x00\x3d\x02\xf3\x04\xda\x05\x25\x02\x2f\x03\x68\x01\x68\x01\x68\x01\x68\x01\x68\x01\x68\x01\x68\x01\x68\x01\x68\x01\x68\x01\x68\x01\x68\x01\x68\x01\x68\x01\x68\x01\x68\x01\x68\x01\x68\x01\x68\x01\x68\x01\x68\x01\x68\x01\x68\x01\x68\x01\x68\x01\x68\x01\x00\x00\x2a\x02\x00\x00\x16\x02\x0e\x02\x70\x05\x00\x00\xb8\x01\x56\x05\x96\x01\xe9\x02\x08\x02\x5c\x05\x47\x07\x50\x03\x00\x00\x2f\x03\x50\x03\x50\x03\x50\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x03\x08\x05\x00\x00\x2f\x03\x2f\x03\x2f\x03\x2f\x03\x2f\x03\x2f\x03\x2f\x03\x2f\x03\x2f\x03\x2f\x03\x2f\x03\x00\x00\x7a\x08\x2f\x03\xef\x07\x14\x02\xff\x01\x7a\x08\x7a\x08\x7a\x08\x7a\x08\xe2\x01\xe2\x01\xe2\x01\xe2\x01\xc3\x05\xc3\x05\x7a\x08\x41\x07\x00\x00\x00\x00\x00\x00\x50\x03\x00\x00\x01\x07\x00\x00\x88\x01\xe9\x01\x00\x00\x00\x00\xdc\x07\x00\x00\x00\x00\x2f\x03\x00\x00\x2f\x03\xe3\x01\x57\x02\x60\x00\x08\x05\x00\x00\x08\x05\x00\x00\xba\x07\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x07\xc0\x07\xc0\x07\xc0\x07\x9f\x07\x9f\x07\x9f\x07\x9f\x07\x84\x07\x84\x07\x84\x07\x84\x07\x69\x07\x4e\x07\xba\x07\x21\x03\x21\x03\x21\x03\x21\x03\x00\x08\x00\x08\x7a\x08\x00\x00\x00\x00\x00\x00\x50\x04\x68\x01\x68\x01\x68\x01\x68\x01\x00\x00\x68\x01\x68\x01\x00\x00\xf3\x04\x68\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x68\x01\x2a\x04\x68\x01\x08\x05\x00\x00\x19\x02\x00\x00\x19\x00\x08\x08\xf0\x01\xdb\x01\x00\x00\x8e\x01\x00\x00\xe2\x07\x00\x00\x68\x01\x20\x04\x00\x00\x20\x04\x00\x00\x00\x00\x00\x00\xfe\x01\x68\x01\x00\x00\xe3\x04\x00\x00\x08\x05\x2f\x03\x00\x00\xf3\x04\x00\x00\xf3\x04\x00\x00\x2f\x03\xf3\x04\x00\x00\xf3\x04\x08\x05\x00\x00\xd6\x03\xeb\x01\xba\x03\x00\x00\xba\x03\x00\x00\x65\x04\x13\x04\xba\x03\x04\x02\x00\x00\xa3\x03\xa3\x03\x00\x00\x00\x00\x5c\x00\x00\x00\x5c\x00\x69\x00\x08\x05\x5f\x00\x09\x04\x68\x01\x75\x01\xcc\x01\x00\x00\x00\x00\x54\x00\x00\x00\xd3\x03\x00\x00\x00\x00\x00\x00\xa1\x01\x7a\x08\x00\x00\x00\x00\x7a\x08\xa6\x01\x00\x00\x2f\x03\xa0\x01\x00\x00\x00\x00\x13\x07\x00\x00\x08\x05\x00\x00\x2f\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x01\x68\x01\xa0\x01\x5e\x00\x9a\x01\x7d\x01\x00\x00\x7a\x01\x89\x01\x89\x01\x89\x01\x00\x00\x13\x07\x89\x01\x68\x01\x00\x00\x63\x01\x00\x00\x00\x00\x7a\x08\x00\x00\x00\x00\x00\x00\xef\x07\x00\x00\x7a\x08\x7a\x08\x2f\x03\x00\x00\x00\x00\x88\x01\xa3\x03\x5a\x01\xce\xff\x81\x01\x68\x01\xf3\x04\xf3\x04\x68\x01\x00\x00\x81\x01\x7a\x08\x5e\x01\x00\x00\x7a\x08\xce\xff\x00\x00\x00\x00\x00\x00\x39\x04\x4f\x01\x66\x01\x68\x01\x00\x00\x00\x00\x00\x00\x36\x01\x00\x00\x08\x05\x41\x01\x00\x00\x25\x01\x00\x00\x2b\x01\x3e\x01\x12\x01\x00\x00\x26\x01\x00\x00\x00\x00\x00\x00\x43\x01\x00\x00\x00\x00\x08\x05\x00\x00\x00\x00"#

happyGotoOffsets :: HappyAddr
happyGotoOffsets = HappyA# "\x37\x01\xf1\x00\x1b\x01\x23\x06\xab\x02\x5f\x02\x00\x01\xf5\x00\x6f\x05\x38\x08\xd6\x04\x00\x00\x58\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x08\xad\x09\x00\x00\x00\x00\x00\x00\x00\x00\xc1\x09\x00\x00\xa7\x03\x00\x00\x00\x00\xbd\x09\x00\x00\xb9\x09\xb5\x09\x00\x00\xb1\x09\xfb\x06\x35\x05\xd2\x04\x70\x04\xa1\x09\x6f\x08\x7f\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfa\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3c\x00\xae\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe8\x02\xbf\x04\x59\x00\xb8\x00\x5e\x02\x31\x01\x14\x07\x00\x07\x00\x00\x00\x00\x13\x01\x00\x00\x00\x00\x85\x02\x00\x00\xed\x00\xbb\x00\xce\x01\x6c\x01\xb7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x05\x00\x00\xab\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x53\x04\x00\x00\xa5\x00\x7d\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdf\x01\xdc\xff\x00\x00\x16\x06\x00\x00\x9d\x00\x29\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdc\xff\x00\x00\x00\x00\x00\x00\x95\x09\x5e\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf7\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5a\x00\xf0\xff\x00\x00\x89\x09\xf3\x06\xeb\x06\xe7\x06\xe3\x06\xdf\x06\xd7\x06\xca\x06\xb6\x06\xae\x06\xaa\x06\xa1\x06\x9d\x06\x99\x06\x95\x06\x8d\x06\x81\x06\x6c\x06\x64\x06\x60\x06\x58\x06\x54\x06\x50\x06\x4c\x06\x43\x06\x37\x06\x1a\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8d\x08\x00\x00\xb7\x02\x00\x00\xea\x03\x00\x00\x7d\x09\xc5\x03\xb7\x03\x52\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x31\x03\x9b\x00\x00\x00\x71\x09\x65\x09\x59\x09\x4d\x09\x41\x09\x35\x09\x29\x09\x1d\x09\x11\x09\x05\x09\xf9\x08\x00\x00\x00\x00\xed\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1c\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe1\x08\x00\x00\xd5\x08\x00\x00\x7b\x08\x52\x08\xfb\x00\x00\x00\x74\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdc\xff\x0e\x06\x9f\x02\x68\x04\x08\x06\x00\x00\x02\x06\xf9\x05\x00\x00\x22\x03\xec\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd8\x05\xdc\xff\xcf\x05\x22\x00\x00\x00\x00\x00\x00\x00\xa1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x39\x02\x0d\x02\x00\x00\x72\x01\x00\x00\x00\x00\x00\x00\x00\x00\xc2\x05\x00\x00\x7d\x00\x00\x00\x7a\x00\xc9\x08\x00\x00\xfd\x02\x00\x00\x6c\x02\x00\x00\xbd\x08\x38\x01\x00\x00\x07\x02\x4e\x00\x00\x00\x2c\x01\x04\x00\x4d\x05\x00\x00\x3f\x05\x00\x00\xcf\x01\xf4\xff\xa5\x03\x8e\x00\x00\x00\xfc\x01\x75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x97\x00\xdf\x03\x00\x00\xdc\xff\xbc\x05\x7d\x00\x79\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb1\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfd\xff\x00\x00\xa5\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb6\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa5\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x08\x00\x00\x00\x00\x00\x00\x77\x03\x00\x00\x3f\x00\x00\x00\xae\x04\x82\x01\x51\x07\x87\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x00\x00\x00\x00\x86\x02\x07\x00\x00\x00\xd9\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\xff\x00\x00\x00\x00"#

happyDefActions :: HappyAddr
happyDefActions = HappyA# "\x00\x00\xdf\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdf\xfe\xe6\xfe\x00\x00\xe4\xfe\xe1\xfe\xe0\xfe\xe2\xfe\xe3\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x26\xff\x04\xff\xfc\xfe\x00\x00\xde\xfe\xfb\xfe\xf8\xfe\xf7\xfe\x00\x00\xfa\xfe\x00\x00\x00\x00\xf9\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf0\xfe\xb8\xff\x00\x00\xb9\xff\xb7\xff\xaf\xff\x8f\xff\x8d\xff\x85\xff\x84\xff\x83\xff\x82\xff\x81\xff\x80\xff\x8a\xff\x00\x00\x00\x00\x8c\xff\x8b\xff\x89\xff\x88\xff\x7f\xff\x87\xff\x86\xff\x7e\xff\x7d\xff\x7b\xff\x7c\xff\x7a\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc4\xff\x00\x00\x00\x00\x00\x00\x00\x00\x34\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe0\xff\x00\x00\xd1\xff\x00\x00\x00\x00\xee\xff\x00\x00\xf0\xff\xeb\xff\xef\xff\xda\xff\xd7\xff\xd2\xff\x00\x00\x00\x00\xe2\xfe\x00\x00\x00\x00\xd0\xff\xdc\xff\x00\x00\x00\x00\xdd\xff\x00\x00\x28\xff\x00\x00\x00\x00\x2d\xff\x00\x00\x38\xff\x36\xff\x00\x00\x35\xff\x33\xff\x00\x00\x00\x00\x30\xff\x00\x00\x00\x00\xc2\xff\x00\x00\x00\x00\x00\x00\x00\x00\xc0\xff\xbe\xff\x00\x00\xba\xff\x90\xff\x91\xff\x00\x00\xdd\xfe\x72\xff\xdc\xfe\x00\x00\x00\x00\x00\x00\x54\xff\x52\xff\x51\xff\x56\xff\x49\xff\x00\x00\x00\x00\x76\xff\x00\x00\x00\x00\x77\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\xff\x45\xff\x00\x00\x74\xff\x00\x00\x00\x00\xb2\xff\x00\x00\x35\xff\x00\x00\x8e\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x19\xff\x00\x00\xe8\xfe\x00\x00\x1b\xff\x22\xff\x0d\xff\x00\x00\x00\x00\x00\x00\x00\x00\xf4\xfe\x00\x00\x00\x00\x00\x00\xfb\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x03\xff\x10\xff\x0e\xff\x0f\xff\xef\xfe\xfd\xfe\x00\x00\xfe\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1f\xff\x24\xff\x00\x00\x25\xff\x00\x00\x00\x00\x23\xff\x11\xff\x12\xff\x13\xff\x06\xff\x05\xff\x07\xff\x08\xff\x09\xff\x0a\xff\x0b\xff\x00\x00\xe5\xfe\xee\xfe\x02\xff\x00\x00\x00\xff\x00\x00\xff\xfe\xed\xfe\x00\x00\xf2\xfe\x20\xff\x00\x00\xf4\xfe\xf3\xfe\x00\x00\xf5\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf1\xfe\x00\x00\x21\xff\xa7\xff\xa8\xff\xa9\xff\xaa\xff\xab\xff\x93\xff\x92\xff\x95\xff\x94\xff\x96\xff\x97\xff\x98\xff\x99\xff\x9b\xff\x9a\xff\x9d\xff\x9c\xff\x9e\xff\x9f\xff\xa0\xff\xa2\xff\xa1\xff\xa3\xff\xa4\xff\xa5\xff\xa6\xff\xae\xff\x71\xff\x4f\xff\x4e\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\xff\x00\x00\x44\xff\x40\xff\x00\x00\x00\x00\x6c\xff\x6d\xff\x6e\xff\x6f\xff\x70\xff\x58\xff\x57\xff\x5a\xff\x59\xff\x5b\xff\x5c\xff\x5d\xff\x5e\xff\x60\xff\x5f\xff\x62\xff\x61\xff\x63\xff\x64\xff\x65\xff\x67\xff\x66\xff\x68\xff\x69\xff\x6a\xff\x6b\xff\x78\xff\x79\xff\x00\x00\x00\x00\x00\x00\x00\x00\x75\xff\x00\x00\x55\xff\x00\x00\x00\x00\x00\x00\xe6\xfe\xd5\xfe\x00\x00\xda\xfe\x00\x00\xc1\xff\x00\x00\x00\x00\xbb\xff\x00\x00\xcf\xff\xc3\xff\xbf\xff\xce\xff\x00\x00\x15\xff\x00\x00\x17\xff\x00\x00\x00\x00\x2e\xff\x00\x00\x2f\xff\x00\x00\x31\xff\x00\x00\x00\x00\x32\xff\x00\x00\x00\x00\x2c\xff\x00\x00\x00\x00\x00\x00\xde\xff\x00\x00\xdb\xff\x00\x00\x00\x00\x00\x00\xe8\xff\xd5\xff\x00\x00\x00\x00\xf3\xff\xed\xff\xf2\xff\xec\xff\xf1\xff\xe1\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd9\xff\xd8\xff\x00\x00\xb4\xff\x00\x00\xb6\xff\x27\xff\x29\xff\x37\xff\x39\xff\x2b\xff\x2a\xff\xcc\xff\x00\x00\x14\xff\x00\x00\xcd\xff\xbd\xff\xbc\xff\xac\xff\xdb\xfe\x00\x00\xd9\xfe\x00\x00\xd7\xfe\xd8\xfe\x53\xff\x50\xff\x48\xff\x4b\xff\x00\x00\x4d\xff\x4d\xff\x47\xff\x3e\xff\x3c\xff\x00\x00\x43\xff\x4c\xff\xb0\xff\xb1\xff\xad\xff\xca\xff\x00\x00\x18\xff\x1b\xff\xe7\xfe\x1a\xff\xe9\xfe\x1c\xff\x1d\xff\x0c\xff\x00\x00\x1e\xff\xeb\xfe\xea\xfe\x00\x00\xf6\xfe\x01\xff\xec\xfe\xee\xff\x00\x00\x00\x00\xc9\xff\x00\x00\x00\x00\x00\x00\x42\xff\x3f\xff\x4a\xff\xd6\xfe\x00\x00\xd4\xfe\xcb\xff\x00\x00\xb5\xff\xb3\xff\xc8\xff\x00\x00\x00\x00\xd3\xff\x00\x00\xd6\xff\xe9\xff\xea\xff\x00\x00\xe2\xff\xe3\xff\xd4\xff\xc7\xff\x00\x00\xc6\xff\x00\x00\x41\xff\x3d\xff\x3b\xff\x3a\xff\xf4\xff\x16\xff\xc5\xff\x00\x00\xe4\xff\xe7\xff\x00\x00\xe5\xff"#

happyCheck :: HappyAddr
happyCheck = HappyA# "\xff\xff\x41\x00\x01\x00\x02\x00\x03\x00\x04\x00\x2a\x00\x13\x00\x07\x00\x08\x00\x09\x00\x01\x00\x0b\x00\x0c\x00\x18\x00\x39\x00\x20\x00\x10\x00\x0e\x00\x3c\x00\x13\x00\x47\x00\x12\x00\x1d\x00\x11\x00\x15\x00\x01\x00\x45\x00\x1b\x00\x41\x00\x2a\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\x2b\x00\x5f\x00\x2a\x00\x19\x00\x26\x00\x41\x00\x31\x00\x32\x00\x06\x00\x41\x00\x5f\x00\x36\x00\x42\x00\x38\x00\x40\x00\x41\x00\x3b\x00\x43\x00\x41\x00\x26\x00\x31\x00\x40\x00\x45\x00\x39\x00\x22\x00\x41\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x01\x00\x02\x00\x41\x00\x04\x00\x02\x00\x2a\x00\x07\x00\x08\x00\x09\x00\x07\x00\x08\x00\x09\x00\x13\x00\x0e\x00\x41\x00\x31\x00\x08\x00\x12\x00\x13\x00\x14\x00\x15\x00\x60\x00\x19\x00\x03\x00\x16\x00\x2c\x00\x22\x00\x23\x00\x41\x00\x1e\x00\x1f\x00\x0b\x00\x0c\x00\x1d\x00\x0e\x00\x2a\x00\x10\x00\x26\x00\x12\x00\x34\x00\x26\x00\x11\x00\x2b\x00\x2e\x00\x2f\x00\x2b\x00\x41\x00\x34\x00\x31\x00\x04\x00\x34\x00\x31\x00\x30\x00\x36\x00\x43\x00\x44\x00\x36\x00\x41\x00\x41\x00\x05\x00\x34\x00\x07\x00\x2a\x00\x44\x00\x41\x00\x43\x00\x44\x00\x41\x00\x13\x00\x32\x00\x47\x00\x01\x00\x02\x00\x03\x00\x04\x00\x43\x00\x44\x00\x07\x00\x08\x00\x09\x00\x34\x00\x0b\x00\x0c\x00\x34\x00\x41\x00\x41\x00\x10\x00\x0d\x00\x0e\x00\x13\x00\x41\x00\x2a\x00\x12\x00\x41\x00\x5f\x00\x1f\x00\x19\x00\x1b\x00\x60\x00\x44\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\x2b\x00\x41\x00\x36\x00\x2a\x00\x1e\x00\x1f\x00\x31\x00\x32\x00\x32\x00\x33\x00\x41\x00\x36\x00\x41\x00\x38\x00\x42\x00\x0e\x00\x3b\x00\x2c\x00\x2d\x00\x12\x00\x41\x00\x40\x00\x01\x00\x02\x00\x03\x00\x04\x00\x41\x00\x46\x00\x07\x00\x08\x00\x09\x00\x18\x00\x0b\x00\x0c\x00\x1b\x00\x1c\x00\x1d\x00\x10\x00\x41\x00\x08\x00\x13\x00\x0a\x00\x41\x00\x2a\x00\x0d\x00\x0e\x00\x13\x00\x5a\x00\x1b\x00\x12\x00\x0f\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x41\x00\x33\x00\x16\x00\x2a\x00\x31\x00\x40\x00\x41\x00\x2a\x00\x43\x00\x36\x00\x3c\x00\x38\x00\x19\x00\x0e\x00\x3b\x00\x1c\x00\x09\x00\x12\x00\x34\x00\x40\x00\x15\x00\x01\x00\x02\x00\x03\x00\x04\x00\x46\x00\x41\x00\x07\x00\x08\x00\x09\x00\x41\x00\x0b\x00\x0c\x00\x43\x00\x44\x00\x00\x00\x10\x00\x3e\x00\x0e\x00\x13\x00\x41\x00\x2a\x00\x12\x00\x19\x00\x14\x00\x5a\x00\x1a\x00\x1b\x00\x13\x00\x33\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\x2b\x00\x41\x00\x34\x00\x2a\x00\x19\x00\x33\x00\x31\x00\x19\x00\x2a\x00\x37\x00\x32\x00\x36\x00\x2c\x00\x38\x00\x29\x00\x2a\x00\x3b\x00\x43\x00\x44\x00\x33\x00\x31\x00\x40\x00\x01\x00\x02\x00\x03\x00\x04\x00\x41\x00\x46\x00\x07\x00\x08\x00\x09\x00\x41\x00\x0b\x00\x0c\x00\x32\x00\x33\x00\x02\x00\x10\x00\x41\x00\x2c\x00\x13\x00\x07\x00\x08\x00\x09\x00\x19\x00\x0e\x00\x33\x00\x5a\x00\x1b\x00\x12\x00\x36\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\x2b\x00\x28\x00\x29\x00\x2a\x00\x2b\x00\x3a\x00\x31\x00\x19\x00\x26\x00\x2a\x00\x43\x00\x36\x00\x3c\x00\x38\x00\x19\x00\x19\x00\x3b\x00\x1c\x00\x1d\x00\x31\x00\x2d\x00\x40\x00\x27\x00\x28\x00\x29\x00\x2a\x00\x41\x00\x46\x00\x3a\x00\x33\x00\x32\x00\x33\x00\x41\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x19\x00\x32\x00\x33\x00\x34\x00\x3e\x00\x3f\x00\x37\x00\x41\x00\x33\x00\x5a\x00\x41\x00\x3c\x00\x37\x00\x3e\x00\x3f\x00\x32\x00\x33\x00\x30\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x3c\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x02\x00\x32\x00\x33\x00\x05\x00\x02\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x07\x00\x08\x00\x09\x00\x02\x00\x28\x00\x29\x00\x2a\x00\x2b\x00\x07\x00\x08\x00\x09\x00\x16\x00\x17\x00\x03\x00\x5f\x00\x16\x00\x36\x00\x34\x00\x35\x00\x32\x00\x33\x00\x0b\x00\x0c\x00\x16\x00\x0e\x00\x07\x00\x10\x00\x26\x00\x12\x00\x41\x00\x41\x00\x26\x00\x2b\x00\x34\x00\x35\x00\x3a\x00\x2b\x00\x19\x00\x31\x00\x26\x00\x01\x00\x0e\x00\x31\x00\x36\x00\x2b\x00\x12\x00\x41\x00\x36\x00\x3f\x00\x33\x00\x31\x00\x3c\x00\x2a\x00\x37\x00\x41\x00\x36\x00\x43\x00\x49\x00\x41\x00\x19\x00\x43\x00\x28\x00\x29\x00\x2a\x00\x01\x00\x02\x00\x41\x00\x04\x00\x43\x00\x2a\x00\x07\x00\x08\x00\x09\x00\x32\x00\x33\x00\x41\x00\x0d\x00\x0e\x00\x0f\x00\x42\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x3f\x00\x41\x00\x33\x00\x3c\x00\x01\x00\x02\x00\x37\x00\x41\x00\x1e\x00\x1f\x00\x07\x00\x08\x00\x09\x00\x1b\x00\x1c\x00\x1d\x00\x26\x00\x01\x00\x02\x00\x35\x00\x04\x00\x2b\x00\x33\x00\x07\x00\x08\x00\x09\x00\x37\x00\x31\x00\x32\x00\x0d\x00\x0e\x00\x0f\x00\x36\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x0e\x00\x32\x00\x33\x00\x26\x00\x12\x00\x41\x00\x14\x00\x33\x00\x1e\x00\x1f\x00\x3a\x00\x37\x00\x40\x00\x41\x00\x31\x00\x43\x00\x26\x00\x01\x00\x02\x00\x36\x00\x04\x00\x2b\x00\x33\x00\x07\x00\x08\x00\x09\x00\x37\x00\x31\x00\x2a\x00\x0d\x00\x0e\x00\x0f\x00\x36\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x0e\x00\x28\x00\x29\x00\x2a\x00\x12\x00\x41\x00\x2c\x00\x33\x00\x1e\x00\x1f\x00\x32\x00\x40\x00\x41\x00\x41\x00\x43\x00\x44\x00\x26\x00\x01\x00\x02\x00\x32\x00\x04\x00\x2b\x00\x32\x00\x07\x00\x08\x00\x09\x00\x41\x00\x31\x00\x2a\x00\x0d\x00\x0e\x00\x0f\x00\x36\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x0e\x00\x1b\x00\x1c\x00\x1d\x00\x12\x00\x41\x00\x32\x00\x32\x00\x1e\x00\x1f\x00\x32\x00\x3e\x00\x3f\x00\x41\x00\x41\x00\x32\x00\x26\x00\x01\x00\x02\x00\x32\x00\x04\x00\x2b\x00\x32\x00\x07\x00\x08\x00\x09\x00\x32\x00\x31\x00\x2a\x00\x0d\x00\x0e\x00\x0f\x00\x36\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x40\x00\x41\x00\x32\x00\x43\x00\x32\x00\x41\x00\x32\x00\x32\x00\x1e\x00\x1f\x00\x49\x00\x01\x00\x02\x00\x41\x00\x04\x00\x32\x00\x26\x00\x07\x00\x08\x00\x09\x00\x32\x00\x2b\x00\x3e\x00\x3f\x00\x0e\x00\x41\x00\x32\x00\x31\x00\x12\x00\x13\x00\x14\x00\x15\x00\x36\x00\x18\x00\x32\x00\x32\x00\x1b\x00\x1c\x00\x1d\x00\x32\x00\x1e\x00\x1f\x00\x21\x00\x41\x00\x32\x00\x24\x00\x32\x00\x32\x00\x26\x00\x01\x00\x02\x00\x32\x00\x04\x00\x2b\x00\x32\x00\x07\x00\x08\x00\x09\x00\x34\x00\x31\x00\x32\x00\x3a\x00\x0e\x00\x34\x00\x36\x00\x42\x00\x12\x00\x13\x00\x14\x00\x15\x00\x28\x00\x29\x00\x2a\x00\x40\x00\x41\x00\x41\x00\x43\x00\x03\x00\x1e\x00\x1f\x00\x43\x00\x01\x00\x02\x00\x60\x00\x04\x00\x34\x00\x26\x00\x07\x00\x08\x00\x09\x00\x03\x00\x2b\x00\x3a\x00\x34\x00\x0e\x00\x41\x00\x60\x00\x31\x00\x12\x00\x13\x00\x14\x00\x15\x00\x36\x00\x37\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\x1e\x00\x1f\x00\x60\x00\x41\x00\x01\x00\x02\x00\x35\x00\x04\x00\x26\x00\x3a\x00\x07\x00\x08\x00\x09\x00\x2b\x00\x19\x00\x40\x00\x41\x00\x0e\x00\x43\x00\x31\x00\x3d\x00\x12\x00\x41\x00\x60\x00\x36\x00\x01\x00\x02\x00\x3d\x00\x04\x00\x49\x00\x3a\x00\x07\x00\x08\x00\x09\x00\x3f\x00\x41\x00\x40\x00\x41\x00\x0e\x00\x43\x00\x60\x00\x26\x00\x12\x00\x01\x00\x02\x00\x03\x00\x2b\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x18\x00\x31\x00\x0b\x00\x0c\x00\x1a\x00\x0e\x00\x36\x00\x10\x00\x42\x00\x12\x00\x42\x00\x26\x00\x3a\x00\x01\x00\x02\x00\x03\x00\x2b\x00\x41\x00\x40\x00\x41\x00\xff\xff\x43\x00\x31\x00\x0b\x00\x0c\x00\xff\xff\x0e\x00\x36\x00\x10\x00\xff\xff\x12\x00\x18\x00\xff\xff\x2a\x00\x1b\x00\x1c\x00\x1d\x00\x02\x00\x41\x00\xff\xff\x05\x00\x06\x00\x07\x00\x08\x00\x09\x00\x0a\x00\xff\xff\xff\xff\x0b\x00\x0c\x00\xff\xff\x0e\x00\xff\xff\x10\x00\x2a\x00\x12\x00\x41\x00\x16\x00\x17\x00\xff\xff\x02\x00\x40\x00\x41\x00\x05\x00\x43\x00\x07\x00\x08\x00\x09\x00\x0a\x00\xff\xff\xff\xff\x40\x00\x41\x00\x26\x00\x43\x00\xff\xff\xff\xff\x41\x00\x2b\x00\x2a\x00\x16\x00\x17\x00\xff\xff\xff\xff\x31\x00\x02\x00\xff\xff\xff\xff\x02\x00\x36\x00\x07\x00\x08\x00\x09\x00\x07\x00\x08\x00\x09\x00\x26\x00\x3a\x00\x3b\x00\xff\xff\x41\x00\x2b\x00\x41\x00\x40\x00\x41\x00\x16\x00\x43\x00\x31\x00\x16\x00\xff\xff\xff\xff\x02\x00\x36\x00\x3a\x00\x05\x00\xff\xff\x07\x00\x08\x00\x09\x00\x40\x00\x41\x00\x26\x00\x43\x00\x41\x00\x26\x00\xff\xff\x2b\x00\x3a\x00\xff\xff\x2b\x00\xff\xff\x16\x00\x31\x00\x40\x00\x41\x00\x31\x00\x43\x00\x36\x00\x37\x00\x02\x00\x36\x00\x37\x00\xff\xff\xff\xff\x07\x00\x08\x00\x09\x00\x26\x00\x41\x00\x02\x00\xff\xff\x41\x00\x2b\x00\xff\xff\x07\x00\x08\x00\x09\x00\xff\xff\x31\x00\x40\x00\x41\x00\x42\x00\x02\x00\x36\x00\x3a\x00\xff\xff\xff\xff\x07\x00\x08\x00\x09\x00\x40\x00\x41\x00\x02\x00\x43\x00\x41\x00\x26\x00\xff\xff\x07\x00\x08\x00\x09\x00\x2b\x00\xff\xff\x16\x00\xff\xff\xff\xff\x26\x00\x31\x00\x02\x00\xff\xff\xff\xff\x2b\x00\x36\x00\x07\x00\x08\x00\x09\x00\x3a\x00\x31\x00\xff\xff\x26\x00\xff\xff\xff\xff\x36\x00\x41\x00\x2b\x00\xff\xff\x3a\x00\xff\xff\xff\xff\x26\x00\x31\x00\x02\x00\xff\xff\x41\x00\x2b\x00\x36\x00\x07\x00\x08\x00\x09\x00\xff\xff\x31\x00\xff\xff\x19\x00\xff\xff\x26\x00\x36\x00\x41\x00\xff\xff\x02\x00\x3a\x00\xff\xff\xff\xff\x02\x00\x07\x00\x08\x00\x09\x00\x41\x00\x07\x00\x08\x00\x09\x00\xff\xff\x37\x00\xff\xff\x2e\x00\x2f\x00\x30\x00\xff\xff\x26\x00\x33\x00\x02\x00\xff\xff\xff\xff\x2b\x00\xff\xff\x07\x00\x08\x00\x09\x00\x18\x00\x31\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x36\x00\x26\x00\xff\xff\x02\x00\x3a\x00\x26\x00\x2b\x00\xff\xff\x07\x00\x08\x00\x09\x00\x41\x00\x31\x00\x40\x00\x41\x00\x42\x00\x31\x00\x36\x00\x40\x00\x41\x00\x42\x00\x3a\x00\x26\x00\xff\xff\x02\x00\x3a\x00\xff\xff\x2b\x00\x41\x00\x07\x00\x08\x00\x09\x00\xff\xff\x31\x00\x40\x00\x41\x00\x3a\x00\x43\x00\x36\x00\x26\x00\xff\xff\xff\xff\x40\x00\x41\x00\x2b\x00\x43\x00\x3e\x00\x02\x00\xff\xff\x41\x00\x31\x00\xff\xff\x07\x00\x08\x00\x09\x00\x36\x00\x02\x00\xff\xff\xff\xff\x3a\x00\x26\x00\x07\x00\x08\x00\x09\x00\x18\x00\x2b\x00\x41\x00\x1b\x00\x1c\x00\x1d\x00\xff\xff\x31\x00\x32\x00\x02\x00\xff\xff\xff\xff\x36\x00\xff\xff\x07\x00\x08\x00\x09\x00\x18\x00\xff\xff\x26\x00\x1b\x00\x1c\x00\x1d\x00\x41\x00\x2b\x00\x2c\x00\x21\x00\xff\xff\x26\x00\x16\x00\x31\x00\x02\x00\xff\xff\x2b\x00\xff\xff\x36\x00\x07\x00\x08\x00\x09\x00\x31\x00\x40\x00\x41\x00\xff\xff\x43\x00\x36\x00\x26\x00\x41\x00\x02\x00\x3a\x00\xff\xff\x2b\x00\xff\xff\x07\x00\x08\x00\x09\x00\x41\x00\x31\x00\x40\x00\x41\x00\x02\x00\x43\x00\x36\x00\xff\xff\xff\xff\x07\x00\x08\x00\x09\x00\x26\x00\x02\x00\xff\xff\x3a\x00\xff\xff\x41\x00\x07\x00\x08\x00\x09\x00\x40\x00\x41\x00\x31\x00\x43\x00\x40\x00\x41\x00\x42\x00\x26\x00\xff\xff\xff\xff\xff\xff\x3a\x00\x2b\x00\xff\xff\x01\x00\x02\x00\x03\x00\x04\x00\x31\x00\x26\x00\x07\x00\x08\x00\x09\x00\x36\x00\x0b\x00\x0c\x00\xff\xff\xff\xff\x26\x00\x10\x00\x31\x00\xff\xff\x13\x00\xff\xff\x41\x00\x0b\x00\x0c\x00\xff\xff\x0e\x00\x3a\x00\x10\x00\xff\xff\x12\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\x2b\x00\x0c\x00\xff\xff\x0e\x00\xff\xff\x10\x00\x31\x00\x12\x00\xff\xff\xff\xff\x2a\x00\x36\x00\xff\xff\x38\x00\xff\xff\x0c\x00\x3b\x00\x0e\x00\xff\xff\x10\x00\x02\x00\x12\x00\xff\xff\x02\x00\xff\xff\x07\x00\x08\x00\x09\x00\x07\x00\x08\x00\x09\x00\x2a\x00\xff\xff\x41\x00\x02\x00\xff\xff\xff\xff\x3a\x00\xff\xff\x07\x00\x08\x00\x09\x00\x02\x00\x40\x00\x41\x00\x2a\x00\x43\x00\x07\x00\x08\x00\x09\x00\xff\xff\xff\xff\x0f\x00\xff\xff\x41\x00\xff\xff\x26\x00\xff\xff\xff\xff\x26\x00\x17\x00\x18\x00\x32\x00\x33\x00\x1b\x00\x1c\x00\x1d\x00\xff\xff\x41\x00\xff\xff\x26\x00\xff\xff\xff\xff\x37\x00\x3e\x00\xff\xff\x37\x00\xff\xff\x26\x00\xff\xff\xff\xff\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x37\x00\xff\xff\xff\xff\x34\x00\x4f\x00\xff\xff\xff\xff\xff\xff\x37\x00\x54\x00\x55\x00\xff\xff\xff\xff\x3e\x00\x40\x00\x41\x00\xff\xff\x43\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\xff\xff\xff\xff\x18\x00\xff\xff\x4f\x00\x1b\x00\x1c\x00\x1d\x00\xff\xff\x54\x00\x55\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\xff\xff\xff\xff\x18\x00\xff\xff\x60\x00\x1b\x00\x1c\x00\x1d\x00\x18\x00\xff\xff\xff\xff\x1b\x00\x1c\x00\x1d\x00\x18\x00\x01\x00\x02\x00\x1b\x00\x1c\x00\x1d\x00\xff\xff\x07\x00\x08\x00\x09\x00\xff\xff\x40\x00\x41\x00\x18\x00\x43\x00\xff\xff\x1b\x00\x1c\x00\x1d\x00\xff\xff\x40\x00\x41\x00\x18\x00\x43\x00\xff\xff\x1b\x00\x1c\x00\x1d\x00\x40\x00\x41\x00\xff\xff\x43\x00\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x26\x00\xff\xff\x40\x00\x41\x00\x18\x00\x43\x00\xff\xff\x1b\x00\x1c\x00\x1d\x00\x47\x00\x48\x00\x49\x00\x4a\x00\xff\xff\x40\x00\x41\x00\x18\x00\x43\x00\xff\xff\x1b\x00\x1c\x00\x1d\x00\xff\xff\x40\x00\x41\x00\x18\x00\x43\x00\xff\xff\x1b\x00\x1c\x00\x1d\x00\x18\x00\xff\xff\xff\xff\x1b\x00\x1c\x00\x1d\x00\x18\x00\xff\xff\xff\xff\x1b\x00\x1c\x00\x1d\x00\x40\x00\x41\x00\x18\x00\x43\x00\xff\xff\x1b\x00\x1c\x00\x1d\x00\xff\xff\x1b\x00\x1c\x00\x1d\x00\xff\xff\x40\x00\x41\x00\x18\x00\x43\x00\xff\xff\x1b\x00\x1c\x00\x1d\x00\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x1b\x00\x1c\x00\x1d\x00\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x40\x00\x41\x00\xff\xff\x43\x00\x1b\x00\x1c\x00\x1d\x00\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x1b\x00\x1c\x00\x1d\x00\xff\xff\x1b\x00\x1c\x00\x1d\x00\xff\xff\x1b\x00\x1c\x00\x1d\x00\xff\xff\x1b\x00\x1c\x00\x1d\x00\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x1b\x00\x1c\x00\x1d\x00\xff\xff\x1b\x00\x1c\x00\x1d\x00\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x1b\x00\x1c\x00\x1d\x00\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x40\x00\x41\x00\xff\xff\x43\x00\x40\x00\x41\x00\xff\xff\x43\x00\x40\x00\x41\x00\xff\xff\x43\x00\x1b\x00\x1c\x00\x1d\x00\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x40\x00\x41\x00\xff\xff\x43\x00\x1b\x00\x1c\x00\x1d\x00\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x1b\x00\x1c\x00\x1d\x00\xff\xff\x1b\x00\x1c\x00\x1d\x00\xff\xff\x1b\x00\x1c\x00\x1d\x00\xff\xff\x1b\x00\x1c\x00\x1d\x00\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x1b\x00\x1c\x00\x1d\x00\xff\xff\x1b\x00\x1c\x00\x1d\x00\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x1b\x00\x1c\x00\x1d\x00\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x40\x00\x41\x00\xff\xff\x43\x00\x40\x00\x41\x00\xff\xff\x43\x00\x40\x00\x41\x00\xff\xff\x43\x00\x1b\x00\x1c\x00\x1d\x00\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x40\x00\x41\x00\xff\xff\x43\x00\x1b\x00\x1c\x00\x1d\x00\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x1b\x00\x1c\x00\x1d\x00\xff\xff\x1b\x00\x1c\x00\x1d\x00\xff\xff\x1b\x00\x1c\x00\x1d\x00\xff\xff\x1b\x00\x1c\x00\x1d\x00\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x1b\x00\x1c\x00\x1d\x00\xff\xff\x1b\x00\x1c\x00\x1d\x00\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x1b\x00\x1c\x00\x1d\x00\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x40\x00\x41\x00\xff\xff\x43\x00\x40\x00\x41\x00\xff\xff\x43\x00\x40\x00\x41\x00\x2c\x00\x43\x00\x1b\x00\x1c\x00\x1d\x00\xff\xff\x40\x00\x41\x00\x3a\x00\x43\x00\x40\x00\x41\x00\xff\xff\x43\x00\x40\x00\x41\x00\xff\xff\x43\x00\x3e\x00\x40\x00\x41\x00\xff\xff\x43\x00\xff\xff\xff\xff\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\xff\xff\xff\xff\xff\xff\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x2c\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x2c\x00\xff\xff\xff\xff\xff\xff\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\xff\xff\xff\xff\xff\xff\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3e\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x41\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\xff\xff\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\xff\xff\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\xff\xff\xff\xff\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\xff\xff\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\xff\xff\xff\xff\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\xff\xff\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\xff\xff\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\xff\xff\xff\xff\xff\xff\x32\x00\x33\x00\x56\x00\x57\x00\x58\x00\x59\x00\x32\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x3e\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\xff\xff\x3e\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\xff\xff\x33\x00\xff\xff\xff\xff\x4f\x00\x37\x00\xff\xff\xff\xff\xff\xff\x54\x00\x55\x00\xff\xff\x3e\x00\x47\x00\x48\x00\x49\x00\x4a\x00\xff\xff\xff\xff\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2e\x00\x2f\x00\x30\x00\xff\xff\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x36\x00\xff\xff\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x2e\x00\x2f\x00\x30\x00\x40\x00\x41\x00\xff\xff\x43\x00\xff\xff\x36\x00\xff\xff\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\xff\xff\x30\x00\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x36\x00\xff\xff\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x31\x00\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\xff\xff\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\xff\xff\x45\x00\x46\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\xff\xff\xff\xff\x40\x00\x41\x00\x36\x00\x43\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3e\x00\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\xff\xff\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\xff\xff\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\xff\xff\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\xff\xff\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\xff\xff\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\xff\xff\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\xff\xff\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\xff\xff\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\xff\xff\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\xff\xff\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\xff\xff\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\xff\xff\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\xff\xff\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\xff\xff\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\xff\xff\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\xff\xff\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\xff\xff\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\xff\xff\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\xff\xff\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\xff\xff\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\xff\xff\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\xff\xff\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\xff\xff\xff\xff\xff\xff\x40\x00\x41\x00\xff\xff\x43\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\xff\xff\x3a\x00\xff\xff\x40\x00\x41\x00\x3a\x00\x43\x00\x40\x00\x41\x00\x3a\x00\x43\x00\x40\x00\x41\x00\x3a\x00\x43\x00\x40\x00\x41\x00\x3a\x00\x43\x00\x40\x00\x41\x00\xff\xff\x43\x00\x40\x00\x41\x00\xff\xff\x43\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"#

happyTable :: HappyAddr
happyTable = HappyA# "\x00\x00\x29\x02\x37\x00\x11\x00\x38\x00\x39\x00\x8e\x01\xbd\x01\x12\x00\x13\x00\x14\x00\xa0\x00\x3a\x00\x3b\x00\x0d\x00\x86\x01\x55\x01\x3c\x00\x92\x00\xa3\x01\x3d\x00\xf3\x01\x57\x00\xcd\x00\x1a\x02\xc3\x01\xa0\x00\x87\x01\x3f\x00\x85\x00\x8c\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x15\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\xf4\x01\x59\x00\x7d\x00\xa1\x00\x56\x01\x4d\x00\xa9\x00\x25\x02\x85\x00\xa4\x01\x4e\x00\x6b\x00\x4f\x00\x1d\x00\x0e\x00\x50\x00\x35\x00\x08\x02\xa1\x00\x1d\x02\x51\x00\x09\x02\xa2\x00\xdd\x01\x5a\x00\xaa\x00\xab\x00\xac\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\xbc\x00\xbd\x00\xbe\x00\x53\x00\xbf\x00\xc0\x00\xc1\x00\xc2\x00\xc3\x00\x20\x00\x11\x00\xa4\x00\x21\x00\x11\x00\xca\x00\x12\x00\x13\x00\x14\x00\x12\x00\x13\x00\x14\x00\x58\x01\x23\x00\x26\x02\xf0\x01\x18\x02\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\x7d\x00\xb6\x01\x5c\x00\xc7\x01\xa2\x00\xa3\x00\xcb\x00\x2a\x00\x2b\x00\xb7\x01\x6f\x00\x5b\x01\x70\x00\x8c\x00\x71\x00\x15\x00\x57\x00\x91\x01\x15\x00\x0e\x02\x2c\x00\x05\x02\x06\x02\x5d\x00\x7f\x00\xab\x01\xf4\x00\xba\x01\xab\x01\x5e\x00\x5c\x01\xf6\x00\x0e\x02\x93\x01\x5f\x00\xa4\x00\x85\x00\x15\x02\xe6\xff\x16\x02\x59\x00\xad\x01\x2f\x00\x14\x02\xad\x01\x60\x00\x80\x01\xed\x01\xf3\x01\x37\x00\x11\x00\x38\x00\x39\x00\xe6\xff\xe6\xff\x12\x00\x13\x00\x14\x00\xcf\x01\x3a\x00\x3b\x00\xb4\x01\xee\x01\x5a\x00\x3c\x00\x79\x00\x67\x00\x3d\x00\xce\x01\x8c\x00\x57\x00\x9a\x01\xf4\x01\xdb\x01\x7d\x00\x3f\x00\xff\xff\xb5\x01\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x15\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x85\x00\xa9\x01\x59\x00\x9d\x00\x9e\x00\x4d\x00\x7c\x01\x7f\x01\x80\x01\x22\x01\x4e\x00\x94\x01\x4f\x00\xaa\x01\x8e\x00\x50\x00\x7d\x00\x7e\x00\x57\x00\xaf\x01\x51\x00\x37\x00\x11\x00\x38\x00\x39\x00\x5a\x00\x52\x00\x12\x00\x13\x00\x14\x00\x19\x02\x3a\x00\x3b\x00\x32\x00\x33\x00\x34\x00\x3c\x00\x7f\x00\x64\x00\x3d\x00\x65\x00\x8a\x00\x59\x00\x66\x00\x67\x00\x8b\x00\x53\x00\x3f\x00\x57\x00\x53\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x15\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\xc7\x00\x5a\x00\x90\x00\x54\x00\x8c\x00\x4d\x00\x1d\x00\x0e\x00\x59\x00\x35\x00\x4e\x00\x91\x00\x4f\x00\x7d\x00\x92\x00\x50\x00\x5d\x01\x62\x00\x57\x00\x91\x01\x51\x00\x93\x00\x37\x00\x11\x00\x38\x00\x39\x00\x52\x00\x85\x00\x12\x00\x13\x00\x14\x00\x5a\x00\x3a\x00\x3b\x00\x92\x01\x93\x01\x69\x00\x3c\x00\xef\x01\x56\x00\x3d\x00\x2a\x01\x59\x00\x57\x00\x7d\x00\xc5\x01\x53\x00\x3e\x00\x3f\x00\x97\x00\x03\x02\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x15\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x5a\x00\xab\x01\x59\x00\x7d\x00\x37\x01\x4d\x00\x7d\x00\x8c\x00\x25\x02\x24\x02\x4e\x00\x9e\x01\x4f\x00\xc9\x01\x83\x00\x50\x00\xac\x01\xad\x01\x9f\x01\x19\x02\x51\x00\x37\x00\x11\x00\x38\x00\x39\x00\x5a\x00\x52\x00\x12\x00\x13\x00\x14\x00\x85\x00\x3a\x00\x3b\x00\x28\x02\x29\x02\x11\x00\x3c\x00\x85\x00\xa0\x01\x3d\x00\x12\x00\x13\x00\x14\x00\x7d\x00\xd2\x01\xa1\x01\x53\x00\x3f\x00\x57\x00\x10\x02\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x15\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x81\x00\x82\x00\x83\x00\x84\x00\xd9\x01\x4d\x00\x7d\x00\x15\x00\x59\x00\x23\x02\x4e\x00\x00\x02\x4f\x00\xf6\xfe\x7d\x00\x50\x00\xf6\xfe\xf6\xfe\x9c\x01\x02\x02\x51\x00\x20\x02\xe5\x01\x82\x00\x83\x00\x85\x00\x52\x00\x11\x02\x03\x02\xe9\x00\xea\x00\x5a\x00\xf6\xfe\xf6\xfe\xf6\xfe\xf6\xfe\xf6\xfe\x7d\x00\xf6\xfe\xf6\xfe\xf6\xfe\xeb\x00\xec\x00\xf6\xfe\xed\x00\xd7\x01\x53\x00\x85\x00\xf6\xfe\xd8\x01\xf6\xfe\xf6\xfe\x30\x01\x31\x01\x04\x02\xf6\xfe\xf6\xfe\xf6\xfe\xf6\xfe\xf6\xfe\xf6\xfe\xf6\xfe\xf6\xfe\xf6\xfe\xf6\xfe\xf6\xfe\xf6\xfe\xf6\xfe\xf6\xfe\xf6\xfe\xf6\xfe\xf6\xfe\xf6\xfe\xf6\xfe\xf6\xfe\xf6\xfe\xf6\xfe\xf6\xfe\x0c\x02\xf6\xfe\xf6\xfe\xf6\xfe\xf6\xfe\xf6\xfe\xf6\xfe\x11\x00\x34\x01\x35\x01\x73\x00\x11\x00\x12\x00\x13\x00\x75\x00\x76\x00\x12\x00\x13\x00\x14\x00\x11\x00\x87\x00\x82\x00\x83\x00\x88\x00\x12\x00\x13\x00\x14\x00\x5c\x00\x77\x00\xb8\x01\xa4\x01\x5c\x00\x10\x02\x98\x01\xbf\x01\x7e\x01\x5f\x01\xb9\x01\x6f\x00\x5c\x00\x70\x00\xbc\x01\x71\x00\x15\x00\x57\x00\x85\x00\x9a\x01\x15\x00\x5d\x00\x98\x01\x99\x01\xd9\x01\x5d\x00\x7d\x00\x5e\x00\x15\x00\xdd\x01\xd3\x01\x5e\x00\x5f\x00\x5d\x00\x57\x00\x9a\x01\x5f\x00\xf7\x01\x31\x01\x5e\x00\xfa\x01\x59\x00\xda\x01\x60\x00\x5f\x00\x7c\x00\x0c\x01\x60\x00\x16\x01\xc5\x01\xc8\x01\x82\x00\x83\x00\x20\x00\x11\x00\x60\x00\x21\x00\x95\x00\x59\x00\x12\x00\x13\x00\x14\x00\xa2\x01\x9f\x01\x5a\x00\x22\x00\x23\x00\x24\x00\xfe\x01\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2d\x01\x85\x00\x37\x01\x36\x01\x9b\x00\x11\x00\x38\x01\x5a\x00\x2a\x00\x2b\x00\x12\x00\x13\x00\x14\x00\xd4\x01\x33\x00\x34\x00\x15\x00\x20\x00\x11\x00\xcd\x00\x21\x00\x2c\x00\x39\x01\x12\x00\x13\x00\x14\x00\x3a\x01\xf4\x00\xf5\x00\x22\x00\x23\x00\x24\x00\xf6\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x56\x00\xa5\x01\xa1\x01\x15\x00\x57\x00\x2f\x00\x58\x00\x83\x01\x2a\x00\x2b\x00\x5a\x01\x84\x01\x1d\x00\x0e\x00\x9c\x00\x35\x00\x15\x00\x20\x00\x11\x00\x9d\x00\x21\x00\x2c\x00\xa7\x01\x12\x00\x13\x00\x14\x00\xa8\x01\xf4\x00\x59\x00\x22\x00\x23\x00\x24\x00\xf6\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x8e\x00\xcb\x01\x82\x00\x83\x00\x57\x00\x2f\x00\x5e\x01\x5f\x01\x2a\x00\x2b\x00\x64\x01\x1d\x00\x0e\x00\x5a\x00\x98\x00\x99\x00\x15\x00\x20\x00\x11\x00\x65\x01\x21\x00\x2c\x00\x66\x01\x12\x00\x13\x00\x14\x00\x85\x00\x2d\x00\x59\x00\x22\x00\x23\x00\x24\x00\x2e\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x60\x00\xea\x01\x33\x00\x34\x00\x57\x00\x2f\x00\x67\x01\x68\x01\x2a\x00\x2b\x00\x69\x01\xeb\x00\x1b\x02\x5a\x00\x2a\x01\x6a\x01\x15\x00\x20\x00\x11\x00\x6b\x01\x21\x00\x2c\x00\x6c\x01\x12\x00\x13\x00\x14\x00\x6d\x01\x2d\x00\x59\x00\x22\x00\x23\x00\x24\x00\xf6\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x1d\x00\x0e\x00\x6e\x01\x35\x00\x6f\x01\x2f\x00\x70\x01\x71\x01\x2a\x00\x2b\x00\x85\x01\x20\x00\x11\x00\x5a\x00\x21\x00\x72\x01\x15\x00\x12\x00\x13\x00\x14\x00\x73\x01\x2c\x00\xeb\x00\xec\x00\x23\x00\x2a\x01\x74\x01\x2d\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2e\x00\xc3\x00\x75\x01\x76\x01\x32\x00\x33\x00\x34\x00\x77\x01\x2a\x00\x2b\x00\xc4\x00\x2f\x00\x78\x01\xc5\x00\x79\x01\x7a\x01\x15\x00\x20\x00\x11\x00\x7b\x01\x21\x00\x2c\x00\x7d\x01\x12\x00\x13\x00\x14\x00\x96\x01\xf4\x00\x2f\x01\xa6\x01\x23\x00\xae\x01\xf6\x00\xb1\x01\x26\x00\x27\x00\x28\x00\x29\x00\xcc\x01\x82\x00\x83\x00\x1d\x00\x0e\x00\x2f\x00\x35\x00\xb3\x01\x2a\x00\x2b\x00\xb6\x01\x20\x00\x11\x00\xff\xff\x21\x00\x79\x00\x15\x00\x12\x00\x13\x00\x14\x00\x78\x00\x2c\x00\x8e\x00\x92\x00\x23\x00\x85\x00\xff\xff\xf4\x00\x26\x00\x27\x00\x28\x00\x29\x00\xf6\x00\x8d\x01\xe2\x01\xe3\x01\xe4\x01\xe5\x01\x82\x00\x83\x00\x2a\x00\x2b\x00\xff\xff\x2f\x00\x20\x00\x11\x00\xcd\x00\x21\x00\x15\x00\xfb\x01\x12\x00\x13\x00\x14\x00\x2c\x00\x7d\x00\x1d\x00\x0e\x00\x23\x00\xf8\x00\xf4\x00\x04\x01\x26\x00\x85\x00\xff\xff\xf6\x00\x20\x00\x11\x00\x04\x01\x21\x00\xd4\x00\x23\x01\x12\x00\x13\x00\x14\x00\x11\x01\x2f\x00\x1d\x00\x0e\x00\x23\x00\xf8\x00\xff\xff\x15\x00\x26\x00\xfe\x01\x6c\x00\x6d\x00\xfa\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\x0d\x00\xf4\x00\x6e\x00\x6f\x00\x3e\x00\x70\x00\xf6\x00\x71\x00\x56\x00\x57\x00\x64\x00\x15\x00\x24\x01\x6b\x00\x6c\x00\x6d\x00\x06\x01\x2f\x00\x1d\x00\x0e\x00\x00\x00\xf8\x00\xf4\x00\x6e\x00\x6f\x00\x00\x00\x70\x00\xf6\x00\x71\x00\x00\x00\x57\x00\x1e\x02\x00\x00\x59\x00\x32\x00\x33\x00\x34\x00\x11\x00\x2f\x00\x00\x00\x73\x00\x74\x00\x12\x00\x13\x00\x75\x00\x76\x00\x00\x00\x00\x00\xbc\x01\x6f\x00\x00\x00\x70\x00\x00\x00\x71\x00\x59\x00\x57\x00\x5a\x00\x5c\x00\x77\x00\x00\x00\x11\x00\x1d\x00\x0e\x00\x73\x00\xae\x01\x12\x00\x13\x00\x75\x00\x76\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x15\x00\x35\x00\x00\x00\x00\x00\x5a\x00\x5d\x00\x59\x00\x5c\x00\x77\x00\x00\x00\x00\x00\x5e\x00\x11\x00\x00\x00\x00\x00\x11\x00\x5f\x00\x12\x00\x13\x00\x14\x00\x12\x00\x13\x00\x14\x00\x15\x00\x01\x01\x02\x01\x00\x00\x60\x00\x5d\x00\x5a\x00\x1d\x00\x0e\x00\x5c\x00\xf8\x00\x5e\x00\x5c\x00\x00\x00\x00\x00\x11\x00\x5f\x00\x25\x01\x69\x00\x00\x00\x12\x00\x13\x00\x14\x00\x1d\x00\x0e\x00\x15\x00\xf8\x00\x60\x00\x15\x00\x00\x00\x5d\x00\x26\x01\x00\x00\x5d\x00\x00\x00\x5c\x00\x5e\x00\x1d\x00\x0e\x00\x5e\x00\xf8\x00\x5f\x00\x0d\x02\x11\x00\x5f\x00\xc7\x01\x00\x00\x00\x00\x12\x00\x13\x00\x14\x00\x15\x00\x60\x00\x11\x00\x00\x00\x60\x00\x5d\x00\x00\x00\x12\x00\x13\x00\x14\x00\x00\x00\x5e\x00\x0d\x00\x0e\x00\x14\x02\x11\x00\x5f\x00\x28\x01\x00\x00\x00\x00\x12\x00\x13\x00\x14\x00\x1d\x00\x0e\x00\x11\x00\xf8\x00\x60\x00\x15\x00\x00\x00\x12\x00\x13\x00\x14\x00\x5d\x00\x00\x00\x5c\x00\x00\x00\x00\x00\x15\x00\x5e\x00\x11\x00\x00\x00\x00\x00\x5d\x00\x5f\x00\x12\x00\x13\x00\x14\x00\x13\x02\x5e\x00\x00\x00\x15\x00\x00\x00\x00\x00\x5f\x00\x60\x00\x5d\x00\x00\x00\xbf\x01\x00\x00\x00\x00\x15\x00\x5e\x00\x11\x00\x00\x00\x60\x00\x5d\x00\x5f\x00\x12\x00\x13\x00\x14\x00\x00\x00\x5e\x00\x00\x00\x7d\x00\x00\x00\x15\x00\x5f\x00\x60\x00\x00\x00\x11\x00\xe0\x01\x00\x00\x00\x00\x11\x00\x12\x00\x13\x00\x14\x00\x60\x00\x12\x00\x13\x00\x14\x00\x00\x00\x1d\x02\x00\x00\x60\x01\x61\x01\x62\x01\x00\x00\x15\x00\x63\x01\x11\x00\x00\x00\x00\x00\x5d\x00\x00\x00\x12\x00\x13\x00\x14\x00\xc7\x00\x5e\x00\xe9\x01\x32\x00\x33\x00\x34\x00\x5f\x00\x15\x00\x00\x00\x11\x00\xed\x01\x15\x00\x5d\x00\x00\x00\x12\x00\x13\x00\x14\x00\x60\x00\x5e\x00\x0d\x00\x0e\x00\xb1\x01\x9c\x01\x5f\x00\x0d\x00\x0e\x00\x14\x01\x82\x01\x15\x00\x00\x00\x11\x00\xc1\x01\x00\x00\x5d\x00\x60\x00\x12\x00\x13\x00\x14\x00\x00\x00\x5e\x00\x1d\x00\x0e\x00\xf7\x00\x35\x00\x5f\x00\x15\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x5d\x00\xf8\x00\x90\x01\x11\x00\x00\x00\x60\x00\x5e\x00\x00\x00\x12\x00\x13\x00\x14\x00\x5f\x00\x11\x00\x00\x00\x00\x00\x98\x01\x15\x00\x12\x00\x13\x00\x14\x00\x21\x02\x5d\x00\x60\x00\x32\x00\x33\x00\x34\x00\x00\x00\x5e\x00\x87\x00\x11\x00\x00\x00\x00\x00\x5f\x00\x00\x00\x12\x00\x13\x00\x14\x00\xa6\x00\x00\x00\x15\x00\x32\x00\x33\x00\x34\x00\x60\x00\x5d\x00\x8a\x00\xa7\x00\x00\x00\x15\x00\x5c\x00\x5e\x00\x11\x00\x00\x00\x5d\x00\x00\x00\x5f\x00\x12\x00\x13\x00\x14\x00\x5e\x00\x1d\x00\x0e\x00\x00\x00\x35\x00\x5f\x00\x15\x00\x60\x00\x11\x00\x35\xff\x00\x00\x5d\x00\x00\x00\x12\x00\x13\x00\x14\x00\x60\x00\x5e\x00\x1d\x00\x0e\x00\x11\x00\x35\x00\x5f\x00\x00\x00\x00\x00\x12\x00\x13\x00\x14\x00\x15\x00\x11\x00\x00\x00\xfa\x00\x00\x00\x60\x00\x12\x00\x13\x00\x14\x00\x1d\x00\x0e\x00\x9c\x01\xf8\x00\x0d\x00\x0e\x00\x0f\x00\x15\x00\x00\x00\x00\x00\x00\x00\xd1\x01\x5d\x00\x00\x00\x37\x00\x11\x00\x38\x00\x39\x00\x5e\x00\x15\x00\x12\x00\x13\x00\x14\x00\x5f\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x15\x00\x3c\x00\x9c\x01\x00\x00\x3d\x00\x00\x00\x60\x00\x7a\x00\x6f\x00\x00\x00\x70\x00\x9d\x01\x71\x00\x00\x00\x57\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x15\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\xc1\x01\x00\x00\x70\x00\x00\x00\x71\x00\x4d\x00\x57\x00\x00\x00\x00\x00\x59\x00\x4e\x00\x00\x00\x4f\x00\x00\x00\xc2\x01\x50\x00\x70\x00\x00\x00\x71\x00\x11\x00\x57\x00\x00\x00\x11\x00\x00\x00\x12\x00\x13\x00\x14\x00\x12\x00\x13\x00\x14\x00\x59\x00\x00\x00\x5a\x00\x11\x00\x00\x00\x00\x00\xfb\x00\x00\x00\x12\x00\x13\x00\x14\x00\x11\x00\x1d\x00\x0e\x00\x59\x00\xf8\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x2f\x00\x00\x00\x5a\x00\x00\x00\x15\x00\x00\x00\x00\x00\x15\x00\x30\x00\x31\x00\x32\x01\x33\x01\x32\x00\x33\x00\x34\x00\x00\x00\x5a\x00\x00\x00\x15\x00\x00\x00\x00\x00\x2c\x01\x07\x01\x00\x00\x81\x00\x00\x00\x15\x00\x00\x00\x00\x00\x08\x01\x09\x01\x0a\x01\x0b\x01\x0c\x01\x0d\x01\xa6\x00\x00\x00\x00\x00\xf2\xfe\x0e\x01\x00\x00\x00\x00\x00\x00\xef\x00\x0f\x01\x10\x01\x00\x00\x00\x00\xf2\xfe\x1d\x00\x0e\x00\x00\x00\x35\x00\xf2\xfe\xf2\xfe\xf2\xfe\xf2\xfe\xf2\xfe\xf2\xfe\xf2\xfe\xf2\xfe\x00\x00\x00\x00\x00\x02\x00\x00\xf2\xfe\x32\x00\x33\x00\x34\x00\x00\x00\xf2\xfe\xf2\xfe\xc7\x00\xc8\x00\xc9\x00\x32\x00\x33\x00\x34\x00\x00\x00\x00\x00\x06\x02\x00\x00\xf2\xfe\x32\x00\x33\x00\x34\x00\x11\x02\x00\x00\x00\x00\x32\x00\x33\x00\x34\x00\xd1\x01\x58\x01\x11\x00\x32\x00\x33\x00\x34\x00\x00\x00\x12\x00\x13\x00\x14\x00\x00\x00\x1d\x00\x0e\x00\xde\x01\x35\x00\x00\x00\x32\x00\x33\x00\x34\x00\x00\x00\x1d\x00\x0e\x00\xe0\x01\x35\x00\x00\x00\x32\x00\x33\x00\x34\x00\x1d\x00\x0e\x00\x00\x00\x35\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x35\x00\x15\x00\x00\x00\x1d\x00\x0e\x00\xe1\x01\x35\x00\x00\x00\x32\x00\x33\x00\x34\x00\x0a\x01\x0b\x01\x0c\x01\x0d\x01\x00\x00\x1d\x00\x0e\x00\xe6\x01\x35\x00\x00\x00\x32\x00\x33\x00\x34\x00\x00\x00\x1d\x00\x0e\x00\xe7\x01\x35\x00\x00\x00\x32\x00\x33\x00\x34\x00\xe8\x01\x00\x00\x00\x00\x32\x00\x33\x00\x34\x00\xeb\x01\x00\x00\x00\x00\x32\x00\x33\x00\x34\x00\x1d\x00\x0e\x00\x96\x01\x35\x00\x00\x00\x32\x00\x33\x00\x34\x00\x00\x00\x3a\x01\x33\x00\x34\x00\x00\x00\x1d\x00\x0e\x00\x61\x00\x35\x00\x00\x00\x32\x00\x33\x00\x34\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x35\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x35\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x35\x00\x3b\x01\x33\x00\x34\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x35\x00\x1d\x00\x0e\x00\x00\x00\x35\x00\x3c\x01\x33\x00\x34\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x35\x00\x3d\x01\x33\x00\x34\x00\x00\x00\x3e\x01\x33\x00\x34\x00\x00\x00\x3f\x01\x33\x00\x34\x00\x00\x00\x40\x01\x33\x00\x34\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x35\x00\x41\x01\x33\x00\x34\x00\x00\x00\x42\x01\x33\x00\x34\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x35\x00\x43\x01\x33\x00\x34\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x35\x00\x1d\x00\x0e\x00\x00\x00\x35\x00\x1d\x00\x0e\x00\x00\x00\x35\x00\x1d\x00\x0e\x00\x00\x00\x35\x00\x44\x01\x33\x00\x34\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x35\x00\x1d\x00\x0e\x00\x00\x00\x35\x00\x45\x01\x33\x00\x34\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x35\x00\x46\x01\x33\x00\x34\x00\x00\x00\x47\x01\x33\x00\x34\x00\x00\x00\x48\x01\x33\x00\x34\x00\x00\x00\x49\x01\x33\x00\x34\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x35\x00\x4a\x01\x33\x00\x34\x00\x00\x00\x4b\x01\x33\x00\x34\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x35\x00\x4c\x01\x33\x00\x34\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x35\x00\x1d\x00\x0e\x00\x00\x00\x35\x00\x1d\x00\x0e\x00\x00\x00\x35\x00\x1d\x00\x0e\x00\x00\x00\x35\x00\x4d\x01\x33\x00\x34\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x35\x00\x1d\x00\x0e\x00\x00\x00\x35\x00\x4e\x01\x33\x00\x34\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x35\x00\x4f\x01\x33\x00\x34\x00\x00\x00\x50\x01\x33\x00\x34\x00\x00\x00\x51\x01\x33\x00\x34\x00\x00\x00\x52\x01\x33\x00\x34\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x35\x00\x53\x01\x33\x00\x34\x00\x00\x00\x96\x00\x33\x00\x34\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x35\x00\x95\x00\x33\x00\x34\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x35\x00\x1d\x00\x0e\x00\x00\x00\x35\x00\x1d\x00\x0e\x00\x00\x00\x35\x00\x1d\x00\x0e\x00\xfb\x01\x35\x00\x96\x00\x33\x00\x34\x00\x00\x00\x1d\x00\x0e\x00\xfc\x00\x35\x00\x1d\x00\x0e\x00\x00\x00\x35\x00\x1d\x00\x0e\x00\x00\x00\xf8\x00\x07\x01\x1d\x00\x0e\x00\x00\x00\x35\x00\x00\x00\x00\x00\x08\x01\x09\x01\x0a\x01\x0b\x01\x0c\x01\x0d\x01\x00\x00\x00\x00\x00\x00\xcf\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x35\x00\xd0\x00\xd1\x00\xd2\x00\xd3\x00\xd4\x00\xd5\x00\xd6\x00\xd7\x00\xd8\x00\xd9\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xe3\x00\xe4\x00\xfd\x01\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xe9\x00\x2a\x01\x00\x00\x00\x00\x00\x00\x1f\x02\xe4\x01\xe5\x01\x82\x00\x83\x00\x00\x00\x00\x00\x00\x00\x07\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x07\x01\x08\x01\x09\x01\x0a\x01\x0b\x01\x0c\x01\x0d\x01\x08\x01\x09\x01\x0a\x01\x0b\x01\x0c\x01\x0d\x01\x85\x00\xd0\x00\xd1\x00\xd2\x00\xd3\x00\xd4\x00\xd5\x00\xd6\x00\x00\x00\xd8\x00\xd9\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xe3\x00\xe4\x00\x00\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xe9\x00\xd0\x00\xd1\x00\xd2\x00\xd3\x00\xd4\x00\xd5\x00\xd6\x00\x00\x00\x00\x00\xd9\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xe3\x00\xe4\x00\x00\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xe9\x00\xd0\x00\xd1\x00\xd2\x00\xd3\x00\xd4\x00\xd5\x00\xd6\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xe3\x00\xe4\x00\x00\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xe9\x00\xd0\x00\xd1\x00\xd2\x00\xd3\x00\xd4\x00\xd5\x00\xd6\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe1\x00\xe2\x00\xe3\x00\xe4\x00\x00\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xe9\x00\xd0\x00\xd1\x00\xd2\x00\xd3\x00\xd4\x00\xd5\x00\xd0\x00\xd1\x00\xd2\x00\xd3\x00\xd4\x00\xd5\x00\x00\x00\x00\x00\x00\x00\x32\x01\x33\x01\xe1\x00\xe2\x00\xe3\x00\xe4\x00\xd6\x01\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xe9\x00\x07\x01\xe5\x00\xe6\x00\xe7\x00\xe8\x00\x00\x00\x07\x01\x08\x01\x09\x01\x0a\x01\x0b\x01\x0c\x01\x0d\x01\x08\x01\x09\x01\x0a\x01\x0b\x01\x0c\x01\x0d\x01\x07\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x01\x09\x01\x0a\x01\x0b\x01\x0c\x01\x0d\x01\x00\x00\x33\x01\x00\x00\x00\x00\x0e\x01\xdb\x01\x00\x00\x00\x00\x00\x00\x0f\x01\x10\x01\x00\x00\x07\x01\xd2\x00\xd3\x00\xd4\x00\xd5\x00\x00\x00\x00\x00\x08\x01\x09\x01\x0a\x01\x0b\x01\x0c\x01\x0d\x01\x00\x00\x00\x00\x00\x00\x00\x00\x93\x01\x16\x00\x17\x00\x00\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\x18\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x1c\x00\x15\x00\x16\x00\x17\x00\x1d\x00\x0e\x00\x00\x00\x1e\x00\x00\x00\x18\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x1c\x00\x00\x00\x12\x01\x00\x00\x1d\x00\x0e\x00\x00\x00\x1e\x00\x18\x00\x00\x00\x13\x01\x1a\x00\x1b\x00\x00\x00\x1c\x00\xf0\x01\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x1e\x00\xf1\x01\x1a\x00\x1b\x00\x00\x00\x1c\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x1e\x00\x87\x01\x1a\x00\x1b\x00\x00\x00\x1c\x00\x88\x01\x00\x00\x00\x00\x1d\x00\x89\x01\x00\x00\x1e\x00\x00\x00\x8a\x01\x8b\x01\xef\x00\xf0\x00\xf1\x00\x1a\x00\x1b\x00\x00\x00\x1c\x00\xf2\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\xf4\x01\x1e\x00\xf5\x01\x1a\x00\x1b\x00\x00\x00\x1c\x00\x07\x01\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x1e\x00\x08\x01\x09\x01\x0a\x01\x0b\x01\x0c\x01\x0d\x01\x2d\x01\x1a\x00\x1b\x00\x00\x00\x1c\x00\xf2\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x1e\x00\xf1\x01\x1a\x00\x1b\x00\x00\x00\x1c\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x1e\x00\x07\x02\x1a\x00\x1b\x00\x00\x00\x1c\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x1e\x00\x0a\x02\x1a\x00\x1b\x00\x00\x00\x1c\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x1e\x00\xca\x01\x1a\x00\x1b\x00\x00\x00\x1c\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x1e\x00\xcd\x01\x1a\x00\x1b\x00\x00\x00\x1c\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x1e\x00\xf7\x01\x1a\x00\x1b\x00\x00\x00\x1c\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x1e\x00\xf8\x01\x1a\x00\x1b\x00\x00\x00\x1c\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x1e\x00\x16\x01\x1a\x00\x1b\x00\x00\x00\x1c\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x1e\x00\x17\x01\x1a\x00\x1b\x00\x00\x00\x1c\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x1e\x00\x18\x01\x1a\x00\x1b\x00\x00\x00\x1c\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x1e\x00\x19\x01\x1a\x00\x1b\x00\x00\x00\x1c\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x1e\x00\x1a\x01\x1a\x00\x1b\x00\x00\x00\x1c\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x1e\x00\x1b\x01\x1a\x00\x1b\x00\x00\x00\x1c\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x1e\x00\x1c\x01\x1a\x00\x1b\x00\x00\x00\x1c\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x1e\x00\x1d\x01\x1a\x00\x1b\x00\x00\x00\x1c\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x1e\x00\x1e\x01\x1a\x00\x1b\x00\x00\x00\x1c\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x1e\x00\x1f\x01\x1a\x00\x1b\x00\x00\x00\x1c\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x1e\x00\x20\x01\x1a\x00\x1b\x00\x00\x00\x1c\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x1e\x00\x21\x01\x1a\x00\x1b\x00\x00\x00\x1c\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x1e\x00\x27\x01\x1a\x00\x1b\x00\x00\x00\x1c\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x1e\x00\x54\x01\x1a\x00\x1b\x00\x00\x00\x1c\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x1e\x00\x8d\x01\x1a\x00\x1b\x00\x00\x00\x1c\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x1e\x00\xf6\x00\x1a\x00\x1b\x00\x00\x00\x1c\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x0e\x00\x00\x00\x1e\x00\x11\x01\x1a\x00\x1b\x00\x00\x00\x1c\x00\x00\x00\xfd\x00\x00\x00\x1d\x00\x0e\x00\xfe\x00\x1e\x00\x1d\x00\x0e\x00\xff\x00\xf8\x00\x1d\x00\x0e\x00\x00\x01\xf8\x00\x1d\x00\x0e\x00\x04\x01\xf8\x00\x1d\x00\x0e\x00\x00\x00\xf8\x00\x1d\x00\x0e\x00\x00\x00\xf8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"#

happyReduceArr = Happy_Data_Array.array (11, 299) [
	(11 , happyReduce_11),
	(12 , happyReduce_12),
	(13 , happyReduce_13),
	(14 , happyReduce_14),
	(15 , happyReduce_15),
	(16 , happyReduce_16),
	(17 , happyReduce_17),
	(18 , happyReduce_18),
	(19 , happyReduce_19),
	(20 , happyReduce_20),
	(21 , happyReduce_21),
	(22 , happyReduce_22),
	(23 , happyReduce_23),
	(24 , happyReduce_24),
	(25 , happyReduce_25),
	(26 , happyReduce_26),
	(27 , happyReduce_27),
	(28 , happyReduce_28),
	(29 , happyReduce_29),
	(30 , happyReduce_30),
	(31 , happyReduce_31),
	(32 , happyReduce_32),
	(33 , happyReduce_33),
	(34 , happyReduce_34),
	(35 , happyReduce_35),
	(36 , happyReduce_36),
	(37 , happyReduce_37),
	(38 , happyReduce_38),
	(39 , happyReduce_39),
	(40 , happyReduce_40),
	(41 , happyReduce_41),
	(42 , happyReduce_42),
	(43 , happyReduce_43),
	(44 , happyReduce_44),
	(45 , happyReduce_45),
	(46 , happyReduce_46),
	(47 , happyReduce_47),
	(48 , happyReduce_48),
	(49 , happyReduce_49),
	(50 , happyReduce_50),
	(51 , happyReduce_51),
	(52 , happyReduce_52),
	(53 , happyReduce_53),
	(54 , happyReduce_54),
	(55 , happyReduce_55),
	(56 , happyReduce_56),
	(57 , happyReduce_57),
	(58 , happyReduce_58),
	(59 , happyReduce_59),
	(60 , happyReduce_60),
	(61 , happyReduce_61),
	(62 , happyReduce_62),
	(63 , happyReduce_63),
	(64 , happyReduce_64),
	(65 , happyReduce_65),
	(66 , happyReduce_66),
	(67 , happyReduce_67),
	(68 , happyReduce_68),
	(69 , happyReduce_69),
	(70 , happyReduce_70),
	(71 , happyReduce_71),
	(72 , happyReduce_72),
	(73 , happyReduce_73),
	(74 , happyReduce_74),
	(75 , happyReduce_75),
	(76 , happyReduce_76),
	(77 , happyReduce_77),
	(78 , happyReduce_78),
	(79 , happyReduce_79),
	(80 , happyReduce_80),
	(81 , happyReduce_81),
	(82 , happyReduce_82),
	(83 , happyReduce_83),
	(84 , happyReduce_84),
	(85 , happyReduce_85),
	(86 , happyReduce_86),
	(87 , happyReduce_87),
	(88 , happyReduce_88),
	(89 , happyReduce_89),
	(90 , happyReduce_90),
	(91 , happyReduce_91),
	(92 , happyReduce_92),
	(93 , happyReduce_93),
	(94 , happyReduce_94),
	(95 , happyReduce_95),
	(96 , happyReduce_96),
	(97 , happyReduce_97),
	(98 , happyReduce_98),
	(99 , happyReduce_99),
	(100 , happyReduce_100),
	(101 , happyReduce_101),
	(102 , happyReduce_102),
	(103 , happyReduce_103),
	(104 , happyReduce_104),
	(105 , happyReduce_105),
	(106 , happyReduce_106),
	(107 , happyReduce_107),
	(108 , happyReduce_108),
	(109 , happyReduce_109),
	(110 , happyReduce_110),
	(111 , happyReduce_111),
	(112 , happyReduce_112),
	(113 , happyReduce_113),
	(114 , happyReduce_114),
	(115 , happyReduce_115),
	(116 , happyReduce_116),
	(117 , happyReduce_117),
	(118 , happyReduce_118),
	(119 , happyReduce_119),
	(120 , happyReduce_120),
	(121 , happyReduce_121),
	(122 , happyReduce_122),
	(123 , happyReduce_123),
	(124 , happyReduce_124),
	(125 , happyReduce_125),
	(126 , happyReduce_126),
	(127 , happyReduce_127),
	(128 , happyReduce_128),
	(129 , happyReduce_129),
	(130 , happyReduce_130),
	(131 , happyReduce_131),
	(132 , happyReduce_132),
	(133 , happyReduce_133),
	(134 , happyReduce_134),
	(135 , happyReduce_135),
	(136 , happyReduce_136),
	(137 , happyReduce_137),
	(138 , happyReduce_138),
	(139 , happyReduce_139),
	(140 , happyReduce_140),
	(141 , happyReduce_141),
	(142 , happyReduce_142),
	(143 , happyReduce_143),
	(144 , happyReduce_144),
	(145 , happyReduce_145),
	(146 , happyReduce_146),
	(147 , happyReduce_147),
	(148 , happyReduce_148),
	(149 , happyReduce_149),
	(150 , happyReduce_150),
	(151 , happyReduce_151),
	(152 , happyReduce_152),
	(153 , happyReduce_153),
	(154 , happyReduce_154),
	(155 , happyReduce_155),
	(156 , happyReduce_156),
	(157 , happyReduce_157),
	(158 , happyReduce_158),
	(159 , happyReduce_159),
	(160 , happyReduce_160),
	(161 , happyReduce_161),
	(162 , happyReduce_162),
	(163 , happyReduce_163),
	(164 , happyReduce_164),
	(165 , happyReduce_165),
	(166 , happyReduce_166),
	(167 , happyReduce_167),
	(168 , happyReduce_168),
	(169 , happyReduce_169),
	(170 , happyReduce_170),
	(171 , happyReduce_171),
	(172 , happyReduce_172),
	(173 , happyReduce_173),
	(174 , happyReduce_174),
	(175 , happyReduce_175),
	(176 , happyReduce_176),
	(177 , happyReduce_177),
	(178 , happyReduce_178),
	(179 , happyReduce_179),
	(180 , happyReduce_180),
	(181 , happyReduce_181),
	(182 , happyReduce_182),
	(183 , happyReduce_183),
	(184 , happyReduce_184),
	(185 , happyReduce_185),
	(186 , happyReduce_186),
	(187 , happyReduce_187),
	(188 , happyReduce_188),
	(189 , happyReduce_189),
	(190 , happyReduce_190),
	(191 , happyReduce_191),
	(192 , happyReduce_192),
	(193 , happyReduce_193),
	(194 , happyReduce_194),
	(195 , happyReduce_195),
	(196 , happyReduce_196),
	(197 , happyReduce_197),
	(198 , happyReduce_198),
	(199 , happyReduce_199),
	(200 , happyReduce_200),
	(201 , happyReduce_201),
	(202 , happyReduce_202),
	(203 , happyReduce_203),
	(204 , happyReduce_204),
	(205 , happyReduce_205),
	(206 , happyReduce_206),
	(207 , happyReduce_207),
	(208 , happyReduce_208),
	(209 , happyReduce_209),
	(210 , happyReduce_210),
	(211 , happyReduce_211),
	(212 , happyReduce_212),
	(213 , happyReduce_213),
	(214 , happyReduce_214),
	(215 , happyReduce_215),
	(216 , happyReduce_216),
	(217 , happyReduce_217),
	(218 , happyReduce_218),
	(219 , happyReduce_219),
	(220 , happyReduce_220),
	(221 , happyReduce_221),
	(222 , happyReduce_222),
	(223 , happyReduce_223),
	(224 , happyReduce_224),
	(225 , happyReduce_225),
	(226 , happyReduce_226),
	(227 , happyReduce_227),
	(228 , happyReduce_228),
	(229 , happyReduce_229),
	(230 , happyReduce_230),
	(231 , happyReduce_231),
	(232 , happyReduce_232),
	(233 , happyReduce_233),
	(234 , happyReduce_234),
	(235 , happyReduce_235),
	(236 , happyReduce_236),
	(237 , happyReduce_237),
	(238 , happyReduce_238),
	(239 , happyReduce_239),
	(240 , happyReduce_240),
	(241 , happyReduce_241),
	(242 , happyReduce_242),
	(243 , happyReduce_243),
	(244 , happyReduce_244),
	(245 , happyReduce_245),
	(246 , happyReduce_246),
	(247 , happyReduce_247),
	(248 , happyReduce_248),
	(249 , happyReduce_249),
	(250 , happyReduce_250),
	(251 , happyReduce_251),
	(252 , happyReduce_252),
	(253 , happyReduce_253),
	(254 , happyReduce_254),
	(255 , happyReduce_255),
	(256 , happyReduce_256),
	(257 , happyReduce_257),
	(258 , happyReduce_258),
	(259 , happyReduce_259),
	(260 , happyReduce_260),
	(261 , happyReduce_261),
	(262 , happyReduce_262),
	(263 , happyReduce_263),
	(264 , happyReduce_264),
	(265 , happyReduce_265),
	(266 , happyReduce_266),
	(267 , happyReduce_267),
	(268 , happyReduce_268),
	(269 , happyReduce_269),
	(270 , happyReduce_270),
	(271 , happyReduce_271),
	(272 , happyReduce_272),
	(273 , happyReduce_273),
	(274 , happyReduce_274),
	(275 , happyReduce_275),
	(276 , happyReduce_276),
	(277 , happyReduce_277),
	(278 , happyReduce_278),
	(279 , happyReduce_279),
	(280 , happyReduce_280),
	(281 , happyReduce_281),
	(282 , happyReduce_282),
	(283 , happyReduce_283),
	(284 , happyReduce_284),
	(285 , happyReduce_285),
	(286 , happyReduce_286),
	(287 , happyReduce_287),
	(288 , happyReduce_288),
	(289 , happyReduce_289),
	(290 , happyReduce_290),
	(291 , happyReduce_291),
	(292 , happyReduce_292),
	(293 , happyReduce_293),
	(294 , happyReduce_294),
	(295 , happyReduce_295),
	(296 , happyReduce_296),
	(297 , happyReduce_297),
	(298 , happyReduce_298),
	(299 , happyReduce_299)
	]

happy_n_terms = 97 :: Int
happy_n_nonterms = 71 :: Int

happyReduce_11 = happyReduce 6# 0# happyReduction_11
happyReduction_11 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut80 happy_x_2 of { happy_var_2 -> 
	case happyOut15 happy_x_5 of { happy_var_5 -> 
	happyIn14
		 (let (is,ts) = happy_var_5 in Module happy_var_2 is ts
	) `HappyStk` happyRest}}

happyReduce_12 = happySpecReduce_3  0# happyReduction_12
happyReduction_12 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut15 happy_x_2 of { happy_var_2 -> 
	happyIn14
		 (let { (is,ts) = happy_var_2
            -- XXX make a location from is and ts
          ; modName = Located { srcRange = emptyRange
                              , thing    = ModName ["Main"]
                              }
          } in Module modName is ts
	)}

happyReduce_13 = happySpecReduce_3  1# happyReduction_13
happyReduction_13 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut16 happy_x_1 of { happy_var_1 -> 
	case happyOut25 happy_x_3 of { happy_var_3 -> 
	happyIn15
		 ((reverse happy_var_1, reverse happy_var_3)
	)}}

happyReduce_14 = happySpecReduce_3  1# happyReduction_14
happyReduction_14 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut16 happy_x_1 of { happy_var_1 -> 
	case happyOut25 happy_x_3 of { happy_var_3 -> 
	happyIn15
		 ((reverse happy_var_1, reverse happy_var_3)
	)}}

happyReduce_15 = happySpecReduce_1  1# happyReduction_15
happyReduction_15 happy_x_1
	 =  case happyOut16 happy_x_1 of { happy_var_1 -> 
	happyIn15
		 ((reverse happy_var_1, [])
	)}

happyReduce_16 = happySpecReduce_1  1# happyReduction_16
happyReduction_16 happy_x_1
	 =  case happyOut25 happy_x_1 of { happy_var_1 -> 
	happyIn15
		 (([], reverse happy_var_1)
	)}

happyReduce_17 = happySpecReduce_0  1# happyReduction_17
happyReduction_17  =  happyIn15
		 (([], [])
	)

happyReduce_18 = happySpecReduce_3  2# happyReduction_18
happyReduction_18 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut16 happy_x_1 of { happy_var_1 -> 
	case happyOut17 happy_x_3 of { happy_var_3 -> 
	happyIn16
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_19 = happySpecReduce_3  2# happyReduction_19
happyReduction_19 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut16 happy_x_1 of { happy_var_1 -> 
	case happyOut17 happy_x_3 of { happy_var_3 -> 
	happyIn16
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_20 = happySpecReduce_1  2# happyReduction_20
happyReduction_20 happy_x_1
	 =  case happyOut17 happy_x_1 of { happy_var_1 -> 
	happyIn16
		 ([happy_var_1]
	)}

happyReduce_21 = happyReduce 4# 3# happyReduction_21
happyReduction_21 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_import)    _)) -> 
	case happyOut80 happy_x_2 of { happy_var_2 -> 
	case happyOut18 happy_x_3 of { happy_var_3 -> 
	case happyOut19 happy_x_4 of { happy_var_4 -> 
	happyIn17
		 (Located { srcRange = rComb happy_var_1
                                                   $ fromMaybe (srcRange happy_var_2)
                                                   $ msum [ fmap srcRange happy_var_4
                                                          , fmap srcRange happy_var_3
                                                          ]
                                        , thing    = Import
                                          { iModule    = thing happy_var_2
                                          , iAs        = fmap thing happy_var_3
                                          , iSpec      = fmap thing happy_var_4
                                          }
                                        }
	) `HappyStk` happyRest}}}}

happyReduce_22 = happySpecReduce_2  4# happyReduction_22
happyReduction_22 happy_x_2
	happy_x_1
	 =  case happyOut80 happy_x_2 of { happy_var_2 -> 
	happyIn18
		 (Just happy_var_2
	)}

happyReduce_23 = happySpecReduce_0  4# happyReduction_23
happyReduction_23  =  happyIn18
		 (Nothing
	)

happyReduce_24 = happyReduce 4# 5# happyReduction_24
happyReduction_24 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut21 happy_x_1 of { happy_var_1 -> 
	case happyOut20 happy_x_3 of { happy_var_3 -> 
	happyIn19
		 (Just Located
                                  { srcRange = case happy_var_3 of
                                      { [] -> emptyRange
                                      ; xs -> rCombs (map srcRange xs) }
                                  , thing    = happy_var_1 (reverse (map thing happy_var_3))
                                  }
	) `HappyStk` happyRest}}

happyReduce_25 = happySpecReduce_0  5# happyReduction_25
happyReduction_25  =  happyIn19
		 (Nothing
	)

happyReduce_26 = happySpecReduce_3  6# happyReduction_26
happyReduction_26 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut20 happy_x_1 of { happy_var_1 -> 
	case happyOut79 happy_x_3 of { happy_var_3 -> 
	happyIn20
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_27 = happySpecReduce_1  6# happyReduction_27
happyReduction_27 happy_x_1
	 =  case happyOut79 happy_x_1 of { happy_var_1 -> 
	happyIn20
		 ([happy_var_1]
	)}

happyReduce_28 = happySpecReduce_0  6# happyReduction_28
happyReduction_28  =  happyIn20
		 ([]
	)

happyReduce_29 = happySpecReduce_1  7# happyReduction_29
happyReduction_29 happy_x_1
	 =  happyIn21
		 (Hiding
	)

happyReduce_30 = happySpecReduce_0  7# happyReduction_30
happyReduction_30  =  happyIn21
		 (Only
	)

happyReduce_31 = happySpecReduce_1  8# happyReduction_31
happyReduction_31 happy_x_1
	 =  case happyOut24 happy_x_1 of { happy_var_1 -> 
	happyIn22
		 (Program (reverse happy_var_1)
	)}

happyReduce_32 = happySpecReduce_0  8# happyReduction_32
happyReduction_32  =  happyIn22
		 (Program []
	)

happyReduce_33 = happySpecReduce_3  9# happyReduction_33
happyReduction_33 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut25 happy_x_2 of { happy_var_2 -> 
	happyIn23
		 (Program (reverse happy_var_2)
	)}

happyReduce_34 = happySpecReduce_2  9# happyReduction_34
happyReduction_34 happy_x_2
	happy_x_1
	 =  happyIn23
		 (Program []
	)

happyReduce_35 = happySpecReduce_2  10# happyReduction_35
happyReduction_35 happy_x_2
	happy_x_1
	 =  case happyOut27 happy_x_1 of { happy_var_1 -> 
	happyIn24
		 ([happy_var_1]
	)}

happyReduce_36 = happySpecReduce_3  10# happyReduction_36
happyReduction_36 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut24 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_2 of { happy_var_2 -> 
	happyIn24
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_37 = happySpecReduce_1  11# happyReduction_37
happyReduction_37 happy_x_1
	 =  case happyOut26 happy_x_1 of { happy_var_1 -> 
	happyIn25
		 (happy_var_1
	)}

happyReduce_38 = happySpecReduce_3  11# happyReduction_38
happyReduction_38 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut25 happy_x_1 of { happy_var_1 -> 
	case happyOut26 happy_x_3 of { happy_var_3 -> 
	happyIn25
		 (happy_var_3 ++ happy_var_1
	)}}

happyReduce_39 = happySpecReduce_3  11# happyReduction_39
happyReduction_39 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut25 happy_x_1 of { happy_var_1 -> 
	case happyOut26 happy_x_3 of { happy_var_3 -> 
	happyIn25
		 (happy_var_3 ++ happy_var_1
	)}}

happyReduce_40 = happySpecReduce_1  12# happyReduction_40
happyReduction_40 happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	happyIn26
		 ([exportDecl Public happy_var_1]
	)}

happyReduce_41 = happyReduce 4# 12# happyReduction_41
happyReduction_41 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut25 happy_x_3 of { happy_var_3 -> 
	happyIn26
		 (changeExport Private (reverse happy_var_3)
	) `HappyStk` happyRest}

happyReduce_42 = happyMonadReduce 2# 12# happyReduction_42
happyReduction_42 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_2 of { (happy_var_2@(Located _ (Token (StrLit {}) _))) -> 
	( (return . Include) `fmap` fromStrLit happy_var_2)}
	) (\r -> happyReturn (happyIn26 r))

happyReduce_43 = happyReduce 5# 12# happyReduction_43
happyReduction_43 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut79 happy_x_2 of { happy_var_2 -> 
	case happyOut33 happy_x_3 of { happy_var_3 -> 
	case happyOut38 happy_x_5 of { happy_var_5 -> 
	happyIn26
		 ([exportDecl Public (mkProperty happy_var_2 happy_var_3 happy_var_5)]
	) `HappyStk` happyRest}}}

happyReduce_44 = happyReduce 4# 12# happyReduction_44
happyReduction_44 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut79 happy_x_2 of { happy_var_2 -> 
	case happyOut38 happy_x_4 of { happy_var_4 -> 
	happyIn26
		 ([exportDecl Public (mkProperty happy_var_2 [] happy_var_4)]
	) `HappyStk` happyRest}}

happyReduce_45 = happySpecReduce_1  12# happyReduction_45
happyReduction_45 happy_x_1
	 =  case happyOut30 happy_x_1 of { happy_var_1 -> 
	happyIn26
		 ([exportNewtype Public happy_var_1]
	)}

happyReduce_46 = happySpecReduce_1  13# happyReduction_46
happyReduction_46 happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	happyIn27
		 (Decl (TopLevel {tlExport = Public, tlValue = happy_var_1})
	)}

happyReduce_47 = happyMonadReduce 2# 13# happyReduction_47
happyReduction_47 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_2 of { (happy_var_2@(Located _ (Token (StrLit {}) _))) -> 
	( Include `fmap` fromStrLit happy_var_2)}
	) (\r -> happyReturn (happyIn27 r))

happyReduce_48 = happySpecReduce_3  14# happyReduction_48
happyReduction_48 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut32 happy_x_1 of { happy_var_1 -> 
	case happyOut60 happy_x_3 of { happy_var_3 -> 
	happyIn28
		 (at (head happy_var_1,happy_var_3) $ DSignature (map (fmap mkUnqual) (reverse happy_var_1)) happy_var_3
	)}}

happyReduce_49 = happySpecReduce_3  14# happyReduction_49
happyReduction_49 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut56 happy_x_1 of { happy_var_1 -> 
	case happyOut38 happy_x_3 of { happy_var_3 -> 
	happyIn28
		 (at (happy_var_1,happy_var_3) $ DPatBind happy_var_1 happy_var_3
	)}}

happyReduce_50 = happyReduce 4# 14# happyReduction_50
happyReduction_50 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut79 happy_x_1 of { happy_var_1 -> 
	case happyOut33 happy_x_2 of { happy_var_2 -> 
	case happyOut38 happy_x_4 of { happy_var_4 -> 
	happyIn28
		 (at (happy_var_1,happy_var_4) $
                             DBind $ Bind { bName      = fmap mkUnqual happy_var_1
                                          , bParams    = reverse happy_var_2
                                          , bDef       = happy_var_4
                                          , bSignature = Nothing
                                          , bPragmas   = []
                                          , bMono      = False
                                          }
	) `HappyStk` happyRest}}}

happyReduce_51 = happyMonadReduce 4# 14# happyReduction_51
happyReduction_51 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_type   ) _)) -> 
	case happyOut79 happy_x_2 of { happy_var_2 -> 
	case happyOut70 happy_x_4 of { happy_var_4 -> 
	( at (happy_var_1,happy_var_4) `fmap` mkTySyn happy_var_2 [] happy_var_4)}}}
	) (\r -> happyReturn (happyIn28 r))

happyReduce_52 = happyMonadReduce 5# 14# happyReduction_52
happyReduction_52 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_type   ) _)) -> 
	case happyOut79 happy_x_2 of { happy_var_2 -> 
	case happyOut67 happy_x_3 of { happy_var_3 -> 
	case happyOut70 happy_x_5 of { happy_var_5 -> 
	( at (happy_var_1,happy_var_5) `fmap` mkTySyn happy_var_2 (reverse happy_var_3) happy_var_5)}}}}
	) (\r -> happyReturn (happyIn28 r))

happyReduce_53 = happyReduce 4# 15# happyReduction_53
happyReduction_53 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut56 happy_x_2 of { happy_var_2 -> 
	case happyOut38 happy_x_4 of { happy_var_4 -> 
	happyIn29
		 (at (happy_var_2,happy_var_4) $ DPatBind happy_var_2 happy_var_4
	) `HappyStk` happyRest}}

happyReduce_54 = happyReduce 5# 15# happyReduction_54
happyReduction_54 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut79 happy_x_2 of { happy_var_2 -> 
	case happyOut33 happy_x_3 of { happy_var_3 -> 
	case happyOut38 happy_x_5 of { happy_var_5 -> 
	happyIn29
		 (at (happy_var_2,happy_var_5) $
                                   DBind $ Bind { bName      = fmap mkUnqual happy_var_2
                                                , bParams    = reverse happy_var_3
                                                , bDef       = happy_var_5
                                                , bSignature = Nothing
                                                , bPragmas   = []
                                                , bMono      = False
                                                }
	) `HappyStk` happyRest}}}

happyReduce_55 = happyReduce 4# 16# happyReduction_55
happyReduction_55 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut81 happy_x_2 of { happy_var_2 -> 
	case happyOut31 happy_x_4 of { happy_var_4 -> 
	happyIn30
		 (Newtype { nName = happy_var_2, nParams = [], nBody = happy_var_4 }
	) `HappyStk` happyRest}}

happyReduce_56 = happyReduce 5# 16# happyReduction_56
happyReduction_56 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut81 happy_x_2 of { happy_var_2 -> 
	case happyOut67 happy_x_3 of { happy_var_3 -> 
	case happyOut31 happy_x_5 of { happy_var_5 -> 
	happyIn30
		 (Newtype { nName = happy_var_2, nParams = happy_var_3, nBody = happy_var_5 }
	) `HappyStk` happyRest}}}

happyReduce_57 = happySpecReduce_2  17# happyReduction_57
happyReduction_57 happy_x_2
	happy_x_1
	 =  happyIn31
		 ([]
	)

happyReduce_58 = happySpecReduce_3  17# happyReduction_58
happyReduction_58 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut77 happy_x_2 of { happy_var_2 -> 
	happyIn31
		 (happy_var_2
	)}

happyReduce_59 = happySpecReduce_1  18# happyReduction_59
happyReduction_59 happy_x_1
	 =  case happyOut79 happy_x_1 of { happy_var_1 -> 
	happyIn32
		 ([ happy_var_1]
	)}

happyReduce_60 = happySpecReduce_3  18# happyReduction_60
happyReduction_60 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut32 happy_x_1 of { happy_var_1 -> 
	case happyOut79 happy_x_3 of { happy_var_3 -> 
	happyIn32
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_61 = happySpecReduce_1  19# happyReduction_61
happyReduction_61 happy_x_1
	 =  case happyOut56 happy_x_1 of { happy_var_1 -> 
	happyIn33
		 ([happy_var_1]
	)}

happyReduce_62 = happySpecReduce_2  19# happyReduction_62
happyReduction_62 happy_x_2
	happy_x_1
	 =  case happyOut33 happy_x_1 of { happy_var_1 -> 
	case happyOut56 happy_x_2 of { happy_var_2 -> 
	happyIn33
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_63 = happySpecReduce_2  20# happyReduction_63
happyReduction_63 happy_x_2
	happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	happyIn34
		 ([happy_var_1]
	)}

happyReduce_64 = happySpecReduce_3  20# happyReduction_64
happyReduction_64 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut34 happy_x_1 of { happy_var_1 -> 
	case happyOut28 happy_x_2 of { happy_var_2 -> 
	happyIn34
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_65 = happySpecReduce_1  21# happyReduction_65
happyReduction_65 happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	happyIn35
		 ([happy_var_1]
	)}

happyReduce_66 = happySpecReduce_3  21# happyReduction_66
happyReduction_66 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut35 happy_x_1 of { happy_var_1 -> 
	case happyOut28 happy_x_3 of { happy_var_3 -> 
	happyIn35
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_67 = happySpecReduce_3  21# happyReduction_67
happyReduction_67 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut35 happy_x_1 of { happy_var_1 -> 
	case happyOut28 happy_x_3 of { happy_var_3 -> 
	happyIn35
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_68 = happySpecReduce_3  22# happyReduction_68
happyReduction_68 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut35 happy_x_2 of { happy_var_2 -> 
	happyIn36
		 (happy_var_2
	)}

happyReduce_69 = happySpecReduce_2  22# happyReduction_69
happyReduction_69 happy_x_2
	happy_x_1
	 =  happyIn36
		 ([]
	)

happyReduce_70 = happySpecReduce_1  23# happyReduction_70
happyReduction_70 happy_x_1
	 =  case happyOut38 happy_x_1 of { happy_var_1 -> 
	happyIn37
		 (ExprInput happy_var_1
	)}

happyReduce_71 = happySpecReduce_1  23# happyReduction_71
happyReduction_71 happy_x_1
	 =  case happyOut29 happy_x_1 of { happy_var_1 -> 
	happyIn37
		 (LetInput happy_var_1
	)}

happyReduce_72 = happySpecReduce_1  24# happyReduction_72
happyReduction_72 happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	happyIn38
		 (happy_var_1
	)}

happyReduce_73 = happyReduce 4# 24# happyReduction_73
happyReduction_73 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut38 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_4 of { (Located happy_var_4 (Token (Sym CurlyR  ) _)) -> 
	happyIn38
		 (at (happy_var_1,happy_var_4) $ EWhere happy_var_1 []
	) `HappyStk` happyRest}}

happyReduce_74 = happyReduce 5# 24# happyReduction_74
happyReduction_74 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut38 happy_x_1 of { happy_var_1 -> 
	case happyOut34 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Located happy_var_5 (Token (Sym CurlyR  ) _)) -> 
	happyIn38
		 (at (happy_var_1,happy_var_5) $ EWhere happy_var_1 (reverse happy_var_4)
	) `HappyStk` happyRest}}}

happyReduce_75 = happyReduce 4# 24# happyReduction_75
happyReduction_75 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut38 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (KW KW_where  ) _)) -> 
	happyIn38
		 (at (happy_var_1,happy_var_2) $ EWhere happy_var_1 []
	) `HappyStk` happyRest}}

happyReduce_76 = happyReduce 5# 24# happyReduction_76
happyReduction_76 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut38 happy_x_1 of { happy_var_1 -> 
	case happyOut35 happy_x_4 of { happy_var_4 -> 
	happyIn38
		 (at (happy_var_1,happy_var_4) $ EWhere happy_var_1 (reverse happy_var_4)
	) `HappyStk` happyRest}}

happyReduce_77 = happySpecReduce_1  25# happyReduction_77
happyReduction_77 happy_x_1
	 =  case happyOut40 happy_x_1 of { happy_var_1 -> 
	happyIn39
		 ([happy_var_1]
	)}

happyReduce_78 = happySpecReduce_3  25# happyReduction_78
happyReduction_78 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut39 happy_x_1 of { happy_var_1 -> 
	case happyOut40 happy_x_3 of { happy_var_3 -> 
	happyIn39
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_79 = happySpecReduce_3  26# happyReduction_79
happyReduction_79 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut38 happy_x_1 of { happy_var_1 -> 
	case happyOut38 happy_x_3 of { happy_var_3 -> 
	happyIn40
		 ((happy_var_1, happy_var_3)
	)}}

happyReduce_80 = happySpecReduce_1  27# happyReduction_80
happyReduction_80 happy_x_1
	 =  case happyOut42 happy_x_1 of { happy_var_1 -> 
	happyIn41
		 (mkEApp happy_var_1
	)}

happyReduce_81 = happySpecReduce_3  27# happyReduction_81
happyReduction_81 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	happyIn41
		 (at (happy_var_1,happy_var_3) $ ETyped happy_var_1 happy_var_3
	)}}

happyReduce_82 = happyReduce 4# 27# happyReduction_82
happyReduction_82 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_if     ) _)) -> 
	case happyOut39 happy_x_2 of { happy_var_2 -> 
	case happyOut41 happy_x_4 of { happy_var_4 -> 
	happyIn41
		 (at (happy_var_1,happy_var_4) $ mkIf happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}

happyReduce_83 = happyReduce 4# 27# happyReduction_83
happyReduction_83 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym Lambda  ) _)) -> 
	case happyOut33 happy_x_2 of { happy_var_2 -> 
	case happyOut41 happy_x_4 of { happy_var_4 -> 
	happyIn41
		 (at (happy_var_1,happy_var_4) $ EFun (reverse happy_var_2) happy_var_4
	) `HappyStk` happyRest}}}

happyReduce_84 = happySpecReduce_3  27# happyReduction_84
happyReduction_84 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Op At          ) _)) -> 
	case happyOut41 happy_x_3 of { happy_var_3 -> 
	happyIn41
		 (binOp happy_var_1 (op ECAt          happy_var_2) happy_var_3
	)}}}

happyReduce_85 = happySpecReduce_3  27# happyReduction_85
happyReduction_85 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Op AtAt        ) _)) -> 
	case happyOut41 happy_x_3 of { happy_var_3 -> 
	happyIn41
		 (binOp happy_var_1 (op ECAtRange     happy_var_2) happy_var_3
	)}}}

happyReduce_86 = happySpecReduce_3  27# happyReduction_86
happyReduction_86 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Op Bang        ) _)) -> 
	case happyOut41 happy_x_3 of { happy_var_3 -> 
	happyIn41
		 (binOp happy_var_1 (op ECAtBack      happy_var_2) happy_var_3
	)}}}

happyReduce_87 = happySpecReduce_3  27# happyReduction_87
happyReduction_87 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Op BangBang    ) _)) -> 
	case happyOut41 happy_x_3 of { happy_var_3 -> 
	happyIn41
		 (binOp happy_var_1 (op ECAtRangeBack happy_var_2) happy_var_3
	)}}}

happyReduce_88 = happySpecReduce_3  27# happyReduction_88
happyReduction_88 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Op Hash        ) _)) -> 
	case happyOut41 happy_x_3 of { happy_var_3 -> 
	happyIn41
		 (binOp happy_var_1 (op ECCat         happy_var_2) happy_var_3
	)}}}

happyReduce_89 = happySpecReduce_3  27# happyReduction_89
happyReduction_89 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Op Plus        ) _)) -> 
	case happyOut41 happy_x_3 of { happy_var_3 -> 
	happyIn41
		 (binOp happy_var_1 (op ECPlus        happy_var_2) happy_var_3
	)}}}

happyReduce_90 = happySpecReduce_3  27# happyReduction_90
happyReduction_90 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Op Minus       ) _)) -> 
	case happyOut41 happy_x_3 of { happy_var_3 -> 
	happyIn41
		 (binOp happy_var_1 (op ECMinus       happy_var_2) happy_var_3
	)}}}

happyReduce_91 = happySpecReduce_3  27# happyReduction_91
happyReduction_91 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Op Mul         ) _)) -> 
	case happyOut41 happy_x_3 of { happy_var_3 -> 
	happyIn41
		 (binOp happy_var_1 (op ECMul         happy_var_2) happy_var_3
	)}}}

happyReduce_92 = happySpecReduce_3  27# happyReduction_92
happyReduction_92 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Op Div         ) _)) -> 
	case happyOut41 happy_x_3 of { happy_var_3 -> 
	happyIn41
		 (binOp happy_var_1 (op ECDiv         happy_var_2) happy_var_3
	)}}}

happyReduce_93 = happySpecReduce_3  27# happyReduction_93
happyReduction_93 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Op Mod         ) _)) -> 
	case happyOut41 happy_x_3 of { happy_var_3 -> 
	happyIn41
		 (binOp happy_var_1 (op ECMod         happy_var_2) happy_var_3
	)}}}

happyReduce_94 = happySpecReduce_3  27# happyReduction_94
happyReduction_94 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Op Exp         ) _)) -> 
	case happyOut41 happy_x_3 of { happy_var_3 -> 
	happyIn41
		 (binOp happy_var_1 (op ECExp         happy_var_2) happy_var_3
	)}}}

happyReduce_95 = happySpecReduce_3  27# happyReduction_95
happyReduction_95 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Op Xor         ) _)) -> 
	case happyOut41 happy_x_3 of { happy_var_3 -> 
	happyIn41
		 (binOp happy_var_1 (op ECXor         happy_var_2) happy_var_3
	)}}}

happyReduce_96 = happySpecReduce_3  27# happyReduction_96
happyReduction_96 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Op Disj        ) _)) -> 
	case happyOut41 happy_x_3 of { happy_var_3 -> 
	happyIn41
		 (binOp happy_var_1 (op ECOr          happy_var_2) happy_var_3
	)}}}

happyReduce_97 = happySpecReduce_3  27# happyReduction_97
happyReduction_97 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Op Conj        ) _)) -> 
	case happyOut41 happy_x_3 of { happy_var_3 -> 
	happyIn41
		 (binOp happy_var_1 (op ECAnd         happy_var_2) happy_var_3
	)}}}

happyReduce_98 = happySpecReduce_3  27# happyReduction_98
happyReduction_98 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Op Equal       ) _)) -> 
	case happyOut41 happy_x_3 of { happy_var_3 -> 
	happyIn41
		 (binOp happy_var_1 (op ECEq          happy_var_2) happy_var_3
	)}}}

happyReduce_99 = happySpecReduce_3  27# happyReduction_99
happyReduction_99 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Op NotEqual    ) _)) -> 
	case happyOut41 happy_x_3 of { happy_var_3 -> 
	happyIn41
		 (binOp happy_var_1 (op ECNotEq       happy_var_2) happy_var_3
	)}}}

happyReduce_100 = happySpecReduce_3  27# happyReduction_100
happyReduction_100 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Op EqualFun    ) _)) -> 
	case happyOut41 happy_x_3 of { happy_var_3 -> 
	happyIn41
		 (binOp happy_var_1 (op ECFunEq       happy_var_2) happy_var_3
	)}}}

happyReduce_101 = happySpecReduce_3  27# happyReduction_101
happyReduction_101 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Op NotEqualFun ) _)) -> 
	case happyOut41 happy_x_3 of { happy_var_3 -> 
	happyIn41
		 (binOp happy_var_1 (op ECFunNotEq    happy_var_2) happy_var_3
	)}}}

happyReduce_102 = happySpecReduce_3  27# happyReduction_102
happyReduction_102 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Op GreaterThan ) _)) -> 
	case happyOut41 happy_x_3 of { happy_var_3 -> 
	happyIn41
		 (binOp happy_var_1 (op ECGt          happy_var_2) happy_var_3
	)}}}

happyReduce_103 = happySpecReduce_3  27# happyReduction_103
happyReduction_103 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Op LessThan    ) _)) -> 
	case happyOut41 happy_x_3 of { happy_var_3 -> 
	happyIn41
		 (binOp happy_var_1 (op ECLt          happy_var_2) happy_var_3
	)}}}

happyReduce_104 = happySpecReduce_3  27# happyReduction_104
happyReduction_104 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Op LEQ         ) _)) -> 
	case happyOut41 happy_x_3 of { happy_var_3 -> 
	happyIn41
		 (binOp happy_var_1 (op ECLtEq        happy_var_2) happy_var_3
	)}}}

happyReduce_105 = happySpecReduce_3  27# happyReduction_105
happyReduction_105 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Op GEQ         ) _)) -> 
	case happyOut41 happy_x_3 of { happy_var_3 -> 
	happyIn41
		 (binOp happy_var_1 (op ECGtEq        happy_var_2) happy_var_3
	)}}}

happyReduce_106 = happySpecReduce_3  27# happyReduction_106
happyReduction_106 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Op ShiftL      ) _)) -> 
	case happyOut41 happy_x_3 of { happy_var_3 -> 
	happyIn41
		 (binOp happy_var_1 (op ECShiftL      happy_var_2) happy_var_3
	)}}}

happyReduce_107 = happySpecReduce_3  27# happyReduction_107
happyReduction_107 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Op ShiftR      ) _)) -> 
	case happyOut41 happy_x_3 of { happy_var_3 -> 
	happyIn41
		 (binOp happy_var_1 (op ECShiftR      happy_var_2) happy_var_3
	)}}}

happyReduce_108 = happySpecReduce_3  27# happyReduction_108
happyReduction_108 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Op RotL        ) _)) -> 
	case happyOut41 happy_x_3 of { happy_var_3 -> 
	happyIn41
		 (binOp happy_var_1 (op ECRotL        happy_var_2) happy_var_3
	)}}}

happyReduce_109 = happySpecReduce_3  27# happyReduction_109
happyReduction_109 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Op RotR        ) _)) -> 
	case happyOut41 happy_x_3 of { happy_var_3 -> 
	happyIn41
		 (binOp happy_var_1 (op ECRotR        happy_var_2) happy_var_3
	)}}}

happyReduce_110 = happySpecReduce_2  27# happyReduction_110
happyReduction_110 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Op Minus       ) _)) -> 
	case happyOut41 happy_x_2 of { happy_var_2 -> 
	happyIn41
		 (unOp     (op ECNeg         happy_var_1) happy_var_2
	)}}

happyReduce_111 = happySpecReduce_2  27# happyReduction_111
happyReduction_111 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Op Complement  ) _)) -> 
	case happyOut41 happy_x_2 of { happy_var_2 -> 
	happyIn41
		 (unOp     (op ECCompl       happy_var_1) happy_var_2
	)}}

happyReduce_112 = happySpecReduce_1  28# happyReduction_112
happyReduction_112 happy_x_1
	 =  case happyOut43 happy_x_1 of { happy_var_1 -> 
	happyIn42
		 ([happy_var_1]
	)}

happyReduce_113 = happySpecReduce_2  28# happyReduction_113
happyReduction_113 happy_x_2
	happy_x_1
	 =  case happyOut42 happy_x_1 of { happy_var_1 -> 
	case happyOut43 happy_x_2 of { happy_var_2 -> 
	happyIn42
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_114 = happySpecReduce_1  29# happyReduction_114
happyReduction_114 happy_x_1
	 =  case happyOut81 happy_x_1 of { happy_var_1 -> 
	happyIn43
		 (at happy_var_1 $ EVar (thing happy_var_1)
	)}

happyReduce_115 = happySpecReduce_1  29# happyReduction_115
happyReduction_115 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_min    ) _)) -> 
	happyIn43
		 (at happy_var_1 $ ECon ECMin
	)}

happyReduce_116 = happySpecReduce_1  29# happyReduction_116
happyReduction_116 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_max    ) _)) -> 
	happyIn43
		 (at happy_var_1 $ ECon ECMax
	)}

happyReduce_117 = happySpecReduce_1  29# happyReduction_117
happyReduction_117 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_lg2    ) _)) -> 
	happyIn43
		 (at happy_var_1 $ ECon ECLg2
	)}

happyReduce_118 = happySpecReduce_1  29# happyReduction_118
happyReduction_118 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_zero   ) _)) -> 
	happyIn43
		 (at happy_var_1 $ ECon ECZero
	)}

happyReduce_119 = happySpecReduce_1  29# happyReduction_119
happyReduction_119 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_join   ) _)) -> 
	happyIn43
		 (at happy_var_1 $ ECon ECJoin
	)}

happyReduce_120 = happySpecReduce_1  29# happyReduction_120
happyReduction_120 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_split  ) _)) -> 
	happyIn43
		 (at happy_var_1 $ ECon ECSplit
	)}

happyReduce_121 = happySpecReduce_1  29# happyReduction_121
happyReduction_121 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_splitAt) _)) -> 
	happyIn43
		 (at happy_var_1 $ ECon ECSplitAt
	)}

happyReduce_122 = happySpecReduce_1  29# happyReduction_122
happyReduction_122 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (Num   {}) _))) -> 
	happyIn43
		 (at happy_var_1 $ numLit (tokenType (thing happy_var_1))
	)}

happyReduce_123 = happySpecReduce_1  29# happyReduction_123
happyReduction_123 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (StrLit {}) _))) -> 
	happyIn43
		 (at happy_var_1 $ ELit $ ECString $ getStr happy_var_1
	)}

happyReduce_124 = happySpecReduce_1  29# happyReduction_124
happyReduction_124 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (ChrLit {}) _))) -> 
	happyIn43
		 (at happy_var_1 $ ELit $ ECNum (getNum happy_var_1) CharLit
	)}

happyReduce_125 = happySpecReduce_1  29# happyReduction_125
happyReduction_125 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_False  ) _)) -> 
	happyIn43
		 (at happy_var_1 $ ECon ECFalse
	)}

happyReduce_126 = happySpecReduce_1  29# happyReduction_126
happyReduction_126 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_True   ) _)) -> 
	happyIn43
		 (at happy_var_1 $ ECon ECTrue
	)}

happyReduce_127 = happySpecReduce_1  29# happyReduction_127
happyReduction_127 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_error  ) _)) -> 
	happyIn43
		 (at happy_var_1 $ ECon ECError
	)}

happyReduce_128 = happySpecReduce_1  29# happyReduction_128
happyReduction_128 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_reverse) _)) -> 
	happyIn43
		 (at happy_var_1 $ ECon ECReverse
	)}

happyReduce_129 = happySpecReduce_1  29# happyReduction_129
happyReduction_129 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_transpose) _)) -> 
	happyIn43
		 (at happy_var_1 $ ECon ECTranspose
	)}

happyReduce_130 = happySpecReduce_1  29# happyReduction_130
happyReduction_130 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_pmult)   _)) -> 
	happyIn43
		 (at happy_var_1 $ ECon ECPMul
	)}

happyReduce_131 = happySpecReduce_1  29# happyReduction_131
happyReduction_131 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_pdiv)    _)) -> 
	happyIn43
		 (at happy_var_1 $ ECon ECPDiv
	)}

happyReduce_132 = happySpecReduce_1  29# happyReduction_132
happyReduction_132 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_pmod)    _)) -> 
	happyIn43
		 (at happy_var_1 $ ECon ECPMod
	)}

happyReduce_133 = happySpecReduce_1  29# happyReduction_133
happyReduction_133 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_random)  _)) -> 
	happyIn43
		 (at happy_var_1 $ ECon ECRandom
	)}

happyReduce_134 = happySpecReduce_3  29# happyReduction_134
happyReduction_134 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut38 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn43
		 (at (happy_var_1,happy_var_3) happy_var_2
	)}}}

happyReduce_135 = happySpecReduce_3  29# happyReduction_135
happyReduction_135 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut47 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn43
		 (at (happy_var_1,happy_var_3) $ ETuple (reverse happy_var_2)
	)}}}

happyReduce_136 = happySpecReduce_2  29# happyReduction_136
happyReduction_136 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym ParenR  ) _)) -> 
	happyIn43
		 (at (happy_var_1,happy_var_2) $ ETuple []
	)}}

happyReduce_137 = happySpecReduce_2  29# happyReduction_137
happyReduction_137 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym CurlyR  ) _)) -> 
	happyIn43
		 (at (happy_var_1,happy_var_2) $ ERecord []
	)}}

happyReduce_138 = happySpecReduce_3  29# happyReduction_138
happyReduction_138 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOut49 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym CurlyR  ) _)) -> 
	happyIn43
		 (at (happy_var_1,happy_var_3) $ ERecord (reverse happy_var_2)
	)}}}

happyReduce_139 = happySpecReduce_2  29# happyReduction_139
happyReduction_139 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym BracketL) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym BracketR) _)) -> 
	happyIn43
		 (at (happy_var_1,happy_var_2) $ EList []
	)}}

happyReduce_140 = happySpecReduce_3  29# happyReduction_140
happyReduction_140 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym BracketL) _)) -> 
	case happyOut50 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym BracketR) _)) -> 
	happyIn43
		 (at (happy_var_1,happy_var_3) happy_var_2
	)}}}

happyReduce_141 = happySpecReduce_2  29# happyReduction_141
happyReduction_141 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym BackTick) _)) -> 
	case happyOut82 happy_x_2 of { happy_var_2 -> 
	happyIn43
		 (at (happy_var_1,happy_var_2) $ ETypeVal happy_var_2
	)}}

happyReduce_142 = happySpecReduce_3  29# happyReduction_142
happyReduction_142 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut43 happy_x_1 of { happy_var_1 -> 
	case happyOut46 happy_x_3 of { happy_var_3 -> 
	happyIn43
		 (at (happy_var_1,happy_var_3) $ ESel happy_var_1 (thing happy_var_3)
	)}}

happyReduce_143 = happySpecReduce_3  29# happyReduction_143
happyReduction_143 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn43
		 (at (happy_var_1,happy_var_3) $ ECon ECAt
	)}}

happyReduce_144 = happySpecReduce_3  29# happyReduction_144
happyReduction_144 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn43
		 (at (happy_var_1,happy_var_3) $ ECon ECAtRange
	)}}

happyReduce_145 = happySpecReduce_3  29# happyReduction_145
happyReduction_145 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn43
		 (at (happy_var_1,happy_var_3) $ ECon ECAtBack
	)}}

happyReduce_146 = happySpecReduce_3  29# happyReduction_146
happyReduction_146 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn43
		 (at (happy_var_1,happy_var_3) $ ECon ECAtRangeBack
	)}}

happyReduce_147 = happySpecReduce_3  29# happyReduction_147
happyReduction_147 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn43
		 (at (happy_var_1,happy_var_3) $ ECon ECCat
	)}}

happyReduce_148 = happySpecReduce_3  29# happyReduction_148
happyReduction_148 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn43
		 (at (happy_var_1,happy_var_3) $ ECon ECPlus
	)}}

happyReduce_149 = happySpecReduce_3  29# happyReduction_149
happyReduction_149 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn43
		 (at (happy_var_1,happy_var_3) $ ECon ECMinus
	)}}

happyReduce_150 = happySpecReduce_3  29# happyReduction_150
happyReduction_150 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn43
		 (at (happy_var_1,happy_var_3) $ ECon ECMul
	)}}

happyReduce_151 = happySpecReduce_3  29# happyReduction_151
happyReduction_151 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn43
		 (at (happy_var_1,happy_var_3) $ ECon ECDiv
	)}}

happyReduce_152 = happySpecReduce_3  29# happyReduction_152
happyReduction_152 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn43
		 (at (happy_var_1,happy_var_3) $ ECon ECMod
	)}}

happyReduce_153 = happySpecReduce_3  29# happyReduction_153
happyReduction_153 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn43
		 (at (happy_var_1,happy_var_3) $ ECon ECExp
	)}}

happyReduce_154 = happySpecReduce_3  29# happyReduction_154
happyReduction_154 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn43
		 (at (happy_var_1,happy_var_3) $ ECon ECXor
	)}}

happyReduce_155 = happySpecReduce_3  29# happyReduction_155
happyReduction_155 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn43
		 (at (happy_var_1,happy_var_3) $ ECon ECOr
	)}}

happyReduce_156 = happySpecReduce_3  29# happyReduction_156
happyReduction_156 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn43
		 (at (happy_var_1,happy_var_3) $ ECon ECAnd
	)}}

happyReduce_157 = happySpecReduce_3  29# happyReduction_157
happyReduction_157 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn43
		 (at (happy_var_1,happy_var_3) $ ECon ECEq
	)}}

happyReduce_158 = happySpecReduce_3  29# happyReduction_158
happyReduction_158 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn43
		 (at (happy_var_1,happy_var_3) $ ECon ECNotEq
	)}}

happyReduce_159 = happySpecReduce_3  29# happyReduction_159
happyReduction_159 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn43
		 (at (happy_var_1,happy_var_3) $ ECon ECFunEq
	)}}

happyReduce_160 = happySpecReduce_3  29# happyReduction_160
happyReduction_160 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn43
		 (at (happy_var_1,happy_var_3) $ ECon ECFunNotEq
	)}}

happyReduce_161 = happySpecReduce_3  29# happyReduction_161
happyReduction_161 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn43
		 (at (happy_var_1,happy_var_3) $ ECon ECGt
	)}}

happyReduce_162 = happySpecReduce_3  29# happyReduction_162
happyReduction_162 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn43
		 (at (happy_var_1,happy_var_3) $ ECon ECLt
	)}}

happyReduce_163 = happySpecReduce_3  29# happyReduction_163
happyReduction_163 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn43
		 (at (happy_var_1,happy_var_3) $ ECon ECLtEq
	)}}

happyReduce_164 = happySpecReduce_3  29# happyReduction_164
happyReduction_164 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn43
		 (at (happy_var_1,happy_var_3) $ ECon ECGtEq
	)}}

happyReduce_165 = happySpecReduce_3  29# happyReduction_165
happyReduction_165 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn43
		 (at (happy_var_1,happy_var_3) $ ECon ECShiftL
	)}}

happyReduce_166 = happySpecReduce_3  29# happyReduction_166
happyReduction_166 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn43
		 (at (happy_var_1,happy_var_3) $ ECon ECShiftR
	)}}

happyReduce_167 = happySpecReduce_3  29# happyReduction_167
happyReduction_167 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn43
		 (at (happy_var_1,happy_var_3) $ ECon ECRotL
	)}}

happyReduce_168 = happySpecReduce_3  29# happyReduction_168
happyReduction_168 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn43
		 (at (happy_var_1,happy_var_3) $ ECon ECRotR
	)}}

happyReduce_169 = happyMonadReduce 2# 29# happyReduction_169
happyReduction_169 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym TriL    ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym TriR    ) _)) -> 
	( mkPoly (rComb happy_var_1 happy_var_2) [])}}
	) (\r -> happyReturn (happyIn43 r))

happyReduce_170 = happyMonadReduce 3# 29# happyReduction_170
happyReduction_170 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym TriL    ) _)) -> 
	case happyOut44 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym TriR    ) _)) -> 
	( mkPoly (rComb happy_var_1 happy_var_3) happy_var_2)}}}
	) (\r -> happyReturn (happyIn43 r))

happyReduce_171 = happySpecReduce_1  30# happyReduction_171
happyReduction_171 happy_x_1
	 =  case happyOut45 happy_x_1 of { happy_var_1 -> 
	happyIn44
		 ([happy_var_1]
	)}

happyReduce_172 = happySpecReduce_3  30# happyReduction_172
happyReduction_172 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut44 happy_x_1 of { happy_var_1 -> 
	case happyOut45 happy_x_3 of { happy_var_3 -> 
	happyIn44
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_173 = happyMonadReduce 1# 31# happyReduction_173
happyReduction_173 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (Num   {}) _))) -> 
	( polyTerm (srcRange happy_var_1) (getNum happy_var_1) 0)}
	) (\r -> happyReturn (happyIn45 r))

happyReduce_174 = happyMonadReduce 1# 31# happyReduction_174
happyReduction_174 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_x)       _)) -> 
	( polyTerm happy_var_1 1 1)}
	) (\r -> happyReturn (happyIn45 r))

happyReduce_175 = happyMonadReduce 3# 31# happyReduction_175
happyReduction_175 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_x)       _)) -> 
	case happyOutTok happy_x_3 of { (happy_var_3@(Located _ (Token (Num   {}) _))) -> 
	( polyTerm (rComb happy_var_1 (srcRange happy_var_3))
                                                            1 (getNum happy_var_3))}}
	) (\r -> happyReturn (happyIn45 r))

happyReduce_176 = happySpecReduce_1  32# happyReduction_176
happyReduction_176 happy_x_1
	 =  case happyOut79 happy_x_1 of { happy_var_1 -> 
	happyIn46
		 (fmap (`RecordSel` Nothing) happy_var_1
	)}

happyReduce_177 = happyMonadReduce 1# 32# happyReduction_177
happyReduction_177 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (Num   {}) _))) -> 
	( mkTupleSel (srcRange happy_var_1) (getNum happy_var_1))}
	) (\r -> happyReturn (happyIn46 r))

happyReduce_178 = happySpecReduce_3  33# happyReduction_178
happyReduction_178 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut38 happy_x_1 of { happy_var_1 -> 
	case happyOut38 happy_x_3 of { happy_var_3 -> 
	happyIn47
		 ([ happy_var_3, happy_var_1]
	)}}

happyReduce_179 = happySpecReduce_3  33# happyReduction_179
happyReduction_179 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut47 happy_x_1 of { happy_var_1 -> 
	case happyOut38 happy_x_3 of { happy_var_3 -> 
	happyIn47
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_180 = happySpecReduce_3  34# happyReduction_180
happyReduction_180 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut79 happy_x_1 of { happy_var_1 -> 
	case happyOut38 happy_x_3 of { happy_var_3 -> 
	happyIn48
		 (Named { name = happy_var_1, value = happy_var_3 }
	)}}

happyReduce_181 = happyReduce 4# 34# happyReduction_181
happyReduction_181 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut79 happy_x_1 of { happy_var_1 -> 
	case happyOut33 happy_x_2 of { happy_var_2 -> 
	case happyOut38 happy_x_4 of { happy_var_4 -> 
	happyIn48
		 (Named { name = happy_var_1, value = EFun (reverse happy_var_2) happy_var_4 }
	) `HappyStk` happyRest}}}

happyReduce_182 = happySpecReduce_1  35# happyReduction_182
happyReduction_182 happy_x_1
	 =  case happyOut48 happy_x_1 of { happy_var_1 -> 
	happyIn49
		 ([happy_var_1]
	)}

happyReduce_183 = happySpecReduce_3  35# happyReduction_183
happyReduction_183 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut49 happy_x_1 of { happy_var_1 -> 
	case happyOut48 happy_x_3 of { happy_var_3 -> 
	happyIn49
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_184 = happySpecReduce_3  36# happyReduction_184
happyReduction_184 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut38 happy_x_1 of { happy_var_1 -> 
	case happyOut51 happy_x_3 of { happy_var_3 -> 
	happyIn50
		 (EComp happy_var_1 (reverse happy_var_3)
	)}}

happyReduce_185 = happySpecReduce_1  36# happyReduction_185
happyReduction_185 happy_x_1
	 =  case happyOut38 happy_x_1 of { happy_var_1 -> 
	happyIn50
		 (EList [happy_var_1]
	)}

happyReduce_186 = happySpecReduce_1  36# happyReduction_186
happyReduction_186 happy_x_1
	 =  case happyOut47 happy_x_1 of { happy_var_1 -> 
	happyIn50
		 (EList (reverse happy_var_1)
	)}

happyReduce_187 = happyMonadReduce 2# 36# happyReduction_187
happyReduction_187 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut38 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym DotDot  ) _)) -> 
	( eFromTo happy_var_2 happy_var_1 Nothing   Nothing)}}
	) (\r -> happyReturn (happyIn50 r))

happyReduce_188 = happyMonadReduce 3# 36# happyReduction_188
happyReduction_188 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut38 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym DotDot  ) _)) -> 
	case happyOut38 happy_x_3 of { happy_var_3 -> 
	( eFromTo happy_var_2 happy_var_1 Nothing   (Just happy_var_3))}}}
	) (\r -> happyReturn (happyIn50 r))

happyReduce_189 = happyMonadReduce 4# 36# happyReduction_189
happyReduction_189 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut38 happy_x_1 of { happy_var_1 -> 
	case happyOut38 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Located happy_var_4 (Token (Sym DotDot  ) _)) -> 
	( eFromTo happy_var_4 happy_var_1 (Just happy_var_3) Nothing)}}}
	) (\r -> happyReturn (happyIn50 r))

happyReduce_190 = happyMonadReduce 5# 36# happyReduction_190
happyReduction_190 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut38 happy_x_1 of { happy_var_1 -> 
	case happyOut38 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Located happy_var_4 (Token (Sym DotDot  ) _)) -> 
	case happyOut38 happy_x_5 of { happy_var_5 -> 
	( eFromTo happy_var_4 happy_var_1 (Just happy_var_3) (Just happy_var_5))}}}}
	) (\r -> happyReturn (happyIn50 r))

happyReduce_191 = happySpecReduce_2  36# happyReduction_191
happyReduction_191 happy_x_2
	happy_x_1
	 =  case happyOut38 happy_x_1 of { happy_var_1 -> 
	happyIn50
		 (EInfFrom happy_var_1 Nothing
	)}

happyReduce_192 = happyReduce 4# 36# happyReduction_192
happyReduction_192 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut38 happy_x_1 of { happy_var_1 -> 
	case happyOut38 happy_x_3 of { happy_var_3 -> 
	happyIn50
		 (EInfFrom happy_var_1 (Just happy_var_3)
	) `HappyStk` happyRest}}

happyReduce_193 = happySpecReduce_1  37# happyReduction_193
happyReduction_193 happy_x_1
	 =  case happyOut52 happy_x_1 of { happy_var_1 -> 
	happyIn51
		 ([ reverse happy_var_1 ]
	)}

happyReduce_194 = happySpecReduce_3  37# happyReduction_194
happyReduction_194 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut51 happy_x_1 of { happy_var_1 -> 
	case happyOut52 happy_x_3 of { happy_var_3 -> 
	happyIn51
		 (reverse happy_var_3 : happy_var_1
	)}}

happyReduce_195 = happySpecReduce_1  38# happyReduction_195
happyReduction_195 happy_x_1
	 =  case happyOut53 happy_x_1 of { happy_var_1 -> 
	happyIn52
		 ([happy_var_1]
	)}

happyReduce_196 = happySpecReduce_3  38# happyReduction_196
happyReduction_196 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut52 happy_x_1 of { happy_var_1 -> 
	case happyOut53 happy_x_3 of { happy_var_3 -> 
	happyIn52
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_197 = happySpecReduce_3  39# happyReduction_197
happyReduction_197 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut54 happy_x_1 of { happy_var_1 -> 
	case happyOut38 happy_x_3 of { happy_var_3 -> 
	happyIn53
		 (Match happy_var_1 happy_var_3
	)}}

happyReduce_198 = happySpecReduce_3  40# happyReduction_198
happyReduction_198 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut55 happy_x_1 of { happy_var_1 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	happyIn54
		 (at (happy_var_1,happy_var_3) $ PTyped happy_var_1 happy_var_3
	)}}

happyReduce_199 = happySpecReduce_1  40# happyReduction_199
happyReduction_199 happy_x_1
	 =  case happyOut55 happy_x_1 of { happy_var_1 -> 
	happyIn54
		 (happy_var_1
	)}

happyReduce_200 = happySpecReduce_3  41# happyReduction_200
happyReduction_200 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut55 happy_x_1 of { happy_var_1 -> 
	case happyOut55 happy_x_3 of { happy_var_3 -> 
	happyIn55
		 (at (happy_var_1,happy_var_3) $ PSplit happy_var_1 happy_var_3
	)}}

happyReduce_201 = happySpecReduce_1  41# happyReduction_201
happyReduction_201 happy_x_1
	 =  case happyOut56 happy_x_1 of { happy_var_1 -> 
	happyIn55
		 (happy_var_1
	)}

happyReduce_202 = happySpecReduce_1  42# happyReduction_202
happyReduction_202 happy_x_1
	 =  case happyOut79 happy_x_1 of { happy_var_1 -> 
	happyIn56
		 (PVar happy_var_1
	)}

happyReduce_203 = happySpecReduce_1  42# happyReduction_203
happyReduction_203 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym Underscore ) _)) -> 
	happyIn56
		 (at happy_var_1       $ PWild
	)}

happyReduce_204 = happySpecReduce_2  42# happyReduction_204
happyReduction_204 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym ParenR  ) _)) -> 
	happyIn56
		 (at (happy_var_1,happy_var_2) $ PTuple []
	)}}

happyReduce_205 = happySpecReduce_3  42# happyReduction_205
happyReduction_205 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut54 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn56
		 (at (happy_var_1,happy_var_3)   happy_var_2
	)}}}

happyReduce_206 = happySpecReduce_3  42# happyReduction_206
happyReduction_206 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut57 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn56
		 (at (happy_var_1,happy_var_3) $ PTuple (reverse happy_var_2)
	)}}}

happyReduce_207 = happySpecReduce_2  42# happyReduction_207
happyReduction_207 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym BracketL) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym BracketR) _)) -> 
	happyIn56
		 (at (happy_var_1,happy_var_2) $ PList []
	)}}

happyReduce_208 = happySpecReduce_3  42# happyReduction_208
happyReduction_208 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym BracketL) _)) -> 
	case happyOut54 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym BracketR) _)) -> 
	happyIn56
		 (at (happy_var_1,happy_var_3) $ PList [happy_var_2]
	)}}}

happyReduce_209 = happySpecReduce_3  42# happyReduction_209
happyReduction_209 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym BracketL) _)) -> 
	case happyOut57 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym BracketR) _)) -> 
	happyIn56
		 (at (happy_var_1,happy_var_3) $ PList (reverse happy_var_2)
	)}}}

happyReduce_210 = happySpecReduce_2  42# happyReduction_210
happyReduction_210 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym CurlyR  ) _)) -> 
	happyIn56
		 (at (happy_var_1,happy_var_2) $ PRecord []
	)}}

happyReduce_211 = happySpecReduce_3  42# happyReduction_211
happyReduction_211 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOut59 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym CurlyR  ) _)) -> 
	happyIn56
		 (at (happy_var_1,happy_var_3) $ PRecord (reverse happy_var_2)
	)}}}

happyReduce_212 = happySpecReduce_3  43# happyReduction_212
happyReduction_212 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut54 happy_x_1 of { happy_var_1 -> 
	case happyOut54 happy_x_3 of { happy_var_3 -> 
	happyIn57
		 ([happy_var_3, happy_var_1]
	)}}

happyReduce_213 = happySpecReduce_3  43# happyReduction_213
happyReduction_213 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut57 happy_x_1 of { happy_var_1 -> 
	case happyOut54 happy_x_3 of { happy_var_3 -> 
	happyIn57
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_214 = happySpecReduce_3  44# happyReduction_214
happyReduction_214 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut79 happy_x_1 of { happy_var_1 -> 
	case happyOut54 happy_x_3 of { happy_var_3 -> 
	happyIn58
		 (Named { name = happy_var_1, value = happy_var_3 }
	)}}

happyReduce_215 = happySpecReduce_1  45# happyReduction_215
happyReduction_215 happy_x_1
	 =  case happyOut58 happy_x_1 of { happy_var_1 -> 
	happyIn59
		 ([happy_var_1]
	)}

happyReduce_216 = happySpecReduce_3  45# happyReduction_216
happyReduction_216 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut59 happy_x_1 of { happy_var_1 -> 
	case happyOut58 happy_x_3 of { happy_var_3 -> 
	happyIn59
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_217 = happySpecReduce_1  46# happyReduction_217
happyReduction_217 happy_x_1
	 =  case happyOut70 happy_x_1 of { happy_var_1 -> 
	happyIn60
		 (at happy_var_1 $ mkSchema [] [] happy_var_1
	)}

happyReduce_218 = happySpecReduce_2  46# happyReduction_218
happyReduction_218 happy_x_2
	happy_x_1
	 =  case happyOut61 happy_x_1 of { happy_var_1 -> 
	case happyOut70 happy_x_2 of { happy_var_2 -> 
	happyIn60
		 (at (happy_var_1,happy_var_2) $ mkSchema (thing happy_var_1) [] happy_var_2
	)}}

happyReduce_219 = happySpecReduce_2  46# happyReduction_219
happyReduction_219 happy_x_2
	happy_x_1
	 =  case happyOut62 happy_x_1 of { happy_var_1 -> 
	case happyOut70 happy_x_2 of { happy_var_2 -> 
	happyIn60
		 (at (happy_var_1,happy_var_2) $ mkSchema [] (thing happy_var_1) happy_var_2
	)}}

happyReduce_220 = happySpecReduce_3  46# happyReduction_220
happyReduction_220 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut61 happy_x_1 of { happy_var_1 -> 
	case happyOut62 happy_x_2 of { happy_var_2 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	happyIn60
		 (at (happy_var_1,happy_var_3) $ mkSchema (thing happy_var_1)
                                                          (thing happy_var_2) happy_var_3
	)}}}

happyReduce_221 = happySpecReduce_2  47# happyReduction_221
happyReduction_221 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym CurlyR  ) _)) -> 
	happyIn61
		 (Located (rComb happy_var_1 happy_var_2) []
	)}}

happyReduce_222 = happySpecReduce_3  47# happyReduction_222
happyReduction_222 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOut65 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym CurlyR  ) _)) -> 
	happyIn61
		 (Located (rComb happy_var_1 happy_var_3) (reverse happy_var_2)
	)}}}

happyReduce_223 = happySpecReduce_3  48# happyReduction_223
happyReduction_223 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym FatArrR ) _)) -> 
	happyIn62
		 (Located (rComb happy_var_1 happy_var_3) []
	)}}

happyReduce_224 = happySpecReduce_2  48# happyReduction_224
happyReduction_224 happy_x_2
	happy_x_1
	 =  case happyOut68 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym FatArrR ) _)) -> 
	happyIn62
		 (Located
                                    (rComb (fromMaybe happy_var_2 (getLoc happy_var_1)) happy_var_2) [happy_var_1]
	)}}

happyReduce_225 = happyReduce 4# 48# happyReduction_225
happyReduction_225 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut69 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_4 of { (Located happy_var_4 (Token (Sym FatArrR ) _)) -> 
	happyIn62
		 (Located (rComb happy_var_1 happy_var_4) (reverse happy_var_2)
	) `HappyStk` happyRest}}}

happyReduce_226 = happySpecReduce_1  49# happyReduction_226
happyReduction_226 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Op Hash        ) _)) -> 
	happyIn63
		 (Located happy_var_1 KNum
	)}

happyReduce_227 = happySpecReduce_1  49# happyReduction_227
happyReduction_227 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Op Mul         ) _)) -> 
	happyIn63
		 (Located happy_var_1 KType
	)}

happyReduce_228 = happyMonadReduce 1# 50# happyReduction_228
happyReduction_228 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut79 happy_x_1 of { happy_var_1 -> 
	( mkTParam happy_var_1 Nothing)}
	) (\r -> happyReturn (happyIn64 r))

happyReduce_229 = happyMonadReduce 3# 50# happyReduction_229
happyReduction_229 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut79 happy_x_1 of { happy_var_1 -> 
	case happyOut63 happy_x_3 of { happy_var_3 -> 
	( mkTParam (at (happy_var_1,happy_var_3) happy_var_1) (Just (thing happy_var_3)))}}
	) (\r -> happyReturn (happyIn64 r))

happyReduce_230 = happySpecReduce_1  51# happyReduction_230
happyReduction_230 happy_x_1
	 =  case happyOut64 happy_x_1 of { happy_var_1 -> 
	happyIn65
		 ([happy_var_1]
	)}

happyReduce_231 = happySpecReduce_3  51# happyReduction_231
happyReduction_231 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut65 happy_x_1 of { happy_var_1 -> 
	case happyOut64 happy_x_3 of { happy_var_3 -> 
	happyIn65
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_232 = happyMonadReduce 1# 52# happyReduction_232
happyReduction_232 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut79 happy_x_1 of { happy_var_1 -> 
	( mkTParam happy_var_1 Nothing)}
	) (\r -> happyReturn (happyIn66 r))

happyReduce_233 = happyMonadReduce 5# 52# happyReduction_233
happyReduction_233 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut79 happy_x_2 of { happy_var_2 -> 
	case happyOut63 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Located happy_var_5 (Token (Sym ParenR  ) _)) -> 
	( mkTParam (at (happy_var_1,happy_var_5) happy_var_2) (Just (thing happy_var_4)))}}}}
	) (\r -> happyReturn (happyIn66 r))

happyReduce_234 = happySpecReduce_1  53# happyReduction_234
happyReduction_234 happy_x_1
	 =  case happyOut66 happy_x_1 of { happy_var_1 -> 
	happyIn67
		 ([happy_var_1]
	)}

happyReduce_235 = happySpecReduce_2  53# happyReduction_235
happyReduction_235 happy_x_2
	happy_x_1
	 =  case happyOut67 happy_x_1 of { happy_var_1 -> 
	case happyOut66 happy_x_2 of { happy_var_2 -> 
	happyIn67
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_236 = happySpecReduce_3  54# happyReduction_236
happyReduction_236 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut70 happy_x_1 of { happy_var_1 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	happyIn68
		 (at (happy_var_1,happy_var_3) $ CEqual  happy_var_1 happy_var_3
	)}}

happyReduce_237 = happySpecReduce_3  54# happyReduction_237
happyReduction_237 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut70 happy_x_1 of { happy_var_1 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	happyIn68
		 (at (happy_var_1,happy_var_3) $ CGeq happy_var_3 happy_var_1
	)}}

happyReduce_238 = happySpecReduce_3  54# happyReduction_238
happyReduction_238 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut70 happy_x_1 of { happy_var_1 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	happyIn68
		 (at (happy_var_1,happy_var_3) $ CGeq happy_var_1 happy_var_3
	)}}

happyReduce_239 = happySpecReduce_2  54# happyReduction_239
happyReduction_239 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_fin    ) _)) -> 
	case happyOut72 happy_x_2 of { happy_var_2 -> 
	happyIn68
		 (at (happy_var_1,happy_var_2) $ CFin happy_var_2
	)}}

happyReduce_240 = happySpecReduce_2  54# happyReduction_240
happyReduction_240 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_Arith  ) _)) -> 
	case happyOut72 happy_x_2 of { happy_var_2 -> 
	happyIn68
		 (at (happy_var_1,happy_var_2) $ CArith happy_var_2
	)}}

happyReduce_241 = happySpecReduce_2  54# happyReduction_241
happyReduction_241 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_Cmp    ) _)) -> 
	case happyOut72 happy_x_2 of { happy_var_2 -> 
	happyIn68
		 (at (happy_var_1,happy_var_2) $ CCmp   happy_var_2
	)}}

happyReduce_242 = happySpecReduce_1  55# happyReduction_242
happyReduction_242 happy_x_1
	 =  case happyOut68 happy_x_1 of { happy_var_1 -> 
	happyIn69
		 ([happy_var_1]
	)}

happyReduce_243 = happySpecReduce_3  55# happyReduction_243
happyReduction_243 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut69 happy_x_1 of { happy_var_1 -> 
	case happyOut68 happy_x_3 of { happy_var_3 -> 
	happyIn69
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_244 = happySpecReduce_3  56# happyReduction_244
happyReduction_244 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut70 happy_x_1 of { happy_var_1 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	happyIn70
		 (at (happy_var_1,happy_var_3) $ TFun happy_var_1 happy_var_3
	)}}

happyReduce_245 = happySpecReduce_3  56# happyReduction_245
happyReduction_245 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut70 happy_x_1 of { happy_var_1 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	happyIn70
		 (at (happy_var_1,happy_var_3) $ TApp TCAdd [happy_var_1, happy_var_3]
	)}}

happyReduce_246 = happySpecReduce_3  56# happyReduction_246
happyReduction_246 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut70 happy_x_1 of { happy_var_1 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	happyIn70
		 (at (happy_var_1,happy_var_3) $ TApp TCSub [happy_var_1, happy_var_3]
	)}}

happyReduce_247 = happySpecReduce_3  56# happyReduction_247
happyReduction_247 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut70 happy_x_1 of { happy_var_1 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	happyIn70
		 (at (happy_var_1,happy_var_3) $ TApp TCMul [happy_var_1, happy_var_3]
	)}}

happyReduce_248 = happySpecReduce_3  56# happyReduction_248
happyReduction_248 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut70 happy_x_1 of { happy_var_1 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	happyIn70
		 (at (happy_var_1,happy_var_3) $ TApp TCDiv [happy_var_1, happy_var_3]
	)}}

happyReduce_249 = happySpecReduce_3  56# happyReduction_249
happyReduction_249 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut70 happy_x_1 of { happy_var_1 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	happyIn70
		 (at (happy_var_1,happy_var_3) $ TApp TCMod [happy_var_1, happy_var_3]
	)}}

happyReduce_250 = happySpecReduce_3  56# happyReduction_250
happyReduction_250 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut70 happy_x_1 of { happy_var_1 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	happyIn70
		 (at (happy_var_1,happy_var_3) $ TApp TCExp [happy_var_1, happy_var_3]
	)}}

happyReduce_251 = happySpecReduce_1  56# happyReduction_251
happyReduction_251 happy_x_1
	 =  case happyOut71 happy_x_1 of { happy_var_1 -> 
	happyIn70
		 (happy_var_1
	)}

happyReduce_252 = happySpecReduce_2  57# happyReduction_252
happyReduction_252 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_lg2    ) _)) -> 
	case happyOut72 happy_x_2 of { happy_var_2 -> 
	happyIn71
		 (at (happy_var_1,happy_var_2) $ TApp TCLg2   [happy_var_2]
	)}}

happyReduce_253 = happySpecReduce_3  57# happyReduction_253
happyReduction_253 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_lengthFromThen) _)) -> 
	case happyOut72 happy_x_2 of { happy_var_2 -> 
	case happyOut72 happy_x_3 of { happy_var_3 -> 
	happyIn71
		 (at (happy_var_1,happy_var_3) $ TApp TCLenFromThen [happy_var_2,happy_var_3]
	)}}}

happyReduce_254 = happyReduce 4# 57# happyReduction_254
happyReduction_254 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_lengthFromThenTo) _)) -> 
	case happyOut72 happy_x_2 of { happy_var_2 -> 
	case happyOut72 happy_x_3 of { happy_var_3 -> 
	case happyOut72 happy_x_4 of { happy_var_4 -> 
	happyIn71
		 (at (happy_var_1,happy_var_4) $ TApp TCLenFromThen [happy_var_2,happy_var_3,happy_var_4]
	) `HappyStk` happyRest}}}}

happyReduce_255 = happySpecReduce_3  57# happyReduction_255
happyReduction_255 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_min    ) _)) -> 
	case happyOut72 happy_x_2 of { happy_var_2 -> 
	case happyOut72 happy_x_3 of { happy_var_3 -> 
	happyIn71
		 (at (happy_var_1,happy_var_3) $ TApp TCMin   [happy_var_2,happy_var_3]
	)}}}

happyReduce_256 = happySpecReduce_3  57# happyReduction_256
happyReduction_256 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_max    ) _)) -> 
	case happyOut72 happy_x_2 of { happy_var_2 -> 
	case happyOut72 happy_x_3 of { happy_var_3 -> 
	happyIn71
		 (at (happy_var_1,happy_var_3) $ TApp TCMax   [happy_var_2,happy_var_3]
	)}}}

happyReduce_257 = happySpecReduce_2  57# happyReduction_257
happyReduction_257 happy_x_2
	happy_x_1
	 =  case happyOut74 happy_x_1 of { happy_var_1 -> 
	case happyOut72 happy_x_2 of { happy_var_2 -> 
	happyIn71
		 (at (happy_var_1,happy_var_2) $ foldr TSeq happy_var_2 (reverse (thing happy_var_1))
	)}}

happyReduce_258 = happySpecReduce_2  57# happyReduction_258
happyReduction_258 happy_x_2
	happy_x_1
	 =  case happyOut81 happy_x_1 of { happy_var_1 -> 
	case happyOut73 happy_x_2 of { happy_var_2 -> 
	happyIn71
		 (at (happy_var_1,head happy_var_2)
                                     $ TUser (thing happy_var_1) (reverse happy_var_2)
	)}}

happyReduce_259 = happySpecReduce_1  57# happyReduction_259
happyReduction_259 happy_x_1
	 =  case happyOut72 happy_x_1 of { happy_var_1 -> 
	happyIn71
		 (happy_var_1
	)}

happyReduce_260 = happySpecReduce_1  58# happyReduction_260
happyReduction_260 happy_x_1
	 =  case happyOut81 happy_x_1 of { happy_var_1 -> 
	happyIn72
		 (at happy_var_1 $ TUser (thing happy_var_1) []
	)}

happyReduce_261 = happySpecReduce_1  58# happyReduction_261
happyReduction_261 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_Bit    ) _)) -> 
	happyIn72
		 (at happy_var_1 $ TBit
	)}

happyReduce_262 = happySpecReduce_1  58# happyReduction_262
happyReduction_262 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_inf    ) _)) -> 
	happyIn72
		 (at happy_var_1 $ TInf
	)}

happyReduce_263 = happySpecReduce_1  58# happyReduction_263
happyReduction_263 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (Num   {}) _))) -> 
	happyIn72
		 (at happy_var_1 $ TNum  (getNum happy_var_1)
	)}

happyReduce_264 = happySpecReduce_1  58# happyReduction_264
happyReduction_264 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (ChrLit {}) _))) -> 
	happyIn72
		 (at happy_var_1 $ TChar (toEnum $ fromInteger
                                                          $ getNum happy_var_1)
	)}

happyReduce_265 = happySpecReduce_3  58# happyReduction_265
happyReduction_265 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym BracketL) _)) -> 
	case happyOut70 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym BracketR) _)) -> 
	happyIn72
		 (at (happy_var_1,happy_var_3) $ TSeq happy_var_2 TBit
	)}}}

happyReduce_266 = happySpecReduce_3  58# happyReduction_266
happyReduction_266 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut70 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn72
		 (at (happy_var_1,happy_var_3) happy_var_2
	)}}}

happyReduce_267 = happySpecReduce_2  58# happyReduction_267
happyReduction_267 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym ParenR  ) _)) -> 
	happyIn72
		 (at (happy_var_1,happy_var_2) $ TTuple []
	)}}

happyReduce_268 = happySpecReduce_3  58# happyReduction_268
happyReduction_268 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut75 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn72
		 (at (happy_var_1,happy_var_3) $ TTuple  (reverse happy_var_2)
	)}}}

happyReduce_269 = happySpecReduce_2  58# happyReduction_269
happyReduction_269 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym CurlyR  ) _)) -> 
	happyIn72
		 (at (happy_var_1,happy_var_2) $ TRecord []
	)}}

happyReduce_270 = happySpecReduce_3  58# happyReduction_270
happyReduction_270 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOut77 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym CurlyR  ) _)) -> 
	happyIn72
		 (at (happy_var_1,happy_var_3) $ TRecord (reverse happy_var_2)
	)}}}

happyReduce_271 = happySpecReduce_1  58# happyReduction_271
happyReduction_271 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym Underscore ) _)) -> 
	happyIn72
		 (at happy_var_1 TWild
	)}

happyReduce_272 = happySpecReduce_1  59# happyReduction_272
happyReduction_272 happy_x_1
	 =  case happyOut72 happy_x_1 of { happy_var_1 -> 
	happyIn73
		 ([ happy_var_1 ]
	)}

happyReduce_273 = happySpecReduce_2  59# happyReduction_273
happyReduction_273 happy_x_2
	happy_x_1
	 =  case happyOut73 happy_x_1 of { happy_var_1 -> 
	case happyOut72 happy_x_2 of { happy_var_2 -> 
	happyIn73
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_274 = happySpecReduce_3  60# happyReduction_274
happyReduction_274 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym BracketL) _)) -> 
	case happyOut70 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym BracketR) _)) -> 
	happyIn74
		 (Located (rComb happy_var_1 happy_var_3) [ happy_var_2 ]
	)}}}

happyReduce_275 = happyReduce 4# 60# happyReduction_275
happyReduction_275 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut74 happy_x_1 of { happy_var_1 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Located happy_var_4 (Token (Sym BracketR) _)) -> 
	happyIn74
		 (at (happy_var_1,happy_var_4) (fmap (happy_var_3 :) happy_var_1)
	) `HappyStk` happyRest}}}

happyReduce_276 = happySpecReduce_3  61# happyReduction_276
happyReduction_276 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut70 happy_x_1 of { happy_var_1 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	happyIn75
		 ([ happy_var_3, happy_var_1]
	)}}

happyReduce_277 = happySpecReduce_3  61# happyReduction_277
happyReduction_277 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut75 happy_x_1 of { happy_var_1 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	happyIn75
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_278 = happySpecReduce_3  62# happyReduction_278
happyReduction_278 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut79 happy_x_1 of { happy_var_1 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	happyIn76
		 (Named { name = happy_var_1, value = happy_var_3 }
	)}}

happyReduce_279 = happySpecReduce_1  63# happyReduction_279
happyReduction_279 happy_x_1
	 =  case happyOut76 happy_x_1 of { happy_var_1 -> 
	happyIn77
		 ([happy_var_1]
	)}

happyReduce_280 = happySpecReduce_3  63# happyReduction_280
happyReduction_280 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut77 happy_x_1 of { happy_var_1 -> 
	case happyOut76 happy_x_3 of { happy_var_3 -> 
	happyIn77
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_281 = happySpecReduce_1  64# happyReduction_281
happyReduction_281 happy_x_1
	 =  case happyOut79 happy_x_1 of { happy_var_1 -> 
	happyIn78
		 ([happy_var_1]
	)}

happyReduce_282 = happySpecReduce_3  64# happyReduction_282
happyReduction_282 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut78 happy_x_1 of { happy_var_1 -> 
	case happyOut79 happy_x_3 of { happy_var_3 -> 
	happyIn78
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_283 = happySpecReduce_1  65# happyReduction_283
happyReduction_283 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (Ident {}) _))) -> 
	happyIn79
		 (happy_var_1 { thing = getName happy_var_1 }
	)}

happyReduce_284 = happySpecReduce_1  65# happyReduction_284
happyReduction_284 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_x)       _)) -> 
	happyIn79
		 (Located { srcRange = happy_var_1, thing = Name "x" }
	)}

happyReduce_285 = happySpecReduce_1  65# happyReduction_285
happyReduction_285 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_private)   _)) -> 
	happyIn79
		 (Located { srcRange = happy_var_1, thing = Name "private" }
	)}

happyReduce_286 = happySpecReduce_1  65# happyReduction_286
happyReduction_286 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_as)        _)) -> 
	happyIn79
		 (Located { srcRange = happy_var_1, thing = Name "as" }
	)}

happyReduce_287 = happySpecReduce_1  65# happyReduction_287
happyReduction_287 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_hiding)    _)) -> 
	happyIn79
		 (Located { srcRange = happy_var_1, thing = Name "hiding" }
	)}

happyReduce_288 = happySpecReduce_1  66# happyReduction_288
happyReduction_288 happy_x_1
	 =  case happyOut78 happy_x_1 of { happy_var_1 -> 
	happyIn80
		 (mkModName happy_var_1
	)}

happyReduce_289 = happySpecReduce_1  67# happyReduction_289
happyReduction_289 happy_x_1
	 =  case happyOut78 happy_x_1 of { happy_var_1 -> 
	happyIn81
		 (mkQName happy_var_1
	)}

happyReduce_290 = happySpecReduce_1  68# happyReduction_290
happyReduction_290 happy_x_1
	 =  case happyOut81 happy_x_1 of { happy_var_1 -> 
	happyIn82
		 (at happy_var_1 $ TUser (thing happy_var_1) []
	)}

happyReduce_291 = happySpecReduce_1  68# happyReduction_291
happyReduction_291 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (Num   {}) _))) -> 
	happyIn82
		 (at happy_var_1 $ TNum  (getNum happy_var_1)
	)}

happyReduce_292 = happyMonadReduce 3# 68# happyReduction_292
happyReduction_292 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut70 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	( validDemotedType (rComb happy_var_1 happy_var_3) happy_var_2)}}}
	) (\r -> happyReturn (happyIn82 r))

happyReduce_293 = happySpecReduce_2  68# happyReduction_293
happyReduction_293 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym CurlyR  ) _)) -> 
	happyIn82
		 (at (happy_var_1,happy_var_2) (TRecord [])
	)}}

happyReduce_294 = happySpecReduce_3  68# happyReduction_294
happyReduction_294 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOut84 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym CurlyR  ) _)) -> 
	happyIn82
		 (at (happy_var_1,happy_var_3) (TRecord (reverse happy_var_2))
	)}}}

happyReduce_295 = happySpecReduce_3  68# happyReduction_295
happyReduction_295 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOut70 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym CurlyR  ) _)) -> 
	happyIn82
		 (anonRecord (getLoc (happy_var_1,happy_var_3)) [happy_var_2]
	)}}}

happyReduce_296 = happySpecReduce_3  68# happyReduction_296
happyReduction_296 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOut75 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym CurlyR  ) _)) -> 
	happyIn82
		 (anonRecord (getLoc (happy_var_1,happy_var_3)) (reverse happy_var_2)
	)}}}

happyReduce_297 = happySpecReduce_3  69# happyReduction_297
happyReduction_297 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut79 happy_x_1 of { happy_var_1 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	happyIn83
		 (Named { name = happy_var_1, value = happy_var_3 }
	)}}

happyReduce_298 = happySpecReduce_1  70# happyReduction_298
happyReduction_298 happy_x_1
	 =  case happyOut83 happy_x_1 of { happy_var_1 -> 
	happyIn84
		 ([happy_var_1]
	)}

happyReduce_299 = happySpecReduce_3  70# happyReduction_299
happyReduction_299 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut84 happy_x_1 of { happy_var_1 -> 
	case happyOut83 happy_x_3 of { happy_var_3 -> 
	happyIn84
		 (happy_var_3 : happy_var_1
	)}}

happyNewToken action sts stk
	= lexerP(\tk -> 
	let cont i = happyDoAction i tk action sts stk in
	case tk of {
	Located _ (Token EOF _) -> happyDoAction 96# tk action sts stk;
	happy_dollar_dollar@(Located _ (Token (Num   {}) _)) -> cont 1#;
	happy_dollar_dollar@(Located _ (Token (Ident {}) _)) -> cont 2#;
	happy_dollar_dollar@(Located _ (Token (StrLit {}) _)) -> cont 3#;
	happy_dollar_dollar@(Located _ (Token (ChrLit {}) _)) -> cont 4#;
	Located happy_dollar_dollar (Token (KW KW_include)   _) -> cont 5#;
	Located happy_dollar_dollar (Token (KW KW_import)    _) -> cont 6#;
	Located happy_dollar_dollar (Token (KW KW_as)        _) -> cont 7#;
	Located happy_dollar_dollar (Token (KW KW_hiding)    _) -> cont 8#;
	Located happy_dollar_dollar (Token (KW KW_private)   _) -> cont 9#;
	Located happy_dollar_dollar (Token (KW KW_property)  _) -> cont 10#;
	Located happy_dollar_dollar (Token (KW KW_False  ) _) -> cont 11#;
	Located happy_dollar_dollar (Token (KW KW_True   ) _) -> cont 12#;
	Located happy_dollar_dollar (Token (KW KW_Arith  ) _) -> cont 13#;
	Located happy_dollar_dollar (Token (KW KW_Bit    ) _) -> cont 14#;
	Located happy_dollar_dollar (Token (KW KW_Cmp    ) _) -> cont 15#;
	Located happy_dollar_dollar (Token (KW KW_error  ) _) -> cont 16#;
	Located happy_dollar_dollar (Token (KW KW_fin    ) _) -> cont 17#;
	Located happy_dollar_dollar (Token (KW KW_inf    ) _) -> cont 18#;
	Located happy_dollar_dollar (Token (KW KW_lg2    ) _) -> cont 19#;
	Located happy_dollar_dollar (Token (KW KW_lengthFromThen) _) -> cont 20#;
	Located happy_dollar_dollar (Token (KW KW_lengthFromThenTo) _) -> cont 21#;
	Located happy_dollar_dollar (Token (KW KW_type   ) _) -> cont 22#;
	Located happy_dollar_dollar (Token (KW KW_newtype) _) -> cont 23#;
	Located happy_dollar_dollar (Token (KW KW_module ) _) -> cont 24#;
	Located happy_dollar_dollar (Token (KW KW_where  ) _) -> cont 25#;
	Located happy_dollar_dollar (Token (KW KW_let    ) _) -> cont 26#;
	Located happy_dollar_dollar (Token (KW KW_if     ) _) -> cont 27#;
	Located happy_dollar_dollar (Token (KW KW_then   ) _) -> cont 28#;
	Located happy_dollar_dollar (Token (KW KW_else   ) _) -> cont 29#;
	Located happy_dollar_dollar (Token (KW KW_min    ) _) -> cont 30#;
	Located happy_dollar_dollar (Token (KW KW_max    ) _) -> cont 31#;
	Located happy_dollar_dollar (Token (KW KW_zero   ) _) -> cont 32#;
	Located happy_dollar_dollar (Token (KW KW_join   ) _) -> cont 33#;
	Located happy_dollar_dollar (Token (KW KW_reverse) _) -> cont 34#;
	Located happy_dollar_dollar (Token (KW KW_split  ) _) -> cont 35#;
	Located happy_dollar_dollar (Token (KW KW_splitAt) _) -> cont 36#;
	Located happy_dollar_dollar (Token (KW KW_transpose) _) -> cont 37#;
	Located happy_dollar_dollar (Token (KW KW_x)       _) -> cont 38#;
	Located happy_dollar_dollar (Token (KW KW_pmult)   _) -> cont 39#;
	Located happy_dollar_dollar (Token (KW KW_pmod)    _) -> cont 40#;
	Located happy_dollar_dollar (Token (KW KW_pdiv)    _) -> cont 41#;
	Located happy_dollar_dollar (Token (KW KW_random)  _) -> cont 42#;
	Located happy_dollar_dollar (Token (Sym BracketL) _) -> cont 43#;
	Located happy_dollar_dollar (Token (Sym BracketR) _) -> cont 44#;
	Located happy_dollar_dollar (Token (Sym ArrL    ) _) -> cont 45#;
	Located happy_dollar_dollar (Token (Sym DotDot  ) _) -> cont 46#;
	Located happy_dollar_dollar (Token (Sym DotDotDot) _) -> cont 47#;
	Located happy_dollar_dollar (Token (Sym Bar     ) _) -> cont 48#;
	Located happy_dollar_dollar (Token (Sym ParenL  ) _) -> cont 49#;
	Located happy_dollar_dollar (Token (Sym ParenR  ) _) -> cont 50#;
	Located happy_dollar_dollar (Token (Sym Comma   ) _) -> cont 51#;
	Located happy_dollar_dollar (Token (Sym Semi    ) _) -> cont 52#;
	Located happy_dollar_dollar (Token (Sym Dot     ) _) -> cont 53#;
	Located happy_dollar_dollar (Token (Sym CurlyL  ) _) -> cont 54#;
	Located happy_dollar_dollar (Token (Sym CurlyR  ) _) -> cont 55#;
	Located happy_dollar_dollar (Token (Sym TriL    ) _) -> cont 56#;
	Located happy_dollar_dollar (Token (Sym TriR    ) _) -> cont 57#;
	Located happy_dollar_dollar (Token (Sym EqDef   ) _) -> cont 58#;
	Located happy_dollar_dollar (Token (Sym BackTick) _) -> cont 59#;
	Located happy_dollar_dollar (Token (Sym Colon   ) _) -> cont 60#;
	Located happy_dollar_dollar (Token (Sym ColonColon) _) -> cont 61#;
	Located happy_dollar_dollar (Token (Sym ArrR    ) _) -> cont 62#;
	Located happy_dollar_dollar (Token (Sym FatArrR ) _) -> cont 63#;
	Located happy_dollar_dollar (Token (Sym Lambda  ) _) -> cont 64#;
	Located happy_dollar_dollar (Token (Sym Underscore ) _) -> cont 65#;
	Located happy_dollar_dollar (Token (Virt VCurlyL)  _) -> cont 66#;
	Located happy_dollar_dollar (Token (Virt VCurlyR)  _) -> cont 67#;
	Located happy_dollar_dollar (Token (Virt VSemi)    _) -> cont 68#;
	Located happy_dollar_dollar (Token (Op Plus        ) _) -> cont 69#;
	Located happy_dollar_dollar (Token (Op Minus       ) _) -> cont 70#;
	Located happy_dollar_dollar (Token (Op Mul         ) _) -> cont 71#;
	Located happy_dollar_dollar (Token (Op Div         ) _) -> cont 72#;
	Located happy_dollar_dollar (Token (Op Exp         ) _) -> cont 73#;
	Located happy_dollar_dollar (Token (Op Mod         ) _) -> cont 74#;
	Located happy_dollar_dollar (Token (Op Xor         ) _) -> cont 75#;
	Located happy_dollar_dollar (Token (Op Disj        ) _) -> cont 76#;
	Located happy_dollar_dollar (Token (Op Conj        ) _) -> cont 77#;
	Located happy_dollar_dollar (Token (Op NotEqual    ) _) -> cont 78#;
	Located happy_dollar_dollar (Token (Op Equal       ) _) -> cont 79#;
	Located happy_dollar_dollar (Token (Op NotEqualFun ) _) -> cont 80#;
	Located happy_dollar_dollar (Token (Op EqualFun    ) _) -> cont 81#;
	Located happy_dollar_dollar (Token (Op GreaterThan ) _) -> cont 82#;
	Located happy_dollar_dollar (Token (Op LessThan    ) _) -> cont 83#;
	Located happy_dollar_dollar (Token (Op LEQ         ) _) -> cont 84#;
	Located happy_dollar_dollar (Token (Op GEQ         ) _) -> cont 85#;
	Located happy_dollar_dollar (Token (Op ShiftR      ) _) -> cont 86#;
	Located happy_dollar_dollar (Token (Op ShiftL      ) _) -> cont 87#;
	Located happy_dollar_dollar (Token (Op RotR        ) _) -> cont 88#;
	Located happy_dollar_dollar (Token (Op RotL        ) _) -> cont 89#;
	Located happy_dollar_dollar (Token (Op Complement  ) _) -> cont 90#;
	Located happy_dollar_dollar (Token (Op At          ) _) -> cont 91#;
	Located happy_dollar_dollar (Token (Op AtAt        ) _) -> cont 92#;
	Located happy_dollar_dollar (Token (Op Bang        ) _) -> cont 93#;
	Located happy_dollar_dollar (Token (Op BangBang    ) _) -> cont 94#;
	Located happy_dollar_dollar (Token (Op Hash        ) _) -> cont 95#;
	_ -> happyError' tk
	})

happyError_ 96# tk = happyError' tk
happyError_ _ tk = happyError' tk

happyThen :: () => ParseM a -> (a -> ParseM b) -> ParseM b
happyThen = (>>=)
happyReturn :: () => a -> ParseM a
happyReturn = (return)
happyThen1 = happyThen
happyReturn1 :: () => a -> ParseM a
happyReturn1 = happyReturn
happyError' :: () => (Located Token) -> ParseM a
happyError' tk = (\token -> happyError) tk

vmodule = happySomeParser where
  happySomeParser = happyThen (happyParse 0#) (\x -> happyReturn (happyOut14 x))

program = happySomeParser where
  happySomeParser = happyThen (happyParse 1#) (\x -> happyReturn (happyOut22 x))

programLayout = happySomeParser where
  happySomeParser = happyThen (happyParse 2#) (\x -> happyReturn (happyOut23 x))

expr = happySomeParser where
  happySomeParser = happyThen (happyParse 3#) (\x -> happyReturn (happyOut38 x))

decl = happySomeParser where
  happySomeParser = happyThen (happyParse 4#) (\x -> happyReturn (happyOut28 x))

decls = happySomeParser where
  happySomeParser = happyThen (happyParse 5#) (\x -> happyReturn (happyOut34 x))

declsLayout = happySomeParser where
  happySomeParser = happyThen (happyParse 6#) (\x -> happyReturn (happyOut36 x))

letDecl = happySomeParser where
  happySomeParser = happyThen (happyParse 7#) (\x -> happyReturn (happyOut29 x))

repl = happySomeParser where
  happySomeParser = happyThen (happyParse 8#) (\x -> happyReturn (happyOut37 x))

schema = happySomeParser where
  happySomeParser = happyThen (happyParse 9#) (\x -> happyReturn (happyOut60 x))

modName = happySomeParser where
  happySomeParser = happyThen (happyParse 10#) (\x -> happyReturn (happyOut80 x))

happySeq = happyDontSeq


parseModName :: String -> Maybe ModName
parseModName txt =
  case parse defaultConfig { cfgModuleScope = False } modName txt of
    Right a -> Just (thing a)
    Left _  -> Nothing

addImplicitIncludes :: Config -> Program -> Program
addImplicitIncludes cfg (Program ds) =
  Program $ map path (cfgAutoInclude cfg) ++ ds
  where path p = Include Located { srcRange = rng, thing = p }
        rng    = Range { source = cfgSource cfg, from = start, to = start }


parseProgramWith :: Config -> String -> Either ParseError Program
parseProgramWith cfg s = case res s of
                          Left err -> Left err
                          Right a  -> Right (addImplicitIncludes cfg a)
  where
  res = parse cfg $ case cfgLayout cfg of
                      Layout   -> programLayout
                      NoLayout -> program

parseModule :: Config -> String -> Either ParseError Module
parseModule cfg = parse cfg { cfgModuleScope = True } vmodule

parseProgram :: Layout -> String -> Either ParseError Program
parseProgram l = parseProgramWith defaultConfig { cfgLayout = l }

parseExprWith :: Config -> String -> Either ParseError Expr
parseExprWith cfg = parse cfg { cfgModuleScope = False } expr

parseExpr :: String -> Either ParseError Expr
parseExpr = parseExprWith defaultConfig

parseDeclWith :: Config -> String -> Either ParseError Decl
parseDeclWith cfg = parse cfg { cfgModuleScope = False } decl

parseDecl :: String -> Either ParseError Decl
parseDecl = parseDeclWith defaultConfig

parseDeclsWith :: Config -> String -> Either ParseError [Decl]
parseDeclsWith cfg = parse cfg { cfgModuleScope = ms } decls'
  where (ms, decls') = case cfgLayout cfg of
                         Layout   -> (True, declsLayout)
                         NoLayout -> (False, decls)

parseDecls :: String -> Either ParseError [Decl]
parseDecls = parseDeclsWith defaultConfig

parseLetDeclWith :: Config -> String -> Either ParseError Decl
parseLetDeclWith cfg = parse cfg { cfgModuleScope = False } letDecl

parseLetDecl :: String -> Either ParseError Decl
parseLetDecl = parseLetDeclWith defaultConfig

parseReplWith :: Config -> String -> Either ParseError ReplInput
parseReplWith cfg = parse cfg { cfgModuleScope = False } repl

parseRepl :: String -> Either ParseError ReplInput
parseRepl = parseReplWith defaultConfig

parseSchemaWith :: Config -> String -> Either ParseError Schema
parseSchemaWith cfg = parse cfg { cfgModuleScope = False } schema

parseSchema :: String -> Either ParseError Schema
parseSchema = parseSchemaWith defaultConfig

-- vim: ft=haskell
{-# LINE 1 "templates/GenericTemplate.hs" #-}
{-# LINE 1 "templates/GenericTemplate.hs" #-}
{-# LINE 1 "<built-in>" #-}
{-# LINE 1 "templates/GenericTemplate.hs" #-}
-- Id: GenericTemplate.hs,v 1.26 2005/01/14 14:47:22 simonmar Exp 


{-# LINE 13 "templates/GenericTemplate.hs" #-}





-- Do not remove this comment. Required to fix CPP parsing when using GCC and a clang-compiled alex.
#if __GLASGOW_HASKELL__ > 706
#define LT(n,m) ((Happy_GHC_Exts.tagToEnum# (n Happy_GHC_Exts.<# m)) :: Bool)
#define GTE(n,m) ((Happy_GHC_Exts.tagToEnum# (n Happy_GHC_Exts.>=# m)) :: Bool)
#define EQ(n,m) ((Happy_GHC_Exts.tagToEnum# (n Happy_GHC_Exts.==# m)) :: Bool)
#else
#define LT(n,m) (n Happy_GHC_Exts.<# m)
#define GTE(n,m) (n Happy_GHC_Exts.>=# m)
#define EQ(n,m) (n Happy_GHC_Exts.==# m)
#endif

{-# LINE 46 "templates/GenericTemplate.hs" #-}


data Happy_IntList = HappyCons Happy_GHC_Exts.Int# Happy_IntList






{-# LINE 67 "templates/GenericTemplate.hs" #-}


{-# LINE 77 "templates/GenericTemplate.hs" #-}










infixr 9 `HappyStk`
data HappyStk a = HappyStk a (HappyStk a)

-----------------------------------------------------------------------------
-- starting the parse

happyParse start_state = happyNewToken start_state notHappyAtAll notHappyAtAll

-----------------------------------------------------------------------------
-- Accepting the parse

-- If the current token is 0#, it means we've just accepted a partial
-- parse (a %partial parser).  We must ignore the saved token on the top of
-- the stack in this case.
happyAccept 0# tk st sts (_ `HappyStk` ans `HappyStk` _) =
        happyReturn1 ans
happyAccept j tk st sts (HappyStk ans _) = 
        (happyTcHack j (happyTcHack st)) (happyReturn1 ans)

-----------------------------------------------------------------------------
-- Arrays only: do the next action



happyDoAction i tk st
        = {- nothing -}
          

          case action of
                0#           -> {- nothing -}
                                     happyFail i tk st
                -1#          -> {- nothing -}
                                     happyAccept i tk st
                n | LT(n,(0# :: Happy_GHC_Exts.Int#)) -> {- nothing -}
                                                   
                                                   (happyReduceArr Happy_Data_Array.! rule) i tk st
                                                   where rule = (Happy_GHC_Exts.I# ((Happy_GHC_Exts.negateInt# ((n Happy_GHC_Exts.+# (1# :: Happy_GHC_Exts.Int#))))))
                n                 -> {- nothing -}
                                     

                                     happyShift new_state i tk st
                                     where new_state = (n Happy_GHC_Exts.-# (1# :: Happy_GHC_Exts.Int#))
   where off    = indexShortOffAddr happyActOffsets st
         off_i  = (off Happy_GHC_Exts.+# i)
         check  = if GTE(off_i,(0# :: Happy_GHC_Exts.Int#))
                  then EQ(indexShortOffAddr happyCheck off_i, i)
                  else False
         action
          | check     = indexShortOffAddr happyTable off_i
          | otherwise = indexShortOffAddr happyDefActions st


indexShortOffAddr (HappyA# arr) off =
        Happy_GHC_Exts.narrow16Int# i
  where
        i = Happy_GHC_Exts.word2Int# (Happy_GHC_Exts.or# (Happy_GHC_Exts.uncheckedShiftL# high 8#) low)
        high = Happy_GHC_Exts.int2Word# (Happy_GHC_Exts.ord# (Happy_GHC_Exts.indexCharOffAddr# arr (off' Happy_GHC_Exts.+# 1#)))
        low  = Happy_GHC_Exts.int2Word# (Happy_GHC_Exts.ord# (Happy_GHC_Exts.indexCharOffAddr# arr off'))
        off' = off Happy_GHC_Exts.*# 2#





data HappyAddr = HappyA# Happy_GHC_Exts.Addr#




-----------------------------------------------------------------------------
-- HappyState data type (not arrays)


{-# LINE 170 "templates/GenericTemplate.hs" #-}

-----------------------------------------------------------------------------
-- Shifting a token

happyShift new_state 0# tk st sts stk@(x `HappyStk` _) =
     let i = (case Happy_GHC_Exts.unsafeCoerce# x of { (Happy_GHC_Exts.I# (i)) -> i }) in
--     trace "shifting the error token" $
     happyDoAction i tk new_state (HappyCons (st) (sts)) (stk)

happyShift new_state i tk st sts stk =
     happyNewToken new_state (HappyCons (st) (sts)) ((happyInTok (tk))`HappyStk`stk)

-- happyReduce is specialised for the common cases.

happySpecReduce_0 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_0 nt fn j tk st@((action)) sts stk
     = happyGoto nt j tk st (HappyCons (st) (sts)) (fn `HappyStk` stk)

happySpecReduce_1 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_1 nt fn j tk _ sts@((HappyCons (st@(action)) (_))) (v1`HappyStk`stk')
     = let r = fn v1 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happySpecReduce_2 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_2 nt fn j tk _ (HappyCons (_) (sts@((HappyCons (st@(action)) (_))))) (v1`HappyStk`v2`HappyStk`stk')
     = let r = fn v1 v2 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happySpecReduce_3 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_3 nt fn j tk _ (HappyCons (_) ((HappyCons (_) (sts@((HappyCons (st@(action)) (_))))))) (v1`HappyStk`v2`HappyStk`v3`HappyStk`stk')
     = let r = fn v1 v2 v3 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happyReduce k i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happyReduce k nt fn j tk st sts stk
     = case happyDrop (k Happy_GHC_Exts.-# (1# :: Happy_GHC_Exts.Int#)) sts of
         sts1@((HappyCons (st1@(action)) (_))) ->
                let r = fn stk in  -- it doesn't hurt to always seq here...
                happyDoSeq r (happyGoto nt j tk st1 sts1 r)

happyMonadReduce k nt fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happyMonadReduce k nt fn j tk st sts stk =
      case happyDrop k (HappyCons (st) (sts)) of
        sts1@((HappyCons (st1@(action)) (_))) ->
          let drop_stk = happyDropStk k stk in
          happyThen1 (fn stk tk) (\r -> happyGoto nt j tk st1 sts1 (r `HappyStk` drop_stk))

happyMonad2Reduce k nt fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happyMonad2Reduce k nt fn j tk st sts stk =
      case happyDrop k (HappyCons (st) (sts)) of
        sts1@((HappyCons (st1@(action)) (_))) ->
         let drop_stk = happyDropStk k stk

             off = indexShortOffAddr happyGotoOffsets st1
             off_i = (off Happy_GHC_Exts.+# nt)
             new_state = indexShortOffAddr happyTable off_i



          in
          happyThen1 (fn stk tk) (\r -> happyNewToken new_state sts1 (r `HappyStk` drop_stk))

happyDrop 0# l = l
happyDrop n (HappyCons (_) (t)) = happyDrop (n Happy_GHC_Exts.-# (1# :: Happy_GHC_Exts.Int#)) t

happyDropStk 0# l = l
happyDropStk n (x `HappyStk` xs) = happyDropStk (n Happy_GHC_Exts.-# (1#::Happy_GHC_Exts.Int#)) xs

-----------------------------------------------------------------------------
-- Moving to a new state after a reduction


happyGoto nt j tk st = 
   {- nothing -}
   happyDoAction j tk new_state
   where off = indexShortOffAddr happyGotoOffsets st
         off_i = (off Happy_GHC_Exts.+# nt)
         new_state = indexShortOffAddr happyTable off_i




-----------------------------------------------------------------------------
-- Error recovery (0# is the error token)

-- parse error if we are in recovery and we fail again
happyFail 0# tk old_st _ stk@(x `HappyStk` _) =
     let i = (case Happy_GHC_Exts.unsafeCoerce# x of { (Happy_GHC_Exts.I# (i)) -> i }) in
--      trace "failing" $ 
        happyError_ i tk

{-  We don't need state discarding for our restricted implementation of
    "error".  In fact, it can cause some bogus parses, so I've disabled it
    for now --SDM

-- discard a state
happyFail  0# tk old_st (HappyCons ((action)) (sts)) 
                                                (saved_tok `HappyStk` _ `HappyStk` stk) =
--      trace ("discarding state, depth " ++ show (length stk))  $
        happyDoAction 0# tk action sts ((saved_tok`HappyStk`stk))
-}

-- Enter error recovery: generate an error token,
--                       save the old token and carry on.
happyFail  i tk (action) sts stk =
--      trace "entering error recovery" $
        happyDoAction 0# tk action sts ( (Happy_GHC_Exts.unsafeCoerce# (Happy_GHC_Exts.I# (i))) `HappyStk` stk)

-- Internal happy errors:

notHappyAtAll :: a
notHappyAtAll = error "Internal Happy error\n"

-----------------------------------------------------------------------------
-- Hack to get the typechecker to accept our action functions


happyTcHack :: Happy_GHC_Exts.Int# -> a -> a
happyTcHack x y = y
{-# INLINE happyTcHack #-}


-----------------------------------------------------------------------------
-- Seq-ing.  If the --strict flag is given, then Happy emits 
--      happySeq = happyDoSeq
-- otherwise it emits
--      happySeq = happyDontSeq

happyDoSeq, happyDontSeq :: a -> b -> b
happyDoSeq   a b = a `seq` b
happyDontSeq a b = b

-----------------------------------------------------------------------------
-- Don't inline any functions from the template.  GHC has a nasty habit
-- of deciding to inline happyGoto everywhere, which increases the size of
-- the generated parser quite a bit.


{-# NOINLINE happyDoAction #-}
{-# NOINLINE happyTable #-}
{-# NOINLINE happyCheck #-}
{-# NOINLINE happyActOffsets #-}
{-# NOINLINE happyGotoOffsets #-}
{-# NOINLINE happyDefActions #-}

{-# NOINLINE happyShift #-}
{-# NOINLINE happySpecReduce_0 #-}
{-# NOINLINE happySpecReduce_1 #-}
{-# NOINLINE happySpecReduce_2 #-}
{-# NOINLINE happySpecReduce_3 #-}
{-# NOINLINE happyReduce #-}
{-# NOINLINE happyMonadReduce #-}
{-# NOINLINE happyGoto #-}
{-# NOINLINE happyFail #-}

-- end of Happy Template.

