The Gudhi library is an open source library for Computational Topology and
Topological Data Analysis (TDA). It offers state-of-the-art algorithms
to construct various types of simplicial complexes, data structures to
represent them, and algorithms to compute geometric approximations of shapes
and persistent homology.

The GUDHI library offers the following interoperable modules:

* Complexes:
   * Cubical
   * Simplicial: Rips, Witness, Alpha and Čech complexes
   * Cover: Nerve and Graph induced complexes
* Data structures and basic operations:
   * Simplex tree, Skeleton blockers and Toplex map
   * Construction, update, filtration and simplification
* Topological descriptors computation
* Manifold reconstruction
* Topological descriptors tools:
   * Bottleneck distance
   * Statistical tools
   * Persistence diagram and barcode

For more information about Topological Data Analysis and its workflow, please
refer to the `Wikipedia TDA dedicated page <https://en.wikipedia.org/wiki/Topological_data_analysis>`_.