// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKDATABOXMM_XYC_GRAPH_H
#define _GTKDATABOXMM_XYC_GRAPH_H

#include <gtkdataboxmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (c) 2012  iCub Facility, Istituto Italiano di Tecnologia
 *   @author Daniele E. Domenichelli <daniele.domenichelli@iit.it>
 *
 * This file is part of gtkdataboxmm.
 *
 * gtkdataboxmm is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 2.1 of the License,
 * or (at your option) any later version.
 *
 * gtkdataboxmm is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <gtkdataboxmm/graph.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkDataboxXYCGraph GtkDataboxXYCGraph;
typedef struct _GtkDataboxXYCGraphClass GtkDataboxXYCGraphClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace GDatabox
{ class XYCGraph_Class; } // namespace GDatabox
namespace GDatabox
{


class XYCGraph : public Graph
{
    
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef XYCGraph CppObjectType;
  typedef XYCGraph_Class CppClassType;
  typedef GtkDataboxXYCGraph BaseObjectType;
  typedef GtkDataboxXYCGraphClass BaseClassType;

private:  friend class XYCGraph_Class;
  static CppClassType xycgraph_class_;

private:
  // noncopyable
  XYCGraph(const XYCGraph&);
  XYCGraph& operator=(const XYCGraph&);

protected:
  explicit XYCGraph(const Glib::ConstructParams& construct_params);
  explicit XYCGraph(GtkDataboxXYCGraph* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~XYCGraph();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkDataboxXYCGraph*       gobj()       { return reinterpret_cast<GtkDataboxXYCGraph*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkDataboxXYCGraph* gobj() const { return reinterpret_cast<GtkDataboxXYCGraph*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkDataboxXYCGraph* gobj_copy();

private:


protected:
    XYCGraph();

public:
    
  /** Gets the the length of the X and Y values arrays.
   * @return Length of X/Y arrays.
   */
  unsigned int get_length() const;
    
  /** Gets the X values of the @a xzc_graph.
   * @return Pointer to X values.
   */
  float* get_X() const;
    
  /** Gets the Y values of the @a xzc_graph.
   * @return Pointer to Y values.
   */
  float* get_Y() const;

    #ifdef GLIBMM_PROPERTIES_ENABLED
/** number of data points.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< unsigned int > property_length() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


    #ifdef GLIBMM_PROPERTIES_ENABLED
/** X values of data.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< float* > property_X_Values() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

;
    #ifdef GLIBMM_PROPERTIES_ENABLED
/** Y values of data.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< float* > property_Y_Values() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace GDatabox


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates GDatabox::XYCGraph
   */
  Glib::RefPtr<GDatabox::XYCGraph> wrap(GtkDataboxXYCGraph* object, bool take_copy = false);
}


#endif /* _GTKDATABOXMM_XYC_GRAPH_H */

