//**************************************************************************************************
//                                        CpntNgsIndSrc.hpp                                        *
//                                       -------------------                                       *
// Description : This class represents a component definition line for an NG-Spice independent     *
//               voltage or current source.                                                        *
// Started     : 2008-06-12                                                                        *
// Last Update : 2015-04-16                                                                        *
// Copyright   : (C) 2008 by MSWaters                                                              *
//**************************************************************************************************

//**************************************************************************************************
//                                                                                                 *
//      This program is free software; you can redistribute it and/or modify it under the          *
//      terms of the GNU General Public License as published by the Free Software Foundation;      *
//      either version 3 of the License, or (at your option) any later version.                    *
//                                                                                                 *
//**************************************************************************************************

#ifndef CPNTNGSINDSRC_HPP
#define CPNTNGSINDSRC_HPP

// Application Includes

#include "TypeDefs.hpp"
#include "netlist/Component.hpp"
#include "gnucap/commands/CmdGnuCapGEN.hpp"

class CmdGnuCapGEN;

// wxWidgets Includes

#include <wx/tokenzr.h>

// Local Constant Declarations

#define  NGS_SINAMP      wxT("1.0")
#define  NGS_SINOFFSET   wxT("0.0")
#define  NGS_SINFREQ     wxT("1.0K")
#define  NGS_SINDELAY    wxT("0.0m")
#define  NGS_SINDAMP     wxT("0.0")

#define  NGS_PULINITIAL  wxT("0.0")
#define  NGS_PULMAX      wxT("0.0")
#define  NGS_PULDELAY    wxT("0.0m")
#define  NGS_PULRISE     wxT("0.0m")
#define  NGS_PULWIDTH    wxT("0.0m")
#define  NGS_PULFALL     wxT("0.0m")
#define  NGS_PULPERIOD   wxT("0.0m")

//**************************************************************************************************

class CpntNgsIndSrc : public Component
{
  private :

    virtual  bool  bParseValue ( void );
    virtual  bool  bFormatValue( void );
    virtual  bool  bValidate   ( void );

             void  ClrValues( void );

  public :

    // Value for a sinusoidal source
    wxString  m_osSinOffset;
    wxString  m_osSinAmp;
    wxString  m_osSinFreq;
    wxString  m_osSinDelay;
    wxString  m_osSinDamp;

    // Value for a pulse source
    wxString  m_osPulInitial;
    wxString  m_osPulMax;
    wxString  m_osPulDelay;
    wxString  m_osPulRise;
    wxString  m_osPulWidth;
    wxString  m_osPulFall;
    wxString  m_osPulPeriod;

                   CpntNgsIndSrc( void );
    virtual       ~CpntNgsIndSrc( );

    virtual  bool  bClear( void );

    CpntNgsIndSrc & operator = ( const Component    & roCpnt   );
    CpntNgsIndSrc & operator = ( const CmdGnuCapGEN & roCmdGEN );

    void  Print( const wxString & rosPrefix=wxT("  ") );
};

//**************************************************************************************************

#endif // CPNTNGSINDSRC_HPP
