package incremental

import (
	"testing"
)

type someInt16Struct struct {
	i Int16
}

func TestInt16Ptr(t *testing.T) {
	i := &Int16{}
	num := i.Next()
	if num != 1 {
		t.Fatalf("expected 1, got %d", num)
	}
	num = i.Next()
	if num != 2 {
		t.Fatalf("expected 2, got %d", num)
	}
	num = i.Last()
	if num != 2 {
		t.Fatalf("expected last to be 2, got %d", num)
	}

	i.Set(42)
	num = i.Last()
	if num != 42 {
		t.Fatalf("expected last to be 42, got %d", num)
	}
	num = i.Next()
	if num != 43 {
		t.Fatalf("expected 43, got %d", num)
	}
}

func TestInt16AsField(t *testing.T) {
	s := someInt16Struct{}
	num := s.i.Next()
	if num != 1 {
		t.Fatalf("expected 1, got %d", num)
	}
	num = s.i.Next()
	if num != 2 {
		t.Fatalf("expected 2, got %d", num)
	}
	num = s.i.Last()
	if num != 2 {
		t.Fatalf("expected last to be 2, got %d", num)
	}

	useSomeInt16Struct(&s, t)

	num = s.i.Last()
	if num != 3 {
		t.Fatalf("expected last to be 3, got %d", num)
	}

	s.i.Set(42)
	num = s.i.Last()
	if num != 42 {
		t.Fatalf("expected last to be 42, got %d", num)
	}
	num = s.i.Next()
	if num != 43 {
		t.Fatalf("expected 43, got %d", num)
	}
}

func useSomeInt16Struct(s *someInt16Struct, t *testing.T) {
	num := s.i.Next()
	if num != 3 {
		t.Fatalf("expected 3, got %d", num)
	}
}
