// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package support provides a client for AWS Support.
package support

import (
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAddAttachmentsToSet = "AddAttachmentsToSet"

// AddAttachmentsToSetRequest generates a "aws/request.Request" representing the
// client's request for the AddAttachmentsToSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AddAttachmentsToSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AddAttachmentsToSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AddAttachmentsToSetRequest method.
//    req, resp := client.AddAttachmentsToSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Support) AddAttachmentsToSetRequest(input *AddAttachmentsToSetInput) (req *request.Request, output *AddAttachmentsToSetOutput) {
	op := &request.Operation{
		Name:       opAddAttachmentsToSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddAttachmentsToSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AddAttachmentsToSetOutput{}
	req.Data = output
	return
}

// AddAttachmentsToSet API operation for AWS Support.
//
// Adds one or more attachments to an attachment set. If an attachmentSetId
// is not specified, a new attachment set is created, and the ID of the set
// is returned in the response. If an attachmentSetId is specified, the attachments
// are added to the specified set, if it exists.
//
// An attachment set is a temporary container for attachments that are to be
// added to a case or case communication. The set is available for one hour
// after it is created; the expiryTime returned in the response indicates when
// the set expires. The maximum number of attachments in a set is 3, and the
// maximum size of any attachment in the set is 5 MB.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support's
// API operation AddAttachmentsToSet for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   An internal server error occurred.
//
//   * AttachmentSetIdNotFound
//   An attachment set with the specified ID could not be found.
//
//   * AttachmentSetExpired
//   The expiration time of the attachment set has passed. The set expires 1 hour
//   after it is created.
//
//   * AttachmentSetSizeLimitExceeded
//   A limit for the size of an attachment set has been exceeded. The limits are
//   3 attachments and 5 MB per attachment.
//
//   * AttachmentLimitExceeded
//   The limit for the number of attachment sets created in a short period of
//   time has been exceeded.
//
func (c *Support) AddAttachmentsToSet(input *AddAttachmentsToSetInput) (*AddAttachmentsToSetOutput, error) {
	req, out := c.AddAttachmentsToSetRequest(input)
	err := req.Send()
	return out, err
}

const opAddCommunicationToCase = "AddCommunicationToCase"

// AddCommunicationToCaseRequest generates a "aws/request.Request" representing the
// client's request for the AddCommunicationToCase operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AddCommunicationToCase for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AddCommunicationToCase method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AddCommunicationToCaseRequest method.
//    req, resp := client.AddCommunicationToCaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Support) AddCommunicationToCaseRequest(input *AddCommunicationToCaseInput) (req *request.Request, output *AddCommunicationToCaseOutput) {
	op := &request.Operation{
		Name:       opAddCommunicationToCase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddCommunicationToCaseInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AddCommunicationToCaseOutput{}
	req.Data = output
	return
}

// AddCommunicationToCase API operation for AWS Support.
//
// Adds additional customer communication to an AWS Support case. You use the
// caseId value to identify the case to add communication to. You can list a
// set of email addresses to copy on the communication using the ccEmailAddresses
// value. The communicationBody value contains the text of the communication.
//
// The response indicates the success or failure of the request.
//
// This operation implements a subset of the features of the AWS Support Center.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support's
// API operation AddCommunicationToCase for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   An internal server error occurred.
//
//   * CaseIdNotFound
//   The requested caseId could not be located.
//
//   * AttachmentSetIdNotFound
//   An attachment set with the specified ID could not be found.
//
//   * AttachmentSetExpired
//   The expiration time of the attachment set has passed. The set expires 1 hour
//   after it is created.
//
func (c *Support) AddCommunicationToCase(input *AddCommunicationToCaseInput) (*AddCommunicationToCaseOutput, error) {
	req, out := c.AddCommunicationToCaseRequest(input)
	err := req.Send()
	return out, err
}

const opCreateCase = "CreateCase"

// CreateCaseRequest generates a "aws/request.Request" representing the
// client's request for the CreateCase operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateCase for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateCase method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateCaseRequest method.
//    req, resp := client.CreateCaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Support) CreateCaseRequest(input *CreateCaseInput) (req *request.Request, output *CreateCaseOutput) {
	op := &request.Operation{
		Name:       opCreateCase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCaseInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateCaseOutput{}
	req.Data = output
	return
}

// CreateCase API operation for AWS Support.
//
// Creates a new case in the AWS Support Center. This operation is modeled on
// the behavior of the AWS Support Center Create Case (https://console.aws.amazon.com/support/home#/case/create)
// page. Its parameters require you to specify the following information:
//
//    * issueType. The type of issue for the case. You can specify either "customer-service"
//    or "technical." If you do not indicate a value, the default is "technical."
//
//
//    * serviceCode. The code for an AWS service. You obtain the serviceCode
//    by calling DescribeServices.
//
//    * categoryCode. The category for the service defined for the serviceCode
//    value. You also obtain the category code for a service by calling DescribeServices.
//    Each AWS service defines its own set of category codes.
//
//    * severityCode. A value that indicates the urgency of the case, which
//    in turn determines the response time according to your service level agreement
//    with AWS Support. You obtain the SeverityCode by calling DescribeSeverityLevels.
//
//    * subject. The Subject field on the AWS Support Center Create Case (https://console.aws.amazon.com/support/home#/case/create)
//    page.
//
//    * communicationBody. The Description field on the AWS Support Center Create
//    Case (https://console.aws.amazon.com/support/home#/case/create) page.
//
//    * attachmentSetId. The ID of a set of attachments that has been created
//    by using AddAttachmentsToSet.
//
//    * language. The human language in which AWS Support handles the case.
//    English and Japanese are currently supported.
//
//    * ccEmailAddresses. The AWS Support Center CC field on the Create Case
//    (https://console.aws.amazon.com/support/home#/case/create) page. You can
//    list email addresses to be copied on any correspondence about the case.
//    The account that opens the case is already identified by passing the AWS
//    Credentials in the HTTP POST method or in a method or function call from
//    one of the programming languages supported by an AWS SDK (http://aws.amazon.com/tools/).
//
//
// To add additional communication or attachments to an existing case, use AddCommunicationToCase.
//
// A successful CreateCase request returns an AWS Support case number. Case
// numbers are used by the DescribeCases operation to retrieve existing AWS
// Support cases.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support's
// API operation CreateCase for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   An internal server error occurred.
//
//   * CaseCreationLimitExceeded
//   The case creation limit for the account has been exceeded.
//
//   * AttachmentSetIdNotFound
//   An attachment set with the specified ID could not be found.
//
//   * AttachmentSetExpired
//   The expiration time of the attachment set has passed. The set expires 1 hour
//   after it is created.
//
func (c *Support) CreateCase(input *CreateCaseInput) (*CreateCaseOutput, error) {
	req, out := c.CreateCaseRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeAttachment = "DescribeAttachment"

// DescribeAttachmentRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAttachment operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeAttachment for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeAttachment method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeAttachmentRequest method.
//    req, resp := client.DescribeAttachmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Support) DescribeAttachmentRequest(input *DescribeAttachmentInput) (req *request.Request, output *DescribeAttachmentOutput) {
	op := &request.Operation{
		Name:       opDescribeAttachment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAttachmentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAttachmentOutput{}
	req.Data = output
	return
}

// DescribeAttachment API operation for AWS Support.
//
// Returns the attachment that has the specified ID. Attachment IDs are generated
// by the case management system when you add an attachment to a case or case
// communication. Attachment IDs are returned in the AttachmentDetails objects
// that are returned by the DescribeCommunications operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support's
// API operation DescribeAttachment for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   An internal server error occurred.
//
//   * DescribeAttachmentLimitExceeded
//   The limit for the number of DescribeAttachment requests in a short period
//   of time has been exceeded.
//
//   * AttachmentIdNotFound
//   An attachment with the specified ID could not be found.
//
func (c *Support) DescribeAttachment(input *DescribeAttachmentInput) (*DescribeAttachmentOutput, error) {
	req, out := c.DescribeAttachmentRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeCases = "DescribeCases"

// DescribeCasesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCases operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeCases for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeCases method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeCasesRequest method.
//    req, resp := client.DescribeCasesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Support) DescribeCasesRequest(input *DescribeCasesInput) (req *request.Request, output *DescribeCasesOutput) {
	op := &request.Operation{
		Name:       opDescribeCases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCasesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeCasesOutput{}
	req.Data = output
	return
}

// DescribeCases API operation for AWS Support.
//
// Returns a list of cases that you specify by passing one or more case IDs.
// In addition, you can filter the cases by date by setting values for the afterTime
// and beforeTime request parameters. You can set values for the includeResolvedCases
// and includeCommunications request parameters to control how much information
// is returned.
//
// Case data is available for 12 months after creation. If a case was created
// more than 12 months ago, a request for data might cause an error.
//
// The response returns the following in JSON format:
//
//    * One or more CaseDetails data types.
//
//    * One or more nextToken values, which specify where to paginate the returned
//    records represented by the CaseDetails objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support's
// API operation DescribeCases for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   An internal server error occurred.
//
//   * CaseIdNotFound
//   The requested caseId could not be located.
//
func (c *Support) DescribeCases(input *DescribeCasesInput) (*DescribeCasesOutput, error) {
	req, out := c.DescribeCasesRequest(input)
	err := req.Send()
	return out, err
}

// DescribeCasesPages iterates over the pages of a DescribeCases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeCases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeCases operation.
//    pageNum := 0
//    err := client.DescribeCasesPages(params,
//        func(page *DescribeCasesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Support) DescribeCasesPages(input *DescribeCasesInput, fn func(p *DescribeCasesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeCasesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeCasesOutput), lastPage)
	})
}

const opDescribeCommunications = "DescribeCommunications"

// DescribeCommunicationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCommunications operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeCommunications for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeCommunications method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeCommunicationsRequest method.
//    req, resp := client.DescribeCommunicationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Support) DescribeCommunicationsRequest(input *DescribeCommunicationsInput) (req *request.Request, output *DescribeCommunicationsOutput) {
	op := &request.Operation{
		Name:       opDescribeCommunications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCommunicationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeCommunicationsOutput{}
	req.Data = output
	return
}

// DescribeCommunications API operation for AWS Support.
//
// Returns communications (and attachments) for one or more support cases. You
// can use the afterTime and beforeTime parameters to filter by date. You can
// use the caseId parameter to restrict the results to a particular case.
//
// Case data is available for 12 months after creation. If a case was created
// more than 12 months ago, a request for data might cause an error.
//
// You can use the maxResults and nextToken parameters to control the pagination
// of the result set. Set maxResults to the number of cases you want displayed
// on each page, and use nextToken to specify the resumption of pagination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support's
// API operation DescribeCommunications for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   An internal server error occurred.
//
//   * CaseIdNotFound
//   The requested caseId could not be located.
//
func (c *Support) DescribeCommunications(input *DescribeCommunicationsInput) (*DescribeCommunicationsOutput, error) {
	req, out := c.DescribeCommunicationsRequest(input)
	err := req.Send()
	return out, err
}

// DescribeCommunicationsPages iterates over the pages of a DescribeCommunications operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeCommunications method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeCommunications operation.
//    pageNum := 0
//    err := client.DescribeCommunicationsPages(params,
//        func(page *DescribeCommunicationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Support) DescribeCommunicationsPages(input *DescribeCommunicationsInput, fn func(p *DescribeCommunicationsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeCommunicationsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeCommunicationsOutput), lastPage)
	})
}

const opDescribeServices = "DescribeServices"

// DescribeServicesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeServices operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeServices for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeServices method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeServicesRequest method.
//    req, resp := client.DescribeServicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Support) DescribeServicesRequest(input *DescribeServicesInput) (req *request.Request, output *DescribeServicesOutput) {
	op := &request.Operation{
		Name:       opDescribeServices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeServicesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeServicesOutput{}
	req.Data = output
	return
}

// DescribeServices API operation for AWS Support.
//
// Returns the current list of AWS services and a list of service categories
// that applies to each one. You then use service names and categories in your
// CreateCase requests. Each AWS service has its own set of categories.
//
// The service codes and category codes correspond to the values that are displayed
// in the Service and Category drop-down lists on the AWS Support Center Create
// Case (https://console.aws.amazon.com/support/home#/case/create) page. The
// values in those fields, however, do not necessarily match the service codes
// and categories returned by the DescribeServices request. Always use the service
// codes and categories obtained programmatically. This practice ensures that
// you always have the most recent set of service and category codes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support's
// API operation DescribeServices for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   An internal server error occurred.
//
func (c *Support) DescribeServices(input *DescribeServicesInput) (*DescribeServicesOutput, error) {
	req, out := c.DescribeServicesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeSeverityLevels = "DescribeSeverityLevels"

// DescribeSeverityLevelsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSeverityLevels operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeSeverityLevels for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeSeverityLevels method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeSeverityLevelsRequest method.
//    req, resp := client.DescribeSeverityLevelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Support) DescribeSeverityLevelsRequest(input *DescribeSeverityLevelsInput) (req *request.Request, output *DescribeSeverityLevelsOutput) {
	op := &request.Operation{
		Name:       opDescribeSeverityLevels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSeverityLevelsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeSeverityLevelsOutput{}
	req.Data = output
	return
}

// DescribeSeverityLevels API operation for AWS Support.
//
// Returns the list of severity levels that you can assign to an AWS Support
// case. The severity level for a case is also a field in the CaseDetails data
// type included in any CreateCase request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support's
// API operation DescribeSeverityLevels for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   An internal server error occurred.
//
func (c *Support) DescribeSeverityLevels(input *DescribeSeverityLevelsInput) (*DescribeSeverityLevelsOutput, error) {
	req, out := c.DescribeSeverityLevelsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeTrustedAdvisorCheckRefreshStatuses = "DescribeTrustedAdvisorCheckRefreshStatuses"

// DescribeTrustedAdvisorCheckRefreshStatusesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTrustedAdvisorCheckRefreshStatuses operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeTrustedAdvisorCheckRefreshStatuses for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeTrustedAdvisorCheckRefreshStatuses method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeTrustedAdvisorCheckRefreshStatusesRequest method.
//    req, resp := client.DescribeTrustedAdvisorCheckRefreshStatusesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Support) DescribeTrustedAdvisorCheckRefreshStatusesRequest(input *DescribeTrustedAdvisorCheckRefreshStatusesInput) (req *request.Request, output *DescribeTrustedAdvisorCheckRefreshStatusesOutput) {
	op := &request.Operation{
		Name:       opDescribeTrustedAdvisorCheckRefreshStatuses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTrustedAdvisorCheckRefreshStatusesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeTrustedAdvisorCheckRefreshStatusesOutput{}
	req.Data = output
	return
}

// DescribeTrustedAdvisorCheckRefreshStatuses API operation for AWS Support.
//
// Returns the refresh status of the Trusted Advisor checks that have the specified
// check IDs. Check IDs can be obtained by calling DescribeTrustedAdvisorChecks.
//
// Some checks are refreshed automatically, and their refresh statuses cannot
// be retrieved by using this operation. Use of the DescribeTrustedAdvisorCheckRefreshStatuses
// operation for these checks causes an InvalidParameterValue error.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support's
// API operation DescribeTrustedAdvisorCheckRefreshStatuses for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   An internal server error occurred.
//
func (c *Support) DescribeTrustedAdvisorCheckRefreshStatuses(input *DescribeTrustedAdvisorCheckRefreshStatusesInput) (*DescribeTrustedAdvisorCheckRefreshStatusesOutput, error) {
	req, out := c.DescribeTrustedAdvisorCheckRefreshStatusesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeTrustedAdvisorCheckResult = "DescribeTrustedAdvisorCheckResult"

// DescribeTrustedAdvisorCheckResultRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTrustedAdvisorCheckResult operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeTrustedAdvisorCheckResult for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeTrustedAdvisorCheckResult method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeTrustedAdvisorCheckResultRequest method.
//    req, resp := client.DescribeTrustedAdvisorCheckResultRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Support) DescribeTrustedAdvisorCheckResultRequest(input *DescribeTrustedAdvisorCheckResultInput) (req *request.Request, output *DescribeTrustedAdvisorCheckResultOutput) {
	op := &request.Operation{
		Name:       opDescribeTrustedAdvisorCheckResult,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTrustedAdvisorCheckResultInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeTrustedAdvisorCheckResultOutput{}
	req.Data = output
	return
}

// DescribeTrustedAdvisorCheckResult API operation for AWS Support.
//
// Returns the results of the Trusted Advisor check that has the specified check
// ID. Check IDs can be obtained by calling DescribeTrustedAdvisorChecks.
//
// The response contains a TrustedAdvisorCheckResult object, which contains
// these three objects:
//
//    * TrustedAdvisorCategorySpecificSummary
//
//    * TrustedAdvisorResourceDetail
//
//    * TrustedAdvisorResourcesSummary
//
// In addition, the response contains these fields:
//
//    * status. The alert status of the check: "ok" (green), "warning" (yellow),
//    "error" (red), or "not_available".
//
//    * timestamp. The time of the last refresh of the check.
//
//    * checkId. The unique identifier for the check.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support's
// API operation DescribeTrustedAdvisorCheckResult for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   An internal server error occurred.
//
func (c *Support) DescribeTrustedAdvisorCheckResult(input *DescribeTrustedAdvisorCheckResultInput) (*DescribeTrustedAdvisorCheckResultOutput, error) {
	req, out := c.DescribeTrustedAdvisorCheckResultRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeTrustedAdvisorCheckSummaries = "DescribeTrustedAdvisorCheckSummaries"

// DescribeTrustedAdvisorCheckSummariesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTrustedAdvisorCheckSummaries operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeTrustedAdvisorCheckSummaries for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeTrustedAdvisorCheckSummaries method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeTrustedAdvisorCheckSummariesRequest method.
//    req, resp := client.DescribeTrustedAdvisorCheckSummariesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Support) DescribeTrustedAdvisorCheckSummariesRequest(input *DescribeTrustedAdvisorCheckSummariesInput) (req *request.Request, output *DescribeTrustedAdvisorCheckSummariesOutput) {
	op := &request.Operation{
		Name:       opDescribeTrustedAdvisorCheckSummaries,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTrustedAdvisorCheckSummariesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeTrustedAdvisorCheckSummariesOutput{}
	req.Data = output
	return
}

// DescribeTrustedAdvisorCheckSummaries API operation for AWS Support.
//
// Returns the summaries of the results of the Trusted Advisor checks that have
// the specified check IDs. Check IDs can be obtained by calling DescribeTrustedAdvisorChecks.
//
// The response contains an array of TrustedAdvisorCheckSummary objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support's
// API operation DescribeTrustedAdvisorCheckSummaries for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   An internal server error occurred.
//
func (c *Support) DescribeTrustedAdvisorCheckSummaries(input *DescribeTrustedAdvisorCheckSummariesInput) (*DescribeTrustedAdvisorCheckSummariesOutput, error) {
	req, out := c.DescribeTrustedAdvisorCheckSummariesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeTrustedAdvisorChecks = "DescribeTrustedAdvisorChecks"

// DescribeTrustedAdvisorChecksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTrustedAdvisorChecks operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeTrustedAdvisorChecks for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeTrustedAdvisorChecks method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeTrustedAdvisorChecksRequest method.
//    req, resp := client.DescribeTrustedAdvisorChecksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Support) DescribeTrustedAdvisorChecksRequest(input *DescribeTrustedAdvisorChecksInput) (req *request.Request, output *DescribeTrustedAdvisorChecksOutput) {
	op := &request.Operation{
		Name:       opDescribeTrustedAdvisorChecks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTrustedAdvisorChecksInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeTrustedAdvisorChecksOutput{}
	req.Data = output
	return
}

// DescribeTrustedAdvisorChecks API operation for AWS Support.
//
// Returns information about all available Trusted Advisor checks, including
// name, ID, category, description, and metadata. You must specify a language
// code; English ("en") and Japanese ("ja") are currently supported. The response
// contains a TrustedAdvisorCheckDescription for each check.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support's
// API operation DescribeTrustedAdvisorChecks for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   An internal server error occurred.
//
func (c *Support) DescribeTrustedAdvisorChecks(input *DescribeTrustedAdvisorChecksInput) (*DescribeTrustedAdvisorChecksOutput, error) {
	req, out := c.DescribeTrustedAdvisorChecksRequest(input)
	err := req.Send()
	return out, err
}

const opRefreshTrustedAdvisorCheck = "RefreshTrustedAdvisorCheck"

// RefreshTrustedAdvisorCheckRequest generates a "aws/request.Request" representing the
// client's request for the RefreshTrustedAdvisorCheck operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RefreshTrustedAdvisorCheck for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RefreshTrustedAdvisorCheck method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RefreshTrustedAdvisorCheckRequest method.
//    req, resp := client.RefreshTrustedAdvisorCheckRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Support) RefreshTrustedAdvisorCheckRequest(input *RefreshTrustedAdvisorCheckInput) (req *request.Request, output *RefreshTrustedAdvisorCheckOutput) {
	op := &request.Operation{
		Name:       opRefreshTrustedAdvisorCheck,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RefreshTrustedAdvisorCheckInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RefreshTrustedAdvisorCheckOutput{}
	req.Data = output
	return
}

// RefreshTrustedAdvisorCheck API operation for AWS Support.
//
// Requests a refresh of the Trusted Advisor check that has the specified check
// ID. Check IDs can be obtained by calling DescribeTrustedAdvisorChecks.
//
// Some checks are refreshed automatically, and they cannot be refreshed by
// using this operation. Use of the RefreshTrustedAdvisorCheck operation for
// these checks causes an InvalidParameterValue error.
//
// The response contains a TrustedAdvisorCheckRefreshStatus object, which contains
// these fields:
//
//    * status. The refresh status of the check: "none", "enqueued", "processing",
//    "success", or "abandoned".
//
//    * millisUntilNextRefreshable. The amount of time, in milliseconds, until
//    the check is eligible for refresh.
//
//    * checkId. The unique identifier for the check.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support's
// API operation RefreshTrustedAdvisorCheck for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   An internal server error occurred.
//
func (c *Support) RefreshTrustedAdvisorCheck(input *RefreshTrustedAdvisorCheckInput) (*RefreshTrustedAdvisorCheckOutput, error) {
	req, out := c.RefreshTrustedAdvisorCheckRequest(input)
	err := req.Send()
	return out, err
}

const opResolveCase = "ResolveCase"

// ResolveCaseRequest generates a "aws/request.Request" representing the
// client's request for the ResolveCase operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ResolveCase for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ResolveCase method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ResolveCaseRequest method.
//    req, resp := client.ResolveCaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Support) ResolveCaseRequest(input *ResolveCaseInput) (req *request.Request, output *ResolveCaseOutput) {
	op := &request.Operation{
		Name:       opResolveCase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResolveCaseInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ResolveCaseOutput{}
	req.Data = output
	return
}

// ResolveCase API operation for AWS Support.
//
// Takes a caseId and returns the initial state of the case along with the state
// of the case after the call to ResolveCase completed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support's
// API operation ResolveCase for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   An internal server error occurred.
//
//   * CaseIdNotFound
//   The requested caseId could not be located.
//
func (c *Support) ResolveCase(input *ResolveCaseInput) (*ResolveCaseOutput, error) {
	req, out := c.ResolveCaseRequest(input)
	err := req.Send()
	return out, err
}

type AddAttachmentsToSetInput struct {
	_ struct{} `type:"structure"`

	// The ID of the attachment set. If an attachmentSetId is not specified, a new
	// attachment set is created, and the ID of the set is returned in the response.
	// If an attachmentSetId is specified, the attachments are added to the specified
	// set, if it exists.
	AttachmentSetId *string `locationName:"attachmentSetId" type:"string"`

	// One or more attachments to add to the set. The limit is 3 attachments per
	// set, and the size limit is 5 MB per attachment.
	//
	// Attachments is a required field
	Attachments []*Attachment `locationName:"attachments" type:"list" required:"true"`
}

// String returns the string representation
func (s AddAttachmentsToSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddAttachmentsToSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddAttachmentsToSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddAttachmentsToSetInput"}
	if s.Attachments == nil {
		invalidParams.Add(request.NewErrParamRequired("Attachments"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The ID and expiry time of the attachment set returned by the AddAttachmentsToSet
// operation.
type AddAttachmentsToSetOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the attachment set. If an attachmentSetId was not specified, a
	// new attachment set is created, and the ID of the set is returned in the response.
	// If an attachmentSetId was specified, the attachments are added to the specified
	// set, if it exists.
	AttachmentSetId *string `locationName:"attachmentSetId" type:"string"`

	// The time and date when the attachment set expires.
	ExpiryTime *string `locationName:"expiryTime" type:"string"`
}

// String returns the string representation
func (s AddAttachmentsToSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddAttachmentsToSetOutput) GoString() string {
	return s.String()
}

// To be written.
type AddCommunicationToCaseInput struct {
	_ struct{} `type:"structure"`

	// The ID of a set of one or more attachments for the communication to add to
	// the case. Create the set by calling AddAttachmentsToSet
	AttachmentSetId *string `locationName:"attachmentSetId" type:"string"`

	// The AWS Support case ID requested or returned in the call. The case ID is
	// an alphanumeric string formatted as shown in this example: case-12345678910-2013-c4c1d2bf33c5cf47
	CaseId *string `locationName:"caseId" type:"string"`

	// The email addresses in the CC line of an email to be added to the support
	// case.
	CcEmailAddresses []*string `locationName:"ccEmailAddresses" type:"list"`

	// The body of an email communication to add to the support case.
	//
	// CommunicationBody is a required field
	CommunicationBody *string `locationName:"communicationBody" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AddCommunicationToCaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddCommunicationToCaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddCommunicationToCaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddCommunicationToCaseInput"}
	if s.CommunicationBody == nil {
		invalidParams.Add(request.NewErrParamRequired("CommunicationBody"))
	}
	if s.CommunicationBody != nil && len(*s.CommunicationBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CommunicationBody", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of the AddCommunicationToCase operation.
type AddCommunicationToCaseOutput struct {
	_ struct{} `type:"structure"`

	// True if AddCommunicationToCase succeeds. Otherwise, returns an error.
	Result *bool `locationName:"result" type:"boolean"`
}

// String returns the string representation
func (s AddCommunicationToCaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddCommunicationToCaseOutput) GoString() string {
	return s.String()
}

// An attachment to a case communication. The attachment consists of the file
// name and the content of the file.
type Attachment struct {
	_ struct{} `type:"structure"`

	// The content of the attachment file.
	//
	// Data is automatically base64 encoded/decoded by the SDK.
	Data []byte `locationName:"data" type:"blob"`

	// The name of the attachment file.
	FileName *string `locationName:"fileName" type:"string"`
}

// String returns the string representation
func (s Attachment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Attachment) GoString() string {
	return s.String()
}

// The file name and ID of an attachment to a case communication. You can use
// the ID to retrieve the attachment with the DescribeAttachment operation.
type AttachmentDetails struct {
	_ struct{} `type:"structure"`

	// The ID of the attachment.
	AttachmentId *string `locationName:"attachmentId" type:"string"`

	// The file name of the attachment.
	FileName *string `locationName:"fileName" type:"string"`
}

// String returns the string representation
func (s AttachmentDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachmentDetails) GoString() string {
	return s.String()
}

// A JSON-formatted object that contains the metadata for a support case. It
// is contained the response from a DescribeCases request. CaseDetails contains
// the following fields:
//
//    * caseId. The AWS Support case ID requested or returned in the call. The
//    case ID is an alphanumeric string formatted as shown in this example:
//    case-12345678910-2013-c4c1d2bf33c5cf47.
//
//    * categoryCode. The category of problem for the AWS Support case. Corresponds
//    to the CategoryCode values returned by a call to DescribeServices.
//
//    * displayId. The identifier for the case on pages in the AWS Support Center.
//
//    * language. The ISO 639-1 code for the language in which AWS provides
//    support. AWS Support currently supports English ("en") and Japanese ("ja").
//    Language parameters must be passed explicitly for operations that take
//    them.
//
//    * recentCommunications. One or more Communication objects. Fields of these
//    objects are attachments, body, caseId, submittedBy, and timeCreated.
//
//    * nextToken. A resumption point for pagination.
//
//    * serviceCode. The identifier for the AWS service that corresponds to
//    the service code defined in the call to DescribeServices.
//
//    * severityCode. The severity code assigned to the case. Contains one of
//    the values returned by the call to DescribeSeverityLevels.
//
//    * status. The status of the case in the AWS Support Center.
//
//    * subject. The subject line of the case.
//
//    * submittedBy. The email address of the account that submitted the case.
//
//    * timeCreated. The time the case was created, in ISO-8601 format.
type CaseDetails struct {
	_ struct{} `type:"structure"`

	// The AWS Support case ID requested or returned in the call. The case ID is
	// an alphanumeric string formatted as shown in this example: case-12345678910-2013-c4c1d2bf33c5cf47
	CaseId *string `locationName:"caseId" type:"string"`

	// The category of problem for the AWS Support case.
	CategoryCode *string `locationName:"categoryCode" type:"string"`

	// The email addresses that receive copies of communication about the case.
	CcEmailAddresses []*string `locationName:"ccEmailAddresses" type:"list"`

	// The ID displayed for the case in the AWS Support Center. This is a numeric
	// string.
	DisplayId *string `locationName:"displayId" type:"string"`

	// The ISO 639-1 code for the language in which AWS provides support. AWS Support
	// currently supports English ("en") and Japanese ("ja"). Language parameters
	// must be passed explicitly for operations that take them.
	Language *string `locationName:"language" type:"string"`

	// The five most recent communications between you and AWS Support Center, including
	// the IDs of any attachments to the communications. Also includes a nextToken
	// that you can use to retrieve earlier communications.
	RecentCommunications *RecentCaseCommunications `locationName:"recentCommunications" type:"structure"`

	// The code for the AWS service returned by the call to DescribeServices.
	ServiceCode *string `locationName:"serviceCode" type:"string"`

	// The code for the severity level returned by the call to DescribeSeverityLevels.
	SeverityCode *string `locationName:"severityCode" type:"string"`

	// The status of the case.
	Status *string `locationName:"status" type:"string"`

	// The subject line for the case in the AWS Support Center.
	Subject *string `locationName:"subject" type:"string"`

	// The email address of the account that submitted the case.
	SubmittedBy *string `locationName:"submittedBy" type:"string"`

	// The time that the case was case created in the AWS Support Center.
	TimeCreated *string `locationName:"timeCreated" type:"string"`
}

// String returns the string representation
func (s CaseDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CaseDetails) GoString() string {
	return s.String()
}

// A JSON-formatted name/value pair that represents the category name and category
// code of the problem, selected from the DescribeServices response for each
// AWS service.
type Category struct {
	_ struct{} `type:"structure"`

	// The category code for the support case.
	Code *string `locationName:"code" type:"string"`

	// The category name for the support case.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s Category) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Category) GoString() string {
	return s.String()
}

// A communication associated with an AWS Support case. The communication consists
// of the case ID, the message body, attachment information, the account email
// address, and the date and time of the communication.
type Communication struct {
	_ struct{} `type:"structure"`

	// Information about the attachments to the case communication.
	AttachmentSet []*AttachmentDetails `locationName:"attachmentSet" type:"list"`

	// The text of the communication between the customer and AWS Support.
	Body *string `locationName:"body" min:"1" type:"string"`

	// The AWS Support case ID requested or returned in the call. The case ID is
	// an alphanumeric string formatted as shown in this example: case-12345678910-2013-c4c1d2bf33c5cf47
	CaseId *string `locationName:"caseId" type:"string"`

	// The email address of the account that submitted the AWS Support case.
	SubmittedBy *string `locationName:"submittedBy" type:"string"`

	// The time the communication was created.
	TimeCreated *string `locationName:"timeCreated" type:"string"`
}

// String returns the string representation
func (s Communication) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Communication) GoString() string {
	return s.String()
}

type CreateCaseInput struct {
	_ struct{} `type:"structure"`

	// The ID of a set of one or more attachments for the case. Create the set by
	// using AddAttachmentsToSet.
	AttachmentSetId *string `locationName:"attachmentSetId" type:"string"`

	// The category of problem for the AWS Support case.
	CategoryCode *string `locationName:"categoryCode" type:"string"`

	// A list of email addresses that AWS Support copies on case correspondence.
	CcEmailAddresses []*string `locationName:"ccEmailAddresses" type:"list"`

	// The communication body text when you create an AWS Support case by calling
	// CreateCase.
	//
	// CommunicationBody is a required field
	CommunicationBody *string `locationName:"communicationBody" min:"1" type:"string" required:"true"`

	// The type of issue for the case. You can specify either "customer-service"
	// or "technical." If you do not indicate a value, the default is "technical."
	IssueType *string `locationName:"issueType" type:"string"`

	// The ISO 639-1 code for the language in which AWS provides support. AWS Support
	// currently supports English ("en") and Japanese ("ja"). Language parameters
	// must be passed explicitly for operations that take them.
	Language *string `locationName:"language" type:"string"`

	// The code for the AWS service returned by the call to DescribeServices.
	ServiceCode *string `locationName:"serviceCode" type:"string"`

	// The code for the severity level returned by the call to DescribeSeverityLevels.
	//
	// The availability of severity levels depends on each customer's support subscription.
	// In other words, your subscription may not necessarily require the urgent
	// level of response time.
	SeverityCode *string `locationName:"severityCode" type:"string"`

	// The title of the AWS Support case.
	//
	// Subject is a required field
	Subject *string `locationName:"subject" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateCaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCaseInput"}
	if s.CommunicationBody == nil {
		invalidParams.Add(request.NewErrParamRequired("CommunicationBody"))
	}
	if s.CommunicationBody != nil && len(*s.CommunicationBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CommunicationBody", 1))
	}
	if s.Subject == nil {
		invalidParams.Add(request.NewErrParamRequired("Subject"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The AWS Support case ID returned by a successful completion of the CreateCase
// operation.
type CreateCaseOutput struct {
	_ struct{} `type:"structure"`

	// The AWS Support case ID requested or returned in the call. The case ID is
	// an alphanumeric string formatted as shown in this example: case-12345678910-2013-c4c1d2bf33c5cf47
	CaseId *string `locationName:"caseId" type:"string"`
}

// String returns the string representation
func (s CreateCaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCaseOutput) GoString() string {
	return s.String()
}

type DescribeAttachmentInput struct {
	_ struct{} `type:"structure"`

	// The ID of the attachment to return. Attachment IDs are returned by the DescribeCommunications
	// operation.
	//
	// AttachmentId is a required field
	AttachmentId *string `locationName:"attachmentId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAttachmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAttachmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAttachmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAttachmentInput"}
	if s.AttachmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AttachmentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The content and file name of the attachment returned by the DescribeAttachment
// operation.
type DescribeAttachmentOutput struct {
	_ struct{} `type:"structure"`

	// The attachment content and file name.
	Attachment *Attachment `locationName:"attachment" type:"structure"`
}

// String returns the string representation
func (s DescribeAttachmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAttachmentOutput) GoString() string {
	return s.String()
}

type DescribeCasesInput struct {
	_ struct{} `type:"structure"`

	// The start date for a filtered date search on support case communications.
	// Case communications are available for 12 months after creation.
	AfterTime *string `locationName:"afterTime" type:"string"`

	// The end date for a filtered date search on support case communications. Case
	// communications are available for 12 months after creation.
	BeforeTime *string `locationName:"beforeTime" type:"string"`

	// A list of ID numbers of the support cases you want returned. The maximum
	// number of cases is 100.
	CaseIdList []*string `locationName:"caseIdList" type:"list"`

	// The ID displayed for a case in the AWS Support Center user interface.
	DisplayId *string `locationName:"displayId" type:"string"`

	// Specifies whether communications should be included in the DescribeCases
	// results. The default is true.
	IncludeCommunications *bool `locationName:"includeCommunications" type:"boolean"`

	// Specifies whether resolved support cases should be included in the DescribeCases
	// results. The default is false.
	IncludeResolvedCases *bool `locationName:"includeResolvedCases" type:"boolean"`

	// The ISO 639-1 code for the language in which AWS provides support. AWS Support
	// currently supports English ("en") and Japanese ("ja"). Language parameters
	// must be passed explicitly for operations that take them.
	Language *string `locationName:"language" type:"string"`

	// The maximum number of results to return before paginating.
	MaxResults *int64 `locationName:"maxResults" min:"10" type:"integer"`

	// A resumption point for pagination.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeCasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCasesInput"}
	if s.MaxResults != nil && *s.MaxResults < 10 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Returns an array of CaseDetails objects and a nextToken that defines a point
// for pagination in the result set.
type DescribeCasesOutput struct {
	_ struct{} `type:"structure"`

	// The details for the cases that match the request.
	Cases []*CaseDetails `locationName:"cases" type:"list"`

	// A resumption point for pagination.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeCasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCasesOutput) GoString() string {
	return s.String()
}

type DescribeCommunicationsInput struct {
	_ struct{} `type:"structure"`

	// The start date for a filtered date search on support case communications.
	// Case communications are available for 12 months after creation.
	AfterTime *string `locationName:"afterTime" type:"string"`

	// The end date for a filtered date search on support case communications. Case
	// communications are available for 12 months after creation.
	BeforeTime *string `locationName:"beforeTime" type:"string"`

	// The AWS Support case ID requested or returned in the call. The case ID is
	// an alphanumeric string formatted as shown in this example: case-12345678910-2013-c4c1d2bf33c5cf47
	//
	// CaseId is a required field
	CaseId *string `locationName:"caseId" type:"string" required:"true"`

	// The maximum number of results to return before paginating.
	MaxResults *int64 `locationName:"maxResults" min:"10" type:"integer"`

	// A resumption point for pagination.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeCommunicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCommunicationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCommunicationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCommunicationsInput"}
	if s.CaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("CaseId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 10 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The communications returned by the DescribeCommunications operation.
type DescribeCommunicationsOutput struct {
	_ struct{} `type:"structure"`

	// The communications for the case.
	Communications []*Communication `locationName:"communications" type:"list"`

	// A resumption point for pagination.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeCommunicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCommunicationsOutput) GoString() string {
	return s.String()
}

type DescribeServicesInput struct {
	_ struct{} `type:"structure"`

	// The ISO 639-1 code for the language in which AWS provides support. AWS Support
	// currently supports English ("en") and Japanese ("ja"). Language parameters
	// must be passed explicitly for operations that take them.
	Language *string `locationName:"language" type:"string"`

	// A JSON-formatted list of service codes available for AWS services.
	ServiceCodeList []*string `locationName:"serviceCodeList" type:"list"`
}

// String returns the string representation
func (s DescribeServicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeServicesInput) GoString() string {
	return s.String()
}

// The list of AWS services returned by the DescribeServices operation.
type DescribeServicesOutput struct {
	_ struct{} `type:"structure"`

	// A JSON-formatted list of AWS services.
	Services []*Service `locationName:"services" type:"list"`
}

// String returns the string representation
func (s DescribeServicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeServicesOutput) GoString() string {
	return s.String()
}

type DescribeSeverityLevelsInput struct {
	_ struct{} `type:"structure"`

	// The ISO 639-1 code for the language in which AWS provides support. AWS Support
	// currently supports English ("en") and Japanese ("ja"). Language parameters
	// must be passed explicitly for operations that take them.
	Language *string `locationName:"language" type:"string"`
}

// String returns the string representation
func (s DescribeSeverityLevelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSeverityLevelsInput) GoString() string {
	return s.String()
}

// The list of severity levels returned by the DescribeSeverityLevels operation.
type DescribeSeverityLevelsOutput struct {
	_ struct{} `type:"structure"`

	// The available severity levels for the support case. Available severity levels
	// are defined by your service level agreement with AWS.
	SeverityLevels []*SeverityLevel `locationName:"severityLevels" type:"list"`
}

// String returns the string representation
func (s DescribeSeverityLevelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSeverityLevelsOutput) GoString() string {
	return s.String()
}

type DescribeTrustedAdvisorCheckRefreshStatusesInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the Trusted Advisor checks to get the status of. Note: Specifying
	// the check ID of a check that is automatically refreshed causes an InvalidParameterValue
	// error.
	//
	// CheckIds is a required field
	CheckIds []*string `locationName:"checkIds" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeTrustedAdvisorCheckRefreshStatusesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrustedAdvisorCheckRefreshStatusesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTrustedAdvisorCheckRefreshStatusesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTrustedAdvisorCheckRefreshStatusesInput"}
	if s.CheckIds == nil {
		invalidParams.Add(request.NewErrParamRequired("CheckIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The statuses of the Trusted Advisor checks returned by the DescribeTrustedAdvisorCheckRefreshStatuses
// operation.
type DescribeTrustedAdvisorCheckRefreshStatusesOutput struct {
	_ struct{} `type:"structure"`

	// The refresh status of the specified Trusted Advisor checks.
	//
	// Statuses is a required field
	Statuses []*TrustedAdvisorCheckRefreshStatus `locationName:"statuses" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeTrustedAdvisorCheckRefreshStatusesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrustedAdvisorCheckRefreshStatusesOutput) GoString() string {
	return s.String()
}

type DescribeTrustedAdvisorCheckResultInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the Trusted Advisor check.
	//
	// CheckId is a required field
	CheckId *string `locationName:"checkId" type:"string" required:"true"`

	// The ISO 639-1 code for the language in which AWS provides support. AWS Support
	// currently supports English ("en") and Japanese ("ja"). Language parameters
	// must be passed explicitly for operations that take them.
	Language *string `locationName:"language" type:"string"`
}

// String returns the string representation
func (s DescribeTrustedAdvisorCheckResultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrustedAdvisorCheckResultInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTrustedAdvisorCheckResultInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTrustedAdvisorCheckResultInput"}
	if s.CheckId == nil {
		invalidParams.Add(request.NewErrParamRequired("CheckId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of the Trusted Advisor check returned by the DescribeTrustedAdvisorCheckResult
// operation.
type DescribeTrustedAdvisorCheckResultOutput struct {
	_ struct{} `type:"structure"`

	// The detailed results of the Trusted Advisor check.
	Result *TrustedAdvisorCheckResult `locationName:"result" type:"structure"`
}

// String returns the string representation
func (s DescribeTrustedAdvisorCheckResultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrustedAdvisorCheckResultOutput) GoString() string {
	return s.String()
}

type DescribeTrustedAdvisorCheckSummariesInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the Trusted Advisor checks.
	//
	// CheckIds is a required field
	CheckIds []*string `locationName:"checkIds" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeTrustedAdvisorCheckSummariesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrustedAdvisorCheckSummariesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTrustedAdvisorCheckSummariesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTrustedAdvisorCheckSummariesInput"}
	if s.CheckIds == nil {
		invalidParams.Add(request.NewErrParamRequired("CheckIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The summaries of the Trusted Advisor checks returned by the DescribeTrustedAdvisorCheckSummaries
// operation.
type DescribeTrustedAdvisorCheckSummariesOutput struct {
	_ struct{} `type:"structure"`

	// The summary information for the requested Trusted Advisor checks.
	//
	// Summaries is a required field
	Summaries []*TrustedAdvisorCheckSummary `locationName:"summaries" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeTrustedAdvisorCheckSummariesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrustedAdvisorCheckSummariesOutput) GoString() string {
	return s.String()
}

type DescribeTrustedAdvisorChecksInput struct {
	_ struct{} `type:"structure"`

	// The ISO 639-1 code for the language in which AWS provides support. AWS Support
	// currently supports English ("en") and Japanese ("ja"). Language parameters
	// must be passed explicitly for operations that take them.
	//
	// Language is a required field
	Language *string `locationName:"language" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTrustedAdvisorChecksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrustedAdvisorChecksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTrustedAdvisorChecksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTrustedAdvisorChecksInput"}
	if s.Language == nil {
		invalidParams.Add(request.NewErrParamRequired("Language"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about the Trusted Advisor checks returned by the DescribeTrustedAdvisorChecks
// operation.
type DescribeTrustedAdvisorChecksOutput struct {
	_ struct{} `type:"structure"`

	// Information about all available Trusted Advisor checks.
	//
	// Checks is a required field
	Checks []*TrustedAdvisorCheckDescription `locationName:"checks" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeTrustedAdvisorChecksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrustedAdvisorChecksOutput) GoString() string {
	return s.String()
}

// The five most recent communications associated with the case.
type RecentCaseCommunications struct {
	_ struct{} `type:"structure"`

	// The five most recent communications associated with the case.
	Communications []*Communication `locationName:"communications" type:"list"`

	// A resumption point for pagination.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s RecentCaseCommunications) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecentCaseCommunications) GoString() string {
	return s.String()
}

type RefreshTrustedAdvisorCheckInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the Trusted Advisor check to refresh. Note: Specifying
	// the check ID of a check that is automatically refreshed causes an InvalidParameterValue
	// error.
	//
	// CheckId is a required field
	CheckId *string `locationName:"checkId" type:"string" required:"true"`
}

// String returns the string representation
func (s RefreshTrustedAdvisorCheckInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RefreshTrustedAdvisorCheckInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RefreshTrustedAdvisorCheckInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RefreshTrustedAdvisorCheckInput"}
	if s.CheckId == nil {
		invalidParams.Add(request.NewErrParamRequired("CheckId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The current refresh status of a Trusted Advisor check.
type RefreshTrustedAdvisorCheckOutput struct {
	_ struct{} `type:"structure"`

	// The current refresh status for a check, including the amount of time until
	// the check is eligible for refresh.
	//
	// Status is a required field
	Status *TrustedAdvisorCheckRefreshStatus `locationName:"status" type:"structure" required:"true"`
}

// String returns the string representation
func (s RefreshTrustedAdvisorCheckOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RefreshTrustedAdvisorCheckOutput) GoString() string {
	return s.String()
}

type ResolveCaseInput struct {
	_ struct{} `type:"structure"`

	// The AWS Support case ID requested or returned in the call. The case ID is
	// an alphanumeric string formatted as shown in this example: case-12345678910-2013-c4c1d2bf33c5cf47
	CaseId *string `locationName:"caseId" type:"string"`
}

// String returns the string representation
func (s ResolveCaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResolveCaseInput) GoString() string {
	return s.String()
}

// The status of the case returned by the ResolveCase operation.
type ResolveCaseOutput struct {
	_ struct{} `type:"structure"`

	// The status of the case after the ResolveCase request was processed.
	FinalCaseStatus *string `locationName:"finalCaseStatus" type:"string"`

	// The status of the case when the ResolveCase request was sent.
	InitialCaseStatus *string `locationName:"initialCaseStatus" type:"string"`
}

// String returns the string representation
func (s ResolveCaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResolveCaseOutput) GoString() string {
	return s.String()
}

// Information about an AWS service returned by the DescribeServices operation.
type Service struct {
	_ struct{} `type:"structure"`

	// A list of categories that describe the type of support issue a case describes.
	// Categories consist of a category name and a category code. Category names
	// and codes are passed to AWS Support when you call CreateCase.
	Categories []*Category `locationName:"categories" type:"list"`

	// The code for an AWS service returned by the DescribeServices response. The
	// name element contains the corresponding friendly name.
	Code *string `locationName:"code" type:"string"`

	// The friendly name for an AWS service. The code element contains the corresponding
	// code.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s Service) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Service) GoString() string {
	return s.String()
}

// A code and name pair that represent a severity level that can be applied
// to a support case.
type SeverityLevel struct {
	_ struct{} `type:"structure"`

	// One of four values: "low," "medium," "high," and "urgent". These values correspond
	// to response times returned to the caller in severityLevel.name.
	Code *string `locationName:"code" type:"string"`

	// The name of the severity level that corresponds to the severity level code.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s SeverityLevel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SeverityLevel) GoString() string {
	return s.String()
}

// The container for summary information that relates to the category of the
// Trusted Advisor check.
type TrustedAdvisorCategorySpecificSummary struct {
	_ struct{} `type:"structure"`

	// The summary information about cost savings for a Trusted Advisor check that
	// is in the Cost Optimizing category.
	CostOptimizing *TrustedAdvisorCostOptimizingSummary `locationName:"costOptimizing" type:"structure"`
}

// String returns the string representation
func (s TrustedAdvisorCategorySpecificSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrustedAdvisorCategorySpecificSummary) GoString() string {
	return s.String()
}

// The description and metadata for a Trusted Advisor check.
type TrustedAdvisorCheckDescription struct {
	_ struct{} `type:"structure"`

	// The category of the Trusted Advisor check.
	//
	// Category is a required field
	Category *string `locationName:"category" type:"string" required:"true"`

	// The description of the Trusted Advisor check, which includes the alert criteria
	// and recommended actions (contains HTML markup).
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// The unique identifier for the Trusted Advisor check.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The column headings for the data returned by the Trusted Advisor check. The
	// order of the headings corresponds to the order of the data in the Metadata
	// element of the TrustedAdvisorResourceDetail for the check. Metadata contains
	// all the data that is shown in the Excel download, even in those cases where
	// the UI shows just summary data.
	//
	// Metadata is a required field
	Metadata []*string `locationName:"metadata" type:"list" required:"true"`

	// The display name for the Trusted Advisor check.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation
func (s TrustedAdvisorCheckDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrustedAdvisorCheckDescription) GoString() string {
	return s.String()
}

// The refresh status of a Trusted Advisor check.
type TrustedAdvisorCheckRefreshStatus struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the Trusted Advisor check.
	//
	// CheckId is a required field
	CheckId *string `locationName:"checkId" type:"string" required:"true"`

	// The amount of time, in milliseconds, until the Trusted Advisor check is eligible
	// for refresh.
	//
	// MillisUntilNextRefreshable is a required field
	MillisUntilNextRefreshable *int64 `locationName:"millisUntilNextRefreshable" type:"long" required:"true"`

	// The status of the Trusted Advisor check for which a refresh has been requested:
	// "none", "enqueued", "processing", "success", or "abandoned".
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true"`
}

// String returns the string representation
func (s TrustedAdvisorCheckRefreshStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrustedAdvisorCheckRefreshStatus) GoString() string {
	return s.String()
}

// The results of a Trusted Advisor check returned by DescribeTrustedAdvisorCheckResult.
type TrustedAdvisorCheckResult struct {
	_ struct{} `type:"structure"`

	// Summary information that relates to the category of the check. Cost Optimizing
	// is the only category that is currently supported.
	//
	// CategorySpecificSummary is a required field
	CategorySpecificSummary *TrustedAdvisorCategorySpecificSummary `locationName:"categorySpecificSummary" type:"structure" required:"true"`

	// The unique identifier for the Trusted Advisor check.
	//
	// CheckId is a required field
	CheckId *string `locationName:"checkId" type:"string" required:"true"`

	// The details about each resource listed in the check result.
	//
	// FlaggedResources is a required field
	FlaggedResources []*TrustedAdvisorResourceDetail `locationName:"flaggedResources" type:"list" required:"true"`

	// Details about AWS resources that were analyzed in a call to Trusted Advisor
	// DescribeTrustedAdvisorCheckSummaries.
	//
	// ResourcesSummary is a required field
	ResourcesSummary *TrustedAdvisorResourcesSummary `locationName:"resourcesSummary" type:"structure" required:"true"`

	// The alert status of the check: "ok" (green), "warning" (yellow), "error"
	// (red), or "not_available".
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true"`

	// The time of the last refresh of the check.
	//
	// Timestamp is a required field
	Timestamp *string `locationName:"timestamp" type:"string" required:"true"`
}

// String returns the string representation
func (s TrustedAdvisorCheckResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrustedAdvisorCheckResult) GoString() string {
	return s.String()
}

// A summary of a Trusted Advisor check result, including the alert status,
// last refresh, and number of resources examined.
type TrustedAdvisorCheckSummary struct {
	_ struct{} `type:"structure"`

	// Summary information that relates to the category of the check. Cost Optimizing
	// is the only category that is currently supported.
	//
	// CategorySpecificSummary is a required field
	CategorySpecificSummary *TrustedAdvisorCategorySpecificSummary `locationName:"categorySpecificSummary" type:"structure" required:"true"`

	// The unique identifier for the Trusted Advisor check.
	//
	// CheckId is a required field
	CheckId *string `locationName:"checkId" type:"string" required:"true"`

	// Specifies whether the Trusted Advisor check has flagged resources.
	HasFlaggedResources *bool `locationName:"hasFlaggedResources" type:"boolean"`

	// Details about AWS resources that were analyzed in a call to Trusted Advisor
	// DescribeTrustedAdvisorCheckSummaries.
	//
	// ResourcesSummary is a required field
	ResourcesSummary *TrustedAdvisorResourcesSummary `locationName:"resourcesSummary" type:"structure" required:"true"`

	// The alert status of the check: "ok" (green), "warning" (yellow), "error"
	// (red), or "not_available".
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true"`

	// The time of the last refresh of the check.
	//
	// Timestamp is a required field
	Timestamp *string `locationName:"timestamp" type:"string" required:"true"`
}

// String returns the string representation
func (s TrustedAdvisorCheckSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrustedAdvisorCheckSummary) GoString() string {
	return s.String()
}

// The estimated cost savings that might be realized if the recommended actions
// are taken.
type TrustedAdvisorCostOptimizingSummary struct {
	_ struct{} `type:"structure"`

	// The estimated monthly savings that might be realized if the recommended actions
	// are taken.
	//
	// EstimatedMonthlySavings is a required field
	EstimatedMonthlySavings *float64 `locationName:"estimatedMonthlySavings" type:"double" required:"true"`

	// The estimated percentage of savings that might be realized if the recommended
	// actions are taken.
	//
	// EstimatedPercentMonthlySavings is a required field
	EstimatedPercentMonthlySavings *float64 `locationName:"estimatedPercentMonthlySavings" type:"double" required:"true"`
}

// String returns the string representation
func (s TrustedAdvisorCostOptimizingSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrustedAdvisorCostOptimizingSummary) GoString() string {
	return s.String()
}

// Contains information about a resource identified by a Trusted Advisor check.
type TrustedAdvisorResourceDetail struct {
	_ struct{} `type:"structure"`

	// Specifies whether the AWS resource was ignored by Trusted Advisor because
	// it was marked as suppressed by the user.
	IsSuppressed *bool `locationName:"isSuppressed" type:"boolean"`

	// Additional information about the identified resource. The exact metadata
	// and its order can be obtained by inspecting the TrustedAdvisorCheckDescription
	// object returned by the call to DescribeTrustedAdvisorChecks. Metadata contains
	// all the data that is shown in the Excel download, even in those cases where
	// the UI shows just summary data.
	//
	// Metadata is a required field
	Metadata []*string `locationName:"metadata" type:"list" required:"true"`

	// The AWS region in which the identified resource is located.
	Region *string `locationName:"region" type:"string"`

	// The unique identifier for the identified resource.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The status code for the resource identified in the Trusted Advisor check.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true"`
}

// String returns the string representation
func (s TrustedAdvisorResourceDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrustedAdvisorResourceDetail) GoString() string {
	return s.String()
}

// Details about AWS resources that were analyzed in a call to Trusted Advisor
// DescribeTrustedAdvisorCheckSummaries.
type TrustedAdvisorResourcesSummary struct {
	_ struct{} `type:"structure"`

	// The number of AWS resources that were flagged (listed) by the Trusted Advisor
	// check.
	//
	// ResourcesFlagged is a required field
	ResourcesFlagged *int64 `locationName:"resourcesFlagged" type:"long" required:"true"`

	// The number of AWS resources ignored by Trusted Advisor because information
	// was unavailable.
	//
	// ResourcesIgnored is a required field
	ResourcesIgnored *int64 `locationName:"resourcesIgnored" type:"long" required:"true"`

	// The number of AWS resources that were analyzed by the Trusted Advisor check.
	//
	// ResourcesProcessed is a required field
	ResourcesProcessed *int64 `locationName:"resourcesProcessed" type:"long" required:"true"`

	// The number of AWS resources ignored by Trusted Advisor because they were
	// marked as suppressed by the user.
	//
	// ResourcesSuppressed is a required field
	ResourcesSuppressed *int64 `locationName:"resourcesSuppressed" type:"long" required:"true"`
}

// String returns the string representation
func (s TrustedAdvisorResourcesSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrustedAdvisorResourcesSummary) GoString() string {
	return s.String()
}
