// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package cloudwatch provides a client for Amazon CloudWatch.
package cloudwatch

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/query"
)

const opDeleteAlarms = "DeleteAlarms"

// DeleteAlarmsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAlarms operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteAlarms for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteAlarms method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteAlarmsRequest method.
//    req, resp := client.DeleteAlarmsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudWatch) DeleteAlarmsRequest(input *DeleteAlarmsInput) (req *request.Request, output *DeleteAlarmsOutput) {
	op := &request.Operation{
		Name:       opDeleteAlarms,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAlarmsInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteAlarmsOutput{}
	req.Data = output
	return
}

// DeleteAlarms API operation for Amazon CloudWatch.
//
// Deletes all specified alarms. In the event of an error, no alarms are deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation DeleteAlarms for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFound
//   The named resource does not exist.
//
func (c *CloudWatch) DeleteAlarms(input *DeleteAlarmsInput) (*DeleteAlarmsOutput, error) {
	req, out := c.DeleteAlarmsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeAlarmHistory = "DescribeAlarmHistory"

// DescribeAlarmHistoryRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAlarmHistory operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeAlarmHistory for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeAlarmHistory method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeAlarmHistoryRequest method.
//    req, resp := client.DescribeAlarmHistoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudWatch) DescribeAlarmHistoryRequest(input *DescribeAlarmHistoryInput) (req *request.Request, output *DescribeAlarmHistoryOutput) {
	op := &request.Operation{
		Name:       opDescribeAlarmHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAlarmHistoryInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAlarmHistoryOutput{}
	req.Data = output
	return
}

// DescribeAlarmHistory API operation for Amazon CloudWatch.
//
// Retrieves history for the specified alarm. Filter alarms by date range or
// item type. If an alarm name is not specified, Amazon CloudWatch returns histories
// for all of the owner's alarms.
//
// Amazon CloudWatch retains the history of an alarm for two weeks, whether
// or not you delete the alarm.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation DescribeAlarmHistory for usage and error information.
//
// Returned Error Codes:
//   * InvalidNextToken
//   The next token specified is invalid.
//
func (c *CloudWatch) DescribeAlarmHistory(input *DescribeAlarmHistoryInput) (*DescribeAlarmHistoryOutput, error) {
	req, out := c.DescribeAlarmHistoryRequest(input)
	err := req.Send()
	return out, err
}

// DescribeAlarmHistoryPages iterates over the pages of a DescribeAlarmHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAlarmHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeAlarmHistory operation.
//    pageNum := 0
//    err := client.DescribeAlarmHistoryPages(params,
//        func(page *DescribeAlarmHistoryOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudWatch) DescribeAlarmHistoryPages(input *DescribeAlarmHistoryInput, fn func(p *DescribeAlarmHistoryOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeAlarmHistoryRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeAlarmHistoryOutput), lastPage)
	})
}

const opDescribeAlarms = "DescribeAlarms"

// DescribeAlarmsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAlarms operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeAlarms for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeAlarms method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeAlarmsRequest method.
//    req, resp := client.DescribeAlarmsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudWatch) DescribeAlarmsRequest(input *DescribeAlarmsInput) (req *request.Request, output *DescribeAlarmsOutput) {
	op := &request.Operation{
		Name:       opDescribeAlarms,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAlarmsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAlarmsOutput{}
	req.Data = output
	return
}

// DescribeAlarms API operation for Amazon CloudWatch.
//
// Retrieves alarms with the specified names. If no name is specified, all alarms
// for the user are returned. Alarms can be retrieved by using only a prefix
// for the alarm name, the alarm state, or a prefix for any action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation DescribeAlarms for usage and error information.
//
// Returned Error Codes:
//   * InvalidNextToken
//   The next token specified is invalid.
//
func (c *CloudWatch) DescribeAlarms(input *DescribeAlarmsInput) (*DescribeAlarmsOutput, error) {
	req, out := c.DescribeAlarmsRequest(input)
	err := req.Send()
	return out, err
}

// DescribeAlarmsPages iterates over the pages of a DescribeAlarms operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAlarms method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeAlarms operation.
//    pageNum := 0
//    err := client.DescribeAlarmsPages(params,
//        func(page *DescribeAlarmsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudWatch) DescribeAlarmsPages(input *DescribeAlarmsInput, fn func(p *DescribeAlarmsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeAlarmsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeAlarmsOutput), lastPage)
	})
}

const opDescribeAlarmsForMetric = "DescribeAlarmsForMetric"

// DescribeAlarmsForMetricRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAlarmsForMetric operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeAlarmsForMetric for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeAlarmsForMetric method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeAlarmsForMetricRequest method.
//    req, resp := client.DescribeAlarmsForMetricRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudWatch) DescribeAlarmsForMetricRequest(input *DescribeAlarmsForMetricInput) (req *request.Request, output *DescribeAlarmsForMetricOutput) {
	op := &request.Operation{
		Name:       opDescribeAlarmsForMetric,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAlarmsForMetricInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAlarmsForMetricOutput{}
	req.Data = output
	return
}

// DescribeAlarmsForMetric API operation for Amazon CloudWatch.
//
// Retrieves all alarms for a single metric. Specify a statistic, period, or
// unit to filter the set of alarms further.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation DescribeAlarmsForMetric for usage and error information.
func (c *CloudWatch) DescribeAlarmsForMetric(input *DescribeAlarmsForMetricInput) (*DescribeAlarmsForMetricOutput, error) {
	req, out := c.DescribeAlarmsForMetricRequest(input)
	err := req.Send()
	return out, err
}

const opDisableAlarmActions = "DisableAlarmActions"

// DisableAlarmActionsRequest generates a "aws/request.Request" representing the
// client's request for the DisableAlarmActions operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DisableAlarmActions for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DisableAlarmActions method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DisableAlarmActionsRequest method.
//    req, resp := client.DisableAlarmActionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudWatch) DisableAlarmActionsRequest(input *DisableAlarmActionsInput) (req *request.Request, output *DisableAlarmActionsOutput) {
	op := &request.Operation{
		Name:       opDisableAlarmActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableAlarmActionsInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DisableAlarmActionsOutput{}
	req.Data = output
	return
}

// DisableAlarmActions API operation for Amazon CloudWatch.
//
// Disables actions for the specified alarms. When an alarm's actions are disabled
// the alarm's state may change, but none of the alarm's actions will execute.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation DisableAlarmActions for usage and error information.
func (c *CloudWatch) DisableAlarmActions(input *DisableAlarmActionsInput) (*DisableAlarmActionsOutput, error) {
	req, out := c.DisableAlarmActionsRequest(input)
	err := req.Send()
	return out, err
}

const opEnableAlarmActions = "EnableAlarmActions"

// EnableAlarmActionsRequest generates a "aws/request.Request" representing the
// client's request for the EnableAlarmActions operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See EnableAlarmActions for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the EnableAlarmActions method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the EnableAlarmActionsRequest method.
//    req, resp := client.EnableAlarmActionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudWatch) EnableAlarmActionsRequest(input *EnableAlarmActionsInput) (req *request.Request, output *EnableAlarmActionsOutput) {
	op := &request.Operation{
		Name:       opEnableAlarmActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableAlarmActionsInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &EnableAlarmActionsOutput{}
	req.Data = output
	return
}

// EnableAlarmActions API operation for Amazon CloudWatch.
//
// Enables actions for the specified alarms.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation EnableAlarmActions for usage and error information.
func (c *CloudWatch) EnableAlarmActions(input *EnableAlarmActionsInput) (*EnableAlarmActionsOutput, error) {
	req, out := c.EnableAlarmActionsRequest(input)
	err := req.Send()
	return out, err
}

const opGetMetricStatistics = "GetMetricStatistics"

// GetMetricStatisticsRequest generates a "aws/request.Request" representing the
// client's request for the GetMetricStatistics operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetMetricStatistics for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetMetricStatistics method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetMetricStatisticsRequest method.
//    req, resp := client.GetMetricStatisticsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudWatch) GetMetricStatisticsRequest(input *GetMetricStatisticsInput) (req *request.Request, output *GetMetricStatisticsOutput) {
	op := &request.Operation{
		Name:       opGetMetricStatistics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMetricStatisticsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetMetricStatisticsOutput{}
	req.Data = output
	return
}

// GetMetricStatistics API operation for Amazon CloudWatch.
//
// Gets statistics for the specified metric.
//
// The maximum number of data points that can be queried is 50,850, whereas
// the maximum number of data points returned from a single GetMetricStatistics
// request is 1,440. If you make a request that generates more than 1,440 data
// points, Amazon CloudWatch returns an error. In such a case, you can alter
// the request by narrowing the specified time range or increasing the specified
// period. A period can be as short as one minute (60 seconds) or as long as
// one day (86,400 seconds). Alternatively, you can make multiple requests across
// adjacent time ranges. GetMetricStatistics does not return the data in chronological
// order.
//
// Amazon CloudWatch aggregates data points based on the length of the period
// that you specify. For example, if you request statistics with a one-minute
// granularity, Amazon CloudWatch aggregates data points with time stamps that
// fall within the same one-minute period. In such a case, the data points queried
// can greatly outnumber the data points returned.
//
// The following examples show various statistics allowed by the data point
// query maximum of 50,850 when you call GetMetricStatistics on Amazon EC2 instances
// with detailed (one-minute) monitoring enabled:
//
//    * Statistics for up to 400 instances for a span of one hour
//
//    * Statistics for up to 35 instances over a span of 24 hours
//
//    * Statistics for up to 2 instances over a span of 2 weeks
//
// For information about the namespace, metric names, and dimensions that other
// Amazon Web Services products use to send metrics to CloudWatch, go to Amazon
// CloudWatch Metrics, Namespaces, and Dimensions Reference (http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html)
// in the Amazon CloudWatch Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation GetMetricStatistics for usage and error information.
//
// Returned Error Codes:
//   * InvalidParameterValue
//   Bad or out-of-range value was supplied for the input parameter.
//
//   * MissingParameter
//   An input parameter that is mandatory for processing the request is not supplied.
//
//   * InvalidParameterCombination
//   Parameters that must not be used together were used together.
//
//   * InternalServiceError
//   Indicates that the request processing has failed due to some unknown error,
//   exception, or failure.
//
func (c *CloudWatch) GetMetricStatistics(input *GetMetricStatisticsInput) (*GetMetricStatisticsOutput, error) {
	req, out := c.GetMetricStatisticsRequest(input)
	err := req.Send()
	return out, err
}

const opListMetrics = "ListMetrics"

// ListMetricsRequest generates a "aws/request.Request" representing the
// client's request for the ListMetrics operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListMetrics for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListMetrics method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListMetricsRequest method.
//    req, resp := client.ListMetricsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudWatch) ListMetricsRequest(input *ListMetricsInput) (req *request.Request, output *ListMetricsOutput) {
	op := &request.Operation{
		Name:       opListMetrics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMetricsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListMetricsOutput{}
	req.Data = output
	return
}

// ListMetrics API operation for Amazon CloudWatch.
//
// Returns a list of valid metrics stored for the AWS account owner. Returned
// metrics can be used with GetMetricStatistics to obtain statistical data for
// a given metric.
//
// Up to 500 results are returned for any one call. To retrieve further results,
// use returned NextToken values with subsequent ListMetrics operations.
//
// If you create a metric with PutMetricData, allow up to fifteen minutes for
// the metric to appear in calls to ListMetrics. Statistics about the metric,
// however, are available sooner using GetMetricStatistics.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation ListMetrics for usage and error information.
//
// Returned Error Codes:
//   * InternalServiceError
//   Indicates that the request processing has failed due to some unknown error,
//   exception, or failure.
//
//   * InvalidParameterValue
//   Bad or out-of-range value was supplied for the input parameter.
//
func (c *CloudWatch) ListMetrics(input *ListMetricsInput) (*ListMetricsOutput, error) {
	req, out := c.ListMetricsRequest(input)
	err := req.Send()
	return out, err
}

// ListMetricsPages iterates over the pages of a ListMetrics operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMetrics method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMetrics operation.
//    pageNum := 0
//    err := client.ListMetricsPages(params,
//        func(page *ListMetricsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudWatch) ListMetricsPages(input *ListMetricsInput, fn func(p *ListMetricsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListMetricsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListMetricsOutput), lastPage)
	})
}

const opPutMetricAlarm = "PutMetricAlarm"

// PutMetricAlarmRequest generates a "aws/request.Request" representing the
// client's request for the PutMetricAlarm operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutMetricAlarm for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutMetricAlarm method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutMetricAlarmRequest method.
//    req, resp := client.PutMetricAlarmRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudWatch) PutMetricAlarmRequest(input *PutMetricAlarmInput) (req *request.Request, output *PutMetricAlarmOutput) {
	op := &request.Operation{
		Name:       opPutMetricAlarm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutMetricAlarmInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &PutMetricAlarmOutput{}
	req.Data = output
	return
}

// PutMetricAlarm API operation for Amazon CloudWatch.
//
// Creates or updates an alarm and associates it with the specified Amazon CloudWatch
// metric. Optionally, this operation can associate one or more Amazon SNS resources
// with the alarm.
//
// When this operation creates an alarm, the alarm state is immediately set
// to INSUFFICIENT_DATA. The alarm is evaluated and its StateValue is set appropriately.
// Any actions associated with the StateValue are then executed.
//
// When updating an existing alarm, its StateValue is left unchanged, but it
// completely overwrites the alarm's previous configuration.
//
// If you are using an AWS Identity and Access Management (IAM) account to create
// or modify an alarm, you must have the following Amazon EC2 permissions:
//
// ec2:DescribeInstanceStatus and ec2:DescribeInstances for all alarms on Amazon
// EC2 instance status metrics.
//
// ec2:StopInstances for alarms with stop actions.
//
// ec2:TerminateInstances for alarms with terminate actions.
//
// ec2:DescribeInstanceRecoveryAttribute, and ec2:RecoverInstances for alarms
// with recover actions.
//
// If you have read/write permissions for Amazon CloudWatch but not for Amazon
// EC2, you can still create an alarm but the stop or terminate actions won't
// be performed on the Amazon EC2 instance. However, if you are later granted
// permission to use the associated Amazon EC2 APIs, the alarm actions you created
// earlier will be performed. For more information about IAM permissions, see
// Permissions and Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/PermissionsAndPolicies.html)
// in Using IAM.
//
// If you are using an IAM role (e.g., an Amazon EC2 instance profile), you
// cannot stop or terminate the instance using alarm actions. However, you can
// still see the alarm state and perform any other actions such as Amazon SNS
// notifications or Auto Scaling policies.
//
// If you are using temporary security credentials granted using the AWS Security
// Token Service (AWS STS), you cannot stop or terminate an Amazon EC2 instance
// using alarm actions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation PutMetricAlarm for usage and error information.
//
// Returned Error Codes:
//   * LimitExceeded
//   The quota for alarms for this customer has already been reached.
//
func (c *CloudWatch) PutMetricAlarm(input *PutMetricAlarmInput) (*PutMetricAlarmOutput, error) {
	req, out := c.PutMetricAlarmRequest(input)
	err := req.Send()
	return out, err
}

const opPutMetricData = "PutMetricData"

// PutMetricDataRequest generates a "aws/request.Request" representing the
// client's request for the PutMetricData operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutMetricData for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutMetricData method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutMetricDataRequest method.
//    req, resp := client.PutMetricDataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudWatch) PutMetricDataRequest(input *PutMetricDataInput) (req *request.Request, output *PutMetricDataOutput) {
	op := &request.Operation{
		Name:       opPutMetricData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutMetricDataInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &PutMetricDataOutput{}
	req.Data = output
	return
}

// PutMetricData API operation for Amazon CloudWatch.
//
// Publishes metric data points to Amazon CloudWatch. Amazon CloudWatch associates
// the data points with the specified metric. If the specified metric does not
// exist, Amazon CloudWatch creates the metric. When Amazon CloudWatch creates
// a metric, it can take up to fifteen minutes for the metric to appear in calls
// to ListMetrics.
//
// Each PutMetricData request is limited to 8 KB in size for HTTP GET requests
// and is limited to 40 KB in size for HTTP POST requests.
//
// Although the Value parameter accepts numbers of type Double, Amazon CloudWatch
// rejects values that are either too small or too large. Values must be in
// the range of 8.515920e-109 to 1.174271e+108 (Base 10) or 2e-360 to 2e360
// (Base 2). In addition, special values (e.g., NaN, +Infinity, -Infinity) are
// not supported.
//
// Data that is timestamped 24 hours or more in the past may take in excess
// of 48 hours to become available from submission time using GetMetricStatistics.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation PutMetricData for usage and error information.
//
// Returned Error Codes:
//   * InvalidParameterValue
//   Bad or out-of-range value was supplied for the input parameter.
//
//   * MissingParameter
//   An input parameter that is mandatory for processing the request is not supplied.
//
//   * InvalidParameterCombination
//   Parameters that must not be used together were used together.
//
//   * InternalServiceError
//   Indicates that the request processing has failed due to some unknown error,
//   exception, or failure.
//
func (c *CloudWatch) PutMetricData(input *PutMetricDataInput) (*PutMetricDataOutput, error) {
	req, out := c.PutMetricDataRequest(input)
	err := req.Send()
	return out, err
}

const opSetAlarmState = "SetAlarmState"

// SetAlarmStateRequest generates a "aws/request.Request" representing the
// client's request for the SetAlarmState operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SetAlarmState for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetAlarmState method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetAlarmStateRequest method.
//    req, resp := client.SetAlarmStateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudWatch) SetAlarmStateRequest(input *SetAlarmStateInput) (req *request.Request, output *SetAlarmStateOutput) {
	op := &request.Operation{
		Name:       opSetAlarmState,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetAlarmStateInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &SetAlarmStateOutput{}
	req.Data = output
	return
}

// SetAlarmState API operation for Amazon CloudWatch.
//
// Temporarily sets the state of an alarm for testing purposes. When the updated
// StateValue differs from the previous value, the action configured for the
// appropriate state is invoked. For example, if your alarm is configured to
// send an Amazon SNS message when an alarm is triggered, temporarily changing
// the alarm's state to ALARM sends an Amazon SNS message. The alarm returns
// to its actual state (often within seconds). Because the alarm state change
// happens very quickly, it is typically only visible in the alarm's History
// tab in the Amazon CloudWatch console or through DescribeAlarmHistory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation SetAlarmState for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFound
//   The named resource does not exist.
//
//   * InvalidFormat
//   Data was not syntactically valid JSON.
//
func (c *CloudWatch) SetAlarmState(input *SetAlarmStateInput) (*SetAlarmStateOutput, error) {
	req, out := c.SetAlarmStateRequest(input)
	err := req.Send()
	return out, err
}

// The AlarmHistoryItem data type contains descriptive information about the
// history of a specific alarm. If you call DescribeAlarmHistory, Amazon CloudWatch
// returns this data type as part of the DescribeAlarmHistoryResult data type.
type AlarmHistoryItem struct {
	_ struct{} `type:"structure"`

	// The descriptive name for the alarm.
	AlarmName *string `min:"1" type:"string"`

	// Machine-readable data about the alarm in JSON format.
	HistoryData *string `min:"1" type:"string"`

	// The type of alarm history item.
	HistoryItemType *string `type:"string" enum:"HistoryItemType"`

	// A human-readable summary of the alarm history.
	HistorySummary *string `min:"1" type:"string"`

	// The time stamp for the alarm history item.
	Timestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s AlarmHistoryItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AlarmHistoryItem) GoString() string {
	return s.String()
}

// The Datapoint data type encapsulates the statistical data that Amazon CloudWatch
// computes from metric data.
type Datapoint struct {
	_ struct{} `type:"structure"`

	// The average of metric values that correspond to the datapoint.
	Average *float64 `type:"double"`

	// The maximum of the metric value used for the datapoint.
	Maximum *float64 `type:"double"`

	// The minimum metric value used for the datapoint.
	Minimum *float64 `type:"double"`

	// The number of metric values that contributed to the aggregate value of this
	// datapoint.
	SampleCount *float64 `type:"double"`

	// The sum of metric values used for the datapoint.
	Sum *float64 `type:"double"`

	// The time stamp used for the datapoint.
	Timestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The standard unit used for the datapoint.
	Unit *string `type:"string" enum:"StandardUnit"`
}

// String returns the string representation
func (s Datapoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Datapoint) GoString() string {
	return s.String()
}

// Describes the inputs for DeleteAlarms.
type DeleteAlarmsInput struct {
	_ struct{} `type:"structure"`

	// A list of alarms to be deleted.
	//
	// AlarmNames is a required field
	AlarmNames []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteAlarmsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAlarmsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAlarmsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAlarmsInput"}
	if s.AlarmNames == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteAlarmsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAlarmsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAlarmsOutput) GoString() string {
	return s.String()
}

// Describes the inputs for DescribeAlarmHistory.
type DescribeAlarmHistoryInput struct {
	_ struct{} `type:"structure"`

	// The name of the alarm.
	AlarmName *string `min:"1" type:"string"`

	// The ending date to retrieve alarm history.
	EndDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The type of alarm histories to retrieve.
	HistoryItemType *string `type:"string" enum:"HistoryItemType"`

	// The maximum number of alarm history records to retrieve.
	MaxRecords *int64 `min:"1" type:"integer"`

	// The token returned by a previous call to indicate that there is more data
	// available.
	NextToken *string `type:"string"`

	// The starting date to retrieve alarm history.
	StartDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s DescribeAlarmHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAlarmHistoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAlarmHistoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAlarmHistoryInput"}
	if s.AlarmName != nil && len(*s.AlarmName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlarmName", 1))
	}
	if s.MaxRecords != nil && *s.MaxRecords < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxRecords", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output for DescribeAlarmHistory.
type DescribeAlarmHistoryOutput struct {
	_ struct{} `type:"structure"`

	// A list of alarm histories in JSON format.
	AlarmHistoryItems []*AlarmHistoryItem `type:"list"`

	// A string that marks the start of the next batch of returned results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAlarmHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAlarmHistoryOutput) GoString() string {
	return s.String()
}

// Describes the inputs for DescribeAlarmsForMetric.
type DescribeAlarmsForMetricInput struct {
	_ struct{} `type:"structure"`

	// The list of dimensions associated with the metric. If the metric has any
	// associated dimensions, you must specify them in order for the DescribeAlarmsForMetric
	// to succeed.
	Dimensions []*Dimension `type:"list"`

	// The name of the metric.
	//
	// MetricName is a required field
	MetricName *string `min:"1" type:"string" required:"true"`

	// The namespace of the metric.
	//
	// Namespace is a required field
	Namespace *string `min:"1" type:"string" required:"true"`

	// The period in seconds over which the statistic is applied.
	Period *int64 `min:"60" type:"integer"`

	// The statistic for the metric.
	Statistic *string `type:"string" enum:"Statistic"`

	// The unit for the metric.
	Unit *string `type:"string" enum:"StandardUnit"`
}

// String returns the string representation
func (s DescribeAlarmsForMetricInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAlarmsForMetricInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAlarmsForMetricInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAlarmsForMetricInput"}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricName", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Period != nil && *s.Period < 60 {
		invalidParams.Add(request.NewErrParamMinValue("Period", 60))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output for DescribeAlarmsForMetric.
type DescribeAlarmsForMetricOutput struct {
	_ struct{} `type:"structure"`

	// A list of information for each alarm with the specified metric.
	MetricAlarms []*MetricAlarm `type:"list"`
}

// String returns the string representation
func (s DescribeAlarmsForMetricOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAlarmsForMetricOutput) GoString() string {
	return s.String()
}

// Describes the inputs for DescribeAlarms.
type DescribeAlarmsInput struct {
	_ struct{} `type:"structure"`

	// The action name prefix.
	ActionPrefix *string `min:"1" type:"string"`

	// The alarm name prefix. AlarmNames cannot be specified if this parameter is
	// specified.
	AlarmNamePrefix *string `min:"1" type:"string"`

	// A list of alarm names to retrieve information for.
	AlarmNames []*string `type:"list"`

	// The maximum number of alarm descriptions to retrieve.
	MaxRecords *int64 `min:"1" type:"integer"`

	// The token returned by a previous call to indicate that there is more data
	// available.
	NextToken *string `type:"string"`

	// The state value to be used in matching alarms.
	StateValue *string `type:"string" enum:"StateValue"`
}

// String returns the string representation
func (s DescribeAlarmsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAlarmsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAlarmsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAlarmsInput"}
	if s.ActionPrefix != nil && len(*s.ActionPrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActionPrefix", 1))
	}
	if s.AlarmNamePrefix != nil && len(*s.AlarmNamePrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlarmNamePrefix", 1))
	}
	if s.MaxRecords != nil && *s.MaxRecords < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxRecords", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output for DescribeAlarms.
type DescribeAlarmsOutput struct {
	_ struct{} `type:"structure"`

	// A list of information for the specified alarms.
	MetricAlarms []*MetricAlarm `type:"list"`

	// A string that marks the start of the next batch of returned results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAlarmsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAlarmsOutput) GoString() string {
	return s.String()
}

// The Dimension data type further expands on the identity of a metric using
// a Name, Value pair.
//
// For examples that use one or more dimensions, see PutMetricData.
type Dimension struct {
	_ struct{} `type:"structure"`

	// The name of the dimension.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The value representing the dimension measurement
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Dimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Dimension) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Dimension) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Dimension"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The DimensionFilter data type is used to filter ListMetrics results.
type DimensionFilter struct {
	_ struct{} `type:"structure"`

	// The dimension name to be matched.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The value of the dimension to be matched.
	//
	// Specifying a Name without specifying a Value returns all values associated
	// with that Name.
	Value *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DimensionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DimensionFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DimensionFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DimensionFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DisableAlarmActionsInput struct {
	_ struct{} `type:"structure"`

	// The names of the alarms to disable actions for.
	//
	// AlarmNames is a required field
	AlarmNames []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DisableAlarmActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableAlarmActionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableAlarmActionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableAlarmActionsInput"}
	if s.AlarmNames == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DisableAlarmActionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableAlarmActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableAlarmActionsOutput) GoString() string {
	return s.String()
}

// Describes the inputs for EnableAlarmActions.
type EnableAlarmActionsInput struct {
	_ struct{} `type:"structure"`

	// The names of the alarms to enable actions for.
	//
	// AlarmNames is a required field
	AlarmNames []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s EnableAlarmActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableAlarmActionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableAlarmActionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableAlarmActionsInput"}
	if s.AlarmNames == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type EnableAlarmActionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableAlarmActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableAlarmActionsOutput) GoString() string {
	return s.String()
}

// Describes the inputs for GetMetricStatistics.
type GetMetricStatisticsInput struct {
	_ struct{} `type:"structure"`

	// A list of dimensions describing qualities of the metric.
	Dimensions []*Dimension `type:"list"`

	// The time stamp to use for determining the last datapoint to return. The value
	// specified is exclusive; results will include datapoints up to the time stamp
	// specified. The time stamp must be in ISO 8601 UTC format (e.g., 2014-09-03T23:00:00Z).
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The name of the metric, with or without spaces.
	//
	// MetricName is a required field
	MetricName *string `min:"1" type:"string" required:"true"`

	// The namespace of the metric, with or without spaces.
	//
	// Namespace is a required field
	Namespace *string `min:"1" type:"string" required:"true"`

	// The granularity, in seconds, of the returned datapoints. A Period can be
	// as short as one minute (60 seconds) or as long as one day (86,400 seconds),
	// and must be a multiple of 60. The default value is 60.
	//
	// Period is a required field
	Period *int64 `min:"60" type:"integer" required:"true"`

	// The time stamp to use for determining the first datapoint to return. The
	// value specified is inclusive; results include datapoints with the time stamp
	// specified. The time stamp must be in ISO 8601 UTC format (e.g., 2014-09-03T23:00:00Z).
	//
	// The specified start time is rounded down to the nearest value. Datapoints
	// are returned for start times up to two weeks in the past. Specified start
	// times that are more than two weeks in the past will not return datapoints
	// for metrics that are older than two weeks.
	//
	// Data that is timestamped 24 hours or more in the past may take in excess
	// of 48 hours to become available from submission time using GetMetricStatistics.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The metric statistics to return. For information about specific statistics
	// returned by GetMetricStatistics, see Statistics (http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#Statistic)
	// in the Amazon CloudWatch Developer Guide.
	//
	// Statistics is a required field
	Statistics []*string `min:"1" type:"list" required:"true"`

	// The specific unit for a given metric. Metrics may be reported in multiple
	// units. Not supplying a unit results in all units being returned. If the metric
	// only ever reports one unit, specifying a unit will have no effect.
	Unit *string `type:"string" enum:"StandardUnit"`
}

// String returns the string representation
func (s GetMetricStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMetricStatisticsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMetricStatisticsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMetricStatisticsInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricName", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Period == nil {
		invalidParams.Add(request.NewErrParamRequired("Period"))
	}
	if s.Period != nil && *s.Period < 60 {
		invalidParams.Add(request.NewErrParamMinValue("Period", 60))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}
	if s.Statistics == nil {
		invalidParams.Add(request.NewErrParamRequired("Statistics"))
	}
	if s.Statistics != nil && len(s.Statistics) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Statistics", 1))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output for GetMetricStatistics.
type GetMetricStatisticsOutput struct {
	_ struct{} `type:"structure"`

	// The datapoints for the specified metric.
	Datapoints []*Datapoint `type:"list"`

	// A label describing the specified metric.
	Label *string `type:"string"`
}

// String returns the string representation
func (s GetMetricStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMetricStatisticsOutput) GoString() string {
	return s.String()
}

// Describes the inputs for ListMetrics.
type ListMetricsInput struct {
	_ struct{} `type:"structure"`

	// A list of dimensions to filter against.
	Dimensions []*DimensionFilter `type:"list"`

	// The name of the metric to filter against.
	MetricName *string `min:"1" type:"string"`

	// The namespace to filter against.
	Namespace *string `min:"1" type:"string"`

	// The token returned by a previous call to indicate that there is more data
	// available.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListMetricsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMetricsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMetricsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMetricsInput"}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricName", 1))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output for ListMetrics.
type ListMetricsOutput struct {
	_ struct{} `type:"structure"`

	// A list of metrics used to generate statistics for an AWS account.
	Metrics []*Metric `type:"list"`

	// A string that marks the start of the next batch of returned results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListMetricsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMetricsOutput) GoString() string {
	return s.String()
}

// The Metric data type contains information about a specific metric. If you
// call ListMetrics, Amazon CloudWatch returns information contained by this
// data type.
//
// The example in the Examples section publishes two metrics named buffers and
// latency. Both metrics are in the examples namespace. Both metrics have two
// dimensions, InstanceID and InstanceType.
type Metric struct {
	_ struct{} `type:"structure"`

	// A list of dimensions associated with the metric.
	Dimensions []*Dimension `type:"list"`

	// The name of the metric.
	MetricName *string `min:"1" type:"string"`

	// The namespace of the metric.
	Namespace *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Metric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Metric) GoString() string {
	return s.String()
}

// The MetricAlarm data type represents an alarm. You can use PutMetricAlarm
// to create or update an alarm.
type MetricAlarm struct {
	_ struct{} `type:"structure"`

	// Indicates whether actions should be executed during any changes to the alarm's
	// state.
	ActionsEnabled *bool `type:"boolean"`

	// The list of actions to execute when this alarm transitions into an ALARM
	// state from any other state. Each action is specified as an Amazon Resource
	// Name (ARN).
	AlarmActions []*string `type:"list"`

	// The Amazon Resource Name (ARN) of the alarm.
	AlarmArn *string `min:"1" type:"string"`

	// The time stamp of the last update to the alarm configuration.
	AlarmConfigurationUpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The description for the alarm.
	AlarmDescription *string `type:"string"`

	// The name of the alarm.
	AlarmName *string `min:"1" type:"string"`

	// The arithmetic operation to use when comparing the specified Statistic and
	// Threshold. The specified Statistic value is used as the first operand.
	ComparisonOperator *string `type:"string" enum:"ComparisonOperator"`

	// The list of dimensions associated with the alarm's associated metric.
	Dimensions []*Dimension `type:"list"`

	// The number of periods over which data is compared to the specified threshold.
	EvaluationPeriods *int64 `min:"1" type:"integer"`

	// The list of actions to execute when this alarm transitions into an INSUFFICIENT_DATA
	// state from any other state. Each action is specified as an Amazon Resource
	// Name (ARN).
	//
	// The current WSDL lists this attribute as UnknownActions.
	InsufficientDataActions []*string `type:"list"`

	// The name of the alarm's metric.
	MetricName *string `min:"1" type:"string"`

	// The namespace of alarm's associated metric.
	Namespace *string `min:"1" type:"string"`

	// The list of actions to execute when this alarm transitions into an OK state
	// from any other state. Each action is specified as an Amazon Resource Name
	// (ARN).
	OKActions []*string `type:"list"`

	// The period in seconds over which the statistic is applied.
	Period *int64 `min:"60" type:"integer"`

	// A human-readable explanation for the alarm's state.
	StateReason *string `type:"string"`

	// An explanation for the alarm's state in machine-readable JSON format
	StateReasonData *string `type:"string"`

	// The time stamp of the last update to the alarm's state.
	StateUpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The state value for the alarm.
	StateValue *string `type:"string" enum:"StateValue"`

	// The statistic to apply to the alarm's associated metric.
	Statistic *string `type:"string" enum:"Statistic"`

	// The value against which the specified statistic is compared.
	Threshold *float64 `type:"double"`

	// The unit of the alarm's associated metric.
	Unit *string `type:"string" enum:"StandardUnit"`
}

// String returns the string representation
func (s MetricAlarm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricAlarm) GoString() string {
	return s.String()
}

// The MetricDatum data type encapsulates the information sent with PutMetricData
// to either create a new metric or add new values to be aggregated into an
// existing metric.
type MetricDatum struct {
	_ struct{} `type:"structure"`

	// A list of dimensions associated with the metric. Note, when using the Dimensions
	// value in a query, you need to append .member.N to it (e.g., Dimensions.member.N).
	Dimensions []*Dimension `type:"list"`

	// The name of the metric.
	//
	// MetricName is a required field
	MetricName *string `min:"1" type:"string" required:"true"`

	// A set of statistical values describing the metric.
	StatisticValues *StatisticSet `type:"structure"`

	// The time stamp used for the metric in ISO 8601 Universal Coordinated Time
	// (UTC) format. If not specified, the default value is set to the time the
	// metric data was received.
	Timestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The unit of the metric.
	Unit *string `type:"string" enum:"StandardUnit"`

	// The value for the metric.
	//
	// Although the Value parameter accepts numbers of type Double, Amazon CloudWatch
	// rejects values that are either too small or too large. Values must be in
	// the range of 8.515920e-109 to 1.174271e+108 (Base 10) or 2e-360 to 2e360
	// (Base 2). In addition, special values (e.g., NaN, +Infinity, -Infinity) are
	// not supported.
	Value *float64 `type:"double"`
}

// String returns the string representation
func (s MetricDatum) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricDatum) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricDatum) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricDatum"}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricName", 1))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.StatisticValues != nil {
		if err := s.StatisticValues.Validate(); err != nil {
			invalidParams.AddNested("StatisticValues", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the inputs for PutMetricAlarm.
type PutMetricAlarmInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether or not actions should be executed during any changes to
	// the alarm's state.
	ActionsEnabled *bool `type:"boolean"`

	// The list of actions to execute when this alarm transitions into an ALARM
	// state from any other state. Each action is specified as an Amazon Resource
	// Name (ARN).
	//
	// Valid Values: arn:aws:automate:region (e.g., us-east-1):ec2:stop | arn:aws:automate:region
	// (e.g., us-east-1):ec2:terminate | arn:aws:automate:region (e.g., us-east-1):ec2:recover
	//
	// Valid Values (for use with IAM roles): arn:aws:swf:us-east-1:{customer-account}:action/actions/AWS_EC2.InstanceId.Stop/1.0
	// | arn:aws:swf:us-east-1:{customer-account}:action/actions/AWS_EC2.InstanceId.Terminate/1.0
	// | arn:aws:swf:us-east-1:{customer-account}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
	//
	// Note: You must create at least one stop, terminate, or reboot alarm using
	// the Amazon EC2 or CloudWatch console to create the EC2ActionsAccess IAM role
	// for the first time. After this IAM role is created, you can create stop,
	// terminate, or reboot alarms using the CLI.
	AlarmActions []*string `type:"list"`

	// The description for the alarm.
	AlarmDescription *string `type:"string"`

	// The descriptive name for the alarm. This name must be unique within the user's
	// AWS account
	//
	// AlarmName is a required field
	AlarmName *string `min:"1" type:"string" required:"true"`

	// The arithmetic operation to use when comparing the specified Statistic and
	// Threshold. The specified Statistic value is used as the first operand.
	//
	// ComparisonOperator is a required field
	ComparisonOperator *string `type:"string" required:"true" enum:"ComparisonOperator"`

	// The dimensions for the alarm's associated metric.
	Dimensions []*Dimension `type:"list"`

	// The number of periods over which data is compared to the specified threshold.
	//
	// EvaluationPeriods is a required field
	EvaluationPeriods *int64 `min:"1" type:"integer" required:"true"`

	// The list of actions to execute when this alarm transitions into an INSUFFICIENT_DATA
	// state from any other state. Each action is specified as an Amazon Resource
	// Name (ARN).
	//
	// Valid Values: arn:aws:automate:region (e.g., us-east-1):ec2:stop | arn:aws:automate:region
	// (e.g., us-east-1):ec2:terminate | arn:aws:automate:region (e.g., us-east-1):ec2:recover
	//
	// Valid Values (for use with IAM roles): arn:aws:swf:us-east-1:{customer-account}:action/actions/AWS_EC2.InstanceId.Stop/1.0
	// | arn:aws:swf:us-east-1:{customer-account}:action/actions/AWS_EC2.InstanceId.Terminate/1.0
	// | arn:aws:swf:us-east-1:{customer-account}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
	//
	// Note: You must create at least one stop, terminate, or reboot alarm using
	// the Amazon EC2 or CloudWatch console to create the EC2ActionsAccess IAM role
	// for the first time. After this IAM role is created, you can create stop,
	// terminate, or reboot alarms using the CLI.
	InsufficientDataActions []*string `type:"list"`

	// The name for the alarm's associated metric.
	//
	// MetricName is a required field
	MetricName *string `min:"1" type:"string" required:"true"`

	// The namespace for the alarm's associated metric.
	//
	// Namespace is a required field
	Namespace *string `min:"1" type:"string" required:"true"`

	// The list of actions to execute when this alarm transitions into an OK state
	// from any other state. Each action is specified as an Amazon Resource Name
	// (ARN).
	//
	// Valid Values: arn:aws:automate:region (e.g., us-east-1):ec2:stop | arn:aws:automate:region
	// (e.g., us-east-1):ec2:terminate | arn:aws:automate:region (e.g., us-east-1):ec2:recover
	//
	// Valid Values (for use with IAM roles): arn:aws:swf:us-east-1:{customer-account}:action/actions/AWS_EC2.InstanceId.Stop/1.0
	// | arn:aws:swf:us-east-1:{customer-account}:action/actions/AWS_EC2.InstanceId.Terminate/1.0
	// | arn:aws:swf:us-east-1:{customer-account}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
	//
	// Note: You must create at least one stop, terminate, or reboot alarm using
	// the Amazon EC2 or CloudWatch console to create the EC2ActionsAccess IAM role
	// for the first time. After this IAM role is created, you can create stop,
	// terminate, or reboot alarms using the CLI.
	OKActions []*string `type:"list"`

	// The period in seconds over which the specified statistic is applied.
	//
	// Period is a required field
	Period *int64 `min:"60" type:"integer" required:"true"`

	// The statistic to apply to the alarm's associated metric.
	//
	// Statistic is a required field
	Statistic *string `type:"string" required:"true" enum:"Statistic"`

	// The value against which the specified statistic is compared.
	//
	// Threshold is a required field
	Threshold *float64 `type:"double" required:"true"`

	// The statistic's unit of measure. For example, the units for the Amazon EC2
	// NetworkIn metric are Bytes because NetworkIn tracks the number of bytes that
	// an instance receives on all network interfaces. You can also specify a unit
	// when you create a custom metric. Units help provide conceptual meaning to
	// your data. Metric data points that specify a unit of measure, such as Percent,
	// are aggregated separately.
	//
	// Note: If you specify a unit, you must use a unit that is appropriate for
	// the metric. Otherwise, this can cause an Amazon CloudWatch alarm to get stuck
	// in the INSUFFICIENT DATA state.
	Unit *string `type:"string" enum:"StandardUnit"`
}

// String returns the string representation
func (s PutMetricAlarmInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutMetricAlarmInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutMetricAlarmInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutMetricAlarmInput"}
	if s.AlarmName == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmName"))
	}
	if s.AlarmName != nil && len(*s.AlarmName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlarmName", 1))
	}
	if s.ComparisonOperator == nil {
		invalidParams.Add(request.NewErrParamRequired("ComparisonOperator"))
	}
	if s.EvaluationPeriods == nil {
		invalidParams.Add(request.NewErrParamRequired("EvaluationPeriods"))
	}
	if s.EvaluationPeriods != nil && *s.EvaluationPeriods < 1 {
		invalidParams.Add(request.NewErrParamMinValue("EvaluationPeriods", 1))
	}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricName", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Period == nil {
		invalidParams.Add(request.NewErrParamRequired("Period"))
	}
	if s.Period != nil && *s.Period < 60 {
		invalidParams.Add(request.NewErrParamMinValue("Period", 60))
	}
	if s.Statistic == nil {
		invalidParams.Add(request.NewErrParamRequired("Statistic"))
	}
	if s.Threshold == nil {
		invalidParams.Add(request.NewErrParamRequired("Threshold"))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutMetricAlarmOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutMetricAlarmOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutMetricAlarmOutput) GoString() string {
	return s.String()
}

// Describes the inputs for PutMetricData.
type PutMetricDataInput struct {
	_ struct{} `type:"structure"`

	// A list of data describing the metric.
	//
	// MetricData is a required field
	MetricData []*MetricDatum `type:"list" required:"true"`

	// The namespace for the metric data.
	//
	// You cannot specify a namespace that begins with "AWS/". Namespaces that begin
	// with "AWS/" are reserved for other Amazon Web Services products that send
	// metrics to Amazon CloudWatch.
	//
	// Namespace is a required field
	Namespace *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutMetricDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutMetricDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutMetricDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutMetricDataInput"}
	if s.MetricData == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricData"))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.MetricData != nil {
		for i, v := range s.MetricData {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MetricData", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutMetricDataOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutMetricDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutMetricDataOutput) GoString() string {
	return s.String()
}

// Describes the inputs for SetAlarmState.
type SetAlarmStateInput struct {
	_ struct{} `type:"structure"`

	// The descriptive name for the alarm. This name must be unique within the user's
	// AWS account. The maximum length is 255 characters.
	//
	// AlarmName is a required field
	AlarmName *string `min:"1" type:"string" required:"true"`

	// The reason that this alarm is set to this specific state (in human-readable
	// text format)
	//
	// StateReason is a required field
	StateReason *string `type:"string" required:"true"`

	// The reason that this alarm is set to this specific state (in machine-readable
	// JSON format)
	StateReasonData *string `type:"string"`

	// The value of the state.
	//
	// StateValue is a required field
	StateValue *string `type:"string" required:"true" enum:"StateValue"`
}

// String returns the string representation
func (s SetAlarmStateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetAlarmStateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetAlarmStateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetAlarmStateInput"}
	if s.AlarmName == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmName"))
	}
	if s.AlarmName != nil && len(*s.AlarmName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlarmName", 1))
	}
	if s.StateReason == nil {
		invalidParams.Add(request.NewErrParamRequired("StateReason"))
	}
	if s.StateValue == nil {
		invalidParams.Add(request.NewErrParamRequired("StateValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SetAlarmStateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetAlarmStateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetAlarmStateOutput) GoString() string {
	return s.String()
}

// The StatisticSet data type describes the StatisticValues component of MetricDatum,
// and represents a set of statistics that describes a specific metric.
type StatisticSet struct {
	_ struct{} `type:"structure"`

	// The maximum value of the sample set.
	//
	// Maximum is a required field
	Maximum *float64 `type:"double" required:"true"`

	// The minimum value of the sample set.
	//
	// Minimum is a required field
	Minimum *float64 `type:"double" required:"true"`

	// The number of samples used for the statistic set.
	//
	// SampleCount is a required field
	SampleCount *float64 `type:"double" required:"true"`

	// The sum of values for the sample set.
	//
	// Sum is a required field
	Sum *float64 `type:"double" required:"true"`
}

// String returns the string representation
func (s StatisticSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StatisticSet) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StatisticSet) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StatisticSet"}
	if s.Maximum == nil {
		invalidParams.Add(request.NewErrParamRequired("Maximum"))
	}
	if s.Minimum == nil {
		invalidParams.Add(request.NewErrParamRequired("Minimum"))
	}
	if s.SampleCount == nil {
		invalidParams.Add(request.NewErrParamRequired("SampleCount"))
	}
	if s.Sum == nil {
		invalidParams.Add(request.NewErrParamRequired("Sum"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

const (
	// ComparisonOperatorGreaterThanOrEqualToThreshold is a ComparisonOperator enum value
	ComparisonOperatorGreaterThanOrEqualToThreshold = "GreaterThanOrEqualToThreshold"

	// ComparisonOperatorGreaterThanThreshold is a ComparisonOperator enum value
	ComparisonOperatorGreaterThanThreshold = "GreaterThanThreshold"

	// ComparisonOperatorLessThanThreshold is a ComparisonOperator enum value
	ComparisonOperatorLessThanThreshold = "LessThanThreshold"

	// ComparisonOperatorLessThanOrEqualToThreshold is a ComparisonOperator enum value
	ComparisonOperatorLessThanOrEqualToThreshold = "LessThanOrEqualToThreshold"
)

const (
	// HistoryItemTypeConfigurationUpdate is a HistoryItemType enum value
	HistoryItemTypeConfigurationUpdate = "ConfigurationUpdate"

	// HistoryItemTypeStateUpdate is a HistoryItemType enum value
	HistoryItemTypeStateUpdate = "StateUpdate"

	// HistoryItemTypeAction is a HistoryItemType enum value
	HistoryItemTypeAction = "Action"
)

const (
	// StandardUnitSeconds is a StandardUnit enum value
	StandardUnitSeconds = "Seconds"

	// StandardUnitMicroseconds is a StandardUnit enum value
	StandardUnitMicroseconds = "Microseconds"

	// StandardUnitMilliseconds is a StandardUnit enum value
	StandardUnitMilliseconds = "Milliseconds"

	// StandardUnitBytes is a StandardUnit enum value
	StandardUnitBytes = "Bytes"

	// StandardUnitKilobytes is a StandardUnit enum value
	StandardUnitKilobytes = "Kilobytes"

	// StandardUnitMegabytes is a StandardUnit enum value
	StandardUnitMegabytes = "Megabytes"

	// StandardUnitGigabytes is a StandardUnit enum value
	StandardUnitGigabytes = "Gigabytes"

	// StandardUnitTerabytes is a StandardUnit enum value
	StandardUnitTerabytes = "Terabytes"

	// StandardUnitBits is a StandardUnit enum value
	StandardUnitBits = "Bits"

	// StandardUnitKilobits is a StandardUnit enum value
	StandardUnitKilobits = "Kilobits"

	// StandardUnitMegabits is a StandardUnit enum value
	StandardUnitMegabits = "Megabits"

	// StandardUnitGigabits is a StandardUnit enum value
	StandardUnitGigabits = "Gigabits"

	// StandardUnitTerabits is a StandardUnit enum value
	StandardUnitTerabits = "Terabits"

	// StandardUnitPercent is a StandardUnit enum value
	StandardUnitPercent = "Percent"

	// StandardUnitCount is a StandardUnit enum value
	StandardUnitCount = "Count"

	// StandardUnitBytesSecond is a StandardUnit enum value
	StandardUnitBytesSecond = "Bytes/Second"

	// StandardUnitKilobytesSecond is a StandardUnit enum value
	StandardUnitKilobytesSecond = "Kilobytes/Second"

	// StandardUnitMegabytesSecond is a StandardUnit enum value
	StandardUnitMegabytesSecond = "Megabytes/Second"

	// StandardUnitGigabytesSecond is a StandardUnit enum value
	StandardUnitGigabytesSecond = "Gigabytes/Second"

	// StandardUnitTerabytesSecond is a StandardUnit enum value
	StandardUnitTerabytesSecond = "Terabytes/Second"

	// StandardUnitBitsSecond is a StandardUnit enum value
	StandardUnitBitsSecond = "Bits/Second"

	// StandardUnitKilobitsSecond is a StandardUnit enum value
	StandardUnitKilobitsSecond = "Kilobits/Second"

	// StandardUnitMegabitsSecond is a StandardUnit enum value
	StandardUnitMegabitsSecond = "Megabits/Second"

	// StandardUnitGigabitsSecond is a StandardUnit enum value
	StandardUnitGigabitsSecond = "Gigabits/Second"

	// StandardUnitTerabitsSecond is a StandardUnit enum value
	StandardUnitTerabitsSecond = "Terabits/Second"

	// StandardUnitCountSecond is a StandardUnit enum value
	StandardUnitCountSecond = "Count/Second"

	// StandardUnitNone is a StandardUnit enum value
	StandardUnitNone = "None"
)

const (
	// StateValueOk is a StateValue enum value
	StateValueOk = "OK"

	// StateValueAlarm is a StateValue enum value
	StateValueAlarm = "ALARM"

	// StateValueInsufficientData is a StateValue enum value
	StateValueInsufficientData = "INSUFFICIENT_DATA"
)

const (
	// StatisticSampleCount is a Statistic enum value
	StatisticSampleCount = "SampleCount"

	// StatisticAverage is a Statistic enum value
	StatisticAverage = "Average"

	// StatisticSum is a Statistic enum value
	StatisticSum = "Sum"

	// StatisticMinimum is a Statistic enum value
	StatisticMinimum = "Minimum"

	// StatisticMaximum is a Statistic enum value
	StatisticMaximum = "Maximum"
)
